/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.store.Store;

public class EngineSearcher
extends Engine.Searcher {
    private final ReferenceManager<IndexSearcher> manager;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final Store store;
    private final Logger logger;

    public EngineSearcher(String source, IndexSearcher searcher, ReferenceManager<IndexSearcher> manager, Store store, Logger logger) {
        super(source, searcher);
        this.manager = manager;
        this.store = store;
        this.logger = logger;
    }

    @Override
    public void close() {
        if (!this.released.compareAndSet(false, true)) {
            this.logger.warn("Searcher was released twice", (Throwable)new IllegalStateException("Double release"));
            return;
        }
        try {
            this.manager.release((Object)this.searcher());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close", e);
        }
        catch (AlreadyClosedException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.store.decRef();
        }
    }
}

