/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import org.mockito.internal.debugging.Java8LocationImpl;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.invocation.Location;

public final class LocationFactory {
    private static final Factory factory = LocationFactory.createLocationFactory();

    private LocationFactory() {
    }

    public static Location create() {
        return LocationFactory.create(false);
    }

    public static Location create(boolean inline) {
        return factory.create(inline);
    }

    private static Factory createLocationFactory() {
        try {
            Class.forName("java.lang.StackWalker");
            return new DefaultLocationFactory();
        }
        catch (ClassNotFoundException e) {
            return new Java8LocationFactory();
        }
    }

    private static final class DefaultLocationFactory
    implements Factory {
        private DefaultLocationFactory() {
        }

        @Override
        public Location create(boolean inline) {
            return new LocationImpl(inline);
        }
    }

    private static final class Java8LocationFactory
    implements Factory {
        private Java8LocationFactory() {
        }

        @Override
        public Location create(boolean inline) {
            return new Java8LocationImpl(new Throwable(), inline);
        }
    }

    private static interface Factory {
        public Location create(boolean var1);
    }
}

