/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.config.AesCipher;
import org.sonar.api.config.Base64Cipher;
import org.sonar.api.config.Cipher;
import org.sonar.api.internal.google.common.collect.ImmutableMap;

public final class Encryption {
    private static final String BASE64_ALGORITHM = "b64";
    private static final String AES_ALGORITHM = "aes";
    private final AesCipher aesCipher;
    private final Map<String, Cipher> ciphers;
    private static final Pattern ENCRYPTED_PATTERN = Pattern.compile("\\{(.*?)\\}(.*)");

    public Encryption(@Nullable String pathToSecretKey) {
        this.aesCipher = new AesCipher(pathToSecretKey);
        this.ciphers = ImmutableMap.of(BASE64_ALGORITHM, new Base64Cipher(), AES_ALGORITHM, this.aesCipher);
    }

    public void setPathToSecretKey(@Nullable String pathToSecretKey) {
        this.aesCipher.setPathToSecretKey(pathToSecretKey);
    }

    public boolean hasSecretKey() {
        return this.aesCipher.hasSecretKey();
    }

    public boolean isEncrypted(String value) {
        return value.indexOf(123) == 0 && value.indexOf(125) > 1;
    }

    public String encrypt(String clearText) {
        return this.encrypt(AES_ALGORITHM, clearText);
    }

    public String scramble(String clearText) {
        return this.encrypt(BASE64_ALGORITHM, clearText);
    }

    public String generateRandomSecretKey() {
        return this.aesCipher.generateRandomSecretKey();
    }

    public String decrypt(String encryptedText) {
        Cipher cipher;
        Matcher matcher = ENCRYPTED_PATTERN.matcher(encryptedText);
        if (matcher.matches() && (cipher = this.ciphers.get(matcher.group(1).toLowerCase(Locale.ENGLISH))) != null) {
            return cipher.decrypt(matcher.group(2));
        }
        return encryptedText;
    }

    private String encrypt(String algorithm, String clearText) {
        Cipher cipher = this.ciphers.get(algorithm);
        if (cipher == null) {
            throw new IllegalArgumentException("Unknown cipher algorithm: " + algorithm);
        }
        return String.format("{%s}%s", algorithm, cipher.encrypt(clearText));
    }
}

