/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Can be used to list the reverse proxy routes")
@ConfigurationProperties(prefix="endpoints.routes")
public class RoutesEndpoint
extends AbstractEndpoint<Map<String, String>> {
    private static final String ID = "routes";
    private RouteLocator routes;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RoutesEndpoint(RouteLocator routes) {
        super(ID, true);
        this.routes = routes;
    }

    @ManagedAttribute
    public Map<String, String> invoke() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Route route : this.routes.getRoutes()) {
            map.put(route.getFullPath(), route.getLocation());
        }
        return map;
    }
}

