/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.IndexAlreadyExistsException;
import org.apache.hadoop.hive.service.HiveServerException;
import org.apache.hadoop.io.IOUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.hadoop.hive.HiveClient;
import org.springframework.data.hadoop.hive.HiveScript;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class HiveUtils {
    HiveUtils() {
    }

    static DataAccessException convert(Exception ex) {
        if (ex == null) {
            return null;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof HiveServerException) {
            return HiveUtils.convert((HiveServerException)ex);
        }
        if (ex instanceof TException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TBase) {
            if (ex instanceof AlreadyExistsException || ex instanceof IndexAlreadyExistsException) {
                return new DataIntegrityViolationException(ex.toString(), (Throwable)ex);
            }
            if (ex instanceof ConfigValSecurityException) {
                return new PermissionDeniedDataAccessException(ex.toString(), (Throwable)ex);
            }
            return new InvalidDataAccessResourceUsageException(ex.toString(), (Throwable)ex);
        }
        return new NonTransientDataAccessResourceException("Unknown exception", (Throwable)ex);
    }

    private static DataAccessException convert(HiveServerException ex) {
        int err = ex.getErrorCode();
        String sqlState = ex.getSQLState();
        String cause = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
        switch (err) {
            case 10: {
                return new DataRetrievalFailureException(cause, (Throwable)ex);
            }
            case 11: {
                return new BadSqlGrammarException("Hive query", "", new SQLException(cause, sqlState));
            }
            case 12: {
                return new NonTransientDataAccessResourceException(cause, (Throwable)ex);
            }
            case -10000: {
                return new NonTransientDataAccessResourceException(cause, (Throwable)ex);
            }
        }
        if ("08S01".equals(sqlState)) {
            return new NonTransientDataAccessResourceException(cause, (Throwable)ex);
        }
        if ("42000".equals(sqlState)) {
            return new BadSqlGrammarException("Hive query", "", new SQLException(cause, sqlState));
        }
        if ("42S02".equals(sqlState)) {
            return new InvalidDataAccessResourceUsageException(cause, (Throwable)ex);
        }
        if ("21000".equals(sqlState)) {
            return new BadSqlGrammarException("Hive query", "", new SQLException(cause, sqlState));
        }
        if (err >= 10000 && err <= 19999) {
            return new InvalidDataAccessResourceUsageException(cause, (Throwable)ex);
        }
        if (err >= 20000 && err <= 29999) {
            return new DataRetrievalFailureException(cause, (Throwable)ex);
        }
        if (err >= 30000 && err <= 39999) {
            return new TransientDataAccessResourceException(cause, (Throwable)ex);
        }
        if (err >= 40000 && err <= 49999) {
            return new NonTransientDataAccessResourceException(cause, (Throwable)ex);
        }
        return new NonTransientDataAccessResourceException(cause, (Throwable)ex);
    }

    static List<String> run(HiveClient hive, Iterable<HiveScript> scripts) throws Exception {
        Assert.notNull(scripts, (String)"at least one script is required");
        ArrayList<String> results = new ArrayList<String>();
        for (HiveScript hiveScript : scripts) {
            results.addAll(HiveUtils.run(hive, hiveScript));
        }
        return results;
    }

    static List<String> runWithConversion(HiveClient hive, Iterable<HiveScript> scripts, boolean closeHive) throws DataAccessException {
        try {
            List<String> list = HiveUtils.run(hive, scripts);
            return list;
        }
        catch (Exception ex) {
            throw HiveUtils.convert(ex);
        }
        finally {
            try {
                if (closeHive) {
                    hive.shutdown();
                }
            }
            catch (Exception ex) {
                throw new InvalidDataAccessResourceUsageException("Error while closing client connection", (Throwable)ex);
            }
        }
    }

    private static List<String> run(HiveClient hive, HiveScript script) throws Exception {
        BufferedReader reader;
        try {
            InputStream stream = script.getResource().getInputStream();
            reader = new BufferedReader(new InputStreamReader(stream));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot open script [" + script.getResource() + "]", ex);
        }
        ArrayList<String> results = new ArrayList<String>();
        Map<String, String> params = script.getArguments();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                results.addAll(HiveUtils.runCommand(hive, "SET hiveconf:" + entry.getKey() + "=" + entry.getValue()));
            }
        }
        String line = null;
        try {
            String command = "";
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("--")) continue;
                int nrCmds = StringUtils.countOccurrencesOf((String)line, (String)";");
                for (String token : line.split(";")) {
                    if (!StringUtils.hasText((String)(token = token.trim()))) continue;
                    command = command + token.concat(" ");
                    if (nrCmds <= 0) continue;
                    results.addAll(HiveUtils.runCommand(hive, command));
                    --nrCmds;
                    command = "";
                }
            }
            if (StringUtils.hasText((String)command)) {
                results.addAll(HiveUtils.runCommand(hive, command));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot read scripts", ex);
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
        return results;
    }

    private static List<String> runCommand(HiveClient hive, String command) throws Exception {
        return hive.execute(command);
    }
}

