/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import org.openqa.selenium.Keys;

class KeyboardModifiersState {
    private boolean shiftPressed = false;
    private boolean ctrlPressed = false;
    private boolean altPressed = false;

    KeyboardModifiersState() {
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed;
    }

    public boolean isAltPressed() {
        return this.altPressed;
    }

    public void storeKeyDown(CharSequence key) {
        this.storeIfEqualsShift(key, true);
        this.storeIfEqualsCtrl(key, true);
        this.storeIfEqualsAlt(key, true);
    }

    public void storeKeyUp(CharSequence key) {
        this.storeIfEqualsShift(key, false);
        this.storeIfEqualsCtrl(key, false);
        this.storeIfEqualsAlt(key, false);
    }

    private void storeIfEqualsShift(CharSequence key, boolean keyState) {
        if (key.equals(Keys.SHIFT)) {
            this.shiftPressed = keyState;
        }
    }

    private void storeIfEqualsCtrl(CharSequence key, boolean keyState) {
        if (key.equals(Keys.CONTROL)) {
            this.ctrlPressed = keyState;
        }
    }

    private void storeIfEqualsAlt(CharSequence key, boolean keyState) {
        if (key.equals(Keys.ALT)) {
            this.altPressed = keyState;
        }
    }
}

