/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.net.InetAddress;

public class INetAddress {
    private final String hostName;
    private final String hostAddress;
    private final boolean loopbackAddress;

    public INetAddress(InetAddress inetAddress) {
        this.hostName = inetAddress.getHostName();
        this.hostAddress = inetAddress.getHostAddress();
        this.loopbackAddress = inetAddress.isLoopbackAddress();
    }

    INetAddress(String hostName, String hostAddress, boolean loopbackAddress) {
        this.hostName = hostName;
        this.hostAddress = hostAddress;
        this.loopbackAddress = loopbackAddress;
    }

    public boolean isLoopbackAddress() {
        return this.loopbackAddress;
    }

    public boolean isIPv6Address() {
        return this.hostAddress.indexOf(":") != -1;
    }

    public boolean isIPv4Address() {
        return !this.isIPv6Address();
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getHostName() {
        return this.hostName;
    }
}

