/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.jetty.http.handler.ResourceHandler;
import org.openqa.jetty.util.Resource;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.SessionExtensionJsResource;

class SessionExtensionJsHandler
extends ResourceHandler {
    public static final Pattern PATH_PATTERN = Pattern.compile("user-extensions.js\\[([0-9a-f]{32})\\]$");

    SessionExtensionJsHandler() {
    }

    @Override
    public Resource getResource(String pathInContext) throws MalformedURLException {
        String sessionId = this.getSessionId(pathInContext);
        if (sessionId != null) {
            String extensionJs = FrameGroupCommandQueueSet.getQueueSet(sessionId).getExtensionJs();
            SessionExtensionJsResource resource = new SessionExtensionJsResource(extensionJs);
            this.getHttpContext().getResourceMetaData(resource);
            return resource;
        }
        return null;
    }

    private String getSessionId(String pathInContext) {
        Matcher m = PATH_PATTERN.matcher(pathInContext);
        return m.find() ? m.group(1) : null;
    }
}

