/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.WebDriverCommandProcessor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverServlet;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.Session;

public class WebDriverBackedSeleniumServlet
extends HttpServlet {
    private static final Random UUID_SEED = new Random();
    static Cache<SessionId, CommandProcessor> SESSIONS = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<SessionId, CommandProcessor>(){

        public void onRemoval(RemovalNotification<SessionId, CommandProcessor> notification) {
            CommandProcessor holder = (CommandProcessor)notification.getValue();
            if (holder != null) {
                try {
                    holder.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }).build();
    private final ImmutableMap<String, DesiredCapabilities> drivers = ImmutableMap.builder().put((Object)"*firefoxproxy", (Object)DesiredCapabilities.firefox()).put((Object)"*firefox", (Object)DesiredCapabilities.firefox()).put((Object)"*chrome", (Object)DesiredCapabilities.firefox()).put((Object)"*firefoxchrome", (Object)DesiredCapabilities.firefox()).put((Object)"*iexploreproxy", (Object)DesiredCapabilities.internetExplorer()).put((Object)"*safari", (Object)DesiredCapabilities.safari()).put((Object)"*iehta", (Object)DesiredCapabilities.internetExplorer()).put((Object)"*iexplore", (Object)DesiredCapabilities.internetExplorer()).put((Object)"*googlechrome", (Object)DesiredCapabilities.chrome()).build();
    private final Supplier<DriverSessions> sessionsSupplier = new Supplier<DriverSessions>(){

        public DriverSessions get() {
            Object attribute = WebDriverBackedSeleniumServlet.this.getServletContext().getAttribute(DriverServlet.SESSIONS_KEY);
            if (attribute == null) {
                attribute = new DefaultDriverSessions();
            }
            return (DriverSessions)attribute;
        }
    };

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cmd = req.getParameter("cmd");
        SessionId sessionId = new SessionId(req.getParameter("sessionId"));
        Object[] args = this.deserializeArgs(req);
        if (cmd == null) {
            resp.sendError(404);
            return;
        }
        StringBuilder printableArgs = new StringBuilder("[");
        Joiner.on((String)", ").appendTo(printableArgs, args);
        printableArgs.append("]");
        this.getServletContext().log(String.format("Command request: %s%s on session %s", cmd, printableArgs, sessionId));
        if ("getNewBrowserSession".equals(cmd)) {
            DesiredCapabilities capabilities = new DesiredCapabilities((Capabilities)this.drivers.get(args[0]));
            try {
                sessionId = ((DriverSessions)this.sessionsSupplier.get()).newSession((Capabilities)capabilities);
                Session session = ((DriverSessions)this.sessionsSupplier.get()).get(sessionId);
                WebDriver driver = session.getDriver();
                WebDriverCommandProcessor commandProcessor = new WebDriverCommandProcessor((String)args[1], driver);
                SESSIONS.put((Object)sessionId, (Object)commandProcessor);
                this.sendResponse(resp, sessionId.toString());
            }
            catch (Exception e) {
                this.sendError(resp, "Unable to create session: " + e.getMessage());
            }
            return;
        }
        if ("testComplete".equals(cmd)) {
            ((DriverSessions)this.sessionsSupplier.get()).deleteSession(sessionId);
            CommandProcessor commandProcessor = (CommandProcessor)SESSIONS.getIfPresent((Object)sessionId);
            if (commandProcessor == null) {
                resp.sendError(404);
                return;
            }
            SESSIONS.invalidate((Object)sessionId);
            this.sendResponse(resp, null);
            return;
        }
        CommandProcessor commandProcessor = (CommandProcessor)SESSIONS.getIfPresent((Object)sessionId);
        if (commandProcessor == null) {
            resp.sendError(404);
            return;
        }
        try {
            String result = commandProcessor.doCommand(cmd, (String[])args);
            this.sendResponse(resp, result);
        }
        catch (SeleniumException e) {
            this.sendError(resp, e.getMessage());
        }
    }

    private void sendResponse(HttpServletResponse resp, String result) throws IOException {
        resp.setStatus(200);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        resp.getWriter().append("OK").append(result == null ? "" : "," + result);
        resp.flushBuffer();
    }

    private void sendError(HttpServletResponse resp, String result) throws IOException {
        resp.setStatus(200);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        resp.getWriter().append("ERROR").append(result == null ? "" : ": " + result);
        resp.flushBuffer();
    }

    private String[] deserializeArgs(HttpServletRequest req) {
        String value;
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < 5 && (value = req.getParameter(String.valueOf(i + 1))) != null; ++i) {
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }
}

