/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.feign;

import cn.gjing.tools.feign.FeignBean;
import cn.gjing.tools.feign.FeignService;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;

@Service
@Import(value={FeignClientsConfiguration.class})
class FeignServiceImpl
implements FeignService {
    private final Feign.Builder urlBuilder;
    private final Feign.Builder nameBuilder;

    @Autowired
    public FeignServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract) {
        this.nameBuilder = Feign.builder().client(client).encoder(encoder).decoder(decoder).contract(contract);
        if (client instanceof LoadBalancerFeignClient) {
            client = ((LoadBalancerFeignClient)client).getDelegate();
        }
        this.urlBuilder = Feign.builder().client(client).encoder(encoder).decoder(decoder).contract(contract);
    }

    @Override
    public FeignBean newInstanceByUrl(String targetServeUrl) {
        return (FeignBean)this.urlBuilder.target(FeignBean.class, targetServeUrl);
    }

    @Override
    public FeignBean newInstanceByName(String targetServeName) {
        return (FeignBean)this.nameBuilder.target(FeignBean.class, targetServeName);
    }
}

