/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.config.security;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.auth.constant.SecurityEnums;
import com.byh.auth.entity.SecurityResultEntity;
import com.byh.auth.entity.SysHospitalEntity;
import com.byh.auth.entity.SysOrganEntity;
import com.byh.auth.entity.SysOrganHospitalEntity;
import com.byh.auth.entity.SysRoleEntity;
import com.byh.auth.entity.SysUserEntity;
import com.byh.auth.entity.base.BaseEntity;
import com.byh.auth.exception.SecurityException;
import com.byh.auth.feign.HsServiceFeign;
import com.byh.auth.mapper.SysHospitalMapper;
import com.byh.auth.mapper.SysHospitalUserMapper;
import com.byh.auth.mapper.SysOrganHospitalMapper;
import com.byh.auth.mapper.SysOrganMapper;
import com.byh.auth.mapper.SysUserMapper;
import com.byh.auth.service.SysUserService;
import com.byh.auth.util.Base64Util;
import com.byh.auth.util.CommonRequest;
import com.byh.auth.util.jwt.JwtEntity;
import com.byh.auth.util.jwt.JwtUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MyAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(MyAuthenticationProvider.class);
    @Value(value="${oauth.token.expire.time}")
    private Integer OAUTH_TOKEN_EXPIRE_TIME;
    private Logger logger = LoggerFactory.getLogger(MyAuthenticationProvider.class);
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private SysUserService sysUserService;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysUserMapper sysUserMapper;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysOrganHospitalMapper sysOrganHospitalMapper;
    @Resource
    private SysHospitalMapper sysHospitalMapper;
    @Resource
    private SysHospitalUserMapper sysHospitalUserMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    private String homePath = "/outpatient/registration";

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        String username = auth.getName().trim();
        String password = auth.getCredentials().toString().trim();
        HttpSession session = this.request.getSession();
        System.out.println(session.getId());
        Object code = session.getAttribute("code");
        System.out.println(code);
        this.checkImgCode(this.request);
        SysUserEntity userEntity = this.checkPassword(auth, username, password);
        List list = this.sysUserMapper.getUserRole(userEntity.getId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new SecurityException(SecurityEnums.SECURITY_NO_AUTH.getCode(), SecurityEnums.SECURITY_NO_AUTH.getName());
        }
        StringBuilder builder = new StringBuilder();
        for (SysRoleEntity n : list) {
            builder.append("ROLE_").append(n.getRoleKey()).append(",");
            if (null == n.getHomePath() || "".equals(this.homePath = n.getHomePath())) continue;
            this.homePath = n.getHomePath();
        }
        List organList = this.getOrganList(userEntity, list);
        List grant = AuthorityUtils.createAuthorityList((String[])builder.toString().split(","));
        User user = new User(username, userEntity.getPassword(), (Collection)grant);
        String token = this.generatorToken(this.request, userEntity);
        SecurityResultEntity result = new SecurityResultEntity((Object)user, (Object)password, (Collection)grant);
        result.setSignNo("");
        result.setDetails(auth.getDetails());
        result.setDetailToken(token);
        result.setOrganList(organList);
        result.setSysUserEntity(userEntity);
        result.setHomePath(this.homePath);
        this.redisTemplate.opsForValue().set((Object)token, (Object)userEntity, 7200L, TimeUnit.SECONDS);
        return result;
    }

    public SysUserEntity checkPassword(Authentication auth, String username, String password) {
        byte[] bytes = password.getBytes();
        String encode = Base64Util.encode((byte[])bytes);
        SysUserEntity userEntity = this.sysUserService.getUserByPhone(username);
        if (null == userEntity) {
            throw new SecurityException(SecurityEnums.SECURITY_USER_EXIST.getCode(), SecurityEnums.SECURITY_USER_EXIST.getName());
        }
        if (!encode.equals(userEntity.getPassword())) {
            throw new SecurityException(SecurityEnums.SECURITY_USER_PASSWORD_ERROR.getCode(), SecurityEnums.SECURITY_USER_PASSWORD_ERROR.getName());
        }
        return userEntity;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }

    private void checkImgCode(HttpServletRequest request) {
        String imgCodeKey = request.getParameter("imgCodeKey");
        if (null == imgCodeKey || "".equals(imgCodeKey)) {
            throw new SecurityException(SecurityEnums.CODE_KEY_IS_BLANK.getCode(), SecurityEnums.CODE_KEY_IS_BLANK.getName());
        }
        String imgCode = request.getParameter("imgCode");
        if (null == imgCode || "".equals(imgCode)) {
            throw new SecurityException(SecurityEnums.LOGIN_IMG_CODE_IS_BLANK.getCode(), SecurityEnums.LOGIN_IMG_CODE_IS_BLANK.getName());
        }
        String RedisImgCode = (String)this.redisTemplate.opsForValue().get((Object)imgCodeKey);
        if (null == RedisImgCode || "".equals(RedisImgCode)) {
            throw new SecurityException(SecurityEnums.LOGIN_IMG_CODE_IS_NOT_GET.getCode(), SecurityEnums.LOGIN_IMG_CODE_IS_NOT_GET.getName());
        }
        if (!(RedisImgCode.equals(imgCode) || RedisImgCode.toLowerCase().equals(imgCode) || RedisImgCode.toUpperCase().equals(imgCode))) {
            throw new SecurityException(SecurityEnums.LOGIN_IMG_CODE_ERROR.getCode(), SecurityEnums.LOGIN_IMG_CODE_ERROR.getName());
        }
    }

    private String generatorToken(HttpServletRequest request, SysUserEntity userEntity) {
        HashMap<String, Object> payload = new HashMap<String, Object>(1);
        payload.put("userInfo", JSONObject.toJSONString((Object)userEntity));
        payload.put("tenantId", userEntity.getTenantId());
        JwtEntity jwtEntity = new JwtEntity("ykik49xYh5lOHzHbjksb", this.OAUTH_TOKEN_EXPIRE_TIME.intValue(), payload);
        String token = JwtUtils.generJwt((JwtEntity)jwtEntity);
        return token;
    }

    private List<SysOrganEntity> getOrganList(SysUserEntity userEntity, List<SysRoleEntity> roleList) {
        for (SysRoleEntity n : roleList) {
            if (!"SUPER_ADMIN".equals(n.getRoleKey())) continue;
            QueryWrapper wrapper = new QueryWrapper();
            List list = this.sysOrganMapper.selectList((Wrapper)wrapper.eq((Object)"del_flag", (Object)"0"));
            List hosList = this.sysHospitalMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDelFlag, (Object)"0"));
            Map<Integer, List<SysHospitalEntity>> hosMap = hosList.stream().collect(Collectors.groupingBy(SysHospitalEntity::getOrganId));
            for (SysOrganEntity m : list) {
                m.setList(hosMap.get(m.getId()));
            }
            return list;
        }
        List list = this.loginUserIsNotAdmin(userEntity);
        return list;
    }

    private List<SysOrganEntity> loginUserIsNotAdmin(SysUserEntity userEntity) {
        SysOrganHospitalEntity entity = (SysOrganHospitalEntity)this.sysOrganHospitalMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysOrganHospitalEntity::getId, (Object)userEntity.getTenantId()));
        List list = this.sysOrganMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)entity.getOrganId())).eq(BaseEntity::getDelFlag, (Object)"0"));
        List hospitalEntity = this.sysHospitalMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDelFlag, (Object)"0")).eq(BaseEntity::getId, (Object)entity.getHospitalId()));
        ((SysOrganEntity)list.get(0)).setList(hospitalEntity);
        return list;
    }
}

