/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.auth.controller.AuthController;
import com.byh.auth.entity.SysUserEntity;
import com.byh.auth.entity.hospital.SysHospitalDTO;
import com.byh.auth.feign.HsServiceFeign;
import com.byh.auth.feign.SysServiceFeign;
import com.byh.auth.feign.request.SigninRequest;
import com.byh.auth.feign.response.HsBaseResponse;
import com.byh.auth.feign.response.HsSigninResponse;
import com.byh.auth.mapper.SysUserMapper;
import com.byh.auth.service.MenuService;
import com.byh.auth.util.CommonRequest;
import com.byh.auth.util.ResponseData;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuthController {
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    private static final String ROLE_SUPER_ADMIN = "ROLE_SUPER_ADMIN";
    @Resource
    private SysServiceFeign sysServiceFeign;
    @Resource
    private HttpServletRequest request;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private MenuService menuService;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Resource
    private SysUserMapper sysUserMapper;

    @PostMapping(value={"/sysUser/hsLogin"})
    public ResponseData getVercode(@RequestBody SysUserEntity sysUserEntity) {
        SigninRequest signinRequest = new SigninRequest();
        signinRequest.setOpter_no(String.valueOf(sysUserEntity.getId()));
        signinRequest.setTenantId(this.commonRequest.getTenant());
        log.info("\u533b\u4fdd\u767b\u5f55signinRequest\uff1a{}", (Object)signinRequest);
        ResponseData hsBaseResponseResponseData = this.hsServiceFeign.hsSignin(signinRequest);
        if (hsBaseResponseResponseData.isSuccess() && !Objects.isNull(hsBaseResponseResponseData.getData())) {
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            HsBaseResponse hsBaseResponse = (HsBaseResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)hsBaseResponseResponseData.getData()), (Type)typeReference.getType(), (Feature[])new Feature[0]);
            log.info("\u533b\u4fdd\u767b\u5f55\u8fd4\u56de\uff1a{}", (Object)hsBaseResponse);
            String signNo = ((HsSigninResponse)hsBaseResponse.getOutput()).getSigninoutb().getSign_no();
            return ResponseData.success((Object)signNo);
        }
        return ResponseData.success((Object)"99999");
    }

    @GetMapping(value={"/sysUser/getVerCode"})
    public ResponseData getVercode(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ResponseData vercode = this.sysServiceFeign.getVercode(100, 40);
        Object data = vercode.getData();
        JSONObject o = (JSONObject)JSONObject.toJSON((Object)data);
        String vercodeValue = (String)o.get((Object)"vercodeValue");
        System.out.println(session.getId());
        session.setAttribute("code", (Object)vercodeValue);
        return vercode;
    }

    @PostMapping(value={"/getCurrent/userInfo"})
    public ResponseData getCurrentUserInfo() {
        String token = this.request.getHeader("detailToken");
        SysUserEntity entity = (SysUserEntity)this.redisTemplate.opsForValue().get((Object)token);
        return ResponseData.success((Object)entity);
    }

    @PostMapping(value={"/sysUser/byId"})
    public ResponseData getUser() {
        return this.sysServiceFeign.sysGetById(Integer.valueOf(1));
    }

    @GetMapping(value={"/getCode"})
    public ResponseData getOauthCode(String code) {
        ResponseData currentUserInfo = this.getCurrentUserInfo();
        System.out.println(currentUserInfo);
        if (null != code) {
            return ResponseData.success((Object)code);
        }
        return ResponseData.error((String)"101", (String)"\u6388\u6743\u7801\u8bf7\u6c42\u9519\u8bef");
    }

    @RequestMapping(value={"/getCode/success"})
    public ResponseData getOauthCodeSuccess() {
        return ResponseData.success();
    }

    @GetMapping(value={"/sysHospital/select"})
    public ResponseData getHospital(@RequestParam(value="page", required=false) Page page, @RequestParam(value="dto", required=false) SysHospitalDTO dto) {
        ResponseData responseData = this.sysServiceFeign.sysHospitalSelect(page, dto);
        return ResponseData.success((Object)responseData);
    }

    @RequestMapping(value={"/get/user/menuList"})
    public ResponseData getUserMenuList(@RequestBody(required=false) Integer id) {
        StringBuilder builder = new StringBuilder();
        List list = new ArrayList();
        SecurityContext context = SecurityContextHolder.getContext();
        Collection authentication = context.getAuthentication().getAuthorities();
        SysUserEntity entity = (SysUserEntity)this.sysUserMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysUserEntity::getId, (Object)id));
        for (GrantedAuthority n : authentication) {
            builder.append(n).append(",");
        }
        list = builder.toString().contains(ROLE_SUPER_ADMIN) ? this.menuService.getAdminMenu(entity.getTenantId()) : this.menuService.getUserMenu(id, entity.getTenantId());
        return ResponseData.success(list);
    }
}

