/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.util.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.byh.auth.util.jwt.JwtEntity;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtils {
    private static Logger logger = LoggerFactory.getLogger(JwtUtils.class);

    public static String generJwt(JwtEntity entity) {
        Calendar instance = Calendar.getInstance();
        instance.add(13, entity.getExpire());
        String token = JWT.create().withHeader(entity.getHeader()).withClaim("payload", entity.getPayload()).withExpiresAt(instance.getTime()).sign(Algorithm.HMAC256((String)entity.getSecret()));
        return token;
    }

    public static Map<String, Object> verifyJwt(String secret, String token) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        JWTVerifier build = JWT.require((Algorithm)Algorithm.HMAC256((String)secret)).build();
        try {
            DecodedJWT verify = build.verify(token);
            Map map = verify.getClaim("payload").asMap();
            return map;
        }
        catch (SignatureVerificationException e) {
            e.printStackTrace();
            logger.error("\u51fa\u73b0\u5f02\u5e38-> \u65e0\u6548\u7b7e\u540d");
            error.put("error", "\u51fa\u73b0\u5f02\u5e38-> \u65e0\u6548\u7b7e\u540d");
        }
        catch (TokenExpiredException e) {
            e.printStackTrace();
            logger.error("\u51fa\u73b0\u5f02\u5e38-> token\u8fc7\u671f");
            error.put("error", "\u51fa\u73b0\u5f02\u5e38-> token\u8fc7\u671f");
        }
        catch (AlgorithmMismatchException e) {
            e.printStackTrace();
            logger.error("\u51fa\u73b0\u5f02\u5e38-> token\u65e0\u6548");
            error.put("error", "\u51fa\u73b0\u5f02\u5e38-> token\u65e0\u6548");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u51fa\u73b0\u5f02\u5e38-> token\u65e0\u6548");
            error.put("error", "\u51fa\u73b0\u5f02\u5e38-> token\u65e0\u6548");
        }
        return error;
    }
}

