/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.controller;

import com.ebaiyihui.dto.DiseaseStatisticsDto;
import com.ebaiyihui.dto.GetDrugMainListByAppletDTO;
import com.ebaiyihui.dto.GetDrugMainListByAppletDTOv2;
import com.ebaiyihui.dto.GetDrugMainListByManageDTO;
import com.ebaiyihui.dto.GetOrderListDTO;
import com.ebaiyihui.dto.OrderListNewResDTO;
import com.ebaiyihui.dto.PcPatientListDTO;
import com.ebaiyihui.dto.StaffStatisticsDto;
import com.ebaiyihui.dto.StoreStatisticsDto;
import com.ebaiyihui.dto.backList.BackListInfoDto;
import com.ebaiyihui.dto.backList.BackListInfoVo;
import com.ebaiyihui.dto.medicalInsurance.MedicalInsuranceListQo;
import com.ebaiyihui.dto.portrait.MemberPatientDto;
import com.ebaiyihui.dto.portrait.MemberQueryConditionQo;
import com.ebaiyihui.dto.portrait.MemberQueryDetailQo;
import com.ebaiyihui.dto.portrait.MemberQueryListQo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisAmountVo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisDrugVo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisListQo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisPersonVo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisStoreVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.service.PatientInfoService;
import com.ebaiyihui.service.RedisService;
import com.ebaiyihui.vo.DelMainListByStatusVO;
import com.ebaiyihui.vo.DiseaseStatisticsVO;
import com.ebaiyihui.vo.DrugMainStatusCountVO;
import com.ebaiyihui.vo.GetMainListAppletRequestVO;
import com.ebaiyihui.vo.OrderListQO;
import com.ebaiyihui.vo.PatientInFoListVo;
import com.ebaiyihui.vo.PatientInformationEntryToIntegrate;
import com.ebaiyihui.vo.StoreStatisticsVO;
import com.ebaiyihui.vo.UpdateIntegrateMainStatusVO;
import com.ebaiyihui.vo.medicalInsurance.MedicalInsuranceVo;
import com.ebaiyihui.vo.portrait.PortraitRmfVo;
import com.ebaiyihui.vo.statics.LsStandardMedicationPatientStaticsQo;
import com.ebaiyihui.vo.statics.LsStandardMedicationPatientStaticsVo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsDpVo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsQo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsVo;
import com.ebaiyihui.vo.statics.PatientOrderStaticsQo;
import com.ebaiyihui.vo.statics.PatientOrderStaticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"integrate/patient"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"\u60a3\u8005\u6570\u636e\u4e2d\u5fc3/\u60e0\u5c14\u5eb7"})
@CrossOrigin(origins={"*"})
public class PatientInfoController {
    private static final Logger log = LoggerFactory.getLogger(PatientInfoController.class);
    @Autowired
    private PatientInfoService patientInfoService;
    @Autowired
    private RedisService redisService;

    @PostMapping(value={"/pcPatientList"})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u60a3\u8005\u5217\u8868(\u8fc7\u671f)")
    public BaseResponse<PcPatientListDTO> pcPatientList(@RequestBody PatientInFoListVo vo) {
        PcPatientListDTO data = this.patientInfoService.pcPatientList(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/v2/pcPatientList"})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u4f1a\u5458\u5217\u8868v2")
    public BaseResponse<PcPatientListDTO> pcPatientListV2(@RequestBody PatientInFoListVo vo) {
        PcPatientListDTO data = this.patientInfoService.pcPatientListV2(vo, Boolean.valueOf(false));
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/pcPatientListExport"})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u4f1a\u5458\u5217\u8868\u5bfc\u51fa")
    public BaseResponse<PcPatientListDTO> pcPatientListExport(@RequestBody PatientInFoListVo vo) {
        PcPatientListDTO data = this.patientInfoService.pcPatientListV2(vo, Boolean.valueOf(true));
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/v3/pcPatientList"})
    @ApiOperation(value="\u60a3\u8005\u6570\u636e\u62c6\u5206\u5217\u8868v3")
    public BaseResponse<PcPatientListDTO> pcPatientListV3(@RequestBody PatientInFoListVo vo) {
        PcPatientListDTO data = this.patientInfoService.pcPatientListV3(vo, false);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/v3/pcPatientSplitList"})
    @ApiOperation(value="\u60a3\u8005\u6570\u636e\u62c6\u5206\u5217\u8868\u5bfc\u51fa")
    public BaseResponse<PcPatientListDTO> pcPatientSplitListV3(@RequestBody PatientInFoListVo vo) {
        PcPatientListDTO data = this.patientInfoService.pcPatientListV3(vo, true);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/pcProgramPatientList"})
    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u60a3\u8005\u5217\u8868")
    public BaseResponse<PcPatientListDTO> pcProgramPatientList(@RequestBody PatientInFoListVo vo) {
        PcPatientListDTO data = this.patientInfoService.pcProgramPatientList(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getPatientIdsByConditions"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4f1a\u5458\u7684ids")
    public BaseResponse<List<String>> getPatientIdsByConditions(@RequestBody PatientInFoListVo vo) {
        List data = this.patientInfoService.getPatientIdsByConditions(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getOrderList"})
    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u5217\u8868")
    public BaseResponse<GetOrderListDTO> getOrderList(@RequestBody OrderListQO vo) {
        GetOrderListDTO data = this.patientInfoService.getOrderList(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getOrderMemberDayList"})
    @ApiOperation(value="\u67e5\u8be2\u4f1a\u5458\u65e5\u6d88\u8d39\u4f1a\u5458")
    public BaseResponse<List<OrderListNewResDTO>> getOrderMemberDayList(@RequestBody OrderListQO vo) {
        List data = this.patientInfoService.getOrderMemberDayList(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getPatientBuyDrugOrderList"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u8d2d\u836f\u5206\u6790\u5217\u8868")
    public BaseResponse<PatientOrderStaticsVo> getPatientBuyDrugOrderList(@RequestBody PatientOrderStaticsQo qo) {
        PatientOrderStaticsVo data = this.patientInfoService.getPatientBuyDrugOrderList(qo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getDrugMainListByManage"})
    @ApiOperation(value="\u83b7\u53d6\u7ba1\u7406\u7aef\u5904\u65b9\u5217\u8868")
    public BaseResponse<GetDrugMainListByManageDTO> getDrugMainListByManage(@RequestBody GetMainListAppletRequestVO vo) {
        GetDrugMainListByManageDTO data = this.patientInfoService.getDrugMainListByManage(vo);
        return BaseResponse.success((Object)data);
    }

    @GetMapping(value={"/delDrugMainListCache"})
    @ApiOperation(value="\u6e05\u9664\u67d0\u54c1\u724c\u67d0\u72b6\u6001\u7684\u5217\u8868\u7f13\u5b58")
    public BaseResponse delDrugMainListCache(@RequestBody DelMainListByStatusVO vo) {
        this.redisService.delDrugMainListCache(vo);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getDrugMainListByApplet"})
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u5904\u65b9\u5217\u8868")
    public BaseResponse<GetDrugMainListByAppletDTO> getDrugMainListByApplet(@RequestBody GetMainListAppletRequestVO vo) {
        GetDrugMainListByAppletDTO data = this.patientInfoService.getDrugMainListByApplet(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/v2/getDrugMainListByApplet"})
    @ApiOperation(value="\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u5904\u65b9\u5217\u8868")
    public BaseResponse<GetDrugMainListByAppletDTOv2> getDrugMainListByAppletv2(@RequestBody GetMainListAppletRequestVO vo) {
        GetDrugMainListByAppletDTOv2 data = this.patientInfoService.getDrugMainListByAppletv2(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getDrugMainStatusCount"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u64cd\u4f5c\u5904\u65b9\u6570\u91cf\u63a5\u53e3")
    public BaseResponse<Integer> getDrugMainStatusCount(@RequestBody DrugMainStatusCountVO vo) {
        Integer data = this.patientInfoService.getDrugMainStatusCount(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/staffStatistics"})
    @ApiOperation(value="PC\u60a3\u8005\u5efa\u6863\u5458\u5de5\u7edf\u8ba1\u5217\u8868")
    public BaseResponse<StaffStatisticsDto> getPatientStaffStatistics(@RequestBody StoreStatisticsVO statisticsVO) {
        StaffStatisticsDto data = this.patientInfoService.getPatientStaffStatistics(statisticsVO);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/diseaseStatistics"})
    @ApiOperation(value="PC\u60a3\u8005\u75c5\u79cd\u7edf\u8ba1\u5217\u8868")
    public BaseResponse<DiseaseStatisticsDto> getPatientDiseaseStatistics(@RequestBody DiseaseStatisticsVO statisticsVO) {
        DiseaseStatisticsDto data = this.patientInfoService.getPatientDiseaseStatistics(statisticsVO);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/updateMainStatus"})
    @ApiOperation(value="\u53d8\u66f4\u5904\u65b9\u72b6\u6001", notes="\u53d8\u66f4\u5904\u65b9\u72b6\u6001")
    public BaseResponse<Object> updateMainStatus(@RequestBody UpdateIntegrateMainStatusVO vo) {
        this.redisService.updateMainStatus(vo);
        return BaseResponse.success();
    }

    @PostMapping(value={"/informationEntry"})
    @ApiOperation(value="\u65b0\u589e\u4f1a\u5458\u5904\u7406", notes="\u65b0\u589e\u7528\u6237\u5904\u7406")
    public BaseResponse<Object> informationEntry(@RequestBody PatientInformationEntryToIntegrate vo) {
        this.redisService.informationEntry(vo);
        return BaseResponse.success();
    }

    @PostMapping(value={"/storeStatistics"})
    @ApiOperation(value="PC\u60a3\u8005\u5f00\u5361\u95e8\u5e97\u7edf\u8ba1\u5217\u8868")
    public BaseResponse<StoreStatisticsDto> getPatientStoreStatistics(@RequestBody StoreStatisticsVO statisticsVO) {
        StoreStatisticsDto data = this.patientInfoService.getPatientStoreStatistics(statisticsVO);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getMedicalInsurance"})
    @ApiOperation(value="\u83b7\u53d6\u533b\u4fdd\u7edf\u7b79\u5217\u8868")
    public BaseResponse<MedicalInsuranceVo> getMedicalInsurance(@RequestBody MedicalInsuranceListQo vo) {
        MedicalInsuranceVo data = this.patientInfoService.getMedicalInsurance(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getBackListList"})
    @ApiOperation(value="\u83b7\u53d6\u9ed1\u540d\u5355\u5217\u8868")
    public BaseResponse<BackListInfoVo> getBackListList(@RequestBody BackListInfoDto vo) {
        BackListInfoVo data = this.patientInfoService.getBackListList(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/querySalesAnalysisPersonByDrug"})
    @ApiOperation(value="\u836f\u54c1-\u4eba\u5458\u4e0b\u94bb\u5217\u8868\u67e5\u8be2")
    public BaseResponse<SalesAnalysisPersonVo> querySalesAnalysisPersonByDrug(@RequestBody SalesAnalysisListQo vo) {
        SalesAnalysisPersonVo data = this.patientInfoService.querySalesAnalysisPersonByDrug(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/querySalesAnalysisDrugList"})
    @ApiOperation(value="\u6309\u836f\u54c1\u7edf\u8ba1\u9500\u552e\u62a5\u8868")
    public BaseResponse<SalesAnalysisDrugVo> querySalesAnalysisDrugList(@RequestBody SalesAnalysisListQo vo) {
        SalesAnalysisDrugVo data = this.patientInfoService.querySalesAnalysisDrugList(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/querySalesAnalysisStoreList"})
    @ApiOperation(value="\u6309\u95e8\u5e97\u7edf\u8ba1\u9500\u552e\u62a5\u8868")
    public BaseResponse<SalesAnalysisStoreVo> querySalesAnalysisStoreList(@RequestBody SalesAnalysisListQo vo) {
        SalesAnalysisStoreVo data = this.patientInfoService.querySalesAnalysisStoreList(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/querySalesAnalysisAmountList"})
    @ApiOperation(value="\u6309\u9500\u552e\u989d\u7edf\u8ba1\u9500\u552e\u62a5\u8868")
    public BaseResponse<SalesAnalysisAmountVo> querySalesAnalysisAmountList(@RequestBody SalesAnalysisListQo vo) {
        SalesAnalysisAmountVo data = this.patientInfoService.querySalesAnalysisAmountList(vo);
        return BaseResponse.success((Object)data);
    }

    @GetMapping(value={"/query/rmf"})
    @ApiOperation(value="\u67e5\u8be2rmf\u503c")
    public BaseResponse<PortraitRmfVo> getRmfAvg() {
        PortraitRmfVo data = this.patientInfoService.getRmfAvg();
        return BaseResponse.success((Object)data);
    }

    @GetMapping(value={"/query/patientIds"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u5f00\u5361\u95e8\u5e97\u7684\u60a3\u8005\u6570\u636e")
    public BaseResponse<List<MemberPatientDto>> queryPatientIdById() {
        List data = this.patientInfoService.queryPatientIdById();
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getConsumerPatientIdByCondition"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u6d88\u8d39\u4f1a\u5458\u7684ids")
    public BaseResponse<List<String>> getConsumerPatientIdByCondition(@RequestBody MemberQueryConditionQo vo) {
        List data = this.patientInfoService.getConsumerPatientIdByCondition(vo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/queryPortraitListByType"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u753b\u50cf\u5217\u8868")
    public BaseResponse<Object> queryPortraitListByType(@RequestBody @Validated MemberQueryListQo vo) {
        Object data = this.patientInfoService.queryPortraitListByType(vo);
        return BaseResponse.success((Object)data);
    }

    @ApiOperation(value="\u7528\u6237\u753b\u50cf-\u5217\u8868\u8be6\u60c5\u63a5\u53e3")
    @PostMapping(value={"/queryPortraitDetail"})
    public BaseResponse<Object> queryPortraitDetail(@RequestBody @Validated MemberQueryDetailQo conditionDto) {
        return BaseResponse.success((Object)this.patientInfoService.queryPortraitDetail(conditionDto));
    }

    @PostMapping(value={"/getLsStandardMedicalStaticList"})
    @ApiOperation(value="\u7f57\u6c0f\u89c4\u8303\u7528\u836f\u7edf\u8ba1\u5217\u8868")
    public BaseResponse<LsStandardMedicationStaticsVo> getLsStandardMedicalStaticList(@RequestBody LsStandardMedicationStaticsQo qo) {
        LsStandardMedicationStaticsVo data = this.patientInfoService.getLsStandardMedicationStaticsList(qo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getLsStandardMedicalPatientStaticList"})
    @ApiOperation(value="\u7f57\u6c0f\u89c4\u8303\u7528\u836f\u60a3\u8005\u8be6\u7ec6\u7edf\u8ba1")
    public BaseResponse<LsStandardMedicationPatientStaticsVo> getLsStandardMedicalPatientStaticList(@RequestBody LsStandardMedicationPatientStaticsQo qo) {
        LsStandardMedicationPatientStaticsVo data = this.patientInfoService.getLsStandardMedicationPatientStaticsList(qo);
        return BaseResponse.success((Object)data);
    }

    @PostMapping(value={"/getLsStandardMedicalStaticListDp"})
    @ApiOperation(value="\u7f57\u6c0f\u6570\u636e\u5927\u5c4f\u7edf\u8ba1")
    public BaseResponse<LsStandardMedicationStaticsDpVo> getLsStandardMedicalStaticListDp(@RequestBody LsStandardMedicationStaticsQo qo) {
        LsStandardMedicationStaticsDpVo data = this.patientInfoService.getLsStandardMedicalStaticListDp(qo);
        return BaseResponse.success((Object)data);
    }
}

