/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.controller.huawei;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.controller.huawei.AppInfo;
import com.ebaiyihui.controller.huawei.BaseResp;
import com.ebaiyihui.controller.huawei.ExpireInstanceReq;
import com.ebaiyihui.controller.huawei.IsvProduceAPI;
import com.ebaiyihui.controller.huawei.KeyPairUtil;
import com.ebaiyihui.controller.huawei.NewInstanceInfo;
import com.ebaiyihui.controller.huawei.NewInstanceReq;
import com.ebaiyihui.controller.huawei.NewInstanceResp;
import com.ebaiyihui.controller.huawei.ParamConverter;
import com.ebaiyihui.controller.huawei.RefreshInstanceReq;
import com.ebaiyihui.controller.huawei.ReleaseInstanceReq;
import com.ebaiyihui.controller.huawei.ResultCodeEnum;
import com.ebaiyihui.controller.huawei.UpgradeReq;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/test"})
@CrossOrigin(origins={"*"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    ObjectMapper mapper = new ObjectMapper();
    private static final int ENCRYPT_TYPE = 1;
    private static final String ACCESS_KEY = "07df8329-d12c-48e3-9103-f30b42c1c0ee";
    private static final String BODY_SIGN_KEY = "Body-Sign";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String BODY_SIGN_VALUE = "sign_type=\"HMAC-SHA256\", signature= \"{signature}\"";
    private String privateSecret = "";

    @GetMapping(value={"/hello"})
    public String hello() {
        return "hello";
    }

    @RequestMapping(value={"/bodySign"})
    public void bodySign(@RequestParam String activity, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.info("HTTP Body\u7b7e\u540d");
        log.info("activity: {}", (Object)activity);
        if ("newInstance".equals(activity)) {
            this.newInstance(request, response);
        } else if ("refreshInstance".equals(activity)) {
            this.refreshInstance(request, response);
        } else if ("releaseInstance".equals(activity)) {
            this.releaseInstance(request, response);
        } else if ("expireInstance".equals(activity)) {
            this.expireInstance(request, response);
        }
    }

    public static String generateResponseBodySignature(String key, String body) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        return TestController.base_64((byte[])TestController.hmacSHA256((String)key, (String)body));
    }

    public static byte[] hmacSHA256(String macKey, String macData) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, UnsupportedEncodingException {
        SecretKeySpec secret = new SecretKeySpec(macKey.getBytes(), "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(secret);
        byte[] doFinal = mac.doFinal(macData.getBytes("UTF-8"));
        return doFinal;
    }

    public static String base_64(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public void newInstance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map paramsMap = request.getParameterMap();
        if (this.verifyParams(IsvProduceAPI.verificationRequestQueryParams((Map)paramsMap, (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee"), response)) {
            return;
        }
        NewInstanceReq newInstanceReq = ParamConverter.convertNewInstanceReq((Map)paramsMap);
        log.info("newInstance : {}", (Object)JSON.toJSONString((Object)newInstanceReq));
        newInstanceReq.setMobilePhone(IsvProduceAPI.decryptContent((String)newInstanceReq.getMobilePhone(), (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee", (int)1));
        newInstanceReq.setEmail(IsvProduceAPI.decryptContent((String)newInstanceReq.getEmail(), (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee", (int)1));
        if (StringUtils.isNotEmpty((CharSequence)newInstanceReq.getSaasExtendParams())) {
            newInstanceReq.setSaasExtendParams(IsvProduceAPI.decryptSaasExtendParams((String)newInstanceReq.getSaasExtendParams()));
        }
        NewInstanceInfo newInstanceInfo = new NewInstanceInfo();
        newInstanceInfo.setInstanceId(UUID.randomUUID().toString());
        AppInfo appInfo = new AppInfo();
        appInfo.setUserName("test");
        appInfo.setPassword("test");
        appInfo.setAdminUrl("http://devapi.chinachdu.com");
        appInfo.setFrontEndUrl("http://devapi.chinachdu.com");
        newInstanceInfo.setAppInfo(appInfo);
        if (null == newInstanceInfo) {
            this.writeErrorResp(ResultCodeEnum.OTHER_INNER_ERROR, response);
            return;
        }
        String instanceId = newInstanceInfo.getInstanceId();
        String userName = newInstanceInfo.getAppInfo().getUserName();
        String password = newInstanceInfo.getAppInfo().getPassword();
        String adminUrl = newInstanceInfo.getAppInfo().getAdminUrl();
        String frontEndUrl = newInstanceInfo.getAppInfo().getFrontEndUrl();
        String memo = newInstanceInfo.getAppInfo().getMemo();
        String responseBody = this.buildNewInstanceSuccessResponse(userName, password, 1, instanceId, adminUrl, frontEndUrl, memo);
        this.writeSuccessResp(response, responseBody);
    }

    private void writeErrorResp(ResultCodeEnum resultCodeEnum, HttpServletResponse response) throws IOException {
        String responseBody = this.buildFailedResponse(resultCodeEnum.getResultCode(), resultCodeEnum.getResultMsg());
        String signature = IsvProduceAPI.generateResponseBodySignature((String)"07df8329-d12c-48e3-9103-f30b42c1c0ee", (String)responseBody);
        response.setHeader("Body-Sign", "sign_type=\"HMAC-SHA256\", signature= \"{signature}\"".replace("{signature}", signature));
        response.setStatus(400);
        response.getWriter().print(responseBody);
    }

    private boolean verifyParams(boolean verificationResult, HttpServletResponse response) throws IOException {
        if (!verificationResult) {
            this.writeErrorResp(ResultCodeEnum.INVALID_PARAM, response);
            return true;
        }
        return false;
    }

    public void refreshInstance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map paramsMap = request.getParameterMap();
        if (this.verifyParams(IsvProduceAPI.verificationRequestQueryParams((Map)paramsMap, (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee"), response)) {
            return;
        }
        RefreshInstanceReq refreshInstanceReq = ParamConverter.convertRefreshInstanceReq((Map)paramsMap);
        log.info("refreshInstanceReq : {}", (Object)JSON.toJSONString((Object)refreshInstanceReq));
        boolean isSuccess = true;
        if (isSuccess) {
            this.writeSuccessResp(response, null);
            return;
        }
        this.writeErrorResp(ResultCodeEnum.OTHER_INNER_ERROR, response);
    }

    private void writeSuccessResp(HttpServletResponse response, String successResp) throws IOException {
        String responseBody = StringUtils.isBlank((CharSequence)successResp) ? this.buildSuccessResponse() : successResp;
        String signature = IsvProduceAPI.generateResponseBodySignature((String)"07df8329-d12c-48e3-9103-f30b42c1c0ee", (String)responseBody);
        response.setHeader("Body-Sign", "sign_type=\"HMAC-SHA256\", signature= \"{signature}\"".replace("{signature}", signature));
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        response.getWriter().print(responseBody);
    }

    public void expireInstance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map paramsMap = request.getParameterMap();
        if (this.verifyParams(IsvProduceAPI.verificationRequestQueryParams((Map)paramsMap, (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee"), response)) {
            return;
        }
        ExpireInstanceReq expireInstanceReq = ParamConverter.convertExpireInstanceReq((Map)paramsMap);
        log.info("expireInstanceReq : {}", (Object)JSON.toJSONString((Object)expireInstanceReq));
        boolean isSuccess = true;
        if (isSuccess) {
            this.writeSuccessResp(response, null);
            return;
        }
        this.writeErrorResp(ResultCodeEnum.OTHER_INNER_ERROR, response);
    }

    public void releaseInstance(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map paramsMap = request.getParameterMap();
        if (this.verifyParams(IsvProduceAPI.verificationRequestQueryParams((Map)paramsMap, (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee"), response)) {
            return;
        }
        ReleaseInstanceReq releaseInstanceReq = ParamConverter.convertReleaseInstanceReq((Map)paramsMap);
        log.info("releaseInstanceReq : {}", (Object)JSON.toJSONString((Object)releaseInstanceReq));
        boolean isSuccess = true;
        if (isSuccess) {
            this.writeSuccessResp(response, null);
            return;
        }
        this.writeErrorResp(ResultCodeEnum.OTHER_INNER_ERROR, response);
    }

    public void upgrade(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map paramsMap = request.getParameterMap();
        if (this.verifyParams(IsvProduceAPI.verificationRequestQueryParams((Map)paramsMap, (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee"), response)) {
            return;
        }
        UpgradeReq upgradeReq = ParamConverter.convertUpgradeReq((Map)paramsMap);
        log.info("upgradeReq : {}", (Object)JSON.toJSONString((Object)upgradeReq));
        boolean isSuccess = true;
        if (isSuccess) {
            this.writeSuccessResp(response, null);
            return;
        }
        this.writeErrorResp(ResultCodeEnum.OTHER_INNER_ERROR, response);
    }

    private String getAppSecret(String appSecret) {
        try {
            return KeyPairUtil.decrypt((String)appSecret, (String)this.privateSecret);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String buildFailedResponse(String code, String message) throws JsonProcessingException {
        BaseResp result = new BaseResp();
        result.setResultMsg(message);
        result.setResultCode(code);
        return this.mapper.writeValueAsString((Object)result);
    }

    private String buildNewInstanceSuccessResponse(String userName, String password, int encryptType, String instanceId, String adminUrl, String frontEndUrl, String memo) throws JsonProcessingException {
        this.mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        NewInstanceResp result = new NewInstanceResp();
        result.setResultMsg(ResultCodeEnum.SUCCESS.getResultMsg());
        result.setResultCode(ResultCodeEnum.SUCCESS.getResultCode());
        result.setEncryptType(encryptType);
        result.setInstanceId(instanceId);
        AppInfo appInfo = new AppInfo();
        appInfo.setAdminUrl(adminUrl);
        appInfo.setFrontEndUrl(frontEndUrl);
        appInfo.setMemo(memo);
        appInfo.setUserName(IsvProduceAPI.encryptContent((String)userName, (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee", (int)encryptType));
        appInfo.setPassword(IsvProduceAPI.encryptContent((String)password, (String)"07df8329-d12c-48e3-9103-f30b42c1c0ee", (int)encryptType));
        result.setAppInfo(appInfo);
        return this.mapper.writeValueAsString((Object)result);
    }

    private String buildSuccessResponse() throws JsonProcessingException {
        BaseResp result = new BaseResp();
        result.setResultMsg(ResultCodeEnum.SUCCESS.getResultMsg());
        result.setResultCode(ResultCodeEnum.SUCCESS.getResultCode());
        return this.mapper.writeValueAsString((Object)result);
    }
}

