/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.dto.DiseaseStatisticsDto;
import com.ebaiyihui.dto.DiseaseStatisticsListDto;
import com.ebaiyihui.dto.GetDrugMainListByAppletDTO;
import com.ebaiyihui.dto.GetDrugMainListByAppletDTOv2;
import com.ebaiyihui.dto.GetDrugMainListByManageDTO;
import com.ebaiyihui.dto.GetMainListByManageResponseDto;
import com.ebaiyihui.dto.GetOrderListDTO;
import com.ebaiyihui.dto.OrderListDto;
import com.ebaiyihui.dto.OrderListNewResDTO;
import com.ebaiyihui.dto.PatientInfoDTO;
import com.ebaiyihui.dto.PcPatientListDTO;
import com.ebaiyihui.dto.PrescriptionAppletListResponseDto;
import com.ebaiyihui.dto.PrescriptionAppletListResponseDtov2;
import com.ebaiyihui.dto.ProgramIndexStatisticsDTO;
import com.ebaiyihui.dto.StaffStatisticsDto;
import com.ebaiyihui.dto.StaffStatisticsListDto;
import com.ebaiyihui.dto.StoreStatisticsDto;
import com.ebaiyihui.dto.StoreStatisticsListDto;
import com.ebaiyihui.dto.backList.BackListInfoDto;
import com.ebaiyihui.dto.backList.BackListInfoVo;
import com.ebaiyihui.dto.medicalInsurance.MedicalInsuranceListQo;
import com.ebaiyihui.dto.portrait.MemberPatientDto;
import com.ebaiyihui.dto.portrait.MemberQueryConditionQo;
import com.ebaiyihui.dto.portrait.MemberQueryDetailQo;
import com.ebaiyihui.dto.portrait.MemberQueryListQo;
import com.ebaiyihui.dto.portrait.PortraitRmfDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisAmountDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisAmountVo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisCommonDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisDrugDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisDrugVo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisListQo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisPersonChildDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisPersonVo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisStoreDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisStoreVo;
import com.ebaiyihui.service.PatientInfoService;
import com.ebaiyihui.starrocks.StarRocksOrderUtils;
import com.ebaiyihui.starrocks.StarRocksPatientUtils;
import com.ebaiyihui.starrocks.StarRocksPresUtils;
import com.ebaiyihui.starrocks.StarRocksStatisticsUtils;
import com.ebaiyihui.utils.DateUtils;
import com.ebaiyihui.utils.PaginationHelper;
import com.ebaiyihui.utils.RedisUtil;
import com.ebaiyihui.vo.DiseaseStatisticsVO;
import com.ebaiyihui.vo.DrugMainStatusCountVO;
import com.ebaiyihui.vo.GetMainListAppletRequestVO;
import com.ebaiyihui.vo.OrderListQO;
import com.ebaiyihui.vo.PatientInFoListVo;
import com.ebaiyihui.vo.ProgramIndexStatisticsVo;
import com.ebaiyihui.vo.StoreStatisticsVO;
import com.ebaiyihui.vo.UserDataAuthsVO;
import com.ebaiyihui.vo.medicalInsurance.MedicalInsuranceListVo;
import com.ebaiyihui.vo.medicalInsurance.MedicalInsuranceSubVo;
import com.ebaiyihui.vo.medicalInsurance.MedicalInsuranceVo;
import com.ebaiyihui.vo.portrait.MemberQueryListVo;
import com.ebaiyihui.vo.portrait.PortraitRmfVo;
import com.ebaiyihui.vo.statics.LsStandardMedicationPatientStaticsQo;
import com.ebaiyihui.vo.statics.LsStandardMedicationPatientStaticsVo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsDpVo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsDto;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsQo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsVo;
import com.ebaiyihui.vo.statics.PatientOrderStaticsQo;
import com.ebaiyihui.vo.statics.PatientOrderStaticsVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PatientInfoServiceImpl
implements PatientInfoService {
    private static final Logger log = LoggerFactory.getLogger(PatientInfoServiceImpl.class);
    @Autowired
    private StarRocksPatientUtils starRocksPatientUtils;
    @Autowired
    private StarRocksOrderUtils starRocksOrderUtils;
    @Autowired
    private StarRocksPresUtils starRocksPresUtils;
    @Autowired
    private StarRocksStatisticsUtils starRocksStatisticsUtils;
    @Autowired
    private DataSource starRocksDataSource;
    @Autowired
    private RedisUtil redisUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetDrugMainListByAppletDTO getDrugMainListByApplet(GetMainListAppletRequestVO vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            GetDrugMainListByAppletDTO data = new GetDrugMainListByAppletDTO();
            Future list = this.starRocksPresUtils.queryDrugMainListByApplet(connection, vo);
            Future total = this.starRocksPresUtils.queryDrugMainListCountByApplet(connection, vo);
            List prescriptionAppletListResponseDtos = (List)list.get();
            for (PrescriptionAppletListResponseDto detailsDto : prescriptionAppletListResponseDtos) {
                if (StringUtils.isNotEmpty((CharSequence)detailsDto.getPrescriptionData())) {
                    detailsDto.setPrescriptionUrls(JSON.parseArray((String)detailsDto.getPrescriptionData(), String.class));
                }
                if (!Objects.nonNull(detailsDto.getPrescriptionInputTime())) continue;
                detailsDto.setPrescriptionInputTimeString(DateUtil.format((Date)detailsDto.getPrescriptionInputTime(), (String)"yyyy-MM-dd"));
            }
            data.setList(prescriptionAppletListResponseDtos);
            data.setTotal(Integer.valueOf(Integer.parseInt((String)total.get())));
            GetDrugMainListByAppletDTO getDrugMainListByAppletDTO = data;
            return getDrugMainListByAppletDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    public GetDrugMainListByAppletDTOv2 getDrugMainListByAppletv2(GetMainListAppletRequestVO vo) {
        GetDrugMainListByAppletDTOv2 data = new GetDrugMainListByAppletDTOv2();
        GetDrugMainListByManageDTO list = this.getDrugMainListByManage(vo);
        ArrayList<PrescriptionAppletListResponseDtov2> appletList = new ArrayList<PrescriptionAppletListResponseDtov2>();
        for (GetMainListByManageResponseDto m : list.getList()) {
            PrescriptionAppletListResponseDtov2 a = new PrescriptionAppletListResponseDtov2();
            BeanUtils.copyProperties((Object)m, (Object)a);
            appletList.add(a);
        }
        data.setList(appletList);
        data.setTotal(list.getTotal());
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetDrugMainListByManageDTO getDrugMainListByManage(GetMainListAppletRequestVO vo) {
        Connection connection = null;
        try {
            List userDataAuths;
            connection = this.starRocksDataSource.getConnection();
            GetDrugMainListByManageDTO data = new GetDrugMainListByManageDTO();
            UserDataAuthsVO auth = this.querydataAuthsStr(connection, vo.getUserId());
            String keyCache = "patient_getDrugMainList_cache:#" + auth.getAuthType() + "@" + auth.getId() + "###" + vo.getMainStatus();
            if (vo.needCache().booleanValue()) {
                Object obj = this.redisUtil.get(keyCache);
                log.info("\u7f13\u5b58\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)obj));
                if (Objects.nonNull(obj)) {
                    log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u76f8\u540c\u6743\u9650\u7684\u6570\u636e,key:{}", (Object)keyCache);
                    data = (GetDrugMainListByManageDTO)JSON.parseObject((String)obj.toString(), GetDrugMainListByManageDTO.class);
                    if (data.getList().size() >= data.getTotal() || vo.getPageIndex() * vo.getPageSize() <= data.getList().size()) {
                        data.setList(this.starRocksPresUtils.dataPageFilter(data.getList(), vo));
                        GetDrugMainListByManageDTO getDrugMainListByManageDTO = data;
                        return getDrugMainListByManageDTO;
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId())))) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future list = this.starRocksPresUtils.queryDrugMainList(connection, userDataAuths, vo);
            List mainListDTOS = (List)list.get();
            Future total = this.starRocksPresUtils.queryDrugMainListCount(connection, userDataAuths, vo);
            data.setList(mainListDTOS);
            data.setTotal(Integer.valueOf(Integer.parseInt((String)total.get())));
            if (vo.needCache().booleanValue()) {
                long size = this.redisUtil.lGetListSize("INTEGRATE_MAIN_STATUS_NEW_LIST");
                if (size > 0L && (Objects.isNull(vo.getMainStatus()) || Objects.equals(vo.getMainStatus(), 10))) {
                    List objects = this.redisUtil.lGet("INTEGRATE_MAIN_STATUS_NEW_LIST", 0L, size);
                    ArrayList<GetMainListByManageResponseDto> redisValue = new ArrayList<GetMainListByManageResponseDto>();
                    for (int i = 0; i < objects.size(); ++i) {
                        String obj = objects.get(i).toString().split("###")[0];
                        GetMainListByManageResponseDto dto = (GetMainListByManageResponseDto)JSON.parseObject((String)obj, GetMainListByManageResponseDto.class);
                        if (auth.getAuthType() != 0 && (auth.getAuthType() != 1 || !auth.getId().contains("@" + objects.get(i).toString().split("###")[1])) && (auth.getAuthType() != 2 || !auth.getId().contains("@" + objects.get(i).toString().split("###")[2]))) continue;
                        boolean have = false;
                        for (int j = 0; j < mainListDTOS.size(); ++j) {
                            if (!((GetMainListByManageResponseDto)mainListDTOS.get(j)).getDrugPrescriptionId().equals(dto.getDrugPrescriptionId())) continue;
                            have = true;
                            break;
                        }
                        if (have) continue;
                        redisValue.add(dto);
                        data.setTotal(Integer.valueOf(data.getTotal() + 1));
                    }
                    mainListDTOS.addAll(redisValue);
                }
                this.redisUtil.set(keyCache, (Object)JSON.toJSONString((Object)data), 900L);
                data.setList(this.starRocksPresUtils.dataPageFilter(data.getList(), vo));
            }
            GetDrugMainListByManageDTO getDrugMainListByManageDTO = data;
            return getDrugMainListByManageDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetOrderListDTO getOrderList(OrderListQO vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            GetOrderListDTO data = new GetOrderListDTO();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future list = this.starRocksOrderUtils.queryOrderList(connection, userDataAuths, vo);
            Future total = this.starRocksOrderUtils.queryOrderListCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            if (!CollectionUtils.isEmpty((Collection)patientInfoDTOS)) {
                for (OrderListDto orderListDto : patientInfoDTOS) {
                    String orderAmount;
                    String patientName = orderListDto.getPatientName();
                    if (StringUtils.isEmpty((CharSequence)patientName)) {
                        orderListDto.setPatientInfo("");
                    } else {
                        Date birthDayFromIdCard;
                        Integer patientSex = orderListDto.getPatientSex();
                        String sex = "";
                        if (Objects.nonNull(patientSex)) {
                            if (1 == patientSex) {
                                sex = "\u7537";
                            } else if (2 == patientSex) {
                                sex = "\u5973";
                            }
                        }
                        String patientIdCard = orderListDto.getPatientIdCard();
                        String patientBirthday = orderListDto.getPatientBirthday();
                        String age = "";
                        if (StringUtils.isNotEmpty((CharSequence)patientBirthday)) {
                            DateTime parse = DateUtil.parse((CharSequence)patientBirthday, (String)"yyyy-MM-dd");
                            age = String.valueOf(DateUtils.getAgeByBirthDay((Date)parse));
                        } else if (!StringUtils.isEmpty((CharSequence)patientIdCard) && PatientInfoServiceImpl.isValidIDCard((String)patientIdCard) && Objects.nonNull(birthDayFromIdCard = DateUtils.getBirthDayFromIdCard((String)patientIdCard))) {
                            age = String.valueOf(DateUtils.getAgeByBirthDay((Date)birthDayFromIdCard));
                        }
                        orderListDto.setPatientInfo(patientName + "/" + sex + "/" + age);
                    }
                    String patientSplitName = orderListDto.getPatientSplitName();
                    if (StringUtils.isEmpty((CharSequence)patientSplitName)) {
                        orderListDto.setPatientSplitInfo("");
                    } else {
                        Date birthDayFromIdCard;
                        Integer patientSplitSex = orderListDto.getPatientSplitSex();
                        String sex = "";
                        if (Objects.nonNull(patientSplitSex)) {
                            if (1 == patientSplitSex) {
                                sex = "\u7537";
                            } else if (2 == patientSplitSex) {
                                sex = "\u5973";
                            }
                        }
                        String patientSplitIdCard = orderListDto.getPatientSplitIdCard();
                        String patientSplitBirthday = orderListDto.getPatientSplitBirthday();
                        String age = "";
                        if (StringUtils.isNotEmpty((CharSequence)patientSplitBirthday)) {
                            DateTime parse = DateUtil.parse((CharSequence)patientSplitBirthday, (String)"yyyy-MM-dd");
                            age = String.valueOf(DateUtils.getAgeByBirthDay((Date)parse));
                        } else if (!StringUtils.isEmpty((CharSequence)patientSplitIdCard) && PatientInfoServiceImpl.isValidIDCard((String)patientSplitIdCard) && Objects.nonNull(birthDayFromIdCard = DateUtils.getBirthDayFromIdCard((String)patientSplitIdCard))) {
                            age = String.valueOf(DateUtils.getAgeByBirthDay((Date)birthDayFromIdCard));
                        }
                        orderListDto.setPatientSplitInfo(patientSplitName + "/" + sex + "/" + age);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(orderAmount = orderListDto.getOrderAmount()))) continue;
                    BigDecimal bigDecimal = new BigDecimal(orderAmount);
                    BigDecimal bigDecimal1 = bigDecimal.setScale(2, RoundingMode.HALF_UP);
                    orderListDto.setOrderAmount(bigDecimal1.toString());
                }
            }
            data.setList(patientInfoDTOS);
            data.setTotal((Integer)total.get());
            GetOrderListDTO getOrderListDTO = data;
            return getOrderListDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrderListNewResDTO> getOrderMemberDayList(OrderListQO vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            ArrayList data = new ArrayList();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future list = this.starRocksOrderUtils.queryPatientsByOrderList(connection, userDataAuths, vo);
            List list2 = (List)list.get();
            return list2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isValidIDCard(String idCard) {
        String regex = "^[1-9]\\d{5}(18|19|20)\\d{2}(0\\d|10|11|12)([0-2]\\d|30|31)\\d{3}[0-9Xx]$";
        return idCard.matches(regex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcPatientListDTO pcProgramPatientList(PatientInFoListVo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            PcPatientListDTO data = new PcPatientListDTO();
            UserDataAuthsVO auth = this.querydataAuthsStr(connection, vo.getUserId());
            String storeId = this.queryUserStoreId(connection, vo.getUserId());
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, vo.getUserId());
            }
            Future list = this.starRocksPatientUtils.queryProgramPatientInfo(connection, storeId, userDataAuths, vo);
            Future total = this.starRocksPatientUtils.queryProgramPatientInfoCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            if (!CollectionUtils.isEmpty((Collection)patientInfoDTOS)) {
                for (PatientInfoDTO patientInfoDTO : patientInfoDTOS) {
                    this.setAge(patientInfoDTO);
                    String icdNameStr = patientInfoDTO.getIcdNameStr();
                    if (!StringUtils.isNotEmpty((CharSequence)icdNameStr)) continue;
                    String[] split = icdNameStr.split(",");
                    ArrayList<String> list1 = new ArrayList<String>();
                    for (int i = 0; i < split.length; ++i) {
                        list1.add(split[i]);
                    }
                    patientInfoDTO.setIcdName(list1);
                }
            }
            data.setList(patientInfoDTOS);
            data.setTotal((Integer)total.get());
            this.addPatientFromRedis(data, auth, storeId, vo, "INTEGRATE_PATIENT_NEW_LIST");
            PcPatientListDTO pcPatientListDTO = data;
            return pcPatientListDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcPatientListDTO pcPatientList(PatientInFoListVo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            PcPatientListDTO data = new PcPatientListDTO();
            UserDataAuthsVO auth = this.querydataAuthsStr(connection, vo.getUserId());
            String storeId = this.queryUserStoreId(connection, vo.getUserId());
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, vo.getUserId());
            }
            Future list = this.starRocksPatientUtils.queryPatientInfo(connection, userDataAuths, vo);
            Future total = this.starRocksPatientUtils.queryPatientInfoCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            if (!CollectionUtils.isEmpty((Collection)patientInfoDTOS)) {
                for (PatientInfoDTO patientInfoDTO : patientInfoDTOS) {
                    this.setArrayListStr(patientInfoDTO);
                    this.setAge(patientInfoDTO);
                    String icdNameStr = patientInfoDTO.getIcdNameStr();
                    if (!StringUtils.isNotEmpty((CharSequence)icdNameStr)) continue;
                    String[] split = icdNameStr.split(",");
                    ArrayList<String> list1 = new ArrayList<String>();
                    for (int i = 0; i < split.length; ++i) {
                        list1.add(split[i]);
                    }
                    patientInfoDTO.setIcdName(list1);
                }
            }
            data.setList(patientInfoDTOS);
            data.setTotal((Integer)total.get());
            this.addPatientFromRedis(data, auth, storeId, vo, "INTEGRATE_PATIENT_NEW_LIST");
            PcPatientListDTO pcPatientListDTO = data;
            return pcPatientListDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcPatientListDTO pcPatientListV2(PatientInFoListVo vo, Boolean exportFlag) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            PcPatientListDTO data = new PcPatientListDTO();
            UserDataAuthsVO auth = this.querydataAuthsStr(connection, vo.getUserId());
            String storeId = this.queryUserStoreId(connection, vo.getUserId());
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, vo.getUserId());
            }
            List<PatientInfoDTO> resultList = new ArrayList();
            vo.setXfFlag(Integer.valueOf(0));
            Future list = this.starRocksPatientUtils.queryPatientInfoV2(connection, storeId, userDataAuths, vo, exportFlag);
            List patientInfoDTOS = (List)list.get();
            if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo()) && ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getNoConsumerDay())) {
                vo.setXfFlag(Integer.valueOf(1));
                Future listTwo = this.starRocksPatientUtils.queryPatientInfoV2(connection, storeId, userDataAuths, vo, exportFlag);
                HashSet<String> idsInListTwo = new HashSet<String>();
                for (PatientInfoDTO item : (List)listTwo.get()) {
                    idsInListTwo.add(item.getPatientInfoId());
                }
                for (PatientInfoDTO item : patientInfoDTOS) {
                    if (idsInListTwo.contains(item.getPatientInfoId())) continue;
                    resultList.add(item);
                }
                if (ObjectUtil.isNotEmpty((Object)vo.getPageIndex())) {
                    PaginationHelper paginationHelper = new PaginationHelper(resultList, vo.getPageSize().intValue());
                    List pageItems = paginationHelper.getPageItems(vo.getPageIndex() - 1);
                    resultList = pageItems;
                    if (!exportFlag.booleanValue()) {
                        Integer totalNum = paginationHelper.getItemCount();
                        data.setTotal(totalNum);
                    }
                }
            } else {
                resultList = patientInfoDTOS;
                if (!exportFlag.booleanValue()) {
                    Future total = this.starRocksPatientUtils.queryPatientInfoCountV2(connection, userDataAuths, vo, exportFlag);
                    data.setTotal((Integer)total.get());
                }
            }
            if (!CollectionUtils.isEmpty(resultList)) {
                for (PatientInfoDTO patientInfoDTO : resultList) {
                    this.setArrayListStr(patientInfoDTO);
                    this.setAge(patientInfoDTO);
                    String icdNameStr = patientInfoDTO.getIcdNameStr();
                    if (!StringUtils.isNotEmpty((CharSequence)icdNameStr)) continue;
                    String[] split = icdNameStr.split(",");
                    ArrayList<String> list1 = new ArrayList<String>();
                    for (int i = 0; i < split.length; ++i) {
                        list1.add(split[i]);
                    }
                    patientInfoDTO.setIcdName(list1);
                }
            }
            data.setList(resultList);
            this.addPatientFromRedis(data, auth, storeId, vo, "INTEGRATE_PATIENT_NEW_LIST");
            PcPatientListDTO pcPatientListDTO = data;
            return pcPatientListDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPatientIdsByConditions(PatientInFoListVo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, vo.getUserId());
            }
            Future list = this.starRocksPatientUtils.getPatientIdsByConditions(connection, userDataAuths, vo);
            List list2 = (List)list.get();
            return list2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    private void addPatientFromRedis(PcPatientListDTO data, UserDataAuthsVO auth, String storeId, PatientInFoListVo vo, String redisKey) {
        List patientInfoDTOS = data.getList();
        long size = this.redisUtil.lGetListSize(redisKey);
        if (size > 0L) {
            List objects = this.redisUtil.lGet(redisKey, 0L, size);
            ArrayList<PatientInfoDTO> redisValue = new ArrayList<PatientInfoDTO>();
            for (int i = 0; i < objects.size(); ++i) {
                String obj = objects.get(i).toString().split("###")[0];
                PatientInfoDTO dto = (PatientInfoDTO)JSON.parseObject((String)obj, PatientInfoDTO.class);
                if (auth.getAuthType() != 0 && (auth.getAuthType() != 1 || !("@" + auth.getId()).contains("@" + objects.get(i).toString().split("###")[1])) && (auth.getAuthType() != 2 || !("@" + auth.getId()).contains("@" + objects.get(i).toString().split("###")[2]))) continue;
                boolean have = false;
                for (int j = 0; j < patientInfoDTOS.size(); ++j) {
                    if (!((PatientInfoDTO)patientInfoDTOS.get(j)).getPatientInfoId().equals(dto.getPatientInfoId())) continue;
                    have = true;
                    break;
                }
                if (have) continue;
                if (Objects.isNull(vo.getSearchContent())) {
                    vo.setSearchContent("");
                }
                if (Objects.isNull(dto.getPatientMemberNo())) {
                    dto.setPatientMemberNo("");
                }
                if (Objects.isNull(dto.getPatientIdCard())) {
                    dto.setPatientIdCard("");
                }
                if (!vo.needCache().booleanValue() || !dto.getPatientName().contains(vo.getSearchContent()) && !dto.getPatientPhone().contains(vo.getSearchContent()) && !dto.getPatientIdCard().contains(vo.getSearchContent()) && !dto.getPatientMemberNo().contains(vo.getSearchContent())) continue;
                redisValue.add(dto);
            }
            patientInfoDTOS.addAll(redisValue);
            data.setList(this.starRocksPatientUtils.dataPageFilter(data.getList(), storeId, vo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaffStatisticsDto getPatientStaffStatistics(StoreStatisticsVO statisticsVO) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            List userDataAuths = this.querydataAuthsPatient(connection, statisticsVO.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, statisticsVO.getUserId());
            }
            Future listFuture = this.starRocksStatisticsUtils.getAsyncPatientStaffStatistics(connection, userDataAuths, statisticsVO);
            int patientCount = 0;
            int addPatientCount = 0;
            List listDtos = (List)listFuture.get();
            for (StaffStatisticsListDto listDto : listDtos) {
                patientCount += listDto.getPatientCountList().intValue();
                addPatientCount += listDto.getAddPatientCountList().intValue();
            }
            Future staffStatistics = this.starRocksStatisticsUtils.getPatientStaffStatistics(connection, userDataAuths, statisticsVO);
            Future count = this.starRocksStatisticsUtils.getPatientStaffStatisticsCount(connection, userDataAuths, statisticsVO);
            List staffStatisticsListDtos = (List)staffStatistics.get();
            if (!CollectionUtils.isEmpty((Collection)staffStatisticsListDtos)) {
                for (StaffStatisticsListDto staffStatistic : staffStatisticsListDtos) {
                    double per = (double)staffStatistic.getAddPatientCountList().intValue() / (double)staffStatistic.getPatientCountList().intValue() * 100.0;
                    if (0.0 != per) {
                        staffStatistic.setAddPatientCountPer(new DecimalFormat("#.00").format(Math.abs(per)).toString() + "%");
                        continue;
                    }
                    staffStatistic.setAddPatientCountPer("0%");
                }
            }
            Integer total = (Integer)count.get();
            Integer pages = (total - 1) / statisticsVO.getPageSize() + 1;
            StaffStatisticsDto staffStatisticsDto = new StaffStatisticsDto();
            staffStatisticsDto.setStaffStatisticsListDtos(staffStatisticsListDtos);
            staffStatisticsDto.setPatientCount(Integer.valueOf(patientCount));
            staffStatisticsDto.setAddPatientCount(Integer.valueOf(addPatientCount));
            staffStatisticsDto.setTotal(total);
            staffStatisticsDto.setPageIndex(statisticsVO.getPageIndex());
            staffStatisticsDto.setPageSize(statisticsVO.getPageSize());
            staffStatisticsDto.setPages(pages);
            StaffStatisticsDto staffStatisticsDto2 = staffStatisticsDto;
            return staffStatisticsDto2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDrugMainStatusCount(DrugMainStatusCountVO vo) {
        Connection connection = null;
        try {
            Integer total;
            connection = this.starRocksDataSource.getConnection();
            UserDataAuthsVO auth = this.querydataAuthsStr(connection, vo.getUserId());
            String keyCache = "patient_getDrugMainStatusCount_cache:#" + auth.getAuthType() + "@" + auth.getId();
            Object obj = this.redisUtil.get(keyCache);
            if (Objects.nonNull(obj)) {
                log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u76f8\u540c\u6743\u9650\u7684\u6570\u636e");
                Integer n = Integer.valueOf(obj.toString());
                return n;
            }
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Integer n = total = this.queryAndSetPresCountCache(keyCache, userDataAuths, connection);
            return n;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer queryAndSetPresCountCache(String key, List<UserDataAuthsVO> userDataAuths, Connection connection) {
        try {
            if (Objects.isNull(connection)) {
                connection = this.starRocksDataSource.getConnection();
            }
            Future total = this.starRocksPresUtils.getDrugMainStatusCount(connection, userDataAuths);
            this.redisUtil.set(key, (Object)((Integer)total.get()).toString(), 900L);
            Integer n = (Integer)total.get();
            return n;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserDataAuthsVO> querydataAuthsPatient(Connection connection, String userId) {
        ArrayList<UserDataAuthsVO> list = new ArrayList<UserDataAuthsVO>();
        String querySql = "select * from  ps_user_data_auths puda where puda.user_id = '" + userId + "' and puda.status = 1 order by auth_type";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                UserDataAuthsVO dto = new UserDataAuthsVO();
                String id = rs.getString("auth_id");
                int authType = rs.getInt("auth_type");
                String pharmaceuticalCompanyId = rs.getString("parent_id");
                dto.setId(id);
                dto.setAuthType(Integer.valueOf(authType));
                dto.setPharmaceuticalCompanyId(pharmaceuticalCompanyId);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("starRocksConnectUtils querydataAuthsPatient: ", (Object)e.getMessage());
            log.error("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsPatient: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsPatient: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDataAuthsVO querydataAuthsStr(Connection connection, String userId) {
        UserDataAuthsVO result = new UserDataAuthsVO();
        String querySql = "select MIN(pudau.auth_type) auth_type, array_join(array_distinct(array_agg(pudau.auth_id)),'@') auth_id from ps_user_data_auths pudau where pudau.user_id = '" + userId + "' AND pudau.status = 1";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String id = rs.getString("auth_id");
                int authType = rs.getInt("auth_type");
                result.setId(id);
                result.setAuthType(Integer.valueOf(authType));
            }
        }
        catch (SQLException e) {
            log.error("starRocksConnectUtils querydataAuthsPatient: ", (Object)e.getMessage());
            log.error("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsPatient: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsPatient: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String queryUserStoreId(Connection connection, String userId) {
        String id = null;
        String querySql = "select store_id from ps_account_info where id = '" + userId + "'";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                id = rs.getString("store_id");
            }
        }
        catch (SQLException e) {
            log.error("starRocksConnectUtils queryUserStoreId: ", (Object)e.getMessage());
            log.error("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils queryUserStoreId: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils queryUserStoreId: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserDataAuthsVO> querydataAuthsPharmaceutical(Connection connection, String userId) {
        ArrayList<UserDataAuthsVO> list = new ArrayList<UserDataAuthsVO>();
        String querySql = "SELECT  any_value(pps.id) as id, any_value(puda.auth_type) as auth_type  FROM   ps_patient_store pps inner join  ps_user_data_auths puda on  pps.pharmaceutical_company_id = puda.auth_id  AND pps.status = 1 where  puda.status = 1  and puda.user_id = '" + userId + "' group by pps.id";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                UserDataAuthsVO dto = new UserDataAuthsVO();
                String id = rs.getString("id");
                dto.setId(id);
                dto.setAuthType(Integer.valueOf(1));
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("starRocksConnectUtils querydataAuthsPharmaceutical: ", (Object)e.getMessage());
            log.error("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsPharmaceutical: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsPharmaceutical: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UserDataAuthsVO> querydataAuthsCompanyId(Connection connection, String userId) {
        ArrayList<UserDataAuthsVO> list = new ArrayList<UserDataAuthsVO>();
        String querySql = "SELECT   ppss.id as id,   ppss.pharmaceutical_company_id as pharmaceutical_company_id  from    ps_patient_store ppss  where   ppss.pharmaceutical_company_id in (   SELECT    pps.pharmaceutical_company_id   from     ps_patient_store pps inner join    (    SELECT     pai.store_id    from      ps_account_info pai    where     pai.id = '" + userId + "') temp   on    pps.id = temp.store_id)";
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                UserDataAuthsVO dto = new UserDataAuthsVO();
                String id = rs.getString("id");
                String pharmaceuticalCompanyId = rs.getString("pharmaceutical_company_id");
                dto.setId(id);
                dto.setPharmaceuticalCompanyId(pharmaceuticalCompanyId);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("starRocksConnectUtils querydataAuthsCompanyId: ", (Object)e.getMessage());
            log.error("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsCompanyId: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("starRocksConnectUtils querydataAuthsCompanyId: ", (Object)e.getMessage());
                log.error("exception: ", (Throwable)e);
            }
        }
        return list;
    }

    private void setArrayListStr(PatientInfoDTO patientInfoDTO) {
        String str1;
        String str = patientInfoDTO.getPrescriptionListStr();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            String[] split = str.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (String s : split) {
                list.add(s);
            }
            patientInfoDTO.setPrescriptionList(list);
        }
        if (StringUtils.isNotEmpty((CharSequence)(str1 = patientInfoDTO.getStoreListStr()))) {
            String[] split1 = str1.split(",");
            ArrayList<String> list1 = new ArrayList<String>();
            for (String s : split1) {
                list1.add(s);
            }
            patientInfoDTO.setStoreList(list1);
        }
    }

    private void setAge(PatientInfoDTO patientInfoByPid) {
        if (StringUtils.isNotEmpty((CharSequence)patientInfoByPid.getPatientBirthday())) {
            patientInfoByPid.setAge(Integer.valueOf(PatientInfoServiceImpl.getAgeByBirthDay((Date)DateUtil.parse((CharSequence)patientInfoByPid.getPatientBirthday()))));
        } else if (StringUtils.isNotEmpty((CharSequence)patientInfoByPid.getPatientIdCard())) {
            try {
                Date birthDayFromIdCard = PatientInfoServiceImpl.getBirthDayFromIdCard((String)patientInfoByPid.getPatientIdCard());
                if (Objects.nonNull(birthDayFromIdCard)) {
                    patientInfoByPid.setAge(Integer.valueOf(PatientInfoServiceImpl.getAgeByBirthDay((Date)birthDayFromIdCard)));
                }
            }
            catch (ParseException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
    }

    public static Date getBirthDayFromIdCard(String idCard) throws ParseException {
        Date birth = null;
        if (idCard.length() == 18) {
            String year = idCard.substring(6).substring(0, 4);
            String month = idCard.substring(10).substring(0, 2);
            String day = idCard.substring(12).substring(0, 2);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            birth = format.parse(year + "-" + month + "-" + day);
        } else if (idCard.length() == 15) {
            String year = "19" + idCard.substring(6, 8);
            String month = idCard.substring(8, 10);
            String day = idCard.substring(10, 12);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            birth = format.parse(year + "-" + month + "-" + day);
        }
        return birth;
    }

    public static int getAgeByBirthDay(Date birthDay) {
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            return 0;
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramIndexStatisticsDTO programIndexStatistics(ProgramIndexStatisticsVo vo) {
        Object redisKey = null;
        if (StringUtils.isNotEmpty((CharSequence)vo.getStartDate())) {
            vo.setStartDate(vo.getStartDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getEndDate())) {
            vo.setEndDate(vo.getEndDate() + " 23:59:59");
        }
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            Future future = this.starRocksStatisticsUtils.programIndexStatistics(connection, vo);
            ProgramIndexStatisticsDTO result = (ProgramIndexStatisticsDTO)future.get();
            if (vo.isCacheFlag()) {
                // empty if block
            }
            ProgramIndexStatisticsDTO programIndexStatisticsDTO = result;
            return programIndexStatisticsDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreStatisticsDto getPatientStoreStatistics(StoreStatisticsVO statisticsVO) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            List userDataAuths = this.querydataAuthsPatient(connection, statisticsVO.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, statisticsVO.getUserId());
            }
            Future listFuture = this.starRocksStatisticsUtils.getPatientStoreStatistics(connection, userDataAuths, statisticsVO, Boolean.valueOf(false));
            int patientCount = 0;
            int addPatientCount = 0;
            List listDtos = (List)listFuture.get();
            for (StoreStatisticsListDto listDto : listDtos) {
                patientCount += listDto.getPatientCountList().intValue();
                addPatientCount += listDto.getAddPatientCountList().intValue();
            }
            Future staffStatistics = this.starRocksStatisticsUtils.getPatientStoreStatistics(connection, userDataAuths, statisticsVO, Boolean.valueOf(true));
            Future count = this.starRocksStatisticsUtils.getPatientStoreStatisticsCount(connection, userDataAuths, statisticsVO);
            List storeStatisticsListDtos = this.setStoreStaffStaticiseInfo(staffStatistics);
            Integer total = (Integer)count.get();
            Integer pages = (listDtos.size() - 1) / statisticsVO.getPageSize() + 1;
            StoreStatisticsDto staffStatisticsDto = new StoreStatisticsDto();
            staffStatisticsDto.setStoreStatisticsListDtos(storeStatisticsListDtos);
            staffStatisticsDto.setPatientCount(total);
            staffStatisticsDto.setAddPatientCount(Integer.valueOf(addPatientCount));
            staffStatisticsDto.setTotal(Long.valueOf(listDtos.size()));
            staffStatisticsDto.setPageIndex(statisticsVO.getPageIndex());
            staffStatisticsDto.setPageSize(statisticsVO.getPageSize());
            staffStatisticsDto.setPages(pages);
            StoreStatisticsDto storeStatisticsDto = staffStatisticsDto;
            return storeStatisticsDto;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MedicalInsuranceVo getMedicalInsurance(MedicalInsuranceListQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            MedicalInsuranceVo data = new MedicalInsuranceVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future listFuture = this.starRocksOrderUtils.queryMedicalInsuranceList(connection, userDataAuths, vo, false);
            BigDecimal totalConsumerAmount = new BigDecimal("0.00");
            BigDecimal totalCoordinatedPay = new BigDecimal("0.00");
            List listDtos = (List)listFuture.get();
            for (MedicalInsuranceListVo listDto : listDtos) {
                totalConsumerAmount = totalConsumerAmount.add(ObjectUtil.isEmpty((Object)listDto.getConsumerAmount()) ? new BigDecimal("0.00") : new BigDecimal(listDto.getConsumerAmount()));
                totalCoordinatedPay = totalCoordinatedPay.add(ObjectUtil.isEmpty((Object)listDto.getCoordinatedPayStr()) ? new BigDecimal("0.00") : new BigDecimal(listDto.getCoordinatedPayStr()));
            }
            Future list = this.starRocksOrderUtils.queryMedicalInsuranceList(connection, userDataAuths, vo, vo.getIsPage().booleanValue());
            Future total = this.starRocksOrderUtils.queryMedicalInsuranceListCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            this.transMedicalInsuranceData(patientInfoDTOS);
            if (ObjectUtil.isEmpty((Object)patientInfoDTOS)) {
                patientInfoDTOS = Lists.newArrayList();
            }
            data.setList(patientInfoDTOS);
            totalConsumerAmount = totalConsumerAmount.setScale(2, RoundingMode.HALF_UP);
            totalCoordinatedPay = totalCoordinatedPay.setScale(2, RoundingMode.HALF_UP);
            data.setTotalConsumerAmount(totalConsumerAmount.toString());
            data.setTotalCoordinatedPay(totalCoordinatedPay.toString());
            data.setTotal(Integer.valueOf(ObjectUtil.isEmpty(total.get()) ? 0 : (Integer)total.get()));
            MedicalInsuranceVo medicalInsuranceVo = data;
            return medicalInsuranceVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortraitRmfVo getRmfAvg() {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            MedicalInsuranceVo data = new MedicalInsuranceVo();
            List userDataAuths = this.querydataAuthsPatient(connection, null);
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, null);
                }
            }
            Future list = this.starRocksPatientUtils.getRmfAvg(connection, userDataAuths, null);
            PortraitRmfVo portraitRmfVo = new PortraitRmfVo();
            List portraitRmfDtos = (List)list.get();
            int frequencyCount = portraitRmfDtos.stream().map(PortraitRmfDto::getFrequencyCount).mapToInt(Integer::parseInt).sum();
            Double orderAmount = portraitRmfDtos.stream().map(PortraitRmfDto::getOrderAmount).mapToDouble(Double::parseDouble).sum();
            int lastTime = portraitRmfDtos.stream().map(PortraitRmfDto::getLastTime).mapToInt(Integer::parseInt).sum();
            BigDecimal lastTimePer = new BigDecimal(lastTime).divide(new BigDecimal(frequencyCount), 4);
            BigDecimal frequencyCountPer = new BigDecimal(frequencyCount).divide(new BigDecimal(frequencyCount), 4);
            BigDecimal orderAmountPer = new BigDecimal(orderAmount).divide(new BigDecimal(frequencyCount), 4);
            portraitRmfVo.setRecencyAvg(lastTimePer.toString());
            portraitRmfVo.setFrequencyAvg(frequencyCountPer.toString());
            portraitRmfVo.setMonetaryAvg(orderAmountPer.toString());
            portraitRmfVo.setPortraitRmfDtos(portraitRmfDtos);
            PortraitRmfVo portraitRmfVo2 = portraitRmfVo;
            return portraitRmfVo2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberPatientDto> queryPatientIdById() {
        Connection connection = null;
        try {
            List patientInfoDTOS;
            connection = this.starRocksDataSource.getConnection();
            Future list = this.starRocksPatientUtils.queryPatientIdById(connection);
            List list2 = patientInfoDTOS = (List)list.get();
            return list2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getConsumerPatientIdByCondition(MemberQueryConditionQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            Future list = this.starRocksPatientUtils.getConsumerPatientIdByCondition(connection, vo);
            List list2 = (List)list.get();
            return list2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object queryPortraitListByType(MemberQueryListQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            MemberQueryListVo data = new MemberQueryListVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future list = this.starRocksPatientUtils.queryPortraitListByType(connection, userDataAuths, vo);
            Future total = this.starRocksPatientUtils.queryPortraitListByTypeCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            data.setList(patientInfoDTOS);
            data.setTotal(Integer.valueOf(ObjectUtil.isEmpty(total.get()) ? 0 : (Integer)total.get()));
            MemberQueryListVo memberQueryListVo = data;
            return memberQueryListVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object queryPortraitDetail(MemberQueryDetailQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            MemberQueryListVo data = new MemberQueryListVo();
            List userDataAuths = this.querydataAuthsPatient(connection, null);
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, null);
                }
            }
            Future list = this.starRocksPatientUtils.queryPortraitDetail(connection, userDataAuths, vo);
            Object v = list.get();
            return v;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiseaseStatisticsDto getPatientDiseaseStatistics(DiseaseStatisticsVO statisticsVO) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            List userDataAuths = this.querydataAuthsPatient(connection, statisticsVO.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, statisticsVO.getUserId());
            }
            Future staffStatistics = this.starRocksStatisticsUtils.getPatientDiseaseStatistics(connection, userDataAuths, statisticsVO);
            Future patientTotalCount = this.starRocksPatientUtils.getPatientTotalCount(connection, userDataAuths);
            Future count = this.starRocksStatisticsUtils.getPatientDiseaseCount(connection, userDataAuths, statisticsVO);
            List staffStatisticsListDtos = (List)staffStatistics.get();
            Integer patientListCount = (Integer)patientTotalCount.get();
            if (CollectionUtil.isNotEmpty((Collection)staffStatisticsListDtos)) {
                for (DiseaseStatisticsListDto diseaseStatistic : staffStatisticsListDtos) {
                    double per = (double)diseaseStatistic.getPatientCountList().intValue() / (double)patientListCount.intValue() * 100.0;
                    diseaseStatistic.setAllPatientCountList(patientListCount);
                    if (0.0 != per) {
                        String str = BigDecimal.valueOf(per).setScale(2, 4).toString() + "%";
                        diseaseStatistic.setAddPatientCountPer(str);
                        continue;
                    }
                    diseaseStatistic.setAddPatientCountPer("0%");
                }
            }
            int patientCount = 0;
            List listDtos = (List)staffStatistics.get();
            for (DiseaseStatisticsListDto listDto : listDtos) {
                patientCount += listDto.getPatientCountList().intValue();
            }
            Integer total = (Integer)count.get();
            Integer pages = (total - 1) / statisticsVO.getPageSize() + 1;
            DiseaseStatisticsDto diseaseStatisticsDto = new DiseaseStatisticsDto();
            diseaseStatisticsDto.setDiseaseStatisticsListDtos(staffStatisticsListDtos);
            diseaseStatisticsDto.setPatientCount(Integer.valueOf(patientCount));
            diseaseStatisticsDto.setAddPatientCount(patientListCount);
            diseaseStatisticsDto.setTotal(total);
            diseaseStatisticsDto.setPageIndex(statisticsVO.getPageIndex());
            diseaseStatisticsDto.setPageSize(statisticsVO.getPageSize());
            diseaseStatisticsDto.setPages(pages);
            DiseaseStatisticsDto diseaseStatisticsDto2 = diseaseStatisticsDto;
            return diseaseStatisticsDto2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesAnalysisDrugVo querySalesAnalysisDrugList(SalesAnalysisListQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            SalesAnalysisDrugVo data = new SalesAnalysisDrugVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future listFuture = this.starRocksStatisticsUtils.querySalesAnalysisDrugList(connection, userDataAuths, vo, Boolean.valueOf(false));
            BigDecimal salesTotalNums = new BigDecimal("0.00");
            BigDecimal salesPersonTotalNums = new BigDecimal("0.00");
            BigDecimal salesOrderTotalNums = new BigDecimal("0.00");
            List listDtos = (List)listFuture.get();
            for (SalesAnalysisDrugDto listDto : listDtos) {
                salesTotalNums = salesTotalNums.add(ObjectUtil.isEmpty((Object)listDto.getSaleCount()) ? new BigDecimal("0.00") : new BigDecimal(listDto.getSaleCount()));
                salesPersonTotalNums = salesPersonTotalNums.add(ObjectUtil.isEmpty((Object)listDto.getSalePersonCount()) ? new BigDecimal("0.00") : new BigDecimal(listDto.getSalePersonCount()));
                salesOrderTotalNums = salesOrderTotalNums.add(ObjectUtil.isEmpty((Object)listDto.getSaleOrderCount()) ? new BigDecimal("0.00") : new BigDecimal(listDto.getSaleOrderCount()));
            }
            salesTotalNums = salesTotalNums.setScale(2, RoundingMode.HALF_UP);
            salesPersonTotalNums = salesPersonTotalNums.setScale(0, RoundingMode.HALF_UP);
            salesOrderTotalNums = salesOrderTotalNums.setScale(0, RoundingMode.HALF_UP);
            Future list = this.starRocksStatisticsUtils.querySalesAnalysisDrugList(connection, userDataAuths, vo, vo.getIsPage());
            Future total = this.starRocksStatisticsUtils.querySalesAnalysisDrugListCount(connection, userDataAuths, vo);
            data.setDataList((List)list.get());
            data.setDataSize(Long.valueOf(ObjectUtil.isEmpty(total.get()) ? 0L : Long.valueOf(((Integer)total.get()).intValue())));
            data.setSalesTotalNums(salesTotalNums.toString());
            data.setSalesPersonTotalNums(salesPersonTotalNums.toString());
            data.setSalesOrderTotalNums(salesOrderTotalNums.toString());
            SalesAnalysisDrugVo salesAnalysisDrugVo = data;
            return salesAnalysisDrugVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesAnalysisPersonVo querySalesAnalysisPersonByDrug(SalesAnalysisListQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            SalesAnalysisPersonVo data = new SalesAnalysisPersonVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future list = this.starRocksStatisticsUtils.querySalesAnalysisPersonByDrug(connection, userDataAuths, vo, vo.getIsPage());
            Future total = this.starRocksStatisticsUtils.querySalesAnalysisPersonByDrugCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            this.transSalesAnalysisData(patientInfoDTOS);
            if (ObjectUtil.isEmpty((Object)patientInfoDTOS)) {
                patientInfoDTOS = Lists.newArrayList();
            }
            data.setList(patientInfoDTOS);
            data.setTotal(Integer.valueOf(ObjectUtil.isEmpty(total.get()) ? 0 : (Integer)total.get()));
            SalesAnalysisPersonVo salesAnalysisPersonVo = data;
            return salesAnalysisPersonVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesAnalysisStoreVo querySalesAnalysisStoreList(SalesAnalysisListQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            SalesAnalysisStoreVo data = new SalesAnalysisStoreVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future listFuture = this.starRocksStatisticsUtils.querySalesAnalysisStoreList(connection, userDataAuths, vo, Boolean.valueOf(false));
            BigDecimal salesTotalAmount = new BigDecimal("0.00");
            List listDtos = (List)listFuture.get();
            for (SalesAnalysisStoreDto listDto : listDtos) {
                salesTotalAmount = salesTotalAmount.add(ObjectUtil.isEmpty((Object)listDto.getSaleAmount()) ? new BigDecimal("0.00") : new BigDecimal(listDto.getSaleAmount()));
            }
            salesTotalAmount = salesTotalAmount.setScale(2, RoundingMode.HALF_UP);
            Future list = this.starRocksStatisticsUtils.querySalesAnalysisStoreList(connection, userDataAuths, vo, vo.getIsPage());
            Future total = this.starRocksStatisticsUtils.querySalesAnalysisStoreListCount(connection, userDataAuths, vo);
            data.setDataList((List)list.get());
            data.setDataSize(Long.valueOf(ObjectUtil.isEmpty(total.get()) ? 0L : Long.valueOf(((Integer)total.get()).intValue())));
            data.setSalesTotalAmount(salesTotalAmount.toString());
            SalesAnalysisStoreVo salesAnalysisStoreVo = data;
            return salesAnalysisStoreVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesAnalysisAmountVo querySalesAnalysisAmountList(SalesAnalysisListQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            SalesAnalysisAmountVo data = new SalesAnalysisAmountVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future listFuture = this.starRocksStatisticsUtils.querySalesAnalysisAmountList(connection, userDataAuths, vo, false, true);
            BigDecimal salesTotalAmount = new BigDecimal("0.00");
            List listDtos = (List)listFuture.get();
            for (SalesAnalysisAmountDto listDto : listDtos) {
                salesTotalAmount = salesTotalAmount.add(ObjectUtil.isEmpty((Object)listDto.getSaleAmount()) ? new BigDecimal("0.00") : new BigDecimal(listDto.getSaleAmount()));
            }
            salesTotalAmount = salesTotalAmount.setScale(2, RoundingMode.HALF_UP);
            Future list = this.starRocksStatisticsUtils.querySalesAnalysisAmountList(connection, userDataAuths, vo, vo.getIsPage().booleanValue(), false);
            Future total = this.starRocksStatisticsUtils.querySalesAnalysisAmountListCount(connection, userDataAuths, vo);
            List salesAnalysisAmountDtos = (List)list.get();
            this.transSalesAnalysisData(salesAnalysisAmountDtos);
            if (ObjectUtil.isEmpty((Object)salesAnalysisAmountDtos)) {
                salesAnalysisAmountDtos = Lists.newArrayList();
            }
            data.setDataList(salesAnalysisAmountDtos);
            data.setDataSize(Long.valueOf(ObjectUtil.isEmpty(total.get()) ? 0L : Long.valueOf(((Integer)total.get()).intValue())));
            data.setSalesTotalAmount(salesTotalAmount.toString());
            SalesAnalysisAmountVo salesAnalysisAmountVo = data;
            return salesAnalysisAmountVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackListInfoVo getBackListList(BackListInfoDto vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            BackListInfoVo data = new BackListInfoVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, vo.getUserId());
            }
            Future list = this.starRocksPatientUtils.getBackListList(connection, userDataAuths, vo, vo.getIsPage());
            Future total = this.starRocksPatientUtils.getBackListListCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            if (ObjectUtil.isEmpty((Object)patientInfoDTOS)) {
                patientInfoDTOS = Lists.newArrayList();
            }
            data.setList(patientInfoDTOS);
            data.setTotal(Integer.valueOf(ObjectUtil.isEmpty(total.get()) ? 0 : (Integer)total.get()));
            BackListInfoVo backListInfoVo = data;
            return backListInfoVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatientOrderStaticsVo getPatientBuyDrugOrderList(PatientOrderStaticsQo vo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            PatientOrderStaticsVo data = new PatientOrderStaticsVo();
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, vo.getUserId());
                }
            }
            Future list = this.starRocksStatisticsUtils.queryPatientBuyDrugOrderList(connection, userDataAuths, vo);
            Future total = this.starRocksStatisticsUtils.queryPatientBuyDrugOrderListCount(connection, userDataAuths, vo);
            List patientInfoDTOS = (List)list.get();
            data.setList(patientInfoDTOS);
            data.setTotal((Integer)total.get());
            PatientOrderStaticsVo patientOrderStaticsVo = data;
            return patientOrderStaticsVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LsStandardMedicationStaticsVo getLsStandardMedicationStaticsList(LsStandardMedicationStaticsQo qo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            List userDataAuths = this.querydataAuthsPatient(connection, qo.getUserId());
            LsStandardMedicationStaticsVo data = new LsStandardMedicationStaticsVo();
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, qo.getUserId());
                }
            }
            Future future = this.starRocksStatisticsUtils.queryLsStandardMedicalList(connection, userDataAuths, qo);
            Future total = this.starRocksStatisticsUtils.queryLsStandardMedicalListCount(connection, userDataAuths, qo);
            List list = (List)future.get();
            if (Objects.equals("2", qo.getStaticFlag())) {
                for (LsStandardMedicationStaticsDto lsStandardMedicationStaticsVo : list) {
                    lsStandardMedicationStaticsVo.setStoreIdList(qo.getStoreIds());
                }
            }
            data.setList(list);
            data.setTotal((Integer)total.get());
            LsStandardMedicationStaticsVo lsStandardMedicationStaticsVo = data;
            return lsStandardMedicationStaticsVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LsStandardMedicationPatientStaticsVo getLsStandardMedicationPatientStaticsList(LsStandardMedicationPatientStaticsQo qo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            List userDataAuths = this.querydataAuthsPatient(connection, qo.getUserId());
            LsStandardMedicationPatientStaticsVo data = new LsStandardMedicationPatientStaticsVo();
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                if (0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = new ArrayList();
                } else if (1 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType()) {
                    userDataAuths = this.querydataAuthsPharmaceutical(connection, qo.getUserId());
                }
            }
            Future future = this.starRocksStatisticsUtils.queryLsStandardMedicaPatientList(connection, userDataAuths, qo);
            Future total = this.starRocksStatisticsUtils.queryLsStandardMedicalPatientListCount(connection, userDataAuths, qo);
            List list = (List)future.get();
            data.setList(list);
            data.setTotal((Integer)total.get());
            LsStandardMedicationPatientStaticsVo lsStandardMedicationPatientStaticsVo = data;
            return lsStandardMedicationPatientStaticsVo;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PcPatientListDTO pcPatientListV3(PatientInFoListVo vo, boolean exportFlag) {
        Connection connection = null;
        try {
            List patientInfoDTOS;
            connection = this.starRocksDataSource.getConnection();
            PcPatientListDTO data = new PcPatientListDTO();
            UserDataAuthsVO auth = this.querydataAuthsStr(connection, vo.getUserId());
            String storeId = this.queryUserStoreId(connection, vo.getUserId());
            List userDataAuths = this.querydataAuthsPatient(connection, vo.getUserId());
            if (!CollectionUtils.isEmpty((Collection)userDataAuths)) {
                userDataAuths = 0 == ((UserDataAuthsVO)userDataAuths.get(0)).getAuthType() ? new ArrayList() : this.querydataAuthsCompanyId(connection, vo.getUserId());
            }
            Future list = this.starRocksPatientUtils.queryPatientInfoV3(connection, storeId, userDataAuths, vo, exportFlag);
            if (!exportFlag) {
                Future total = this.starRocksPatientUtils.queryPatientInfoCountV3(connection, userDataAuths, vo, exportFlag);
                data.setTotal((Integer)total.get());
            }
            if (!CollectionUtils.isEmpty((Collection)(patientInfoDTOS = (List)list.get()))) {
                for (PatientInfoDTO patientInfoDTO : patientInfoDTOS) {
                    this.setArrayListStr(patientInfoDTO);
                    this.setAge(patientInfoDTO);
                    String icdNameStr = patientInfoDTO.getIcdNameStr();
                    if (!StringUtils.isNotEmpty((CharSequence)icdNameStr)) continue;
                    String[] split = icdNameStr.split(",");
                    ArrayList<String> list1 = new ArrayList<String>();
                    for (int i = 0; i < split.length; ++i) {
                        list1.add(split[i]);
                    }
                    patientInfoDTO.setIcdName(list1);
                }
            }
            data.setList(patientInfoDTOS);
            this.addPatientFromRedis(data, auth, storeId, vo, "INTEGRATE_PATIENT_SPILT_NEW_LIST");
            PcPatientListDTO pcPatientListDTO = data;
            return pcPatientListDTO;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    private void transSalesAnalysisData(List<? extends SalesAnalysisCommonDto> dtos) {
        if (!CollectionUtils.isEmpty(dtos)) {
            for (int i = 0; i < dtos.size(); ++i) {
                String[] orderNoStr = dtos.get(i).getOrderNo().split("@");
                String[] saleStoreNameStr = dtos.get(i).getSaleStoreName().split("@");
                String[] saleStoreNoStr = dtos.get(i).getSaleStoreNo().split("@");
                String[] orderBuyTimeStr = dtos.get(i).getOrderBuyTime().split("@");
                String[] orderAmountStr = dtos.get(i).getOrderAmount().split("@");
                String[] drugInfoStr = dtos.get(i).getDrugInfo().split("@");
                this.calAgeAndSetPatientData(dtos, i);
                ArrayList childDtos = Lists.newArrayList();
                for (int j = 0; j < orderNoStr.length; ++j) {
                    SalesAnalysisPersonChildDto salesAnalysisPersonChildDto = new SalesAnalysisPersonChildDto();
                    salesAnalysisPersonChildDto.setOrderNo(orderNoStr[j]);
                    salesAnalysisPersonChildDto.setSaleStoreName(saleStoreNameStr[j]);
                    salesAnalysisPersonChildDto.setSaleStoreNo(saleStoreNoStr[j]);
                    salesAnalysisPersonChildDto.setOrderBuyTime(orderBuyTimeStr[j]);
                    salesAnalysisPersonChildDto.setOrderAmount(orderAmountStr[j]);
                    salesAnalysisPersonChildDto.setDrugInfo(ObjectUtil.isEmpty((Object)drugInfoStr) ? "" : drugInfoStr[j]);
                    childDtos.add(salesAnalysisPersonChildDto);
                }
                dtos.get(i).setSalesAnalysisPersonChildDtos((List)childDtos);
            }
        }
    }

    private void calAgeAndSetPatientData(List<? extends SalesAnalysisCommonDto> dtos, int i) {
        String patientName = dtos.get(i).getPatientName();
        String patientSex = dtos.get(i).getPatientSex();
        StringBuilder patientInfo = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)dtos.get(i).getPatientBirthday())) {
            DateTime parse = DateUtil.parse((CharSequence)dtos.get(i).getPatientBirthday(), (String)"yyyy-MM-dd");
            this.setPatientInfo(dtos, i, patientName, patientSex, patientInfo, (Date)parse);
        } else if (StringUtils.isNotEmpty((CharSequence)dtos.get(i).getIdCard()) && PatientInfoServiceImpl.isValidIDCard((String)dtos.get(i).getIdCard())) {
            try {
                Date birthDayFromIdCard = DateUtils.getBirthDayFromIdCard((String)dtos.get(i).getIdCard());
                this.setPatientInfo(dtos, i, patientName, patientSex, patientInfo, birthDayFromIdCard);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void setPatientInfo(List<? extends SalesAnalysisCommonDto> dtos, int i, String patientName, String patientSex, StringBuilder patientInfo, Date birthDayFromIdCard) {
        int ageByBirthDay = DateUtils.getAgeByBirthDay((Date)birthDayFromIdCard);
        patientInfo.append(patientName).append("/").append(patientSex).append("/").append(ageByBirthDay);
        dtos.get(i).setPatientInfo(patientInfo.toString());
    }

    private void transMedicalInsuranceData(List<MedicalInsuranceListVo> patientInfoDTOS) {
        if (!CollectionUtils.isEmpty(patientInfoDTOS)) {
            for (int i = 0; i < patientInfoDTOS.size(); ++i) {
                String[] memberNoStr = patientInfoDTOS.get(i).getMemberNo().split("@");
                String[] memberNameStr = patientInfoDTOS.get(i).getMemberName().split("@");
                String[] idCardNoStr = patientInfoDTOS.get(i).getIdCardNo().split("@");
                String[] medicalTypeStr = patientInfoDTOS.get(i).getMedicalType().split("@");
                String[] memberTypeStr = patientInfoDTOS.get(i).getMemberType().split("@");
                String[] coordinatedPayStr = patientInfoDTOS.get(i).getCoordinatedPay().split("@");
                ArrayList medicalInsuranceSubVos = Lists.newArrayList();
                HashMap<String, String> distictMap = new HashMap<String, String>();
                for (int j = 0; j < memberNoStr.length; ++j) {
                    MedicalInsuranceSubVo medicalInsuranceSubVo2 = new MedicalInsuranceSubVo();
                    medicalInsuranceSubVo2.setMemberNo(memberNoStr[j]);
                    medicalInsuranceSubVo2.setMemberName(memberNameStr[j]);
                    medicalInsuranceSubVo2.setMedicalType(medicalTypeStr[j]);
                    medicalInsuranceSubVo2.setMemberType(memberTypeStr[j]);
                    medicalInsuranceSubVo2.setCoordinatedPay(new BigDecimal(coordinatedPayStr[j]).setScale(2, RoundingMode.HALF_UP).toString());
                    medicalInsuranceSubVo2.setIdCardNo(idCardNoStr[j]);
                    if (ObjectUtil.isEmpty(distictMap.get(medicalInsuranceSubVo2.getMemberNo()))) {
                        distictMap.put(medicalInsuranceSubVo2.getMemberNo(), medicalInsuranceSubVo2.getCoordinatedPay());
                        medicalInsuranceSubVos.add(medicalInsuranceSubVo2);
                        continue;
                    }
                    BigDecimal s = new BigDecimal((String)distictMap.get(medicalInsuranceSubVo2.getMemberNo()));
                    BigDecimal add = s.add(new BigDecimal(coordinatedPayStr[j]).setScale(2, RoundingMode.HALF_UP));
                    distictMap.put(medicalInsuranceSubVo2.getMemberNo(), add.toString());
                }
                medicalInsuranceSubVos.forEach(medicalInsuranceSubVo -> {
                    if (ObjectUtil.isNotEmpty(distictMap.get(medicalInsuranceSubVo.getMemberNo()))) {
                        medicalInsuranceSubVo.setCoordinatedPay((String)distictMap.get(medicalInsuranceSubVo.getMemberNo()));
                    }
                });
                patientInfoDTOS.get(i).setMedicalInsuranceSubVos((List)medicalInsuranceSubVos);
            }
        }
    }

    private List<StoreStatisticsListDto> setStoreStaffStaticiseInfo(Future<List<StoreStatisticsListDto>> staffStatistics) throws InterruptedException, ExecutionException {
        List<StoreStatisticsListDto> storeStatisticsListDtos = staffStatistics.get();
        StringBuffer sb = null;
        if (!CollectionUtils.isEmpty(storeStatisticsListDtos)) {
            for (StoreStatisticsListDto storeStatisticsListDto : storeStatisticsListDtos) {
                double per = (double)storeStatisticsListDto.getAddPatientCountList().intValue() / (double)storeStatisticsListDto.getPatientCountList().intValue() * 100.0;
                if (0.0 != per) {
                    String str = BigDecimal.valueOf(per).setScale(2, 4).toString() + "%";
                    storeStatisticsListDto.setAddPatientCountPer(str);
                } else {
                    storeStatisticsListDto.setAddPatientCountPer("0%");
                }
                sb = new StringBuffer();
                if (StringUtils.isNotEmpty((CharSequence)storeStatisticsListDto.getProvince())) {
                    sb.append(storeStatisticsListDto.getProvince()).append("/");
                }
                if (StringUtils.isNotEmpty((CharSequence)storeStatisticsListDto.getCity())) {
                    sb.append(storeStatisticsListDto.getCity()).append("/");
                }
                if (StringUtils.isNotEmpty((CharSequence)storeStatisticsListDto.getDistrict())) {
                    sb.append(storeStatisticsListDto.getDistrict());
                }
                storeStatisticsListDto.setDistrict(sb.toString());
            }
        }
        return storeStatisticsListDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LsStandardMedicationStaticsDpVo getLsStandardMedicalStaticListDp(LsStandardMedicationStaticsQo qo) {
        Connection connection = null;
        try {
            connection = this.starRocksDataSource.getConnection();
            String buyDrugStartTime = qo.getBuyDrugStartTime();
            String buyDrugEndTime = qo.getBuyDrugEndTime();
            qo.setDrugIds(qo.getDrugCodes());
            Future future = this.starRocksStatisticsUtils.queryLsStandardMedicalListnew(connection, qo);
            LsStandardMedicationStaticsDpVo lsStandardMedicationStaticsDpVo = (LsStandardMedicationStaticsDpVo)future.get();
            qo.setBuyDrugStartTime(DateUtils.getTimebefor((String)qo.getBuyDrugStartTime(), (int)Integer.valueOf(qo.getDaysRange())));
            qo.setBuyDrugEndTime(DateUtils.getTimebefor((String)qo.getBuyDrugEndTime(), (int)Integer.valueOf(qo.getDaysRange())));
            Future futurelhb = this.starRocksStatisticsUtils.queryLsStandardMedicalListnew(connection, qo);
            LsStandardMedicationStaticsDpVo lsStandardMedicationStaticsDpVohb = (LsStandardMedicationStaticsDpVo)futurelhb.get();
            qo.setBuyDrugStartTime(DateUtils.getLastYearDate((String)buyDrugStartTime));
            qo.setBuyDrugEndTime(DateUtils.getLastYearDate((String)buyDrugEndTime));
            Future futureltb = this.starRocksStatisticsUtils.queryLsStandardMedicalListnew(connection, qo);
            LsStandardMedicationStaticsDpVo lsStandardMedicationStaticsDpVotb = (LsStandardMedicationStaticsDpVo)futureltb.get();
            lsStandardMedicationStaticsDpVo.setHbPeopleNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getPeopleNum(), (String)lsStandardMedicationStaticsDpVohb.getPeopleNum()));
            lsStandardMedicationStaticsDpVo.setHbAvgBuyNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getAvgBuyNum(), (String)lsStandardMedicationStaticsDpVohb.getAvgBuyNum()));
            lsStandardMedicationStaticsDpVo.setHbStandardMedicationNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getStandardMedicationNum(), (String)lsStandardMedicationStaticsDpVohb.getStandardMedicationNum()));
            lsStandardMedicationStaticsDpVo.setHbNoStandardMedicationNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getNoStandardMedicationNum(), (String)lsStandardMedicationStaticsDpVohb.getNoStandardMedicationNum()));
            lsStandardMedicationStaticsDpVo.setHbGreaterThanTwelve(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getGreaterThanTwelve(), (String)lsStandardMedicationStaticsDpVohb.getGreaterThanTwelve()));
            lsStandardMedicationStaticsDpVo.setHbGreaterThanFifteen(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getGreaterThanFifteen(), (String)lsStandardMedicationStaticsDpVohb.getGreaterThanFifteen()));
            lsStandardMedicationStaticsDpVo.setHbStandardMedicationRate(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getStandardMedicationRate(), (String)lsStandardMedicationStaticsDpVohb.getStandardMedicationRate()));
            lsStandardMedicationStaticsDpVo.setTbPeopleNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getPeopleNum(), (String)lsStandardMedicationStaticsDpVotb.getPeopleNum()));
            lsStandardMedicationStaticsDpVo.setTbAvgBuyNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getAvgBuyNum(), (String)lsStandardMedicationStaticsDpVotb.getAvgBuyNum()));
            lsStandardMedicationStaticsDpVo.setTbStandardMedicationNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getStandardMedicationNum(), (String)lsStandardMedicationStaticsDpVotb.getStandardMedicationNum()));
            lsStandardMedicationStaticsDpVo.setTbNoStandardMedicationNum(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getNoStandardMedicationNum(), (String)lsStandardMedicationStaticsDpVotb.getNoStandardMedicationNum()));
            lsStandardMedicationStaticsDpVo.setTbGreaterThanTwelve(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getGreaterThanTwelve(), (String)lsStandardMedicationStaticsDpVotb.getGreaterThanTwelve()));
            lsStandardMedicationStaticsDpVo.setTbGreaterThanFifteen(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getGreaterThanFifteen(), (String)lsStandardMedicationStaticsDpVotb.getGreaterThanFifteen()));
            lsStandardMedicationStaticsDpVo.setTbStandardMedicationRate(PatientInfoServiceImpl.calculateYearlyGrowth((String)lsStandardMedicationStaticsDpVo.getStandardMedicationRate(), (String)lsStandardMedicationStaticsDpVotb.getStandardMedicationRate()));
            lsStandardMedicationStaticsDpVo.setStandardMedicationRate(new BigDecimal(lsStandardMedicationStaticsDpVo.getStandardMedicationRate()).multiply(new BigDecimal("100")) + "%");
            LsStandardMedicationStaticsDpVo lsStandardMedicationStaticsDpVo2 = lsStandardMedicationStaticsDpVo;
            return lsStandardMedicationStaticsDpVo2;
        }
        catch (Exception e) {
            log.info("exception :{}", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.info("exception :{}", (Throwable)e);
            }
        }
        return null;
    }

    public static String calculateYearlyGrowth(String currentPeriodValue, String previousPeriodValue) {
        try {
            double current = Double.parseDouble(currentPeriodValue);
            double previous = Double.parseDouble(previousPeriodValue);
            if (previous == 0.0) {
                return "0.00%";
            }
            double growthRate = (current - previous) / previous * 100.0;
            return String.format("%.2f%%", growthRate);
        }
        catch (NumberFormatException e) {
            return "0.00%";
        }
    }

    public static void main(String[] args) {
        String s = PatientInfoServiceImpl.calculateYearlyGrowth((String)"8", (String)"12");
        System.out.println(s);
    }
}

