/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.dto.GetDrugMainListByManageDTO;
import com.ebaiyihui.dto.GetMainListByManageResponseDto;
import com.ebaiyihui.service.PatientInfoService;
import com.ebaiyihui.service.RedisService;
import com.ebaiyihui.utils.RedisUtil;
import com.ebaiyihui.vo.DelMainListByStatusVO;
import com.ebaiyihui.vo.PatientInformationEntryToIntegrate;
import com.ebaiyihui.vo.UpdateIntegrateMainStatusVO;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    PatientInfoService patientInfoService;
    private static final Integer[] TODO_COUNT_STATUS = new Integer[]{10, 20, 40};

    public void updateMainStatus(UpdateIntegrateMainStatusVO vo) {
        if (Objects.nonNull(vo.getNewValue()) && Objects.equals(vo.getNewValue().getMainStatus(), 10)) {
            this.redisUtil.lSet("INTEGRATE_MAIN_STATUS_NEW_LIST", (Object)(JSON.toJSONString((Object)vo.getNewValue()) + "###" + vo.getPharmaceuticalCompanyId() + "###" + vo.getStoreId()), 900L);
        }
        if (Objects.nonNull(vo.getRemarkTypeOld()) && Objects.isNull(vo.getRemarkTypeNew())) {
            this.redisUtil.lSet("INTEGRATE_MAIN_STATUS_DEL_LIST", (Object)vo.getDrugPrescriptionId(), 900L);
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getDrugPrescriptionId()) && Objects.nonNull(vo.getRemarkTypeOld()) && Objects.nonNull(vo.getRemarkTypeNew())) {
            this.redisUtil.set("INTEGRATE_MAIN_STATUS_PRESID:" + vo.getDrugPrescriptionId(), (Object)vo.getRemarkTypeNew().toString(), 900L);
            this.redisUtil.lSet("INTEGRATE_MAIN_STATUS_STATUS:" + vo.getRemarkTypeOld().toString(), (Object)vo.getDrugPrescriptionId(), 900L);
            this.redisUtil.lSet("INTEGRATE_MAIN_STATUS_STATUS_AFTER:" + vo.getRemarkTypeNew().toString() + "###" + vo.getStoreId(), (Object)vo.getDrugPrescriptionId(), 900L);
            this.redisUtil.lRemove("INTEGRATE_MAIN_STATUS_STATUS_AFTER:" + vo.getRemarkTypeOld().toString() + "###" + vo.getStoreId(), 1L, (Object)vo.getDrugPrescriptionId());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPharmaceuticalCompanyId()) && StringUtils.isNotEmpty((CharSequence)vo.getStoreId())) {
            this.setPresListCache(vo.getDrugPrescriptionId(), vo.getStoreId(), vo.getPharmaceuticalCompanyId(), vo.getRemarkTypeOld(), vo.getRemarkTypeNew(), vo.getNewValue());
            Set keys1 = this.redisUtil.keys("patient_getDrugMainStatusCount_cache:#2*@" + vo.getStoreId() + "*");
            this.setPresCountCacheByRedisKey(keys1, vo.getRemarkTypeOld(), vo.getRemarkTypeNew());
            Set keys2 = this.redisUtil.keys("patient_getDrugMainStatusCount_cache:#1*@" + vo.getPharmaceuticalCompanyId() + "*");
            this.setPresCountCacheByRedisKey(keys2, vo.getRemarkTypeOld(), vo.getRemarkTypeNew());
            Set keys3 = this.redisUtil.keys("patient_getDrugMainStatusCount_cache:#0*");
            this.setPresCountCacheByRedisKey(keys3, vo.getRemarkTypeOld(), vo.getRemarkTypeNew());
        }
    }

    public void delDrugMainListCache(DelMainListByStatusVO vo) {
        String pharmaceuticalCompanyId = vo.getPharmaceuticalCompanyId();
        String mainStatus = vo.getMainStatus();
        Set listKey1 = this.redisUtil.keys("patient_getDrugMainList_cache:#2*###null");
        Set listKey2 = this.redisUtil.keys("patient_getDrugMainList_cache:#1*@" + pharmaceuticalCompanyId + "*###null");
        Set listKey3 = this.redisUtil.keys("patient_getDrugMainList_cache:#0@###null");
        Set listKey4 = this.redisUtil.keys("patient_getDrugMainList_cache:#2*###" + mainStatus);
        Set listKey5 = this.redisUtil.keys("patient_getDrugMainList_cache:#1*@" + pharmaceuticalCompanyId + "*###" + mainStatus);
        Set listKey6 = this.redisUtil.keys("patient_getDrugMainList_cache:#0@###" + mainStatus);
        this.redisUtil.del(listKey1.toArray(new String[listKey1.size()]));
        this.redisUtil.del(listKey2.toArray(new String[listKey2.size()]));
        this.redisUtil.del(listKey3.toArray(new String[listKey3.size()]));
        this.redisUtil.del(listKey4.toArray(new String[listKey4.size()]));
        this.redisUtil.del(listKey5.toArray(new String[listKey5.size()]));
        this.redisUtil.del(listKey6.toArray(new String[listKey6.size()]));
    }

    private void setPresListCache(String mainId, String storeId, String pharmaceuticalCompanyId, Integer before, Integer after, GetMainListByManageResponseDto newValue) {
        log.info("mainid={},storeId={},pharmaceuticalCompanyId={},before={},after={},newValue={}", new Object[]{mainId, storeId, pharmaceuticalCompanyId, before, after, JSON.toJSONString((Object)newValue)});
        GetMainListByManageResponseDto dto = new GetMainListByManageResponseDto();
        dto.setDrugPrescriptionId(mainId);
        Set listKey1 = this.redisUtil.keys("patient_getDrugMainList_cache:#2*@" + storeId + "*###null");
        Set listKey2 = this.redisUtil.keys("patient_getDrugMainList_cache:#1*@" + pharmaceuticalCompanyId + "*###null");
        Set listKey3 = this.redisUtil.keys("patient_getDrugMainList_cache:#0@###null");
        if (Objects.nonNull(before)) {
            Set listKey1Before = this.redisUtil.keys("patient_getDrugMainList_cache:#2*@" + storeId + "*###" + before);
            this.operateRedisValue(listKey1Before, Integer.valueOf(-1), dto);
            Set listKey2Before = this.redisUtil.keys("patient_getDrugMainList_cache:#1*@" + pharmaceuticalCompanyId + "*###" + before);
            this.operateRedisValue(listKey2Before, Integer.valueOf(-1), dto);
            Set listKey3Before = this.redisUtil.keys("patient_getDrugMainList_cache:#0@###" + before);
            this.operateRedisValue(listKey3Before, Integer.valueOf(-1), dto);
            this.operateRedisValue(listKey1, Integer.valueOf(-1), dto);
            this.operateRedisValue(listKey2, Integer.valueOf(-1), dto);
            this.operateRedisValue(listKey3, Integer.valueOf(-1), dto);
        }
        if (Objects.nonNull(after)) {
            Set listKey1After = this.redisUtil.keys("patient_getDrugMainList_cache:#2*@" + storeId + "*###" + after);
            this.operateRedisValue(listKey1After, Integer.valueOf(1), newValue);
            Set listKey2After = this.redisUtil.keys("patient_getDrugMainList_cache:#1*@" + pharmaceuticalCompanyId + "*###" + after);
            this.operateRedisValue(listKey2After, Integer.valueOf(1), newValue);
            Set listKey3After = this.redisUtil.keys("patient_getDrugMainList_cache:#0@###" + after);
            this.operateRedisValue(listKey3After, Integer.valueOf(1), newValue);
            this.operateRedisValue(listKey1, Integer.valueOf(1), newValue);
            this.operateRedisValue(listKey2, Integer.valueOf(1), newValue);
            this.operateRedisValue(listKey3, Integer.valueOf(1), newValue);
        }
    }

    private void operateRedisValue(Set<String> keys, Integer type, GetMainListByManageResponseDto dto) {
        for (String key : keys) {
            Object obj = this.redisUtil.get(key);
            if (!Objects.nonNull(obj)) continue;
            GetDrugMainListByManageDTO data = (GetDrugMainListByManageDTO)JSON.parseObject((String)obj.toString(), GetDrugMainListByManageDTO.class);
            List list = null;
            switch (type) {
                case 1: {
                    data.setTotal(Integer.valueOf(data.getTotal() + 1));
                    list = data.getList();
                    list.add(dto);
                    break;
                }
                case -1: {
                    data.setTotal(Integer.valueOf(data.getTotal() - 1));
                    for (int i = data.getList().size() - 1; i >= 0; --i) {
                        if (!((GetMainListByManageResponseDto)data.getList().get(i)).getDrugPrescriptionId().equals(dto.getDrugPrescriptionId())) continue;
                        data.getList().remove(i);
                        break;
                    }
                    list = data.getList();
                }
            }
            data.setList(list);
            this.redisUtil.set(key, (Object)JSON.toJSONString((Object)data), 900L);
        }
    }

    private void setPresCountCacheByRedisKey(Set<String> keys, Integer before, Integer after) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        List<Integer> statusList = Arrays.asList(TODO_COUNT_STATUS);
        for (String key : keys) {
            Integer value = Integer.valueOf(this.redisUtil.get(key).toString());
            if (statusList.contains(before) && !statusList.contains(after)) {
                if (Objects.equals(0, value)) {
                    this.redisUtil.del(new String[]{key});
                    continue;
                }
                this.redisUtil.set(key, (Object)String.valueOf(value - 1));
                continue;
            }
            if (statusList.contains(before) || !statusList.contains(after)) continue;
            this.redisUtil.set(key, (Object)String.valueOf(value + 1));
        }
    }

    public void informationEntry(PatientInformationEntryToIntegrate vo) {
        String redisKey;
        switch (vo.getPatientType()) {
            case 1: {
                redisKey = "INTEGRATE_PATIENT_SPILT_NEW_LIST";
                break;
            }
            default: {
                redisKey = "INTEGRATE_PATIENT_NEW_LIST";
            }
        }
        this.redisUtil.lSet(redisKey, (Object)(JSON.toJSONString((Object)vo.getNewValue()) + "###" + vo.getPharmaceuticalCompanyId() + "###" + vo.getStoreId()), 900L);
    }
}

