/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.starrocks;

import com.ebaiyihui.common.execption.BusinessException;
import com.ebaiyihui.dto.dashboard.EChartDataResDTO;
import com.ebaiyihui.dto.dashboard.EchartsResponseDTO;
import com.ebaiyihui.utils.DateHelper;
import com.ebaiyihui.utils.DateUtils;
import com.ebaiyihui.vo.UserDataAuthsVO;
import com.ebaiyihui.vo.dashboard.AverageSalesRevenueOfStoreResVo;
import com.ebaiyihui.vo.dashboard.AvgGrossMarginPerStoreResVo;
import com.ebaiyihui.vo.dashboard.ChronicDiseaseMembersResVo;
import com.ebaiyihui.vo.dashboard.ConsumerPerStoreRatioResVo;
import com.ebaiyihui.vo.dashboard.DashboardCommonReqVO;
import com.ebaiyihui.vo.dashboard.DashboardDtpDrugReqVO;
import com.ebaiyihui.vo.dashboard.DtoAnalysisReqVo;
import com.ebaiyihui.vo.dashboard.DtoAnalysisResVo;
import com.ebaiyihui.vo.dashboard.DtpDrugResVO;
import com.ebaiyihui.vo.dashboard.FollowTaskDataResVo;
import com.ebaiyihui.vo.dashboard.HospitalPresResVO;
import com.ebaiyihui.vo.dashboard.MemberConsumptionConversionDataResVo;
import com.ebaiyihui.vo.dashboard.MemberTransactionAnalysis;
import com.ebaiyihui.vo.dashboard.MonthlySalesDataByCategoryResVo;
import com.ebaiyihui.vo.dashboard.PatientDataResVo;
import com.ebaiyihui.vo.dashboard.SaleDataResVo;
import com.ebaiyihui.vo.dashboard.SaleRankDataCommonResVO;
import com.ebaiyihui.vo.dashboard.ShopTransactAnalysisRes;
import com.ebaiyihui.vo.dashboard.TopTenBestSellingDrugResVo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class StarRocksDashboardUtils {
    private static final Logger log = LoggerFactory.getLogger(StarRocksDashboardUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<PatientDataResVo> dashboardPatientData(Connection connection, String brandId, String timeNowParam, String timeLastParam) {
        PatientDataResVo result = new PatientDataResVo();
        Statement ps = null;
        ResultSet rs = null;
        try {
            BigDecimal rate;
            BigDecimal diff;
            BigDecimal last;
            BigDecimal curr;
            Integer count;
            StringBuffer sb = new StringBuffer();
            sb.append("select count(1) result from ps_patient_split_info p");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = p.id and r.status = 1 and r.patient_type = 1");
            sb.append(" where p.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("'");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("result");
                result.setServicePatients(count);
            }
            sb = new StringBuffer();
            sb.append("select count(1) result from ps_drug_prescription p");
            sb.append(" inner join ps_patient_store s on s.id = p.store_id and s.status = 1");
            sb.append(" where p.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and p.create_time >'");
            sb.append(timeNowParam).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("result");
                result.setMonthsOrders(count);
            }
            sb = new StringBuffer();
            sb.append("select count(distinct p.patient_id) result from ps_drug_prescription p");
            sb.append(" inner join ps_patient_store s on s.id = p.store_id and s.status = 1");
            sb.append(" where p.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and p.create_time >'");
            sb.append(timeNowParam).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("result");
                result.setMonthsServicePatients(count);
            }
            sb = new StringBuffer();
            sb.append("select count(distinct p.patient_id) result from ps_drug_prescription p");
            sb.append(" inner join ps_patient_store s on s.id = p.store_id and s.status = 1");
            sb.append(" where p.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and p.create_time >'");
            sb.append(timeLastParam).append("'");
            sb.append(" and p.create_time < '").append(timeNowParam).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("result");
                if (Objects.equals(count, 0)) continue;
                curr = new BigDecimal(result.getMonthsServicePatients());
                last = new BigDecimal(count);
                diff = curr.subtract(last);
                rate = diff.divide(last, 2, 4).multiply(new BigDecimal(100));
                result.setServicePatientsRatio(Integer.valueOf(rate.intValue()));
            }
            sb = new StringBuffer();
            sb.append("select count(1) result from ps_patient_split_info p");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = p.id and r.status = 1 and r.patient_type = 1");
            sb.append(" where p.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and p.create_time >'");
            sb.append(timeNowParam).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("result");
                result.setMonthsNewPatients(count);
            }
            sb = new StringBuffer();
            sb.append("select count(1) result from ps_patient_split_info p");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = p.id and r.status = 1 and r.patient_type = 1");
            sb.append(" where p.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and p.create_time >'");
            sb.append(timeLastParam).append("'");
            sb.append(" and p.create_time < '").append(timeNowParam).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("result");
                if (Objects.equals(count, 0)) continue;
                curr = new BigDecimal(result.getMonthsNewPatients());
                last = new BigDecimal(count);
                diff = curr.subtract(last);
                rate = diff.divide(last, 2, 4).multiply(new BigDecimal(100));
                result.setNewPatientsRatio(Integer.valueOf(rate.intValue()));
            }
            if (!Objects.equals(result.getMonthsServicePatients(), 0)) {
                BigDecimal ser = new BigDecimal(result.getMonthsServicePatients());
                BigDecimal np = new BigDecimal(result.getMonthsNewPatients());
                BigDecimal rate2 = np.divide(ser, 2, 4).multiply(new BigDecimal(100));
                result.setNewPatientsServiceRatio(Integer.valueOf(rate2.intValue()));
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Map> dashboardPatientSex(Connection connection, String brandId) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select SUM(CASE p.patient_sex WHEN '1' THEN 1 ELSE 0 END) AS '1',");
            sb.append(" SUM(CASE p.patient_sex WHEN '2' THEN 1 ELSE 0 END) AS '2'");
            sb.append(" from ps_patient_split_info p");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = p.id and r.status = 1 and r.patient_type = 1");
            sb.append(" where p.status = 1 and p.patient_sex is not null and r.pharmaceutical_company_id = '").append(brandId).append("'");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer count1 = rs.getInt("1");
                Integer count2 = rs.getInt("2");
                result.put(1, count1);
                result.put(2, count2);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientSex: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientSex: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientSex: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Map> dashboardPatientAge(Connection connection, String brandId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            Date now = DateUtils.parseYMDDate((Date)new Date());
            Calendar c = Calendar.getInstance();
            c.setTime(now);
            c.add(1, -18);
            String under18 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -12);
            String under30 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -10);
            String under40 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -10);
            String under50 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -10);
            String under60 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            StringBuffer sb = new StringBuffer();
            sb.append("select ");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday >= '" + under18 + "' THEN 1 ELSE 0 END) AS 'under18',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under18 + "' and p.patient_birthday >= '" + under30 + "' THEN 1 ELSE 0 END) AS '18-30',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under30 + "' and p.patient_birthday >= '" + under40 + "' THEN 1 ELSE 0 END) AS '30-40',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under40 + "' and p.patient_birthday >= '" + under50 + "' THEN 1 ELSE 0 END) AS '40-50',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under50 + "' and p.patient_birthday >= '" + under60 + "' THEN 1 ELSE 0 END) AS '50-60',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under60 + "' THEN 1 ELSE 0 END) AS 'after60'");
            sb.append(" from ps_patient_split_info p");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = p.id and r.status = 1 and r.patient_type = 1");
            sb.append(" where p.status = 1 and p.patient_birthday is not null and r.pharmaceutical_company_id = '").append(brandId).append("'");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer count1 = rs.getInt("under18");
                Integer count2 = rs.getInt("18-30");
                Integer count3 = rs.getInt("30-40");
                Integer count4 = rs.getInt("40-50");
                Integer count5 = rs.getInt("50-60");
                Integer count6 = rs.getInt("after60");
                result.put("under18", count1);
                result.put("18-30", count2);
                result.put("30-40", count3);
                result.put("40-50", count4);
                result.put("50-60", count5);
                result.put("after60", count6);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Map> dashboardPatientIndication(Connection connection, String brandId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select ");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u80ba\u764c%' and status = 1)) as feiai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u80c3\u764c%' and status = 1)) as weiai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u98df\u7ba1\u764c%' and status = 1)) as shiguanai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u809d\u764c%' and status = 1)) as ganai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u4e73\u817a\u764c%' and status = 1)) as ruxianai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u80a0\u764c%' and status = 1)) as changai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u5b50\u5bab\u9888\u764c%' and status = 1)) as zigongjingai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u767d\u8840\u75c5%' and status = 1)) as baixuebing,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u6dcb\u5df4\u764c%' and status = 1)) as linbaai,");
            sb.append(" (select count(DISTINCT i.patient_id) from ps_patient_icd_reg i");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = i.patient_id and r.status = 1 and r.patient_type = 1");
            sb.append(" where i.patient_type = 1 and i.status = 1 and r.pharmaceutical_company_id = '").append(brandId).append("' and icd_id in");
            sb.append(" (select id from ps_icd_item where icd_name like '%\u9f3b\u54bd\u764c%' and status = 1)) as biyanai");
            sb.append(" from dual");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer count1 = rs.getInt("feiai");
                Integer count2 = rs.getInt("weiai");
                Integer count3 = rs.getInt("shiguanai");
                Integer count4 = rs.getInt("ganai");
                Integer count5 = rs.getInt("ruxianai");
                Integer count6 = rs.getInt("changai");
                Integer count7 = rs.getInt("zigongjingai");
                Integer count8 = rs.getInt("baixuebing");
                Integer count9 = rs.getInt("linbaai");
                Integer count10 = rs.getInt("biyanai");
                result.put("\u80ba\u764c", count1);
                result.put("\u80c3\u764c", count2);
                result.put("\u98df\u7ba1\u764c", count3);
                result.put("\u809d\u764c", count4);
                result.put("\u4e73\u817a\u764c", count5);
                result.put("\u80a0\u764c", count6);
                result.put("\u5b50\u5bab\u9888\u764c", count7);
                result.put("\u767d\u8840\u75c5", count8);
                result.put("\u6dcb\u5df4\u764c", count9);
                result.put("\u9f3b\u54bd\u764c", count10);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    private Map<String, String> setStartAndEnd(Integer queryType) {
        String end;
        String start;
        switch (queryType) {
            case 3: {
                start = DateUtils.formatDate((Date)DateUtils.addDay((Date)new Date(), (int)-6), (Object[])new Object[0]);
                end = DateUtils.formatDate((Date)DateUtils.addDay((Date)new Date(), (int)1), (Object[])new Object[0]);
                break;
            }
            case 4: {
                start = DateUtils.formatDate((Date)DateUtils.addDay((Date)new Date(), (int)-29), (Object[])new Object[0]);
                end = DateUtils.formatDate((Date)DateUtils.addDay((Date)new Date(), (int)1), (Object[])new Object[0]);
                break;
            }
            default: {
                throw new BusinessException("\u53c2\u6570\u9519\u8bef");
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("start", start);
        result.put("end", end);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<HospitalPresResVO>> dashboardHospitalPresData(Connection connection, DashboardCommonReqVO dashboardCommonReqVO) {
        ArrayList<HospitalPresResVO> result = new ArrayList<HospitalPresResVO>();
        Statement ps = null;
        ResultSet rs = null;
        Map timeParams = this.setStartAndEnd(dashboardCommonReqVO.getQueryType());
        String start = (String)timeParams.get("start");
        String end = (String)timeParams.get("end");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select ");
            sb.append(" p.pres_hospital_name hospitalName, count(1) presCount");
            sb.append(" from ps_drug_prescription p");
            sb.append(" inner join ps_patient_store s on s.id = p.store_id and s.status = 1");
            sb.append(" where p.status = 1 and s.pharmaceutical_company_id = '").append(dashboardCommonReqVO.getBrandId()).append("'");
            sb.append(" and p.prescription_input_time  >= '").append(start).append("'");
            sb.append(" and p.prescription_input_time < '").append(end).append("'");
            sb.append(" group by p.pres_hospital_name order by presCount desc limit ").append(dashboardCommonReqVO.getPageSize());
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            int rankNum = 1;
            while (rs.next()) {
                HospitalPresResVO dto = new HospitalPresResVO();
                String hospitalName = rs.getString("hospitalName");
                Integer presCount = rs.getInt("presCount");
                dto.setRank(Integer.valueOf(rankNum++));
                dto.setHospitalName(hospitalName);
                dto.setPresCount(presCount);
                result.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardHospitalPresData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardHospitalPresData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardHospitalPresData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<DtpDrugResVO>> dashboardDtpDrugData(Connection connection, DashboardCommonReqVO dashboardCommonReqVO) {
        ArrayList<DtpDrugResVO> result = new ArrayList<DtpDrugResVO>();
        Statement ps = null;
        ResultSet rs = null;
        Map timeParams = this.setStartAndEnd(dashboardCommonReqVO.getQueryType());
        String start = (String)timeParams.get("start");
        String end = (String)timeParams.get("end");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select ");
            sb.append(" d.drug_id drugId, d.drug_name drugName, sum(d.total_price) price");
            sb.append(" from ps_drug_prescription_detail d");
            sb.append(" inner join ps_drug_prescription p on d.main_id = p.id");
            sb.append(" inner join ps_patient_store s on s.id = p.store_id and s.status = 1");
            sb.append(" where p.status = 1 and s.pharmaceutical_company_id = '").append(dashboardCommonReqVO.getBrandId()).append("'");
            sb.append(" and d.status = 1 and p.status = 1");
            sb.append(" and p.prescription_input_time  >= '").append(start).append("'");
            sb.append(" and p.prescription_input_time < '").append(end).append("'");
            sb.append(" group by d.drug_id, d.drug_name order by price desc limit ").append(dashboardCommonReqVO.getPageSize());
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                DtpDrugResVO dto = new DtpDrugResVO();
                String drugId = rs.getString("drugId");
                String drugName = rs.getString("drugName");
                BigDecimal price = rs.getBigDecimal("price");
                dto.setDrugId(drugId);
                dto.setDrugName(drugName);
                dto.setTotalPrice(price.setScale(2, RoundingMode.HALF_UP));
                result.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardDtpDrugData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardDtpDrugData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardDtpDrugData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    private List<String> combineXAxisByTime(Date start, Date end) throws Exception {
        if (Objects.isNull(start) || Objects.isNull(end)) {
            throw new Exception("\u53c2\u6570\u9519\u8bef");
        }
        ArrayList<String> xAxis = new ArrayList<String>();
        while (start.getTime() < end.getTime()) {
            xAxis.add(DateUtils.formatDate((Date)start, (Object[])new Object[]{"MM-dd"}));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(start);
            calendar.add(7, 1);
            start = calendar.getTime();
        }
        return xAxis;
    }

    private EchartsResponseDTO organizeEChartData(List<String> xAxis, List<EChartDataResDTO> data) {
        EchartsResponseDTO responseDTO = new EchartsResponseDTO();
        responseDTO.setXAxis(xAxis);
        Map<String, Integer> dataMap = data.stream().collect(Collectors.toMap(EChartDataResDTO::getTime, EChartDataResDTO::getValue));
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (String time : xAxis) {
            Integer currValue = dataMap.get(time);
            if (Objects.isNull(currValue)) {
                values.add(0);
                continue;
            }
            values.add(currValue);
        }
        responseDTO.setSeries(values);
        return responseDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<EchartsResponseDTO> dashboardDtpDrugSaleOrPatientCount(Connection connection, DashboardDtpDrugReqVO dashboardDtpDrugReqVO) throws Exception {
        EchartsResponseDTO result = new EchartsResponseDTO();
        Statement ps = null;
        ResultSet rs = null;
        Map timeParams = this.setStartAndEnd(dashboardDtpDrugReqVO.getQueryType());
        String start = (String)timeParams.get("start");
        String end = (String)timeParams.get("end");
        result.setXAxis(this.combineXAxisByTime(DateUtils.parseDate((String)start, (String)"yyyy-MM-dd"), DateUtils.parseDate((String)end, (String)"yyyy-MM-dd")));
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select ");
            sb.append(" date_format(p.prescription_input_time, '%m-%d') as time,");
            if (Objects.equals(dashboardDtpDrugReqVO.getPatientOrSale(), 1)) {
                sb.append(" sum(d.amount) value");
            } else {
                sb.append(" count(distinct p.patient_id) value");
            }
            sb.append(" from ps_drug_prescription_detail d");
            sb.append(" inner join ps_drug_prescription p on d.main_id = p.id");
            sb.append(" where d.status = 1 and p.status = 1");
            sb.append(" and p.prescription_input_time  >= '").append(start).append("'");
            sb.append(" and p.prescription_input_time < '").append(end).append("'");
            sb.append(" and d.drug_id = '").append(dashboardDtpDrugReqVO.getDrugId()).append("'");
            sb.append(" group by time");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            ArrayList<EChartDataResDTO> list = new ArrayList<EChartDataResDTO>();
            while (rs.next()) {
                EChartDataResDTO dto = new EChartDataResDTO();
                String time = rs.getString("time");
                Integer value = rs.getInt("value");
                dto.setTime(time);
                dto.setValue(value);
                list.add(dto);
            }
            result = this.organizeEChartData(result.getXAxis(), list);
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardDtpDrugSaleOrPatientCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardDtpDrugSaleOrPatientCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardDtpDrugSaleOrPatientCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Map> dashboardDtpDrugPatientSex(Connection connection, DashboardDtpDrugReqVO dashboardDtpDrugReqVO) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        Statement ps = null;
        ResultSet rs = null;
        Map timeParams = this.setStartAndEnd(dashboardDtpDrugReqVO.getQueryType());
        String start = (String)timeParams.get("start");
        String end = (String)timeParams.get("end");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select SUM(CASE p.patient_sex WHEN '1' THEN 1 ELSE 0 END) AS '1',");
            sb.append(" SUM(CASE p.patient_sex WHEN '2' THEN 1 ELSE 0 END) AS '2'");
            sb.append(" from ps_drug_prescription p");
            sb.append(" where p.status = 1");
            sb.append(" and p.prescription_input_time  >= '").append(start).append("'");
            sb.append(" and p.prescription_input_time < '").append(end).append("'");
            sb.append(" and p.id in (select main_id from ps_drug_prescription_detail where status = 1");
            sb.append(" and drug_id = '").append(dashboardDtpDrugReqVO.getDrugId()).append("')");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer count1 = rs.getInt("1");
                Integer count2 = rs.getInt("2");
                result.put(1, count1);
                result.put(2, count2);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardDtpDrugPatientSex: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardDtpDrugPatientSex: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardDtpDrugPatientSex: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<SaleDataResVo> dashboardSaleData(Connection connection, String brandId) {
        SaleDataResVo result = new SaleDataResVo();
        Statement ps = null;
        ResultSet rs = null;
        try {
            BigDecimal resultValue;
            Date now = new Date();
            String timeParam = DateUtils.formatDate((Date)now, (Object[])new Object[]{"yyyy-01-01"});
            StringBuffer sb = new StringBuffer();
            sb.append("select sum(o.pay_amount) result from ps_drug_order o");
            sb.append(" inner join ps_patient_store s on s.id = o.store_id and s.status = 1");
            sb.append(" where o.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(timeParam).append("'");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                BigDecimal resultValue2 = rs.getBigDecimal("result");
                result.setYearTotal(resultValue2.setScale(2, RoundingMode.HALF_UP));
            }
            Date yearStart = DateUtils.parseY_M_DDate((String)timeParam);
            Calendar c = Calendar.getInstance();
            c.setTime(yearStart);
            c.add(1, -1);
            String lastYearStart = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[]{"yyyy-MM-dd"});
            c.setTime(now);
            c.add(1, -1);
            c.add(5, 1);
            String lastYearCurr = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[]{"yyyy-MM-dd"});
            sb = new StringBuffer();
            sb.append("select sum(o.pay_amount) result from ps_drug_order o");
            sb.append(" inner join ps_patient_store s on s.id = o.store_id and s.status = 1");
            sb.append(" where o.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(lastYearStart).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) <'").append(lastYearCurr).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                resultValue = rs.getBigDecimal("result");
                BigDecimal diff = result.getYearTotal().subtract(resultValue);
                BigDecimal rate = diff.divide(resultValue, 2, 4).multiply(new BigDecimal(100));
                result.setYearTotalRatio(Integer.valueOf(rate.intValue()));
            }
            timeParam = DateUtils.formatDate((Date)now, (Object[])new Object[]{"yyyy-MM-01"});
            sb = new StringBuffer();
            sb.append("select sum(o.pay_amount) result from ps_drug_order o");
            sb.append(" inner join ps_patient_store s on s.id = o.store_id and s.status = 1");
            sb.append(" where o.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(timeParam).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                resultValue = rs.getBigDecimal("result");
                result.setMonthsTotal(resultValue.setScale(2, RoundingMode.HALF_UP));
            }
            c = Calendar.getInstance();
            c.setTime(now);
            c.add(2, -1);
            String monthLast = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[]{"yyyy-MM-01"});
            sb = new StringBuffer();
            sb.append("select sum(o.pay_amount) result from ps_drug_order o");
            sb.append(" inner join ps_patient_store s on s.id = o.store_id and s.status = 1");
            sb.append(" where o.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(monthLast).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) <'").append(timeParam).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                BigDecimal resultValue3 = rs.getBigDecimal("result");
                BigDecimal diff = result.getMonthsTotal().subtract(resultValue3);
                BigDecimal rate = diff.divide(resultValue3, 2, 4).multiply(new BigDecimal(100));
                result.setMonthsTotalRatio(Integer.valueOf(rate.intValue()));
            }
            String timeEnd = DateUtils.formatDate((Date)now, (Object[])new Object[]{"yyyy-MM-dd"});
            String timeStart = DateUtils.formatDate((Date)DateUtils.addDay((Date)now, (int)-1), (Object[])new Object[]{"yyyy-MM-dd"});
            sb = new StringBuffer();
            sb.append("select sum(o.pay_amount) result from ps_drug_order o");
            sb.append(" inner join ps_patient_store s on s.id = o.store_id and s.status = 1");
            sb.append(" where o.status = 1 and s.pharmaceutical_company_id = '").append(brandId).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(timeStart).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) <'").append(timeEnd).append("'");
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                BigDecimal resultValue4 = rs.getBigDecimal("result");
                result.setYesterdayTotal(resultValue4.setScale(2, RoundingMode.HALF_UP));
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardSaleData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<SaleRankDataCommonResVO>> dashboardSaleYesterdayStoreData(Connection connection, DashboardCommonReqVO dashboardCommonReqVO) {
        ArrayList<SaleRankDataCommonResVO> result = new ArrayList<SaleRankDataCommonResVO>();
        Statement ps = null;
        ResultSet rs = null;
        Date now = new Date();
        String timeEnd = DateUtils.formatDate((Date)now, (Object[])new Object[]{"yyyy-MM-dd"});
        String timeStart = DateUtils.formatDate((Date)DateUtils.addDay((Date)now, (int)-1), (Object[])new Object[]{"yyyy-MM-dd"});
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select s.store_name name, sum(o.pay_amount) total from ps_drug_order o");
            sb.append(" inner join ps_patient_store s on s.id = o.store_id and s.status = 1");
            sb.append(" where o.status = 1 and s.pharmaceutical_company_id = '").append(dashboardCommonReqVO.getBrandId()).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(timeStart).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) <'").append(timeEnd).append("'");
            sb.append(" group by o.store_id, s.store_name order by total desc limit ").append(dashboardCommonReqVO.getPageSize());
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            int rankNum = 1;
            while (rs.next()) {
                SaleRankDataCommonResVO vo = new SaleRankDataCommonResVO();
                String name = rs.getString("name");
                BigDecimal total = rs.getBigDecimal("total");
                vo.setRank(Integer.valueOf(rankNum++));
                vo.setName(name);
                vo.setTotal(total.setScale(2, RoundingMode.HALF_UP));
                result.add(vo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardSaleYesterdayStoreData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleYesterdayStoreData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleYesterdayStoreData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<SaleRankDataCommonResVO>> dashboardSaleYesterdayDrugData(Connection connection, DashboardCommonReqVO dashboardCommonReqVO) {
        ArrayList<SaleRankDataCommonResVO> result = new ArrayList<SaleRankDataCommonResVO>();
        Statement ps = null;
        ResultSet rs = null;
        Date now = new Date();
        String timeEnd = DateUtils.formatDate((Date)now, (Object[])new Object[]{"yyyy-MM-dd"});
        String timeStart = DateUtils.formatDate((Date)DateUtils.addDay((Date)now, (int)-1), (Object[])new Object[]{"yyyy-MM-dd"});
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select d.drug_name name, sum(o.pay_amount) total from ps_drug_order o");
            sb.append(" inner join ps_drug_prescription_detail d on d.order_id = o.id and d.status = 1");
            sb.append(" inner join ps_patient_store s on s.id = o.store_id and s.status = 1");
            sb.append(" where o.status = 1 and s.pharmaceutical_company_id = '").append(dashboardCommonReqVO.getBrandId()).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(timeStart).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) <'").append(timeEnd).append("'");
            sb.append(" group by d.drug_id, d.drug_name order by total desc limit ").append(dashboardCommonReqVO.getPageSize());
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            int rankNum = 1;
            while (rs.next()) {
                SaleRankDataCommonResVO vo = new SaleRankDataCommonResVO();
                String name = rs.getString("name");
                BigDecimal total = rs.getBigDecimal("total");
                vo.setRank(Integer.valueOf(rankNum++));
                vo.setName(name);
                vo.setTotal(total.setScale(2, RoundingMode.HALF_UP));
                result.add(vo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardSaleYesterdayDrugData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleYesterdayDrugData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleYesterdayDrugData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<SaleRankDataCommonResVO>> dashboardSaleYesterdayOrgData(Connection connection, DashboardCommonReqVO dashboardCommonReqVO) {
        ArrayList<SaleRankDataCommonResVO> result = new ArrayList<SaleRankDataCommonResVO>();
        Statement ps = null;
        ResultSet rs = null;
        Date now = new Date();
        String timeEnd = DateUtils.formatDate((Date)now, (Object[])new Object[]{"yyyy-MM-dd"});
        String timeStart = DateUtils.formatDate((Date)DateUtils.addDay((Date)now, (int)-1), (Object[])new Object[]{"yyyy-MM-dd"});
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select split_part(r.org_id, ',', 3) orgId, og.org_name name, sum(o.pay_amount) total from ps_drug_order o");
            sb.append(" inner join ps_patient_org_store_reg r on r.store_id = o.store_id and r.status = 1");
            sb.append(" inner join ps_patient_org og on r.org_id like concat('%',og.id,'%') and og.status = 1");
            sb.append(" where o.status = 1 and og.level = 3 and og.pharmaceutical_company_id = '").append(dashboardCommonReqVO.getBrandId()).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) >'").append(timeStart).append("'");
            sb.append(" and ifnull(o.pay_time, o.create_time) <'").append(timeEnd).append("'");
            sb.append(" group by orgId, og.org_name order by total desc");
            if (Objects.nonNull(dashboardCommonReqVO.getPageSize())) {
                sb.append(" limit ").append(dashboardCommonReqVO.getPageSize());
            }
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            int rankNum = 1;
            while (rs.next()) {
                SaleRankDataCommonResVO vo = new SaleRankDataCommonResVO();
                String name = rs.getString("name");
                BigDecimal total = rs.getBigDecimal("total");
                vo.setRank(Integer.valueOf(rankNum++));
                vo.setName(name);
                vo.setTotal(total.setScale(2, RoundingMode.HALF_UP));
                result.add(vo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardSaleYesterdayDrugData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleYesterdayDrugData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardSaleYesterdayDrugData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<FollowTaskDataResVo> dashboardFollowTaskData(Connection connection, List<UserDataAuthsVO> userDataAuths, String timeNowParam, String timeLastParam) {
        FollowTaskDataResVo result = new FollowTaskDataResVo();
        Statement ps = null;
        ResultSet rs = null;
        try {
            BigDecimal diff;
            BigDecimal rate2;
            BigDecimal np;
            BigDecimal ser;
            Integer done;
            Integer allTask;
            String querySql = this.queryFollowTaskSql(Integer.valueOf(3), userDataAuths, timeNowParam, null);
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            BigDecimal rate = null;
            while (rs.next()) {
                allTask = rs.getInt("allTask");
                done = rs.getInt("done");
                result.setDrop(allTask);
                result.setDropDone(done);
                if (Objects.equals(allTask, 0)) continue;
                ser = new BigDecimal(allTask);
                np = new BigDecimal(done);
                rate = np.divide(ser, 2, 4).multiply(new BigDecimal(100));
                result.setDropRatio(Integer.valueOf(rate.intValue()));
            }
            if (Objects.nonNull(rate)) {
                querySql = this.queryFollowTaskSql(Integer.valueOf(3), userDataAuths, timeLastParam, timeNowParam);
                ps = connection.prepareStatement(querySql);
                rs = ps.executeQuery(querySql);
                while (rs.next()) {
                    allTask = rs.getInt("allTask");
                    done = rs.getInt("done");
                    if (Objects.equals(done, 0)) continue;
                    ser = new BigDecimal(allTask);
                    np = new BigDecimal(done);
                    rate2 = np.divide(ser, 2, 4).multiply(new BigDecimal(100));
                    if (rate2.compareTo(new BigDecimal(0)) == 0) continue;
                    diff = rate.subtract(rate2);
                    result.setDropQoqRatio(Integer.valueOf(diff.divide(rate2, 2, 4).multiply(new BigDecimal(100)).intValue()));
                }
            }
            querySql = this.queryFollowTaskSql(Integer.valueOf(12), userDataAuths, timeNowParam, null);
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                allTask = rs.getInt("allTask");
                done = rs.getInt("done");
                result.setRebuy(allTask);
                result.setRebuyDone(done);
                if (Objects.equals(allTask, 0)) continue;
                ser = new BigDecimal(allTask);
                np = new BigDecimal(done);
                rate = np.divide(ser, 2, 4).multiply(new BigDecimal(100));
                result.setRebuyRatio(Integer.valueOf(rate.intValue()));
            }
            if (Objects.nonNull(rate)) {
                querySql = this.queryFollowTaskSql(Integer.valueOf(12), userDataAuths, timeLastParam, timeNowParam);
                ps = connection.prepareStatement(querySql);
                rs = ps.executeQuery(querySql);
                while (rs.next()) {
                    allTask = rs.getInt("allTask");
                    done = rs.getInt("done");
                    if (Objects.equals(done, 0)) continue;
                    ser = new BigDecimal(allTask);
                    np = new BigDecimal(done);
                    rate2 = np.divide(ser, 2, 4).multiply(new BigDecimal(100));
                    if (rate2.compareTo(new BigDecimal(0)) == 0) continue;
                    diff = rate.subtract(rate2);
                    result.setRebuyQoqRatio(Integer.valueOf(diff.divide(rate2, 2, 4).multiply(new BigDecimal(100)).intValue()));
                }
            }
            querySql = this.queryFollowTaskSql(Integer.valueOf(1), userDataAuths, timeNowParam, null);
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                allTask = rs.getInt("allTask");
                done = rs.getInt("done");
                result.setAfterBuy(allTask);
                result.setAfterBuyDone(done);
                if (Objects.equals(allTask, 0)) continue;
                ser = new BigDecimal(allTask);
                np = new BigDecimal(done);
                rate = np.divide(ser, 2, 4).multiply(new BigDecimal(100));
                result.setAfterBuyRatio(Integer.valueOf(rate.intValue()));
            }
            if (Objects.nonNull(rate)) {
                querySql = this.queryFollowTaskSql(Integer.valueOf(1), userDataAuths, timeLastParam, timeNowParam);
                ps = connection.prepareStatement(querySql);
                rs = ps.executeQuery(querySql);
                while (rs.next()) {
                    allTask = rs.getInt("allTask");
                    done = rs.getInt("done");
                    if (Objects.equals(done, 0)) continue;
                    ser = new BigDecimal(allTask);
                    np = new BigDecimal(done);
                    rate2 = np.divide(ser, 2, 4).multiply(new BigDecimal(100));
                    if (rate2.compareTo(new BigDecimal(0)) == 0) continue;
                    diff = rate.subtract(rate2);
                    result.setAfterBuyQoqRatio(Integer.valueOf(diff.divide(rate2, 2, 4).multiply(new BigDecimal(100)).intValue()));
                }
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardFollowTaskData: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardFollowTaskData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardFollowTaskData: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    private String queryFollowTaskSql(Integer buildType, List<UserDataAuthsVO> userDataAuths, String start, String end) {
        StringBuffer sb = new StringBuffer();
        sb.append("select sum(case t.follow_status when 1 then 0 else 1 end) allTask,");
        sb.append(" sum(case t.follow_status when 4 then 1 else 0 end) as done");
        sb.append(" from ps_patient_follow_task t");
        sb.append(" where t.status = 1");
        switch (buildType) {
            case 1: {
                sb.append(" and t.build_type = 1 and t.other like '%\u60a3\u8005\u8d2d\u836f\u540e%'");
                break;
            }
            case 3: {
                sb.append(" and t.build_type = 3");
                break;
            }
            case 12: {
                sb.append(" and t.build_type in (1,2,3,4,5) and t.other like '%\u60a3\u8005\u7528\u836f\u5230\u671f%'");
            }
        }
        sb.append(" and t.visit_starttime >= '").append(start).append("'");
        if (!StringUtils.isEmpty((Object)end)) {
            sb.append(" and t.visit_starttime <'").append(end).append("'");
        }
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and t.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "') ");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<DtoAnalysisResVo>> dtoAnalysis(Connection connection, DtoAnalysisReqVo dtoAnalysisReqVo) {
        ArrayList<DtoAnalysisResVo> result = new ArrayList<DtoAnalysisResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT  DATE_FORMAT( create_time, '%Y-%m' ) AS MONTH, COUNT( DISTINCT patient_phone ) AS patientCount, SUM( quantity ) AS salesQuantity  FROM");
            sb.append(" ( SELECT  o.create_time, o.patient_phone AS patient_phone, d.amount AS quantity FROM  `ps_drug_prescription` o");
            sb.append(" INNER JOIN `ps_patient_store` pps ON pps.id =  o.store_id ");
            sb.append(" INNER JOIN `ps_drug_prescription_detail` d ON o.id = d.main_id  INNER JOIN `ps_drug_item` pdi ON pdi.id = d.drug_id WHERE pdi.product_code  IN ( ");
            String[] split = dtoAnalysisReqVo.getDrugCodes().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
            sb.append(" AND pps.store_code IN (");
            String[] splitStor = dtoAnalysisReqVo.getStoreCodes().split(",");
            for (int i = 0; i < splitStor.length; ++i) {
                if (i != splitStor.length - 1) {
                    sb.append(" '" + splitStor[i] + "' ,");
                    continue;
                }
                sb.append(" '" + splitStor[i] + "' )");
            }
            sb.append(" AND o.STATUS = 1");
            if (dtoAnalysisReqVo.getType() == 1) {
                sb.append(" AND o.create_time >= CONCAT( YEAR ( CURDATE()), '-01-01' )");
            } else {
                sb.append(" AND o.create_time >= DATE_SUB(CURDATE(), INTERVAL 11 MONTH)");
            }
            sb.append(" ) AS RelevantOrders");
            sb.append(" GROUP BY MONTH");
            sb.append(" ORDER BY MONTH");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                DtoAnalysisResVo dto = new DtoAnalysisResVo();
                dto.setMonth(rs.getString("MONTH"));
                dto.setPatientCount(rs.getString("patientCount"));
                dto.setSalesQuantity(rs.getString("salesQuantity"));
                result.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<ShopTransactAnalysisRes> shopTransactAnalysis(Connection connection, String starTime, String endTime) {
        ShopTransactAnalysisRes result = new ShopTransactAnalysisRes();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT      IFNULL(SUM(CASE WHEN i.special_new_type = 2 THEN 1 ELSE 0 END) / NULLIF(COUNT(DISTINCT CASE WHEN i.special_new_type = 2 THEN o.store_id END), 0), 0) AS avg_transaction_count,     IFNULL(SUM(CASE WHEN i.special_new_type = 2 THEN o.pay_amount ELSE 0 END) / NULLIF(COUNT(DISTINCT CASE WHEN i.special_new_type = 2 THEN o.store_id END), 0), 0) AS avg_transaction_sales FROM      ps_drug_order o JOIN       ps_patient_store pps ON pps.id = o.store_id    JOIN      ps_drug_prescription_detail d ON o.id = d.order_id JOIN      ps_drug_item i ON d.drug_id = i.id WHERE      o.patient_id is not null ");
            sb.append(" AND o.create_time>= '" + starTime + " 00:00:00'AND o.create_time<= '" + endTime + " 23:59:59'");
            sb.append(" AND o.status = 1     AND i.special_new_type = 2      AND pps.store_name  NOT LIKE '%DTP%'    ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                result.setSalesFrequency(rs.getString("avg_transaction_count"));
                result.setSalesAmount(rs.getString("avg_transaction_sales"));
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<AvgGrossMarginPerStoreResVo>> avgGrossMarginPerStore(Connection connection) {
        ArrayList<AvgGrossMarginPerStoreResVo> result = new ArrayList<AvgGrossMarginPerStoreResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT     DATE_FORMAT(o.create_time, '%Y-%m-01') AS `MONTH`,     ROUND(         SUM(CAST(o.gross_profit AS DECIMAL(30,4))) / COUNT(DISTINCT o.store_id),         1     ) AS avg_gross_margin_per_store  FROM     ps_drug_order o JOIN   ps_patient_store pps ON pps.id = o.store_id    JOIN (     SELECT DISTINCT order_id     FROM ps_drug_prescription_detail d     JOIN ps_drug_item i ON d.drug_id = i.id      WHERE i.special_new_type = 2 ) d ON o.id = d.order_id WHERE      o.patient_id is not null     AND o.create_time >= DATE_SUB(DATE_FORMAT(NOW(), '%Y-%m-01'), INTERVAL 11 MONTH)     AND o.create_time < DATE_ADD(DATE_FORMAT(NOW(), '%Y-%m-01'), INTERVAL 1 MONTH)     AND o.status = 1      AND o.gross_profit IS NOT NULL      AND o.pay_amount > 0      AND pps.store_name  NOT LIKE '%DTP%'    GROUP BY     DATE_FORMAT(o.create_time, '%Y-%m-01') ORDER BY     `MONTH` DESC; ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                AvgGrossMarginPerStoreResVo avgGrossMarginPerStoreResVo = new AvgGrossMarginPerStoreResVo();
                avgGrossMarginPerStoreResVo.setAvgGrossMarginPerStore(rs.getString("avg_gross_margin_per_store"));
                avgGrossMarginPerStoreResVo.setMonth(rs.getString("MONTH"));
                result.add(avgGrossMarginPerStoreResVo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<TopTenBestSellingDrugResVo>> topTenBestSellingDrugs(Connection connection) {
        ArrayList<TopTenBestSellingDrugResVo> result = new ArrayList<TopTenBestSellingDrugResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT      pdi.product_code,      pdi.product_name,     CAST(SUM(pdpd.amount) AS UNSIGNED) AS total_quantity_sold  FROM      ps_drug_order pdo  JOIN         ps_patient_store pps ON pps.id = pdo.store_id    JOIN      ps_drug_prescription_detail pdpd ON pdpd.order_id = pdo.id  JOIN      ps_drug_item pdi ON pdpd.drug_id = pdi.id  WHERE      pdo.patient_id is not null     AND   pdo.status = 1      AND   pps.store_name NOT LIKE '%DTP%'        AND   pdi.is_chronic_disease = 1      AND   pdi.special_new_type = 2         AND   pdo.create_time >= DATE_FORMAT(CURRENT_DATE, '%Y-%m-01')      AND   pdo.create_time < DATE_ADD(DATE_FORMAT(CURRENT_DATE, '%Y-%m-01'), INTERVAL 1 MONTH)  GROUP BY      pdi.product_code,      pdi.product_name  ORDER BY      total_quantity_sold DESC  LIMIT 10; ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                TopTenBestSellingDrugResVo topTenBestSellingDrugResVo = new TopTenBestSellingDrugResVo();
                topTenBestSellingDrugResVo.setProductCode(rs.getString("product_code"));
                topTenBestSellingDrugResVo.setProductName(rs.getString("product_name"));
                topTenBestSellingDrugResVo.setTotalQuantitySold(rs.getString("total_quantity_sold"));
                result.add(topTenBestSellingDrugResVo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<AverageSalesRevenueOfStoreResVo>> averageSalesRevenueOfStores(Connection connection) {
        ArrayList<AverageSalesRevenueOfStoreResVo> result = new ArrayList<AverageSalesRevenueOfStoreResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT       category,       IFNULL(ROUND(SUM(category_sales.total_payment) / (COUNT(DISTINCT store_id)*10000), 2), 0) AS avg_store_sales,      SUM(category_sales.total_payment) AS category_sales_percentage_display      FROM (        SELECT             pdo.store_id,            CASE                WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4e2d\u897f\u6210\u836f' THEN '\u4e2d\u897f\u6210\u836f'              WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4e2d\u836f\u996e\u7247' THEN '\u4e2d\u836f\u996e\u7247'               WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4fdd\u5065\u98df\u54c1' THEN '\u4fdd\u5065\u98df\u54c1'              WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u533b\u7597\u5668\u68b0' THEN '\u533b\u7597\u5668\u68b0'                ELSE '\u5176\u4ed6'            END AS category,            SUM(pdpd.total_price) AS total_payment        FROM             ps_drug_order pdo        JOIN             ps_patient_store pps ON pps.id = pdo.store_id        JOIN             ps_drug_prescription_detail pdpd ON pdpd.order_id = pdo.id        JOIN             ps_drug_item pdi ON pdpd.drug_id = pdi.product_code        WHERE             pdo.create_time >= DATE_SUB(CURRENT_DATE, INTERVAL 365 DAY)            AND pdo.create_time < CURRENT_DATE            AND pdo.status = 1            AND pps.store_name  NOT LIKE '%DTP%'            AND pdo.patient_id is not null         AND pdi.special_new_type = 2       GROUP BY             pdo.store_id,           category  ) AS category_sales    GROUP BY         category ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                AverageSalesRevenueOfStoreResVo averageSalesRevenueOfStoreResVo = new AverageSalesRevenueOfStoreResVo();
                averageSalesRevenueOfStoreResVo.setAvgStoreSales(rs.getString("avg_store_sales"));
                averageSalesRevenueOfStoreResVo.setCategory(rs.getString("category"));
                averageSalesRevenueOfStoreResVo.setCategorySalesPercentageDisplay(rs.getString("category_sales_percentage_display"));
                result.add(averageSalesRevenueOfStoreResVo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<MonthlySalesDataByCategoryResVo>> monthlySalesDataByCategory(Connection connection) {
        ArrayList<MonthlySalesDataByCategoryResVo> result = new ArrayList<MonthlySalesDataByCategoryResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT    cd.category AS category,    cd.MONTH AS month,    IFNULL( ROUND( cd.total_category_payment / ( cd.store_count * 10000 ), 2 ), 0 ) AS avg_store_sales,     IFNULL(ROUND(cd.total_category_payment / (cd.store_count * 10000), 2), 0) AS category_sales_percentage    FROM    (    SELECT     CASE             WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4e2d\u897f\u6210\u836f' THEN '\u4e2d\u897f\u6210\u836f'               WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4e2d\u836f\u996e\u7247' THEN '\u4e2d\u836f\u996e\u7247'               WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4fdd\u5065\u98df\u54c1' THEN '\u4fdd\u5065\u98df\u54c1'               WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u533b\u7597\u5668\u68b0' THEN '\u533b\u7597\u5668\u68b0'               ELSE '\u5176\u4ed6'         END AS category ,     DATE_FORMAT( pdo.create_time, '%Y-%m' ) AS MONTH,       SUM( pdpd.total_price ) AS total_category_payment,       COUNT( DISTINCT pdo.store_id ) AS store_count      FROM       ps_drug_order pdo       JOIN ps_patient_store pps ON pps.id = pdo.store_id       JOIN ps_drug_prescription_detail pdpd ON pdpd.order_id = pdo.id       JOIN ps_drug_item pdi ON pdpd.drug_id = pdi.product_code      WHERE       pdo.create_time >= DATE_SUB( CURRENT_DATE, INTERVAL 11 MONTH )        AND pdo.create_time < CURRENT_DATE        AND pdo.STATUS = 1        AND pps.store_name NOT LIKE '%DTP%'        AND pdo.patient_id IS NOT NULL        AND pdi.special_new_type = 2    GROUP BY       category,       DATE_FORMAT( pdo.create_time, '%Y-%m' )      ) cd    ORDER BY    cd.MONTH,    cd.category; ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                MonthlySalesDataByCategoryResVo monthlySalesDataByCategoryResVo = new MonthlySalesDataByCategoryResVo();
                monthlySalesDataByCategoryResVo.setAvgStoreSales(rs.getString("avg_store_sales"));
                monthlySalesDataByCategoryResVo.setMonth(rs.getString("month"));
                monthlySalesDataByCategoryResVo.setCategorySalesPercentage(rs.getBigDecimal("category_sales_percentage"));
                monthlySalesDataByCategoryResVo.setCategory(rs.getString("category"));
                result.add(monthlySalesDataByCategoryResVo);
            }
            if (null != result && result.size() > 0) {
                Map<String, BigDecimal> monthlyTotal = result.stream().collect(Collectors.groupingBy(MonthlySalesDataByCategoryResVo::getMonth, Collectors.reducing(BigDecimal.ZERO, item -> item.getCategorySalesPercentage(), BigDecimal::add)));
                for (MonthlySalesDataByCategoryResVo monthlySalesDataByCategoryResVo : result) {
                    monthlySalesDataByCategoryResVo.setCategorySalesPercentage(monthlySalesDataByCategoryResVo.getCategorySalesPercentage().divide(monthlyTotal.get(monthlySalesDataByCategoryResVo.getMonth()), 3, RoundingMode.HALF_UP));
                }
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<AverageSalesRevenueOfStoreResVo>> averageSalesRevenueOfZXCPharmacy(Connection connection) {
        ArrayList<AverageSalesRevenueOfStoreResVo> result = new ArrayList<AverageSalesRevenueOfStoreResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT       category,       IFNULL(ROUND(SUM(category_sales.total_payment) / (COUNT(DISTINCT store_id)*10000), 2), 0) AS avg_store_sales,      SUM(category_sales.total_payment) AS category_sales_percentage_display      FROM (        SELECT             pdo.store_id,            CASE                WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1) = '\u4e2d\u897f\u6210\u836f,\u6d88\u5316\u7cfb\u7edf\u7528\u836f' THEN '\u6d88\u5316\u7cfb\u7edf\u7528\u836f'             WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1)= '\u4e2d\u897f\u6210\u836f,\u5fc3\u8111\u8840\u7ba1\u7528\u836f' THEN '\u5fc3\u8111\u8840\u7ba1\u7528\u836f'             WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1) = '\u4e2d\u897f\u6210\u836f,\u7cd6\u5c3f\u75c5\u7528\u836f' THEN '\u7cd6\u5c3f\u75c5\u7528\u836f'             WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1)= '\u4e2d\u897f\u6210\u836f,\u6e05\u70ed\u89e3\u6bd2\u7528\u836f' THEN '\u6e05\u70ed\u89e3\u6bd2\u7528\u836f'             ELSE '\u4e2d\u897f\u6210\u836f\u5176\u4ed6'         END AS category,            SUM(pdpd.total_price) AS total_payment        FROM             ps_drug_order pdo        JOIN             ps_patient_store pps ON pps.id = pdo.store_id        JOIN             ps_drug_prescription_detail pdpd ON pdpd.order_id = pdo.id        JOIN             ps_drug_item pdi ON pdpd.drug_id = pdi.product_code        WHERE             pdo.create_time >= DATE_SUB(CURRENT_DATE, INTERVAL 365 DAY)            AND pdo.create_time < CURRENT_DATE            AND pdo.status = 1            AND pps.store_name  NOT LIKE '%DTP%'            AND pdo.patient_id is not null         AND LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4e2d\u897f\u6210\u836f'         AND pdi.special_new_type = 2       GROUP BY             pdo.store_id,           category  ) AS category_sales    GROUP BY         category ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                AverageSalesRevenueOfStoreResVo averageSalesRevenueOfStoreResVo = new AverageSalesRevenueOfStoreResVo();
                averageSalesRevenueOfStoreResVo.setAvgStoreSales(rs.getString("avg_store_sales"));
                averageSalesRevenueOfStoreResVo.setCategory(rs.getString("category"));
                averageSalesRevenueOfStoreResVo.setCategorySalesPercentageDisplay(rs.getString("category_sales_percentage_display"));
                result.add(averageSalesRevenueOfStoreResVo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<MonthlySalesDataByCategoryResVo>> monthlySalesDataOfSegmentedTraditional(Connection connection) {
        ArrayList<MonthlySalesDataByCategoryResVo> result = new ArrayList<MonthlySalesDataByCategoryResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" SELECT     cd.category AS category,     cd.month AS month,     IFNULL(ROUND(cd.total_category_payment / (cd.store_count * 10000), 2), 0) AS avg_store_sales,     IFNULL(ROUND(cd.total_category_payment / (cd.store_count * 10000), 2), 0) AS category_sales_percentage FROM (     SELECT         CASE              WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1) = '\u4e2d\u897f\u6210\u836f,\u6d88\u5316\u7cfb\u7edf\u7528\u836f' THEN '\u6d88\u5316\u7cfb\u7edf\u7528\u836f'              WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1)= '\u4e2d\u897f\u6210\u836f,\u5fc3\u8111\u8840\u7ba1\u7528\u836f' THEN '\u5fc3\u8111\u8840\u7ba1\u7528\u836f'             WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1) = '\u4e2d\u897f\u6210\u836f,\u7cd6\u5c3f\u75c5\u7528\u836f' THEN '\u7cd6\u5c3f\u75c5\u7528\u836f'             WHEN LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category, LOCATE(',', pdi.drug_category) + 1) - 1)= '\u4e2d\u897f\u6210\u836f,\u6e05\u70ed\u89e3\u6bd2\u7528\u836f' THEN '\u6e05\u70ed\u89e3\u6bd2\u7528\u836f'             ELSE '\u4e2d\u897f\u6210\u836f\u5176\u4ed6'         END AS category,         DATE_FORMAT(pdo.create_time, '%Y-%m') AS month,         SUM(pdpd.total_price) AS total_category_payment,         COUNT(DISTINCT pdo.store_id) AS store_count     FROM         ps_drug_order pdo         JOIN ps_patient_store pps ON pps.id = pdo.store_id         JOIN ps_drug_prescription_detail pdpd ON pdpd.order_id = pdo.id         JOIN ps_drug_item pdi ON pdpd.drug_id = pdi.id     WHERE         pdo.create_time >= DATE_SUB(CURRENT_DATE, INTERVAL 11 MONTH)         AND pdo.create_time < CURRENT_DATE         AND pdo.status = 1         AND pps.store_name NOT LIKE '%DTP%'         AND pdo.patient_id IS NOT NULL         AND LEFT(pdi.drug_category, LOCATE(',', pdi.drug_category) - 1) = '\u4e2d\u897f\u6210\u836f'         AND pdi.special_new_type = 2     GROUP BY         category,         DATE_FORMAT(pdo.create_time, '%Y-%m') ) cd ORDER BY     cd.month,     cd.category; ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                MonthlySalesDataByCategoryResVo monthlySalesDataByCategoryResVo = new MonthlySalesDataByCategoryResVo();
                monthlySalesDataByCategoryResVo.setAvgStoreSales(rs.getString("avg_store_sales"));
                monthlySalesDataByCategoryResVo.setMonth(rs.getString("month"));
                monthlySalesDataByCategoryResVo.setCategorySalesPercentage(rs.getBigDecimal("category_sales_percentage"));
                monthlySalesDataByCategoryResVo.setCategory(rs.getString("category"));
                result.add(monthlySalesDataByCategoryResVo);
            }
            if (null != result && result.size() > 0) {
                Map<String, BigDecimal> monthlyTotal = result.stream().collect(Collectors.groupingBy(MonthlySalesDataByCategoryResVo::getMonth, Collectors.reducing(BigDecimal.ZERO, item -> item.getCategorySalesPercentage(), BigDecimal::add)));
                for (MonthlySalesDataByCategoryResVo monthlySalesDataByCategoryResVo : result) {
                    monthlySalesDataByCategoryResVo.setCategorySalesPercentage(monthlySalesDataByCategoryResVo.getCategorySalesPercentage().divide(monthlyTotal.get(monthlySalesDataByCategoryResVo.getMonth()), 3, RoundingMode.HALF_UP));
                }
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<MemberConsumptionConversionDataResVo> memberConsumptionConversionData(Connection connection) {
        MemberConsumptionConversionDataResVo result = new MemberConsumptionConversionDataResVo();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT        COUNT(DISTINCT CASE            WHEN create_time >= DATE_SUB(CURRENT_DATE, INTERVAL 24 MONTH)            THEN id        END) AS members_created,          COUNT(DISTINCT CASE            WHEN last_order_time IS NOT NULL                 AND last_order_time >= DATE_SUB(CURRENT_DATE, INTERVAL 24 MONTH)                 AND create_time >= DATE_SUB(CURRENT_DATE, INTERVAL 24 MONTH)            THEN id        END) AS active_members,          COUNT(DISTINCT CASE            WHEN order_count >= 2                AND last_order_time IS NOT NULL                 AND last_order_time >= DATE_SUB(CURRENT_DATE, INTERVAL 24 MONTH)                 AND create_time >= DATE_SUB(CURRENT_DATE, INTERVAL 24 MONTH)             THEN id        END) AS members_with_two_or_more_orders,          COUNT(DISTINCT id) AS cumulative_members   FROM (       SELECT            pi.id,           pi.create_time,           MAX(do.create_time) AS last_order_time,           COUNT(do.id) AS order_count       FROM            ps_patient_info pi      INNER JOIN ps_patient_store_reg r on r.patient_id = pi.id        AND r.status = 1 and r.patient_type = 2     LEFT JOIN  ps_drug_order do ON pi.id = do.patient_id           AND do.status = '1'  AND do.create_time >= DATE_SUB(CURRENT_DATE, INTERVAL 24 MONTH)      WHERE            pi.status = '1'         and r.pharmaceutical_company_id = '1'     GROUP BY            pi.id, pi.create_time   ) AS MemberStats;");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                result.setActiveMembers(rs.getString("active_members"));
                result.setMembersWithTwoOrMoreOrders(rs.getString("members_with_two_or_more_orders"));
                result.setMembersCreated(rs.getString("members_created"));
                result.setTotalMembersCreated(rs.getString("cumulative_members"));
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<ConsumerPerStoreRatioResVo>> consumerPerStoreRatio(Connection connection) {
        ArrayList<ConsumerPerStoreRatioResVo> result = new ArrayList<ConsumerPerStoreRatioResVo>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT       month,      monthly_consumers,      active_stores,      CASE           WHEN active_stores = 0 THEN NULL          ELSE ROUND(monthly_consumers / active_stores, 1)      END AS consumer_per_store_ratio  FROM (      SELECT           DATE_FORMAT(do.create_time, '%Y-%m') AS month,          COUNT(DISTINCT do.patient_id) AS monthly_consumers,          COUNT(DISTINCT do.store_id) AS active_stores      FROM           ps_drug_order do             JOIN ps_patient_store pps ON pps.id = do.store_id      WHERE           do.status = '1'          AND do.patient_id IS NOT NULL          AND pps.store_name NOT LIKE '%DTP%'          AND do.create_time >= DATE_SUB(DATE_FORMAT(CURRENT_DATE, '%Y-%m-01'), INTERVAL 11 MONTH)          AND do.create_time < DATE_ADD(DATE_FORMAT(CURRENT_DATE, '%Y-%m-01'), INTERVAL 1 MONTH)      GROUP BY           DATE_FORMAT(do.create_time, '%Y-%m')  ) AS MonthlyStats  ORDER BY       month DESC;");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                ConsumerPerStoreRatioResVo consumerPerStoreRatioResVo = new ConsumerPerStoreRatioResVo();
                consumerPerStoreRatioResVo.setMonth(rs.getString("month"));
                consumerPerStoreRatioResVo.setConsumerPerStoreRatio(rs.getBigDecimal("consumer_per_store_ratio").setScale(0, 4).toString());
                result.add(consumerPerStoreRatioResVo);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<MemberTransactionAnalysis> memberTransactionAnalysis(Connection connection) {
        MemberTransactionAnalysis result = new MemberTransactionAnalysis();
        Statement ps = null;
        ResultSet rs = null;
        try {
            String[] datesMonth = DateHelper.getDatesForComparison();
            String[] datesYear = DateHelper.getDatesForYearlyComparison();
            BigDecimal avgNewMembersPerStoreThisMonth = new BigDecimal(0);
            BigDecimal avgNewMembersPerStoreLastMonth = new BigDecimal(0);
            String querySqlAvgNewMembersPerStoreThisMonth = this.avgNewMembersPerStoreThisMonth(datesMonth[0], datesMonth[1]);
            ps = connection.prepareStatement(querySqlAvgNewMembersPerStoreThisMonth);
            rs = ps.executeQuery(querySqlAvgNewMembersPerStoreThisMonth);
            while (rs.next()) {
                avgNewMembersPerStoreThisMonth = rs.getBigDecimal("avg_new_members_per_store");
                result.setAvgNewMembersPerStoreThisMonth(rs.getBigDecimal("avg_new_members_per_store").setScale(0, 4));
            }
            String querySqlAvgNewMembersPerStoreLastMonth = this.avgNewMembersPerStoreThisMonth(datesMonth[2], datesMonth[3]);
            ps = connection.prepareStatement(querySqlAvgNewMembersPerStoreLastMonth);
            rs = ps.executeQuery(querySqlAvgNewMembersPerStoreLastMonth);
            while (rs.next()) {
                avgNewMembersPerStoreLastMonth = rs.getBigDecimal("avg_new_members_per_store");
                result.setAvgNewMembersPerStoreThisMonthHb(DateHelper.calculateYearGrowthRate((BigDecimal)avgNewMembersPerStoreThisMonth, (BigDecimal)avgNewMembersPerStoreLastMonth));
            }
            BigDecimal avgTransactionsPerMemberThisMonth = new BigDecimal(0);
            BigDecimal avgTransactionsPerMemberLastMonth = new BigDecimal(0);
            BigDecimal avgSalesPerMemberThisMonth = new BigDecimal(0);
            BigDecimal avgSalesPerMemberLastMonth = new BigDecimal(0);
            BigDecimal newConsumerPercentageThisMonth = new BigDecimal(0);
            BigDecimal newConsumerPercentageLastMonth = new BigDecimal(0);
            String avgTransactionsPerMemberThisMonthQuery = this.avgTransactionsPerMemberThisMonth(datesMonth[0], datesMonth[1]);
            ps = connection.prepareStatement(avgTransactionsPerMemberThisMonthQuery);
            rs = ps.executeQuery(avgTransactionsPerMemberThisMonthQuery);
            while (rs.next()) {
                avgTransactionsPerMemberThisMonth = rs.getBigDecimal("avg_transactions_per_member");
                result.setAvgTransactionsPerMemberThisMonth(rs.getBigDecimal("avg_transactions_per_member").setScale(1, 4));
                avgSalesPerMemberThisMonth = rs.getBigDecimal("avg_sales_per_member");
                result.setAvgSalesPerMemberThisMonth(rs.getBigDecimal("avg_sales_per_member").setScale(1, 4));
                newConsumerPercentageThisMonth = rs.getBigDecimal("new_consumer_percentage");
                result.setNewConsumerPercentageThisMonth(rs.getBigDecimal("new_consumer_percentage").setScale(1, 4).toString() + "%");
            }
            String avgTransactionsPerMemberLastMonthQuery = this.avgTransactionsPerMemberThisMonth(datesMonth[2], datesMonth[3]);
            ps = connection.prepareStatement(avgTransactionsPerMemberLastMonthQuery);
            rs = ps.executeQuery(avgTransactionsPerMemberLastMonthQuery);
            while (rs.next()) {
                avgTransactionsPerMemberLastMonth = rs.getBigDecimal("avg_transactions_per_member");
                avgSalesPerMemberLastMonth = rs.getBigDecimal("avg_sales_per_member");
                result.setAvgTransactionsPerMemberThisMonthHb(DateHelper.calculateYearGrowthRate((BigDecimal)avgTransactionsPerMemberThisMonth, (BigDecimal)avgTransactionsPerMemberLastMonth));
                result.setAvgSalesPerMemberThisMonthHb(DateHelper.calculateYearGrowthRate((BigDecimal)avgSalesPerMemberThisMonth, (BigDecimal)avgSalesPerMemberLastMonth));
                newConsumerPercentageLastMonth = rs.getBigDecimal("new_consumer_percentage");
                result.setNewConsumerPercentageThisMonthHb(DateHelper.calculateYearGrowthRate((BigDecimal)newConsumerPercentageThisMonth, (BigDecimal)newConsumerPercentageLastMonth));
            }
            BigDecimal repurchaseRateThisYear = new BigDecimal(0);
            BigDecimal repurchaseRateLastYear = new BigDecimal(0);
            BigDecimal avgConsumersPerStoreThisYear = new BigDecimal(0);
            BigDecimal averageOrderValueThisYear = new BigDecimal(0);
            BigDecimal averageOrderValueLastYear = new BigDecimal(0);
            BigDecimal avgConsumersPerStoreLastYear = new BigDecimal(0);
            String repurchaseRateThisYearQuery = this.avgTransactionsPerMemberThisMonth(datesYear[0], datesYear[1]);
            ps = connection.prepareStatement(repurchaseRateThisYearQuery);
            rs = ps.executeQuery(repurchaseRateThisYearQuery);
            while (rs.next()) {
                repurchaseRateThisYear = rs.getBigDecimal("repurchase_rate");
                averageOrderValueThisYear = rs.getBigDecimal("average_order_value");
                avgConsumersPerStoreThisYear = rs.getBigDecimal("avg_consumers_per_store_this_year");
                result.setRepurchaseRate(rs.getBigDecimal("repurchase_rate").setScale(1, 4));
                result.setAverageOrderValue(rs.getBigDecimal("average_order_value").setScale(2, 4));
                result.setAvgConsumersPerStoreThisYear(rs.getBigDecimal("avg_consumers_per_store_this_year").setScale(2, 4));
            }
            String repurchaseRateLastYearQuery = this.avgTransactionsPerMemberThisMonth(datesYear[2], datesYear[3]);
            ps = connection.prepareStatement(repurchaseRateLastYearQuery);
            rs = ps.executeQuery(repurchaseRateLastYearQuery);
            while (rs.next()) {
                repurchaseRateLastYear = rs.getBigDecimal("repurchase_rate");
                averageOrderValueLastYear = rs.getBigDecimal("average_order_value");
                avgConsumersPerStoreLastYear = rs.getBigDecimal("avg_consumers_per_store_this_year");
                result.setRepurchaseRateTb(DateHelper.calculateYearGrowthRate((BigDecimal)repurchaseRateThisYear, (BigDecimal)repurchaseRateLastYear));
                result.setAverageOrderValueTb(DateHelper.calculateYearGrowthRate((BigDecimal)averageOrderValueThisYear, (BigDecimal)averageOrderValueLastYear));
                result.setAvgConsumersPerStoreThisYearTb(DateHelper.calculateYearGrowthRate((BigDecimal)avgConsumersPerStoreThisYear, (BigDecimal)avgConsumersPerStoreLastYear));
            }
            BigDecimal avgMembersPerStoreThisYear = new BigDecimal(0);
            BigDecimal avgMembersPerStoreLastYear = new BigDecimal(0);
            String avgMembersPerStoreThisYearQuery = this.avgMembersPerStore(datesYear[1]);
            ps = connection.prepareStatement(avgMembersPerStoreThisYearQuery);
            rs = ps.executeQuery(avgMembersPerStoreThisYearQuery);
            while (rs.next()) {
                avgMembersPerStoreThisYear = rs.getBigDecimal("avg_members_per_store");
                result.setAvgMembersPerStore(rs.getBigDecimal("avg_members_per_store").setScale(0, 4));
            }
            String avgMembersPerStoreLastQuery = this.avgMembersPerStore(datesYear[3]);
            ps = connection.prepareStatement(avgMembersPerStoreLastQuery);
            rs = ps.executeQuery(avgMembersPerStoreLastQuery);
            while (rs.next()) {
                avgMembersPerStoreLastYear = rs.getBigDecimal("avg_members_per_store");
                result.setAvgMembersPerStoreTb(DateHelper.calculateYearGrowthRate((BigDecimal)avgMembersPerStoreThisYear, (BigDecimal)avgMembersPerStoreLastYear));
            }
            BigDecimal lostMemberRateThisYear = new BigDecimal(0);
            BigDecimal activeMemberRateThisYear = new BigDecimal(0);
            BigDecimal lostMemberRateLastYear = new BigDecimal(0);
            BigDecimal activeMemberRateLastYear = new BigDecimal(0);
            String lostMembersAndActiveMembersThisYearQuery = this.lostMembersAndActiveMembers(datesYear[1]);
            ps = connection.prepareStatement(lostMembersAndActiveMembersThisYearQuery);
            rs = ps.executeQuery(lostMembersAndActiveMembersThisYearQuery);
            while (rs.next()) {
                lostMemberRateThisYear = rs.getBigDecimal("lost_member_rate");
                activeMemberRateThisYear = rs.getBigDecimal("active_member_rate");
                result.setLostMembers(rs.getBigDecimal("lost_members"));
                result.setLostMemberRate(rs.getBigDecimal("lost_member_rate").setScale(1, 4).toString() + "%");
                result.setActiveMembers(rs.getBigDecimal("active_members"));
                result.setActiveMemberRate(rs.getBigDecimal("active_member_rate").setScale(1, 4).toString() + "%");
            }
            String lostMembersAndActiveMembersLastYearQuery = this.lostMembersAndActiveMembers(datesYear[1]);
            ps = connection.prepareStatement(lostMembersAndActiveMembersLastYearQuery);
            rs = ps.executeQuery(lostMembersAndActiveMembersLastYearQuery);
            while (rs.next()) {
                lostMemberRateLastYear = rs.getBigDecimal("lost_member_rate");
                activeMemberRateLastYear = rs.getBigDecimal("active_member_rate");
                result.setLostMemberRateTb(DateHelper.calculateYearGrowthRate((BigDecimal)lostMemberRateThisYear, (BigDecimal)lostMemberRateLastYear));
                result.setActiveMemberRateTb(DateHelper.calculateYearGrowthRate((BigDecimal)activeMemberRateThisYear, (BigDecimal)activeMemberRateLastYear));
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<ChronicDiseaseMembersResVo> chronicDiseaseMembers(Connection connection) {
        ChronicDiseaseMembersResVo result = new ChronicDiseaseMembersResVo();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String querySql = this.cumulativeChronicDiseaseMembers();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                result.setCumulativeChronicDiseaseMembers(rs.getString("cumulative_chronic_disease_members"));
            }
            String querySqlMonthOnMonthGrowthRate = this.monthOnMonthGrowthRate();
            ps = connection.prepareStatement(querySqlMonthOnMonthGrowthRate);
            rs = ps.executeQuery(querySqlMonthOnMonthGrowthRate);
            if (rs.next()) {
                result.setMonthOnMonthGrowthRate(rs.getString("month_on_month_growth_rate") + "%");
                result.setNewMembersThisMonth(rs.getString("new_members_this_month"));
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Map> chronicDiseaseMemberstAge(Connection connection) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            Date now = DateUtils.parseYMDDate((Date)new Date());
            Calendar c = Calendar.getInstance();
            c.setTime(now);
            c.add(1, -18);
            String under18 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -12);
            String under30 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -10);
            String under40 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -10);
            String under50 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            c.add(1, -10);
            String under60 = DateUtils.formatDate((Date)c.getTime(), (Object[])new Object[0]);
            StringBuffer sb = new StringBuffer();
            sb.append("select ");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday >= '" + under18 + "' THEN 1 ELSE 0 END) AS 'under18',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under18 + "' and p.patient_birthday >= '" + under30 + "' THEN 1 ELSE 0 END) AS '18-30',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under30 + "' and p.patient_birthday >= '" + under40 + "' THEN 1 ELSE 0 END) AS '30-40',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under40 + "' and p.patient_birthday >= '" + under50 + "' THEN 1 ELSE 0 END) AS '40-50',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under50 + "' and p.patient_birthday >= '" + under60 + "' THEN 1 ELSE 0 END) AS '50-60',");
            sb.append(" SUM(CASE 1 WHEN p.patient_birthday < '" + under60 + "' THEN 1 ELSE 0 END) AS 'after60'");
            sb.append(" from ps_patient_info p");
            sb.append(" inner join ps_patient_store_reg r on r.patient_id = p.id and r.status = 1 and r.patient_type = 2");
            sb.append(" where p.status = 1 and p.patient_birthday is not null and r.pharmaceutical_company_id = '1'");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer count1 = rs.getInt("under18");
                Integer count2 = rs.getInt("18-30");
                Integer count3 = rs.getInt("30-40");
                Integer count4 = rs.getInt("40-50");
                Integer count5 = rs.getInt("50-60");
                Integer count6 = rs.getInt("after60");
                result.put("0-18", count1);
                result.put("19-30", count2);
                result.put("31-40", count3);
                result.put("41-50", count4);
                result.put("51-60", count5);
                result.put("61-200", count6);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Map> memberDetectionData(Connection connection) {
        HashMap<String, String> result = new HashMap<String, String>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT       COUNT(*) AS annual_total_tests,      ROUND(COUNT(*) / NULLIF(COUNT(DISTINCT p.id), 0), 1) AS average_tests_per_person  FROM ps_threshold_patient_data tpd  JOIN ps_patient_info p ON tpd.patient_id = p.id  WHERE YEAR(tpd.quota_day) = YEAR(CURDATE()); ");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String count1 = rs.getString("annual_total_tests");
                String count2 = rs.getString("average_tests_per_person");
                result.put("annualTotalTests", count1);
                result.put("averageTestsPerPerson", count2);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<Map>> dailyTestCount(Connection connection) {
        ArrayList result = new ArrayList();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT       DATE(tpd.quota_day) AS test_date,      COUNT(*) AS daily_test_count  FROM ps_threshold_patient_data tpd  JOIN ps_patient_info p ON tpd.patient_id = p.id  WHERE quota_day >= CURDATE() - INTERVAL 6 DAY  GROUP BY DATE(quota_day)  ORDER BY test_date;");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String count1 = rs.getString("test_date");
                String count2 = rs.getString("daily_test_count");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("testDate", count1);
                map.put("dailyTestCount", count2);
                result.add(map);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Map> degreeCompletion(Connection connection) {
        HashMap<String, String> result = new HashMap<String, String>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String querySql = this.degreeCompletionSql();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String count1 = rs.getString("degreeCompletion");
                result.put("degreeCompletionMembers", count1);
            }
            String querySqlDiseaseMembers = this.cumulativeChronicDiseaseMembers();
            ps = connection.prepareStatement(querySqlDiseaseMembers);
            rs = ps.executeQuery(querySqlDiseaseMembers);
            while (rs.next()) {
                String count2 = rs.getString("cumulative_chronic_disease_members");
                result.put("totalMembers", count2);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<Map>> memberFollowUpData(Connection connection) {
        ArrayList result = new ArrayList();
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("  SELECT      (CASE ppfc.build_type          WHEN 6 THEN '\u68c0\u6d4b\u56de\u8bbf'          WHEN 9 THEN '\u81ea\u4e3b\u56de\u8bbf'          WHEN 10 THEN '\u8fc7\u836f\u56de\u8bbf'          ELSE '\u672a\u77e5\u7c7b\u578b'       END) AS taskTypeName,      COUNT(*) AS task_count  FROM      ps_patient_follow_task ppfc  WHERE      ppfc.status = 1       AND ppfc.build_type IN (6, 9, 10)      AND ppfc.follow_status = 1      AND ppfc.create_time >= CURDATE() - INTERVAL 29 DAY  GROUP BY      ppfc.build_type  ORDER BY      taskTypeName;");
            String querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String count1 = rs.getString("taskTypeName");
                String count2 = rs.getString("task_count");
                map.put(count1, count2);
                result.add(map);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientAge: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(result);
    }

    private String cumulativeChronicDiseaseMembers() {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT       COUNT(DISTINCT pi.id) AS cumulative_chronic_disease_members  FROM       ps_patient_info pi  JOIN       ps_patient_store_reg reg ON pi.id = reg.patient_id        AND reg.status = 1 AND reg.patient_type = 2   AND reg.pharmaceutical_company_id = 1 JOIN       ps_patient_disease_parameter AS ppdp ON  pi.id = ppdp.patient_id        AND ppdp.status =1       AND ppdp.first_record_time IS NOT NULL   WHERE       pi.status = 1 ");
        return sb.toString();
    }

    private String degreeCompletionSql() {
        StringBuffer sb = new StringBuffer();
        sb.append("         SELECT       COUNT(DISTINCT pi.id) AS degreeCompletion  FROM       ps_patient_info pi  JOIN       ps_patient_store_reg reg ON pi.id = reg.patient_id          AND reg.status = 1 AND reg.patient_type = 2  AND reg.pharmaceutical_company_id = 1  JOIN       ps_patient_disease_parameter AS ppdp ON  pi.id = ppdp.patient_id          AND ppdp.status =1         AND ppdp.first_record_time IS NOT NULL   WHERE       pi.status = 1         AND reg.pharmaceutical_company_id = 1      AND pi.id IN (     SELECT        patient_id      FROM        (        SELECT           *,           (( cun2 / cun1 ) * 100 ) cun3         FROM           ( SELECT count( 1 ) cun1, parent_id FROM ps_chronic_disease_template WHERE `status` = 1 AND is_select = 1 GROUP BY parent_id ) temp1           INNER JOIN ( SELECT count( 1 ) cun2, disease_id, patient_id FROM ps_patient_disease_parameter WHERE STATUS = 1 AND disease_id != - 1 AND submit_value != '' GROUP BY patient_id, disease_id ) temp2 ON temp1.parent_id = temp2.disease_id         ) temp3      WHERE        temp3.cun3 = 100      GROUP BY        patient_id      )  ");
        return sb.toString();
    }

    private String monthOnMonthGrowthRate() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT       DATE_FORMAT(pi.create_time, '%Y-%m') AS month,      COUNT(DISTINCT pi.id) AS new_members_this_month,      LAG(COUNT(DISTINCT pi.id), 1) OVER (ORDER BY DATE_FORMAT(pi.create_time, '%Y-%m')) AS new_members_last_month,      CASE           WHEN LAG(COUNT(DISTINCT pi.id), 1) OVER (ORDER BY DATE_FORMAT(pi.create_time, '%Y-%m')) IS NULL THEN NULL          ELSE ROUND(              (COUNT(DISTINCT pi.id) - LAG(COUNT(DISTINCT pi.id), 1) OVER (ORDER BY DATE_FORMAT(pi.create_time, '%Y-%m'))) /               LAG(COUNT(DISTINCT pi.id), 1) OVER (ORDER BY DATE_FORMAT(pi.create_time, '%Y-%m')) * 100, 1          )      END AS month_on_month_growth_rate  FROM       ps_patient_info pi  JOIN       ps_patient_store_reg reg ON pi.id = reg.patient_id        AND reg.status = 1 AND reg.patient_type = 2   AND reg.pharmaceutical_company_id = 1 JOIN       ps_patient_disease_parameter AS ppdp ON  pi.id = ppdp.patient_id        AND ppdp.status =1       AND ppdp.first_record_time IS NOT NULL   WHERE       pi.status = 1     AND pi.create_time >= DATE_SUB(DATE_FORMAT(CURRENT_DATE, '%Y-%m-01'), INTERVAL 1 MONTH)      AND pi.create_time < DATE_ADD(DATE_FORMAT(CURRENT_DATE, '%Y-%m-01'), INTERVAL 1 MONTH)  GROUP BY       DATE_FORMAT(pi.create_time, '%Y-%m')  ORDER BY       month DESC;  ");
        return sb.toString();
    }

    private String avgNewMembersPerStoreThisMonth(String startTime, String endTime) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT       ROUND(          COUNT( DISTINCT pi.id ) / NULLIF((             SELECT                COUNT( DISTINCT ps.id )              FROM                ps_patient_store ps              WHERE                ps.STATUS = 1               AND ps.pharmaceutical_company_id = 1  ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append(" AND ps.create_time < STR_TO_DATE('" + endTime + "' , '%Y-%m-%d') + INTERVAL 1 DAY ");
        }
        sb.append("            ), 0 ), 2 ) AS avg_new_members_per_store     FROM       ps_patient_info pi       join ps_patient_store_reg r on r.patient_id = pi.id and r.status = 1 and r.patient_type = 2    WHERE     pi.STATUS = 1  and r.pharmaceutical_company_id ='1' ");
        if (!StringUtils.isEmpty((Object)startTime)) {
            sb.append(" AND pi.create_time >= STR_TO_DATE('" + startTime + "' , '%Y-%m-%d') ");
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append(" AND pi.create_time < STR_TO_DATE('" + endTime + "' , '%Y-%m-%d') + INTERVAL 1 DAY ");
        }
        log.info("221212323   " + sb);
        return sb.toString();
    }

    private String avgMembersPerStore(String endTime) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT    ROUND(      ( SELECT COUNT( DISTINCT pi.id ) FROM ps_patient_info pi       JOIN ps_patient_store_reg r on r.patient_id = pi.id and r.status = 1 and r.patient_type = 2    WHERE       pi.STATUS = 1  and r.pharmaceutical_company_id ='1' ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append(" AND pi.create_time < STR_TO_DATE('" + endTime + "' , '%Y-%m-%d') + INTERVAL 1 DAY ");
        }
        sb.append(" ) / NULLIF(( SELECT COUNT( DISTINCT ps.id )       FROM ps_patient_store ps       WHERE       ps.STATUS = 1       AND ps.pharmaceutical_company_id = 1  ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append(" AND ps.create_time < STR_TO_DATE('" + endTime + "' , '%Y-%m-%d') + INTERVAL 1 DAY ");
        }
        sb.append("    ), 0 ),    2     ) AS avg_members_per_store; ");
        return sb.toString();
    }

    private String avgTransactionsPerMemberThisMonth(String startTime, String endTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT       ROUND(SUM(os.total_pay_amount) / NULLIF(COUNT(DISTINCT os.patient_id), 0), 2) AS avg_sales_per_member,      ROUND(COUNT(DISTINCT os.patient_id) / NULLIF((SELECT COUNT(DISTINCT id) FROM ps_patient_store WHERE status = 1), 0), 1) AS avg_consumers_per_store_this_year,      ROUND(SUM(os.order_count) / NULLIF(COUNT(DISTINCT os.patient_id), 0), 2) AS avg_transactions_per_member,      ROUND(COUNT(DISTINCT CASE WHEN os.order_count > 1 THEN os.patient_id END) / NULLIF(COUNT(DISTINCT os.patient_id), 0), 2) AS repurchase_rate,      ROUND(SUM(os.total_pay_amount) / NULLIF(COUNT(DISTINCT os.patient_id), 0), 2) AS average_order_value,  ");
        sb.append("    ROUND(  (COUNT(DISTINCT CASE ");
        if (!StringUtils.isEmpty((Object)startTime)) {
            sb.append("  WHEN DATE(os.patient_create_time) >=  STR_TO_DATE('" + startTime + "' , '%Y-%m-%d') ");
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append("  AND DATE(os.patient_create_time) < STR_TO_DATE('" + endTime + "' , '%Y-%m-%d') + INTERVAL 1 DAY ");
        }
        sb.append("THEN os.patient_id END) /    NULLIF(COUNT(DISTINCT os.patient_id), 0)) * 100, 2  ) AS new_consumer_percentage  ");
        sb.append(" FROM (      SELECT           do.patient_id,          COUNT(do.id) AS order_count,          SUM(do.pay_amount) AS total_pay_amount,          MIN(pi.create_time) AS patient_create_time     FROM ps_drug_order do      JOIN ps_patient_info pi ON do.patient_id = pi.id      JOIN ps_patient_store pps ON pps.id = do.store_id      WHERE do.status = '1'        AND do.patient_id IS NOT NULL        AND pps.store_name NOT LIKE '%DTP%'  ");
        if (!StringUtils.isEmpty((Object)startTime)) {
            sb.append(" AND do.create_time >= STR_TO_DATE('" + startTime + "' , '%Y-%m-%d') ");
        }
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append(" AND do.create_time < STR_TO_DATE('" + endTime + "' , '%Y-%m-%d') + INTERVAL 1 DAY ");
        }
        sb.append("    GROUP BY do.patient_id  ) AS os; ");
        return sb.toString();
    }

    private String lostMembersAndActiveMembers(String endTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT        COUNT(DISTINCT CASE    ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append("  WHEN last_order_time <= DATE_SUB('" + endTime + "', INTERVAL 12 MONTH)  ");
        }
        sb.append("        THEN id        END) AS lost_members,       ROUND(           COUNT(DISTINCT CASE    ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append("  WHEN last_order_time <= DATE_SUB('" + endTime + "', INTERVAL 12 MONTH)  ");
        }
        sb.append("            THEN id            END) / NULLIF(COUNT(DISTINCT id), 0), 4       )*100 AS lost_member_rate,       COUNT(DISTINCT CASE    ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append("  WHEN last_order_time >= DATE_SUB('" + endTime + "', INTERVAL 3 MONTH)  ");
        }
        sb.append("        THEN id        END) AS active_members,       ROUND(           COUNT(DISTINCT CASE    ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append("  WHEN last_order_time >= DATE_SUB('" + endTime + "', INTERVAL 3 MONTH)  ");
        }
        sb.append("  THEN id            END) / NULLIF(COUNT(DISTINCT id), 0), 4       )*100 AS active_member_rate,      COUNT(DISTINCT id) countNum   FROM (       SELECT            pi.id,           MAX(do.create_time) AS last_order_time       FROM            ps_patient_info pi       LEFT JOIN            ps_drug_order do ON pi.id = do.patient_id   AND do.status = '1' AND do.patient_id IS NOT NULL       WHERE        pi.status='1'   ");
        if (!StringUtils.isEmpty((Object)endTime)) {
            sb.append(" AND pi.create_time <= STR_TO_DATE('" + endTime + "' , '%Y-%m-%d')  ");
        }
        sb.append("    GROUP BY            pi.id   ) AS MemberStats; ");
        return sb.toString();
    }
}

