/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.starrocks;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ebaiyihui.dto.OrderListDto;
import com.ebaiyihui.dto.OrderListNewResDTO;
import com.ebaiyihui.dto.medicalInsurance.MedicalInsuranceListQo;
import com.ebaiyihui.vo.OrderListQO;
import com.ebaiyihui.vo.UserDataAuthsVO;
import com.ebaiyihui.vo.medicalInsurance.MedicalInsuranceListVo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StarRocksOrderUtils {
    private static final Logger log = LoggerFactory.getLogger(StarRocksOrderUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<OrderListDto>> queryOrderList(Connection connection, List<UserDataAuthsVO> userDataAuths, OrderListQO vo) {
        ArrayList<OrderListDto> list = new ArrayList<OrderListDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getOrderListSqlData(userDataAuths, vo));
        if (ObjectUtil.isNotEmpty((Object)vo.getPageIndex())) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        }
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                OrderListDto dto = new OrderListDto();
                String orderId = rs.getString("presChannelOrderId");
                String id = rs.getString("orderId");
                String presChannelName = rs.getString("presChannelName");
                String patientName = rs.getString("patientName");
                String patientId = rs.getString("patientId");
                int patientSex = rs.getInt("patientSex");
                String patientIdCard = rs.getString("patientIdCard");
                String patientBirthday = rs.getString("patientBirthday");
                String patientPhone = rs.getString("patientPhone");
                String patientSplitId = rs.getString("patientSplitId");
                int patientSplitSex = rs.getInt("patientSplitSex");
                String patientSplitName = rs.getString("patientSplitName");
                String patientSplitIdCard = rs.getString("patientSplitIdCard");
                String patientSplitBirthday = rs.getString("patientSplitBirthday");
                String patientSplitPhone = rs.getString("patientSplitPhone");
                String storeName = rs.getString("storeName");
                String orderAmount = rs.getString("orderAmount");
                String createTime = rs.getString("createTime");
                String drugName = rs.getString("drugName");
                int status = rs.getInt("status");
                String idCardNo = rs.getString("idCardNo");
                String memberNo = rs.getString("memberNo");
                String medicalType = rs.getString("medicalType");
                String memberName = rs.getString("memberName");
                String memberType = rs.getString("memberType");
                String coordinatedPay = rs.getString("coordinatedPay");
                String pdpId = rs.getString("pdpId");
                dto.setId(id);
                dto.setOrderId(orderId);
                dto.setPresChannelName(presChannelName);
                dto.setPatientId(patientId);
                dto.setPatientSex(Integer.valueOf(patientSex));
                dto.setPatientName(patientName);
                dto.setPatientIdCard(patientIdCard);
                dto.setPatientBirthday(patientBirthday);
                dto.setPatientPhone(patientPhone);
                dto.setPatientSplitId(patientSplitId);
                dto.setPatientSplitSex(Integer.valueOf(patientSplitSex));
                dto.setPatientSplitName(patientSplitName);
                dto.setPatientSplitIdCard(patientSplitIdCard);
                dto.setPatientSplitBirthday(patientSplitBirthday);
                dto.setPatientSplitPhone(patientSplitPhone);
                dto.setStoreName(storeName);
                dto.setOrderAmount(orderAmount);
                dto.setCreateTime(createTime);
                dto.setDrugName(drugName);
                dto.setStatus(Integer.valueOf(status));
                dto.setIdCardNo(idCardNo);
                dto.setMemberNo(memberNo);
                dto.setMedicalType(medicalType);
                dto.setMedicalType(medicalType);
                dto.setMemberName(memberName);
                dto.setMemberType(memberType);
                dto.setCoordinatedPay(coordinatedPay);
                dto.setEnterTypeName("\u5df2\u5f55\u5165");
                if (StringUtils.isEmpty((CharSequence)pdpId)) {
                    dto.setEnterTypeName("\u672a\u5f55\u5165");
                }
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryOrderList: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryOrderList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryOrderList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Integer> queryOrderListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, OrderListQO vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getOrderListSqlData(userDataAuths, vo));
        sb.append(" ) temp ");
        Integer count = 0;
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryOrderListCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryOrderListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private String getOrderListSqlData(List<UserDataAuthsVO> userDataAuths, OrderListQO vo) {
        int i;
        StringBuffer sb = new StringBuffer("SELECT                                                          ");
        sb.append("pdo.id AS orderId,                                                                       ");
        sb.append("any_value ( pdo.pres_channel_name ) AS presChannelName,                                  ");
        sb.append("any_value ( pdo.pres_channel_order_id ) AS presChannelOrderId,                           ");
        sb.append("any_value ( ppi.patient_name ) AS patientName,                                           ");
        sb.append("any_value ( ppi.id ) AS patientId,                                                       ");
        sb.append("any_value ( ppi.patient_sex ) AS patientSex,                                             ");
        sb.append("any_value ( ppi.patient_id_card ) AS patientIdCard,                                      ");
        sb.append("any_value ( ppi.patient_birthday ) AS patientBirthday,                                   ");
        sb.append("any_value ( ppi.patient_phone ) AS patientPhone,                                         ");
        sb.append("any_value ( ppsi.id ) AS patientSplitId,                                                 ");
        sb.append("any_value ( ppsi.patient_name ) AS patientSplitName,                                     ");
        sb.append("any_value ( ppsi.patient_sex ) AS patientSplitSex,                                       ");
        sb.append("any_value ( ppsi.patient_id_card ) AS patientSplitIdCard,                                ");
        sb.append("any_value ( ppsi.patient_birthday ) AS patientSplitBirthday,                             ");
        sb.append("any_value ( ppsi.patient_phone ) AS patientSplitPhone,                                   ");
        sb.append("any_value ( pps.store_name ) AS storeName,                                               ");
        sb.append("sum ( pdpd.total_price ) AS orderAmount,                                                 ");
        sb.append("any_value ( pdo.status ) AS status,                                                      ");
        sb.append("any_value ( pdo.id_card_no ) AS idCardNo,                                                ");
        sb.append("any_value ( pdo.member_no ) AS memberNo,                                                 ");
        sb.append("any_value ( pdo.medical_type ) AS medicalType,                                           ");
        sb.append("any_value ( pdo.member_name ) AS memberName,                                             ");
        sb.append("any_value ( pdo.member_type ) AS memberType,                                             ");
        sb.append("any_value ( pdo.coordinated_pay ) AS coordinatedPay,                                     ");
        sb.append("any_value ( pdp.id ) AS pdpId,                                                         ");
        sb.append("any_value (ifnull( pdo.pay_time, pdo.create_time )) AS createTime,                       ");
        sb.append("any_value ( pdo.store_id ) AS storeId,                                                   ");
        sb.append("array_join ( reverse( array_distinct ( array_agg ( pdpd.drug_name ))), ',' ) AS drugName ");
        sb.append("FROM ps_drug_order AS pdo                                                                ");
        sb.append("\tLEFT OUTER JOIN ps_patient_info AS ppi ON pdo.patient_id = ppi.id                       ");
        sb.append("\tLEFT OUTER JOIN ps_patient_split_info AS ppsi ON pdo.patient_split_id = ppsi.id         ");
        sb.append("\tLEFT OUTER JOIN ps_patient_store AS pps ON pdo.store_id = pps.id                        ");
        String joinType = StringUtils.isNotEmpty((CharSequence)vo.getEnterType()) && "1".equals(vo.getEnterType()) ? "INNER JOIN" : "LEFT JOIN";
        sb.append(String.format(" %s ps_drug_prescription AS pdp ON pdo.id = pdp.order_id", joinType));
        sb.append("\tINNER JOIN ps_drug_prescription_detail AS pdpd ON pdo.id = pdpd.order_id                ");
        sb.append(" where 1=1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPatientSearch())) {
            sb.append(" AND (ppi.patient_name LIKE '%" + vo.getPatientSearch() + "%' or ppi.patient_phone LIKE '%" + vo.getPatientSearch() + "%' )");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStoreName())) {
            sb.append(" AND pps.store_name LIKE '%" + vo.getStoreName() + "%'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getOrderCode())) {
            sb.append(" AND pdo.pres_channel_order_id LIKE '%" + vo.getOrderCode() + "%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getOrderSource())) {
            sb.append(" AND pdo.pres_channel_name LIKE '%" + vo.getOrderSource() + "%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getDrugName())) {
            sb.append(" AND pdpd.drug_name LIKE '%" + vo.getDrugName() + "%' ");
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getDrugIds())) {
            sb.append(" AND pdpd.drug_id in (");
            for (i = 0; i < vo.getDrugIds().size(); ++i) {
                if (i != vo.getDrugIds().size() - 1) {
                    sb.append("'" + (String)vo.getDrugIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getDrugIds().get(i) + "')");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getStoreIds())) {
            sb.append(" AND pdo.store_id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStartTime())) {
            sb.append(" AND ifnull(pdo.pay_time, pdo.create_time) >= '" + vo.getStartTime() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getEndTime())) {
            sb.append(" AND ifnull(pdo.pay_time, pdo.create_time) <= '" + vo.getEndTime() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getOrderStatus())) {
            sb.append(" AND pdo.status = " + vo.getOrderStatus() + " ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPatientType())) {
            if ("1".equals(vo.getPatientType())) {
                sb.append(" and pdo.patient_split_id is not null");
            } else {
                sb.append(" and pdo.patient_id is not null");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getEnterType()) && "2".equals(vo.getEnterType())) {
            sb.append("and pdp.order_id IS NULL               ");
        }
        sb.append(" GROUP BY pdo.id ");
        sb.append(" order by createTime desc");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> queryMedicalInsuranceListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, MedicalInsuranceListQo vo) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT COUNT(1) as cou FROM (SELECT any_value(pdo.patient_id)   FROM ps_drug_order pdo INNER JOIN ps_patient_info ppi ON pdo.patient_id = ppi.id LEFT JOIN ps_account_info pai ON pai.id = ppi.archives_create_person AND pai.`status` = 1 LEFT JOIN ps_patient_store_reg ppsr ON ppsr.patient_id = ppi.id AND ppsr.`status` = 1 AND ppsr.is_create_store = 1 left join ps_patient_org_store_reg pposr on pposr.store_id=pai.store_id LEFT JOIN ps_patient_org ppo on ppo.id = ifnull(split_part(pposr.org_id, ',', array_length(split(pposr.org_id,','))),pposr.org_id)  LEFT JOIN ps_patient_store pps ON pps.id = ppsr.store_id WHERE pdo.STATUS = 1 AND ppi.`status` = 1 AND pdo.member_name IS NOT NULL AND pdo.medical_type ='\u804c\u5de5\u7edf\u7b79' AND (pdo.member_type ='\u5728\u804c' or pdo.member_type ='\u9000\u4f11\u4eba\u5458' )");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'").append(userDataAuths.get(i).getId()).append("',");
                    continue;
                }
                sb.append("'").append(userDataAuths.get(i).getId()).append("')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getStoreIds())) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getOrgId())) {
            sb.append(" and pposr.org_id like '%" + vo.getOrgId() + "%'");
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getOrgIds())) {
            sb.append(" and (");
            for (i = 0; i < vo.getOrgIds().size(); ++i) {
                if (i != vo.getOrgIds().size() - 1) {
                    sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                    sb.append(" or ");
                    continue;
                }
                sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                sb.append(")");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getAccountIds())) {
            sb.append(" and pai.id in (");
            for (i = 0; i < vo.getAccountIds().size(); ++i) {
                if (i != vo.getAccountIds().size() - 1) {
                    sb.append("'" + (String)vo.getAccountIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getAccountIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientInfo())) {
            sb.append(" AND (ppi.patient_name LIKE '%" + vo.getPatientInfo() + "%'        or ppi.patient_phone LIKE '%" + vo.getPatientInfo() + "%'        or ppi.patient_member_no LIKE '%" + vo.getPatientInfo() + "%'        )");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getMedicalInfo())) {
            sb.append(" AND (pdo.member_name LIKE '%" + vo.getMedicalInfo() + "%'        or pdo.member_no LIKE '%" + vo.getMedicalInfo() + "%'        or pdo.id_card_no LIKE '%" + vo.getMedicalInfo() + "%'        )");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPayStartTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getPayStartTime() + "'and pdo.create_time<= '" + vo.getPayEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getPayStartTime() + "'and pdo.pay_time<= '" + vo.getPayEndTime() + "'))");
        }
        sb.append(" GROUP BY pdo.patient_id");
        sb.append(" order by pdo.patient_id ");
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<MedicalInsuranceListVo>> queryMedicalInsuranceList(Connection connection, List<UserDataAuthsVO> userDataAuths, MedicalInsuranceListQo vo, boolean isPage) {
        ArrayList<MedicalInsuranceListVo> list = new ArrayList<MedicalInsuranceListVo>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMedicalInsuranceListData(userDataAuths, vo));
        if (isPage) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                MedicalInsuranceListVo dto = new MedicalInsuranceListVo();
                String patientName = rs.getString("patientName");
                String patientId = rs.getString("patientId");
                dto.setPatientName(patientName);
                dto.setPatientId(patientId);
                String patientTelephone = rs.getString("patientTelephone");
                dto.setPatientTelephone(patientTelephone);
                String patientCardNo = rs.getString("patientCardNo");
                dto.setPatientCardNo(patientCardNo);
                String haveMedicalFlag = rs.getString("haveMedicalFlag");
                dto.setHaveMedicalFlag(haveMedicalFlag);
                String accountName = rs.getString("accountName");
                dto.setAccountName(accountName);
                String emplNo = rs.getString("emplNo");
                dto.setEmplNo(emplNo);
                String openStoreName = rs.getString("openStoreName");
                dto.setOpenStoreName(openStoreName);
                String storeCode = rs.getString("storeCode");
                String archivesCreateTime = rs.getString("archivesCreateTime");
                dto.setArchivesCreateTime(archivesCreateTime);
                String coordinatedPayStr = rs.getString("coordinatedPayStr");
                dto.setCoordinatedPayStr(coordinatedPayStr);
                dto.setStoreCode(storeCode);
                String orgName = rs.getString("orgName");
                dto.setOrgName(orgName);
                String orgId = rs.getString("orgId");
                dto.setOrgId(orgId);
                String consumerAmount = rs.getString("consumerAmount");
                dto.setConsumerAmount(consumerAmount);
                String memberNo = rs.getString("memberNo");
                dto.setMemberNo(memberNo);
                String memberName = rs.getString("memberName");
                dto.setMemberName(memberName);
                String idCardNo = rs.getString("idCardNo");
                dto.setIdCardNo(idCardNo);
                String coordinatedPay = rs.getString("coordinatedPay");
                dto.setCoordinatedPay(coordinatedPay);
                String medicalType = rs.getString("medicalType");
                dto.setMedicalType(medicalType);
                String memberType = rs.getString("memberType");
                dto.setMemberType(memberType);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getMedicalInsuranceListData(List<UserDataAuthsVO> userDataAuths, MedicalInsuranceListQo vo) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT any_value ( ppi.patient_name ) AS patientName,  any_value ( ppi.id ) AS patientId,  any_value ( ppi.patient_phone ) AS patientTelephone,   any_value ( ppi.patient_member_no ) AS patientCardNo,     any_value ( pai.login_name ) AS accountName,     any_value ( pai.empl_no ) AS emplNo,     any_value ( pps.store_name ) AS openStoreName,     any_value ( pps.store_code ) AS storeCode,     any_value ( ppmi.archives_create_time ) AS archivesCreateTime,     array_join ( array_sortby ( array_agg ( pdo.member_no ), array_agg ( pdo.create_time )), '@' ) AS memberNo,     cast(     sum( pdo.order_amount ) AS DECIMAL ( 32, 2 )) AS consumerAmount,     cast(     sum( pdo.coordinated_pay ) AS DECIMAL ( 32, 3 )) AS coordinatedPayStr,     array_join ( array_sortby ( array_agg ( pdo.coordinated_pay ), array_agg ( pdo.create_time )), '@' ) AS coordinatedPay,     array_join ( array_sortby ( array_agg ( pdo.id_card_no ), array_agg ( pdo.create_time )), '@' ) AS idCardNo,     array_join ( array_sortby ( array_agg ( pdo.member_name ), array_agg ( pdo.create_time )), '@' ) AS memberName,     array_join ( array_sortby ( array_agg ( pdo.medical_type ), array_agg ( pdo.create_time )), '@' ) AS medicalType,     array_join ( array_sortby ( array_agg ( pdo.member_type ), array_agg ( pdo.create_time )), '@' ) AS memberType,     any_value ( ppo.id ) AS orgId,     any_value ( ppo.org_name ) AS orgName,    (CASE WHEN any_value(ppmi.archives_create_time) IS NOT NULL THEN '\u662f' else '\u5426' end ) as haveMedicalFlag  FROM       ps_drug_order pdo       INNER JOIN ps_patient_info ppi ON pdo.patient_id = ppi.id       LEFT JOIN ps_patient_medical_insurance ppmi on pdo.patient_id=ppmi.patient_id       LEFT JOIN ps_account_info pai ON pai.id = ppmi.archives_create_person        AND pai.`status` = 1       LEFT JOIN ps_patient_store pps ON pps.id = pai.store_id        LEFT JOIN ps_patient_org_store_reg pposr ON pposr.store_id = pai.store_id     LEFT JOIN ps_patient_org ppo on ppo.id = ifnull(split_part(pposr.org_id, ',', array_length(split(pposr.org_id,','))),pposr.org_id)  WHERE  pdo.STATUS = 1 AND ppi.`status` = 1 AND pdo.member_name IS NOT NULL AND pdo.medical_type ='\u804c\u5de5\u7edf\u7b79' AND (pdo.member_type ='\u5728\u804c' or pdo.member_type ='\u9000\u4f11\u4eba\u5458' )");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getStoreIds())) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getOrgId())) {
            sb.append(" and pposr.org_id like '%" + vo.getOrgId() + "%'");
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getOrgIds())) {
            sb.append(" and (");
            for (i = 0; i < vo.getOrgIds().size(); ++i) {
                if (i != vo.getOrgIds().size() - 1) {
                    sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                    sb.append(" or ");
                    continue;
                }
                sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                sb.append(")");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getAccountIds())) {
            sb.append(" and pai.id in (");
            for (i = 0; i < vo.getAccountIds().size(); ++i) {
                if (i != vo.getAccountIds().size() - 1) {
                    sb.append("'" + (String)vo.getAccountIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getAccountIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientInfo())) {
            sb.append(" AND (ppi.patient_name LIKE '%" + vo.getPatientInfo() + "%'        or ppi.patient_phone LIKE '%" + vo.getPatientInfo() + "%'        or ppi.patient_member_no LIKE '%" + vo.getPatientInfo() + "%'        )");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getMedicalInfo())) {
            sb.append(" AND (pdo.member_name LIKE '%" + vo.getMedicalInfo() + "%'        or pdo.member_no LIKE '%" + vo.getMedicalInfo() + "%'        or pdo.id_card_no LIKE '%" + vo.getMedicalInfo() + "%'        )");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPayStartTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getPayStartTime() + "'and pdo.create_time<= '" + vo.getPayEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getPayStartTime() + "'and pdo.pay_time<= '" + vo.getPayEndTime() + "'))");
        }
        sb.append(" GROUP BY pdo.patient_id ");
        if (ObjectUtil.isNotEmpty((Object)vo.getHaveMedicalFlag())) {
            if ("1".equals(vo.getHaveMedicalFlag())) {
                sb.append("having haveMedicalFlag = '\u662f' ");
            } else if ("2".equals(vo.getHaveMedicalFlag())) {
                sb.append("having haveMedicalFlag = '\u5426' ");
            }
        }
        sb.append(" order by pdo.patient_id ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<OrderListNewResDTO>> queryPatientsByOrderList(Connection connection, List<UserDataAuthsVO> userDataAuths, OrderListQO vo) {
        ArrayList<OrderListNewResDTO> list = new ArrayList<OrderListNewResDTO>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getOrderMemberDayList(userDataAuths, vo));
        if (ObjectUtil.isNotEmpty((Object)vo.getPageIndex())) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        }
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        log.info("SQL===" + querySql);
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                OrderListNewResDTO dto = new OrderListNewResDTO();
                String patientId = rs.getString("patientId");
                String createTime = rs.getString("createTime");
                dto.setPatientId(patientId);
                dto.setCreateTime(createTime);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryOrderList: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryOrderList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryOrderList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getOrderMemberDayList(List<UserDataAuthsVO> userDataAuths, OrderListQO vo) {
        int i;
        StringBuffer sb = new StringBuffer("SELECT                                                          ");
        sb.append("any_value ( ppi.id ) AS patientId,                                                       ");
        sb.append("any_value (pdo.create_time ) AS createTime                        ");
        sb.append("FROM ps_drug_order AS pdo                                                                ");
        sb.append("\tINNER JOIN ps_patient_info AS ppi ON pdo.patient_id = ppi.id                              ");
        sb.append(" where 1=1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getStoreIds()) && vo.getStoreIds().size() > 1) {
            sb.append(" AND pdo.store_id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        } else if (!CollectionUtils.isEmpty((Collection)vo.getStoreIds()) && vo.getStoreIds().size() <= 1) {
            sb.append(" AND pdo.store_id = ");
            sb.append("'" + (String)vo.getStoreIds().get(0) + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStartTime())) {
            sb.append(" AND  pdo.create_time >= '" + vo.getStartTime() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getEndTime())) {
            sb.append(" AND  pdo.create_time <= '" + vo.getEndTime() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getOrderStatus())) {
            sb.append(" AND pdo.status = " + vo.getOrderStatus() + " ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPatientType())) {
            if ("1".equals(vo.getPatientType())) {
                sb.append(" and pdo.patient_split_id is not null");
            } else {
                sb.append(" and pdo.patient_id is not null");
            }
        }
        sb.append(" and ppi.`status` = 1 ");
        sb.append(" GROUP BY pdo.id ");
        return sb.toString();
    }
}

