/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.starrocks;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ebaiyihui.common.enums.ConsumerTimeType;
import com.ebaiyihui.common.enums.PortraitSceneTypeEnum;
import com.ebaiyihui.common.enums.QueryConsumerPreferenceEnum;
import com.ebaiyihui.common.enums.QueryCouponPreferenceEnum;
import com.ebaiyihui.dto.PatientInfoDTO;
import com.ebaiyihui.dto.backList.BackListInfoDto;
import com.ebaiyihui.dto.portrait.MemberPatientDto;
import com.ebaiyihui.dto.portrait.MemberQueryConditionQo;
import com.ebaiyihui.dto.portrait.MemberQueryDetailQo;
import com.ebaiyihui.dto.portrait.MemberQueryListQo;
import com.ebaiyihui.dto.portrait.PortraitRmfDto;
import com.ebaiyihui.utils.DateUtils;
import com.ebaiyihui.utils.ObjectUtils;
import com.ebaiyihui.vo.PatientInFoListVo;
import com.ebaiyihui.vo.UserDataAuthsVO;
import com.ebaiyihui.vo.portrait.MemberActListVo;
import com.ebaiyihui.vo.portrait.MemberDegListVo;
import com.ebaiyihui.vo.portrait.MemberQueryDetailVo;
import com.ebaiyihui.vo.portrait.MemberRmfListVo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StarRocksPatientUtils {
    private static final Logger log = LoggerFactory.getLogger(StarRocksPatientUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<PatientInfoDTO>> queryProgramPatientInfo(Connection connection, String storeId, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo) {
        ArrayList<PatientInfoDTO> list = new ArrayList<PatientInfoDTO>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getProgramPatientSqlData(userDataAuths, storeId, vo));
        int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
        sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                PatientInfoDTO dto = new PatientInfoDTO();
                String id = rs.getString("patientInfoId");
                String patientName = rs.getString("patientName");
                String patientPhone = rs.getString("patientPhone");
                int patientSex = rs.getInt("patientSex");
                String patientIdCard = rs.getString("patientIdCard");
                String patientBirthday = rs.getString("patientBirthday");
                String icdCode = rs.getString("icdCode");
                String icdName = rs.getString("icdName");
                String archivesCreatePerson1 = rs.getString("archivesCreatePerson1");
                String archivesCreatePerson2 = rs.getString("archivesCreatePerson2");
                String storeName = rs.getString("storeName");
                String storeId_ = rs.getString("storeId");
                String patientMemberNo = rs.getString("patientMemberNo");
                String formatDateTime = rs.getString("createTime");
                dto.setPatientInfoId(id);
                dto.setPatientName(patientName);
                dto.setPatientPhone(patientPhone);
                dto.setPatientSex(Integer.valueOf(patientSex));
                dto.setPatientIdCard(patientIdCard);
                dto.setPatientBirthday(patientBirthday);
                dto.setIcdCodeStr(icdCode);
                dto.setIcdNameStr(icdName);
                dto.setPatientMemberNo(patientMemberNo);
                dto.setArchivesCreatePerson1(archivesCreatePerson1);
                dto.setArchivesCreatePerson2(archivesCreatePerson2);
                dto.setStoreName(storeName);
                dto.setStoreId(storeId_);
                dto.setStoreCreateTime(formatDateTime);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryProgramPatientInfo: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryProgramPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryProgramPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getProgramPatientSqlData(List<UserDataAuthsVO> userDataAuths, String storeId, PatientInFoListVo vo) {
        int i;
        StringBuffer sb = new StringBuffer("SELECT * from patient_applet_list_mv palm  ");
        sb.append(" where 1=1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and palm.storeId in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getAccountId())) {
            sb.append("  AND palm.patientInfoId in (SELECT id FROM ps_patient_info WHERE archives_create_person= '" + vo.getAccountId() + "' and status!=-1) ");
        }
        if ((ObjectUtil.isNotEmpty((Object)vo.getArchivistId()) || ObjectUtil.isNotEmpty((Object)vo.getMztcCreateId())) && CollectionUtil.isNotEmpty((Collection)vo.getPatientIds())) {
            sb.append(" and palm.patientInfoId in (");
            for (i = 0; i < vo.getPatientIds().size(); ++i) {
                if (i != vo.getPatientIds().size() - 1) {
                    sb.append("'" + (String)vo.getPatientIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getPatientIds().get(i) + "')");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchContent())) {
            sb.append("AND (palm.patientName = '" + vo.getSearchContent() + "' or palm.patientPhone = '" + vo.getSearchContent() + "')");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStoreId())) {
            sb.append(" AND palm.storeId = '" + vo.getStoreId() + "'");
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getIcdCodes())) {
            sb.append("AND palm.patientInfoId in (             select ppif.id             from ps_patient_info ppif                      left join ps_patient_icd_reg ppirf on ppif.id = ppirf.patient_id and ppirf.status = 1             where    ppirf.icd_id in (");
            for (i = 0; i < vo.getIcdCodes().size(); ++i) {
                if (i == vo.getIcdCodes().size() - 1) {
                    sb.append(" '" + (String)vo.getIcdCodes().get(i) + "'");
                    continue;
                }
                sb.append(" '" + (String)vo.getIcdCodes().get(i) + "',");
            }
            sb.append(" ) ) ");
        }
        sb.append(" order by ");
        if (Objects.nonNull(storeId)) {
            sb.append(" (case when palm.storeId = '" + storeId + "' then 0 else 1 end),");
        }
        sb.append(" palm.ppati_createtime desc ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Integer> queryProgramPatientInfoCount(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getProgramPatientSqlData(userDataAuths, null, vo));
        sb.append(" ) temp");
        Integer count = 0;
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<PatientInfoDTO>> queryPatientInfo(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo) {
        ArrayList<PatientInfoDTO> list = new ArrayList<PatientInfoDTO>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlData(userDataAuths, vo, Boolean.valueOf(false)));
        int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
        if (ObjectUtil.isEmpty((Object)vo.getQueryConsumptionVo().getNoConsumerDay())) {
            sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        }
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                PatientInfoDTO dto = new PatientInfoDTO();
                String id = rs.getString("patientInfoId");
                String patientName = rs.getString("patientName");
                String patientHeadPortrait = rs.getString("patientHeadPortrait");
                String patientPhone = rs.getString("patientPhone");
                String patientMemberNo = rs.getString("patientMemberNo");
                int patientSex = rs.getInt("patientSex");
                String patientIdCard = rs.getString("patientIdCard");
                String patientBirthday = rs.getString("patientBirthday");
                String detailAddress = rs.getString("detailAddress");
                String archivesCreatePerson = rs.getString("archivesCreatePerson");
                String empNo = rs.getString("empNo");
                String createPerson = rs.getString("createPerson");
                String storeId = rs.getString("storeId");
                String storeName = rs.getString("storeName");
                String storeCode = rs.getString("storeCode");
                String prescriptionList = rs.getString("prescriptionList1");
                String storeList = rs.getString("storeList1");
                String storeListCodes = rs.getString("storeListCodes");
                String formatDateTime = rs.getString("ppati_createTime");
                String icdCode = rs.getString("icdCode");
                String icdName = rs.getString("icdName");
                String patientType = rs.getString("patientType");
                String memberLevel = rs.getString("memberLevel");
                String memberValue = rs.getString("memberValue");
                String archivesCreatePerson1 = rs.getString("archivesCreatePerson1");
                String recordCreateTime = rs.getString("archivesCreateTime");
                String archivesCreateStoreName = rs.getString("archivesCreateStoreName");
                String archivesCreateStoreCode = rs.getString("archivesCreateStoreCode");
                String patientSourceChanelName = rs.getString("patientSourceChanelName");
                dto.setPatientSourceChanelName(patientSourceChanelName);
                String medicalInsurancePerson = rs.getString("medicalInsurancePerson");
                String medicalInsurancePersonNo = rs.getString("medicalInsurancePersonNo");
                String medicalInsuranceStoreName = rs.getString("medicalInsuranceStoreName");
                String medicalInsuranceStoreCode = rs.getString("medicalInsuranceStoreCode");
                String medicalInsuranceTime = rs.getString("medicalInsuranceTime");
                String archivesCreatePersonNo = rs.getString("archivesCreatePersonNo");
                dto.setMedicalInsurancePerson(medicalInsurancePerson);
                dto.setMedicalInsurancePersonNo(medicalInsurancePersonNo);
                dto.setMedicalInsuranceStoreName(medicalInsuranceStoreName);
                dto.setMedicalInsuranceStoreCode(medicalInsuranceStoreCode);
                dto.setMedicalInsuranceTime(medicalInsuranceTime);
                dto.setArchivesCreatePersonNo(archivesCreatePersonNo);
                dto.setStoreCreateTime(formatDateTime);
                dto.setPatientType(patientType);
                dto.setMemberLevel(memberLevel);
                dto.setMemberValue(memberValue);
                dto.setPatientInfoId(id);
                dto.setPatientName(patientName);
                dto.setPatientHeadPortrait(patientHeadPortrait);
                dto.setPatientPhone(patientPhone);
                dto.setPatientMemberNo(patientMemberNo);
                dto.setPatientSex(Integer.valueOf(patientSex));
                dto.setPatientIdCard(patientIdCard);
                dto.setPatientBirthday(patientBirthday);
                dto.setDetailAddress(detailAddress);
                dto.setStoreCode(storeCode);
                dto.setStoreListCodes(storeListCodes);
                dto.setRecordCreatePerson(archivesCreatePerson1);
                dto.setRecordCreateTime(recordCreateTime);
                dto.setArchivesCreateStoreName(archivesCreateStoreName);
                dto.setArchivesCreateStoreCode(archivesCreateStoreCode);
                dto.setEmpNo(empNo);
                if (StringUtils.isNotEmpty((CharSequence)archivesCreatePerson)) {
                    dto.setArchivesCreatePerson(archivesCreatePerson);
                } else {
                    dto.setArchivesCreatePerson(createPerson);
                }
                dto.setStoreId(storeId);
                dto.setStoreName(storeName);
                dto.setPrescriptionListStr(prescriptionList);
                dto.setStoreListStr(storeList);
                dto.setArchivesCreateTime(formatDateTime);
                dto.setIcdCodeStr(icdCode);
                dto.setIcdNameStr(icdName);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Integer> queryPatientInfoCount(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getSqlData(userDataAuths, vo, Boolean.valueOf(false)));
        sb.append(" ) temp");
        Integer count = 0;
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<PatientInfoDTO>> queryPatientInfoV2(Connection connection, String userStoreId, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo, Boolean exportFlag) {
        ArrayList<PatientInfoDTO> list = new ArrayList<PatientInfoDTO>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlDataV2(userDataAuths, vo, userStoreId, Boolean.valueOf(false), exportFlag));
        if (!(!ObjectUtil.isNotEmpty((Object)vo.getPageIndex()) || ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo()) && ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getNoConsumerDay()))) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        }
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                PatientInfoDTO dto = new PatientInfoDTO();
                String id = rs.getString("patientInfoId");
                String formatDateTime = rs.getString("ppati_createTime");
                String patientName = rs.getString("patientName");
                String patientPhone = rs.getString("patientPhone");
                String patientMemberNo = rs.getString("patientMemberNo");
                int patientSex = rs.getInt("patientSex");
                String patientIdCard = rs.getString("patientIdCard");
                String patientBirthday = rs.getString("patientBirthday");
                String archivesCreatePerson = rs.getString("archivesCreatePerson");
                String createPerson = rs.getString("createPerson");
                String storeName = rs.getString("storeName");
                String patientType = rs.getString("patientType");
                String memberLevel = rs.getString("memberLevel");
                String memberValue = rs.getString("memberValue");
                String patientSourceChanelName = rs.getString("patientSourceChanelName");
                String storeId = rs.getString("storeId");
                String storeList = rs.getString("storeList1");
                dto.setStoreCreateTime(formatDateTime);
                dto.setPatientType(patientType);
                dto.setMemberLevel(memberLevel);
                dto.setMemberValue(memberValue);
                dto.setPatientInfoId(id);
                dto.setPatientName(patientName);
                dto.setPatientPhone(patientPhone);
                dto.setPatientMemberNo(patientMemberNo);
                dto.setPatientSex(Integer.valueOf(patientSex));
                dto.setPatientIdCard(patientIdCard);
                dto.setPatientBirthday(patientBirthday);
                dto.setPatientSourceChanelName(patientSourceChanelName);
                if (StringUtils.isNotEmpty((CharSequence)archivesCreatePerson)) {
                    dto.setArchivesCreatePerson(archivesCreatePerson);
                }
                dto.setStoreName(storeName);
                dto.setStoreId(storeId);
                dto.setStoreListStr(storeList);
                dto.setArchivesCreateTime(formatDateTime);
                String detailAddress = rs.getString("detailAddress");
                dto.setDetailAddress(detailAddress);
                if (exportFlag.booleanValue()) {
                    String empNo = rs.getString("empNo");
                    String storeCode = rs.getString("storeCode");
                    String prescriptionList = rs.getString("prescriptionList1");
                    String storeListCodes = rs.getString("storeListCodes");
                    String icdCode = rs.getString("icdCode");
                    String icdName = rs.getString("icdName");
                    String archivesCreatePerson1 = rs.getString("archivesCreatePerson1");
                    String recordCreateTime = rs.getString("archivesCreateTime");
                    String archivesCreateStoreName = rs.getString("archivesCreateStoreName");
                    String archivesCreateStoreCode = rs.getString("archivesCreateStoreCode");
                    String medicalInsurancePerson = rs.getString("medicalInsurancePerson");
                    String medicalInsurancePersonNo = rs.getString("medicalInsurancePersonNo");
                    String medicalInsuranceStoreName = rs.getString("medicalInsuranceStoreName");
                    String medicalInsuranceStoreCode = rs.getString("medicalInsuranceStoreCode");
                    String medicalInsuranceTime = rs.getString("medicalInsuranceTime");
                    String archivesCreatePersonNo = rs.getString("archivesCreatePersonNo");
                    dto.setMedicalInsurancePerson(medicalInsurancePerson);
                    dto.setMedicalInsurancePersonNo(medicalInsurancePersonNo);
                    dto.setMedicalInsuranceStoreName(medicalInsuranceStoreName);
                    dto.setMedicalInsuranceStoreCode(medicalInsuranceStoreCode);
                    dto.setMedicalInsuranceTime(medicalInsuranceTime);
                    dto.setArchivesCreatePersonNo(archivesCreatePersonNo);
                    dto.setStoreCode(storeCode);
                    dto.setStoreListCodes(storeListCodes);
                    dto.setRecordCreatePerson(archivesCreatePerson1);
                    dto.setRecordCreateTime(recordCreateTime);
                    dto.setArchivesCreateStoreName(archivesCreateStoreName);
                    dto.setArchivesCreateStoreCode(archivesCreateStoreCode);
                    dto.setEmpNo(empNo);
                    dto.setPrescriptionListStr(prescriptionList);
                    dto.setIcdCodeStr(icdCode);
                    dto.setIcdNameStr(icdName);
                }
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Integer> queryPatientInfoCountV2(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo, Boolean exportFlag) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getSqlDataV2(userDataAuths, vo, null, Boolean.valueOf(false), Boolean.valueOf(false)));
        sb.append(" ) temp");
        Integer count = 0;
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<String>> getPatientIdsByConditions(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlDataV2(userDataAuths, vo, null, Boolean.valueOf(true), Boolean.valueOf(false)));
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String id = rs.getString("patientInfoId");
                list.add(id);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientIdsByConditions: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientIdsByConditions: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientIdsByConditions: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getSqlDataV2(List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo, String storeId, Boolean idOnly, Boolean exportFlag) {
        StringBuffer sb = new StringBuffer();
        if (exportFlag.booleanValue()) {
            sb.append(" SELECT * FROM (SELECT ");
            sb.append(" ppati.id AS patientInfoId, ");
            sb.append(" any_value ( ppati.archives_create_time ) AS ppati_createTime, ");
            sb.append(" any_value ( ppati.patient_name ) AS patientName, ");
            sb.append(" any_value ( ppati.patient_head_portrait ) AS patientHeadPortrait, ");
            sb.append(" any_value ( ppati.patient_phone ) AS patientPhone, ");
            sb.append(" any_value ( ppati.patient_member_no ) AS patientMemberNo, ");
            sb.append(" any_value ( ppati.patient_sex ) AS patientSex, ");
            sb.append(" any_value ( ppati.patient_id_card ) AS patientIdCard, ");
            sb.append(" any_value ( ppati.patient_birthday ) AS patientBirthday, ");
            sb.append(" any_value ( ppati.detail_address ) AS detailAddress, ");
            sb.append(" any_value ( pai.login_name ) AS archivesCreatePerson, ");
            sb.append(" any_value ( pai.empl_no ) AS empNo, ");
            sb.append(" any_value ( ppati.archives_create_person ) AS createPerson, ");
            sb.append(" any_value ( ppss.id ) AS storeId, ");
            sb.append(" any_value ( ppss.store_name ) AS storeName, ");
            sb.append(" any_value ( ppss.store_code ) AS storeCode, ");
            sb.append(" any_value ( ppati.patient_card_type ) AS patientCardType, ");
            sb.append(" any_value ( ppati.patient_type ) AS patientType, ");
            sb.append(" any_value ( ppati.member_level ) AS memberLevel, ");
            sb.append(" any_value ( ppati.member_value ) AS memberValue, ");
            sb.append(" any_value ( ppati.medical_type ) AS medicalType, ");
            sb.append(" any_value ( ppati.patient_medicine ) AS patientMedicine, ");
            sb.append(" any_value ( ppati.patient_medicine_currency ) AS patientMedicineCurrency, ");
            sb.append(" any_value ( ppati.patient_medicine_tumour ) AS patientMedicineTumour, ");
            sb.append(" any_value ( pdp.hospital_id ) AS hospitalId, ");
            sb.append(" any_value ( ppati.source_channel_name ) AS patientSourceChanelName, ");
            sb.append(" any_value ( pdp.department_id ) AS departmentId, ");
            sb.append(" any_value ( pdp.doctor_id ) AS doctorId, ");
            sb.append(" min ( ppsr.store_id ) AS storeIdFilter, ");
            sb.append(" any_value ( ppsr.pharmaceutical_company_id ) AS pharmaceuticalCompanyId, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( ppsr.store_id ))), ',' ) AS storeIdList, ");
            sb.append(" any_value ( `t1`.`login_name` ) AS archivesCreatePerson1, ");
            sb.append(" any_value ( pphrec.first_record_time ) AS archivesCreateTime, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pii.icd_code ))), ',' ) AS icdCode, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pii.icd_name ))), ',' ) AS icdName, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pps.store_name ))), ',' ) AS storeList1, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pps.store_code ))), ',' ) AS storeListCodes, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pdp.pres_hospital_name ))), ',' ) AS prescriptionList1, ");
            sb.append(" any_value ( t1.store_id ) AS archivesCreateStore, ");
            sb.append(" any_value ( t1.empl_no ) AS archivesCreatePersonNo, ");
            sb.append(" any_value ( ppsss.store_code ) AS archivesCreateStoreCode, ");
            sb.append(" any_value ( ppsss.store_name ) AS archivesCreateStoreName, ");
            sb.append(" any_value ( ppati.patient_currency_update_time ) AS archivesCurrencyUpdateTime, ");
            sb.append(" any_value ( ppati.patient_currency_create_person ) AS archivesCurrencyUpdatePerson, ");
            sb.append(" any_value ( ppati.patient_tumour_update_time ) AS archivesTumorUpdateTime, ");
            sb.append(" any_value ( ppati.patient_tumour_create_person ) AS archivesTumorUpdatePerson, ");
            sb.append(" any_value ( t3.login_name ) AS medicalInsurancePerson, ");
            sb.append(" any_value ( t3.empl_no ) AS medicalInsurancePersonNo, ");
            sb.append(" any_value ( t2.store_name ) AS medicalInsuranceStoreName, ");
            sb.append(" any_value ( t2.store_code ) AS medicalInsuranceStoreCode, ");
            sb.append(" any_value ( ppmi.archives_create_time ) AS medicalInsuranceTime, ");
            sb.append(" array_max (array_concat (array_append ([], ");
            sb.append(" any_value ( ppati.patient_currency_update_time )),array_append ([], ");
            sb.append(" any_value ( ppati.patient_tumour_update_time )))) AS archivesAllUpdateTime, ");
            sb.append(" split_part (array_join (reverse(array_sortby ( ");
            sb.append(" array_concat (array_append ([],any_value ( ppati.patient_currency_create_person )),array_append ([],any_value ( ppati.patient_tumour_create_person ))), ");
            sb.append(" array_concat (array_append ([],any_value ( ppati.patient_currency_update_time )),array_append ([],any_value ( ppati.patient_tumour_update_time ))))),'-'),'-',1) AS archivesAllUpdatePerson ");
            sb.append(" FROM ps_patient_info AS ppati ");
            sb.append(" \tINNER JOIN  ps_patient_store_reg AS ppsr ON ( ppsr.patient_id = ppati.id ) ");
            sb.append(" \tAND ( ppsr.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS pps ON pps.id = ppsr.store_id ");
            sb.append(" \tLEFT OUTER JOIN  ps_account_info AS pai ON pai.id = ppati.archives_create_person ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store_reg AS ppsrr ON (( ppsrr.patient_id = ppati.id ) ");
            sb.append(" \tAND ( ppsrr.is_create_store = 1 )) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS ppss ON ( ppss.id = ppsrr.store_id ) ");
            sb.append(" \tAND ( ppss.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_icd_reg AS ppir ON ( ppati.id = ppir.patient_id ) ");
            sb.append(" \tAND ( ppir.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_icd_item AS pii ON ( ppir.icd_id = pii.icd_code ) ");
            sb.append(" \tAND ( pii.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_disease_parameter AS pphrec ON ( ppati.id = pphrec.patient_id ) ");
            sb.append(" \tAND ( `pphrec`.`first_record_time` IS NOT NULL ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_account_info AS t1 ON ( pphrec.first_record_person = t1.id ) ");
            sb.append(" \tAND ( t1.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS ppsss ON ( ppsss.id = t1.store_id ) ");
            sb.append(" \tAND ( ppsss.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_drug_prescription AS pdp ON ( ppati.id = pdp.patient_id ) ");
            sb.append(" \tAND ( pdp.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_condition_tumour_diagnosis AS pctd ON ( ppati.id = pctd.patient_id ) ");
            sb.append(" \tAND ( pctd.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_medical_insurance AS ppmi ON ( ppati.id = ppmi.patient_id ) ");
            sb.append(" \tAND ( ppmi.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_account_info AS t3 ON ( t3.id = ppmi.archives_create_person ) ");
            sb.append(" \tAND ( t3.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS t2 ON ( t2.id = t3.store_id ) ");
            sb.append(" \tAND ( t2.STATUS = 1 ) ");
            sb.append(" WHERE ppati.STATUS = 1 ");
            sb.append(" GROUP BY ppati.id) pmlm");
        } else {
            sb.append("SELECT " + (idOnly != false ? "patientInfoId" : "*") + " from patient_manage_list_mv_v2 pmlm ");
        }
        sb.append(" where 1=1 ");
        this.dealUserDataAuth(userDataAuths, sb);
        this.exportByPatientIds(vo, sb);
        this.quickSearchContent(vo, sb);
        this.queryPatientInfoByCondition(vo, sb, "2");
        this.queryPatientPortraitInfoByCondition(vo, sb);
        this.queryDtpMedicineByCondition(vo, sb);
        this.queryDtpPrescriptionByCondition(vo, sb);
        this.queryConsumerAndDrugByCondition(vo, sb, "2");
        this.queryChronicByCondition(vo, sb);
        this.queryHealthCheckByCondition(vo, sb);
        this.queryMedicalInsuranceCondition(vo, sb);
        this.queryDeleteMethodCondition(vo, sb);
        this.queryOtherInfoByCondition(vo, sb);
        if (!idOnly.booleanValue()) {
            sb.append(" order by ");
            if (Objects.nonNull(storeId)) {
                sb.append(" (case when pmlm.storeId = '" + storeId + "' then 0 else 1 end),");
            }
            sb.append(" pmlm.ppati_createtime desc ");
        }
        return sb.toString();
    }

    private String getSqlData(List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo, Boolean idOnly) {
        StringBuffer sb = new StringBuffer("SELECT " + (idOnly != false ? "patientInfoId" : "*") + " from patient_manage_list_mv pmlm ");
        sb.append(" where 1=1 ");
        this.dealUserDataAuth(userDataAuths, sb);
        this.exportByPatientIds(vo, sb);
        this.quickSearchContent(vo, sb);
        this.queryPatientInfoByCondition(vo, sb, "2");
        this.queryDtpMedicineByCondition(vo, sb);
        this.queryDtpPrescriptionByCondition(vo, sb);
        this.queryConsumerAndDrugByCondition(vo, sb, "2");
        this.queryChronicByCondition(vo, sb);
        this.queryHealthCheckByCondition(vo, sb);
        this.queryMedicalInsuranceCondition(vo, sb);
        this.queryDeleteMethodCondition(vo, sb);
        this.queryOtherInfoByCondition(vo, sb);
        if (idOnly.booleanValue()) {
            sb.append(" order by pmlm.patientInfoId ");
        } else {
            sb.append(" order by pmlm.ppati_createtime desc ");
        }
        return sb.toString();
    }

    private void queryDeleteMethodCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryDeleteMethodVo())) {
            this.getDeleteSmsPatient(vo, sb);
            this.getDeleteConsumerPatient(vo, sb);
            this.getDeleteFollowPatient(vo, sb);
            this.getQueryDeleteCouponPatient(vo, sb);
        }
    }

    private void getQueryDeleteCouponPatient(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryDeleteMethodVo().getDeleteCouponPatient())) {
            String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
            String startTime = DateUtils.formatDate((Date)DateUtils.addDay((Date)DateUtils.addDay((Date)new Date(), (int)(-Integer.parseInt(vo.getQueryDeleteMethodVo().getDeleteCouponPatient()))), (int)1), (Object[])new Object[0]);
            sb.append(" AND pmlm.patientInfoId not in ( ");
            sb.append("SELECT pcpr.patient_id FROM ps_coupon_patient_reg pcpr WHERE `status`=1 ");
            sb.append("  and pcpr.create_time >= '" + startTime + " 00:00:00' ");
            sb.append(" AND pcpr.create_time <= '" + now + " 23:59:59' ");
            sb.append(" ) ");
        }
    }

    private void getDeleteFollowPatient(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryDeleteMethodVo().getDeleteFollowPatient())) {
            String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
            String startTime = DateUtils.formatDate((Date)DateUtils.addDay((Date)DateUtils.addDay((Date)new Date(), (int)(-Integer.parseInt(vo.getQueryDeleteMethodVo().getDeleteFollowPatient()))), (int)1), (Object[])new Object[0]);
            sb.append(" AND pmlm.patientInfoId not in ( ");
            sb.append("SELECT ppft.patient_id FROM ps_patient_follow_task ppft WHERE ppft.follow_status=4 ");
            sb.append("  and ppft.visit_completetime >= '" + startTime + " 00:00:00' ");
            sb.append(" AND ppft.visit_completetime <= '" + now + " 23:59:59' ");
            sb.append(" ) ");
        }
    }

    private void getDeleteConsumerPatient(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryDeleteMethodVo().getDeleteConsumerPatient())) {
            String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
            String startTime = DateUtils.formatDate((Date)DateUtils.addDay((Date)DateUtils.addDay((Date)new Date(), (int)(-Integer.parseInt(vo.getQueryDeleteMethodVo().getDeleteConsumerPatient()))), (int)1), (Object[])new Object[0]);
            sb.append(" AND pmlm.patientInfoId not in ( ");
            sb.append("select pdo.patient_id from ps_drug_order pdo where ");
            sb.append(" pdo.create_time >= '" + startTime + " 00:00:00' ");
            sb.append(" AND pdo.create_time <= '" + now + " 23:59:59' ");
            sb.append("and pdo.patient_id is not null ");
            sb.append(" and pdo.status=1");
            sb.append(" ) ");
        }
    }

    private void getDeleteSmsPatient(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryDeleteMethodVo().getDeleteSmsPatient())) {
            String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
            String startTime = DateUtils.formatDate((Date)DateUtils.addDay((Date)DateUtils.addDay((Date)new Date(), (int)(-Integer.parseInt(vo.getQueryDeleteMethodVo().getDeleteSmsPatient()))), (int)1), (Object[])new Object[0]);
            sb.append(" AND pmlm.patientPhone not in ( ");
            sb.append("SELECT phone_num FROM ps_sms_send_detail pssd WHERE pssd.report_time is not NULL");
            sb.append(" and pssd.report_time >= '" + startTime + " 00:00:00' ");
            sb.append(" AND pssd.report_time <= '" + now + " 23:59:59' ");
            sb.append("and pssd.phone_num is not null");
            sb.append(" ) ");
        }
    }

    private void queryMedicalInsuranceCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicalInsuranceVo())) {
            this.getHasMedicalInsuranceRecord(vo, sb);
            this.getMedicalStoreIds(vo, sb);
            this.getMedicalRecordPerson(vo, sb);
            this.getMedicalRecordTime(vo, sb);
        }
    }

    private void getMedicalRecordTime(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryMedicalInsuranceVo().getMedicalRecodeCreateTime()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryMedicalInsuranceVo().getMedicalRecodeEndTime())) {
            sb.append(" AND pmlm.patientInfoId in( ");
            sb.append(" SELECT ppmi.patient_id FROM ps_patient_medical_insurance ppmi  INNER JOIN ps_account_info pai on pai.id=ppmi.archives_create_person WHERE ppmi.`status`=1 and pai.`status`=1  ");
            sb.append(" and ppmi.archives_create_time >= '" + vo.getQueryMedicalInsuranceVo().getMedicalRecodeCreateTime() + " 00:00:00' ");
            sb.append(" AND ppmi.archives_create_time <= '" + vo.getQueryMedicalInsuranceVo().getMedicalRecodeEndTime() + " 23:59:59' ");
            sb.append(")");
        }
    }

    private void getMedicalRecordPerson(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicalInsuranceVo().getMedicalRecodeCreatePerson())) {
            sb.append(" AND pmlm.patientInfoId in ( ");
            sb.append(" SELECT ppmi.patient_id FROM ps_patient_medical_insurance ppmi  INNER JOIN ps_account_info pai on pai.id=ppmi.archives_create_person WHERE ppmi.`status`=1 and pai.`status`=1");
            sb.append(" and  pai.login_name like '%" + vo.getQueryMedicalInsuranceVo().getMedicalRecodeCreatePerson() + "%') ");
        }
    }

    private void getMedicalStoreIds(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicalInsuranceVo().getMedicalRecodeStoreIds())) {
            sb.append(" AND pmlm.patientInfoId in ( ");
            sb.append(" SELECT ppmi.patient_id FROM ps_patient_medical_insurance ppmi  INNER JOIN ps_account_info pai on pai.id=ppmi.archives_create_person WHERE ppmi.`status`=1 and pai.`status`=1 and pai.store_id in(  ");
            String[] split = vo.getQueryMedicalInsuranceVo().getMedicalRecodeStoreIds().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' ))");
            }
        }
    }

    private void getHasMedicalInsuranceRecord(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryMedicalInsuranceVo().getHasMedicalInsurance())) {
            if ("1".equals(vo.getQueryMedicalInsuranceVo().getHasMedicalInsurance())) {
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append("SELECT patient_id FROM ps_patient_medical_insurance WHERE `status`=1  ) ");
            } else {
                sb.append(" AND pmlm.patientInfoId  not in ( ");
                sb.append("SELECT patient_id FROM ps_patient_medical_insurance WHERE `status`=1  ) ");
            }
        }
    }

    private void queryOtherInfoByCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getStoreId())) {
            sb.append(" AND pmlm.storeId = '" + vo.getStoreId() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStoreName())) {
            sb.append("AND pmlm.storeList1 REGEXP '(^|,)" + vo.getStoreName() + "($|,)'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getArchivist())) {
            sb.append("AND pmlm.archivesCreatePerson LIKE '%" + vo.getArchivist() + "%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getDiseaseType())) {
            sb.append("AND pmlm.icdName like REGEXP '(^|,)" + vo.getDiseaseType() + "($|,)'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getHasPrescription()) && "1".equals(vo.getHasPrescription())) {
            sb.append("AND pmlm.patientInfoId in (            select patient_id from ps_drug_prescription pdp where pdp.status =1            group by pdp.patient_id)");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getHasPrescription()) && "2".equals(vo.getHasPrescription())) {
            sb.append("AND pmlm.patientInfoId not in (            select patient_id from ps_drug_prescription pdp where pdp.status =1            group by pdp.patient_id)");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStartTime())) {
            sb.append(" AND pmlm.ppati_createTime >= '" + vo.getStartTime() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getEndTime())) {
            sb.append(" AND pmlm.ppati_createTime <= '" + vo.getEndTime() + "'");
        }
    }

    private void queryHealthCheckByCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (Objects.nonNull(vo.getQueryHealthyVo())) {
            this.getHasCheck(vo, sb);
            this.getCheckResult(vo, sb);
            this.getCheckStore(vo, sb);
            this.getCheckPerson(vo, sb);
            this.getCheckTime(vo, sb);
        }
    }

    private void getCheckTime(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryHealthyVo().getDetectionStartTime()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryHealthyVo().getDetectionEndTime())) {
            sb.append(" AND pmlm.patientInfoId in( ");
            sb.append("select ptpd.patient_id from ps_threshold_patient_data ptpd where ");
            sb.append(" ptpd.quota_day >= '" + vo.getQueryHealthyVo().getDetectionStartTime() + " 00:00:00' ");
            sb.append(" AND ptpd.quota_day <= '" + vo.getQueryHealthyVo().getDetectionEndTime() + " 23:59:59' ");
            sb.append(" group by ptpd.patient_id )");
        }
    }

    private void getCheckPerson(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryHealthyVo().getDetectionPerson())) {
            sb.append(" AND pmlm.patientInfoId in( ");
            sb.append("select ptpd.patient_id from ps_threshold_patient_data ptpd where ");
            sb.append(" ptpd.create_name like '%" + vo.getQueryHealthyVo().getDetectionPerson() + "%' ");
            sb.append(" group by ptpd.patient_id )");
        }
    }

    private void getCheckStore(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryHealthyVo().getDetectionStore())) {
            sb.append(" AND pmlm.patientInfoId in( ");
            sb.append("select ptpd.patient_id from ps_threshold_patient_data ptpd where ");
            sb.append(" ptpd.store_id in (");
            String[] split = vo.getQueryHealthyVo().getDetectionStore().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
            sb.append(" group by ptpd.patient_id )");
        }
    }

    private void getCheckResult(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryHealthyVo().getDetectionResult())) {
            if ("1".equals(vo.getQueryHealthyVo().getDetectionResult())) {
                sb.append(" AND pmlm.patientInfoId in( ");
                sb.append(" select a.patient_id from ps_threshold_patient_data a where a.patient_id in ( select patient_id from ps_threshold_patient_data ptpd where ptpd.exception_flag != 2  ) and a.patient_id not in (select patient_id from ps_threshold_patient_data ptpd where ptpd.exception_flag = 2 ) group  by patient_id ");
                sb.append(" ) ");
            } else {
                sb.append(" AND pmlm.patientInfoId in( ");
                sb.append("select ptpd.patient_id from ps_threshold_patient_data ptpd where ");
                sb.append(" ptpd.exception_flag = " + vo.getQueryHealthyVo().getDetectionResult() + " ");
                sb.append(" group by ptpd.patient_id )");
            }
        }
    }

    private void getHasCheck(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryHealthyVo().getHasCheck())) {
            if (1 == Integer.parseInt(vo.getQueryHealthyVo().getHasCheck())) {
                sb.append(" AND pmlm.patientInfoId in (            select patient_id from ps_threshold_patient_data ptpdd where ptpdd.status =1             group by ptpdd.patient_id) ");
            } else if (2 == Integer.parseInt(vo.getQueryHealthyVo().getHasCheck())) {
                sb.append(" AND pmlm.patientInfoId not in (            select patient_id from ps_threshold_patient_data ptpdd where ptpdd.status =1             group by ptpdd.patient_id) ");
            }
        }
    }

    private void queryChronicByCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryChronicVo())) {
            this.getChronicMedicineByDisease(vo, sb);
            this.getHasChronicRecord(vo, sb);
            this.getHasMztc(vo, sb);
            this.getChronicMedicineRatio(vo, sb);
            this.getChronicPatientValue(vo, sb);
            this.getChronicPatientAct(vo, sb);
        }
        this.getChronicStaffRecord(vo, sb);
        this.getChronicStaffRecordTime(vo, sb);
        this.getChonicStaffRecordStore(vo, sb);
    }

    private void getChonicStaffRecordStore(PatientInFoListVo vo, StringBuffer sb) {
        if (Objects.nonNull(vo.getQueryChronicVo()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getStaffRecodeStoreIds())) {
            sb.append(" and pmlm.archivesCreateStore in (");
            String[] split = vo.getQueryChronicVo().getStaffRecodeStoreIds().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
    }

    private void getChronicStaffRecordTime(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryChronicVo()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getStaffRecodeCreateTime())) {
            sb.append("AND pmlm.archivesCreateTime >= '" + vo.getQueryChronicVo().getStaffRecodeCreateTime() + "'");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryChronicVo()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getStaffRecodeEndTime())) {
            sb.append("AND pmlm.archivesCreateTime <= '" + vo.getQueryChronicVo().getStaffRecodeEndTime() + "'");
        }
    }

    private void getChronicStaffRecord(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryChronicVo()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getStaffRecodeCreatePerson())) {
            sb.append("AND pmlm.archivesCreatePerson1 LIKE '%" + vo.getQueryChronicVo().getStaffRecodeCreatePerson() + "%' ");
        }
    }

    private void getChronicPatientAct(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getActivityLevel())) {
            sb.append(" AND pmlm.memberLevel in (");
            String[] split = vo.getQueryChronicVo().getActivityLevel().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
    }

    private void getChronicPatientValue(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getMembershipValue())) {
            sb.append(" AND pmlm.memberValue in (");
            String[] split = vo.getQueryChronicVo().getMembershipValue().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
    }

    private void getChronicMedicineRatio(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getChronicIntegrityStart()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getChronicIntegrityEnd())) {
            sb.append(" AND pmlm.patientInfoId in ( ");
            sb.append("select patient_id from ( select *, ((cun2 / cun1) * 100) cun3 from (select count(1) cun1, parent_id from ps_chronic_disease_template where `status`=1  and is_select=1 group by parent_id ) temp1 inner join ( SELECT count(1) cun2, disease_id , patient_id FROM ps_patient_disease_parameter WHERE status  =1  and disease_id != -1 and submit_value!='' group by patient_id,disease_id) temp2 on temp1.parent_id = temp2.disease_id) temp3 where temp3.cun3 <= " + vo.getQueryChronicVo().getChronicIntegrityEnd() + " and temp3.cun3 >= " + vo.getQueryChronicVo().getChronicIntegrityStart() + " group by patient_id");
            sb.append(" )");
        }
    }

    private void getHasMztc(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getHasMztc()) && "1".equals(vo.getQueryChronicVo().getHasMztc())) {
            sb.append(" AND pmlm.patientInfoId in (");
            sb.append(" SELECT p.patient_id from ps_patient_disease_parameter p INNER JOIN ps_chronic_disease_template tem ON p.disease_option_id = tem.id  where tem.`name` = '\u901a\u7528\u836f\u5386' and p.patient_id in (  SELECT t.patient_id FROM (SELECT patient_id,count( patient_id ) cn FROM ps_patient_disease_parameter par WHERE  par.disease_id = - 1 AND par.`status` = 1 GROUP BY par.patient_id HAVING cn = 1 ) t )) ");
            sb.append(" and pmlm.patientInfoId not in (select patient_id from ps_patient_health_records where status = 1 and patient_id is not null) ");
        }
    }

    private void getHasChronicRecord(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getHasRecord())) {
            if ("1".equals(vo.getQueryChronicVo().getHasRecord())) {
                sb.append(" AND pmlm.archivesCreateTime is not null ");
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append("select ppdp.patient_id from ps_patient_disease_parameter ppdp where ppdp.status =1 ) ");
            } else {
                sb.append(" AND pmlm.archivesCreateTime is null  ");
            }
        }
    }

    private void getChronicMedicineByDisease(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryChronicVo().getChronicDisease())) {
            sb.append(" AND pmlm.patientInfoId in ( ");
            sb.append("select ppdp.patient_id from ps_patient_disease_parameter ppdp where ");
            sb.append("  ppdp.disease_option_id in (");
            String[] split = vo.getQueryChronicVo().getChronicDisease().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" " + split[i] + " ,");
                    continue;
                }
                sb.append(" " + split[i] + " )");
            }
            sb.append(" and ppdp.status =1 )");
        }
    }

    private void queryConsumerAndDrugByCondition(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo()) && !ObjectUtils.allFieldIsNULL((Object)vo.getQueryConsumptionVo()) || ObjectUtil.isNotEmpty((Object)vo.getQueryDrugInfoVo()) && !ObjectUtils.allFieldIsNULL((Object)vo.getQueryDrugInfoVo())) {
            int i;
            Object split;
            String col = Objects.equals("1", type) ? "patient_split_id" : "patient_id";
            sb.append(" AND pmlm.patientInfoId ");
            if (Objects.equals("2", vo.getQueryConsumptionVo().getHasConsumption())) {
                sb.append(" not ");
            }
            sb.append(" in (");
            sb.append("select ");
            sb.append(col).append(" from ps_drug_order pdo");
            if (ObjectUtil.isNotEmpty((Object)vo.getQueryDrugInfoVo()) && !ObjectUtils.allFieldIsNULL((Object)vo.getQueryDrugInfoVo())) {
                sb.append(" inner join ps_drug_prescription_detail pdpd on pdo.id = pdpd.order_id and pdpd.status = 1");
                sb.append(" inner join ps_drug_item pdi on pdi.id=pdpd.drug_id and pdi.status = 1");
                if (ObjectUtil.isNotEmpty((Object)vo.getQueryDrugInfoVo().getGroupIds())) {
                    sb.append(" inner join ps_group_drug_link pgdl on pdi.id=pgdl.drug_item_id and pgdl.status = 1  inner join ps_group_management pgm on pgm.id=pgdl.group_id ");
                    sb.append(" and pgm. id = '" + vo.getQueryDrugInfoVo().getGroupIds() + "'");
                }
            }
            sb.append(" where pdo.status=1 ");
            if (StringUtils.isNotEmpty((CharSequence)vo.getQueryConsumptionVo().getHasConsumption())) {
                sb.append(" and pdo.").append(col).append(" is not null ");
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getQueryConsumptionVo().getConsumptionStartTime()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryConsumptionVo().getConsumptionEndTime()) && vo.getXfFlag() == 0) {
                sb.append(" and ifnull(pdo.pay_time,pdo.create_time) >= '" + vo.getQueryConsumptionVo().getConsumptionStartTime() + " 00:00:00' ");
                sb.append(" and ifnull(pdo.pay_time,pdo.create_time) <= '" + vo.getQueryConsumptionVo().getConsumptionEndTime() + " 23:59:59' ");
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getQueryConsumptionVo().getSalesStores())) {
                sb.append(" and pdo.store_id in (");
                split = vo.getQueryConsumptionVo().getSalesStores().split(",");
                for (i = 0; i < ((String[])split).length; ++i) {
                    if (i != ((String[])split).length - 1) {
                        sb.append(" '" + split[i] + "' ,");
                        continue;
                    }
                    sb.append(" '" + split[i] + "' )");
                }
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getNoConsumerDay()) && vo.getXfFlag() == 1) {
                String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
                String startTime = DateUtils.formatDate((Date)DateUtils.addDay((Date)new Date(), (int)(-vo.getQueryConsumptionVo().getNoConsumerDay().intValue())), (Object[])new Object[0]);
                sb.append(" and ( ifnull(pdo.pay_time,pdo.create_time) >= '" + startTime + " 00:00:00' ");
                sb.append(" and ifnull(pdo.pay_time,pdo.create_time) <= '" + now + " 23:59:59' ) ");
            }
            if (ObjectUtil.isNotEmpty((Object)vo.getQueryDrugInfoVo())) {
                if (ObjectUtil.isNotEmpty((Object)vo.getQueryDrugInfoVo().getPurchaseMedicine())) {
                    sb.append(" and pdpd.drug_id in (");
                    split = vo.getQueryDrugInfoVo().getPurchaseMedicine().split(",");
                    for (i = 0; i < ((String[])split).length; ++i) {
                        if (i != ((String[])split).length - 1) {
                            sb.append(" '" + (String)split[i] + "' ,");
                            continue;
                        }
                        sb.append(" '" + (String)split[i] + "' )");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)vo.getQueryDrugInfoVo().getManufacturer())) {
                    sb.append(" and pdi.manufacturer LIKE '%" + vo.getQueryDrugInfoVo().getManufacturer() + "%'");
                }
                if (ObjectUtil.isNotEmpty((Object)vo.getQueryDrugInfoVo().getChronicType())) {
                    sb.append(" and split_part(pdi.drug_category, ',', array_length(split(pdi.drug_category,','))) in ( ");
                    split = vo.getChronicTypeNames();
                    for (i = 0; i < split.size(); ++i) {
                        if (i != split.size() - 1) {
                            sb.append(" '" + (String)split.get(i) + "' ,");
                            continue;
                        }
                        sb.append(" '" + (String)split.get(i) + "' )");
                    }
                }
            }
            sb.append("group by pdo.").append(col).append(") ");
            this.getConsumerFrequency(vo, sb, type);
            this.getLastConsumptionTime(vo, sb, type);
            this.getLastConsumerStore(vo, sb, type);
            this.getConsumerAmount(vo, sb, type);
            this.getConsumerUnitPrice(vo, sb, type);
            this.getConsumerPreference(vo, sb, type);
            this.getCouponPreference(vo, sb);
        }
    }

    private void queryDtpPrescriptionByCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryPrescriptionVo())) {
            this.getHasDtpPrescription(vo, sb);
            this.getDtpPrescriptionByDoctor(vo, sb);
            this.getDtpPrescriptionByHos(vo, sb);
            this.getDtpPrescriptionByDep(vo, sb);
            this.getDtpPrescriptionByDrug(vo, sb);
        }
    }

    private void getDtpPrescriptionByDrug(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPrescriptionVo().getDrugInformation())) {
            sb.append(" AND pmlm.patientInfoId in (( ");
            sb.append("SELECT pdo.patient_split_id from ps_drug_order pdo inner join ps_drug_prescription_detail pdpd on pdo.id = pdpd.order_id where pdpd.drug_id in (");
            String[] split = vo.getQueryPrescriptionVo().getDrugInformation().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
            sb.append(" ) ) ");
        }
    }

    private void getDtpPrescriptionByDep(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPrescriptionVo().getVisitingDepartment())) {
            sb.append(" AND pmlm.patientInfoId in (             select patient_id from ps_drug_prescription pdp where pdp.status =1 and pdp.patient_id is not null ");
            sb.append(" and pdp.department_id in (");
            String[] split = vo.getQueryPrescriptionVo().getVisitingDepartment().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" " + split[i] + " ,");
                    continue;
                }
                sb.append(" " + split[i] + " )");
            }
            sb.append("group by pdp.patient_id) ");
        }
    }

    private void getDtpPrescriptionByHos(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPrescriptionVo().getVisitingHospital())) {
            sb.append(" AND pmlm.patientInfoId in (             select patient_id from ps_drug_prescription pdp where pdp.status =1 and pdp.patient_id is not null ");
            sb.append(" and pdp.hospital_id in (");
            String[] split = vo.getQueryPrescriptionVo().getVisitingHospital().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" " + split[i] + " ,");
                    continue;
                }
                sb.append(" " + split[i] + " )");
            }
            sb.append("group by pdp.patient_id) ");
        }
    }

    private void getDtpPrescriptionByDoctor(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPrescriptionVo().getVisitingDoctor())) {
            sb.append(" AND pmlm.patientInfoId in (             select patient_id from ps_drug_prescription pdp where pdp.status =1 and pdp.patient_id is not null ");
            sb.append(" and pdp.doctor_id in (");
            String[] split = vo.getQueryPrescriptionVo().getVisitingDoctor().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" " + split[i] + " ,");
                    continue;
                }
                sb.append(" " + split[i] + " )");
            }
            sb.append("group by pdp.patient_id) ");
        }
    }

    private void getHasDtpPrescription(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPrescriptionVo().getHasPrescription())) {
            if (1 == Integer.parseInt(vo.getQueryPrescriptionVo().getHasPrescription())) {
                sb.append(" AND pmlm.patientInfoId in (            select patient_id from ps_drug_prescription pdp where pdp.status =1 and pdp.patient_id is not null            group by pdp.patient_id) ");
            } else if (2 == Integer.parseInt(vo.getQueryPrescriptionVo().getHasPrescription())) {
                sb.append(" AND pmlm.patientInfoId not in (            select patient_id from ps_drug_prescription pdp where pdp.status =1 and pdp.patient_id is not null            group by pdp.patient_id) ");
            }
        }
    }

    private void queryDtpMedicineByCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicineVo())) {
            this.getHasMedicine(vo, sb);
            this.getQueryMedicineRatio(vo, sb);
            this.getQueryMedicineType(vo, sb);
            this.getDtpUpdateTime(vo, sb);
            this.getDtpEnterPerson(vo, sb);
        }
    }

    private void getDtpEnterPerson(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicineVo().getEnterPerson())) {
            if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicineVo().getMedicineType())) {
                if ("1".equals(vo.getQueryMedicineVo().getMedicineType())) {
                    sb.append(" AND pmlm.archivesTumorUpdatePerson LIKE '%" + vo.getQueryMedicineVo().getEnterPerson() + "%' ");
                }
                if ("2".equals(vo.getQueryMedicineVo().getMedicineType())) {
                    sb.append(" AND pmlm.archivesCurrencyUpdatePerson LIKE '%" + vo.getQueryMedicineVo().getEnterPerson() + "%' ");
                }
            }
            if (ObjectUtil.isEmpty((Object)vo.getQueryMedicineVo().getMedicineType())) {
                sb.append(" AND pmlm.archivesAllUpdatePerson LIKE '%" + vo.getQueryMedicineVo().getEnterPerson() + "%' ");
            }
        }
    }

    private void getDtpUpdateTime(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicineVo().getUpdateCreateTime()) && ObjectUtil.isNotEmpty((Object)vo.getQueryMedicineVo().getUpdateEndTime())) {
            if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicineVo().getMedicineType())) {
                String medicineType = vo.getQueryMedicineVo().getMedicineType();
                int length = medicineType.split(",").length;
                if (Integer.valueOf("1").equals(length)) {
                    if ("1".equals(vo.getQueryMedicineVo().getMedicineType())) {
                        sb.append(" AND pmlm.archivesTumorUpdateTime >= '" + vo.getQueryMedicineVo().getUpdateCreateTime() + " 00:00:00'");
                        sb.append(" AND pmlm.archivesTumorUpdateTime <= '" + vo.getQueryMedicineVo().getUpdateEndTime() + " 23:59:59'");
                    }
                    if ("2".equals(vo.getQueryMedicineVo().getMedicineType())) {
                        sb.append(" AND pmlm.archivesCurrencyUpdateTime >= '" + vo.getQueryMedicineVo().getUpdateCreateTime() + " 00:00:00'");
                        sb.append(" AND pmlm.archivesCurrencyUpdateTime <= '" + vo.getQueryMedicineVo().getUpdateEndTime() + " 23:59:59'");
                    }
                } else {
                    sb.append(" AND (pmlm.archivesCurrencyUpdateTime >= '" + vo.getQueryMedicineVo().getUpdateCreateTime() + " 00:00:00'");
                    sb.append(" AND pmlm.archivesCurrencyUpdateTime <= '" + vo.getQueryMedicineVo().getUpdateEndTime() + " 23:59:59')");
                    sb.append(" or( pmlm.archivesTumorUpdateTime >= '" + vo.getQueryMedicineVo().getUpdateCreateTime() + " 00:00:00'");
                    sb.append(" AND pmlm.archivesTumorUpdateTime <= '" + vo.getQueryMedicineVo().getUpdateEndTime() + " 23:59:59')");
                }
            }
            if (ObjectUtil.isEmpty((Object)vo.getQueryMedicineVo().getMedicineType())) {
                sb.append(" AND pmlm.archivesAllUpdateTime >= '" + vo.getQueryMedicineVo().getUpdateCreateTime() + " 00:00:00'");
                sb.append(" AND pmlm.archivesAllUpdateTime <= '" + vo.getQueryMedicineVo().getUpdateEndTime() + " 23:59:59'");
            }
        }
    }

    private void getQueryMedicineType(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryMedicineVo().getMedicineType())) {
            if ("1".equals(vo.getQueryMedicineVo().getMedicineType())) {
                sb.append(" AND pmlm.patientMedicineTumour is not null and pmlm.patientMedicineTumour>0 ");
            } else if ("2".equals(vo.getQueryMedicineVo().getMedicineType())) {
                sb.append(" AND pmlm.patientMedicineCurrency is not null and pmlm.patientMedicineCurrency>0 ");
            } else {
                sb.append(" AND (pmlm.patientMedicineTumour is not null and pmlm.patientMedicineTumour>0 ");
                sb.append(" OR pmlm.patientMedicineCurrency is not null and pmlm.patientMedicineCurrency>0 ) ");
            }
        }
    }

    private void getQueryMedicineRatio(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryMedicineVo().getMedicineIntegrityStart()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryMedicineVo().getMedicineIntegrityEnd())) {
            sb.append(" AND ( (pmlm.patientMedicineCurrency >= " + Integer.parseInt(vo.getQueryMedicineVo().getMedicineIntegrityStart()) + " and pmlm.patientMedicineCurrency <= " + Integer.parseInt(vo.getQueryMedicineVo().getMedicineIntegrityEnd()) + ") or (pmlm.patientMedicineTumour >= " + Integer.parseInt(vo.getQueryMedicineVo().getMedicineIntegrityStart()) + " and pmlm.patientMedicineTumour <= " + Integer.parseInt(vo.getQueryMedicineVo().getMedicineIntegrityEnd()) + " ) )");
        }
    }

    private void getHasMedicine(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryMedicineVo().getHasMedicine())) {
            if ("1".equals(vo.getQueryMedicineVo().getHasMedicine())) {
                sb.append(" AND (pmlm.patientMedicineCurrency >0 or patientMedicineTumour>0 ) ");
            } else {
                sb.append(" AND (pmlm.patientMedicineCurrency =0 and patientMedicineTumour=0 ) ");
            }
        }
    }

    private void dealUserDataAuth(List<UserDataAuthsVO> userDataAuths, StringBuffer sb) {
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and (pmlm.storeIdFilter in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
            sb.append(" or pmlm.pharmaceuticalCompanyId = '").append(userDataAuths.get(0).getPharmaceuticalCompanyId()).append("')");
        }
    }

    private void getPatientInsuranceType(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getInsuranceType())) {
            sb.append(" AND pmlm.patientInfoId in ( select id from ");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
                sb.append("ps_patient_split_info");
            } else {
                sb.append("ps_patient_info");
            }
            sb.append(" where medical_type REGEXP '");
            String[] split = vo.getQueryPatientVo().getInsuranceType().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append("(^|,)" + split[i] + "($|,)|");
                    continue;
                }
                sb.append("(^|,)" + split[i] + "($|,)'");
            }
            sb.append(" ) ");
        }
    }

    private void queryPatientInfoByCondition(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryPatientVo())) {
            this.getQueryBirthday(vo, sb);
            this.getPatientSex(vo, sb);
            this.getPatientAge(vo, sb);
            this.getOpenStore(vo, sb);
            this.getAccountStore(vo, sb);
            this.getIsAssign(vo, sb);
            this.getAccountName(vo, sb);
            this.getPatientCreateTime(vo, sb);
            this.getPatientIcd(vo, sb);
            this.getPatientIndications(vo, sb);
            this.getPatientHasIdCard(vo, sb);
            this.getPatientInsuranceType(vo, sb, type);
        }
    }

    private void getPatientHasIdCard(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getHasIdCard())) {
            if ("1".equals(vo.getQueryPatientVo().getHasIdCard())) {
                sb.append(" AND (pmlm.patientIdCard is not null and  pmlm.patientIdCard !='' ) ");
            } else {
                sb.append(" AND (pmlm.patientIdCard  is null or  pmlm.patientIdCard ='' ) ");
            }
        }
    }

    private void getPatientIndications(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryPatientVo().getIndications())) {
            sb.append(" AND pmlm.patientIndication in ( ");
            List split = vo.getQueryPatientVo().getIndications();
            for (int i = 0; i < split.size(); ++i) {
                if (i != split.size() - 1) {
                    sb.append(" '" + (String)split.get(i) + "' ,");
                    continue;
                }
                sb.append(" '" + (String)split.get(i) + "' )");
            }
        }
    }

    private void queryPatientPortraitInfoByCondition(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryPatientPortraitVo())) {
            this.getQueryLableIds(vo, sb);
        }
    }

    private void getQueryLableIds(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryPatientPortraitVo().getLabelIds())) {
            sb.append(" AND pmlm.patientInfoId in ( select patient_id from ps_member_label_reg");
            sb.append(" where label_id in (");
            String[] split = vo.getQueryPatientPortraitVo().getLabelIds().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
            sb.append(" and status = 1) ");
        }
    }

    private void getIsAssign(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryPatientVo().getIsAssign())) {
            if ("1".equals(vo.getQueryPatientVo().getIsAssign())) {
                sb.append(" AND pmlm.archivesCreatePerson is not null ");
            } else {
                sb.append(" AND pmlm.archivesCreatePerson is null ");
            }
        }
    }

    private void getPatientIcd(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getDiseaseType())) {
            sb.append(" AND pmlm.patientInfoId in ( select ppir.patient_id from ps_patient_icd_reg ppir where ppir.icd_id in (");
            String[] split = vo.getQueryPatientVo().getDiseaseType().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
            sb.append(" and ppir.status = 1) ");
        }
    }

    private void getPatientType(PatientInFoListVo vo, StringBuffer sb) {
        if (Objects.nonNull(vo.getQueryPatientVo()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getPatientType())) {
            if ("1".equals(vo.getQueryPatientVo().getPatientType())) {
                sb.append(" AND pmlm.isDtp = " + Integer.valueOf(vo.getQueryPatientVo().getPatientType()) + " ");
            } else {
                sb.append(" AND pmlm.isCommon = " + Integer.valueOf("1") + " ");
            }
        }
    }

    private void getPatientCreateTime(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getStartTime())) {
            sb.append(" AND pmlm.ppati_createTime >= '" + vo.getQueryPatientVo().getStartTime() + " 00:00:00'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getEndTime())) {
            sb.append(" AND pmlm.ppati_createTime <= '" + vo.getQueryPatientVo().getEndTime() + " 23:59:59'");
        }
    }

    private void getAccountName(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getArchivist())) {
            sb.append(" AND pmlm.archivesCreatePerson LIKE '%" + vo.getQueryPatientVo().getArchivist() + "%' ");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getAccountId())) {
            sb.append("  AND pmlm.patientInfoId in (SELECT id FROM ps_patient_split_info WHERE archives_create_person= '" + vo.getAccountId() + "' and status=1) ");
        }
    }

    private void getAccountStore(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getBelongStore())) {
            sb.append(" AND pmlm.storeIdList REGEXP '");
            String[] split = vo.getQueryPatientVo().getBelongStore().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append("(^|,)" + split[i] + "($|,)|");
                    continue;
                }
                sb.append("(^|,)" + split[i] + "($|,)' ");
            }
        }
    }

    private void getOpenStore(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getRecordStore())) {
            sb.append(" AND pmlm.storeId in ( ");
            String[] split = vo.getQueryPatientVo().getRecordStore().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
    }

    private void getPatientAge(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getAge())) {
            int year = DateUtil.year((Date)new Date());
            int start = year - Integer.parseInt(vo.getQueryPatientVo().getAge());
            int end = year - Integer.parseInt(vo.getQueryPatientVo().getAge()) - 1;
            String formatDate = DateUtil.format((Date)new Date(), (String)"MM-dd");
            sb.append(" AND pmlm.patientBirthday <= '" + String.valueOf(start) + "-" + formatDate + " 00:00:00' ");
            sb.append(" AND pmlm.patientBirthday >= '" + String.valueOf(end) + "-" + formatDate + " 23:59:59' ");
        }
    }

    private void getPatientSex(PatientInFoListVo vo, StringBuffer sb) {
        if (Objects.nonNull(vo.getGender())) {
            sb.append("AND pmlm.patientSex = " + vo.getGender() + " ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getGender())) {
            sb.append(" AND pmlm.patientSex = " + Integer.parseInt(vo.getQueryPatientVo().getGender()) + " ");
        }
    }

    private void getQueryBirthday(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getBirthdayStartTime())) {
            sb.append(" AND pmlm.patientBirthday >= '" + vo.getQueryPatientVo().getBirthdayStartTime() + "' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryPatientVo().getBirthdayEndTime())) {
            sb.append(" AND pmlm.patientBirthday <= '" + vo.getQueryPatientVo().getBirthdayEndTime() + "' ");
        }
    }

    private void quickSearchContent(PatientInFoListVo vo, StringBuffer sb) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchContent())) {
            sb.append("AND (pmlm.patientName like '" + vo.getSearchContent() + "%' or pmlm.patientPhone like '" + vo.getSearchContent() + "%' or pmlm.patientIdCard = '" + vo.getSearchContent() + "' or pmlm.patientMemberNo = '" + vo.getSearchContent() + "')");
        }
    }

    private void exportByPatientIds(PatientInFoListVo vo, StringBuffer sb) {
        if (CollectionUtil.isNotEmpty((Collection)vo.getPatientIds())) {
            sb.append(" and pmlm.patientInfoId in (");
            for (int i = 0; i < vo.getPatientIds().size(); ++i) {
                if (i != vo.getPatientIds().size() - 1) {
                    sb.append("'" + (String)vo.getPatientIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getPatientIds().get(i) + "')");
            }
        }
    }

    private void getCouponPreference(PatientInFoListVo vo, StringBuffer sb) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getCouponPreference())) {
            String[] split = QueryCouponPreferenceEnum.getDesc((Integer)Integer.valueOf(vo.getQueryConsumptionVo().getCouponPreference())).split("-");
            String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
            String startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)-3), (Object[])new Object[0]);
            sb.append(" AND pmlm.patientInfoId in ( ");
            sb.append(" select  temp1.patient_id from  (SELECT pcpr.patient_id, COUNT( 1 ) couponTotalNums, SUM( CASE WHEN pcpr.coupon_reg_status = 3 THEN 1 ELSE 0 END ) couponCheckNums  FROM ps_coupon_patient_reg pcpr  WHERE  pcpr.`status` = 1 ");
            sb.append(" and pcpr.create_time >= '" + startTime + " 00:00:00' ");
            sb.append(" and pcpr.create_time <= '" + now + " 23:59:59' ");
            sb.append(" GROUP BY pcpr.patient_id) temp1");
            if (split.length > 1 && ObjectUtil.isNotEmpty((Object)split[0])) {
                sb.append(" where (temp1.couponCheckNums/temp1.couponTotalNums)*100 >= " + split[0]);
                sb.append(" and (temp1.couponCheckNums/temp1.couponTotalNums)*100<=  " + split[1]);
            }
            if (split.length > 1 && ObjectUtil.isEmpty((Object)split[0])) {
                sb.append(" where (temp1.couponCheckNums/temp1.couponTotalNums)*100<=  " + split[1]);
            }
            if (split.length == 1) {
                sb.append(" where (temp1.couponCheckNums/temp1.couponTotalNums)*100 >= " + split[0]);
            }
            sb.append(")");
        }
    }

    private void getConsumerPreference(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getConsumerPreference())) {
            if ("1".equals(type)) {
                String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
                String startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)-6), (Object[])new Object[0]);
                String[] split = QueryConsumerPreferenceEnum.getDesc((Integer)Integer.valueOf(vo.getQueryConsumptionVo().getConsumerPreference())).split("-");
                sb.append(" AND pmlm.patientInfoId is not null ");
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append(" SELECT temp1.patient_split_id FROM (SELECT pdo.patient_split_id,SUM(pdo.order_amount)  as orderAmount,COUNT(1) as patientCount FROM ps_drug_order pdo  WHERE pdo.`status`=1");
                sb.append(" and IFNULL(pdo.pay_time,pdo.create_time) >= '" + startTime + " 00:00:00' ");
                sb.append(" and IFNULL(pdo.pay_time,pdo.create_time) <= '" + now + " 23:59:59' ");
                sb.append(" GROUP BY pdo.patient_split_id ) temp1  WHERE temp1.patient_split_id IS NOT NULL ");
                if (split.length > 1 && ObjectUtil.isNotEmpty((Object)split[0])) {
                    sb.append(" AND  temp1.orderAmount >= " + split[0]);
                    sb.append(" and temp1.orderAmount<=  " + split[1]);
                }
                if (split.length > 1 && ObjectUtil.isEmpty((Object)split[0])) {
                    sb.append(" and temp1.orderAmount<=  " + split[1]);
                }
                if (split.length == 1) {
                    sb.append(" AND  temp1.orderAmount >= " + split[0]);
                }
                sb.append(")");
            } else {
                String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
                String startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)-6), (Object[])new Object[0]);
                String[] split = QueryConsumerPreferenceEnum.getDesc((Integer)Integer.valueOf(vo.getQueryConsumptionVo().getConsumerPreference())).split("-");
                sb.append(" AND pmlm.patientInfoId is not null ");
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append(" SELECT temp1.patient_id FROM (SELECT pdo.patient_id,SUM(pdo.order_amount)  as orderAmount,COUNT(1) as patientCount FROM ps_drug_order pdo  WHERE pdo.`status`=1");
                sb.append(" and IFNULL(pdo.pay_time,pdo.create_time) >= '" + startTime + " 00:00:00' ");
                sb.append(" and IFNULL(pdo.pay_time,pdo.create_time) <= '" + now + " 23:59:59' ");
                sb.append(" GROUP BY pdo.patient_id ) temp1  WHERE temp1.patient_id IS NOT NULL ");
                if (split.length > 1 && ObjectUtil.isNotEmpty((Object)split[0])) {
                    sb.append(" AND  temp1.orderAmount >= " + split[0]);
                    sb.append(" and temp1.orderAmount<=  " + split[1]);
                }
                if (split.length > 1 && ObjectUtil.isEmpty((Object)split[0])) {
                    sb.append(" and temp1.orderAmount<=  " + split[1]);
                }
                if (split.length == 1) {
                    sb.append(" AND  temp1.orderAmount >= " + split[0]);
                }
                sb.append(")");
            }
        }
    }

    private void getConsumerUnitPrice(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getConsumerUnitPrice())) {
            if ("1".equals(type)) {
                sb.append(" AND pmlm.patientInfoId in ( ");
                String consumerAmount = vo.getQueryConsumptionVo().getConsumerUnitPrice();
                String[] split = consumerAmount.split("-");
                sb.append("SELECT temp1.patient_split_id FROM (SELECT pdo.patient_split_id,SUM(pdo.order_amount) as orderAmount,COUNT(1) as patientCount FROM ps_drug_order pdo WHERE pdo.`status`=1 GROUP BY pdo.patient_split_id)temp1 WHERE temp1.patient_split_id is not NULL and ");
                if (split.length > 1) {
                    if (ObjectUtil.isEmpty((Object)split[0])) {
                        sb.append("  temp1.orderAmount/temp1.patientCount<=  " + split[1]);
                    } else {
                        sb.append("  temp1.orderAmount/temp1.patientCount >= " + split[0]);
                        sb.append(" and temp1.orderAmount/temp1.patientCount<=  " + split[1]);
                    }
                } else {
                    sb.append("  temp1.orderAmount/temp1.patientCount >= " + split[0]);
                }
                sb.append(")");
            } else {
                sb.append(" AND pmlm.patientInfoId in ( ");
                String consumerAmount = vo.getQueryConsumptionVo().getConsumerUnitPrice();
                String[] split = consumerAmount.split("-");
                sb.append("SELECT temp1.patient_id FROM (SELECT pdo.patient_id,SUM(pdo.order_amount) as orderAmount,COUNT(1) as patientCount FROM ps_drug_order pdo WHERE pdo.`status`=1 GROUP BY pdo.patient_id)temp1 WHERE temp1.patient_id is not NULL and ");
                if (split.length > 1) {
                    if (ObjectUtil.isEmpty((Object)split[0])) {
                        sb.append("  temp1.orderAmount/temp1.patientCount<=  " + split[1]);
                    } else {
                        sb.append("  temp1.orderAmount/temp1.patientCount >= " + split[0]);
                        sb.append(" and temp1.orderAmount/temp1.patientCount<=  " + split[1]);
                    }
                } else {
                    sb.append("  temp1.orderAmount/temp1.patientCount >= " + split[0]);
                }
                sb.append(")");
            }
        }
    }

    private void getConsumerAmount(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getConsumerAmount())) {
            if ("1".equals(type)) {
                sb.append(" AND pmlm.patientInfoId in ( ");
                String consumerAmount = vo.getQueryConsumptionVo().getConsumerAmount();
                String[] split = consumerAmount.split("-");
                sb.append(" SELECT temp1.patient_split_id FROM (SELECT pdo.patient_split_id,SUM(pdo.order_amount)  as orderAmount,COUNT(1) FROM ps_drug_order pdo WHERE pdo.`status`=1 GROUP BY pdo.patient_split_id)temp1 WHERE temp1.patient_split_id is not NULL and ");
                if (split.length > 1) {
                    if (ObjectUtil.isEmpty((Object)split[0])) {
                        sb.append(" and temp1.orderAmount<=  " + split[1]);
                    } else {
                        sb.append("  temp1.orderAmount >= " + split[0]);
                        sb.append(" and temp1.orderAmount<=  " + split[1]);
                    }
                } else {
                    sb.append("  temp1.orderAmount >= " + split[0]);
                }
                sb.append(")");
            } else {
                sb.append(" AND pmlm.patientInfoId in ( ");
                String consumerAmount = vo.getQueryConsumptionVo().getConsumerAmount();
                String[] split = consumerAmount.split("-");
                sb.append(" SELECT temp1.patient_id FROM (SELECT pdo.patient_id,SUM(pdo.order_amount)  as orderAmount,COUNT(1) FROM ps_drug_order pdo WHERE pdo.`status`=1 GROUP BY pdo.patient_id)temp1 WHERE temp1.patient_id is not NULL and ");
                if (split.length > 1) {
                    if (ObjectUtil.isEmpty((Object)split[0])) {
                        sb.append(" and temp1.orderAmount<=  " + split[1]);
                    } else {
                        sb.append("  temp1.orderAmount >= " + split[0]);
                        sb.append(" and temp1.orderAmount<=  " + split[1]);
                    }
                } else {
                    sb.append("  temp1.orderAmount >= " + split[0]);
                }
                sb.append(")");
            }
        }
    }

    private void getLastConsumerStore(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryConsumptionVo().getLastConsumerStores())) {
            if ("1".equals(type)) {
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append("SELECT  pdo.patient_split_id FROM  ps_drug_order pdo  INNER JOIN   ( SELECT pdo1.patient_split_id, MAX( IFNULL(pdo1.pay_time,pdo1.create_time)  ) AS lastConsumerTime FROM ps_drug_order pdo1 WHERE pdo1.`status` = 1 GROUP BY pdo1.patient_split_id )    temp ON pdo.patient_split_id = temp.patient_split_id   AND IFNULL(pdo.pay_time,pdo.create_time)  = temp.lastConsumerTime  WHERE pdo.`status`=1 ");
                sb.append("and  pdo.store_id in (");
                String[] split = vo.getQueryConsumptionVo().getLastConsumerStores().split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (i != split.length - 1) {
                        sb.append(" '" + split[i] + "' ,");
                        continue;
                    }
                    sb.append(" '" + split[i] + "' )");
                }
                sb.append(" ) ");
            } else {
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append("SELECT  pdo.patient_id FROM  ps_drug_order pdo  INNER JOIN   ( SELECT pdo1.patient_id, MAX( IFNULL(pdo1.pay_time,pdo1.create_time)  ) AS lastConsumerTime FROM ps_drug_order pdo1 WHERE pdo1.`status` = 1 GROUP BY pdo1.patient_id )    temp ON pdo.patient_id = temp.patient_id   AND IFNULL(pdo.pay_time,pdo.create_time)  = temp.lastConsumerTime  WHERE pdo.`status`=1 ");
                sb.append("and  pdo.store_id in (");
                String[] split = vo.getQueryConsumptionVo().getLastConsumerStores().split(",");
                for (int i = 0; i < split.length; ++i) {
                    if (i != split.length - 1) {
                        sb.append(" '" + split[i] + "' ,");
                        continue;
                    }
                    sb.append(" '" + split[i] + "' )");
                }
                sb.append(" ) ");
            }
        }
    }

    private void getLastConsumptionTime(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (StringUtils.isNotEmpty((CharSequence)vo.getQueryConsumptionVo().getLastConsumptionStartTime()) && StringUtils.isNotEmpty((CharSequence)vo.getQueryConsumptionVo().getLastConsumptionEndTime())) {
            if ("1".equals(type)) {
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append("select pdo.patient_split_id from ps_drug_order pdo where ");
                sb.append(" pdo.patient_split_id is not null ");
                sb.append(" and pdo.status=1");
                sb.append(" GROUP BY pdo.patient_split_id ");
                sb.append(" HAVING max(pdo.create_time) >= '" + vo.getQueryConsumptionVo().getLastConsumptionStartTime() + " 00:00:00' ");
                sb.append(" AND max(pdo.create_time) <= '" + vo.getQueryConsumptionVo().getLastConsumptionEndTime() + " 23:59:59' ");
                sb.append(" ) ");
            } else {
                sb.append(" AND pmlm.patientInfoId in ( ");
                sb.append("select pdo.patient_id from ps_drug_order pdo where ");
                sb.append(" pdo.patient_id is not null ");
                sb.append(" and pdo.status=1");
                sb.append(" GROUP BY pdo.patient_id ");
                sb.append(" HAVING max(pdo.create_time) >= '" + vo.getQueryConsumptionVo().getLastConsumptionStartTime() + " 00:00:00' ");
                sb.append(" AND max(pdo.create_time) <= '" + vo.getQueryConsumptionVo().getLastConsumptionEndTime() + " 23:59:59' ");
                sb.append(" ) ");
            }
        }
    }

    private void getConsumerFrequency(PatientInFoListVo vo, StringBuffer sb, String type) {
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryConsumptionVo().getConsumerFrequency())) {
            String col = "1".equals(type) ? "patient_split_id" : "patient_id";
            sb.append(" AND pmlm.patientInfoId in ( ");
            sb.append("SELECT " + col + " FROM (select " + col + ",COUNT(" + col + ") as consumerCount from ps_drug_order pdoo WHERE pdoo.`status`=1 group by pdoo." + col + ") t WHERE t.consumerCount");
            if (5 != vo.getQueryConsumptionVo().getConsumerFrequency()) {
                sb.append("=" + vo.getQueryConsumptionVo().getConsumerFrequency());
            } else {
                sb.append(">" + vo.getQueryConsumptionVo().getConsumerFrequency());
            }
            sb.append(")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<PortraitRmfDto>> getRmfAvg(Connection connection, List<UserDataAuthsVO> userDataAuths, Object o) {
        ArrayList<PortraitRmfDto> list = new ArrayList<PortraitRmfDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getRmfData(userDataAuths, null));
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                PortraitRmfDto dto = new PortraitRmfDto();
                String patientId = rs.getString("patientId");
                dto.setPatientId(patientId);
                String frequencyCount = rs.getString("frequencyCount");
                dto.setFrequencyCount(frequencyCount);
                String orderAmount = rs.getString("orderAmount");
                dto.setOrderAmount(orderAmount);
                String orderAmountPer = rs.getString("orderAmountPer");
                dto.setOrderAmountPer(orderAmountPer);
                String lastTime = rs.getString("lastTime");
                dto.setLastTime(lastTime);
                String storeId = rs.getString("storeId");
                dto.setStoreId(storeId);
                String lastTimePer = rs.getString("lastTimePer");
                dto.setLastTimePer(lastTimePer);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getRmfData(List<UserDataAuthsVO> userDataAuths, Object o) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT pdo.patient_id as patientId, count( pdo.patient_id ) as frequencyCount, SUM( pdo.order_amount ) as orderAmount, SUM( pdo.order_amount ) as orderAmountPer, any_value(ppsr.store_id) as storeId, DATEDIFF(DATE(NOW()),max(IFNULL(pdo.pay_time,pdo.create_time))) as lastTime, DATEDIFF( DATE( NOW()), max( IFNULL( pdo.pay_time, pdo.create_time ))) as lastTimePer FROM ps_drug_order pdo  inner join ps_patient_info ppi on pdo.patient_id=ppi.id  INNER JOIN ps_patient_store_reg ppsr on ppsr.patient_id=ppi.id and ppsr.is_create_store=1 WHERE pdo.`status` = 1 ");
        String now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
        String startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)-24), (Object[])new Object[0]);
        sb.append(" and ((pdo.create_time>= '" + startTime + " 00:00:00'and pdo.create_time<= '" + now + " 23:59:59')");
        sb.append("  or (pdo.pay_time>= '" + startTime + " 00:00:00'and pdo.pay_time<= '" + now + " 23:59:59'))");
        sb.append(" AND pdo.patient_id IS NOT NULL  GROUP BY pdo.patient_id");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<MemberPatientDto>> queryPatientIdById(Connection connection) {
        ArrayList<MemberPatientDto> list = new ArrayList<MemberPatientDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPortraitPatientIdData());
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                MemberPatientDto dto = new MemberPatientDto();
                String storeId = rs.getString("storeId");
                String patientId = rs.getString("patientId");
                String createTime = rs.getString("createTime");
                dto.setPatientId(patientId);
                dto.setStoreId(storeId);
                dto.setCreatTime(createTime);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getPortraitPatientIdData() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ppi.id AS patientId, pps.id AS storeId, DATE_FORMAT(ppi.create_time,'%Y-%m') as createTime FROM ps_patient_info ppi INNER JOIN ps_patient_store_reg ppsr ON ppi.id = ppsr.patient_id  AND ppsr.is_create_store = 1 INNER JOIN ps_patient_store pps ON pps.id = ppsr.store_id  WHERE ppi.`status` = 1  AND ppsr.`status` = 1  AND pps.`status` =1");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<String>> getConsumerPatientIdByCondition(Connection connection, MemberQueryConditionQo vo) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getConsumerPatientIdByConditionData(vo));
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String id = rs.getString("patientInfoId");
                list.add(id);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientIdsByConditions: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientIdsByConditions: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientIdsByConditions: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getConsumerPatientIdByConditionData(MemberQueryConditionQo vo) {
        String startTime;
        String now;
        StringBuffer sb = new StringBuffer("SELECT patientInfoId from patient_manage_list_mv_v2 pmlm ");
        sb.append(" where 1=1 ");
        sb.append(" AND pmlm.patientInfoId  in ( ");
        sb.append("SELECT id FROM ps_patient_info WHERE `status`=1 ");
        sb.append(" ) ");
        if (ObjectUtil.isNotEmpty((Object)vo.getConsumerRangTime()) && ConsumerTimeType.NO_CONSUMER_TIME_TYPE.getCode().equals(vo.getConsumerRangTimeType())) {
            now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
            startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)(-vo.getConsumerRangTime().intValue())), (Object[])new Object[0]);
            sb.append(" AND pmlm.patientInfoId not in ( ");
            sb.append("select pdo.patient_id from ps_drug_order pdo where  ");
            sb.append(" pdo.create_time >= '" + startTime + " 00:00:00' ");
            sb.append(" AND pdo.create_time <= '" + now + " 23:59:59' ");
            sb.append("and pdo.patient_id is not null");
            sb.append(" and pdo.status=1");
            sb.append(" ) ");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getOtherCondition()) && "1".equals(vo.getOtherCondition())) {
            sb.append(" AND pmlm.patientInfoId  in ( ");
            sb.append("SELECT id FROM ps_patient_info WHERE `status`=1 and patient_name ='' or patient_phone='' or patient_phone like '%*%'");
            sb.append(" ) ");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getConsumerRangTime()) && ConsumerTimeType.CONSUMER_TIME_TYPE.getCode().equals(vo.getConsumerRangTimeType())) {
            now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
            startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)(-vo.getConsumerRangTime().intValue())), (Object[])new Object[0]);
            if (ObjectUtil.isNotEmpty((Object)vo.getOtherCondition()) && "2".equals(vo.getOtherCondition())) {
                sb.append(" and (( ");
            } else {
                sb.append(" and ");
            }
            sb.append("  pmlm.patientInfoId  in ( ");
            sb.append("select pdo.patient_id from ps_drug_order pdo where  ");
            sb.append(" pdo.create_time >= '" + startTime + " 00:00:00' ");
            sb.append(" AND pdo.create_time <= '" + now + " 23:59:59' ");
            sb.append("and pdo.patient_id is not null");
            sb.append(" and pdo.status=1");
            sb.append(" ) ");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getConsumerAmount())) {
            sb.append(" AND pmlm.patientInfoId  in ( ");
            sb.append("SELECT temp.patient_id  FROM  ( SELECT  SUM( pdo.order_amount ) AS orderAmount, pdo.patient_id  FROM  ps_drug_order pdo  WHERE  pdo.`status` = 1  AND pdo.patient_id IS NOT NULL ");
            if (ConsumerTimeType.NO_CONSUMER_TIME_TYPE.getCode().equals(vo.getConsumerAmountType())) {
                now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
                startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)(-vo.getConsumerRangTime().intValue())), (Object[])new Object[0]);
                sb.append(" and pdo.create_time >= '" + startTime + " 00:00:00' ");
                sb.append(" AND pdo.create_time <= '" + now + " 23:59:59' ");
            }
            sb.append(" GROUP BY pdo.patient_id  ) temp  WHERE temp.orderAmount");
            if (ConsumerTimeType.NO_CONSUMER_TIME_TYPE.getCode().equals(vo.getConsumerAmountType())) {
                sb.append(">" + vo.getConsumerAmount());
            } else {
                String startAmount = vo.getConsumerAmount().split("-")[0];
                String endAmount = vo.getConsumerAmount().split("-")[1];
                if (endAmount.compareTo(startAmount) < 0) {
                    sb.append(">=" + startAmount);
                } else {
                    sb.append(">=" + startAmount);
                    sb.append(" and temp.orderAmount<=" + endAmount);
                }
            }
            sb.append(" ) ");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getConsumerFrequency())) {
            sb.append(" AND pmlm.patientInfoId in ( ");
            sb.append("SELECT patient_id FROM (select patient_id,COUNT(patient_id) as consumerCount from ps_drug_order pdo WHERE pdo.`status`=1 ");
            if (ConsumerTimeType.NO_CONSUMER_TIME_TYPE.getCode().equals(vo.getConsumerAmountType())) {
                now = DateUtils.formatDate((Date)new Date(), (Object[])new Object[0]);
                startTime = DateUtils.formatDate((Date)DateUtils.addMonths((Date)new Date(), (int)(-vo.getConsumerRangTime().intValue())), (Object[])new Object[0]);
                sb.append(" and pdo.create_time >= '" + startTime + " 00:00:00' ");
                sb.append(" AND pdo.create_time <= '" + now + " 23:59:59' ");
            }
            sb.append("group by pdo.patient_id) t WHERE t.consumerCount");
            sb.append(">" + vo.getConsumerFrequency());
            sb.append(")");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getOtherCondition()) && "2".equals(vo.getOtherCondition())) {
            sb.append(" ) or pmlm.patientInfoId  in ( ");
            sb.append(" SELECT id FROM ps_patient_info WHERE STATUS = 1 AND ( DATEDIFF( DATE( NOW()), create_time )> 30  and DATEDIFF( DATE( NOW()), create_time )< 90 ) AND id IS NOT NULL AND id NOT IN ( SELECT patient_id FROM ps_drug_order WHERE STATUS = 1 and patient_id is not NULL )");
            sb.append(" )) ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> queryPortraitListByTypeCount(Connection connection, List<UserDataAuthsVO> userDataAuths, MemberQueryListQo vo) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT COUNT(1) as cou from ( ");
        sb.append(" select any_value(pps.id) FROM ps_patient_store pps LEFT JOIN ps_portrait_statics_info ppsi ON pps.id = ppsi.store_id AND ppsi.scene_type = " + vo.getSceneType());
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryTime())) {
            sb.append(" and DATE_FORMAT(ppsi.create_time, '%Y-%m')= '" + vo.getQueryTime() + "'");
        }
        sb.append(" LEFT JOIN ps_patient_org_store_reg pposr ON pposr.store_id = ppsi.store_id LEFT JOIN ps_patient_org ppo ON ppo.id = ifnull(split_part(pposr.org_id, ',', array_length(split(pposr.org_id,','))),pposr.org_id)  WHERE pps.`status` = 1");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pps.id in (");
            for (int i2 = 0; i2 < userDataAuths.size(); ++i2) {
                if (i2 != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i2).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i2).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryStoreId())) {
            sb.append(" and pps.id in (");
            String[] split = vo.getQueryStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreId())) {
            sb.append(" and pps.id in (");
            String[] split = vo.getStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        sb.append(" GROUP BY pps.id");
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<Object>> queryPortraitListByType(Connection connection, List<UserDataAuthsVO> userDataAuths, MemberQueryListQo vo) {
        ArrayList<MemberDegListVo> list = new ArrayList<MemberDegListVo>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.queryPortraitListByTypeData(userDataAuths, vo));
        if (ObjectUtil.isNotEmpty((Object)vo.getPageIndex())) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String createTime;
                String storeId;
                String storeName;
                String storeCode;
                String orgName;
                Integer totalMemberCount;
                MemberDegListVo dto;
                if (PortraitSceneTypeEnum.PORTRAIT_DEG.getValue().equals(vo.getSceneType())) {
                    dto = new MemberDegListVo();
                    totalMemberCount = rs.getInt("totalMemberCount");
                    orgName = rs.getString("orgName");
                    storeCode = rs.getString("storeCode");
                    storeName = rs.getString("storeName");
                    storeId = rs.getString("storeId");
                    dto.setStoreId(storeId);
                    if (ObjectUtil.isNotEmpty((Object)vo.getQueryLineFlag())) {
                        createTime = rs.getString("createTime");
                        dto.setCreateTime(createTime);
                    }
                    dto.setStoreName(storeName);
                    dto.setTotalMemberCount(totalMemberCount);
                    Integer commonMemberCount = rs.getInt("commonMemberCount");
                    Integer copperMemberCount = rs.getInt("copperMemberCount");
                    Integer sliverMemberCount = rs.getInt("sliverMemberCount");
                    Integer goldMemberCount = rs.getInt("goldMemberCount");
                    Integer diamondMemberCount = rs.getInt("diamondMemberCount");
                    dto.setCommonMemberCount(commonMemberCount);
                    dto.setCopperMemberCount(copperMemberCount);
                    dto.setSliverMemberCount(sliverMemberCount);
                    dto.setGoldMemberCount(goldMemberCount);
                    dto.setDiamondMemberCount(diamondMemberCount);
                    list.add(dto);
                }
                if (PortraitSceneTypeEnum.PORTRAIT_ACT.getValue().equals(vo.getSceneType())) {
                    dto = new MemberActListVo();
                    totalMemberCount = rs.getInt("totalMemberCount");
                    orgName = rs.getString("orgName");
                    storeCode = rs.getString("storeCode");
                    storeName = rs.getString("storeName");
                    storeId = rs.getString("storeId");
                    dto.setStoreId(storeId);
                    if (ObjectUtil.isNotEmpty((Object)vo.getQueryLineFlag())) {
                        createTime = rs.getString("createTime");
                        dto.setCreateTime(createTime);
                    }
                    dto.setStoreName(storeName);
                    dto.setTotalMemberCount(totalMemberCount);
                    dto.setStoreCode(storeCode);
                    Integer newMemberCount = rs.getInt("newMemberCount");
                    Integer coreMemberCount = rs.getInt("coreMemberCount");
                    Integer commonMemberCount = rs.getInt("commonMemberCount");
                    Integer invalidMemberCount = rs.getInt("invalidMemberCount");
                    Integer severeMemberCount = rs.getInt("severeMemberCount");
                    Integer deepMemberCount = rs.getInt("deepMemberCount");
                    Integer moderateMemberCount = rs.getInt("moderateMemberCount");
                    Integer lightMemberCount = rs.getInt("lightMemberCount");
                    Integer noLevelMemberCount = rs.getInt("noLevelMemberCount");
                    dto.setNewMemberCount(newMemberCount);
                    dto.setCoreMemberCount(coreMemberCount);
                    dto.setCommonMemberCount(commonMemberCount);
                    dto.setInvalidMemberCount(invalidMemberCount);
                    dto.setSevereMemberCount(severeMemberCount);
                    dto.setDeepMemberCount(deepMemberCount);
                    dto.setModerateMemberCount(moderateMemberCount);
                    dto.setLightMemberCount(lightMemberCount);
                    dto.setNoLevelMemberCount(noLevelMemberCount);
                    list.add(dto);
                }
                if (!PortraitSceneTypeEnum.PORTRAIT_RMF.getValue().equals(vo.getSceneType())) continue;
                dto = new MemberRmfListVo();
                if (ObjectUtil.isNotEmpty((Object)vo.getQueryLineFlag())) {
                    String createTime2 = rs.getString("createTime");
                    dto.setCreateTime(createTime2);
                }
                String storeId2 = rs.getString("storeId");
                dto.setStoreId(storeId2);
                Integer totalMemberCount2 = rs.getInt("totalMemberCount");
                String orgName2 = rs.getString("orgName");
                String storeCode2 = rs.getString("storeCode");
                String storeName2 = rs.getString("storeName");
                dto.setStoreName(storeName2);
                dto.setTotalMemberCount(totalMemberCount2);
                dto.setStoreCode(storeCode2);
                dto.setOrgName(orgName2);
                Integer importMainCount = rs.getInt("importMainCount");
                Integer importValueCount = rs.getInt("importValueCount");
                Integer importDevelopCount = rs.getInt("importDevelopCount");
                Integer importRetentionCount = rs.getInt("importRetentionCount");
                Integer commonImportCount = rs.getInt("commonImportCount");
                Integer commonMemberCount = rs.getInt("commonMemberCount");
                Integer commonRetentionCount = rs.getInt("commonRetentionCount");
                Integer notValueCount = rs.getInt("notValueCount");
                dto.setImportMainCount(importMainCount);
                dto.setImportValueCount(importValueCount);
                dto.setImportDevelopCount(importDevelopCount);
                dto.setImportRetentionCount(importRetentionCount);
                dto.setCommonImportCount(commonImportCount);
                dto.setCommonMemberCount(commonMemberCount);
                dto.setCommonRetentionCount(commonRetentionCount);
                dto.setNotValueCount(notValueCount);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String queryPortraitListByTypeData(List<UserDataAuthsVO> userDataAuths, MemberQueryListQo vo) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryLineFlag())) {
            sb.append(" DATE_FORMAT(ppsi.create_time, '%Y-%m') as createTime,");
        }
        sb.append(" any_value(pps.id) AS storeId, any_value(pps.store_name) AS storeName, any_value(pps.store_code) AS storeCode, any_value(ppo.org_name) AS orgName, COUNT( ppsi.tag_name ) AS totalMemberCount,");
        if (PortraitSceneTypeEnum.PORTRAIT_DEG.getValue().equals(vo.getSceneType())) {
            sb.append(" SUM( IF ( ppsi.tag_name = '\u666e\u5361\u4f1a\u5458', 1, 0 )) AS commonMemberCount, SUM( IF ( ppsi.tag_name = '\u94dc\u724c\u4f1a\u5458', 1, 0 )) AS copperMemberCount, SUM( IF ( ppsi.tag_name = '\u94f6\u724c\u4f1a\u5458', 1, 0 )) AS sliverMemberCount, SUM(IF( ppsi.tag_name = '\u91d1\u724c\u4f1a\u5458', 1, 0 )) AS goldMemberCount, SUM( if( ppsi.tag_name = '\u94bb\u77f3\u4f1a\u5458', 1, 0 )) AS diamondMemberCount");
        }
        if (PortraitSceneTypeEnum.PORTRAIT_ACT.getValue().equals(vo.getSceneType())) {
            sb.append(" SUM(IF( ppsi.tag_name = '\u65b0\u589e\u4f1a\u5458', 1, 0 )) AS newMemberCount, SUM(IF( ppsi.tag_name = '\u6838\u5fc3\u4f1a\u5458', 1, 0 )) AS coreMemberCount, SUM(IF( ppsi.tag_name = '\u666e\u901a\u4f1a\u5458', 1, 0 )) AS commonMemberCount, SUM(IF( ppsi.tag_name = '\u65e0\u6548\u4f1a\u5458', 1, 0 )) AS invalidMemberCount, SUM(IF( ppsi.tag_name = '\u91cd\u5ea6\u7761\u7720', 1, 0 )) AS severeMemberCount, SUM(IF( ppsi.tag_name = '\u6df1\u5ea6\u7761\u7720', 1, 0 )) AS deepMemberCount, SUM(IF( ppsi.tag_name = '\u4e2d\u5ea6\u7761\u7720', 1, 0 )) AS moderateMemberCount, SUM(IF( ppsi.tag_name = '\u8f7b\u5ea6\u7761\u7720', 1, 0 )) AS lightMemberCount, SUM(IF( ppsi.tag_name = '\u672a\u5206\u7ea7', 1, 0 )) AS noLevelMemberCount");
        }
        if (PortraitSceneTypeEnum.PORTRAIT_RMF.getValue().equals(vo.getSceneType())) {
            sb.append(" SUM(IF( ppsi.tag_name = '\u91cd\u8981\u4fdd\u6301', 1, 0 )) AS importMainCount, SUM(IF( ppsi.tag_name = '\u91cd\u8981\u4ef7\u503c', 1, 0 )) AS importValueCount, SUM(IF( ppsi.tag_name = '\u91cd\u8981\u53d1\u5c55', 1, 0 )) AS importDevelopCount, SUM(IF( ppsi.tag_name = '\u91cd\u8981\u633d\u7559', 1, 0 )) AS importRetentionCount, SUM(IF( ppsi.tag_name = '\u4e00\u822c\u91cd\u8981', 1, 0 )) AS commonImportCount, SUM(IF( ppsi.tag_name = '\u4e00\u822c\u5ba2\u6237', 1, 0 )) AS commonMemberCount, SUM(IF( ppsi.tag_name = '\u4e00\u822c\u633d\u7559', 1, 0 )) AS commonRetentionCount, SUM(IF( ppsi.tag_name = '\u65e0\u4ef7\u503c', 1, 0 )) AS notValueCount");
        }
        sb.append(" FROM ps_patient_store pps LEFT JOIN ps_portrait_statics_info ppsi ON pps.id = ppsi.store_id AND ppsi.scene_type = " + vo.getSceneType());
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryTime()) && ObjectUtil.isEmpty((Object)vo.getQueryLineFlag())) {
            sb.append(" and DATE_FORMAT(ppsi.create_time, '%Y-%m')= '" + vo.getQueryTime() + "'");
        }
        sb.append(" LEFT JOIN ps_patient_org_store_reg pposr ON pposr.store_id = ppsi.store_id LEFT JOIN ps_patient_org ppo ON ppo.id = ifnull(split_part(pposr.org_id, ',', array_length(split(pposr.org_id,','))),pposr.org_id)  WHERE pps.`status` = 1");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pps.id in (");
            for (int i2 = 0; i2 < userDataAuths.size(); ++i2) {
                if (i2 != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i2).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i2).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryStoreId())) {
            sb.append(" and pps.id in (");
            String[] split = vo.getQueryStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreId())) {
            sb.append(" and pps.id in (");
            String[] split = vo.getStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isEmpty((Object)vo.getQueryTotalFlag())) {
            sb.append(" GROUP BY pps.id");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getQueryLineFlag())) {
            sb.append(" GROUP BY DATE_FORMAT(ppsi.create_time, '%Y-%m')");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Object> queryPortraitDetail(Connection connection, List<UserDataAuthsVO> userDataAuths, MemberQueryDetailQo vo) {
        MemberQueryDetailVo dto = new MemberQueryDetailVo();
        StringBuffer sb = new StringBuffer();
        sb.append(this.queryPortraitDetailData(userDataAuths, vo));
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String storeName = rs.getString("storeName");
                dto.setStoreName(storeName);
                int curCoreMemberCount = rs.getInt("curCoreMemberCount");
                dto.setCurCoreMemberCount(Integer.valueOf(curCoreMemberCount));
                int coreMemberRatio = rs.getInt("coreMemberRatio");
                dto.setCoreMemberRatio(ObjectUtil.isEmpty((Object)coreMemberRatio) ? "--" : String.valueOf(coreMemberRatio));
                int curCommonMemberCount = rs.getInt("curCommonMemberCount");
                dto.setCurCommonMemberCount(Integer.valueOf(curCommonMemberCount));
                int commonMemberRatio = rs.getInt("commonMemberRatio");
                dto.setCommonMemberRatio(ObjectUtil.isEmpty((Object)commonMemberRatio) ? "--" : String.valueOf(commonMemberRatio));
                int curLightMemberCount = rs.getInt("curLightMemberCount");
                dto.setCurLightMemberCount(Integer.valueOf(curLightMemberCount));
                int lightMemberRatio = rs.getInt("lightMemberRatio");
                dto.setLightMemberRatio(ObjectUtil.isEmpty((Object)lightMemberRatio) ? "--" : String.valueOf(lightMemberRatio));
                int curModerateMemberCount = rs.getInt("curModerateMemberCount");
                dto.setCurModerateMemberCount(Integer.valueOf(curModerateMemberCount));
                int moderateMemberRatio = rs.getInt("moderateMemberRatio");
                dto.setModerateMemberRatio(ObjectUtil.isEmpty((Object)moderateMemberRatio) ? "--" : String.valueOf(moderateMemberRatio));
                int curDeepMemberCount = rs.getInt("curDeepMemberCount");
                dto.setCurDeepMemberCount(Integer.valueOf(curDeepMemberCount));
                int deepMemberRatio = rs.getInt("deepMemberRatio");
                dto.setDeepMemberRatio(ObjectUtil.isEmpty((Object)deepMemberRatio) ? "--" : String.valueOf(deepMemberRatio));
                int curSevereMemberCount = rs.getInt("curSevereMemberCount");
                dto.setCurSevereMemberCount(Integer.valueOf(curSevereMemberCount));
                int severeMemberRatio = rs.getInt("severeMemberRatio");
                dto.setSevereMemberRatio(ObjectUtil.isEmpty((Object)severeMemberRatio) ? "--" : String.valueOf(severeMemberRatio));
                int curNewMemberCount = rs.getInt("curNewMemberCount");
                dto.setCurNewMemberCount(Integer.valueOf(curNewMemberCount));
                int newMemberRatio = rs.getInt("newMemberRatio");
                dto.setNewMemberRatio(ObjectUtil.isEmpty((Object)newMemberRatio) ? "--" : String.valueOf(newMemberRatio));
                int curUnratedMemberCount = rs.getInt("curUnratedMemberCount");
                dto.setCurUnratedMemberCount(Integer.valueOf(curUnratedMemberCount));
                int unratedMemberRatio = rs.getInt("unratedMemberRatio");
                dto.setUnratedMemberRatio(ObjectUtil.isEmpty((Object)unratedMemberRatio) ? "--" : String.valueOf(unratedMemberRatio));
                int curInvalidMemberCount = rs.getInt("curInvalidMemberCount");
                dto.setCurInvalidMemberCount(Integer.valueOf(curInvalidMemberCount));
                int invalidMemberRatio = rs.getInt("invalidMemberRatio");
                dto.setInvalidMemberRatio(ObjectUtil.isEmpty((Object)invalidMemberRatio) ? "--" : String.valueOf(invalidMemberRatio));
                int lastCoreMemberCount = rs.getInt("lastCoreMemberCount");
                dto.setLastCoreMemberCount(Integer.valueOf(lastCoreMemberCount));
                int lastCommonMemberCount = rs.getInt("lastCommonMemberCount");
                dto.setLastCommonMemberCount(Integer.valueOf(lastCommonMemberCount));
                int lastLightMemberCount = rs.getInt("lastLightMemberCount");
                dto.setLastLightMemberCount(Integer.valueOf(lastLightMemberCount));
                int lastModerateMemberCount = rs.getInt("lastModerateMemberCount");
                dto.setLastModerateMemberCount(Integer.valueOf(lastModerateMemberCount));
                int lastDeepMemberCount = rs.getInt("lastDeepMemberCount");
                dto.setLastDeepMemberCount(Integer.valueOf(lastDeepMemberCount));
                int lastSevereMemberCount = rs.getInt("lastSevereMemberCount");
                dto.setLastSevereMemberCount(Integer.valueOf(lastSevereMemberCount));
                int lastNewMemberCount = rs.getInt("lastNewMemberCount");
                dto.setLastNewMemberCount(Integer.valueOf(lastNewMemberCount));
                int lastUnratedMemberCount = rs.getInt("lastUnratedMemberCount");
                dto.setLastUnratedMemberCount(Integer.valueOf(lastUnratedMemberCount));
                int lastInvalidMemberCount = rs.getInt("lastInvalidMemberCount");
                dto.setLastInvalidMemberCount(Integer.valueOf(lastInvalidMemberCount));
                int curTotalMemberCount = rs.getInt("curTotalMemberCount");
                dto.setCurTotalMemberCount(Integer.valueOf(curTotalMemberCount));
                int lastTotalMemberCount = rs.getInt("lastTotalMemberCount");
                dto.setLastTotalMemberCount(Integer.valueOf(lastTotalMemberCount));
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)dto);
    }

    private String queryPortraitDetailData(List<UserDataAuthsVO> userDataAuths, MemberQueryDetailQo vo) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT any_value(ta.store_name) as storeName, ifnull(any_value(ta.curTotalMemberCount),0) as curTotalMemberCount,  ifnull(any_value(tb.lastTotalMemberCount),0) as lastTotalMemberCount, any_value(ifnull(ta.coreMemberCount,0)) as curCoreMemberCount, any_value ( ifnull( ta.coreMemberCount, 0 )-ifnull( tb.coreMemberCount, 0 )) AS coreMemberRatio, any_value(ifnull(ta.commonMemberCount,0)) as curCommonMemberCount, any_value (ifnull( ta.commonMemberCount, 0 )-ifnull( tb.commonMemberCount, 0 )) AS commonMemberRatio, any_value(ifnull(ta.lightMemberCount,0)) as curLightMemberCount, any_value (ifnull( ta.lightMemberCount, 0 )-ifnull( tb.lightMemberCount, 0 )) AS lightMemberRatio,  any_value(ifnull(ta.moderateMemberCount,0)) as curModerateMemberCount, any_value (ifnull( ta.moderateMemberCount, 0 )-ifnull( tb.moderateMemberCount, 0 )) AS moderateMemberRatio, any_value(ifnull(ta.deepMemberCount,0)) as curDeepMemberCount, any_value (ifnull( ta.deepMemberCount, 0 )-ifnull( tb.deepMemberCount, 0 )) AS deepMemberRatio,  any_value(ifnull(ta.severeMemberCount,0)) as curSevereMemberCount, any_value (ifnull( ta.severeMemberCount, 0 )-ifnull( tb.severeMemberCount, 0 )) AS severeMemberRatio, any_value(ifnull(ta.newMemberCount,0)) as curNewMemberCount, any_value (ifnull( ta.newMemberCount, 0 )-ifnull( tb.newMemberCount, 0 )) AS newMemberRatio, any_value(ifnull(ta.unratedMemberCount,0)) as curUnratedMemberCount,  any_value (ifnull( ta.unratedMemberCount, 0 )-ifnull( tb.unratedMemberCount, 0 )) AS unratedMemberRatio,  any_value(ifnull(ta.invalidMemberCount,0)) as curInvalidMemberCount,  any_value (ifnull( ta.invalidMemberCount, 0 )-ifnull( tb.invalidMemberCount, 0 )) AS invalidMemberRatio, any_value(ifnull(tb.coreMemberCount,0)) as lastCoreMemberCount, any_value(ifnull(tb.commonMemberCount,0)) as lastCommonMemberCount, any_value(ifnull(tb.lightMemberCount,0)) as lastLightMemberCount,  any_value(ifnull(tb.moderateMemberCount,0)) as lastModerateMemberCount, any_value(ifnull(tb.deepMemberCount,0)) as lastDeepMemberCount, any_value(ifnull(tb.severeMemberCount,0)) as lastSevereMemberCount, any_value(ifnull(tb.newMemberCount,0)) as lastNewMemberCount, any_value(ifnull(tb.unratedMemberCount,0)) as lastUnratedMemberCount, any_value(ifnull(tb.invalidMemberCount,0)) as lastInvalidMemberCount FROM (SELECT any_value(ppsi.create_time) as create_time,   any_value(YEAR(ppsi.create_time)) yy,   any_value(MONTH(ppsi.create_time)) mm,   any_value(pps.store_name)  as store_name,   any_value(ppsi.store_id) as store_id,   COUNT(ppsi.id) as curTotalMemberCount, IFNULL(SUM(   IF   ( ppsi.tag_name = '\u6838\u5fc3\u4f1a\u5458', 1, 0 )),0) AS coreMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u666e\u901a\u4f1a\u5458', 1, 0 )),0) AS commonMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u8f7b\u5ea6\u7761\u7720', 1, 0 )),0) AS lightMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u4e2d\u5ea6\u7761\u7720', 1, 0 )),0) AS moderateMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u91cd\u5ea6\u7761\u7720', 1, 0 )),0) AS deepMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u6df1\u5ea6\u7761\u7720', 1, 0 )),0) AS severeMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u65b0\u589e\u4f1a\u5458', 1, 0 )),0) AS newMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u672a\u5206\u7ea7', 1, 0 )),0) AS unratedMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u65e0\u6548\u4f1a\u5458', 1, 0 )),0) AS invalidMemberCount  FROM   ps_portrait_statics_info ppsi   LEFT JOIN ps_patient_store pps on ppsi.store_id=pps.id  WHERE   ppsi.`status` = 1 AND ppsi.scene_type = 1    and ppsi.store_id='" + vo.getStoreId() + "'  and DATE_FORMAT(ppsi.create_time, '%Y-%m')='" + vo.getQueryTime() + "' GROUP BY DATE_FORMAT(ppsi.create_time, '%Y-%m')   ) ta   LEFT JOIN   (   SELECT   any_value(YEAR(ppsi.create_time)) yy,   any_value(MONTH(ppsi.create_time)) mm,   any_value(ppsi.store_id) as store_id,   COUNT(ppsi.id) as lastTotalMemberCount,IFNULL(SUM(   IF   ( ppsi.tag_name = '\u6838\u5fc3\u4f1a\u5458', 1, 0 )),0) AS coreMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u666e\u901a\u4f1a\u5458', 1, 0 )),0) AS commonMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u8f7b\u5ea6\u7761\u7720', 1, 0 )),0) AS lightMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u4e2d\u5ea6\u7761\u7720', 1, 0 )),0) AS moderateMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u91cd\u5ea6\u7761\u7720', 1, 0 )),0) AS deepMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u6df1\u5ea6\u7761\u7720', 1, 0 )),0) AS severeMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u65b0\u589e\u4f1a\u5458', 1, 0 )),0) AS newMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u672a\u5206\u7ea7', 1, 0 )),0) AS unratedMemberCount,   IFNULL(SUM(   IF   ( ppsi.tag_name = '\u65e0\u6548\u4f1a\u5458', 1, 0 )),0) AS invalidMemberCount  FROM   ps_portrait_statics_info ppsi  WHERE   ppsi.`status` = 1 AND ppsi.scene_type = 1    and ppsi.store_id='" + vo.getStoreId() + "'  and DATE_FORMAT(ppsi.create_time, '%Y-%m')='" + vo.getQueryTime() + "' GROUP BY DATE_FORMAT(ppsi.create_time, '%Y-%m')   ) tb on ta.store_id=tb.store_id and ( (ta.yy = tb.yy and tb.mm = ta.mm - 1) OR (tb.yy=ta.yy - 1 AND tb.mm = 12 AND ta.mm = 1) )  ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> getPatientTotalCount(Connection connection, List<UserDataAuthsVO> userDataAuths) {
        StringBuilder sb = new StringBuilder();
        sb.append("    select        count(temp.id) as cou    from        (        select            ppi.id id        from            ps_patient_split_info ppi        inner join ps_patient_store_reg PPSR on            PPSR.patient_id = ppi.id            and PPSR.`status` = 1  where   ppi.status = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and PPSR.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        sb.append("   group by            ppi.id) temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> getBackListListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, BackListInfoDto vo) {
        StringBuilder sb = new StringBuilder();
        sb.append("     SELECT COUNT(1) as cou FROM (   SELECT      be.id AS id,      pa.patient_name AS patientName,      pa.patient_member_no patientCardNo,      pa.patient_phone telphone,      be.service_type AS serviceType,      be.create_time AS createTime,      be.remark AS remark,      pai.login_name isAccountName,      ppss.store_name cardStoreName,      ( SELECT paii.login_name FROM ps_account_info paii WHERE paii.id = be.create_person_id AND paii.`status` = 1 ) createProsenName    FROM      ps_backlist_emp be      INNER JOIN ps_patient_info pa ON pa.id = be.patient_id       AND pa.`status` = 1      LEFT  JOIN `ps_account_info` AS `pai` ON `pai`.`id` = `pa`.`archives_create_person`      LEFT  JOIN `ps_patient_store_reg` AS `ppsr` ON ((            `ppsr`.`patient_id` = `pa`.`id`             )       AND ( `ppsr`.`is_create_store` = 1 ))       AND ( `ppsr`.`STATUS` = 1 )      LEFT  JOIN `ps_patient_store` AS `ppss` ON ( `ppss`.`id` = `ppsr`.`store_id` )       AND ( `ppss`.`STATUS` = 1 )         WHERE      be.STATUS =1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and ppsr.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getCardStoreId())) {
            sb.append(" and ppss.id in (");
            String[] split = vo.getCardStoreId().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getParams())) {
            sb.append(" and ( ");
            sb.append("  pa.patient_name like '%" + vo.getParams() + "%'");
            sb.append(" or pa.patient_phone like '%" + vo.getParams() + "%'");
            sb.append(" or pa.patient_member_no like '%" + vo.getParams() + "%'");
            sb.append(" )");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBeginTime())) {
            sb.append("and be.create_time between '" + vo.getBeginTime() + " 00:00:00'");
            sb.append(" and '" + vo.getBeginTime() + " 23:59:59'");
        }
        sb.append("  order by be.create_time desc ");
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<BackListInfoDto>> getBackListList(Connection connection, List<UserDataAuthsVO> userDataAuths, BackListInfoDto vo, Boolean isPage) {
        ArrayList<BackListInfoDto> list = new ArrayList<BackListInfoDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getBackListListData(userDataAuths, vo));
        if (isPage.booleanValue()) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                BackListInfoDto dto = new BackListInfoDto();
                String id = rs.getString("id");
                dto.setId(id);
                String patientName = rs.getString("patientName");
                dto.setPatientName(patientName);
                String patientCardNo = rs.getString("patientCardNo");
                dto.setPatientCardNo(patientCardNo);
                String telphone = rs.getString("telphone");
                dto.setTelphone(telphone);
                String isAccountName = rs.getString("isAccountName");
                dto.setIsAccountName(isAccountName);
                String cardStoreName = rs.getString("cardStoreName");
                dto.setCardStoreName(cardStoreName);
                int serviceType = rs.getInt("serviceType");
                dto.setServiceType(Integer.valueOf(serviceType));
                String remark = rs.getString("remark");
                dto.setRemark(remark);
                String createTime = rs.getString("createTime");
                dto.setCreateTime(DateUtils.parseYMDFullDateTime((String)createTime));
                String createProsenName = rs.getString("createProsenName");
                dto.setCreateProsenName(createProsenName);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getBackListListData(List<UserDataAuthsVO> userDataAuths, BackListInfoDto vo) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT      be.id AS id,      pa.patient_name AS patientName,      pa.patient_member_no patientCardNo,      pa.patient_phone telphone,      be.service_type AS serviceType,      be.create_time AS createTime,      be.remark AS remark,      pai.login_name isAccountName,      ppss.store_name cardStoreName,      ( SELECT paii.login_name FROM ps_account_info paii WHERE paii.id = be.create_person_id AND paii.`status` = 1 ) createProsenName    FROM      ps_backlist_emp be      INNER JOIN ps_patient_info pa ON pa.id = be.patient_id       AND pa.`status` = 1      LEFT  JOIN `ps_account_info` AS `pai` ON `pai`.`id` = `pa`.`archives_create_person`      LEFT  JOIN `ps_patient_store_reg` AS `ppsr` ON ((            `ppsr`.`patient_id` = `pa`.`id`             )       AND ( `ppsr`.`is_create_store` = 1 ))       AND ( `ppsr`.`STATUS` = 1 )      LEFT  JOIN `ps_patient_store` AS `ppss` ON ( `ppss`.`id` = `ppsr`.`store_id` )       AND ( `ppss`.`STATUS` = 1 )         WHERE      be.STATUS =1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and ppsr.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getCardStoreId())) {
            sb.append(" and ppss.id in (");
            String[] split = vo.getCardStoreId().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getParams())) {
            sb.append(" and ( ");
            sb.append("  pa.patient_name like '%" + vo.getParams() + "%'");
            sb.append(" or pa.patient_phone like '%" + vo.getParams() + "%'");
            sb.append(" or pa.patient_member_no like '%" + vo.getParams() + "%'");
            sb.append(" )");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBeginTime())) {
            sb.append("and be.create_time between '" + vo.getBeginTime() + " 00:00:00'");
            sb.append(" and '" + vo.getBeginTime() + " 23:59:59'");
        }
        sb.append("  order by be.create_time desc ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<PatientInfoDTO>> queryPatientInfoV3(Connection connection, String userStoreId, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo, boolean exportFlag) {
        ArrayList<PatientInfoDTO> list = new ArrayList<PatientInfoDTO>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlDataV3(userDataAuths, vo, userStoreId, false, exportFlag));
        if (ObjectUtil.isNotEmpty((Object)vo.getPageIndex())) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        }
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                PatientInfoDTO dto = new PatientInfoDTO();
                String id = rs.getString("patientInfoId");
                String formatDateTime = rs.getString("ppati_createTime");
                String patientName = rs.getString("patientName");
                String patientPhone = rs.getString("patientPhone");
                String patientMemberNo = rs.getString("patientMemberNo");
                int patientSex = rs.getInt("patientSex");
                String patientIdCard = rs.getString("patientIdCard");
                String patientBirthday = rs.getString("patientBirthday");
                String archivesCreatePerson = rs.getString("archivesCreatePerson");
                String createPerson = rs.getString("createPerson");
                String storeName = rs.getString("storeName");
                String patientType = rs.getString("patientType");
                String memberLevel = rs.getString("memberLevel");
                String memberValue = rs.getString("memberValue");
                String patientSourceChanelName = rs.getString("patientSourceChanelName");
                String storeId = rs.getString("storeId");
                String storeList = rs.getString("storeList1");
                String patientIndication = rs.getString("patientIndication");
                dto.setPatientIndication(patientIndication);
                dto.setStoreCreateTime(formatDateTime);
                dto.setPatientType(patientType);
                dto.setMemberLevel(memberLevel);
                dto.setMemberValue(memberValue);
                dto.setPatientInfoId(id);
                dto.setPatientName(patientName);
                dto.setPatientPhone(patientPhone);
                dto.setPatientMemberNo(patientMemberNo);
                dto.setPatientSex(Integer.valueOf(patientSex));
                dto.setPatientIdCard(patientIdCard);
                dto.setPatientBirthday(patientBirthday);
                dto.setPatientSourceChanelName(patientSourceChanelName);
                if (StringUtils.isNotEmpty((CharSequence)archivesCreatePerson)) {
                    dto.setArchivesCreatePerson(archivesCreatePerson);
                }
                dto.setStoreName(storeName);
                dto.setStoreId(storeId);
                dto.setStoreListStr(storeList);
                dto.setArchivesCreateTime(formatDateTime);
                if (exportFlag) {
                    String detailAddress = rs.getString("detailAddress");
                    String empNo = rs.getString("empNo");
                    String storeCode = rs.getString("storeCode");
                    String prescriptionList = rs.getString("prescriptionList1");
                    String storeListCodes = rs.getString("storeListCodes");
                    String icdCode = rs.getString("icdCode");
                    String icdName = rs.getString("icdName");
                    String archivesCreatePerson1 = rs.getString("archivesCreatePerson1");
                    String recordCreateTime = rs.getString("archivesCreateTime");
                    String archivesCreateStoreName = rs.getString("archivesCreateStoreName");
                    String archivesCreateStoreCode = rs.getString("archivesCreateStoreCode");
                    String medicalInsurancePerson = rs.getString("medicalInsurancePerson");
                    String medicalInsurancePersonNo = rs.getString("medicalInsurancePersonNo");
                    String medicalInsuranceStoreName = rs.getString("medicalInsuranceStoreName");
                    String medicalInsuranceStoreCode = rs.getString("medicalInsuranceStoreCode");
                    String medicalInsuranceTime = rs.getString("medicalInsuranceTime");
                    String archivesCreatePersonNo = rs.getString("archivesCreatePersonNo");
                    dto.setMedicalInsurancePerson(medicalInsurancePerson);
                    dto.setMedicalInsurancePersonNo(medicalInsurancePersonNo);
                    dto.setMedicalInsuranceStoreName(medicalInsuranceStoreName);
                    dto.setMedicalInsuranceStoreCode(medicalInsuranceStoreCode);
                    dto.setMedicalInsuranceTime(medicalInsuranceTime);
                    dto.setArchivesCreatePersonNo(archivesCreatePersonNo);
                    dto.setDetailAddress(detailAddress);
                    dto.setStoreCode(storeCode);
                    dto.setStoreListCodes(storeListCodes);
                    dto.setRecordCreatePerson(archivesCreatePerson1);
                    dto.setRecordCreateTime(recordCreateTime);
                    dto.setArchivesCreateStoreName(archivesCreateStoreName);
                    dto.setArchivesCreateStoreCode(archivesCreateStoreCode);
                    dto.setEmpNo(empNo);
                    dto.setPrescriptionListStr(prescriptionList);
                    dto.setIcdCodeStr(icdCode);
                    dto.setIcdNameStr(icdName);
                }
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfo: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getSqlDataV3(List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo, String userStoreId, boolean idOnly, boolean exportFlag) {
        StringBuffer sb = new StringBuffer();
        if (exportFlag) {
            sb.append(" SELECT * FROM (SELECT ");
            sb.append(" ppati.id AS patientInfoId, ");
            sb.append(" any_value ( ppati.archives_create_time ) AS ppati_createTime, ");
            sb.append(" any_value ( ppati.patient_name ) AS patientName, ");
            sb.append(" any_value ( ppati.patient_head_portrait ) AS patientHeadPortrait, ");
            sb.append(" any_value ( ppati.patient_phone ) AS patientPhone, ");
            sb.append(" any_value ( ppati.patient_member_no ) AS patientMemberNo, ");
            sb.append(" any_value ( ppati.patient_sex ) AS patientSex, ");
            sb.append(" any_value ( ppati.patient_id_card ) AS patientIdCard, ");
            sb.append(" any_value ( ppati.patient_birthday ) AS patientBirthday, ");
            sb.append(" any_value ( ppati.detail_address ) AS detailAddress, ");
            sb.append(" any_value ( pai.login_name ) AS archivesCreatePerson, ");
            sb.append(" any_value ( pai.empl_no ) AS empNo, ");
            sb.append(" any_value ( ppati.archives_create_person ) AS createPerson, ");
            sb.append(" any_value ( ppss.id ) AS storeId, ");
            sb.append(" any_value ( ppss.store_name ) AS storeName, ");
            sb.append(" any_value ( ppss.store_code ) AS storeCode, ");
            sb.append(" any_value ( ppati.patient_card_type ) AS patientCardType, ");
            sb.append(" CASE WHEN (((any_value(`ppati`.`is_dtp`)) = 0) AND ((any_value(`ppati`.`is_common`)) = 1)) THEN '\u666e\u836f\u60a3\u8005' WHEN (((any_value(`ppati`.`is_dtp`)) = 1) AND ((any_value(`ppati`.`is_common`)) = 0)) THEN 'DTP\u60a3\u8005' WHEN (((any_value(`ppati`.`is_dtp`)) = 1) AND ((any_value(`ppati`.`is_common`)) = 1)) THEN 'DTP\u60a3\u8005;\u666e\u836f\u60a3\u8005' ELSE '' END AS `patientType`, ");
            sb.append(" any_value ( ppati.member_level ) AS memberLevel, ");
            sb.append(" any_value ( ppati.member_value ) AS memberValue, ");
            sb.append(" any_value ( ppati.medical_type ) AS medicalType, ");
            sb.append(" any_value ( ppati.patient_indication ) AS patientIndication, ");
            sb.append(" any_value ( ppati.patient_medicine ) AS patientMedicine, ");
            sb.append(" any_value ( ppati.patient_medicine_currency ) AS patientMedicineCurrency, ");
            sb.append(" any_value ( ppati.patient_medicine_tumour ) AS patientMedicineTumour, ");
            sb.append(" any_value ( pdp.hospital_id ) AS hospitalId, ");
            sb.append(" any_value ( ppati.source_channel_name ) AS patientSourceChanelName, ");
            sb.append(" any_value ( pdp.department_id ) AS departmentId, ");
            sb.append(" any_value ( pdp.doctor_id ) AS doctorId, ");
            sb.append(" min ( ppsr.store_id ) AS storeIdFilter, ");
            sb.append(" any_value ( ppo.org_id ) AS orgId, ");
            sb.append(" any_value ( ppo.org_name ) AS orgName, ");
            sb.append(" any_value ( ppsr.pharmaceutical_company_id ) AS pharmaceuticalCompanyId, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( ppsr.store_id ))), ',' ) AS storeIdList, ");
            sb.append(" any_value ( t1.login_name ) AS archivesCreatePerson1, ");
            sb.append(" any_value ( pphrec.first_record_time ) AS archivesCreateTime, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pii.icd_code ))), ',' ) AS icdCode, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pii.icd_name ))), ',' ) AS icdName, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pps.store_name ))), ',' ) AS storeList1, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pps.store_code ))), ',' ) AS storeListCodes, ");
            sb.append(" array_join ( reverse( array_distinct ( array_agg ( pdp.pres_hospital_name ))), ',' ) AS prescriptionList1, ");
            sb.append(" any_value ( t1.store_id ) AS archivesCreateStore, ");
            sb.append(" any_value ( t1.empl_no ) AS archivesCreatePersonNo, ");
            sb.append(" any_value ( ppsss.store_code ) AS archivesCreateStoreCode, ");
            sb.append(" any_value ( ppsss.store_name ) AS archivesCreateStoreName, ");
            sb.append(" any_value ( ppati.patient_currency_update_time ) AS archivesCurrencyUpdateTime, ");
            sb.append(" any_value ( ppati.patient_currency_create_person ) AS archivesCurrencyUpdatePerson, ");
            sb.append(" any_value ( ppati.patient_tumour_update_time ) AS archivesTumorUpdateTime, ");
            sb.append(" any_value ( ppati.patient_tumour_create_person ) AS archivesTumorUpdatePerson, ");
            sb.append(" any_value ( t3.login_name ) AS medicalInsurancePerson, ");
            sb.append(" any_value ( t3.empl_no ) AS medicalInsurancePersonNo, ");
            sb.append(" any_value ( t2.store_name ) AS medicalInsuranceStoreName, ");
            sb.append(" any_value ( t2.store_code ) AS medicalInsuranceStoreCode, ");
            sb.append(" any_value ( ppmi.archives_create_time ) AS medicalInsuranceTime, ");
            sb.append(" array_max (array_concat (array_append ([], ");
            sb.append(" any_value ( ppati.patient_currency_update_time )),array_append ([], ");
            sb.append(" any_value ( ppati.patient_tumour_update_time )))) AS archivesAllUpdateTime, ");
            sb.append(" split_part (array_join (reverse(array_sortby ( ");
            sb.append(" array_concat (array_append ([],any_value ( ppati.patient_currency_create_person )),array_append ([],any_value ( ppati.patient_tumour_create_person ))), ");
            sb.append(" array_concat (array_append ([],any_value ( ppati.patient_currency_update_time )),array_append ([],any_value ( ppati.patient_tumour_update_time ))))),'-'),'-',1) AS archivesAllUpdatePerson ");
            sb.append(" FROM ps_patient_split_info AS ppati ");
            sb.append(" \tINNER JOIN  ps_patient_store_reg AS ppsr ON ( ppsr.patient_id = ppati.id ) ");
            sb.append(" \tAND ( ppsr.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS pps ON pps.id = ppsr.store_id ");
            sb.append(" \tLEFT OUTER JOIN  ps_account_info AS pai ON pai.id = ppati.archives_create_person ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store_reg AS ppsrr ON (( ppsrr.patient_id = ppati.id ) ");
            sb.append(" \tAND ( ppsrr.is_create_store = 1 )) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS ppss ON ( ppss.id = ppsrr.store_id ) ");
            sb.append(" \tAND ( ppss.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_icd_reg AS ppir ON ( ppati.id = ppir.patient_id ) ");
            sb.append(" \tAND ( ppir.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_icd_item AS pii ON ( ppir.icd_id = pii.icd_code ) ");
            sb.append(" \tAND ( pii.STATUS = 1 ) ");
            sb.append(" LEFT OUTER JOIN `ps_patient_disease_parameter` AS `pphrec` ON ((     `ppati`.`id` = `pphrec`.`patient_id`      )     and `pphrec`.first_record_time IS NOT NULL      ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_account_info AS t1 ON ( pphrec.first_record_person = t1.id ) ");
            sb.append(" \tAND ( t1.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS ppsss ON ( ppsss.id = t1.store_id ) ");
            sb.append(" \tAND ( ppsss.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_drug_prescription AS pdp ON ( ppati.id = pdp.patient_id ) ");
            sb.append(" \tAND ( pdp.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_condition_tumour_diagnosis AS pctd ON ( ppati.id = pctd.patient_id ) ");
            sb.append(" \tAND ( pctd.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_medical_insurance AS ppmi ON ( ppati.id = ppmi.patient_id ) ");
            sb.append(" \tAND ( ppmi.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_account_info AS t3 ON ( t3.id = ppmi.archives_create_person ) ");
            sb.append(" \tAND ( t3.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_store AS t2 ON ( t2.id = t3.store_id ) ");
            sb.append(" \tAND ( t2.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_org_store_reg AS pposr ON ( pposr.store_id=ppsr.store_id ) ");
            sb.append(" \tAND ( pposr.STATUS = 1 ) ");
            sb.append(" \tLEFT OUTER JOIN  ps_patient_org AS ppo ON ( ppo.id = reverse(split(pposr.org_id,','))[1]) ");
            sb.append(" \tAND ( ppo.STATUS = 1 ) ");
            sb.append(" WHERE ppati.STATUS = 1  ");
            sb.append(" GROUP BY ppati.id) pmlm");
        } else {
            sb.append("SELECT " + (idOnly ? "patientInfoId" : "*") + " from patient_split_manage_list_mv_v3 pmlm ");
        }
        sb.append(" where 1=1 ");
        this.dealUserDataAuth(userDataAuths, sb);
        this.exportByPatientIds(vo, sb);
        this.quickSearchContent(vo, sb);
        this.queryPatientInfoByCondition(vo, sb, "1");
        this.getPatientType(vo, sb);
        this.queryDtpMedicineByCondition(vo, sb);
        this.queryDtpPrescriptionByCondition(vo, sb);
        this.queryConsumerAndDrugByCondition(vo, sb, "1");
        this.queryChronicByCondition(vo, sb);
        this.queryHealthCheckByCondition(vo, sb);
        this.queryMedicalInsuranceCondition(vo, sb);
        this.queryDeleteMethodCondition(vo, sb);
        this.queryOtherInfoByCondition(vo, sb);
        if (!idOnly) {
            sb.append(" order by ");
            if (Objects.nonNull(userStoreId)) {
                sb.append(" (case when pmlm.storeId = '" + userStoreId + "' then 0 else 1 end),");
            }
            sb.append(" pmlm.ppati_createtime desc ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> queryPatientInfoCountV3(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientInFoListVo vo, boolean exportFlag) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getSqlDataV3(userDataAuths, vo, null, false, false));
        sb.append(" ) temp");
        Integer count = 0;
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    public List<PatientInfoDTO> dataPageFilter(List<PatientInfoDTO> list, String storeId, PatientInFoListVo vo) {
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList<PatientInfoDTO>();
        }
        for (PatientInfoDTO patientInfoDTO : list) {
            if (StringUtils.equals((CharSequence)patientInfoDTO.getStoreId(), (CharSequence)storeId)) {
                patientInfoDTO.setSort(Integer.valueOf(1));
                continue;
            }
            patientInfoDTO.setSort(Integer.valueOf(0));
        }
        list = list.stream().sorted(Comparator.comparing(PatientInfoDTO::getSort, Comparator.reverseOrder()).thenComparing(PatientInfoDTO::getStoreCreateTime, Comparator.reverseOrder())).collect(Collectors.toList());
        if (ObjectUtil.isEmpty((Object)vo.getPageSize())) {
            return list;
        }
        ArrayList<PatientInfoDTO> listResult = new ArrayList<PatientInfoDTO>();
        int n = 0;
        int endIndex = list.size() < vo.getPageSize() ? list.size() : vo.getPageSize().intValue();
        for (int i = n; i < endIndex; ++i) {
            listResult.add((PatientInfoDTO)list.get(i));
        }
        return listResult;
    }
}

