/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.starrocks;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ebaiyihui.dto.GetMainListByManageResponseDto;
import com.ebaiyihui.dto.PrescriptionAppletListResponseDto;
import com.ebaiyihui.utils.DateUtils;
import com.ebaiyihui.utils.RedisUtil;
import com.ebaiyihui.vo.GetMainListAppletRequestVO;
import com.ebaiyihui.vo.UserDataAuthsVO;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StarRocksPresUtils {
    private static final Logger log = LoggerFactory.getLogger(StarRocksPresUtils.class);
    @Autowired
    private RedisUtil redisUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<PrescriptionAppletListResponseDto>> queryDrugMainListByApplet(Connection connection, GetMainListAppletRequestVO vo) {
        ArrayList<PrescriptionAppletListResponseDto> list = new ArrayList<PrescriptionAppletListResponseDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDrugMainListDataByApplet(vo));
        int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
        sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                PrescriptionAppletListResponseDto dto = new PrescriptionAppletListResponseDto();
                String pdpre_id = rs.getString("pdpre_id");
                Date pdpre_prescriptionInputTime = rs.getDate("pdpre_prescriptionInputTime");
                String pdpre_prescriptionData = rs.getString("pdpre_prescriptionData");
                String pdpre_presHospitalName = rs.getString("pdpre_presHospitalName");
                String pdpre_presDeptName = rs.getString("pdpre_presDeptName");
                String pdpre_presDoctorName = rs.getString("pdpre_presDoctorName");
                String drugNames = rs.getString("drugNames");
                String diagnosis = rs.getString("diagnosis");
                String storeName = rs.getString("storeName");
                dto.setDrugPrescriptionId(pdpre_id);
                dto.setPrescriptionInputTime((java.util.Date)pdpre_prescriptionInputTime);
                dto.setPrescriptionData(pdpre_prescriptionData);
                dto.setPresHospitalName(pdpre_presHospitalName);
                dto.setPresDeptName(pdpre_presDeptName);
                dto.setPresDoctorName(pdpre_presDoctorName);
                dto.setDrugNames(drugNames);
                dto.setDiagnosis(diagnosis);
                dto.setStoreName(storeName);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryDrugMainListByApplet: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainListByApplet: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainListByApplet: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<String> queryDrugMainListCountByApplet(Connection connection, GetMainListAppletRequestVO vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getDrugMainListDataByApplet(vo));
        sb.append(" ) temp");
        String count = "0";
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getString("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryDrugMainListCountByApplet: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainListCountByApplet: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainListCountByApplet: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private String getDrugMainListDataByApplet(GetMainListAppletRequestVO vo) {
        StringBuffer sb = new StringBuffer("SELECT * from prescription_applet_list_mv palm ");
        sb.append(" where 1 = 1 ");
        if (StringUtils.isNotEmpty((CharSequence)vo.getPatientId())) {
            sb.append(" AND palm.patientId = '" + vo.getPatientId() + "' ");
        } else {
            sb.append(" AND palm.patientName is not null ");
        }
        sb.append(" ORDER BY palm.createTime DESC ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<GetMainListByManageResponseDto>> queryDrugMainList(Connection connection, List<UserDataAuthsVO> userDataAuths, GetMainListAppletRequestVO vo) {
        ArrayList<GetMainListByManageResponseDto> list = new ArrayList<GetMainListByManageResponseDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDrugMainListData(userDataAuths, vo));
        if (vo.needCache().booleanValue()) {
            sb.append(" limit 100 offset 0");
        } else {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + vo.getPageSize() + " offset " + firstIndex);
        }
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                GetMainListByManageResponseDto dto = new GetMainListByManageResponseDto();
                String drugPrescriptionId = rs.getString("drugPrescriptionId");
                String salesOrder = rs.getString("salesOrder");
                String patientId = rs.getString("patientId");
                String patientName = rs.getString("patientName");
                String patientPhone = rs.getString("patientPhone");
                String patientNo = rs.getString("patientNo");
                int patientSexString = rs.getInt("patientSexString");
                int patientAge = rs.getInt("patientAge");
                String threeMainNo = rs.getString("threeMainNo");
                String patientIdCard = rs.getString("patientIdCard");
                String drugIds = rs.getString("drugIds");
                String drugSpec = rs.getString("drugSpec");
                String manufacturer = rs.getString("manufacturer");
                String unitPrice = rs.getString("unitPrice");
                String amount = rs.getString("amount");
                String singleDose = rs.getString("singleDose");
                String duration = rs.getString("duration");
                dto.setPatientIdCard(patientIdCard);
                dto.setDrugIds(drugIds);
                dto.setDrugSpec(drugSpec);
                dto.setManufacturer(manufacturer);
                dto.setUnitPrice(unitPrice);
                dto.setAmount(amount);
                dto.setSingleDose(singleDose);
                dto.setDuration(duration);
                String presHospitalName = rs.getString("presHospitalName");
                String presDeptName = rs.getString("presDeptName");
                String presDoctorName = rs.getString("presDoctorName");
                String prescriptionInputTimeString = rs.getString("prescriptionInputTimeString");
                String createAccountPerson = rs.getString("createAccountPerson");
                String storeName = rs.getString("storeName");
                String createTime = rs.getString("createTime");
                int mainStatus = rs.getInt("mainStatus");
                int hasMedicalInsurance = rs.getInt("hasMedicalInsurance");
                Object value = this.redisUtil.get("INTEGRATE_MAIN_STATUS_PRESID:" + drugPrescriptionId);
                if (Objects.nonNull(value)) {
                    mainStatus = Integer.parseInt(value.toString());
                }
                String diagnosis = rs.getString("diagnosis");
                String drugNames = rs.getString("drugNames");
                StringBuilder drugNamesNew = new StringBuilder();
                if (ObjectUtil.isNotEmpty((Object)drugNames)) {
                    String[] drugNamesSplit = drugNames.split("@@@");
                    for (int i = 0; i < drugNamesSplit.length; ++i) {
                        drugNamesNew.append(drugNamesSplit[i]);
                        drugNamesNew.append(",");
                    }
                    drugNamesNew.deleteCharAt(drugNamesNew.lastIndexOf(","));
                }
                String icdNames = rs.getString("icdNames");
                String remarkUser = rs.getString("remarkUser");
                if (StringUtils.isNotEmpty((CharSequence)remarkUser)) {
                    String[] splitRemarkUser = remarkUser.split("@@@");
                    String remarkType = rs.getString("remarkType");
                    String[] splitRemarkType = remarkType.split("@@@");
                    String inputTime = rs.getString("inputTime");
                    String[] splitInputTime = inputTime.split("@@@");
                    for (int i = 0; i < splitRemarkType.length; ++i) {
                        if ("10".equals(splitRemarkType[i])) {
                            dto.setInputPerson(splitRemarkUser[i]);
                            if (i < splitInputTime.length) {
                                dto.setInputTime(DateUtils.formatYMDHMSDateTime((String)splitInputTime[i]));
                            }
                        }
                        if ("20".equals(splitRemarkType[i]) || "30".equals(splitRemarkType[i])) {
                            dto.setExaminePerson(splitRemarkUser[i]);
                            if (i < splitInputTime.length) {
                                dto.setExamineTime(DateUtils.formatYMDHMSDateTime((String)splitInputTime[i]));
                            }
                        }
                        if ("40".equals(splitRemarkType[i]) || "50".equals(splitRemarkType[i])) {
                            dto.setAllocate(splitRemarkUser[i]);
                            if (i < splitInputTime.length) {
                                dto.setAllocateTime(DateUtils.formatYMDHMSDateTime((String)splitInputTime[i]));
                            }
                        }
                        if (!"55".equals(splitRemarkType[i]) && !"56".equals(splitRemarkType[i]) && !"60".equals(splitRemarkType[i])) continue;
                        dto.setReCheckPerson(splitRemarkUser[i]);
                        if (i >= splitInputTime.length) continue;
                        dto.setReCheckTime(DateUtils.formatYMDHMSDateTime((String)splitInputTime[i]));
                    }
                }
                dto.setDrugNames(drugNamesNew.toString());
                dto.setIcdNames(icdNames);
                if (1 == patientSexString) {
                    dto.setPatientSexString("\u7537");
                } else if (2 == patientSexString) {
                    dto.setPatientSexString("\u5973");
                } else {
                    dto.setPatientSexString("-");
                }
                dto.setDrugPrescriptionId(drugPrescriptionId);
                dto.setSalesOrder(salesOrder);
                dto.setPatientId(patientId);
                dto.setPatientName(patientName);
                dto.setPatientPhone(patientPhone);
                dto.setPatientNo(patientNo);
                dto.setPatientAge(Integer.valueOf(patientAge));
                dto.setThreeMainNo(threeMainNo);
                dto.setPatientIdCard(patientIdCard);
                dto.setPresHospitalName(presHospitalName);
                dto.setPresDeptName(presDeptName);
                dto.setPresDoctorName(presDoctorName);
                dto.setPrescriptionInputTimeString(DateUtils.formatYMDHMSDateTime((String)prescriptionInputTimeString));
                dto.setCreateAccountPerson(createAccountPerson);
                dto.setStoreName(storeName);
                dto.setCreateTime(createTime);
                dto.setMainStatus(Integer.valueOf(mainStatus));
                dto.setDiagnosis(diagnosis);
                dto.setHasMedicalInsuranceStr(hasMedicalInsurance != 1 ? "\u5426" : "\u662f");
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryDrugMainList: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                if (null != ps) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<String> queryDrugMainListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, GetMainListAppletRequestVO vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getDrugMainListData(userDataAuths, vo));
        sb.append(" ) temp");
        String count = "0";
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getString("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryDrugMainListCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                if (null != ps) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryDrugMainListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private String getDrugMainListData(List<UserDataAuthsVO> userDataAuths, GetMainListAppletRequestVO vo) {
        long size1;
        int i;
        StringBuffer sb = new StringBuffer("SELECT * from prescription_manage_list_mv pmlm ");
        sb.append(" where 1=1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pmlm.storeId in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getStoreIds())) {
            sb.append(" and pmlm.storeId in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getInputPersonIds())) {
            sb.append(" and pmlm.createPerson in (");
            String[] split = vo.getInputPersonIds().split(",");
            for (int i2 = 0; i2 < split.length; ++i2) {
                if (i2 != split.length - 1) {
                    sb.append("'" + split[i2] + "',");
                    continue;
                }
                sb.append("'" + split[i2] + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getHasMedicalInsurance())) {
            if (1 == vo.getHasMedicalInsurance()) {
                sb.append(" and pmlm.hasMedicalInsurance is not null and pmlm.hasMedicalInsurance!=2  ");
            } else {
                sb.append(" and pmlm.hasMedicalInsurance is null or  pmlm.hasMedicalInsurance!=1  ");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getPrescriptionIds())) {
            sb.append(" and pmlm.drugPrescriptionId in (");
            for (int i3 = 0; i3 < vo.getPrescriptionIds().size(); ++i3) {
                if (i3 != vo.getPrescriptionIds().size() - 1) {
                    sb.append("'" + (String)vo.getPrescriptionIds().get(i3) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getPrescriptionIds().get(i3) + "')");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getPreHospNames())) {
            sb.append(" and pmlm.presHospitalName in (");
            for (int i4 = 0; i4 < vo.getPreHospNames().size(); ++i4) {
                if (i4 != vo.getPreHospNames().size() - 1) {
                    sb.append("'" + (String)vo.getPreHospNames().get(i4) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getPreHospNames().get(i4) + "')");
            }
        }
        if (0L != (size1 = this.redisUtil.lGetListSize("INTEGRATE_MAIN_STATUS_DEL_LIST"))) {
            sb.append(" and pmlm.drugPrescriptionId not in ( ");
            List objects = this.redisUtil.lGet("INTEGRATE_MAIN_STATUS_DEL_LIST", 0L, size1);
            for (int i5 = 0; i5 < objects.size(); ++i5) {
                if (i5 != objects.size() - 1) {
                    sb.append("'" + objects.get(i5).toString() + "',");
                    continue;
                }
                sb.append("'" + objects.get(i5).toString() + "')");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPatientId())) {
            sb.append(" AND pmlm.patientId = '" + vo.getPatientId() + "' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchName())) {
            sb.append(" AND (pmlm.patientName like '" + vo.getSearchName() + "%' OR pmlm.salesOrder = '" + vo.getSearchName() + "') ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchSaleOrder())) {
            sb.append(" AND (pmlm.salesOrder LIKE '%" + vo.getSearchSaleOrder() + "%' OR pmlm.threeMainNo LIKE '%" + vo.getSearchSaleOrder() + "%') ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStoreName())) {
            sb.append(" AND pmlm.storeName LIKE '%" + vo.getStoreName() + "%' ");
        }
        if (Objects.nonNull(vo.getIsHistory()) && 1 == vo.getIsHistory()) {
            sb.append(" AND pmlm.presChannelId != '3' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInputMainStartTimeString())) {
            sb.append(" AND pmlm.createTime >= '" + vo.getInputMainStartTimeString() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInputMainEndTimeString())) {
            sb.append(" AND pmlm.createTime <= '" + vo.getInputMainEndTimeString() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchDrugName())) {
            sb.append(" AND pmlm.drugNames like '%" + vo.getSearchDrugName() + "%' ");
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getDrugIds())) {
            sb.append(" and (");
            for (int i6 = 0; i6 < vo.getDrugIds().size(); ++i6) {
                if (i6 != vo.getDrugIds().size() - 1) {
                    sb.append(" pmlm.drugIds LIKE '%" + (String)vo.getDrugIds().get(i6) + "%' or ");
                    continue;
                }
                sb.append(" pmlm.drugIds LIKE '%" + (String)vo.getDrugIds().get(i6) + "%') ");
            }
        }
        if (Objects.nonNull(vo.getMainStatus())) {
            int i7;
            sb.append(" AND (pmlm.mainStatus = " + vo.getMainStatus() + " ");
            long size = this.redisUtil.lGetListSize("INTEGRATE_MAIN_STATUS_STATUS:" + vo.getMainStatus().toString());
            if (0L != size) {
                sb.append(" AND pmlm.drugPrescriptionId not in ( ");
                List objects = this.redisUtil.lGet("INTEGRATE_MAIN_STATUS_STATUS:" + vo.getMainStatus().toString(), 0L, size);
                for (i7 = 0; i7 < objects.size(); ++i7) {
                    if (i7 != objects.size() - 1) {
                        sb.append("'" + objects.get(i7).toString() + "',");
                        continue;
                    }
                    sb.append("'" + objects.get(i7).toString() + "')");
                }
            }
            if (!CollectionUtils.isEmpty(userDataAuths)) {
                StringBuffer buffer = new StringBuffer();
                for (i7 = 0; i7 < userDataAuths.size(); ++i7) {
                    long size2 = this.redisUtil.lGetListSize("INTEGRATE_MAIN_STATUS_STATUS_AFTER:" + vo.getMainStatus().toString() + "###" + userDataAuths.get(i7).getId());
                    if (0L == size2) continue;
                    List objects = this.redisUtil.lGet("INTEGRATE_MAIN_STATUS_STATUS_AFTER:" + vo.getMainStatus().toString() + "###" + userDataAuths.get(i7).getId(), 0L, size2);
                    for (int j = 0; j < objects.size(); ++j) {
                        buffer.append("'" + objects.get(j).toString() + "',");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)buffer.toString())) {
                    String ids = buffer.toString();
                    sb.append(" OR pmlm.drugPrescriptionId in ( ");
                    sb.append(ids, 0, ids.length() - 1);
                    sb.append(" )");
                }
            }
            sb.append(" ) ");
        }
        sb.append(" order by pmlm.createTime desc");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Integer> getDrugMainStatusCount(Connection connection, List<UserDataAuthsVO> userDataAuths) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from ");
        sb.append("ps_drug_prescription pdpre where ");
        sb.append("pdpre.status = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdpre.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "') ");
            }
        }
        sb.append("and (pdpre.main_status = 10 or pdpre.main_status = 20 or pdpre.main_status = 40) ");
        Integer count = 0;
        Statement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryOrderListCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryOrderListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryPatientInfoCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    public List<GetMainListByManageResponseDto> dataPageFilter(List<GetMainListByManageResponseDto> list, GetMainListAppletRequestVO vo) {
        list = list.stream().sorted(Comparator.comparing(GetMainListByManageResponseDto::getCreateTime).reversed()).collect(Collectors.toList());
        ArrayList<GetMainListByManageResponseDto> listResult = new ArrayList<GetMainListByManageResponseDto>();
        int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
        int endIndex = list.size() < vo.getPageIndex() * vo.getPageSize() ? list.size() : vo.getPageIndex() * vo.getPageSize();
        for (int i = firstIndex; i < endIndex; ++i) {
            listResult.add((GetMainListByManageResponseDto)list.get(i));
        }
        return listResult;
    }
}

