/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.starrocks;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ebaiyihui.dto.DiseaseStatisticsListDto;
import com.ebaiyihui.dto.ProgramIndexStatisticsDTO;
import com.ebaiyihui.dto.StaffStatisticsListDto;
import com.ebaiyihui.dto.StoreStatisticsListDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisAmountDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisDrugDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisListQo;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisPersonDto;
import com.ebaiyihui.dto.salesAnalysis.SalesAnalysisStoreDto;
import com.ebaiyihui.utils.DateUtils;
import com.ebaiyihui.vo.DiseaseStatisticsVO;
import com.ebaiyihui.vo.ProgramIndexStatisticsVo;
import com.ebaiyihui.vo.StoreStatisticsVO;
import com.ebaiyihui.vo.UserDataAuthsVO;
import com.ebaiyihui.vo.statics.LsStandardMedicationPatientStaticsDto;
import com.ebaiyihui.vo.statics.LsStandardMedicationPatientStaticsQo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsDpVo;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsDto;
import com.ebaiyihui.vo.statics.LsStandardMedicationStaticsQo;
import com.ebaiyihui.vo.statics.PatientOrderStaticsDto;
import com.ebaiyihui.vo.statics.PatientOrderStaticsQo;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StarRocksStatisticsUtils {
    private static final Logger log = LoggerFactory.getLogger(StarRocksStatisticsUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<StaffStatisticsListDto>> getAsyncPatientStaffStatistics(Connection connection, List<UserDataAuthsVO> userDataAuths, StoreStatisticsVO vo) {
        int i;
        ArrayList<StaffStatisticsListDto> list = new ArrayList<StaffStatisticsListDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select sum(count1) as patientCountList,sum(count2) as addPatientCountList  from ( select         any_value(pps.store_name) storeName,         count(ppsr.patient_id) count1,         sum(case when ppi.create_time between '" + vo.getStartTime() + "' and '" + vo.getEndTime() + "' then 1 else 0 end) count2     from         ps_patient_store pps     inner join ps_patient_store_reg ppsr on         (pps.id = ppsr.store_id )         and ppsr.status = 1 and ppsr.patient_type=1  ");
        sb.append("    inner join ps_patient_split_info ppi on         (ppi.id = ppsr.patient_id )     inner join ps_account_info pai on         (ppi.archives_create_person = pai.id)         and pai.status = 1     inner join ps_user_role_reg purr on         (pai.id = purr.user_id)         and purr.status = 1     inner join ps_role_info pri on         (purr.role_id = pri.id)         and pri.status = 1     where         pps.status = 1 and ppsr.is_create_store = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pps.id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getStoreIds())) {
            sb.append(" and pps.id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchStaff())) {
            sb.append(" and pai.login_name LIKE '%" + vo.getSearchStaff() + "%' ");
        }
        sb.append("    group by         ppi.archives_create_person ");
        sb.append(") temp where 1=1 ");
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchContent())) {
            sb.append(" AND temp.storeName LIKE '%" + vo.getSearchContent() + "%' ");
        }
        sb.append(" order by ");
        if ("1".equals(vo.getSortAllPatient())) {
            sb.append(" patientCountList desc ");
        }
        if ("2".equals(vo.getSortAllPatient())) {
            sb.append(" patientCountList asc ");
        }
        if ("1".equals(vo.getAddSortAllPatient())) {
            sb.append(" addPatientCountList desc ");
        }
        if ("2".equals(vo.getAddSortAllPatient())) {
            sb.append(" addPatientCountList asc ");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                StaffStatisticsListDto dto = new StaffStatisticsListDto();
                int patientCountList = rs.getInt("patientCountList");
                int addPatientCountList = rs.getInt("addPatientCountList");
                dto.setPatientCountList(Integer.valueOf(patientCountList));
                dto.setAddPatientCountList(Integer.valueOf(addPatientCountList));
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getAsyncPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getAsyncPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getAsyncPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<StaffStatisticsListDto>> getPatientStaffStatistics(Connection connection, List<UserDataAuthsVO> userDataAuths, StoreStatisticsVO vo) {
        ArrayList<StaffStatisticsListDto> list = new ArrayList<StaffStatisticsListDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPatientStaffStatisticsData(userDataAuths, vo));
        int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
        sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                StaffStatisticsListDto dto = new StaffStatisticsListDto();
                String staffName = rs.getString("staffName");
                String storeName = rs.getString("storeName");
                String role = rs.getString("role");
                int patientCountList = rs.getInt("patientCountList");
                int addPatientCountList = rs.getInt("addPatientCountList");
                dto.setStaffName(staffName);
                dto.setStoreName(storeName);
                dto.setRole(role);
                dto.setPatientCountList(Integer.valueOf(patientCountList));
                dto.setAddPatientCountList(Integer.valueOf(addPatientCountList));
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getPatientStaffStatisticsData(List<UserDataAuthsVO> userDataAuths, StoreStatisticsVO vo) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(" select * from ( select         any_value(pai.login_name) staffName,         any_value(pps.store_name) storeName,         any_value(pri.role_name) role,         count(ppsr.patient_id) patientCountList,         sum(case when ppi.create_time between '" + vo.getStartTime() + "' and '" + vo.getEndTime() + "' then 1 else 0 end) addPatientCountList     from         ps_patient_store pps     inner join ps_patient_store_reg ppsr on         (pps.id = ppsr.store_id )         and ppsr.status = 1 and ppsr.patient_type=1 ");
        sb.append("    inner join ps_patient_split_info ppi on         (ppi.id = ppsr.patient_id )     inner join ps_account_info pai on         (ppi.archives_create_person = pai.id)         and pai.status = 1     inner join ps_user_role_reg purr on         (pai.id = purr.user_id)         and purr.status = 1     inner join ps_role_info pri on         (purr.role_id = pri.id)         and pri.status = 1     where         pps.status = 1 and ppsr.is_create_store = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pps.id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getStoreIds())) {
            sb.append(" and pps.id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchStaff())) {
            sb.append(" and pai.login_name LIKE '%" + vo.getSearchStaff() + "%' ");
        }
        sb.append("    group by         ppi.archives_create_person ");
        sb.append(") temp where 1=1 ");
        if (StringUtils.isNotEmpty((CharSequence)vo.getSearchContent())) {
            sb.append(" AND temp.storeName LIKE '%" + vo.getSearchContent() + "%' ");
        }
        sb.append(" order by ");
        if ("1".equals(vo.getSortAllPatient())) {
            sb.append(" patientCountList desc ");
        }
        if ("2".equals(vo.getSortAllPatient())) {
            sb.append(" patientCountList asc ");
        }
        if ("1".equals(vo.getAddSortAllPatient())) {
            sb.append(" addPatientCountList desc ");
        }
        if ("2".equals(vo.getAddSortAllPatient())) {
            sb.append(" addPatientCountList asc ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Integer> getPatientStaffStatisticsCount(Connection connection, List<UserDataAuthsVO> userDataAuths, StoreStatisticsVO vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) cou from (");
        sb.append(this.getPatientStaffStatisticsData(userDataAuths, vo));
        sb.append(" ) temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<ProgramIndexStatisticsDTO> programIndexStatistics(Connection connection, ProgramIndexStatisticsVo vo) {
        ProgramIndexStatisticsDTO dto = new ProgramIndexStatisticsDTO();
        Statement ps = null;
        ResultSet rs = null;
        try {
            long start = System.currentTimeMillis();
            StringBuffer sb = new StringBuffer();
            sb.append(this.getProgramIndexStatisticsNewPatientCount(vo));
            String querySql = sb.toString();
            log.info("\u67e5\u8be2user:{}\u7684\u65b0\u589e\u60a3\u8005\u6570", (Object)vo.getUserId());
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer newPatientCount = rs.getInt("newPatientCount");
                dto.setNewPatientCount(this.getTenThousandOfANumber(newPatientCount));
            }
            log.info("\u6267\u884c\u65b0\u589e\u60a3\u8005\u6570\u67e5\u8be2\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            sb = new StringBuffer();
            sb.append(this.getProgramIndexStatisticsNewPresCount(vo));
            querySql = sb.toString();
            log.info("\u67e5\u8be2user:{}\u7684\u5f55\u5165\u5904\u65b9\u6570", (Object)vo.getUserId());
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer newPresCount = rs.getInt("newPresCount");
                dto.setNewPresCount(this.getTenThousandOfANumber(newPresCount));
            }
            log.info("\u6267\u884c\u5f55\u5165\u5904\u65b9\u6570\u67e5\u8be2\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            sb = new StringBuffer();
            sb.append(this.getProgramIndexStatisticsPatientMedicineCount(vo));
            querySql = sb.toString();
            log.info("\u67e5\u8be2user:{}\u7684\u5b8c\u5584DTP\u836f\u5386\u4eba\u6570", (Object)vo.getUserId());
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer patientMedicineCount = rs.getInt("patientMedicineCount");
                dto.setPatientMedicineCount(this.getTenThousandOfANumber(patientMedicineCount));
            }
            log.info("\u6267\u884c\u5b8c\u5584DTP\u836f\u5386\u4eba\u6570\u67e5\u8be2\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            sb = new StringBuffer();
            sb.append(this.getProgramIndexStatisticsPatientMedicalArchivesCount(vo));
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            ArrayList<String> mbPatients = new ArrayList<String>();
            while (rs.next()) {
                mbPatients.add(rs.getString("patientId"));
            }
            dto.setPatientMedicalArchivesIds(mbPatients);
            dto.setPatientMedicalArchivesCount(this.getTenThousandOfANumber(Integer.valueOf(mbPatients.size())));
            log.info("\u6267\u884c\u6162\u75c5\u5efa\u6863\u60a3\u8005\u4eba\u6570\u67e5\u8be2\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            sb = new StringBuffer();
            sb.append(this.getPatientMztcCount(vo));
            querySql = sb.toString();
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            ArrayList<String> mztcPatients = new ArrayList<String>();
            while (rs.next()) {
                mztcPatients.add(rs.getString("patientId"));
            }
            dto.setPatientMztcIds(mztcPatients);
            dto.setPatientMztcCount(this.getTenThousandOfANumber(Integer.valueOf(mztcPatients.size())));
            log.info("\u6267\u884c\u95e8\u8bca\u7edf\u7b79\u5efa\u6863\u4eba\u6570\u67e5\u8be2\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            sb = new StringBuffer();
            sb.append(this.getProgramIndexStatisticsCheckCount(vo));
            querySql = sb.toString();
            log.info("\u67e5\u8be2user:{}\u7684\u5065\u5eb7\u68c0\u6d4b\u6b21\u6570\u548c\u5f02\u5e38", (Object)vo.getUserId());
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer checkCount = rs.getInt("checkCount");
                dto.setCheckCount(this.getTenThousandOfANumber(checkCount));
                Integer checkAnomalyCount = rs.getInt("checkAnomalyCount");
                dto.setCheckAnomalyCount(this.getTenThousandOfANumber(checkAnomalyCount));
            }
            log.info("\u6267\u884c\u5065\u5eb7\u68c0\u6d4b\u6b21\u6570\u548c\u5f02\u5e38\u6b21\u6570\u67e5\u8be2\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            sb = new StringBuffer();
            sb.append(this.getProgramIndexStatisticsVisitCount(vo));
            querySql = sb.toString();
            log.info("\u67e5\u8be2user:{}\u7684\u6162\u75c5\u56de\u8bbf\u6b21\u6570\u548c\u5b8c\u6210\u6570\u548cDTP\u7528\u836f\u56de\u8bbf\u6b21\u6570\u548c\u5b8c\u6210\u6570", (Object)vo.getUserId());
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                Integer chronicVisitCount = rs.getInt("chronicVisitCount");
                dto.setChronicVisitCount(this.getTenThousandOfANumber(chronicVisitCount));
                Integer chronicVisitDoneCount = rs.getInt("chronicVisitDoneCount");
                dto.setChronicVisitDoneCount(this.getTenThousandOfANumber(chronicVisitDoneCount));
                Integer dtpMedicineVisitCount = rs.getInt("dtpMedicineVisitCount");
                dto.setDtpMedicineVisitCount(this.getTenThousandOfANumber(dtpMedicineVisitCount));
                Integer dtpMedicineVisitDoneCount = rs.getInt("dtpMedicineVisitDoneCount");
                dto.setDtpMedicineVisitDoneCount(this.getTenThousandOfANumber(dtpMedicineVisitDoneCount));
            }
            log.info("\u6267\u884c\u6162\u75c5\u56de\u8bbf\u6b21\u6570\u548c\u5b8c\u6210\u6570\u548cDTP\u7528\u836f\u56de\u8bbf\u6b21\u6570\u548c\u5b8c\u6210\u6570\u67e5\u8be2\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils programIndexStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils programIndexStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils programIndexStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)dto);
    }

    private String getProgramIndexStatisticsNewPatientCount(ProgramIndexStatisticsVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select         sum(case when ppi.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "' then 1 else 0 end) newPatientCount     from         ps_patient_store_reg ppsr     inner join ps_patient_split_info ppi on         (ppi.id = ppsr.patient_id  and ppsr.patient_type=1 )     inner join ps_account_info pai on         (ppi.archives_create_person = pai.id)         and pai.status = 1     where         ppsr.status = 1  and ppsr.is_create_store = 1 and pai.id = '" + vo.getUserId() + "'");
        return sb.toString();
    }

    private String getProgramIndexStatisticsNewPresCount(ProgramIndexStatisticsVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select         count(1) newPresCount     from         ps_drug_prescription dp     where         dp.status = 1 and dp.prescription_input_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'        and dp.create_person = '" + vo.getUserId() + "'");
        return sb.toString();
    }

    private String getProgramIndexStatisticsPatientMedicineCount(ProgramIndexStatisticsVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(1) patientMedicineCount         FROM (SELECT patient_id, COUNT(1)               FROM (SELECT tmp1.patient_id, tmp1.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_currency_diagnosis ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp1 ON pi.id = tmp1.patient_id                     UNION                     SELECT tmp2.patient_id, tmp2.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_drugs_healthy ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp2 ON pi.id = tmp2.patient_id                     UNION                     SELECT tmp3.patient_id, tmp3.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_evaluation ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp3 ON pi.id = tmp3.patient_id                     UNION                     SELECT tmp4.patient_id, tmp4.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_experience ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp4 ON pi.id = tmp4.patient_id                     UNION                     SELECT tmp5.patient_id, tmp5.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_followup ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp5 ON pi.id = tmp5.patient_id                     UNION                     SELECT tmp6.patient_id, tmp6.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_images ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp6 ON pi.id = tmp6.patient_id                     UNION                     SELECT tmp7.patient_id, tmp7.create_time                     FROM ps_patient_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_stage ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp7 ON pi.id = tmp7.patient_id                     UNION                     SELECT tmp8.patient_id, tmp8.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_treatment ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1) tmp8 ON pi.id = tmp8.patient_id                     UNION                     SELECT tmp9.patient_id, tmp9.create_time                     FROM ps_patient_split_info pi                              INNER JOIN (SELECT ps.patient_id, ps.create_time                                          FROM ps_condition_tumour_diagnosis ps                                          INNER JOIN ps_account_info pai ON pai.login_name = ps.create_person                                          WHERE ps.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'                                          AND pai.id = '" + vo.getUserId() + "'                                          AND ps.status = 1   ) tmp9 ON pi.id = tmp9.patient_id) tmp               GROUP BY tmp.patient_id) tm                  INNER JOIN ps_patient_store_reg psr on psr.patient_id = tm.patient_id and psr.status = 1");
        return sb.toString();
    }

    private String getProgramIndexStatisticsPatientMedicalArchivesCount(ProgramIndexStatisticsVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT   patient_id patientId FROM   ps_patient_health_records pphr   INNER JOIN ps_account_info pai ON pai.login_name = pphr.archives_create_person   LEFT JOIN ps_patient_store pps ON pps.id = pai.store_id WHERE   pphr.`status` = 1   and pphr.archives_create_person is not null   and pps.`status` = 1   and pphr.patient_id in (SELECT DISTINCT(par.patient_id) patient_id from ps_patient_disease_parameter par where par.STATUS = 1 )  and pphr.archives_create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'    and pai.id = '" + vo.getUserId() + "'");
        return sb.toString();
    }

    private String getPatientMztcCount(ProgramIndexStatisticsVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select        DISTINCT(ppmi.patient_id) patientId     from         ps_patient_medical_insurance ppmi     where         ppmi.status = 1 and ppmi.create_time between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'        and ppmi.archives_create_person = '" + vo.getUserId() + "'");
        return sb.toString();
    }

    private String getProgramIndexStatisticsCheckCount(ProgramIndexStatisticsVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT   count( ptpd.id ) AS checkCount,   sum( ptpd.exception_flag -1 ) checkAnomalyCount FROM  ps_threshold_patient_data ptpd  LEFT JOIN ps_patient_store pps ON ptpd.store_id = pps.id WHERE  ptpd.STATUS = 1  AND pps.status=1  AND DATE_FORMAT(ptpd.quota_day, '%Y-%m-%d %H:%i:%s') between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "'  AND ptpd.create_person = '" + vo.getUserId() + "'");
        return sb.toString();
    }

    private String getProgramIndexStatisticsVisitCount(ProgramIndexStatisticsVo vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT  SUM(case when ppft.build_type in (6, 7, 10) THEN 1 ELSE 0 END) chronicVisitCount,  SUM(case when ppft.follow_status = 4 and ppft.build_type in (6, 7, 10) THEN 1 ELSE 0 END) chronicVisitDoneCount,  SUM(case when ppft.build_type in (1, 2, 3, 4) THEN 1 ELSE 0 END) dtpMedicineVisitCount,  SUM(case when ppft.follow_status = 4 and ppft.build_type in (1, 2, 3, 4) THEN 1 ELSE 0 END) dtpMedicineVisitDoneCount FROM ps_patient_follow_task ppft WHERE ppft.status = 1  and ppft.follow_status in (2, 3, 4)  AND ppft.visit_person = '" + vo.getUserId() + "'  AND ppft.visit_starttime between '" + vo.getStartDate() + "' and '" + vo.getEndDate() + "' ");
        return sb.toString();
    }

    private String getTenThousandOfANumber(Integer num) {
        if (Objects.isNull(num)) {
            return "0";
        }
        if (num < 10000) {
            return String.valueOf(num);
        }
        String numStr = new DecimalFormat("#.00").format((double)num.intValue() / 10000.0);
        String[] ss = numStr.split("\\.");
        if ("00".equals(ss[1])) {
            return ss[0] + "\u4e07";
        }
        if ('0' == ss[1].charAt(1)) {
            return ss[0] + "." + ss[1].charAt(0) + "\u4e07";
        }
        return numStr + "\u4e07";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<List<StoreStatisticsListDto>> getPatientStoreStatistics(Connection connection, List<UserDataAuthsVO> userDataAuths, StoreStatisticsVO vo, Boolean isPage) {
        ArrayList<StoreStatisticsListDto> list = new ArrayList<StoreStatisticsListDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPatientStoreStatisticsData(userDataAuths, vo));
        int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
        if (isPage.booleanValue()) {
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                StoreStatisticsListDto dto = new StoreStatisticsListDto();
                String storeName = rs.getString("storeName");
                String storeCode = rs.getString("storeCode");
                String province = rs.getString("province");
                String city = rs.getString("city");
                String district = rs.getString("district");
                int patientCountList = rs.getInt("patientCountList");
                int addPatientCountList = rs.getInt("addPatientCountList");
                dto.setStoreName(storeName);
                dto.setStoreCode(storeCode);
                dto.setProvince(province);
                dto.setCity(city);
                dto.setDistrict(district);
                dto.setPatientCountList(Integer.valueOf(patientCountList));
                dto.setAddPatientCountList(Integer.valueOf(addPatientCountList));
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public Future<Integer> getPatientStoreStatisticsCount(Connection connection, List<UserDataAuthsVO> userDataAuths, StoreStatisticsVO vo) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("  select         count(temp.id) cou     from         (         select             ppi.id id         from             ps_patient_split_info ppi         inner join ps_patient_store_reg ppsr on             ppsr.patient_id = ppi.id and ppsr.patient_type=1        and ppsr.is_create_store=1 and ppsr.`status` = 1");
        sb.append("  where ppi.status = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and ppsr.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'").append(userDataAuths.get(i).getId()).append("',");
                    continue;
                }
                sb.append("'").append(userDataAuths.get(i).getId()).append("')");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getStoreIds())) {
            sb.append(" and ppsr.store_id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getSearchContent())) {
            sb.append(" AND (pps.store_name LIKE '%" + vo.getSearchContent() + "'%        or pps.store_code LIKE '%" + vo.getSearchContent() + "'%'        )");
        }
        sb.append(" group by             ppi.id) temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private String getPatientStoreStatisticsData(List<UserDataAuthsVO> userDataAuths, StoreStatisticsVO vo) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("select         any_value(pps.store_name) storeName,        any_value(pps.store_code) storeCode,        any_value(pps.province) province,        any_value(pps.city) city,        any_value(pps.district) district,        count( DISTINCT ppsr.patient_id) patientCountList,        sum(case when ppsr.create_time between '" + vo.getStartTime() + "' and '" + vo.getEndTime() + "' then 1 else 0 end) addPatientCountList FROM  ps_patient_split_info ppi   LEFT JOIN ps_patient_store_reg ppsr ON ( ppi.id = ppsr.patient_id )   AND ppsr.STATUS = 1  LEFT  JOIN ps_patient_store pps ON pps.id = ppsr.store_id and  pps.STATUS = 1 ");
        sb.append("    where      ppsr.is_create_store = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and ppsr.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getStoreIds())) {
            sb.append(" and pps.id in (");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getSearchContent())) {
            sb.append(" AND (pps.store_name LIKE '%" + vo.getSearchContent() + "'%        or pps.store_code LIKE '%" + vo.getSearchContent() + "'%'        )");
        }
        sb.append(" group by         pps.id");
        sb.append(" order by ");
        if ("1".equals(vo.getSortAllPatient())) {
            sb.append(" patientCountList desc ");
        }
        if ("2".equals(vo.getSortAllPatient())) {
            sb.append(" patientCountList asc ");
        }
        if ("1".equals(vo.getAddSortAllPatient())) {
            sb.append(" addPatientCountList desc ");
        }
        if ("2".equals(vo.getAddSortAllPatient())) {
            sb.append(" addPatientCountList asc ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<DiseaseStatisticsListDto>> getPatientDiseaseStatistics(Connection connection, List<UserDataAuthsVO> userDataAuths, DiseaseStatisticsVO vo) {
        ArrayList<DiseaseStatisticsListDto> list = new ArrayList<DiseaseStatisticsListDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPatientDiseaseStatisticsData(userDataAuths, vo));
        int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
        sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                DiseaseStatisticsListDto dto = new DiseaseStatisticsListDto();
                String diseaseName = rs.getString("diseaseName");
                int patientCountList = rs.getInt("patientCountList");
                dto.setDiseaseName(diseaseName);
                dto.setPatientCountList(Integer.valueOf(patientCountList));
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> getPatientDiseaseCount(Connection connection, List<UserDataAuthsVO> userDataAuths, DiseaseStatisticsVO vo) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT COUNT(1) as cou FROM (");
        sb.append(this.getPatientDiseaseStatisticsData(userDataAuths, vo));
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private String getPatientDiseaseStatisticsData(List<UserDataAuthsVO> userDataAuths, DiseaseStatisticsVO vo) {
        StringBuffer sb = new StringBuffer();
        sb.append("select         any_value(pii.icd_name) diseaseName,        count(ppi.id) patientCountList    from        ps_patient_split_info ppi    inner join ps_patient_icd_reg ppir on        (ppi.id = ppir.patient_id)        and ppir.status = 1 and ppir.patient_type=1    inner join ps_icd_item pii on        (ppir.icd_id = pii.icd_code)        and pii.status = 1    INNER JOIN ps_patient_store_reg PPSR ON PPSR.patient_id = ppi.id AND PPSR.`status` = 1  and PPSR.patient_type=1   where 1=1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and PPSR.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getSearchContent())) {
            sb.append(" AND pii.icd_name LIKE '%" + vo.getSearchContent() + "%' ");
        }
        sb.append("    group by         pii.id order by  ");
        if ("1".equals(vo.getSortAllPatient())) {
            sb.append("  patientCountList desc ");
        }
        if ("2".equals(vo.getSortAllPatient())) {
            sb.append("  patientCountList asc ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<SalesAnalysisDrugDto>> querySalesAnalysisDrugList(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, Boolean isPage) {
        ArrayList<SalesAnalysisDrugDto> list = new ArrayList<SalesAnalysisDrugDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSalesAnalysisDrugListData(userDataAuths, vo));
        if (isPage.booleanValue()) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                SalesAnalysisDrugDto dto = new SalesAnalysisDrugDto();
                String drugId = rs.getString("drugId");
                String drugCode = rs.getString("drugCode");
                String drugName = rs.getString("drugName");
                String drugSpec = rs.getString("drugSpec");
                String manufacturer = rs.getString("manufacturer");
                int saleCount = rs.getInt("saleCount");
                int salePersonCount = rs.getInt("salePersonCount");
                int saleOrderCount = rs.getInt("saleOrderCount");
                dto.setDrugId(drugId);
                dto.setDrugCode(drugCode);
                dto.setDrugName(drugName);
                dto.setDrugSpec(drugSpec);
                dto.setManufacturer(manufacturer);
                dto.setSaleCount(Integer.valueOf(saleCount));
                dto.setSalePersonCount(Integer.valueOf(salePersonCount));
                dto.setSaleOrderCount(Integer.valueOf(saleOrderCount));
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getSalesAnalysisDrugListData(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo) {
        StringBuilder sb = new StringBuilder();
        this.isSaleDrugConditionSql(userDataAuths, vo, sb);
        return sb.toString();
    }

    private void isSaleDrugConditionSql(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, StringBuilder sb) {
        int i;
        sb.append("SELECT any_value ( pdi.id ) AS drugId,  any_value ( pdi.product_code ) AS drugCode,  any_value ( pdi.product_name ) AS drugName,  any_value ( pdi.drug_spec ) AS drugSpec,  any_value ( pdi.manufacturer ) AS manufacturer,  cast(  SUM( pdpd.amount ) AS DECIMAL ( 32, 2 )) AS saleCount,  COUNT( DISTINCT pdo.patient_id ) AS salePersonCount,  COUNT( DISTINCT pdo.id ) AS saleOrderCount   FROM  ps_drug_order pdo  INNER JOIN ps_drug_prescription_detail pdpd ON pdo.id = pdpd.order_id  INNER JOIN ps_drug_item pdi ON pdi.id = pdpd.drug_id  WHERE  pdo.`status` = 1   AND pdpd.`status` = 1   AND pdi.`status` = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (int i2 = 0; i2 < userDataAuths.size(); ++i2) {
                if (i2 != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i2).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i2).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBuyStartTime()) && ObjectUtil.isNotEmpty((Object)vo.getBuyEndTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getBuyStartTime() + "'and pdo.create_time<= '" + vo.getBuyEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getBuyStartTime() + "'and pdo.pay_time<= '" + vo.getBuyEndTime() + "'))");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getSaleStoreId())) {
            sb.append("and pdo.store_id in (");
            String[] split = vo.getSaleStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getDrugInfo())) {
            sb.append("and pdi.id in (");
            String[] split = vo.getDrugInfo().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        sb.append("  GROUP BY pdi.id");
        sb.append(" order by ");
        if ("1".equals(vo.getSortSaleCount())) {
            sb.append("   SUM( pdpd.amount ) desc");
        } else if ("2".equals(vo.getSortSaleCount())) {
            sb.append("   SUM( pdpd.amount ) asc");
        } else if ("1".equals(vo.getSortSaleOrderCount())) {
            sb.append(" COUNT( DISTINCT pdo.id ) desc");
        } else if ("2".equals(vo.getSortSaleOrderCount())) {
            sb.append(" COUNT( DISTINCT pdo.id ) asc");
        } else if ("1".equals(vo.getSortSalePersonCount())) {
            sb.append(" COUNT( DISTINCT pdo.patient_id ) desc");
        } else if ("2".equals(vo.getSortSalePersonCount())) {
            sb.append(" COUNT( DISTINCT pdo.patient_id ) asc");
        } else {
            sb.append("   SUM( pdpd.amount ) desc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> querySalesAnalysisDrugListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo) {
        StringBuilder sb = new StringBuilder();
        this.isSaleDrugCountCondition(userDataAuths, vo, sb);
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private void isSaleDrugCountCondition(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, StringBuilder sb) {
        int i;
        sb.append(" SELECT COUNT(1) as cou FROM ( select any_value ( pdi.product_code ) AS drugCode,  any_value ( pdi.product_name ) AS drugName,  any_value ( pdi.drug_spec ) AS drugSpec,  any_value ( pdi.manufacturer ) AS manufacturer,  cast(  SUM( pdpd.amount ) AS DECIMAL ( 32, 2 )) AS saleCount,  COUNT( DISTINCT pdo.patient_id ) AS salePersonCount,  COUNT( DISTINCT pdo.id ) AS saleOrderCount   FROM  ps_drug_order pdo  INNER JOIN ps_drug_prescription_detail pdpd ON pdo.id = pdpd.order_id  INNER JOIN ps_drug_item pdi ON pdi.id = pdpd.drug_id  WHERE  pdo.`status` = 1   AND pdpd.`status` = 1   AND pdi.`status` = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (int i2 = 0; i2 < userDataAuths.size(); ++i2) {
                if (i2 != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i2).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i2).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBuyStartTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getBuyStartTime() + "'and pdo.create_time<= '" + vo.getBuyEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getBuyStartTime() + "'and pdo.pay_time<= '" + vo.getBuyEndTime() + "'))");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getSaleStoreId())) {
            sb.append("and pdo.store_id in (");
            String[] split = vo.getSaleStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getDrugInfo())) {
            sb.append("and pdi.id in (");
            String[] split = vo.getDrugInfo().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        sb.append(" GROUP BY pdi.id");
        sb.append(") temp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<SalesAnalysisPersonDto>> querySalesAnalysisPersonByDrug(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, Boolean isPage) {
        ArrayList<SalesAnalysisPersonDto> list = new ArrayList<SalesAnalysisPersonDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSalesAnalysisPersonByDrugData(userDataAuths, vo));
        if (isPage.booleanValue()) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                SalesAnalysisPersonDto dto = new SalesAnalysisPersonDto();
                String patientInfoId = rs.getString("patientInfoId");
                dto.setPatientInfoId(patientInfoId);
                String patientBirthday = rs.getString("patientBirthday");
                dto.setPatientBirthday(patientBirthday);
                String idCard = rs.getString("idCard");
                dto.setIdCard(idCard);
                String patientSex = rs.getString("patientSex");
                dto.setPatientSex(patientSex);
                String patientName = rs.getString("patientName");
                dto.setPatientName(patientName);
                String mobile = rs.getString("mobile");
                dto.setMobile(mobile);
                String patientNo = rs.getString("patientNo");
                dto.setPatientNo(patientNo);
                String icd = rs.getString("icd");
                dto.setIcd(icd);
                String openStoreName = rs.getString("openStoreName");
                dto.setOpenStoreName(openStoreName);
                String openStoreCode = rs.getString("openStoreCode");
                dto.setOpenStoreCode(openStoreCode);
                String accountName = rs.getString("accountName");
                dto.setAccountName(accountName);
                String accountNo = rs.getString("accountNo");
                dto.setAccountNo(accountNo);
                String orderTotalAmount = rs.getString("orderTotalAmount");
                dto.setOrderTotalAmount(orderTotalAmount);
                String orderNo = rs.getString("orderNo");
                dto.setOrderNo(orderNo);
                String saleStoreName = rs.getString("saleStoreName");
                dto.setSaleStoreName(saleStoreName);
                String saleStoreNo = rs.getString("saleStoreNo");
                dto.setSaleStoreNo(saleStoreNo);
                String orderBuyTime = rs.getString("orderBuyTime");
                dto.setOrderBuyTime(orderBuyTime);
                String orderAmount = rs.getString("orderAmount");
                dto.setOrderAmount(orderAmount);
                String drugInfo = rs.getString("drugInfo");
                dto.setDrugInfo(drugInfo);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getSalesAnalysisPersonByDrugData(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT  any_value ( ppi.id ) as patientInfoId,  any_value ( ppi.patient_birthday ) as patientBirthday,  any_value ( ppi.patient_id_card ) as idCard,  any_value ( (case when ppi.patient_sex=1 then '\u7537'   when ppi.patient_sex=2 then '\u5973' else '' end  ))  as patientSex,  any_value ( ppi.patient_name ) as patientName,  any_value ( ppi.patient_phone ) as mobile,  any_value ( ppi.patient_member_no ) as patientNo,  any_value ( t3.icdNames ) as icd,  any_value ( pps.store_name ) as openStoreName,  any_value ( pps.store_code ) as openStoreCode,  any_value ( pai.login_name ) as accountName,  any_value ( pai.empl_no ) as accountNo,  cast(  sum( t1.`order_amount` ) AS DECIMAL ( 32, 2 )) AS orderTotalAmount,  array_join ( array_sortby ( array_agg ( t1.order_seq ), array_agg ( t1.create_time )), '@' ) AS orderNo,  array_join ( array_sortby ( array_agg ( t1.`store_name` ), array_agg ( t1.create_time )), '@' ) AS saleStoreName,  array_join ( array_sortby ( array_agg ( t1.`store_code` ), array_agg ( t1.create_time )), '@' ) AS saleStoreNo,  array_join ( array_sortby ( array_agg ( t1.orderBuyTime ), array_agg ( t1.create_time )), '@' ) AS orderBuyTime,  array_join ( array_sortby ( array_agg ( CAST( t1.`order_amount` AS string ) ), array_agg ( t1.create_time )), '@' ) AS orderAmount,  array_join ( array_sortby ( array_agg ( t1.drugInfo ), array_agg ( t1.create_time )), '@' ) AS drugInfo   FROM  ps_patient_info ppi  INNER JOIN (  SELECT   pdo.id,   GROUP_CONCAT( t1.drugInfo ) AS drugInfo,   any_value ( pdo.order_seq ) AS order_seq,   any_value ( pdo.order_amount ) AS order_amount,   any_value (   IFNULL( pdo.pay_time, pdo.create_time )) AS orderBuyTime,   any_value ( pdo.create_time ) AS create_time,   any_value ( pps.store_name ) AS store_name,   any_value ( pps.store_code ) AS store_code,   any_value ( pdo.patient_id ) AS patient_id,   any_value ( pdo.id ) AS orderId,    any_value ( pdo.store_id ) AS store_id    FROM   ps_drug_order pdo   left JOIN ( SELECT pdpd.order_id, CONCAT_WS( '*', pdpd.drug_name, cast(pdpd.amount as DECIMAL(10,2)) ) AS drugInfo FROM ps_drug_prescription_detail pdpd WHERE pdpd.`status` = 1 ) t1 ON pdo.id = t1.order_id   left JOIN ps_patient_store pps ON pdo.store_id = pps.id    WHERE   pdo.`status` = 1    AND pps.`status` = 1   GROUP BY   pdo.id   ) t1 ON ppi.id = t1.patient_id  LEFT JOIN(  SELECT ppi.id,GROUP_CONCAT(pii.icd_name) as icdNames FROM ps_patient_info ppi  LEFT JOIN ps_patient_icd_reg ppir on ppi.id=ppir.patient_id  LEFT JOIN ps_icd_item pii on pii.id=ppir.icd_id  WHERE ppi.`status`=1 and ppir.`status`=1 and pii.`status`=1  ");
        sb.append(" GROUP BY ppi.id  ) t3 on t3.id=ppi.id  LEFT JOIN ps_patient_store_reg ppsr ON ppsr.patient_id = ppi.id   AND ppsr.is_create_store = 1  LEFT JOIN ps_patient_store pps ON pps.id = ppsr.store_id  LEFT JOIN ps_account_info pai ON pai.login_name = ppi.archives_create_person   WHERE  ppi.`status` = 1  ");
        if (vo.getQuerySalesType().equals("1")) {
            sb.append(" AND t1.orderId IN ( SELECT pdo.id FROM ps_drug_order pdo INNER JOIN ps_drug_prescription_detail pdpd ON pdpd.order_id = pdo.id AND pdpd.drug_id = '" + vo.getDrugConditionId() + "' ) ");
        } else {
            sb.append(" AND t1.orderId IN ( SELECT pdo.id FROM ps_drug_order pdo WHERE pdo.store_id = '" + vo.getStoreConditionId() + "' ) ");
        }
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and t1.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getIcdId())) {
            sb.append(" and ppi.id in ( ");
            sb.append("            SELECT ppi.id              FROM ps_patient_info ppi              LEFT JOIN ps_patient_icd_reg ppir on ppi.id=ppir.patient_id                LEFT JOIN ps_icd_item pii on pii.id=ppir.icd_id               WHERE ppi.`status`=1 and ppir.`status`=1 and pii.`status`=1  ");
            sb.append("and pii.id in (");
            String[] split = vo.getIcdId().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
            sb.append("                 GROUP BY ppi.id) ");
        }
        sb.append(" GROUP BY ppi.id");
        sb.append(" order by ppi.id ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> querySalesAnalysisPersonByDrugCount(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT COUNT(1) as cou FROM ( select any_value ( ppi.id ),  any_value ( ppi.patient_birthday ) as patientBirthday,  any_value ( ppi.patient_id_card ) as idCard,  any_value ( (case when ppi.patient_sex=1 then '\u7537'   when ppi.patient_sex=2 then '\u5973' else '' end  ))  as patientSex,  any_value ( ppi.patient_name ) as patientName,  any_value ( ppi.patient_phone ) as mobile,  any_value ( ppi.patient_member_no ) as patientNo,  any_value ( t3.icdNames ) as icd,  any_value ( pps.store_name ) as openStoreName,  any_value ( pps.store_code ) as openStoreCode,  any_value ( pai.login_name ) as accountName,  any_value ( pai.empl_no ) as accountNo,  cast(  sum( t1.`order_amount` ) AS DECIMAL ( 32, 2 )) AS orderTotalAmount,  array_join ( array_sortby ( array_agg ( t1.order_seq ), array_agg ( t1.create_time )), '@' ) AS orderNo,  array_join ( array_sortby ( array_agg ( t1.`store_name` ), array_agg ( t1.create_time )), '@' ) AS saleStoreName,  array_join ( array_sortby ( array_agg ( t1.`store_code` ), array_agg ( t1.create_time )), '@' ) AS saleStoreNo,  array_join ( array_sortby ( array_agg ( t1.orderBuyTime ), array_agg ( t1.create_time )), '@' ) AS orderBuyTime,  array_join ( array_sortby ( array_agg ( CAST( t1.`order_amount` AS string ) ), array_agg ( t1.create_time )), '@' ) AS orderAmount,  array_join ( array_sortby ( array_agg ( t1.drugInfo ), array_agg ( t1.create_time )), '@' ) AS drugInfo   FROM  ps_patient_info ppi  INNER JOIN (  SELECT   pdo.id,   GROUP_CONCAT( t1.drugInfo ) AS drugInfo,   any_value ( pdo.order_seq ) AS order_seq,   any_value ( pdo.order_amount ) AS order_amount,   any_value (   IFNULL( pdo.pay_time, pdo.create_time )) AS orderBuyTime,   any_value ( pdo.create_time ) AS create_time,   any_value ( pps.store_name ) AS store_name,   any_value ( pps.store_code ) AS store_code,   any_value ( pdo.patient_id ) AS patient_id,   any_value ( pdo.id ) AS orderId,   any_value ( pdo.store_id ) AS store_id    FROM   ps_drug_order pdo   left JOIN ( SELECT pdpd.order_id, CONCAT_WS( '*', pdpd.drug_name, cast(pdpd.amount as DECIMAL(10,2)) ) AS drugInfo FROM ps_drug_prescription_detail pdpd WHERE pdpd.`status` = 1 ) t1 ON pdo.id = t1.order_id   left JOIN ps_patient_store pps ON pdo.store_id = pps.id    WHERE   pdo.`status` = 1    AND pps.`status` = 1   GROUP BY   pdo.id   ) t1 ON ppi.id = t1.patient_id  LEFT JOIN(  SELECT ppi.id,GROUP_CONCAT(pii.icd_name) as icdNames FROM ps_patient_info ppi  LEFT JOIN ps_patient_icd_reg ppir on ppi.id=ppir.patient_id  LEFT JOIN ps_icd_item pii on pii.id=ppir.icd_id  WHERE ppi.`status`=1 and ppir.`status`=1 and pii.`status`=1  ");
        sb.append(" GROUP BY ppi.id  ) t3 on t3.id=ppi.id  LEFT JOIN ps_patient_store_reg ppsr ON ppsr.patient_id = ppi.id   AND ppsr.is_create_store = 1  LEFT JOIN ps_patient_store pps ON pps.id = ppsr.store_id  LEFT JOIN ps_account_info pai ON pai.login_name = ppi.archives_create_person   WHERE  ppi.`status` = 1  ");
        if (vo.getQuerySalesType().equals("1")) {
            sb.append(" AND t1.orderId IN ( SELECT pdo.id FROM ps_drug_order pdo INNER JOIN ps_drug_prescription_detail pdpd ON pdpd.order_id = pdo.id AND pdpd.drug_id = '" + vo.getDrugConditionId() + "' ) ");
        } else {
            sb.append("AND t1.orderId IN ( SELECT pdo.id FROM ps_drug_order pdo WHERE pdo.store_id = '" + vo.getStoreConditionId() + "' ) ");
        }
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and t1.store_id in (");
            for (int i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getIcdId())) {
            sb.append(" and ppi.id in ( ");
            sb.append("            SELECT ppi.id              FROM ps_patient_info ppi              LEFT JOIN ps_patient_icd_reg ppir on ppi.id=ppir.patient_id                LEFT JOIN ps_icd_item pii on pii.id=ppir.icd_id               WHERE ppi.`status`=1 and ppir.`status`=1 and pii.`status`=1  ");
            sb.append("and pii.id in (");
            String[] split = vo.getIcdId().split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
            sb.append("                 GROUP BY ppi.id) ");
        }
        sb.append(" GROUP BY  ppi.id");
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<SalesAnalysisStoreDto>> querySalesAnalysisStoreList(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, Boolean isPage) {
        ArrayList<SalesAnalysisStoreDto> list = new ArrayList<SalesAnalysisStoreDto>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSalesAnalysisStoreListData(userDataAuths, vo));
        if (isPage.booleanValue()) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                SalesAnalysisStoreDto dto = new SalesAnalysisStoreDto();
                String storeId = rs.getString("storeId");
                String storeCode = rs.getString("storeCode");
                String storeName = rs.getString("storeName");
                String orgInfoName = rs.getString("orgInfoName");
                String orgInfoId = rs.getString("orgInfoId");
                String saleAmount = rs.getString("saleAmount");
                int salePersonCount = rs.getInt("salePersonCount");
                int saleOrderCount = rs.getInt("saleOrderCount");
                String saleGrossProfit = rs.getString("saleGrossProfit");
                dto.setStoreId(storeId);
                dto.setStoreCode(storeCode);
                dto.setStoreName(storeName);
                dto.setOrgInfoName(orgInfoName);
                dto.setOrgInfoId(orgInfoId);
                dto.setSaleAmount(saleAmount);
                dto.setSalePersonCount(Integer.valueOf(salePersonCount));
                dto.setSaleOrderCount(Integer.valueOf(saleOrderCount));
                dto.setSaleGrossProfit(saleGrossProfit);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getSalesAnalysisStoreListData(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo) {
        StringBuilder sb = new StringBuilder();
        this.isSaleStoreCondition(userDataAuths, vo, sb);
        return sb.toString();
    }

    private void isSaleStoreCondition(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, StringBuilder sb) {
        int i;
        sb.append("SELECT  any_value(pps.id) as storeId , any_value(pps.store_code) as storeCode,  any_value(pps.store_name) as storeName,  any_value(ppo.org_name) as orgInfoName,  any_value(ppo.org_id) as orgInfoId,  sum(pdo.order_amount) as saleAmount,  COUNT( DISTINCT pdo.patient_id) as salePersonCount,  COUNT(pdo.id) as saleOrderCount,  sum(pdo.gross_profit) as saleGrossProfit    FROM ps_drug_order pdo   INNER JOIN ps_patient_store pps on pdo.store_id=pps.id  LEFT JOIN ps_patient_org_store_reg pposr on pposr.store_id=pps.id and pposr.status=1  LEFT JOIN ps_patient_org ppo on ppo.id=ifnull(split_part(pposr.org_id, ',', array_length(split(pposr.org_id,','))),pposr.org_id) and ppo.`status`=1   where pdo.`status`=1 and pps.`status`=1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBuyStartTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getBuyStartTime() + "'and pdo.create_time<= '" + vo.getBuyEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getBuyStartTime() + "'and pdo.pay_time<= '" + vo.getBuyEndTime() + "'))");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreId())) {
            sb.append("and pdo.store_id in (");
            String[] split = vo.getStoreId().split(",");
            for (int i2 = 0; i2 < split.length; ++i2) {
                if (i2 != split.length - 1) {
                    sb.append(" '" + split[i2] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i2] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getOrgId())) {
            sb.append(" and pposr.org_id LIKE '%" + vo.getOrgId() + "%' ");
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getOrgIds())) {
            sb.append(" and (");
            for (i = 0; i < vo.getOrgIds().size(); ++i) {
                if (i != vo.getOrgIds().size() - 1) {
                    sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                    sb.append(" or ");
                    continue;
                }
                sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                sb.append(")");
            }
        }
        sb.append("GROUP BY pps.id ");
        sb.append(" order by ");
        if ("1".equals(vo.getSortSaleAmount())) {
            sb.append(" sum(pdo.order_amount) desc");
        } else if ("2".equals(vo.getSortSaleAmount())) {
            sb.append(" sum(pdo.order_amount) asc");
        } else if ("1".equals(vo.getSortSaleOrderCount())) {
            sb.append(" count(t1.order_seq) desc");
        } else if ("2".equals(vo.getSortSaleOrderCount())) {
            sb.append(" count(t1.order_seq) asc");
        } else if ("1".equals(vo.getSortSalePersonCount())) {
            sb.append(" COUNT(pdo.patient_id) desc");
        } else if ("2".equals(vo.getSortSalePersonCount())) {
            sb.append(" COUNT(pdo.patient_id) asc");
        } else if ("1".equals(vo.getSortSaleGrossProfit())) {
            sb.append(" sum(pdo.gross_profit) desc");
        } else if ("2".equals(vo.getSortSaleGrossProfit())) {
            sb.append(" sum(pdo.gross_profit) asc");
        } else {
            sb.append(" sum(pdo.order_amount) DESC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> querySalesAnalysisStoreListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo) {
        StringBuilder sb = new StringBuilder();
        this.isSaleStoreCountCondition(userDataAuths, vo, sb);
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private void isSaleStoreCountCondition(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, StringBuilder sb) {
        int i;
        sb.append(" SELECT COUNT(1) as cou FROM ( select any_value(pps.id) , any_value(pps.store_code) as storeCode,  any_value(pps.store_name) as storeName,  any_value(ppo.org_name) as orgInfoName,  any_value(ppo.org_id) as orgInfoId,  sum(pdo.order_amount) as saleAmount,  COUNT( DISTINCT pdo.patient_id) as salePersonCount,  COUNT(pdo.id) as saleOrderCount,  sum(pdo.gross_profit) as saleGrossProfit    FROM ps_drug_order pdo   INNER JOIN ps_patient_store pps on pdo.store_id=pps.id  LEFT JOIN ps_patient_org_store_reg pposr on pposr.store_id=pps.id and pposr.status=1  LEFT JOIN ps_patient_org ppo on ppo.id=ifnull(split_part(pposr.org_id, ',', array_length(split(pposr.org_id,','))),pposr.org_id) and ppo.`status`=1   where pdo.`status`=1 and pps.`status`=1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBuyStartTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getBuyStartTime() + "'and pdo.create_time<= '" + vo.getBuyEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getBuyStartTime() + "'and pdo.pay_time<= '" + vo.getBuyEndTime() + "'))");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreId())) {
            sb.append("and pdo.store_id in (");
            String[] split = vo.getStoreId().split(",");
            for (int i2 = 0; i2 < split.length; ++i2) {
                if (i2 != split.length - 1) {
                    sb.append(" '" + split[i2] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i2] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getOrgId())) {
            sb.append(" and pposr.org_id LIKE '%" + vo.getOrgId() + "%' ");
        }
        if (CollectionUtil.isNotEmpty((Collection)vo.getOrgIds())) {
            sb.append(" and (");
            for (i = 0; i < vo.getOrgIds().size(); ++i) {
                if (i != vo.getOrgIds().size() - 1) {
                    sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                    sb.append(" or ");
                    continue;
                }
                sb.append("  pposr.org_id like '%" + (String)vo.getOrgIds().get(i) + "%'");
                sb.append(")");
            }
        }
        sb.append("GROUP BY pps.id ORDER BY sum(pdo.order_amount) DESC");
        sb.append(") temp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<SalesAnalysisAmountDto>> querySalesAnalysisAmountList(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, boolean isPage, boolean onlyFiled) {
        ArrayList<SalesAnalysisAmountDto> list = new ArrayList<SalesAnalysisAmountDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSalesAnalysisAmountListData(userDataAuths, vo, onlyFiled));
        if (isPage) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                SalesAnalysisAmountDto dto = new SalesAnalysisAmountDto();
                if (!onlyFiled) {
                    String patientInfoId = rs.getString("patientInfoId");
                    dto.setPatientInfoId(patientInfoId);
                    String patientBirthday = rs.getString("patientBirthday");
                    dto.setPatientBirthday(patientBirthday);
                    String idCard = rs.getString("idCard");
                    dto.setIdCard(idCard);
                    String patientSex = rs.getString("patientSex");
                    dto.setPatientSex(patientSex);
                    String patientName = rs.getString("patientName");
                    dto.setPatientName(patientName);
                    String mobile = rs.getString("mobile");
                    dto.setMobile(mobile);
                    String patientNo = rs.getString("patientNo");
                    dto.setPatientNo(patientNo);
                    String icd = rs.getString("icd");
                    dto.setIcd(icd);
                    String openStoreName = rs.getString("openStoreName");
                    dto.setOpenStoreName(openStoreName);
                    String openStoreCode = rs.getString("openStoreCode");
                    dto.setOpenStoreCode(openStoreCode);
                    String accountName = rs.getString("accountName");
                    dto.setAccountName(accountName);
                    String accountNo = rs.getString("accountNo");
                    dto.setAccountNo(accountNo);
                    int orderTotalNums = rs.getInt("orderTotalNums");
                    dto.setSaleOrderCount(Integer.valueOf(orderTotalNums));
                    String orderTotalAmount = rs.getString("orderTotalAmount");
                    dto.setSaleAmount(orderTotalAmount);
                    String orderNo = rs.getString("orderNo");
                    dto.setOrderNo(orderNo);
                    String saleStoreName = rs.getString("saleStoreName");
                    dto.setSaleStoreName(saleStoreName);
                    String saleStoreNo = rs.getString("saleStoreNo");
                    dto.setSaleStoreNo(saleStoreNo);
                    String orderBuyTime = rs.getString("orderBuyTime");
                    dto.setOrderBuyTime(orderBuyTime);
                    String orderAmount = rs.getString("orderAmount");
                    dto.setOrderAmount(orderAmount);
                    String drugInfo = rs.getString("drugInfo");
                    dto.setDrugInfo(drugInfo);
                } else {
                    String orderTotalAmount = rs.getString("orderTotalAmount");
                    dto.setSaleAmount(orderTotalAmount);
                }
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    private String getSalesAnalysisAmountListData(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, boolean onlyFiled) {
        StringBuilder sb = new StringBuilder();
        this.isSaleAmountCondition(userDataAuths, vo, onlyFiled, sb);
        return sb.toString();
    }

    private void isSaleAmountCondition(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, boolean onlyFiled, StringBuilder sb) {
        int i;
        String[] split;
        if (onlyFiled) {
            sb.append(" SELECT cast( sum( t1.`order_amount` ) AS DECIMAL ( 32, 2 )) AS orderTotalAmount ");
        } else {
            sb.append("SELECT   any_value ( ppi.id ) as patientInfoId,  any_value ( ppi.patient_birthday ) as patientBirthday,  any_value ( ppi.patient_id_card ) as idCard,  any_value ( (case when ppi.patient_sex=1 then '\u7537'   when ppi.patient_sex=2 then '\u5973' else '' end  ))  as patientSex,  any_value ( ppi.patient_name ) as patientName,   any_value ( ppi.patient_phone ) AS mobile,   any_value ( ppi.patient_member_no ) AS patientNo,   any_value ( t3.icdNames ) AS icd,   any_value ( pps.store_name ) AS openStoreName,   any_value ( pps.store_code ) AS openStoreCode,   any_value ( pai.login_name ) AS accountName,   any_value ( pai.empl_no ) AS accountNo,   cast(   sum( t1.`order_amount` ) AS DECIMAL ( 32, 2 )) AS orderTotalAmount,   count(t1.order_seq) as orderTotalNums,   array_join ( array_sortby ( array_agg ( t1.order_seq ), array_agg ( t1.create_time )), '@' ) AS orderNo,   array_join ( array_sortby ( array_agg ( t1.`store_name` ), array_agg ( t1.create_time )), '@' ) AS saleStoreName,   array_join ( array_sortby ( array_agg ( t1.`store_code` ), array_agg ( t1.create_time )), '@' ) AS saleStoreNo,   array_join ( array_sortby ( array_agg ( t1.orderBuyTime ), array_agg ( t1.create_time )), '@' ) AS orderBuyTime,   array_join ( array_sortby ( array_agg ( CAST( t1.`order_amount` AS string ) ), array_agg ( t1.create_time )), '@' ) AS orderAmount,   array_join ( array_sortby ( array_agg ( t1.drugInfo ), array_agg ( t1.create_time )), '@' ) AS drugInfo  ");
        }
        sb.append(" FROM   ps_patient_info ppi   INNER JOIN (   SELECT     pdo.id,     GROUP_CONCAT( t1.drugInfo ) AS drugInfo,     any_value ( pdo.order_seq ) AS order_seq,     any_value ( pdo.order_amount ) AS order_amount,     any_value (     IFNULL( pdo.pay_time, pdo.create_time )) AS orderBuyTime,     any_value ( pdo.create_time ) AS create_time,     any_value ( pps.store_name ) AS store_name,     any_value ( pps.store_code ) AS store_code,     any_value ( pdo.patient_id ) AS patient_id,   any_value ( pdo.store_id ) AS store_id,     any_value ( pdo.id ) AS orderId    FROM     ps_drug_order pdo     inner JOIN (     SELECT       pdpd.order_id,       CONCAT_WS( '*', pdpd.drug_name, cast( pdpd.amount AS DECIMAL ( 10, 2 )) ) as drugInfo       FROM       ps_drug_prescription_detail pdpd      WHERE       pdpd.`status` = 1      ) t1 ON pdo.id = t1.order_id     LEFT JOIN ps_patient_store pps ON pdo.store_id = pps.id    WHERE     pdo.`status` = 1      AND pps.`status` = 1  ");
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBuyStartTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getBuyStartTime() + "'and pdo.create_time<= '" + vo.getBuyEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getBuyStartTime() + "'and pdo.pay_time<= '" + vo.getBuyEndTime() + "'))");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getSaleStoreId())) {
            sb.append("and pdo.store_id in (");
            split = vo.getSaleStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        sb.append("  GROUP BY     pdo.id    ) t1 ON ppi.id = t1.patient_id  LEFT JOIN ps_patient_store_reg ppsr ON ppsr.patient_id = ppi.id and ppsr. `status` = 1  AND ppsr.is_create_store = 1 LEFT JOIN ps_patient_store pps ON pps.id = ppsr.store_id and pps.`status`=1  LEFT JOIN ps_account_info pai ON pai.id = ppi.archives_create_person and pai.status=1   LEFT JOIN(  SELECT ppi.id,GROUP_CONCAT(pii.icd_name) as icdNames FROM ps_patient_info ppi  LEFT JOIN ps_patient_icd_reg ppir on ppi.id=ppir.patient_id  LEFT JOIN ps_icd_item pii on pii.id=ppir.icd_id  WHERE ppi.`status`=1 and ppir.`status`=1 and pii.`status`=1   GROUP BY ppi.id  ) t3 on t3.id=ppi.id  WHERE  ppi.`status` = 1  ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and t1.store_id in (");
            for (int i2 = 0; i2 < userDataAuths.size(); ++i2) {
                if (i2 != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i2).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i2).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreId())) {
            sb.append("and pps.id in (");
            split = vo.getStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getAccountId())) {
            sb.append("and pai.id in (");
            split = vo.getAccountId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        sb.append("GROUP BY ppi.id");
        sb.append(" order by ");
        if ("1".equals(vo.getSortSaleAmount())) {
            sb.append("   sum( t1.`order_amount` ) desc");
        } else if ("2".equals(vo.getSortSaleAmount())) {
            sb.append("   sum( t1.`order_amount` ) asc");
        } else if ("1".equals(vo.getSortSaleOrderCount())) {
            sb.append(" count(t1.order_seq) desc");
        } else if ("2".equals(vo.getSortSaleOrderCount())) {
            sb.append(" count(t1.order_seq) asc");
        } else {
            sb.append("  sum(t1.`order_amount`) desc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> querySalesAnalysisAmountListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo) {
        StringBuilder sb = new StringBuilder();
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreId()) || ObjectUtil.isNotEmpty((Object)vo.getSaleStoreId()) || ObjectUtil.isNotEmpty((Object)vo.getAccountId()) || ObjectUtil.isNotEmpty((Object)vo.getBuyStartTime())) {
            this.isSaleAmountCountCondition(userDataAuths, vo, sb);
        } else {
            sb.append("SELECT count(1) as cou FROM saleAssay_amount_mv WHERE 1=1");
        }
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private void isSaleAmountCountCondition(List<UserDataAuthsVO> userDataAuths, SalesAnalysisListQo vo, StringBuilder sb) {
        int i;
        String[] split;
        sb.append(" SELECT COUNT(1) as cou FROM ( select any_value ( ppi.id ),   any_value ( ppi.patient_name ) AS patientInfo,   any_value ( ppi.patient_phone ) AS mobile,   any_value ( ppi.patient_member_no ) AS patientNo,   any_value ( t3.icdNames ) AS icd,   any_value ( pps.store_name ) AS openStoreName,   any_value ( pps.store_code ) AS openStoreCode,   any_value ( pai.login_name ) AS accountName,   any_value ( pai.empl_no ) AS accountNo,   cast(   sum( t1.`order_amount` ) AS DECIMAL ( 32, 2 )) AS orderTotalAmount,   count(t1.order_seq) as orderTotalNums,   array_join ( array_sortby ( array_agg ( t1.order_seq ), array_agg ( t1.create_time )), '@' ) AS orderNo,   array_join ( array_sortby ( array_agg ( t1.`store_name` ), array_agg ( t1.create_time )), '@' ) AS saleStoreName,   array_join ( array_sortby ( array_agg ( t1.`store_code` ), array_agg ( t1.create_time )), '@' ) AS saleStoreNo,   array_join ( array_sortby ( array_agg ( t1.orderBuyTime ), array_agg ( t1.create_time )), '@' ) AS orderBuyTime,   array_join ( array_sortby ( array_agg ( CAST( t1.`order_amount` AS string ) ), array_agg ( t1.create_time )), '@' ) AS orderAmount,   array_join ( array_sortby ( array_agg ( t1.drugInfo ), array_agg ( t1.create_time )), '@' ) AS drugInfo   FROM   ps_patient_info ppi   INNER JOIN (   SELECT     pdo.id,     GROUP_CONCAT( t1.drugInfo ) AS drugInfo,     any_value ( pdo.order_seq ) AS order_seq,     any_value ( pdo.order_amount ) AS order_amount,     any_value (     IFNULL( pdo.pay_time, pdo.create_time )) AS orderBuyTime,     any_value ( pdo.create_time ) AS create_time,     any_value ( pps.store_name ) AS store_name,     any_value ( pps.store_code ) AS store_code,     any_value ( pdo.patient_id ) AS patient_id,   any_value ( pdo.store_id ) AS store_id,     any_value ( pdo.id ) AS orderId    FROM     ps_drug_order pdo     inner JOIN (     SELECT       pdpd.order_id,       CONCAT_WS( '*', pdpd.drug_name, cast( pdpd.amount AS DECIMAL ( 10, 2 )) ) AS drugInfo      FROM       ps_drug_prescription_detail pdpd      WHERE       pdpd.`status` = 1      ) t1 ON pdo.id = t1.order_id     LEFT JOIN ps_patient_store pps ON pdo.store_id = pps.id    WHERE     pdo.`status` = 1      AND pps.`status` = 1  ");
        if (ObjectUtil.isNotEmpty((Object)vo.getBrandId())) {
            sb.append(" and pdo.store_id in (SELECT id FROM ps_patient_store WHERE pharmaceutical_company_id= '" + vo.getBrandId() + "')");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getBuyStartTime())) {
            sb.append(" and ((pdo.create_time>= '" + vo.getBuyStartTime() + "'and pdo.create_time<= '" + vo.getBuyEndTime() + "')");
            sb.append("  or (pdo.pay_time>= '" + vo.getBuyStartTime() + "'and pdo.pay_time<= '" + vo.getBuyEndTime() + "'))");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getSaleStoreId())) {
            sb.append("and pdo.store_id in (");
            split = vo.getSaleStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        sb.append("  GROUP BY     pdo.id    ) t1 ON ppi.id = t1.patient_id  LEFT JOIN ps_patient_store_reg ppsr ON ppsr.patient_id = ppi.id and ppsr. `status` = 1  AND ppsr.is_create_store = 1 LEFT JOIN ps_patient_store pps ON pps.id = ppsr.store_id and pps.`status`=1  LEFT JOIN ps_account_info pai ON pai.id = ppi.archives_create_person and pai.status=1   LEFT JOIN(  SELECT ppi.id,GROUP_CONCAT(pii.icd_name) as icdNames FROM ps_patient_info ppi  LEFT JOIN ps_patient_icd_reg ppir on ppi.id=ppir.patient_id  LEFT JOIN ps_icd_item pii on pii.id=ppir.icd_id  WHERE ppi.`status`=1 and ppir.`status`=1 and pii.`status`=1   GROUP BY ppi.id  ) t3 on t3.id=ppi.id  WHERE  ppi.`status` = 1  ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append(" and t1.store_id in (");
            for (int i2 = 0; i2 < userDataAuths.size(); ++i2) {
                if (i2 != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i2).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i2).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreId())) {
            sb.append("and pps.id in (");
            split = vo.getStoreId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getAccountId())) {
            sb.append("and pai.id in (");
            split = vo.getAccountId().split(",");
            for (i = 0; i < split.length; ++i) {
                if (i != split.length - 1) {
                    sb.append(" '" + split[i] + "' ,");
                    continue;
                }
                sb.append(" '" + split[i] + "' )");
            }
        }
        sb.append("GROUP BY ppi.id");
        sb.append(") temp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<PatientOrderStaticsDto>> queryPatientBuyDrugOrderList(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientOrderStaticsQo vo) {
        ArrayList<PatientOrderStaticsDto> list = new ArrayList<PatientOrderStaticsDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.queryPatientBuyDrugOrderListData(userDataAuths, vo));
        if (ObjectUtil.isNotEmpty((Object)vo.getIsPage()) && Boolean.TRUE.equals(vo.getIsPage())) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                PatientOrderStaticsDto dto = new PatientOrderStaticsDto();
                String brandName = rs.getString("brandName");
                dto.setBrandName(brandName);
                String storeName = rs.getString("storeName");
                String storeCode = rs.getString("storeCode");
                String patientPhone = rs.getString("patientPhone");
                String patientName = rs.getString("patientName");
                String productName = rs.getString("productName");
                String productCode = rs.getString("productCode");
                dto.setStoreCode(storeCode);
                String indication = rs.getString("indication");
                dto.setIndication(indication);
                String firstBuyDrugTime = rs.getString("firstBuyDrugTime");
                String lastBuyDrugTime = rs.getString("lastBuyDrugTime");
                String lastBuyDrugCount = rs.getString("lastBuyDrugCount");
                dto.setLastBuyDrugCount(lastBuyDrugCount);
                String lastSecondBuyTime = rs.getString("lastSecondBuyTime");
                dto.setLastSecondBuyTime(lastSecondBuyTime);
                String lastSecondBuyDrugCount = rs.getString("lastSecondBuyDrugCount");
                dto.setLastSecondBuyDrugCount(lastSecondBuyDrugCount);
                String noBuyDrugReason = rs.getString("noBuyDrugReason");
                dto.setNoBuyDrugReason(noBuyDrugReason);
                String isAdverseReactions = rs.getString("isAdverseReactions");
                dto.setIsAdverseReactions(isAdverseReactions);
                String isDiarrhea = rs.getString("isDiarrhea");
                dto.setIsDiarrhea(isDiarrhea);
                String isRash = rs.getString("isRash");
                dto.setIsRash(isRash);
                String isDrySkin = rs.getString("isDrySkin");
                dto.setIsDrySkin(isDrySkin);
                String isPruritus = rs.getString("isPruritus");
                dto.setIsPruritus(isPruritus);
                String isParonychia = rs.getString("isParonychia");
                dto.setIsParonychia(isParonychia);
                String isOralMucositis = rs.getString("isOralMucositis");
                dto.setIsOralMucositis(isOralMucositis);
                String isPulmonary = rs.getString("isPulmonary");
                dto.setIsPulmonary(isPulmonary);
                String isHeating = rs.getString("isHeating");
                dto.setIsHeating(isHeating);
                String isInterstitialPneumonia = rs.getString("isInterstitialPneumonia");
                dto.setIsInterstitialPneumonia(isInterstitialPneumonia);
                String isLeukopenia = rs.getString("isLeukopenia");
                dto.setIsLeukopenia(isLeukopenia);
                String isThrombocytopenia = rs.getString("isThrombocytopenia");
                dto.setIsThrombocytopenia(isThrombocytopenia);
                String isNeutropenia = rs.getString("isNeutropenia");
                dto.setIsNeutropenia(isNeutropenia);
                String isLymphopenia = rs.getString("isLymphopenia");
                String delayUsedDrugReason = rs.getString("delayUsedDrugReason");
                dto.setDelayUsedDrugReason(delayUsedDrugReason);
                dto.setIsLymphopenia(isLymphopenia);
                dto.setPatientName(patientName);
                dto.setPatientPhone(patientPhone);
                dto.setProductName(productName);
                dto.setProductCode(productCode);
                dto.setFirstBuyDrugTime(firstBuyDrugTime);
                dto.setLastBuyDrugTime(lastBuyDrugTime);
                dto.setStoreName(storeName);
                String isRetch = rs.getString("isRetch");
                dto.setIsRetch(isRetch);
                String isAnemia = rs.getString("isAnemia");
                dto.setIsAnemia(isAnemia);
                String isFatigue = rs.getString("isFatigue");
                dto.setIsFatigue(isFatigue);
                String isHairLoss = rs.getString("isHairLoss");
                dto.setIsHairLoss(isHairLoss);
                String isLevf = rs.getString("isLevf");
                dto.setIsLevf(isLevf);
                String isApr = rs.getString("isApr");
                dto.setIsApr(isApr);
                String standardMedicalSelect = rs.getString("standardMedicalSelect");
                dto.setStandardMedicalSelect(standardMedicalSelect);
                String isEdema = rs.getString("isEdema");
                String isAllergy = rs.getString("isAllergy");
                String isAstriction = rs.getString("isAstriction");
                dto.setIsEdema(isEdema);
                dto.setIsAllergy(isAllergy);
                dto.setIsAstriction(isAstriction);
                String orderSeq = rs.getString("orderSeq");
                dto.setOrderSeq(orderSeq);
                String adverseReactions = rs.getString("adverseReactions");
                dto.setAdverseReactions(adverseReactions);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatistics: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> queryPatientBuyDrugOrderListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, PatientOrderStaticsQo vo) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT COUNT(1) as cou FROM (");
        this.queryAzDotList(userDataAuths, vo, sb);
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils getPatientStaffStatisticsCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private String queryPatientBuyDrugOrderListData(List<UserDataAuthsVO> userDataAuths, PatientOrderStaticsQo vo) {
        StringBuilder sb = new StringBuilder();
        this.queryAzDotList(userDataAuths, vo, sb);
        return sb.toString();
    }

    private void queryAzDotList(List<UserDataAuthsVO> userDataAuths, PatientOrderStaticsQo vo, StringBuilder sb) {
        int i;
        sb.append(" SELECT  array_join ( array_distinct ( array_agg ( ppc.pharmaceutical_company_name )), ',' ) AS brandName,  array_join ( array_distinct ( array_agg ( pdo.order_seq )), ',' ) AS orderSeq,  array_join ( array_distinct ( array_agg ( pps.store_name )), ',' ) AS storeName,  array_join ( array_distinct ( array_agg ( pps.store_code )), ',' ) AS storeCode,  any_value ( ppi.patient_phone ) AS patientPhone,  any_value ( ppi.patient_name ) AS patientName,  any_value ( pdpd.drug_name ) AS productName,  any_value ( pdi.product_code ) AS productCode,  any_value ( temp1.indication ) AS indication,  IFNULL( any_value ( ppas.buy_time ), '' ) AS firstBuyDrugTime,  MAX(  IFNULL( pdo.pay_time, pdo.create_time )) AS lastBuyDrugTime, CASE      WHEN array_length (    array_sortby (     split ( GROUP_CONCAT( cast( pdpd.amount AS string ), '_' ), '_' ),     split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' )     )     )= 1 THEN    GROUP_CONCAT(     cast( 0+cast ( cast( pdpd.amount AS DECIMAL ( 32, 5 ) ) AS CHAR ) AS string )) ELSE split_part (     array_join (      REVERSE(       array_sortby (        split ( GROUP_CONCAT( cast( 0+cast ( cast( pdpd.amount AS DECIMAL ( 32, 5 ) ) AS CHAR ) AS string ), '_' ), '_' ),        split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' )        )       ),      '_'      ),     '_',     1     )    END AS lastBuyDrugCount,  any_value(temp.lastSecondBuyTime) AS lastSecondBuyTime,    any_value(temp.lastSecondBuyDrugCount) AS lastSecondBuyDrugCount,   ( CASE WHEN any_value ( temp1.no_buy_drug_select )= '\u5176\u4ed6' THEN any_value ( temp1.no_buy_drug_reason ) ELSE any_value ( temp1.no_buy_drug_select ) END ) AS noBuyDrugReason,   any_value ( temp1.delay_used_drug_reason ) AS delayUsedDrugReason,(   CASE          WHEN ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8179\u6cfb', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u76ae\u75b9\uff08\u75e4\u75ae\u76ae\u75b9\uff09', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u76ae\u80a4\u5e72\u71e5', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u76ae\u80a4\u7619\u75d2', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u7532\u6c9f\u708e', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u53e3\u8154\u9ecf\u819c\u708e', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u80ba\u90e8\u76f8\u5173\u75c7\u72b6\uff08\u54b3\u55fd\u3001\u547c\u5438\u56f0\u96be\uff09', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u53d1\u70ed', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u95f4\u8d28\u6027\u80ba\u708e', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u767d\u7ec6\u80de\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8840\u5c0f\u677f\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u4e2d\u6027\u7c92\u7ec6\u80de\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u6dcb\u5df4\u7ec6\u80de\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u6076\u5fc3\u5455\u5410', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8d2b\u8840', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u75b2\u4e4f', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8131\u53d1', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u5de6\u5fc3\u5ba4\u529f\u80fd\u969c\u788d', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u80ba\u90e8\u4e0d\u826f\u53cd\u5e94', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u6c34\u80bf', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8fc7\u654f', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f'      OR ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u4fbf\u79d8', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END )= '\u662f' THEN      '\u662f' ELSE '\u5426'      END      ) AS isAdverseReactions,     any_value ( temp1.standard_medical_select ) AS standardMedicalSelect,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8179\u6cfb', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isDiarrhea,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u76ae\u75b9\uff08\u75e4\u75ae\u76ae\u75b9\uff09', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isRash,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u76ae\u80a4\u5e72\u71e5', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isDrySkin,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u76ae\u80a4\u7619\u75d2', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isPruritus,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u7532\u6c9f\u708e', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isParonychia,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u53e3\u8154\u9ecf\u819c\u708e', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isOralMucositis,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u80ba\u90e8\u76f8\u5173\u75c7\u72b6\uff08\u54b3\u55fd\u3001\u547c\u5438\u56f0\u96be\uff09', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isPulmonary,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u53d1\u70ed', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isHeating,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u95f4\u8d28\u6027\u80ba\u708e', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isInterstitialPneumonia,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u767d\u7ec6\u80de\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isLeukopenia,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8840\u5c0f\u677f\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isThrombocytopenia,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u4e2d\u6027\u7c92\u7ec6\u80de\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isNeutropenia,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u6dcb\u5df4\u7ec6\u80de\u51cf\u5c11', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isLymphopenia,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u6076\u5fc3\u5455\u5410', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isRetch,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8d2b\u8840', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isAnemia,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u75b2\u4e4f', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isFatigue,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8131\u53d1', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isHairLoss,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u5de6\u5fc3\u5ba4\u529f\u80fd\u969c\u788d', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isLevf,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u80ba\u90e8\u4e0d\u826f\u53cd\u5e94', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isApr,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u6c34\u80bf', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isEdema,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u8fc7\u654f', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isAllergy,     ( CASE WHEN ( any_value ( temp1.adverse_reactions_select ) REGEXP REPLACE ( '\u4fbf\u79d8', ',', '|' ))= 1 THEN '\u662f' ELSE '\u5426' END ) AS isAstriction,    any_value ( temp1.adverse_reactions_select ) as adverseReactions   FROM     ps_drug_order pdo     INNER JOIN (     SELECT      pdpd.order_id AS order_id,      pdpd.drug_id AS drug_id,      any_value ( pdpd.drug_name ) AS drug_name,      SUM( pdpd.amount ) AS amount      FROM      ps_drug_prescription_detail pdpd      WHERE      pdpd.`status` = 1      GROUP BY      pdpd.order_id,      pdpd.drug_id      ) pdpd ON pdo.id = pdpd.order_id          INNER JOIN ps_patient_split_info ppi ON pdo.patient_split_id = ppi.id          LEFT JOIN      (SELECT  IFNULL(   split_part (    array_join (     reverse(      array_sort (       array_distinct (        array_sort (        split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' ))))),     '_'     ),    '_',    2    ),   ''   ) AS lastSecondBuyTime,  split_part (   array_join (    REVERSE(     array_sortby (      split ( GROUP_CONCAT( cast( 0+cast ( cast( pdpd.amount AS DECIMAL ( 32, 5 ) ) AS CHAR ) AS string ), '_' ), '_' ),      split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' )      )),    '_'    ),   '_',   2   ) AS lastSecondBuyDrugCount,  pdo.store_id,  pdo.patient_split_id,  pdpd.drug_id FROM  ps_drug_order pdo  INNER JOIN (  SELECT   pdpd.order_id AS order_id,   pdpd.drug_id AS drug_id,   any_value ( pdpd.drug_name ) AS drug_name,   SUM( pdpd.amount ) AS amount   FROM   ps_drug_prescription_detail pdpd   WHERE   pdpd.`status` = 1   GROUP BY   pdpd.order_id,   pdpd.drug_id   ) pdpd ON pdo.id = pdpd.order_id  WHERE  pdo.`status` = 1   AND pdo.patient_split_id IS NOT NULL  and IFNULL(pdo.pay_time,pdo.create_time)<'" + vo.getBuyDrugEndTime() + "'GROUP BY  pdo.store_id,  pdo.patient_split_id,  pdpd.drug_id) temp on temp.store_id=pdo.store_id and temp.patient_split_id=pdo.patient_split_id and temp.drug_id=pdpd.drug_id     LEFT JOIN ps_patient_store pps ON pps.id = pdo.store_id     LEFT JOIN ps_pharmaceutical_company ppc ON ppc.id = pps.pharmaceutical_company_id     LEFT JOIN ps_drug_item pdi ON pdi.id = pdpd.drug_id     LEFT JOIN ps_patient_az_statistics ppas ON ppi.id = ppas.patient_id      AND pdo.store_id = ppas.store_id      AND ppas.drug_id = pdi.id     LEFT JOIN (     SELECT      temp.patient_id,      temp.drug_id,      temp.followTaskId,      pcf.indication,      pcf.no_buy_drug_select,      pcf.no_buy_drug_reason,      pcf.adverse_reactions_select,      pcf.adverse_reactions_reason,      pcf.delay_used_drug_reason,      pcf.delay_used_drug_str,      pcf.standard_medical_select      FROM      (      SELECT       (       CASE                  WHEN array_length (          array_sortby ( split ( GROUP_CONCAT( ppft.id, '_' ), '_' ), split ( GROUP_CONCAT( cast( ppft.update_time AS string ), '_' ), '_' ) )           )= 1 THEN          GROUP_CONCAT( ppft.id ) ELSE split_part (           array_join (            REVERSE(             array_sortby ( split ( GROUP_CONCAT( ppft.id, '_' ), '_' ), split ( GROUP_CONCAT( cast( ppft.update_time AS string ), '_' ), '_' ) )             ),            '_'            ),           '_',           1           )          END          ) AS followTaskId,         ppft.patient_id,         ppft.drug_id         FROM         ps_patient_follow_task ppft         WHERE         ppft.follow_status = 4          AND ppft.STATUS = 1         GROUP BY         ppft.patient_id,         ppft.drug_id         ) temp        LEFT JOIN ps_condition_followup pcf ON temp.followTaskId = pcf.follow_task_id        WHERE        pcf.STATUS = 1        ) temp1 ON temp1.patient_id = pdo.patient_split_id        AND temp1.drug_id = pdpd.drug_id           WHERE             pdo.`status` = 1              AND pdo.patient_split_id IS NOT NULL       ");
        sb.append("    and pdo.create_time BETWEEN '" + vo.getBuyDrugStartTime() + "'and '" + vo.getBuyDrugEndTime() + "'");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append("and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append(" and pdo.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getDrugIds())) {
            sb.append(" and pdi.id in ( ");
            for (i = 0; i < vo.getDrugIds().size(); ++i) {
                if (i != vo.getDrugIds().size() - 1) {
                    sb.append("'" + (String)vo.getDrugIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getDrugIds().get(i) + "')");
            }
        }
        sb.append("GROUP BY     pps.id,      pdo.patient_split_id,              pdpd.drug_id             ORDER BY              pdo.patient_split_id DESC  ");
    }

    private String queryLsStandardMedicalData(List<UserDataAuthsVO> userDataAuths, LsStandardMedicationStaticsQo vo) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT     array_join ( array_distinct ( array_agg ( ppc.pharmaceutical_company_name )), ',' ) AS brandName,     array_join ( array_distinct ( array_agg ( pps.store_name )), ',' ) AS storeName,     array_join ( array_distinct ( array_agg ( pps.store_code )), ',' ) AS storeCode,     any_value ( subquery.drug_name ) as drugName,     any_value ( pdi.product_code ) AS productCode, ");
        if (Objects.equals("1", vo.getStaticFlag())) {
            sb.append("    subquery.store_id AS storeId, ");
        } else {
            sb.append("    array_join ( array_distinct ( array_agg ( subquery.store_id )), ',' ) AS storeId, ");
        }
        sb.append("    subquery.drug_id AS drugId,     COUNT( DISTINCT subquery.patient_id ) AS peopleNum,     array_remove(array_distinct(array_agg (subquery.patient_id)),null) AS pidList,     ROUND(SUM( subquery.amount ),1) AS buyAmount,     ROUND( SUM( subquery.amount ) / COUNT( DISTINCT subquery.patient_id ), 1 ) AS averageNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) <= 21 THEN subquery.patient_id ELSE null END )),null)) AS standardMedicationNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) > 21 THEN subquery.patient_id ELSE null END )),null)) AS noStandardMedicationNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 12 THEN subquery.patient_id ELSE null END)),null)) greaterThanTwelve,     array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) <= 21 THEN subquery.patient_id ELSE null END )),null) AS standardMedicationPidList,     array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) > 21 THEN subquery.patient_id ELSE null END )),null) AS noStandardMedicationPidList,     array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 12 THEN subquery.patient_id ELSE null END)),null) AS greaterThanTwelvePidList,     array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 15 THEN subquery.patient_id ELSE null END)),null) AS greaterThanFifteenPidList,     array_length(array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 15 THEN subquery.patient_id ELSE null END)),null)) AS greaterThanFifteen FROM   (   SELECT     pdpd.order_id,     pdpd.store_id,     pdpd.drug_id,     pdpd.drug_name,     pdo.patient_split_id as patient_id,     pdpd.amount,     IFNULL( pdo.pay_time, pdo.create_time ) AS pay_time, ");
        if (Objects.equals("1", vo.getStaticFlag())) {
            sb.append("    LAG( IFNULL( pdo.pay_time, pdo.create_time )) OVER ( PARTITION BY pdo.patient_split_id, pdpd.drug_id, pdpd.store_id ORDER BY IFNULL( pdo.pay_time, pdo.create_time ) ASC ) AS prev_pay_time  ");
        } else {
            sb.append("    LAG( IFNULL( pdo.pay_time, pdo.create_time )) OVER ( PARTITION BY pdo.patient_split_id, pdpd.drug_id ORDER BY IFNULL( pdo.pay_time, pdo.create_time ) ASC ) AS prev_pay_time  ");
        }
        sb.append("   FROM      ps_drug_prescription_detail pdpd     INNER JOIN ps_drug_order pdo ON pdpd.order_id = pdo.id     WHERE      pdo.`status` = 1       AND pdo.patient_split_id IS NOT NULL  AND pdo.patient_split_id != ''        AND pdpd.`status` = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append("and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append(" and pdpd.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getDrugIds())) {
            sb.append(" and pdpd.drug_id in ( ");
            for (i = 0; i < vo.getDrugIds().size(); ++i) {
                if (i != vo.getDrugIds().size() - 1) {
                    sb.append("'" + (String)vo.getDrugIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getDrugIds().get(i) + "')");
            }
        }
        sb.append("   ) AS subquery");
        sb.append("      LEFT JOIN ps_patient_store pps ON pps.id = subquery.store_id      LEFT JOIN ps_pharmaceutical_company ppc ON ppc.id = pps.pharmaceutical_company_id      LEFT JOIN ps_drug_item pdi ON pdi.id = subquery.drug_id ");
        sb.append("    WHERE subquery.pay_time  >= '" + vo.getBuyDrugStartTime() + "'  AND  subquery.pay_time  <= '" + vo.getBuyDrugEndTime() + "' ");
        if (Objects.equals("1", vo.getStaticFlag())) {
            sb.append(" GROUP BY subquery.store_id, subquery.drug_id ");
        } else {
            sb.append(" GROUP BY subquery.drug_id ");
            sb.append(" ORDER BY drug_id  DESC ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> queryLsStandardMedicalListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, LsStandardMedicationStaticsQo vo) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT COUNT(1) as cou FROM (");
        sb.append("SELECT     array_join ( array_distinct ( array_agg ( ppc.pharmaceutical_company_name )), ',' ) AS brandName,     array_join ( array_distinct ( array_agg ( pps.store_name )), ',' ) AS storeName,     array_join ( array_distinct ( array_agg ( pps.store_code )), ',' ) AS storeCode,     any_value ( subquery.drug_name ) as drugName,     any_value ( pdi.product_code ) AS productCode, ");
        if (Objects.equals("1", vo.getStaticFlag())) {
            sb.append("    subquery.store_id AS storeId, ");
        } else {
            sb.append("    array_join ( array_distinct ( array_agg ( subquery.store_id )), ',' ) AS storeId, ");
        }
        sb.append("    subquery.drug_id AS drugId,     COUNT( DISTINCT subquery.patient_id ) AS peopleNum,     array_remove(array_distinct(array_agg (subquery.patient_id)),null) AS pidList,     ROUND(SUM( subquery.amount ),1) AS buyAmount,     ROUND( SUM( subquery.amount ) / COUNT( DISTINCT subquery.patient_id ), 1 ) AS averageNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) <= 21 THEN subquery.patient_id ELSE null END )),null)) AS standardMedicationNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 12 THEN subquery.patient_id ELSE null END)),null)) greaterThanTwelve,     array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) <= 21 THEN subquery.patient_id ELSE null END )),null) AS standardMedicationPidList,     array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 12 THEN subquery.patient_id ELSE null END)),null) AS greaterThanTwelvePidList,     array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 15 THEN subquery.patient_id ELSE null END)),null) AS greaterThanFifteenPidList,     array_length(array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 15 THEN subquery.patient_id ELSE null END)),null)) AS greaterThanFifteen FROM   (   SELECT     pdpd.order_id,     pdpd.store_id,     pdpd.drug_id,     pdpd.drug_name,     pdo.patient_split_id as patient_id,     pdpd.amount,     IFNULL( pdo.pay_time, pdo.create_time ) AS pay_time, ");
        if (Objects.equals("1", vo.getStaticFlag())) {
            sb.append("    LAG( IFNULL( pdo.pay_time, pdo.create_time )) OVER ( PARTITION BY pdo.patient_split_id, pdpd.drug_id, pdpd.store_id ORDER BY IFNULL( pdo.pay_time, pdo.create_time ) ASC ) AS prev_pay_time  ");
        } else {
            sb.append("    LAG( IFNULL( pdo.pay_time, pdo.create_time )) OVER ( PARTITION BY pdo.patient_split_id, pdpd.drug_id ORDER BY IFNULL( pdo.pay_time, pdo.create_time ) ASC ) AS prev_pay_time  ");
        }
        sb.append("   FROM      ps_drug_prescription_detail pdpd     INNER JOIN ps_drug_order pdo ON pdpd.order_id = pdo.id     WHERE      pdo.`status` = 1       AND pdo.patient_split_id IS NOT NULL  AND pdo.patient_split_id != ''      AND pdpd.`status` = 1 ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append("and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append(" and pdpd.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getDrugIds())) {
            sb.append(" and pdpd.drug_id in ( ");
            for (i = 0; i < vo.getDrugIds().size(); ++i) {
                if (i != vo.getDrugIds().size() - 1) {
                    sb.append("'" + (String)vo.getDrugIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getDrugIds().get(i) + "')");
            }
        }
        sb.append("  and IFNULL( pdo.pay_time, pdo.create_time ) >= DATE_SUB('" + vo.getBuyDrugStartTime() + "', INTERVAL 21 DAY)  ");
        sb.append("  and IFNULL( pdo.pay_time, pdo.create_time ) <= '" + vo.getBuyDrugEndTime() + "'");
        sb.append("   ) AS subquery");
        sb.append("      LEFT JOIN ps_patient_store pps ON pps.id = subquery.store_id      LEFT JOIN ps_pharmaceutical_company ppc ON ppc.id = pps.pharmaceutical_company_id      LEFT JOIN ps_drug_item pdi ON pdi.id = subquery.drug_id ");
        sb.append("    WHERE subquery.pay_time  >= '" + vo.getBuyDrugStartTime() + "'  AND  subquery.pay_time  <= '" + vo.getBuyDrugEndTime() + "' ");
        if (Objects.equals("1", vo.getStaticFlag())) {
            sb.append(" GROUP BY subquery.store_id, subquery.drug_id ");
            sb.append(" ORDER BY store_id, drug_id  DESC ");
        } else {
            sb.append(" GROUP BY subquery.drug_id");
        }
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryLsStandardMedicalListCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicalListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicalListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<LsStandardMedicationStaticsDto>> queryLsStandardMedicalList(Connection connection, List<UserDataAuthsVO> userDataAuths, LsStandardMedicationStaticsQo vo) {
        ArrayList<LsStandardMedicationStaticsDto> list = new ArrayList<LsStandardMedicationStaticsDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.queryLsStandardMedicalData(userDataAuths, vo));
        if (ObjectUtil.isNotEmpty((Object)vo.getIsPage()) && Boolean.TRUE.equals(vo.getIsPage())) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                LsStandardMedicationStaticsDto dto = new LsStandardMedicationStaticsDto();
                String brandName = rs.getString("brandName");
                dto.setBrandName(brandName);
                String storeName = rs.getString("storeName");
                dto.setStoreName(storeName);
                String storeCode = rs.getString("storeCode");
                dto.setStoreCode(storeCode);
                String drugName = rs.getString("drugName");
                dto.setProductName(drugName);
                String productCode = rs.getString("productCode");
                dto.setProductCode(productCode);
                String drugId = rs.getString("drugId");
                dto.setDrugId(drugId);
                String storeId = rs.getString("storeId");
                dto.setStoreId(storeId);
                String peopleNum = rs.getString("peopleNum");
                dto.setPeopleNum(peopleNum);
                String buyAmount = rs.getString("buyAmount");
                dto.setBuyAmount(buyAmount);
                String averageNum = rs.getString("averageNum");
                dto.setAvgBuyNum(averageNum);
                String standardMedicationNum = rs.getString("standardMedicationNum");
                dto.setStandardMedicationNum(standardMedicationNum);
                String noStandardMedicationNum = rs.getString("noStandardMedicationNum");
                dto.setNoStandardMedicationNum(noStandardMedicationNum);
                String greaterThanTwelve = rs.getString("greaterThanTwelve");
                dto.setGreaterThanTwelve(greaterThanTwelve);
                String greaterThanFifteen = rs.getString("greaterThanFifteen");
                dto.setGreaterThanFifteen(greaterThanFifteen);
                String pidListString = rs.getString("pidList");
                pidListString = pidListString.replace("[", "").replace("]", "").replace("\"", "");
                List<String> pidList = Arrays.asList(pidListString.split(","));
                dto.setPidList(pidList);
                String greaterThanTwelvePidListString = rs.getString("greaterThanTwelvePidList");
                greaterThanTwelvePidListString = greaterThanTwelvePidListString.replace("[", "").replace("]", "").replace("\"", "");
                List<String> greaterThanTwelvePidList = Arrays.asList(greaterThanTwelvePidListString.split(","));
                dto.setGreaterThanTwelvePidList(greaterThanTwelvePidList);
                String greaterThanFifteenPidListString = rs.getString("greaterThanFifteenPidList");
                greaterThanFifteenPidListString = greaterThanFifteenPidListString.replace("[", "").replace("]", "").replace("\"", "");
                List<String> greaterThanFifteenPidList = Arrays.asList(greaterThanFifteenPidListString.split(","));
                dto.setGreaterThanFifteenPidList(greaterThanFifteenPidList);
                String standardMedicationPidListString = rs.getString("standardMedicationPidList");
                standardMedicationPidListString = standardMedicationPidListString.replace("[", "").replace("]", "").replace("\"", "");
                List<String> standardMedicationPidList = Arrays.asList(standardMedicationPidListString.split(","));
                dto.setStandardMedicationPidList(standardMedicationPidList);
                String noStandardMedicationPidListString = rs.getString("noStandardMedicationPidList");
                noStandardMedicationPidListString = noStandardMedicationPidListString.replace("[", "").replace("]", "").replace("\"", "");
                ArrayList<String> noStandardMedicationPidList = new ArrayList<String>(Arrays.asList(noStandardMedicationPidListString.split(",")));
                noStandardMedicationPidList.removeAll(standardMedicationPidList);
                dto.setNoStandardMedicationPidList(noStandardMedicationPidList);
                BigDecimal part = new BigDecimal(standardMedicationNum);
                BigDecimal total = part.add(new BigDecimal(noStandardMedicationNum));
                if (total.compareTo(new BigDecimal("0")) == 0) {
                    dto.setStandardMedicationRate("0.00%");
                } else {
                    BigDecimal percentage = part.divide(total, 4, 4).multiply(new BigDecimal("100"));
                    dto.setStandardMedicationRate(percentage.setScale(2, 4) + "%");
                }
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryLsStandardMedicalList: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicalList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicalList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<LsStandardMedicationPatientStaticsDto>> queryLsStandardMedicaPatientList(Connection connection, List<UserDataAuthsVO> userDataAuths, LsStandardMedicationPatientStaticsQo vo) {
        ArrayList<LsStandardMedicationPatientStaticsDto> list = new ArrayList<LsStandardMedicationPatientStaticsDto>();
        StringBuffer sb = new StringBuffer();
        sb.append(this.queryLsStandardMedicalPatientData(userDataAuths, vo));
        if (ObjectUtil.isNotEmpty((Object)vo.getIsPage()) && Boolean.TRUE.equals(vo.getIsPage())) {
            int firstIndex = (vo.getPageIndex() - 1) * vo.getPageSize();
            sb.append(" limit " + firstIndex + "," + vo.getPageSize());
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                LsStandardMedicationPatientStaticsDto dto = new LsStandardMedicationPatientStaticsDto();
                String patientName = rs.getString("patientName");
                dto.setPatientName(patientName);
                String patientPhone = rs.getString("patientPhone");
                dto.setPatientPhone(patientPhone);
                String patientSex = rs.getString("patientSex");
                dto.setSex(patientSex);
                String patientBirthday = rs.getString("patientBirthday");
                dto.setBirthday(patientBirthday);
                String patientIdCard = rs.getString("patientIdCard");
                int age = 0;
                if (StringUtils.isNotEmpty((CharSequence)patientIdCard)) {
                    try {
                        Date birthDayFromIdCard = DateUtils.getBirthDayFromIdCard((String)patientIdCard);
                        age = DateUtils.getAgeByBirthDay((Date)birthDayFromIdCard);
                    }
                    catch (Exception e) {
                        log.info("-=-----\u89c4\u8303\u7528\u836f\u8be6\u60c5\u7edf\u8ba1\u8eab\u4efd\u8bc1\u8ba1\u7b97\u5e74\u9f84\u89e3\u6790\u5f02\u5e38-----");
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)patientBirthday)) {
                    LocalDate birthday = LocalDate.parse(patientBirthday);
                    LocalDate currentDate = LocalDate.now();
                    age = Period.between(birthday, currentDate).getYears();
                }
                dto.setAge(String.valueOf(age));
                String belongStore = rs.getString("belongStore");
                belongStore = belongStore.replace("[", "").replace("]", "").replace("\"", "");
                dto.setBelongStore(belongStore);
                String recordStore = rs.getString("recordStore");
                dto.setRecordStore(recordStore);
                String archivesCreatePerson = rs.getString("archivesCreatePerson");
                dto.setArchivist(archivesCreatePerson);
                String archivesCreateTime = rs.getString("archivesCreateTime");
                dto.setArchivistTime(archivesCreateTime);
                String buyAmount = rs.getString("buyAmount");
                dto.setBuyDrugNum(buyAmount);
                String lastBuyTime = rs.getString("lastBuyTime");
                dto.setLastBuyDrugTime(lastBuyTime);
                String lastBuyAmount = rs.getString("lastBuyAmount");
                dto.setLastBuyDrugCount(lastBuyAmount);
                String lastSecondBuyTime = rs.getString("lastSecondBuyTime");
                dto.setLastSecondBuyTime(lastSecondBuyTime);
                String firstBuyTime = rs.getString("firstBuyTime");
                dto.setFirstBuyDrugTime(firstBuyTime);
                String lastSecondBuyDrugCount = rs.getString("lastSecondBuyDrugCount");
                dto.setLastSecondBuyDrugCount(lastSecondBuyDrugCount);
                list.add(dto);
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryLsStandardMedicaPatientList: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicaPatientList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicaPatientList: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> queryLsStandardMedicalPatientListCount(Connection connection, List<UserDataAuthsVO> userDataAuths, LsStandardMedicationPatientStaticsQo vo) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT COUNT(1) as cou FROM (");
        sb.append("SELECT     any_value ( ppi.patient_name ) as patientName,     any_value ( ppi.patient_phone ) as patientPhone,     (CASE any_value ( ppi.patient_sex ) WHEN 1 THEN '\u7537' ELSE '\u5973' END) AS patientSex,     any_value ( ppi.patient_id_card ) AS patientIdCard,     any_value ( ppi.patient_birthday ) AS patientBirthday,     any_value ( CASE WHEN ppsr.is_create_store = 1 THEN pps.store_name END ) AS recordStore,     array_remove(array_distinct(array_agg ( pps.store_name )),null) as belongStore,     any_value ( pai.login_name ) AS archivesCreatePerson,     any_value ( ppi.archives_create_time ) AS archivesCreateTime,     MAX( DISTINCT ( IFNULL( pdo.pay_time, pdo.create_time ))) AS lastBuyTime,     ROUND(max_by ( pdpd.amount, IFNULL( pdo.pay_time, pdo.create_time )),1) AS lastBuyAmount,     any_value ( temp.first_buy_time) AS firstBuyTime,     ROUND(SUM( pdpd.amount ),1) AS buyAmount,       IFNULL(         split_part (           array_join (             reverse(               array_sort (                 array_distinct (                   array_sort (                   split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' ))))),             '_'            ),           '_',           2          ),         ''        ) AS lastSecondBuyTime,       ROUND(split_part (         array_join (           REVERSE(             array_sortby (               split ( GROUP_CONCAT( cast( cast( pdpd.amount AS DECIMAL ( 32, 1 ) ) AS string ), '_' ), '_' ),               split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' )              )),           '_'          ),         '_',         2        ),1) AS lastSecondBuyDrugCount ");
        sb.append("FROM    ps_patient_split_info ppi   INNER JOIN ps_drug_order pdo ON ppi.id = pdo.patient_split_id    INNER JOIN ps_drug_prescription_detail pdpd ON pdo.id = pdpd.order_id    LEFT JOIN ps_account_info pai ON pai.id = ppi.archives_create_person    LEFT JOIN  ps_patient_store_reg ppsr ON ppsr.patient_id = ppi.id  AND ppsr.patient_type = 1    LEFT JOIN ps_patient_store pps ON pps.id = ppsr.store_id     LEFT JOIN (     SELECT        pdo.patient_split_id AS patient_id,        MIN( IFNULL( pdo.pay_time, pdo.create_time )) AS first_buy_time     FROM        ps_drug_prescription_detail pdpd        INNER JOIN ps_drug_order pdo ON pdpd.order_id = pdo.id      WHERE        pdo.`status` = 1        AND pdpd.`status` = 1         AND pdpd.drug_id =  '" + vo.getDrugId() + "'");
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append("       AND pdpd.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        sb.append("    GROUP BY pdo.patient_split_id ) temp ON temp.patient_id = ppi.id WHERE   pdo.`status` = 1    AND pdpd.`status` = 1    AND pdpd.drug_id =  '" + vo.getDrugId() + "'  AND IFNULL( pdo.pay_time, pdo.create_time ) >= '" + vo.getBuyDrugStartTime() + "'   AND IFNULL( pdo.pay_time, pdo.create_time ) <= '" + vo.getBuyDrugEndTime() + "' ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append("and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append(" AND pdpd.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPidList())) {
            sb.append(" AND ppi.id in ( ");
            for (i = 0; i < vo.getPidList().size(); ++i) {
                if (i != vo.getPidList().size() - 1) {
                    sb.append("'" + (String)vo.getPidList().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getPidList().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientName())) {
            sb.append(" AND ppi.patient_name = '" + vo.getPatientName() + "'");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientPhone())) {
            sb.append(" AND ppi.patient_phone = '" + vo.getPatientPhone() + "'");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientIdCard())) {
            sb.append(" AND ppi.patient_id_card = '" + vo.getPatientIdCard() + "'");
        }
        sb.append(" GROUP BY ppi.id ");
        sb.append(" ORDER BY ppi.id ");
        sb.append(") temp");
        Integer count = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String querySql = sb.toString();
        try {
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                count = rs.getInt("cou");
            }
            AsyncResult asyncResult = new AsyncResult((Object)count);
            return asyncResult;
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils queryLsStandardMedicalPatientListCount: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicalPatientListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils queryLsStandardMedicalPatientListCount: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)count);
    }

    private String queryLsStandardMedicalPatientData(List<UserDataAuthsVO> userDataAuths, LsStandardMedicationPatientStaticsQo vo) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT     any_value ( ppi.patient_name ) as patientName,     any_value ( ppi.patient_phone ) as patientPhone,     (CASE any_value ( ppi.patient_sex ) WHEN 1 THEN '\u7537' ELSE '\u5973' END) AS patientSex,     any_value ( ppi.patient_id_card ) AS patientIdCard,     any_value ( ppi.patient_birthday ) AS patientBirthday,     any_value ( CASE WHEN ppsr.is_create_store = 1 THEN pps.store_name END ) AS recordStore,     array_remove(array_distinct(array_agg ( pps.store_name )),null) as belongStore,     any_value ( pai.login_name ) AS archivesCreatePerson,     any_value ( ppi.archives_create_time ) AS archivesCreateTime,     MAX( DISTINCT ( IFNULL( pdo.pay_time, pdo.create_time ))) AS lastBuyTime,     ROUND(max_by ( pdpd.amount, IFNULL( pdo.pay_time, pdo.create_time )),1) AS lastBuyAmount,     any_value ( temp.first_buy_time) AS firstBuyTime,     ROUND(SUM( pdpd.amount ),1) AS buyAmount,       IFNULL(         split_part (           array_join (             reverse(               array_sort (                 array_distinct (                   array_sort (                   split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' ))))),             '_'            ),           '_',           2          ),         ''        ) AS lastSecondBuyTime,       ROUND(split_part (         array_join (           REVERSE(             array_sortby (               split ( GROUP_CONCAT( cast( cast( pdpd.amount AS DECIMAL ( 32, 1 ) ) AS string ), '_' ), '_' ),               split ( GROUP_CONCAT( date_format( IFNULL( pdo.pay_time, pdo.create_time ), '%Y-%m-%d %H:%i:%s' ), '_' ), '_' )              )),           '_'          ),         '_',         2        ),1) AS lastSecondBuyDrugCount ");
        sb.append("FROM    ps_patient_split_info ppi   INNER JOIN ps_drug_order pdo ON ppi.id = pdo.patient_split_id    INNER JOIN ps_drug_prescription_detail pdpd ON pdo.id = pdpd.order_id    LEFT JOIN ps_account_info pai ON pai.id = ppi.archives_create_person    LEFT JOIN  ps_patient_store_reg ppsr ON ppsr.patient_id = ppi.id  AND ppsr.patient_type = 1    LEFT JOIN ps_patient_store pps ON pps.id = ppsr.store_id     LEFT JOIN (     SELECT        pdo.patient_split_id AS patient_id,        MIN( IFNULL( pdo.pay_time, pdo.create_time )) AS first_buy_time     FROM        ps_drug_prescription_detail pdpd        INNER JOIN ps_drug_order pdo ON pdpd.order_id = pdo.id      WHERE        pdo.`status` = 1        AND pdpd.`status` = 1         AND pdpd.drug_id =  '" + vo.getDrugId() + "'");
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append("       AND pdpd.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        sb.append("    GROUP BY pdo.patient_split_id ) temp ON temp.patient_id = ppi.id WHERE   pdo.`status` = 1    AND pdpd.`status` = 1    AND pdpd.drug_id =  '" + vo.getDrugId() + "'  AND IFNULL( pdo.pay_time, pdo.create_time ) >= '" + vo.getBuyDrugStartTime() + "'   AND IFNULL( pdo.pay_time, pdo.create_time ) <= '" + vo.getBuyDrugEndTime() + "' ");
        if (!CollectionUtils.isEmpty(userDataAuths)) {
            sb.append("and pdo.store_id in (");
            for (i = 0; i < userDataAuths.size(); ++i) {
                if (i != userDataAuths.size() - 1) {
                    sb.append("'" + userDataAuths.get(i).getId() + "',");
                    continue;
                }
                sb.append("'" + userDataAuths.get(i).getId() + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append(" AND pdpd.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPidList())) {
            sb.append(" AND ppi.id in ( ");
            for (i = 0; i < vo.getPidList().size(); ++i) {
                if (i != vo.getPidList().size() - 1) {
                    sb.append("'" + (String)vo.getPidList().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getPidList().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientName())) {
            sb.append(" AND ppi.patient_name = '" + vo.getPatientName() + "'");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientPhone())) {
            sb.append(" AND ppi.patient_phone = '" + vo.getPatientPhone() + "'");
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getPatientIdCard())) {
            sb.append(" AND ppi.patient_id_card = '" + vo.getPatientIdCard() + "'");
        }
        sb.append(" GROUP BY ppi.id ");
        sb.append(" ORDER BY ppi.id ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<LsStandardMedicationStaticsDpVo> queryLsStandardMedicalListnew(Connection connection, LsStandardMedicationStaticsQo vo) {
        LsStandardMedicationStaticsDpVo dto = new LsStandardMedicationStaticsDpVo();
        Statement ps = null;
        ResultSet rs = null;
        try {
            String querySql = this.queryLsStandardMedicalListSql(vo);
            ps = connection.prepareStatement(querySql);
            rs = ps.executeQuery(querySql);
            while (rs.next()) {
                String peopleNum = rs.getString("peopleNum");
                dto.setPeopleNum(peopleNum);
                String averageNum = rs.getString("averageNum");
                dto.setAvgBuyNum(averageNum);
                String standardMedicationNum = rs.getString("standardMedicationNum");
                dto.setStandardMedicationNum(standardMedicationNum);
                String noStandardMedicationNum = rs.getString("noStandardMedicationNum");
                dto.setNoStandardMedicationNum(noStandardMedicationNum);
                String greaterThanTwelve = rs.getString("greaterThanTwelve");
                dto.setGreaterThanTwelve(greaterThanTwelve);
                String greaterThanFifteen = rs.getString("greaterThanFifteen");
                dto.setGreaterThanFifteen(greaterThanFifteen);
                BigDecimal part = new BigDecimal(standardMedicationNum);
                BigDecimal total = part.add(new BigDecimal(noStandardMedicationNum));
                if (total.compareTo(new BigDecimal("0")) == 0) {
                    dto.setStandardMedicationRate("0");
                    continue;
                }
                BigDecimal percentage = part.divide(total, 4, 4);
                dto.setStandardMedicationRate(percentage.setScale(2, 4).toString());
            }
        }
        catch (SQLException e) {
            log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
            log.info("exception: ", (Throwable)e);
        }
        finally {
            try {
                assert (ps != null);
                ps.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
            try {
                assert (rs != null);
                rs.close();
            }
            catch (SQLException e) {
                log.error("StarRocksPatientUtils dashboardPatientIndication: ", (Object)e.getMessage());
                log.info("exception: ", (Throwable)e);
            }
        }
        return new AsyncResult((Object)dto);
    }

    private String queryLsStandardMedicalListSql(LsStandardMedicationStaticsQo vo) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT     COUNT( DISTINCT subquery.patient_id ) AS peopleNum,     ROUND( SUM( subquery.amount ) / COUNT( DISTINCT subquery.patient_id ), 1 ) AS averageNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) <= 21 THEN subquery.patient_id ELSE null END )),null)) AS standardMedicationNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN DATEDIFF( subquery.pay_time, subquery.prev_pay_time ) > 21 THEN subquery.patient_id ELSE null END )),null)) AS noStandardMedicationNum,     array_length(array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 12 THEN subquery.patient_id ELSE null END)),null)) greaterThanTwelve,     array_length(array_remove(array_distinct(array_agg (CASE WHEN subquery.amount >= 15 THEN subquery.patient_id ELSE null END)),null)) AS greaterThanFifteen FROM   (   SELECT     pdpd.order_id,     pdpd.store_id,     pdpd.drug_id,     pdpd.drug_name,     pdo.patient_split_id as patient_id,     pdpd.amount,     IFNULL( pdo.pay_time, pdo.create_time ) AS pay_time, ");
        sb.append("    LAG( IFNULL( pdo.pay_time, pdo.create_time )) OVER ( PARTITION BY pdo.patient_split_id, pdpd.drug_id ORDER BY IFNULL( pdo.pay_time, pdo.create_time ) ASC ) AS prev_pay_time  ");
        sb.append("   FROM      ps_drug_prescription_detail pdpd     INNER JOIN ps_drug_order pdo ON pdpd.order_id = pdo.id     WHERE      pdo.`status` = 1       AND pdo.patient_split_id IS NOT NULL  AND pdo.patient_split_id != ''        AND pdpd.`status` = 1 ");
        if (ObjectUtil.isNotEmpty((Object)vo.getStoreIds())) {
            sb.append(" and pdpd.store_id in ( ");
            for (i = 0; i < vo.getStoreIds().size(); ++i) {
                if (i != vo.getStoreIds().size() - 1) {
                    sb.append("'" + (String)vo.getStoreIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getStoreIds().get(i) + "')");
            }
        }
        if (ObjectUtil.isNotEmpty((Object)vo.getDrugIds())) {
            sb.append(" and pdpd.drug_id in ( ");
            for (i = 0; i < vo.getDrugIds().size(); ++i) {
                if (i != vo.getDrugIds().size() - 1) {
                    sb.append("'" + (String)vo.getDrugIds().get(i) + "',");
                    continue;
                }
                sb.append("'" + (String)vo.getDrugIds().get(i) + "')");
            }
        }
        sb.append("   ) AS subquery");
        sb.append("      LEFT JOIN ps_patient_store pps ON pps.id = subquery.store_id      LEFT JOIN ps_pharmaceutical_company ppc ON ppc.id = pps.pharmaceutical_company_id      LEFT JOIN ps_drug_item pdi ON pdi.id = subquery.drug_id ");
        sb.append("    WHERE subquery.pay_time  >= '" + vo.getBuyDrugStartTime() + "'  AND  subquery.pay_time  <= '" + vo.getBuyDrugEndTime() + "' ");
        return sb.toString();
    }
}

