/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.utils;

import com.ebaiyihui.utils.PaginationHelper;
import java.util.ArrayList;
import java.util.List;

public class PaginationHelper<T> {
    private final List<T> items;
    private final int itemsPerPage;

    public PaginationHelper(List<T> items, int itemsPerPage) {
        this.items = items;
        this.itemsPerPage = itemsPerPage;
    }

    public int getItemCount() {
        return this.items != null ? this.items.size() : 0;
    }

    public int getPageCount() {
        if (this.items == null || this.items.isEmpty()) {
            return 0;
        }
        return (int)Math.ceil((double)this.getItemCount() / (double)this.itemsPerPage);
    }

    public List<T> getPageItems(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            throw new IndexOutOfBoundsException("Invalid page index");
        }
        int start = pageIndex * this.itemsPerPage;
        int end = Math.min(start + this.itemsPerPage, this.getItemCount());
        if (start >= this.getItemCount()) {
            return new ArrayList();
        }
        return this.items.subList(start, end);
    }

    public Page getPageInfo(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            throw new IndexOutOfBoundsException("Invalid page index");
        }
        int start = pageIndex * this.itemsPerPage;
        int end = Math.min(start + this.itemsPerPage, this.getItemCount());
        return new Page(pageIndex, this.getPageCount(), start, end, this.itemsPerPage);
    }
}

