/*
 * Decompiled with CFR 0.152.
 */
package com.byh.measureserver.config;

import com.byh.measureserver.common.execption.BusinessException;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class GlobalDefaultExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalDefaultExceptionHandler.class);
    private static final Logger logger = LoggerFactory.getLogger(GlobalDefaultExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResponse handleException(HttpServletRequest req, Exception ex) {
        logger.error("\u7cfb\u7edf\u9519\u8bef\uff01uri:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)req.getRequestURI(), (Object)ex);
        if (ex instanceof BusinessException) {
            BusinessException businessException = (BusinessException)ex;
            return new BaseResponse(businessException.getCode(), businessException.getDesc(), null);
        }
        return BaseResponse.error((IError)IError.SYSYTEM_UNKNOW);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public BaseResponse handleParamCheckExcepion(HttpServletRequest req, MethodArgumentNotValidException ex) {
        BindingResult bindingResult = ex.getBindingResult();
        StringBuilder paramErrorMsg = new StringBuilder();
        if (bindingResult.hasErrors()) {
            List allErrors = bindingResult.getAllErrors();
            for (ObjectError objectError : allErrors) {
                String msg = objectError.getDefaultMessage();
                if (paramErrorMsg.length() == 0) {
                    paramErrorMsg.append(msg);
                    continue;
                }
                paramErrorMsg.append(',');
                paramErrorMsg.append(msg);
            }
        }
        logger.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25! uri:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)req.getRequestURI(), (Object)paramErrorMsg.toString());
        return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD, (String)paramErrorMsg.toString());
    }
}

