/*
 * Decompiled with CFR 0.152.
 */
package com.byh.measureserver.service.impl;

import com.byh.measureserver.dao.MeasureDao;
import com.byh.measureserver.dao.UserDao;
import com.byh.measureserver.pojo.vo.JobSaturationVO;
import com.byh.measureserver.pojo.vo.ReactivatedBugsVO;
import com.byh.measureserver.pojo.vo.TodoBugsVO;
import com.byh.measureserver.service.MeasureService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="measureService")
@Transactional(rollbackFor={Exception.class})
public class measureServiceImpl
implements MeasureService {
    @Autowired
    UserDao userDao;
    @Autowired
    MeasureDao measureDao;

    private List<String> getShowUserAccs() {
        return this.userDao.getShowUserAccs();
    }

    public List<JobSaturationVO> getJobSaturation() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String year = format.format(new Date()) + "-01-01";
        List jobSaturationVOList = this.measureDao.getJobSaturation(this.userDao.getShowUserAccs(), year);
        return jobSaturationVOList;
    }

    public List<TodoBugsVO> getTodoBugsSummary() {
        List todoBugsVOList = this.measureDao.getTodoBugs(this.userDao.getShowUserAccs());
        return todoBugsVOList;
    }

    public List<ReactivatedBugsVO> getReactivatedBugsSummary() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String year = format.format(new Date()) + "-01-01";
        List reactivatedBugsVOList = this.measureDao.getReactivatedBugs(this.userDao.getShowUserAccs(), year);
        return reactivatedBugsVOList;
    }
}

