/*
 * Decompiled with CFR 0.152.
 */
package com.byh.measureserver.utils;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueKeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(UniqueKeyGenerator.class);
    private static final String POSSIBLE_CHARS = "0123456789abcdefghijklmnopqrstuvwxyz";

    public static String generateToken() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String generateSalt() {
        SecureRandom RANDOM = new SecureRandom();
        byte[] salt = new byte[16];
        ((Random)RANDOM).nextBytes(salt);
        try {
            return new String(Base64.encodeBase64((byte[])salt), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("generateSalt error");
            return "";
        }
    }

    public static Long generateViewId() {
        Long timestamp = System.currentTimeMillis();
        StringBuilder result = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 6; ++i) {
            result.append(random.nextInt(10));
        }
        return Long.valueOf(String.valueOf(timestamp) + result.toString());
    }

    public static String random(int n) {
        String random = "";
        Random nextRandom = new Random();
        for (int i = 0; i < n; ++i) {
            random = random + nextRandom.nextInt(10);
        }
        return random;
    }

    public static String random(int n, int min, int max) {
        String random = "";
        Random nextRandom = new Random();
        for (int i = 0; i < n; ++i) {
            random = random + (nextRandom.nextInt(max) % (max - min + 1) + min);
        }
        return random;
    }

    public static String generateRandomString(int length) {
        StringBuilder sb = new StringBuilder(length);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            sb.append(POSSIBLE_CHARS.charAt(random.nextInt(POSSIBLE_CHARS.length())));
        }
        return sb.toString();
    }
}

