/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.byh.common.ResultInfo;
import com.byh.constants.BillConstant;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.enums.BillBusinessTypeEnum;
import com.byh.enums.DoctorServiceEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.manage.consultation.BusinessManage;
import com.byh.manage.consultation.ConsultationManager;
import com.byh.manage.consultation.ConsultationReportManager;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.consultation.DoctorBillVo;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.DoctorBillInfoService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.StringUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/business/v2"})
public class BusinessController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BusinessController.class);
    @Autowired
    private ConsultationManager consultationManager;
    @Autowired
    private DoctorBillInfoService doctorBillInfoService;
    @Autowired
    private ConsultationReportManager consultationReportManager;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private BusinessManage businessManage;
    @Autowired
    private ConsultationExtendService consultationExtendService;

    @PostMapping(value={"/directAccountEntry"})
    public ResultInfo<String> directAccountEntry(@RequestParam(value="orderIds") String ids) {
        List list = Stream.of(ids.split(",")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            for (String orderViewId : list) {
                ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId.trim());
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                boolean checkSevenElements = this.consultationReportManager.checkConsultationQualifiedNoPatientInfo(consultationEntity, this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay()));
                if (!checkSevenElements) continue;
                Integer accompanyType = new Integer(0);
                Integer receiveType = new Integer(0);
                String serviceCodeName = DoctorServiceEnum.getByValue((Integer)consultationEntity.getServiceCode()).getDisplay();
                if (StringUtil.isNotEmpty((String)serviceCodeName) && serviceCodeName.contains("\u533b\u9662")) {
                    accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_COMP.getValue();
                    receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_RECV.getValue();
                } else {
                    accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_COMP.getValue();
                    receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_RECV.getValue();
                }
                DoctorBillVo doctorBillVo = new DoctorBillVo();
                doctorBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
                doctorBillVo.setBusinessId(orderViewId);
                doctorBillVo.setBusinessType(accompanyType.intValue());
                doctorBillVo.setDoctorId(consultationEntity.getDoctorId());
                doctorBillVo.setOriginalMoney(consultationExtendEntity.getAccompanyFee());
                doctorBillVo.setSubsidyMoney(new BigDecimal(0));
                doctorBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
                doctorBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)accompanyType).getDisplay());
                doctorBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
                DoctorBillInfoEntity doctorBillInfoEntity = this.doctorBillInfoService.addOne(doctorBillVo);
                DoctorBillVo expertBillVo = new DoctorBillVo();
                expertBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
                expertBillVo.setBusinessId(orderViewId);
                expertBillVo.setBusinessType(receiveType.intValue());
                expertBillVo.setDoctorId(consultationEntity.getExpertId());
                expertBillVo.setOriginalMoney(consultationExtendEntity.getAmissionFee());
                expertBillVo.setSubsidyMoney(new BigDecimal(0));
                expertBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
                expertBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)receiveType).getDisplay());
                expertBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
                DoctorBillInfoEntity doctorBillInfoEntity2 = this.doctorBillInfoService.addOne(expertBillVo);
            }
        }
        return this.returnSucceed("\u5165\u8d26\u6210\u529f");
    }

    @ApiOperation(value="\u751f\u4ea7\u73af\u5883\u4f7f\u7528\u67e5\u627e\u89c6\u9891\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u8ba2\u5355\u7684viewId", name="orderViewId", required=true, dataType="string", paramType="query")})
    @GetMapping(value={"/getVedioUrlByStreamId"})
    public ResultInfo<Map<String, String>> getVedioUrlByStreamId(@RequestParam(value="orderViewId", defaultValue="0") String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
        if (consultationEntity != null) {
            Map map = this.businessManage.getVideoDetailL(consultationEntity);
            return this.returnSucceed((Object)map, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/elements/checkOrderInfo"})
    public BaseResponse<String> checkOrderInfo(@RequestParam(value="orderId", defaultValue="0") Long orderId) {
        boolean checkConsent;
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(orderId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        boolean checkConsultationValue = false;
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        boolean checkPatienfInfo = StringUtil.isNotEmpty((String)consultationEntity.getPatientName()) && StringUtil.isNotEmpty((String)consultationExtendEntity.getPatientPhone()) && patientInfoRespVO != null && StringUtil.isNotEmpty((String)patientInfoRespVO.getCredNo());
        PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
        boolean checkPatientCaseInfo = StringUtil.isNotEmpty((String)patientCaseInfoEntity.getMainSuit()) && (StringUtil.isNotEmpty((String)patientCaseInfoEntity.getNormalImages()) || StringUtil.isNotEmpty((String)consultationExtendEntity.getDcmFileUrl()) || StringUtil.isNotEmpty((String)consultationExtendEntity.getDcmPackUrl())) && StringUtil.isNotEmpty((String)patientCaseInfoEntity.getConsultAim());
        boolean checkDoctorDetailInfo = StringUtil.isNotEmpty((String)consultationEntity.getDoctorName()) && StringUtil.isNotEmpty((String)consultationEntity.getDoctorHosName()) && StringUtil.isNotEmpty((String)consultationEntity.getDoctorDepName());
        boolean checkExpertDetailInfo = StringUtil.isNotEmpty((String)consultationEntity.getExpertName()) && StringUtil.isNotEmpty((String)consultationEntity.getExpertDeptName()) && StringUtil.isNotEmpty((String)consultationEntity.getExpertHosName());
        ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId());
        boolean checkReport = consultationReportEntity != null;
        boolean checkVedio = true;
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue())) {
            checkVedio = StringUtil.isNotEmpty((String)consultationExtendEntity.getVideoUrl());
        }
        boolean bl = checkConsent = StringUtil.isNotEmpty((String)consultationEntity.getPatientInformedConsentUrl()) || StringUtil.isNotEmpty((String)consultationEntity.getPatientSignature());
        if (checkPatienfInfo && checkPatientCaseInfo && checkDoctorDetailInfo && checkExpertDetailInfo && checkReport && checkVedio && checkConsent) {
            checkConsultationValue = true;
        }
        log.info("===\u68c0\u67e5\u7684\u7ed3\u679c\u662f:===\u60a3\u8005\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkPatienfInfo + "===\u75c5\u4f8b\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkPatientCaseInfo + "===\u966a\u8bca\u533b\u751f\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkDoctorDetailInfo + "===\u63a5\u8bca\u4e13\u5bb6\u662f\u5426\u5408\u683c:" + checkExpertDetailInfo + "====\u4f1a\u8bca\u62a5\u544a\u662f\u5426\u7f3a\u5931:" + checkReport + "===\u4f1a\u8bca\u89c6\u9891\u662f\u5426\u7f3a\u5931:" + checkVedio + "===\u77e5\u60c5\u540c\u610f\u4e66\u662f\u5426\u7f3a\u5931:" + checkConsent + "======\u6700\u7ec8\u7684\u68c0\u67e5\u7ed3\u679c\u662f:" + checkConsultationValue);
        return BaseResponse.success();
    }

    @PostMapping(value={"/saveOrUpdateSignCode"})
    public BaseResponse<String> saveOrUpdateSignCode(@RequestParam(value="appCode", defaultValue="") String appCode, @RequestParam(value="signCode", defaultValue="") String signCode) {
        if (StringUtil.isBlank((String)appCode) || StringUtil.isBlank((String)signCode)) {
            return BaseResponse.error((String)"appCode\u6216\u8005signCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.businessManage.saveOrUpdateSignCode(appCode, signCode);
    }

    @GetMapping(value={"/getSignCodeByAppCode"})
    public BaseResponse<String> getSignCode(@RequestParam(value="appCode", defaultValue="") String appCode) {
        return this.businessManage.getSignCodeByAppCode(appCode);
    }
}

