/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.common.ResultInfo;
import com.byh.constants.BillConstant;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.enums.BillBusinessTypeEnum;
import com.byh.enums.DoctorServiceEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.exception.PushInfoException;
import com.byh.manage.consultation.ConsultationManager;
import com.byh.manage.consultation.ConsultationReportManager;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.pojo.bo.consultation.ConsultationReportDto;
import com.byh.pojo.bo.consultation.OrderDetailDto;
import com.byh.pojo.bo.consultation.OrderDetailEditionTwoDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.vo.consultation.DoctorBillVo;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.DoctorBillInfoService;
import com.byh.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.JedisCluster;

@Api(description="\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u548c\u8ba2\u5355\u8be6\u60c5")
@RestController
@RequestMapping(value={"/api/v1/consultation/report"})
public class ConsultationReportController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ConsultationReportController.class);
    @Autowired
    private ConsultationReportManager consultationReportManager;
    @Autowired
    private DoctorBillInfoService doctorBillInfoService;
    @Autowired
    private ConsultationManager consultationManager;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private JedisCluster jedisCluster;

    @ApiOperation(value="\u4e13\u5bb6\u4fdd\u5b58\u6216\u4fee\u6539\u4f1a\u8bca\u62a5\u544a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="orderType", value="\u8ba2\u5355\u7c7b\u578b", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="treatPlan", value="\u6cbb\u7597\u610f\u89c1", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="signature", value="\u6570\u5b57\u7b7e\u540d", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="photoReport", value="\u56fe\u7247\u8def\u5f84", required=false, dataType="String", paramType="query")})
    @PostMapping(value={"/saveUpdate_consultationReport"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo saveUpdateConsultationReport(@RequestParam(value="orderViewId", required=true) String orderViewId, @RequestParam(value="orderType", required=true, defaultValue="0") Integer orderType, @RequestParam(value="treatPlan", defaultValue="") String treatPlan, @RequestParam(value="signature", defaultValue="") String signature, @RequestParam(value="photoReport", defaultValue="") String photoReport) {
        if (StringUtil.isEmpty((String)orderViewId)) {
            return this.returnFailure("\u8ba2\u5355viewId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        if (orderType == null || orderType == 0) {
            return this.returnFailure("\u8ba2\u5355\u7c7b\u578b\u9519\u8bef!");
        }
        if (!consultationEntity.getStatus().equals(OrderStatusEnum.FINISH.getValue())) {
            return this.returnFailure("\u8bf7\u7ed3\u675f\u4f1a\u8bca\u540e\u518d\u586b\u5199\u4f1a\u8bca\u62a5\u544a");
        }
        LocalDateTime beforLocalDateTime = LocalDateTime.now().minusMinutes(2L);
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) && StringUtil.isNotEmpty((String)consultationEntity.getFinishTime()) && !beforLocalDateTime.isAfter(LocalDateTime.parse(consultationEntity.getFinishTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))) {
            return this.returnFailure("\u4f1a\u8bca\u89c6\u9891\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u5927\u7ea6\u9700\u8981\u4e24\u5206\u949f\u65f6\u95f4");
        }
        this.consultationReportManager.compensateVideo(consultationEntity);
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) && StringUtil.isEmpty((String)consultationExtendEntity.getVideoUrl())) {
            return this.returnFailure("\u89c6\u9891\u4f1a\u8bca\u8ba2\u5355\u5f55\u5236\u89c6\u9891\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ResultInfo resultInfo = this.consultationReportManager.saveUpdateConsultationReport(orderViewId, orderType, treatPlan, signature, photoReport);
        try {
            this.webAndAppMessageManager.saveUpdateConsultationReportSendMessage(consultationEntity.getId());
            this.shortMessageManager.remindUserWatchReport(consultationEntity.getViewId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean checkSevenElements = this.consultationReportManager.checkConsultationQualified(consultationEntity, resultInfo);
        if (resultInfo.getCode() == ReturnCodeEnum.SUCCEED.getValue() && checkSevenElements) {
            log.info("====\u5f00\u59cb\u5165\u8d26=====\u8ba2\u5355\u7684view_id\u662f:" + orderViewId);
            Integer accompanyType = new Integer(0);
            Integer receiveType = new Integer(0);
            String serviceCodeName = DoctorServiceEnum.getByValue((Integer)consultationEntity.getServiceCode()).getDisplay();
            if (StringUtil.isNotEmpty((String)serviceCodeName) && serviceCodeName.contains("\u533b\u9662")) {
                accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_COMP.getValue();
                receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_RECV.getValue();
            } else {
                accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_COMP.getValue();
                receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_RECV.getValue();
            }
            DoctorBillVo doctorBillVo = new DoctorBillVo();
            doctorBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
            doctorBillVo.setBusinessId(consultationEntity.getViewId());
            doctorBillVo.setBusinessType(accompanyType.intValue());
            doctorBillVo.setDoctorId(consultationEntity.getDoctorId());
            doctorBillVo.setOriginalMoney(consultationExtendEntity.getAccompanyFee());
            doctorBillVo.setSubsidyMoney(new BigDecimal(0));
            doctorBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
            doctorBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)accompanyType).getDisplay());
            doctorBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
            log.info("===\u7ed9\u533b\u751f\u5165\u8d26\u7684\u4fe1\u606f\u662f:" + doctorBillVo.toString());
            DoctorBillInfoEntity doctorBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(doctorBillVo);
            DoctorBillVo expertBillVo = new DoctorBillVo();
            expertBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
            expertBillVo.setBusinessId(consultationEntity.getViewId());
            expertBillVo.setBusinessType(receiveType.intValue());
            expertBillVo.setDoctorId(consultationEntity.getExpertId());
            expertBillVo.setOriginalMoney(consultationExtendEntity.getAmissionFee());
            expertBillVo.setSubsidyMoney(new BigDecimal(0));
            expertBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
            expertBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)receiveType).getDisplay());
            expertBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
            log.info("====\u7ed9\u4e13\u5bb6\u5165\u8d26\u7684\u4fe1\u606f\u662f:" + expertBillVo.toString());
            DoctorBillInfoEntity expertBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(expertBillVo);
            if (doctorBillInfoEntityResultInfo == null || expertBillInfoEntityResultInfo == null) {
                throw new RuntimeException("\u5165\u533b\u751f\u8d26\u5355\u670d\u52a1\u9519\u8bef");
            }
        }
        return resultInfo;
    }

    @ApiOperation(value="\u533b\u9662\u7ba1\u7406\u5458\u4fdd\u5b58\u6216\u4fee\u6539\u4f1a\u8bca\u62a5\u544a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="orderType", value="\u8ba2\u5355\u7c7b\u578b", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="treatPlan", value="\u6cbb\u7597\u610f\u89c1", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="signature", value="\u6570\u5b57\u7b7e\u540d", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="photoReport", value="\u56fe\u7247\u8def\u5f84", required=false, dataType="String", paramType="query")})
    @PostMapping(value={"/hospital/saveUpdate_consultationReport"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo adminSaveUpdateConsultationReport(@RequestParam(value="orderViewId", required=true) String orderViewId, @RequestParam(value="orderType", required=true, defaultValue="0") Integer orderType, @RequestParam(value="treatPlan", defaultValue="") String treatPlan, @RequestParam(value="signature", defaultValue="") String signature, @RequestParam(value="photoReport", defaultValue="") String photoReport) {
        if (StringUtil.isBlank((String)orderViewId)) {
            return this.returnFailure("\u8ba2\u5355uuid\u4e3a\u7a7a!");
        }
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        if (orderType == null || orderType == 0) {
            return this.returnFailure("\u8ba2\u5355\u7c7b\u578b\u9519\u8bef!");
        }
        if (!consultationEntity.getStatus().equals(OrderStatusEnum.FINISH.getValue())) {
            return this.returnFailure("\u8bf7\u7ed3\u675f\u4f1a\u8bca\u540e\u518d\u586b\u5199\u4f1a\u8bca\u62a5\u544a");
        }
        this.consultationReportManager.compensateVideo(consultationEntity);
        ResultInfo resultInfo = this.consultationReportManager.saveUpdateConsultationReport(orderViewId, orderType, treatPlan, signature, photoReport);
        try {
            this.webAndAppMessageManager.saveUpdateConsultationReportSendMessage(consultationEntity.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean checkSevenElements = this.consultationReportManager.checkConsultationQualified(consultationEntity, resultInfo);
        if (resultInfo.getCode() == ReturnCodeEnum.SUCCEED.getValue() && checkSevenElements) {
            Integer accompanyType = new Integer(0);
            Integer receiveType = new Integer(0);
            String serviceCodeName = DoctorServiceEnum.getByValue((Integer)consultationEntity.getServiceCode()).getDisplay();
            if (StringUtil.isNotEmpty((String)serviceCodeName) && serviceCodeName.contains("\u533b\u9662")) {
                accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_COMP.getValue();
                receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_RECV.getValue();
            } else {
                accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_COMP.getValue();
                receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_RECV.getValue();
            }
            DoctorBillVo doctorBillVo = new DoctorBillVo();
            doctorBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
            doctorBillVo.setBusinessId(consultationEntity.getViewId());
            doctorBillVo.setBusinessType(accompanyType.intValue());
            doctorBillVo.setDoctorId(consultationEntity.getDoctorId());
            doctorBillVo.setOriginalMoney(consultationExtendEntity.getAccompanyFee());
            doctorBillVo.setSubsidyMoney(new BigDecimal(0));
            doctorBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
            doctorBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)accompanyType).getDisplay());
            doctorBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
            DoctorBillInfoEntity doctorBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(doctorBillVo);
            DoctorBillVo expertBillVo = new DoctorBillVo();
            expertBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
            expertBillVo.setBusinessId(consultationEntity.getViewId());
            expertBillVo.setBusinessType(receiveType.intValue());
            expertBillVo.setDoctorId(consultationEntity.getExpertId());
            expertBillVo.setOriginalMoney(consultationExtendEntity.getAmissionFee());
            expertBillVo.setSubsidyMoney(new BigDecimal(0));
            expertBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
            expertBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)receiveType).getDisplay());
            expertBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
            DoctorBillInfoEntity expertBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(expertBillVo);
            if (doctorBillInfoEntityResultInfo == null || expertBillInfoEntityResultInfo == null) {
                throw new RuntimeException("\u5165\u533b\u751f\u8d26\u5355\u670d\u52a1\u9519\u8bef");
            }
        }
        return resultInfo;
    }

    @ApiOperation(value="\u4f1a\u8bca\u62a5\u544a_\u67e5\u8be2\u8ba2\u5355uuid")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/query_consultationReport_byOrder"})
    public ResultInfo<ConsultationReportDto> queryConsultationReportByOrder(@RequestParam(value="orderViewId", required=true, defaultValue="") String orderViewId) {
        if (orderViewId == null) {
            log.info("\u8ba2\u5355uuid\u4e3a\u7a7a==========");
            return this.returnFailure("\u8ba2\u5355uuid\u4e3a\u7a7a!");
        }
        return this.consultationReportManager.queryConsultationReportByOrder(orderViewId);
    }

    @ApiOperation(value="\u4f1a\u8bca\u62a5\u544a_\u67e5\u8be2\u60a3\u8005id")
    @ApiImplicitParams(value={@ApiImplicitParam(name="patientId", value="\u60a3\u8005id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="10", dataType="int", paramType="query")})
    @GetMapping(value={"/query_consultationReport_byPatientId"})
    public ResultInfo<List<ConsultationReportDto>> queryConsultationReportByPatient(@RequestParam(value="patientId", defaultValue="0") Long patientId, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        if (patientId == null) {
            log.info("\u60a3\u8005id\u4e3a\u7a7a==========");
            return this.returnFailure("\u60a3\u8005id\u4e3a\u7a7a!");
        }
        return this.consultationReportManager.queryConsultationReportByPatient(patientId, pageIndex, pageSize);
    }

    @ApiOperation(value="\u4f1a\u8bca\u62a5\u544a_\u67e5\u8be2\u533b\u751fid")
    @ApiImplicitParams(value={@ApiImplicitParam(name="doctorId", value="\u533b\u751fid", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="10", dataType="int", paramType="query"), @ApiImplicitParam(name="search", value="\u6a21\u7cca\u5b57\u6bb5", defaultValue="", dataType="String", paramType="query")})
    @GetMapping(value={"/query_consultationReport_byDoctorId"})
    public ResultInfo<List<ConsultationReportDto>> queryConsultationReportByDoctorId(@RequestParam(value="doctorId", defaultValue="0") Long doctorId, @RequestParam(value="type", defaultValue="0") Integer type, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="search", required=false, defaultValue="") String search) {
        if (doctorId == null || doctorId.intValue() == 0) {
            log.info("\u533b\u751fid\u9519\u8bef==========");
            return this.returnFailure("\u533b\u751fid\u9519\u8bef!");
        }
        if (type == null || type == 0) {
            log.info("\u7c7b\u578b\u9519\u8bef==========");
            return this.returnFailure("\u7c7b\u578b\u9519\u8bef!");
        }
        return this.consultationReportManager.queryConsultationReportByDoctorId(doctorId, type, pageIndex, pageSize, search);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/query_orderDetail"})
    public ResultInfo<OrderDetailDto> queryOrderDetail(@RequestParam(value="orderViewId") String orderViewId) {
        if (orderViewId == null) {
            log.info("\u8ba2\u5355uuid\u4e3a\u7a7a==========");
            return this.returnFailure("\u8ba2\u5355uuid\u4e3a\u7a7a!");
        }
        return this.consultationReportManager.queryOrderDetail(orderViewId);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5_\u591a\u5b9e\u4f53\u5c01\u88c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/query_orderDetailEditionTwoDto"})
    public ResultInfo<OrderDetailEditionTwoDto> queryOrderDetailEditionTwoDto(@RequestParam(value="orderViewId") String orderViewId) {
        if (StringUtil.isEmpty((String)orderViewId)) {
            log.info("\u8ba2\u5355uuid\u4e3a\u7a7a==========");
            return this.returnFailure("\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a!");
        }
        return this.consultationReportManager.queryOrderDetailEditionTwoDto(orderViewId);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5,\u5206\u4eab\u4e13\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, dataType="Long", paramType="query")})
    @GetMapping(value={"/query_orderDetail_share"})
    public ResultInfo<OrderDetailDto> queryOrderDetailShare(@RequestParam(value="orderId", defaultValue="0") Long orderId) {
        if (orderId == null || orderId.intValue() == 0) {
            log.info("\u8ba2\u5355id\u4e3a\u9519\u8bef==========");
            return this.returnFailure("\u8ba2\u5355id\u9519\u8bef!");
        }
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(orderId);
        if (consultationEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return this.consultationReportManager.queryOrderDetail(consultationEntity.getViewId());
    }

    @GetMapping(value={"/weixin/view_id/query_orderDetail"})
    public ResultInfo<OrderDetailDto> queryOrderDetailShareByOrderViewId(@RequestParam(value="orderViewId", defaultValue="0") String orderViewId) {
        return this.consultationReportManager.queryOrderDetail(orderViewId);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5_orderId")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/query_orderDetail_orderId"})
    public ResultInfo<OrderDetailDto> queryOrderDetailByOrderId(@RequestParam(value="orderId", defaultValue="0") Long orderId) {
        OrderDetailDto orderDetailDto = null;
        try {
            orderDetailDto = (OrderDetailDto)this.consultationReportManager.queryOrderDetailByOrderId(orderId).getData();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.returnSucceed((Object)orderDetailDto, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u4f1a\u8bca\u62a5\u544a_\u8349\u7a3f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="orderType", value="\u8ba2\u5355\u7c7b\u578b", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="treatPlan", value="\u6cbb\u7597\u610f\u89c1", dataType="String", paramType="query"), @ApiImplicitParam(name="signature", value="\u6570\u5b57\u7b7e\u540d", dataType="String", paramType="query"), @ApiImplicitParam(name="photoReport", value="\u56fe\u6587\u62a5\u544a", dataType="String", paramType="query")})
    @PostMapping(value={"/consultationReportDraft"})
    public ResultInfo consultationReportDraft(@RequestParam(value="orderViewId", defaultValue="") String orderViewId, @RequestParam(value="orderType", defaultValue="0") Integer orderType, @RequestParam(value="treatPlan", defaultValue="") String treatPlan, @RequestParam(value="signature", defaultValue="") String signature, @RequestParam(value="photoReport", defaultValue="") String photoReport) {
        if (orderViewId.equals("")) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:orderViewId");
        }
        if (orderType == 0) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:orderType");
        }
        return this.consultationReportManager.consultationReportDraft(orderViewId, orderType, treatPlan, signature, photoReport);
    }

    @ApiOperation(value="\u4f1a\u8bca\u62a5\u544a_\u5ba1\u6838")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001,-1:\u5220\u9664 1:\u6b63\u5f0f 2:\u8349\u7a3f", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="reason", value="\u539f\u56e0", dataType="String", paramType="query")})
    @PostMapping(value={"/consultationReportInspect"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo consultationReportInspect(@RequestParam(value="orderViewId", defaultValue="") String orderViewId, @RequestParam(value="status", defaultValue="0") Integer status, @RequestParam(value="reason", defaultValue="") String reason) {
        if (orderViewId.equals("")) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:orderViewId");
        }
        if (status == 1 && reason.equals("")) {
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:reason");
        }
        ResultInfo resultInfo = this.consultationReportManager.consultationReportInspect(orderViewId, status, reason);
        try {
            this.webAndAppMessageManager.consultationReportInspectSendMessage(orderViewId, reason);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return resultInfo;
    }

    @ApiOperation(value="\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66_\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="patientInformedConsentUrl", value="\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66\u8def\u5f84", dataType="String", paramType="query")})
    @PostMapping(value={"/upload_patientInformedConsentUrl"})
    public ResultInfo uploadPatientInformedConsentUrl(@RequestParam(value="orderId", defaultValue="0") Long orderId, @RequestParam(value="patientInformedConsentUrl", defaultValue="") String patientInformedConsentUrl) {
        if (orderId.intValue() == 0) {
            log.error("\u53c2\u6570\u9519\u8bef============" + orderId);
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:orderId");
        }
        if (patientInformedConsentUrl.equals("")) {
            log.error("\u53c2\u6570\u9519\u8bef============" + patientInformedConsentUrl);
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:patientInformedConsentUrl");
        }
        return this.consultationManager.uploadPatientInformedConsentUrl(orderId, patientInformedConsentUrl);
    }

    @ApiOperation(value="\u4e0a\u4f20\u4f1a\u8bca\u62a5\u544a \u591a\u5f20\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="photoReport", value="\u56fe\u7247\u8def\u5f84", required=true, dataType="String", paramType="query")})
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/upLoadReportMore"})
    public ResultInfo upLoadReportMore(@RequestParam(value="orderViewId", defaultValue="") String orderViewId, @RequestParam(value="photoReport", defaultValue="") String photoReport) {
        if (StringUtil.isEmpty((String)orderViewId)) {
            return this.returnFailure("\u53c2\u6570\u9519\u8beforderViewId:" + orderViewId);
        }
        if (StringUtil.isEmpty((String)photoReport)) {
            return this.returnFailure("\u53c2\u6570\u9519\u8befphotoReport:" + photoReport);
        }
        ResultInfo resultInfo = this.consultationReportManager.upLoadReportMore(orderViewId, photoReport);
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
        LocalDateTime beforLocalDateTime = LocalDateTime.now().minusMinutes(2L);
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) && StringUtil.isNotEmpty((String)consultationEntity.getFinishTime()) && !beforLocalDateTime.isAfter(LocalDateTime.parse(consultationEntity.getFinishTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")))) {
            return this.returnFailure("\u4f1a\u8bca\u89c6\u9891\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u5927\u7ea6\u9700\u8981\u4e24\u5206\u949f\u65f6\u95f4");
        }
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        boolean checkSevenElements = this.consultationReportManager.checkConsultationQualified(consultationEntity, resultInfo);
        if (resultInfo.getCode() == ReturnCodeEnum.SUCCEED.getValue() && checkSevenElements) {
            log.info("====\u5f00\u59cb\u5165\u8d26=====\u8ba2\u5355\u7684view_id\u662f:" + orderViewId);
            Integer accompanyType = new Integer(0);
            Integer receiveType = new Integer(0);
            String serviceCodeName = DoctorServiceEnum.getByValue((Integer)consultationEntity.getServiceCode()).getDisplay();
            if (StringUtil.isNotEmpty((String)serviceCodeName) && serviceCodeName.contains("\u533b\u9662")) {
                accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_COMP.getValue();
                receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_RECV.getValue();
            } else {
                accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_COMP.getValue();
                receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_RECV.getValue();
            }
            DoctorBillVo doctorBillVo = new DoctorBillVo();
            doctorBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
            doctorBillVo.setBusinessId(consultationEntity.getViewId());
            doctorBillVo.setBusinessType(accompanyType.intValue());
            doctorBillVo.setDoctorId(consultationEntity.getDoctorId());
            doctorBillVo.setOriginalMoney(consultationExtendEntity.getAccompanyFee());
            doctorBillVo.setSubsidyMoney(new BigDecimal(0));
            doctorBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
            doctorBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)accompanyType).getDisplay());
            doctorBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
            log.info("===\u7ed9\u533b\u751f\u5165\u8d26\u7684\u4fe1\u606f\u662f:" + doctorBillVo.toString());
            DoctorBillInfoEntity doctorBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(doctorBillVo);
            DoctorBillVo expertBillVo = new DoctorBillVo();
            expertBillVo.setBillStatus(Integer.valueOf(BillConstant.STATUS_WAITTING_DEAL_ACCOUNTENTRY));
            expertBillVo.setBusinessId(consultationEntity.getViewId());
            expertBillVo.setBusinessType(receiveType.intValue());
            expertBillVo.setDoctorId(consultationEntity.getExpertId());
            expertBillVo.setOriginalMoney(consultationExtendEntity.getAmissionFee());
            expertBillVo.setSubsidyMoney(new BigDecimal(0));
            expertBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
            expertBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)receiveType).getDisplay());
            expertBillVo.setType(Integer.valueOf(BillConstant.TYPE_ACCOUNT_INCOME));
            log.info("====\u7ed9\u4e13\u5bb6\u5165\u8d26\u7684\u4fe1\u606f\u662f:" + expertBillVo.toString());
            DoctorBillInfoEntity expertBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(expertBillVo);
            if (doctorBillInfoEntityResultInfo == null || expertBillInfoEntityResultInfo == null) {
                throw new RuntimeException("\u5165\u533b\u751f\u8d26\u5355\u670d\u52a1\u9519\u8bef");
            }
        }
        return resultInfo;
    }

    @ApiOperation(value="\u7b7e\u540d\u7167\u7247\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="autographPhoto", value="\u7b7e\u540d\u56fe\u7247\u8def\u5f84", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/upLoadAutographPhoto"})
    public ResultInfo upLoadAutographPhoto(@RequestParam(value="orderViewId", defaultValue="") String orderViewId, @RequestParam(value="autographPhoto", defaultValue="") String autographPhoto) {
        if (StringUtil.isEmpty((String)orderViewId)) {
            return this.returnFailure("\u53c2\u6570\u9519\u8beforderViewId:" + orderViewId);
        }
        if (StringUtil.isEmpty((String)autographPhoto)) {
            return this.returnFailure("\u53c2\u6570\u9519\u8befphotoReport:" + autographPhoto);
        }
        String key = orderViewId + "_autograph";
        this.jedisCluster.set(key, JSONObject.toJSONString((Object)autographPhoto));
        this.jedisCluster.expire(key, 259200);
        return this.returnSucceed("\u7b7e\u540d\u7167\u7247\u4fdd\u5b58");
    }

    @ApiOperation(value="\u83b7\u53d6\u7b7e\u540d\u7167\u7247")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderViewId", value="\u8ba2\u5355uuid", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/getAutographPhoto"})
    public ResultInfo getAutographPhoto(@RequestParam(value="orderViewId", defaultValue="") String orderViewId) {
        if (StringUtil.isEmpty((String)orderViewId)) {
            return this.returnFailure("\u53c2\u6570\u9519\u8beforderViewId:" + orderViewId);
        }
        String key = orderViewId + "_autograph";
        String autographPhoto = this.jedisCluster.get(key);
        return this.returnSucceed(autographPhoto);
    }
}

