/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.alibaba.excel.EasyExcel;
import com.byh.common.PageResult;
import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.vo.consultation.BillListQuery;
import com.byh.pojo.vo.consultation.BillListVo;
import com.byh.pojo.vo.consultation.DoctorBillVo;
import com.byh.pojo.vo.consultation.NewTransferVo;
import com.byh.pojo.vo.consultation.excel.BillDataInfoVO;
import com.byh.service.cosultation.DoctorBillInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/doctorbillinfo"})
@Api(tags={"\u533b\u751f\u8d26\u5355\u4fe1\u606f"})
public class DoctorBillInfoController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(DoctorBillInfoController.class);
    private static final Integer STATUS_VALID = 1;
    @Autowired
    private DoctorBillInfoService doctorBillInfoService;

    @ApiOperation(value="\u8d85\u7ba1\uff1a\u65b0\u5efa\u5212\u62e8")
    @PostMapping(value={"/addNewTransfer"})
    public ResultInfo<DoctorBillInfoEntity> addNewTransfer(@RequestBody NewTransferVo newTransferVo) {
        DoctorBillInfoEntity entity = this.doctorBillInfoService.addTransfer(newTransferVo);
        if (entity == null) {
            return this.returnFailure("\u5f85\u5212\u62e8\u7684\u4e1a\u52a1\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return this.returnSucceed((Object)entity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u8d85\u7ba1\uff1a\u83b7\u53d6\u603b\u8ba1\u5e26\u5212\u62e8\u91d1\u989d")
    @GetMapping(value={"/getMoneySum"})
    public ResultInfo<BigDecimal> getMoneySum(String userViewId) {
        BigDecimal moneySum = this.doctorBillInfoService.getMoneySum(userViewId);
        if (moneySum == null) {
            moneySum = BigDecimal.ZERO;
        }
        return this.returnSucceed((Object)moneySum, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u8d85\u7ba1\uff1a\u8d26\u5355\u7ba1\u7406__\u8d26\u5355\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/getBillQueryList"})
    public ResultInfo<PageResult<List<BillListVo>>> getBillQueryList(@RequestBody BillListQuery billListQuery) {
        billListQuery.setBillStatus(STATUS_VALID);
        billListQuery.setHasWithdraw(STATUS_VALID);
        return this.returnSucceed((Object)this.doctorBillInfoService.getListByCondition(billListQuery), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u8d85\u7ba1\uff1a\u533b\u751f\u6536\u5165__\u6761\u4ef6\u67e5\u8be2\u533b\u751f\u8d26\u5355\u5217\u8868")
    @PostMapping(value={"/getlist"})
    public ResultInfo<PageResult<List<BillListVo>>> getList(@RequestBody BillListQuery billListQuery) {
        return this.returnSucceed((Object)this.doctorBillInfoService.getListByCondition(billListQuery), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u8d85\u7ba1\uff1a\u533b\u751f\u8d26\u5355\u7ba1\u7406\uff0c\u53d1\u94b1\u64cd\u4f5c")
    @PostMapping(value={"/verify"})
    public ResultInfo getList(@RequestParam(value="billId") Long billId, @RequestParam(value="actualMoney") BigDecimal actualMoney, @RequestParam(value="auditor") String auditor) {
        int flag = this.doctorBillInfoService.updateStatus(billId, actualMoney, auditor);
        if (flag > 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u6dfb\u52a0\u4e00\u6761\u8d26\u5355\u4fe1\u606f(\u51fa\u5165\u53c2\u5355\u4f4d\u4e0e\u6570\u636e\u5e93\u4e00\u81f4)")
    @PostMapping(value={"/addone"})
    public ResultInfo<DoctorBillInfoEntity> addOne(@RequestBody DoctorBillVo doctorBillInfo) {
        DoctorBillInfoEntity doctorBillInfoEntity = this.doctorBillInfoService.addOne(doctorBillInfo);
        if (doctorBillInfoEntity == null) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed((Object)doctorBillInfoEntity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6dfb\u52a0\u533b\u751f\u8d26\u5355\u4fe1\u606f")
    @PostMapping(value={"/save"})
    public ResultInfo saveDoctorBillInfo(@RequestBody DoctorBillInfoEntity doctorBillInfo) {
        int insert = this.doctorBillInfoService.saveDoctorBillInfo(doctorBillInfo);
        if (insert != 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u8d26\u5355\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, dataType="Long", paramType="query")})
    @GetMapping(value={"/{id}"})
    public ResultInfo<DoctorBillInfoEntity> getDoctorBillInfo(@PathVariable Long id) {
        DoctorBillInfoEntity doctorBillInfo = this.doctorBillInfoService.getDoctorBillInfo(id);
        return this.returnSucceed((Object)doctorBillInfo, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u4fee\u6539\u533b\u751f\u8d26\u5355\u4fe1\u606f")
    @PostMapping(value={"/update"})
    public ResultInfo updateDoctorBillInfo(@RequestBody DoctorBillInfoEntity doctorBillInfo) {
        int update = this.doctorBillInfoService.updateDoctorBillInfo(doctorBillInfo);
        if (update != 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664\u533b\u751f\u8d26\u5355\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/delete"})
    public ResultInfo deleteDoctorBillInfo(@RequestParam(value="id", required=true) Long id) {
        int delete = this.doctorBillInfoService.deleteDoctorBillInfo(id);
        if (delete != 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u8d26\u5355\u5bfc\u51fa--\u533b\u751f\u6536\u5165")
    @GetMapping(value={"/bill"})
    public void bill(@RequestParam(value="ids") String ids, HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(Consts.UTF_8.name());
        String fileName = "";
        try {
            fileName = URLEncoder.encode("\u533b\u751f\u8d26\u5355\u4fe1\u606f" + System.currentTimeMillis(), Consts.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), BillDataInfoVO.class).sheet("\u533b\u751f\u8d26\u5355\u4fe1\u606f").doWrite(this.doctorBillInfoService.billDataInfoVOS(ids));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

