/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.OrderStatusEnum;
import com.byh.exception.PushInfoException;
import com.byh.manage.consultation.MyClinicManager;
import com.byh.manage.consultation.ProgramMessageManager;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.pojo.bo.consultation.AppointmentTimeConsultationDto;
import com.byh.pojo.bo.consultation.ConsulationEntityDto;
import com.byh.pojo.bo.consultation.OrderDetailDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u4f1a\u8bca\u5176\u4ed6\u4fe1\u606f\u63a5\u53e3")
@RestController
@RequestMapping(value={"/api/v1/MyClinic"})
public class MyClinicController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MyClinicController.class);
    private static String[] timeArray = new String[]{"08:00:00", "08:30:00", "09:00:00", "09:30:00", "10:00:00", "10:30:00", "11:00:00", "11:30:00", "12:00:00", "12:30:00", "13:00:00", "13:30:00", "14:00:00", "14:30:00", "15:00:00", "15:30:00", "16:00:00", "16:30:00", "17:00:00", "17:30:00", "18:00:00", "18:30:00", "19:00:00", "19:30:00", "20:00:00", "20:30:00", "21:00:00", "21:30:00", "22:00:00"};
    @Autowired
    private MyClinicManager myClinicManager;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ProgramMessageManager programMessageManager;

    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\u4f1a\u8bca\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="10", dataType="Integer", paramType="query"), @ApiImplicitParam(name="patientId", value="\u60a3\u8005id", dataType="Long", paramType="query"), @ApiImplicitParam(name="doctorId", value="\u533b\u751fid", dataType="Long", paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", dataType="Long", paramType="query"), @ApiImplicitParam(name="hosId", value="\u533b\u9662id", dataType="Long", paramType="query"), @ApiImplicitParam(name="search", value="\u6a21\u7cca\u5b57\u6bb5", dataType="string", paramType="query")})
    @GetMapping(value={"query_consultation_list_by_patient_id_and_hospital_id"})
    public ResultInfo<List<OrderDetailDto>> queryConsultationListByPatientIdAndHospitalId(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="patientId", required=false, defaultValue="0") Long patientId, @RequestParam(value="doctorId", required=false, defaultValue="0") Long doctorId, @RequestParam(value="userId", required=false, defaultValue="0") Long userId, @RequestParam(value="hosId", required=false, defaultValue="0") Long hosId, @RequestParam(value="search", required=false, defaultValue="") String search) {
        return this.myClinicManager.queryConsultationListByPatientIdAndHospitalId(pageIndex, pageSize, patientId, userId, hosId, doctorId, search);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bca\u8ba2\u5355\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="beginTime", value="\u5f00\u59cb\u65f6\u95f4", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="status", value="\u8ba2\u5355\u72b6\u6001", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="depName", value="\u79d1\u5ba4", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="search", value="", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"query_consultation_list"})
    public ResultInfo<List<ConsulationEntityDto>> queryConsultationList(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="status", required=false, defaultValue="") Integer status, @RequestParam(value="depName", required=false, defaultValue="") String depName, @RequestParam(value="search", required=false, defaultValue="") String search) {
        return this.myClinicManager.queryConsultationList(pageIndex, pageSize, beginTime, endTime, status, depName, search);
    }

    @ApiOperation(value="\u6839\u636e\u8ba2\u5355id\u4fee\u6539\u89c6\u9891\u9884\u7ea6\u65f6\u95f4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="consultationDate", value="\u89c6\u9891\u9884\u7ea6\u65e5\u671f", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="consultationTime", value="\u89c6\u9891\u9884\u7ea6\u65f6\u95f4", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"updateConsultationTimeByOrderId"})
    public ResultInfo updateConsultationTimeByOrderId(@RequestParam(value="id", required=true, defaultValue="") Long id, @RequestParam(value="consultationDate", required=true, defaultValue="") String consultationDate, @RequestParam(value="consultationTime", required=true, defaultValue="") String consultationTime) {
        if (id == null || id.intValue() == 0) {
            return this.returnFailure("\u8ba2\u5355id\u6709\u8bef");
        }
        if (consultationTime == null || consultationTime.isEmpty()) {
            return this.returnFailure("\u89c6\u9891\u9884\u7ea6\u65f6\u95f4\u6709\u8bef");
        }
        if (consultationDate == null || consultationDate.isEmpty()) {
            return this.returnFailure("\u89c6\u9891\u9884\u7ea6\u65e5\u671f\u6709\u8bef");
        }
        ConsultationEntity consultationEntity = this.myClinicManager.queryConsultationEntityById(id);
        if (consultationEntity == null) {
            return this.returnFailure("\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        int i = this.myClinicManager.updateConsultationTimeByOrderId(id, consultationTime, consultationDate);
        if (i > 0) {
            return this.returnSucceed("\u4fee\u6539\u6210\u529f");
        }
        return this.returnFailure("\u4fee\u6539\u5931\u8d25");
    }

    @ApiOperation(value="\u53d6\u6d88\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="closeId", value="\u5173\u95ed\u8005id", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="closeType", value="\u5173\u95ed\u8005\u7c7b\u578b", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="cancelReason", value="\u53d6\u6d88\u539f\u56e0", required=true, dataType="string", paramType="query")})
    @PostMapping(value={"updateOrderStatusByOrderIdAndClose"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo updateOrderStatusByOrderIdAndClose(@RequestParam(value="orderId", required=true, defaultValue="0") Long orderId, @RequestParam(value="closeId", required=true, defaultValue="0") Long closeId, @RequestParam(value="closeType", required=true, defaultValue="0") Integer closeType, @RequestParam(value="cancelReason", required=true, defaultValue="") String cancelReason) {
        log.info("====\u53d6\u6d88\u8ba2\u5355\u53c2\u6570===orderId:" + orderId + "=====closeId:" + closeId + "=======closeType:" + closeType + "======\u53d6\u6d88\u539f\u56e0:" + cancelReason);
        ConsultationEntity consultationEntity = this.myClinicManager.queryConsultationByOrerId(orderId);
        if (orderId.intValue() == 0 || consultationEntity == null) {
            return this.returnFailure("\u8ba2\u5355id\u6709\u8bef");
        }
        if (closeId.intValue() == 0 || closeType == 0 || StringUtil.isEmpty((String)cancelReason)) {
            return this.returnFailure("\u53d6\u6d88\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        if (consultationEntity.getStatus() < OrderStatusEnum.RUNNING.getValue()) {
            String closeTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            int i = this.myClinicManager.updateOrderStatusByOrderIdAndClose(orderId, closeTime);
            int j = this.consultationExtendService.updateCloseIdAndCloseTypeAndCloseReason(closeId, closeType, cancelReason, orderId);
            if (i > 0) {
                try {
                    this.shortMessageManager.cancelConsultationApply(consultationEntity.getViewId(), cancelReason);
                    this.shortMessageManager.cancelConsultationToDoctor(consultationEntity.getViewId());
                    this.webAndAppMessageManager.cancellationOfConsultationSendMessage(consultationEntity, cancelReason);
                    ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(orderId);
                    this.programMessageManager.cancelOrderPush(consultationEntity, consultationExtendEntity, closeTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return this.returnSucceed("\u4fee\u6539\u6210\u529f");
            }
            return this.returnFailure("\u4fee\u6539\u5931\u8d25");
        }
        if (consultationEntity.getStatus().intValue() == OrderStatusEnum.CANCEL.getValue().intValue()) {
            return this.returnFailure("\u6539\u8ba2\u5355\u5df2\u53d6\u6d88,\u8bf7\u52ff\u91cd\u590d\u53d6\u6d88");
        }
        return this.returnFailure("\u8fdb\u884c\u4e2d\u6216\u5df2\u5b8c\u6210\u7684\u8ba2\u5355\u4e0d\u80fd\u53d6\u6d88");
    }

    @ApiOperation(value="\u9884\u7ea6\u4f1a\u8bca\u65f6\u95f4\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="expertId", value="\u63a5\u8bca\u533b\u751fid", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="consultationDate", value="\u89c6\u9891\u9884\u7ea6\u65e5\u671f", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"queryConsultationDateByExpertId"})
    public ResultInfo<List<AppointmentTimeConsultationDto>> queryConsultationDateByExpertId(@RequestParam(value="expertId", required=true, defaultValue="") Long expertId, @RequestParam(value="consultationDate", required=true, defaultValue="") String consultationDate) {
        if (expertId == null || expertId.intValue() == 0) {
            return this.returnFailure("\u4f20\u5165\u7684\u63a5\u8bca\u533b\u751fid\u6709\u8bef");
        }
        if (consultationDate == null || consultationDate.isEmpty()) {
            return this.returnFailure("\u4f20\u5165\u7684\u89c6\u9891\u9884\u7ea6\u65e5\u671f\u6709\u8bef");
        }
        ArrayList list = new ArrayList();
        List<String> timeList = Arrays.asList(timeArray);
        for (String time : timeList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int count = this.myClinicManager.queryCountConsultationDateByExpertId(expertId, consultationDate, time);
            map.put("consultationTime", time);
            map.put("total", count);
            list.add(map);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @ApiOperation(value="\u9884\u7ea6\u4f1a\u8bca\u65f6\u95f4\u5217\u8868\u65e5\u671f")
    @PostMapping(value={"GetDates"})
    public ResultInfo<ArrayList<String>> queryConsultationDateByExpertIdAndCon() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i <= 6; ++i) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            int day = c.get(5);
            c.set(5, day + i);
            String dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
            list.add(dayAfter);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }
}

