/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.manage.consultation.TRTCManage;
import com.byh.pojo.bo.video.VideoNotify;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationTranscodeVideoEntity;
import com.byh.pojo.entity.consultation.ConsultationVedioEntity;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ConsultationTranscodeVideoService;
import com.byh.service.cosultation.ConsultationVedioService;
import com.byh.util.DateTimeUtil;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.rabbitmq.client.Channel;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskResult;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskTranscodeResult;
import com.tencentcloudapi.vod.v20180717.models.ProcedureTask;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tencent/rtc"})
public class TRTCController {
    private static final Logger log = LoggerFactory.getLogger(TRTCController.class);
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private ConsultationVedioService consultationVedioService;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ConsultationTranscodeVideoService consultationTranscodeVideoService;

    @GetMapping(value={"/index"})
    public BaseResponse<String> stringBaseResponse(@RequestParam(value="orderId") Long orderId) {
        this.trtcManage.saveRtcRoomId(orderId);
        return BaseResponse.success((Object)"\u6210\u529f");
    }

    @RabbitListener(queues={"video.queue"})
    public void listenVideo(Message message, Channel channel) {
        try {
            String videoMsg = new String(message.getBody());
            log.info("=========\u8fdb\u5165\u89c6\u9891\u56de\u8c03========" + videoMsg);
            if (StringUtil.isNotEmpty((String)videoMsg)) {
                VideoNotify videoNotify = (VideoNotify)JSONObject.parseObject((String)videoMsg, VideoNotify.class);
                String orderViewId = videoNotify.getTreatmentId();
                ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                if (consultationEntity != null && consultationExtendEntity != null) {
                    ConsultationVedioEntity consultationVedio = this.consultationVedioService.getByVedioUrl(videoNotify.getVideoUrl());
                    consultationExtendEntity.setVideoUrl(videoNotify.getVideoUrl());
                    if (consultationVedio == null) {
                        long startTimeSeconed = videoNotify.getStartTime();
                        long endTimeSeconed = videoNotify.getEndTime();
                        String startTime = DateTimeUtil.formatTime((Date)new Date(startTimeSeconed * 1000L), (String)"yyyy-MM-dd HH:mm:ss");
                        String endTime = DateTimeUtil.formatTime((Date)new Date(endTimeSeconed * 1000L), (String)"yyyy-MM-dd HH:mm:ss");
                        ConsultationVedioEntity consultationVedioEntity = new ConsultationVedioEntity();
                        consultationVedioEntity.setStatus(Integer.valueOf(1));
                        consultationVedioEntity.setVedioUrl(videoNotify.getVideoUrl());
                        consultationVedioEntity.setConsultationType(consultationEntity.getType().intValue());
                        consultationVedioEntity.setViewId(UuidUtils.generateUUID());
                        long duration = endTimeSeconed - startTimeSeconed;
                        consultationVedioEntity.setDuration(Long.valueOf(duration));
                        consultationVedioEntity.setStartTime(startTime);
                        consultationVedioEntity.setEndTime(endTime);
                        consultationVedioEntity.setConsultationId(consultationEntity.getId());
                        this.consultationVedioService.insertConsultationVedio(consultationVedioEntity);
                    }
                    this.consultationService.updateConsultationEntity(consultationEntity);
                    this.consultationExtendService.update(consultationExtendEntity);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/transcodingCallback"}, method={RequestMethod.GET, RequestMethod.POST})
    public void transcodingCallback(@RequestBody JSONObject jsonObject) {
        log.info("====\u8fdb\u5165\u4e86\u52a0\u6c34\u5370\u7684\u89c6\u9891\u8f6c\u7801\u7684\u56de\u8c03=====");
        log.info("====data\u662f:" + jsonObject.toString());
    }

    @PostMapping(value={"/invokeProcessVideo"})
    public BaseResponse<String> invokeProcessVideo(@RequestParam(value="orderViewId", defaultValue="") String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
        ConsultationTranscodeVideoEntity consultationTranscodeVideoEntity = this.consultationTranscodeVideoService.getByOrderViewIdAndOrderType(orderViewId, consultationEntity.getType());
        if (consultationEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u8ba2\u5355\u7f16\u53f7\u662f\u5426\u6b63\u786e");
        }
        if (consultationTranscodeVideoEntity != null) {
            return BaseResponse.error((String)"\u6b63\u5728\u8f6c\u7801\u4e2d\uff0c\u8bf7\u60a8\u7a0d\u540e\u4e0b\u8f7d");
        }
        return this.trtcManage.invokeProcessMedia(consultationEntity);
    }

    @RequestMapping(value={"/callBack/processvideo"}, method={RequestMethod.GET, RequestMethod.POST})
    public void callBackProcessVideo(@RequestBody JSONObject jsonObject) {
        log.info("\u8fdb\u5165\u8f6c\u7801\u56de\u8c03,\u56de\u8c03\u4fe1\u606f\u662f:{}", (Object)jsonObject.toJSONString());
        String eventType = jsonObject.getString("EventType");
        String procedureTaskStr = JSONObject.toJSONString((Object)jsonObject.getJSONObject("ProcedureStateChangeEvent"));
        ProcedureTask procedureTask = (ProcedureTask)JSONObject.parseObject((String)procedureTaskStr, ProcedureTask.class);
        if ("ProcedureStateChanged".equalsIgnoreCase(eventType) && "FINISH".equalsIgnoreCase(procedureTask.getStatus()) && procedureTask.getMediaProcessResultSet() != null) {
            MediaProcessTaskResult[] mediaProcessTaskResults;
            log.info("======>\u786e\u8ba4\u662f\u89c6\u9891\u8f6c\u7801\u56de\u8c03");
            String videoUrl = "";
            Long duration = 0L;
            String fileId = procedureTask.getFileId();
            ConsultationTranscodeVideoEntity videoEntity = this.consultationTranscodeVideoService.getByFileId(fileId);
            for (MediaProcessTaskResult mediaProcessTaskResult : mediaProcessTaskResults = procedureTask.getMediaProcessResultSet()) {
                if (!"Transcode".equalsIgnoreCase(mediaProcessTaskResult.getType())) continue;
                MediaProcessTaskTranscodeResult mediaProcessTaskTranscodeResult = mediaProcessTaskResult.getTranscodeTask();
                videoUrl = mediaProcessTaskTranscodeResult.getOutput().getUrl();
                duration = mediaProcessTaskTranscodeResult.getOutput().getDuration().longValue();
                break;
            }
            this.consultationTranscodeVideoService.updateVideoTypeAndUrlAndDuration("mp4", videoUrl, duration, videoEntity.getId());
        }
    }
}

