/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.patient;

import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.entity.patient.PatientSurgeryInfoEntity;
import com.byh.service.patient.PatientSurgeryInfoService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u60a3\u8005\u624b\u672f\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/api/v1/patient_surgery_info"})
public class PatientSurgeryInfoController {
    private static final Logger log = LoggerFactory.getLogger(PatientSurgeryInfoController.class);
    @Autowired
    PatientSurgeryInfoService patientSurgeryInfoService;

    @ApiOperation(value="\u4fdd\u5b58\u60a3\u8005\u624b\u672f\u4fe1\u606f")
    @PostMapping(value={"save_patient_surgery_info"})
    public BaseResponse<Long> save(@RequestBody PatientSurgeryInfoEntity patientSurgeryInfoEntity) {
        log.info("\u53c2\u6570\uff1a" + patientSurgeryInfoEntity.toString());
        Long count = this.patientSurgeryInfoService.savePatientSurgeryInfo(patientSurgeryInfoEntity);
        if (count > 0L) {
            return BaseResponse.success((Object)patientSurgeryInfoEntity.getId());
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u4fdd\u5b58\u60a3\u8005\u624b\u672f\u4fe1\u606f")
    @PostMapping(value={"save_patient_surgery_info_list"})
    public BaseResponse<List<Long>> saveList(@RequestBody List<PatientSurgeryInfoEntity> patientSurgeryInfoEntity) {
        log.info("\u53c2\u6570\uff1a" + patientSurgeryInfoEntity.toString());
        ArrayList<Long> ids = new ArrayList<Long>();
        Long count = 0L;
        for (PatientSurgeryInfoEntity patientSurgeryInfoEntity1 : patientSurgeryInfoEntity) {
            Long count1 = this.patientSurgeryInfoService.savePatientSurgeryInfo(patientSurgeryInfoEntity1);
            count = count + count1;
            ids.add(patientSurgeryInfoEntity1.getId());
        }
        if (count > 0L) {
            return BaseResponse.success(ids);
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u66f4\u65b0\u60a3\u8005\u624b\u672f\u4fe1\u606f")
    @PostMapping(value={"update_patient_surgery_info"})
    public BaseResponse update(@RequestBody PatientSurgeryInfoEntity patientSurgeryInfoEntity) {
        log.info("\u53c2\u6570\uff1a" + patientSurgeryInfoEntity.toString());
        Long count = this.patientSurgeryInfoService.updatePatientSurgeryInfo(patientSurgeryInfoEntity);
        if (count > 0L) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u60a3\u8005\u624b\u672f\u4fe1\u606f")
    @GetMapping(value={"find_patient_surgery_info_by_id"})
    public BaseResponse<PatientSurgeryInfoEntity> findPatientSurgeryInfoById(@RequestParam(value="id") Long id) {
        log.info("\u53c2\u6570\uff1a" + id);
        PatientSurgeryInfoEntity patientSurgeryInfoEntity = this.patientSurgeryInfoService.findPatientSurgeryInfoById(id);
        return BaseResponse.success((Object)patientSurgeryInfoEntity);
    }

    @ApiOperation(value="\u6839\u636e\u591a\u4e2aid\u67e5\u8be2\u60a3\u8005\u624b\u672f\u4fe1\u606f\u5217\u8868")
    @PostMapping(value={"find_patient_surgery_info_list_by_ids"})
    public BaseResponse<List<PatientSurgeryInfoEntity>> findPatientSurgeryInfoListByIds(@RequestBody List<Long> ids) {
        log.info("\u53c2\u6570\uff1a" + ids.toString());
        List patientSurgeryInfoEntity = this.patientSurgeryInfoService.findPatientSurgeryInfoListByIds(ids);
        return BaseResponse.success((Object)patientSurgeryInfoEntity);
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u60a3\u8005\u624b\u672f\u4fe1\u606f")
    @PostMapping(value={"delete_patient_surgery_info_by_id"})
    public BaseResponse deletePatientSurgeryInfoById(@RequestParam(value="id") Long id) {
        log.info("\u53c2\u6570\uff1a" + id);
        Long count = this.patientSurgeryInfoService.deletePatientSurgeryInfoById(id);
        if (count > 0L) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
    }
}

