/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.superadmin;

import com.byh.pojo.entity.superadmin.AppVersionEntity;
import com.byh.service.superadmin.AppVersionService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7248\u672c\u63a7\u5236"})
@RestController
@RequestMapping(value={"/api/v1/app_version"})
public class AppVersionController {
    @Autowired
    AppVersionService appVersionService;

    @ApiOperation(value="\u6839\u636e\u5e73\u53f0\u67e5\u8be2\u6700\u65b0\u4e00\u6761\u7248\u672c\u4fe1\u606f")
    @GetMapping(value={"/get/latestbyplatform"})
    public BaseResponse<AppVersionEntity> getAppVersionById(@RequestParam(value="platform") String platform) {
        AppVersionEntity appVersionEntity = this.appVersionService.getLatestByPlatform(platform);
        return BaseResponse.success((Object)appVersionEntity);
    }

    @ApiOperation(value="\u6839\u636ename\u67e5\u8be2\u7248\u672c\u63a7\u5236")
    @GetMapping(value={"/get/byname"})
    public BaseResponse<AppVersionEntity> getAppVersionByName(@RequestParam(value="versionName") String versionName) {
        AppVersionEntity appVersionEntity = this.appVersionService.getAppVersionByName(versionName);
        return BaseResponse.success((Object)appVersionEntity);
    }

    @ApiOperation(value="\u6dfb\u52a0\u7248\u672c\u63a7\u5236")
    @PostMapping(value={"/insert"})
    public BaseResponse insertAppVersion(@RequestBody AppVersionEntity appVersionEntity) {
        this.appVersionService.insertAppVersion(appVersionEntity);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u7248\u672c\u63a7\u5236")
    @PostMapping(value={"/update"})
    public BaseResponse updateAppVersion(@RequestBody AppVersionEntity appVersionEntity) {
        this.appVersionService.updateAppVersion(appVersionEntity);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u5065\u5220\u9664\u7248\u672c\u63a7\u5236")
    @GetMapping(value={"/delete/byid"})
    public BaseResponse deleteAppVersionById(@RequestParam(value="id") Long id) {
        this.appVersionService.deleteAppVersionById(id);
        return BaseResponse.success();
    }
}

