/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.superadmin;

import com.byh.enums.ErrorEnum;
import com.byh.exception.LoginException;
import com.byh.pojo.entity.superadmin.SuperAdminUserEntity;
import com.byh.service.superadmin.SuperAdminService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/super_admin"})
public class SuperAdminController {
    private static final Logger log = LoggerFactory.getLogger(SuperAdminController.class);
    @Autowired
    private SuperAdminService adminService;

    @PostMapping(value={"/login"})
    public BaseResponse<SuperAdminUserEntity> login(@RequestParam(value="userName") String userName, @RequestParam(value="password") String password) {
        SuperAdminUserEntity superAdminUserEntity = null;
        try {
            superAdminUserEntity = this.adminService.login(userName, password);
        }
        catch (LoginException e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)superAdminUserEntity);
    }

    @PostMapping(value={"/validate_token"})
    public BaseResponse validateToken(@RequestParam(value="token") String token) {
        try {
            this.adminService.validateToken(token);
        }
        catch (LoginException e) {
            e.printStackTrace();
            return BaseResponse.error((IError)ErrorEnum.NO_PERMISSION, (String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @PostMapping(value={"/logout"})
    public BaseResponse logout(@RequestParam(value="viewId") String viewId) {
        this.adminService.logout(viewId);
        return BaseResponse.success();
    }
}

