/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.common.ResultInfo;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.DoctorServiceEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.PatientSignerRelationshipEnum;
import com.byh.enums.PayStateEnum;
import com.byh.enums.PayTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.ICloudAccountApiClient;
import com.byh.feign.IDoctorApiClient;
import com.byh.feign.IOssApiClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.pojo.bo.PatientCaseInfoDTO;
import com.byh.pojo.bo.consultation.HosManageOrderDto;
import com.byh.pojo.bo.consultation.NormalImagesDto;
import com.byh.pojo.bo.consultation.OrderDetailDto;
import com.byh.pojo.bo.consultation.PatientInfoDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceMemberEntity;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceServiceEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.consultation.AppOrderListVo;
import com.byh.pojo.vo.consultation.ConsultationPatientCaseInfoVO;
import com.byh.pojo.vo.consultation.ConsultationVO;
import com.byh.pojo.vo.consultation.DataManagerVo;
import com.byh.pojo.vo.consultation.ImproveOrderResVO;
import com.byh.pojo.vo.consultation.OrganizationResVO;
import com.byh.pojo.vo.consultation.TransferReqVO;
import com.byh.pojo.vo.consultation.TransferResVO;
import com.byh.pojo.vo.consultation.WechatConsultationVO;
import com.byh.pojo.vo.consultation.excel.ConsultationDataInfoVO;
import com.byh.pojo.vo.consultation.res.DepartmentResVO;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.pojo.vo.consultation.res.StandDeptInfoResVO;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.remotecall.DepartMentInfoRemote;
import com.byh.remotecall.IhosBaseDataRemote;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.healthalliace.HealthAllianceMemberService;
import com.byh.service.healthalliace.HealthAllianceServiceService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.DateTimeUtil;
import com.byh.util.HttpUtils;
import com.byh.util.StringUtil;
import com.byh.util.UniqueKeyGenerator;
import com.doctoruser.api.pojo.dto.doctor.QueryPiontServiceDTO;
import com.doctoruser.api.pojo.vo.OssFileVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.PointDoctorServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultationManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ConsultationManager.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private DepartMentInfoRemote departMentInfoRemote;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private IOssApiClient iOssApiClient;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private HealthAllianceServiceService healthAllianceServiceService;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private HealthAllianceMemberService healthAllianceMemberService;
    @Autowired
    private ICloudAccountApiClient iCloudAccountApiClient;
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private IhosBaseDataRemote ihosBaseDataRemote;

    public int getApplyCountByDoctorId(Long doctorId, int status) {
        return this.consultationService.getApplyCountByDoctorId(doctorId, status);
    }

    public int getDoctorConsultationCount(Long doctorId, Integer status) {
        return this.consultationService.getDoctorConsultationCount(doctorId, status);
    }

    public Map<String, String> saveConsultation(ConsultationVO consultationVO) {
        BaseResponse expertAuditVOBaseResponse;
        log.info("\u4e0b\u5355\u65f6\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)consultationVO.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationVO.getDoctorId());
        BaseResponse doctorAuditVOBaseResponse = this.iCloudAccountApiClient.getSecondAudit(consultationVO.getDoctorId().toString());
        if (doctorAuditVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && doctorAuditVOBaseResponse.getData() != null) {
            map.put("code", ReturnCodeEnum.FAILURE.getValue());
            map.put("msg", "\u6b64\u966a\u8bca\u533b\u751f\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4e0b\u5355!");
            return map;
        }
        if ((consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() || consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_EXPERT.intValue()) && (expertAuditVOBaseResponse = this.iCloudAccountApiClient.getSecondAudit(consultationVO.getExpertId().toString())).getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && expertAuditVOBaseResponse.getData() != null) {
            map.put("code", ReturnCodeEnum.FAILURE.getValue());
            map.put("msg", "\u6b64\u63a5\u8bca\u4e13\u5bb6\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4e0b\u5355!");
            return map;
        }
        String doctorDeptName = doctorEntityInfoVO.getHospitalDeptName();
        String doctorHosName = this.remoteManage.getHospitalDetailById(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue())).getOrganName();
        PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
        patientCaseInfoVO.setUserId(Long.valueOf(0L));
        patientCaseInfoVO.setMainSuit(consultationVO.getMainSuit() != null ? consultationVO.getMainSuit() : "");
        if (CollectionUtils.isNotEmpty((Collection)consultationVO.getOssFileIds())) {
            List list = consultationVO.getOssFileIds();
            ArrayList<String> strings = new ArrayList<String>();
            for (Long aLong : list) {
                strings.add(aLong.toString());
            }
            String normalImages = String.join((CharSequence)",", strings);
            patientCaseInfoVO.setNormalImages(normalImages);
        }
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationVO.getPatientId(), Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        patientCaseInfoVO.setPastHistory(consultationVO.getPastHistory());
        patientCaseInfoVO.setPresentHistory(consultationVO.getPresentHistory());
        patientCaseInfoVO.setHospitalId(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        patientCaseInfoVO.setPrimaryDiagno(consultationVO.getPrimaryDiagno() != null ? consultationVO.getPrimaryDiagno() : "");
        patientCaseInfoVO.setConsultAim(consultationVO.getConsultAim() != null ? consultationVO.getConsultAim() : "");
        patientCaseInfoVO.setPatientViewId(consultationVO.getPatientId().toString());
        patientCaseInfoVO.setPatientName(patientInfoRespVO.getName());
        patientCaseInfoVO.setDoctorId(consultationVO.getDoctorId());
        patientCaseInfoVO.setDoctorName(doctorEntityInfoVO.getName());
        patientCaseInfoVO.setCaseType(PatientCaseInfoDTO.CONSULTATION_TYPE);
        patientCaseInfoVO.setHospitalName(doctorHosName);
        patientCaseInfoVO.setDeptDetailName(doctorDeptName);
        patientCaseInfoVO.setFamilyHistory(StringUtil.isNotEmpty((String)consultationVO.getFamilyHistory()) ? consultationVO.getFamilyHistory() : "");
        patientCaseInfoVO.setMedicationHistory(StringUtil.isNotEmpty((String)consultationVO.getMedicationHistory()) ? consultationVO.getMedicationHistory() : "");
        PatientCaseInfoVO caseInfoVO = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
        ConsultationEntity consultationEntity = new ConsultationEntity();
        ConsultationExtendEntity consultationExtendEntity = new ConsultationExtendEntity();
        BeanUtils.copyProperties((Object)consultationVO, (Object)consultationEntity);
        consultationEntity.setCaseId(caseInfoVO.getId());
        String orderViewId = UniqueKeyGenerator.generateViewId().toString();
        consultationEntity.setViewId(orderViewId);
        consultationEntity.setDoctorId(consultationVO.getDoctorId());
        consultationExtendEntity.setPatientSex(consultationVO.getSex());
        consultationExtendEntity.setPatientIdCard(consultationVO.getIdcard());
        consultationExtendEntity.setPatientPhone(consultationVO.getMobileNumber());
        LocalDate today = LocalDate.now();
        LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(consultationVO.getAge()));
        Long age = ChronoUnit.YEARS.between(birthday, today);
        consultationExtendEntity.setPatientAge(Integer.valueOf(age.intValue()));
        BigDecimal price = null;
        if (consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() || consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_EXPERT.intValue()) {
            Integer serviceId = 0;
            serviceId = consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() ? (consultationVO.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_HOSPITAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_HOSPITAL.getValue()) : (consultationVO.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_PERSERNAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_PERSONAL.getValue());
            DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationVO.getExpertId());
            consultationEntity.setServiceCode(serviceId);
            consultationEntity.setExpertName(expertDetailInfoEntity.getName());
            consultationEntity.setExpertHospitalId(Long.valueOf(expertDetailInfoEntity.getOrganId().longValue()));
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(expertDetailInfoEntity.getOrganId());
            consultationExtendEntity.setClinicalAppCode(expertAppCode);
            consultationEntity.setExpertId(consultationVO.getExpertId());
            consultationExtendEntity.setExpertPhone(expertDetailInfoEntity.getRegisterMobile());
            consultationEntity.setExpertType(expertDetailInfoEntity.getDoctorType());
            String expertHosName = this.remoteManage.getHospitalDetailById(Long.valueOf(expertDetailInfoEntity.getOrganId().longValue())).getOrganName();
            consultationEntity.setExpertHosName(expertHosName);
            if (consultationVO.getDeptType().intValue() == ConsultationConstant.TYPE_DEPT_STANDARD.intValue()) {
                StandDeptInfoResVO standDeptInfoVO = this.departMentInfoRemote.getStandDeptDetailId(consultationVO.getDeptId(), Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
                consultationEntity.setExpertDeptName(standDeptInfoVO.getDisplayName());
            } else {
                consultationEntity.setExpertDeptName(expertDetailInfoEntity.getHospitalDeptName());
            }
            BigDecimal accompanyFee = BigDecimal.ZERO;
            BigDecimal amissionFee = BigDecimal.ZERO;
            BigDecimal baiyihuiFee = BigDecimal.ZERO;
            if (consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() || consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_EXPERT.intValue()) {
                ArrayList<QueryPiontServiceDTO> queryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
                QueryPiontServiceDTO expertPiontService = new QueryPiontServiceDTO();
                expertPiontService.setDoctorId(Integer.valueOf(consultationEntity.getExpertId().intValue()));
                expertPiontService.setServiceCode(consultationEntity.getServiceCode().toString());
                queryPiontServiceDTOS.add(expertPiontService);
                List infoVOS = this.remoteManage.queryDoctorServiceInfo(queryPiontServiceDTOS);
                amissionFee = ((PointDoctorServiceInfoVO)infoVOS.get(0)).getPrice();
                log.info("\u63a5\u8bca\u8d39\u8fd4\u56de\u7684\u4ef7\u683c\u662f:{}", (Object)infoVOS.toString());
                Integer surgeryType = OrderTypeEnum.getByValue((Integer)consultationEntity.getType()).getValue().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) ? DoctorServiceEnum.CONSULTATION_VEDIO_SURGERY.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_SURGERY.getValue();
                ArrayList<QueryPiontServiceDTO> doctorQueryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
                QueryPiontServiceDTO doctorPiontService = new QueryPiontServiceDTO();
                doctorPiontService.setDoctorId(Integer.valueOf(consultationEntity.getDoctorId().intValue()));
                doctorPiontService.setServiceCode(surgeryType.toString());
                doctorQueryPiontServiceDTOS.add(doctorPiontService);
                List doctorInfoVOS = this.remoteManage.queryDoctorServiceInfo(doctorQueryPiontServiceDTOS);
                log.info("\u966a\u8bca\u8d39\u8fd4\u56de\u7684\u4ef7\u683c\u662f:{}", (Object)doctorInfoVOS.toString());
                accompanyFee = doctorInfoVOS.isEmpty() || doctorInfoVOS.get(0) == null ? new BigDecimal(0) : ((PointDoctorServiceInfoVO)doctorInfoVOS.get(0)).getPrice();
            }
            consultationExtendEntity.setAccompanyFee(accompanyFee);
            consultationExtendEntity.setAmissionFee(amissionFee);
            consultationExtendEntity.setServiceFee(baiyihuiFee);
            price = amissionFee.add(accompanyFee).add(baiyihuiFee);
            log.info("\u6b63\u5728\u8fdb\u884cweb\u6216app\u4e0b\u5355========>\u966a\u8bca\u8d39:{}=====\u63a5\u8bca\u8d39\u662f:{}====\u4f70\u533b\u6c47\u5e73\u53f0\u670d\u52a1\u8d39\u662f:{}", new Object[]{accompanyFee, amissionFee, baiyihuiFee});
            consultationExtendEntity.setPrice(price);
            consultationEntity.setExpertDepId(consultationVO.getDeptId());
            this.dataDaily(consultationEntity, consultationExtendEntity, doctorEntityInfoVO, expertDetailInfoEntity);
        } else {
            if (consultationVO.getDeptType().intValue() == ConsultationConstant.TYPE_DEPT_STANDARD.intValue()) {
                StandDeptInfoResVO standDeptInfoVO = this.departMentInfoRemote.getStandDeptDetailId(consultationVO.getDeptId(), Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
                consultationEntity.setExpertDeptName(standDeptInfoVO.getDisplayName());
            } else {
                QueryOrganDetailVO queryOrganDetailVO = this.remoteManage.getHospitalDetailById(consultationVO.getExpertHospitalId());
                consultationEntity.setExpertHospitalId(consultationVO.getExpertHospitalId());
                consultationEntity.setExpertHosName(queryOrganDetailVO.getOrganName());
                DepartmentResVO hosDeptInfo = this.departMentInfoRemote.getHosDeptDetailId(consultationVO.getDeptId(), consultationVO.getExpertHospitalId());
                log.info("=====\u4e0b\u5355\u53d6\u5230\u7684\u533b\u9662\u79d1\u5ba4\u4fe1\u606f\u662f:{}====\u79d1\u5ba4\u540d\u79f0\u662f:{}", (Object)hosDeptInfo.toString(), (Object)hosDeptInfo.getDeptName());
                consultationEntity.setExpertDeptName(hosDeptInfo.getDeptName());
            }
            price = BigDecimal.ZERO;
            consultationExtendEntity.setPrice(price);
        }
        if (StringUtil.isNotBlank((String)consultationVO.getDcmFileUrl())) {
            consultationExtendEntity.setDcmFileUrl(consultationVO.getDcmFileUrl());
        }
        consultationEntity.setExpertDepId(consultationVO.getDeptId());
        consultationEntity.setDeptType(consultationVO.getDeptType());
        consultationEntity.setStatus(OrderStatusEnum.WAIT_PATIENT_SIGN.getValue());
        consultationEntity.setDoctorName(doctorEntityInfoVO.getName());
        consultationExtendEntity.setDoctorPhone(doctorEntityInfoVO.getRegisterMobile());
        consultationEntity.setDoctorDepName(doctorDeptName);
        consultationEntity.setDoctorHosName(doctorHosName);
        consultationEntity.setDoctorDepId(Long.valueOf(doctorEntityInfoVO.getHospitalDeptId().longValue()));
        consultationEntity.setDoctorHospitalId(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        String accompanyAppCode = this.remoteManage.getAppCodeByHospitalId(doctorEntityInfoVO.getOrganId());
        consultationEntity.setAccompanyAppCode(accompanyAppCode);
        consultationEntity.setPatientName(patientInfoRespVO.getName());
        consultationExtendEntity.setInitiatorType(consultationVO.getInitiatorType());
        consultationExtendEntity.setDcmPackUrl(consultationVO.getDcmPackUrl());
        consultationExtendEntity.setPatientNo(consultationVO.getPatientNo());
        ConsultationEntity consultation = this.consultationService.saveConsultation(consultationEntity);
        consultationExtendEntity.setConsultationId(consultation.getId());
        consultationExtendEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
        ConsultationExtendEntity extendEntity = this.consultationExtendService.insert(consultationExtendEntity);
        if (consultation.getId() != null && extendEntity.getId() != null) {
            map.put("code", ReturnCodeEnum.SUCCEED.getValue());
            map.put("msg", ReturnCodeEnum.SUCCEED.getDisplay());
            map.put("viewId", orderViewId);
        }
        return map;
    }

    public ConsultationEntity queryConsultationEntityById(Long id) {
        return this.consultationService.queryConsultationEntityById(id);
    }

    public ConsultationEntity getByViewId(String viewId) {
        return this.consultationService.selectByViewId(viewId);
    }

    public int updateConsultation(ConsultationEntity consultationEntity) {
        return this.consultationService.updateConsultationEntity(consultationEntity);
    }

    public ResultInfo<List<HosManageOrderDto>> queryConsultationListByDoctorId(Integer pageIndex, Integer pageSize, Long doctorId, String beginTime, String endTime, Integer type, Integer status, Integer isSponsor, String search) {
        List consultationEntityList;
        ArrayList<HosManageOrderDto> list = new ArrayList<HosManageOrderDto>();
        int total = 0;
        if (!beginTime.equals("")) {
            beginTime = beginTime + " 00:00:00";
        }
        if (!endTime.equals("")) {
            endTime = endTime + " 23:59:59";
        }
        if (isSponsor == 1) {
            PageHelper.startPage((int)pageIndex, (int)pageSize);
            consultationEntityList = this.consultationService.queryConsultationEntityByDoctorId(doctorId, beginTime, endTime, type, status, search);
            total = this.consultationService.queryConsultationEntityByDoctorId(doctorId, beginTime, endTime, type, status, search).size();
        } else {
            PageHelper.startPage((int)pageIndex, (int)pageSize);
            consultationEntityList = this.consultationService.queryConsultationEntityByExpertId(doctorId, beginTime, endTime, type, status, search);
            total = this.consultationService.queryConsultationEntityByExpertId(doctorId, beginTime, endTime, type, status, search).size();
        }
        if (CollectionUtils.isEmpty((Collection)consultationEntityList)) {
            return this.returnSucceed(null);
        }
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            ConsultationReportEntity consultationReport;
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            HosManageOrderDto hosManageOrderDto = new HosManageOrderDto();
            hosManageOrderDto.setOrderId(consultationEntity.getId());
            hosManageOrderDto.setOrderCreateTime(consultationEntity.getCreateTime().toString());
            String format = DateTimeUtil.formatTime((Date)consultationEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            hosManageOrderDto.setOrderCreateTimeStr(format);
            hosManageOrderDto.setOrderViewId(consultationEntity.getViewId());
            hosManageOrderDto.setOrderStatus(consultationEntity.getStatus());
            hosManageOrderDto.setOrderType(consultationEntity.getType());
            hosManageOrderDto.setConsultationDate(consultationEntity.getConsultationDate());
            hosManageOrderDto.setConsultationTime(consultationEntity.getConsultationTime());
            hosManageOrderDto.setBeginTime(consultationEntity.getBeginTime());
            hosManageOrderDto.setFinishTime(consultationEntity.getFinishTime());
            hosManageOrderDto.setAcceptTime(consultationEntity.getAcceptTime());
            hosManageOrderDto.setOrderPrice(consultationExtendEntity.getPrice());
            hosManageOrderDto.setOrderNum(Integer.valueOf(total));
            hosManageOrderDto.setPatientId(consultationEntity.getPatientId());
            hosManageOrderDto.setPatientName(consultationEntity.getPatientName());
            hosManageOrderDto.setPatientSex(consultationExtendEntity.getPatientSex());
            hosManageOrderDto.setPatientAge(consultationExtendEntity.getPatientAge());
            hosManageOrderDto.setDocId(consultationEntity.getDoctorId());
            hosManageOrderDto.setDocName(consultationEntity.getDoctorName());
            hosManageOrderDto.setDocDepName(consultationEntity.getDoctorDepName());
            hosManageOrderDto.setDocHosName(consultationEntity.getDoctorHosName());
            hosManageOrderDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
            hosManageOrderDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
            hosManageOrderDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
            hosManageOrderDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
            if (consultationEntity.getStatus().intValue() == OrderStatusEnum.FINISH.getValue().intValue() && (consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) != null && consultationReport.getStatus() == 1) {
                hosManageOrderDto.setIsReport(Integer.valueOf(1));
            }
            hosManageOrderDto.setPatientTel(consultationExtendEntity.getPatientPhone());
            String mainSuit = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId()).getMainSuit();
            hosManageOrderDto.setPatCaseMainSuit(mainSuit);
            list.add(hosManageOrderDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ResultInfo<List<PatientInfoDto>> queryPatientInfoList(Long doctorId, Integer pageIndex, Integer pageSize) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.consultationService.queryConsultationPatListByDoctorId(doctorId);
        if (consultationEntityList == null) {
            log.info("\u65e0\u60a3\u8005");
            return this.returnSucceed((Object)new PatientInfoDto(), "\u65e0\u60a3\u8005");
        }
        ArrayList<PatientInfoDto> list = new ArrayList<PatientInfoDto>();
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            PatientCaseInfoEntity patientCaseInfoEntity;
            PatientInfoDto patientInfoDto = new PatientInfoDto();
            PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
            if (patientInfoRespVO != null) {
                patientInfoDto.setPatId(Long.valueOf(Long.parseLong(patientInfoRespVO.getPatientId())));
                patientInfoDto.setPatientName(patientInfoRespVO.getName());
                patientInfoDto.setPatientSex(Integer.valueOf(patientInfoRespVO.getGender().intValue()));
                patientInfoDto.setPatientAge(Integer.valueOf(Integer.parseInt(patientInfoRespVO.getAge())));
                patientInfoDto.setPatientTel(patientInfoRespVO.getContactMobile());
                patientInfoDto.setPatIdCard(patientInfoRespVO.getCredNo());
            }
            if ((patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId())) != null) {
                patientInfoDto.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
                String normalImages = patientCaseInfoEntity.getNormalImages();
                ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
                if (normalImages != null && !normalImages.equals("")) {
                    String[] split = normalImages.split(",");
                    for (int i = 0; i < split.length; ++i) {
                        BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(split[i]));
                        if (!ossFileVOBaseResponse.getCode().equals("1")) {
                            return this.returnFailure(ossFileVOBaseResponse.getMsg());
                        }
                        OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                        if (ossFileEntity == null) continue;
                        NormalImagesDto normalImagesDto = new NormalImagesDto();
                        normalImagesDto.setId(ossFileEntity.getId());
                        normalImagesDto.setUrl(ossFileEntity.getUrl());
                        caseAttachmentList.add(normalImagesDto);
                    }
                    patientInfoDto.setCaseAttachmentList(caseAttachmentList);
                } else {
                    patientInfoDto.setCaseAttachmentList(new ArrayList());
                }
            }
            list.add(patientInfoDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ResultInfo updatePatientSignature(Long orderId, String patientSignature) {
        ConsultationEntity entity = this.queryConsultationEntityById(orderId);
        ResultInfo consultationEntityResultInfo = this.orderStatusAndPayType(entity);
        if (consultationEntityResultInfo.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && consultationEntityResultInfo.getData() != null) {
            int i = this.consultationService.updatePatientSignature(((ConsultationEntity)consultationEntityResultInfo.getData()).getId(), patientSignature, PatientSignerRelationshipEnum.OTHER.getValue());
            if (i > 0) {
                log.info("\u8ba2\u5355:{}========>\u7b7e\u7f72\u6210\u529f", (Object)orderId);
                this.webAndAppMessageManager.applyOrderToNodeAdminUser((ConsultationEntity)consultationEntityResultInfo.getData());
                if (((ConsultationEntity)consultationEntityResultInfo.getData()).getStatus().intValue() == OrderStatusEnum.WAITING.getValue().intValue() && ((ConsultationEntity)consultationEntityResultInfo.getData()).getExpertId() != null && ((ConsultationEntity)consultationEntityResultInfo.getData()).getExpertId().intValue() != 0) {
                    Map map = this.commonService.creatRongCloudGroup(orderId);
                    if (((String)map.get("msg")).equals("success")) {
                        log.info("========\u521b\u5efa\u7fa4\u7ec4\u6210\u529f,\u7b7e\u540d\u6210\u529f");
                        try {
                            this.webAndAppMessageManager.addOrderSendMessageToPatient((ConsultationEntity)consultationEntityResultInfo.getData());
                            this.webAndAppMessageManager.applyOrderToNodeAdminUser((ConsultationEntity)consultationEntityResultInfo.getData());
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        return this.returnSucceed("\u7b7e\u540d\u6210\u529f");
                    }
                    log.error("\u521b\u5efa\u7fa4\u7ec4\u9519\u8bef:\u4e0a\u4f20\u7b7e\u540d\u5931\u8d25==========" + (String)map.get("msg"));
                    throw new RuntimeException("\u521b\u5efa\u7fa4\u7ec4\u9519\u8bef:\u4e0a\u4f20\u7b7e\u540d\u5931\u8d25," + (String)map.get("msg"));
                }
            }
            return this.returnSucceed("\u4e0a\u4f20\u6210\u529f");
        }
        return consultationEntityResultInfo;
    }

    public ResultInfo updatePatientSignatureRelationship(Long orderId, String patientSignature, Integer patientSignerRelationship) {
        ConsultationEntity entity = this.queryConsultationEntityById(orderId);
        ResultInfo consultationEntityResultInfo = this.orderStatusAndPayType(entity);
        if (!consultationEntityResultInfo.getCode().equals(ReturnCodeEnum.SUCCEED.getValue())) {
            return consultationEntityResultInfo;
        }
        int i = this.consultationService.updatePatientSignature(((ConsultationEntity)consultationEntityResultInfo.getData()).getId(), patientSignature, patientSignerRelationship);
        if (i > 0) {
            log.info("\u8ba2\u5355:{}=======>\u7b7e\u540d\u4e0a\u4f20\u6210\u529f", (Object)orderId);
            try {
                this.webAndAppMessageManager.applyOrderToNodeAdminUser((ConsultationEntity)consultationEntityResultInfo.getData());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (((ConsultationEntity)consultationEntityResultInfo.getData()).getStatus().intValue() == OrderStatusEnum.WAITING.getValue().intValue() && ((ConsultationEntity)consultationEntityResultInfo.getData()).getExpertId() != null && ((ConsultationEntity)consultationEntityResultInfo.getData()).getExpertId().intValue() != 0) {
                Map map = this.commonService.creatRongCloudGroup(orderId);
                if (((String)map.get("msg")).equals("success")) {
                    try {
                        this.webAndAppMessageManager.addOrderSendMessageToPatient((ConsultationEntity)consultationEntityResultInfo.getData());
                    }
                    catch (Exception e) {
                        log.error("\u7b7e\u540d\u63a8\u9001\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
                    }
                    log.info("\u521b\u5efa\u7fa4\u7ec4\u6210\u529f======\u7b7e\u540d\u6210\u529f");
                    return this.returnSucceed("\u7b7e\u540d\u6210\u529f");
                }
                log.error("\u521b\u5efa\u7fa4\u7ec4\u9519\u8bef:\u5728\u7ebf\u7b7e\u7f72\u5931\u8d25========" + (String)map.get("msg"));
                throw new RuntimeException("\u521b\u5efa\u7fa4\u7ec4\u9519\u8bef:\u5728\u7ebf\u7b7e\u7f72\u5931\u8d25," + (String)map.get("msg"));
            }
            return this.returnSucceed("\u7b7e\u7f72\u6210\u529f");
        }
        return this.returnFailure("\u7b7e\u7f72\u5931\u8d25");
    }

    public ResultInfo orderExpertAccept(Long orderId) {
        String acceptTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        int i = this.consultationService.updateConsultationEntityByIdStatus(orderId, OrderStatusEnum.RUNNING.getValue(), acceptTime);
        if (i > 0) {
            log.info("\u63a5\u8bca\u6210\u529f==============");
            return this.returnSucceed("\u63a5\u8bca\u6210\u529f");
        }
        return this.returnFailure("\u63a5\u8bca\u5931\u8d25");
    }

    public ResultInfo hospitalManageOrderDistribution(String orderIds, Integer orderType, Long expertId, Integer expertType, String expertName, Long expertDepId, String expertDepName, Long expertHosId, String expertHosName, String consultationDate) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orderIds.contains(",")) {
            List<String> strings = Arrays.asList(orderIds.split(","));
            for (String s : strings) {
                ids.add(Long.parseLong(s.trim()));
            }
        } else {
            ids.add(Long.parseLong(orderIds.trim()));
        }
        int i = 0;
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                boolean expertHealthInfo;
                log.info("\u53d6\u5230\u7684\u9700\u8981\u5206\u914d\u7684id\u662f:" + id);
                ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(id);
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                if (consultationEntity == null || consultationExtendEntity == null) continue;
                if (OrderStatusEnum.FINISH.getValue().equals(consultationEntity.getStatus())) {
                    return this.returnFailure("\u5df2\u5b8c\u6210\u7684\u8ba2\u5355\u4e0d\u80fd\u5206\u914d!");
                }
                if (consultationEntity.getDoctorId().intValue() == expertId.intValue()) {
                    return this.returnFailure("\u8ba2\u5355\u966a\u8bca\u533b\u751f\u548c\u63a5\u8bca\u4e13\u5bb6\u4e0d\u80fd\u4e3a\u540c\u4e00\u4f4d\u533b\u751f!");
                }
                log.info("\u4e13\u5bb6id\u662f:" + expertId + "\u8ba2\u5355\u7c7b\u578b\u662f:" + orderType);
                Integer serviceId = orderType.intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_HOSPITAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_HOSPITAL.getValue();
                HospitalHealthAllianceMemberEntity hospitalHealthAllianceMember = this.healthAllianceMemberService.getHealthAllianceMemberByHospitalId(expertHosId);
                ArrayList<QueryPiontServiceDTO> queryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
                QueryPiontServiceDTO expertPiontService = new QueryPiontServiceDTO();
                expertPiontService.setDoctorId(Integer.valueOf(expertId.intValue()));
                expertPiontService.setServiceCode(serviceId.toString());
                queryPiontServiceDTOS.add(expertPiontService);
                List expertInfoVOS = this.remoteManage.queryDoctorServiceInfo(queryPiontServiceDTOS);
                BaseResponse expertServiceInfoVOBaseResponse = this.iDoctorApiClient.queryAllServiceInfo(expertPiontService);
                log.info("\u5206\u914d\u8ba2\u5355\u65f6\u67e5\u5230\u63a5\u8bca\u8d39\u7684\u4ef7\u683c\u662f:{},\u67e5\u8be2\u4e13\u5bb6\u5f00\u901a\u533b\u8054\u4f53\u72b6\u6001\u662f:{}", (Object)expertInfoVOS.toString(), (Object)expertServiceInfoVOBaseResponse.toString());
                boolean bl = expertHealthInfo = expertServiceInfoVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && expertServiceInfoVOBaseResponse.getData() != null && new Integer(1).equals(((DoctorServiceInfoVO)expertServiceInfoVOBaseResponse.getData()).getStatus());
                if (hospitalHealthAllianceMember != null && !expertInfoVOS.isEmpty() && expertInfoVOS.get(0) != null && expertHealthInfo) {
                    log.info("=====\u5206\u914d\u4f18\u5148\u533b\u8054\u4f53\u6a21\u5f0f======");
                } else {
                    log.info("========\u5206\u914d\u5230\u4e2a\u4eba\u6a21\u5f0f======");
                    serviceId = orderType.intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_PERSERNAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_PERSONAL.getValue();
                    ArrayList<QueryPiontServiceDTO> expertPriceList = new ArrayList<QueryPiontServiceDTO>();
                    QueryPiontServiceDTO expertPiont = new QueryPiontServiceDTO();
                    expertPiont.setDoctorId(Integer.valueOf(expertId.intValue()));
                    expertPiont.setServiceCode(serviceId.toString());
                    expertPriceList.add(expertPiont);
                    BaseResponse expertPersonfoVOBaseResponse = this.iDoctorApiClient.queryAllServiceInfo(expertPiont);
                    log.info("\u67e5\u8be2\u5230\u4e13\u5bb6\u5f00\u901a\u540d\u9662\u4e13\u5bb6\u662f:{}", (Object)expertPersonfoVOBaseResponse);
                    boolean expertPersonInfo = expertPersonfoVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && expertPersonfoVOBaseResponse.getData() != null && new Integer(1).equals(((DoctorServiceInfoVO)expertPersonfoVOBaseResponse.getData()).getStatus());
                    List expertService = this.remoteManage.queryDoctorServiceInfo(expertPriceList);
                    if (expertService == null || expertService.get(0) == null || !expertPersonInfo) {
                        return this.returnFailure("\u6b64\u4e13\u5bb6\u6240\u5728\u7684\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53\u6216\u672a\u5f00\u901a\u4efb\u4f55\u4f1a\u8bca\u670d\u52a1!");
                    }
                }
                String consultationDate1 = "";
                String consultationTime1 = "";
                DoctorEntityInfoVO expertDetailInfo = this.remoteManage.getDoctorDetailById(expertId);
                expertType = expertDetailInfo.getDoctorType();
                i = this.consultationService.hospitalManageOrderDistribution(Long.valueOf(id), orderType, expertId, expertType, expertName, expertDepId, expertDepName, expertHosId, expertHosName, consultationDate1, consultationTime1, OrderStatusEnum.WAIT_DISTRIBUTION.getValue(), serviceId);
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(expertHosId.intValue()));
                consultationExtendEntity.setClinicalAppCode(expertAppCode);
                consultationExtendEntity.setExpertPhone(expertDetailInfo.getRegisterMobile());
                this.consultationExtendService.update(consultationExtendEntity);
                if (i > 0) {
                    log.info("==\u4f1a\u8bca\u8ba2\u5355:" + id + "\u4e13\u5bb6\u5206\u914d\u6210\u529f=============");
                    consultationEntity.setExpertName(expertName);
                    consultationEntity.setExpertDepId(expertDepId);
                    consultationEntity.setExpertDeptName(expertDepName);
                    consultationEntity.setExpertHospitalId(expertHosId);
                    consultationEntity.setExpertHosName(expertHosName);
                    consultationEntity.setConsultationDate(consultationDate1);
                    consultationEntity.setConsultationTime(consultationTime1);
                    consultationEntity.setExpertId(expertId);
                    consultationEntity.setExpertType(expertType);
                    consultationEntity.setServiceCode(serviceId);
                    consultationEntity.setType(orderType);
                    ResultInfo consultationEntityResultInfo = this.orderStatusAndPayType(consultationEntity);
                    if (consultationEntityResultInfo.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && consultationEntityResultInfo.getData() != null) {
                        if (((ConsultationEntity)consultationEntityResultInfo.getData()).getStatus().intValue() != OrderStatusEnum.WAITING.getValue().intValue()) continue;
                        log.info("========\u5f85\u63a5\u8bca\u72b6\u6001\u5f00\u59cb\u521b\u5efa\u878d\u4e91\u7fa4\u7ec4=====");
                        Map map = new HashMap();
                        try {
                            map = this.commonService.creatRongCloudGroup(Long.valueOf(id));
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        if (!((String)map.get("msg")).equals("success")) {
                            log.error("\u521b\u5efa\u7fa4\u7ec4\u9519\u8bef:\u4e13\u5bb6\u5206\u914d\u5931\u8d25========" + (String)map.get("msg"));
                            throw new RuntimeException("\u521b\u5efa\u7fa4\u7ec4\u9519\u8bef:\u4e13\u5bb6\u5206\u914d\u5931\u8d25," + (String)map.get("msg"));
                        }
                        log.info("======\u5206\u914d\u4e13\u5bb6\u521b\u5efa\u878d\u4e91\u7fa4\u7ec4\u6210\u529f===");
                        try {
                            if (orderType.equals(ConsultationConstant.TYPE_ORDER_VIDEO)) {
                                this.shortMessageManager.videoConsultationFromAdminToDoctor(consultationEntity);
                                this.shortMessageManager.videoConsultationFromAdminToReport(consultationEntity);
                            } else {
                                this.shortMessageManager.photoConsultationFromAdminToDoctor(consultationEntity.getViewId());
                                this.shortMessageManager.photoConsultationFromAdminToReport(consultationEntity);
                            }
                            this.webAndAppMessageManager.hospitalManageOrderDistributionSendMessage(consultationEntity);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    return consultationEntityResultInfo;
                }
                log.error("=====\u8ba2\u5355\u8868\u66f4\u65b0\u4fe1\u606f\u5931\u8d25");
                return this.returnFailure("\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        } else {
            return this.returnFailure("\u6ca1\u6709\u5206\u914d\u7684\u8ba2\u5355!");
        }
        log.info("========\u8ba2\u5355\u5206\u914d\u4e13\u5bb6\u5b8c\u6210=======");
        return this.returnSucceed("\u5206\u914d\u8ba2\u5355\u6210\u529f");
    }

    public ResultInfo<List<HosManageOrderDto>> queryAppConsultationListByDoctorId(Integer pageIndex, Integer pageSize, Long doctorId, Integer status, Integer isSponsor) {
        List consultationEntityList;
        ArrayList<HosManageOrderDto> list = new ArrayList<HosManageOrderDto>();
        if (isSponsor == 1) {
            PageHelper.startPage((int)pageIndex, (int)pageSize);
            consultationEntityList = this.consultationService.queryAppConsultationEntityByDoctorId(doctorId, status);
        } else {
            PageHelper.startPage((int)pageIndex, (int)pageSize);
            consultationEntityList = this.consultationService.queryAppConsultationEntityByExpertId(doctorId, status);
        }
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            if (consultationEntity.getStatus() >= OrderStatusEnum.WAITING.getValue() && consultationEntity.getGroupId().equals("") && consultationEntity.getExpertId() != null && consultationEntity.getExpertId().intValue() != 0) {
                log.info("groupId\u8865\u507f\u673a\u5236\u5f00\u59cb=======================\u8ba2\u5355id" + consultationEntity.getId());
                try {
                    Map map = this.commonService.creatRongCloudGroup(consultationEntity.getId());
                    if (((String)map.get("msg")).equals("success")) {
                        log.info("groupId\u8865\u507f\u6210\u529f==========");
                    } else {
                        log.error("groupId\u8865\u507f\u5931\u8d25====\u8ba2\u5355id:" + consultationEntity.getId() + "====" + (String)map.get("msg"));
                    }
                }
                catch (Exception e) {
                    log.error("groupId\u8865\u507f\u5f02\u5e38\u6355\u83b7====\u8ba2\u5355id" + consultationEntity.getId() + "======" + e.toString());
                }
            }
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            HosManageOrderDto hosManageOrderDto = new HosManageOrderDto();
            hosManageOrderDto.setOrderId(consultationEntity.getId());
            hosManageOrderDto.setOrderCreateTime(consultationEntity.getCreateTime().toString());
            String format = DateTimeUtil.formatTime((Date)consultationEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            hosManageOrderDto.setOrderCreateTimeStr(format);
            hosManageOrderDto.setOrderViewId(consultationEntity.getViewId());
            hosManageOrderDto.setOrderStatus(consultationEntity.getStatus());
            hosManageOrderDto.setOrderType(consultationEntity.getType());
            hosManageOrderDto.setConsultationDate(consultationEntity.getConsultationDate());
            hosManageOrderDto.setConsultationTime(consultationEntity.getConsultationTime());
            hosManageOrderDto.setBeginTime(consultationEntity.getBeginTime());
            hosManageOrderDto.setFinishTime(consultationEntity.getFinishTime());
            hosManageOrderDto.setAcceptTime(consultationEntity.getAcceptTime());
            hosManageOrderDto.setCloseTime(consultationEntity.getClosedTime());
            hosManageOrderDto.setOrderPrice(consultationExtendEntity.getPrice());
            hosManageOrderDto.setOrderApplicationChannels(consultationEntity.getApplicationChannels());
            hosManageOrderDto.setGroupId(consultationEntity.getGroupId());
            hosManageOrderDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
            hosManageOrderDto.setPatientId(consultationEntity.getPatientId());
            hosManageOrderDto.setPatientName(consultationEntity.getPatientName());
            hosManageOrderDto.setPatientSex(consultationExtendEntity.getPatientSex());
            hosManageOrderDto.setPatientAge(consultationExtendEntity.getPatientAge());
            hosManageOrderDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
            hosManageOrderDto.setDocId(consultationEntity.getDoctorId());
            hosManageOrderDto.setDocName(consultationEntity.getDoctorName());
            hosManageOrderDto.setDocDepName(consultationEntity.getDoctorDepName());
            hosManageOrderDto.setDocHosName(consultationEntity.getDoctorHosName());
            hosManageOrderDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
            hosManageOrderDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
            hosManageOrderDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
            hosManageOrderDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
            hosManageOrderDto.setPatientTel(consultationExtendEntity.getPatientPhone());
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            if (patientCaseInfoEntity != null) {
                hosManageOrderDto.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
            }
            list.add(hosManageOrderDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ResultInfo<ConsultationEntity> orderStatusAndPayType(ConsultationEntity consultationEntity) {
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        log.info("=========\u8ba2\u5355\u7684id\u662f:{}=====\u8ba2\u5355\u7c7b\u578b\u662f:{}", (Object)consultationEntity.getId(), (Object)consultationEntity.getType());
        if (consultationEntity != null && consultationEntity.getStatus() <= OrderStatusEnum.FINISH.getValue()) {
            log.info("========\u8ba2\u5355\u5b9e\u4f53\u7c7b\u662f:{}", (Object)consultationEntity.toString());
            if (consultationEntity.getApplicationChannels().intValue() != ConsultationConstant.TYPE_APPLICATION_DISTRIBUTION.intValue() || consultationEntity.getApplicationChannels().equals(ConsultationConstant.TYPE_APPLICATION_DISTRIBUTION) && consultationEntity.getStatus() >= OrderStatusEnum.WAIT_DISTRIBUTION.getValue() && consultationEntity.getStatus() <= OrderStatusEnum.FINISH.getValue()) {
                ArrayList<QueryPiontServiceDTO> queryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
                QueryPiontServiceDTO expertPiontService = new QueryPiontServiceDTO();
                expertPiontService.setDoctorId(Integer.valueOf(consultationEntity.getExpertId().intValue()));
                expertPiontService.setServiceCode(consultationEntity.getServiceCode().toString());
                queryPiontServiceDTOS.add(expertPiontService);
                List infoVOS = this.remoteManage.queryDoctorServiceInfo(queryPiontServiceDTOS);
                log.info("\u63a5\u8bca\u8d39\u8fd4\u56de\u7684\u4ef7\u683c\u662f:{}", (Object)infoVOS.toString());
                Integer surgeryType = OrderTypeEnum.getByValue((Integer)consultationEntity.getType()).getValue().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) ? DoctorServiceEnum.CONSULTATION_VEDIO_SURGERY.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_SURGERY.getValue();
                ArrayList<QueryPiontServiceDTO> doctorQueryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
                QueryPiontServiceDTO doctorPiontService = new QueryPiontServiceDTO();
                doctorPiontService.setDoctorId(Integer.valueOf(consultationEntity.getDoctorId().intValue()));
                doctorPiontService.setServiceCode(surgeryType.toString());
                doctorQueryPiontServiceDTOS.add(doctorPiontService);
                List doctorInfoVOS = this.remoteManage.queryDoctorServiceInfo(doctorQueryPiontServiceDTOS);
                log.info("\u966a\u8bca\u8d39\u8fd4\u56de\u7684\u4ef7\u683c\u662f:{}", (Object)doctorInfoVOS.toString());
                BigDecimal accompanyFee = null;
                BigDecimal amissionFee = null;
                Integer serviceCode = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? DoctorServiceEnum.CONSULTATION_VEDIO_HOSPITAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_HOSPITAL.getValue();
                amissionFee = ((PointDoctorServiceInfoVO)infoVOS.get(0)).getPrice();
                accompanyFee = doctorInfoVOS.isEmpty() || doctorInfoVOS.get(0) == null ? new BigDecimal(0) : ((PointDoctorServiceInfoVO)doctorInfoVOS.get(0)).getPrice();
                BigDecimal baiyihuiFee = new BigDecimal(0);
                consultationExtendEntity.setAmissionFee(amissionFee);
                consultationExtendEntity.setAccompanyFee(accompanyFee);
                consultationExtendEntity.setServiceFee(baiyihuiFee);
                BigDecimal price = BigDecimal.ZERO;
                if (consultationExtendEntity.getIsImageConsultation() != null && consultationExtendEntity.getIsImageConsultation() == 1) {
                    log.info("\u5f71\u50cf\u4f1a\u8bca\u4ef7\u683c:{}", (Object)consultationExtendEntity.getImagePrice());
                    price = consultationExtendEntity.getImagePrice().add(consultationExtendEntity.getAccompanyFee()).add(consultationExtendEntity.getAmissionFee()).add(consultationExtendEntity.getServiceFee());
                } else {
                    price = consultationExtendEntity.getAccompanyFee().add(consultationExtendEntity.getAmissionFee()).add(consultationExtendEntity.getServiceFee());
                }
                consultationExtendEntity.setPrice(price);
                consultationExtendEntity.setPayState(PayStateEnum.NO_PAY_STATE.getValue());
                log.info("\u4e13\u5bb6\u7684\u63a5\u8bca\u8d39\u7528\u662f{}=====\u533b\u751f\u7684\u966a\u8bca\u8d39\u662f:{}===\u4f70\u533b\u6c47\u7684\u670d\u52a1\u8d39\u662f:{}===\u8ba2\u5355\u4ef7\u683c\u662f:{}", new Object[]{amissionFee, accompanyFee, baiyihuiFee, price});
                if (!consultationEntity.getApplicationChannels().equals(ConsultationConstant.TYPE_APPLICATION_CHANNELS_EXPERT)) {
                    HospitalHealthAllianceServiceEntity normalMonthState = this.healthAllianceServiceService.getHealthAllianceServiceByHospitalIdAndServiceId(consultationEntity.getExpertHospitalId(), Long.valueOf(0L), serviceCode);
                    HospitalHealthAllianceServiceEntity specialMonthState = this.healthAllianceServiceService.getHealthAllianceServiceByHospitalIdAndServiceId(consultationEntity.getDoctorHospitalId(), consultationEntity.getExpertHospitalId(), serviceCode);
                    if (normalMonthState != null || specialMonthState != null) {
                        log.info("====\u5f00\u901a\u4e86\u6708\u7ed3====");
                        consultationEntity.setStatus(OrderStatusEnum.WAITING.getValue());
                        consultationExtendEntity.setPayType(PayTypeEnum.MONTH_SETTLE.getValue());
                    } else {
                        log.info("=====\u672a\u5f00\u901a\u6708\u7ed3====");
                        consultationExtendEntity.setPayType(PayTypeEnum.NORMAL_SETTLE.getValue());
                        int orderStatus = price.compareTo(new BigDecimal(0)) == 0 || StringUtil.isNotBlank((String)consultationEntity.getPayTime()) ? OrderStatusEnum.WAITING.getValue() : OrderStatusEnum.UN_PAY.getValue();
                        consultationEntity.setStatus(Integer.valueOf(orderStatus));
                    }
                } else {
                    log.info("======\u6b63\u5e38\u652f\u4ed8=======");
                    int orderStatus = price.compareTo(new BigDecimal(0)) == 0 || StringUtil.isNotBlank((String)consultationEntity.getPayTime()) ? OrderStatusEnum.WAITING.getValue() : OrderStatusEnum.UN_PAY.getValue();
                    consultationEntity.setStatus(Integer.valueOf(orderStatus));
                    consultationExtendEntity.setPayType(PayTypeEnum.NORMAL_SETTLE.getValue());
                }
            } else {
                consultationEntity.setStatus(OrderStatusEnum.WAIT_DISTRIBUTION.getValue());
            }
            int value = this.updateConsultation(consultationEntity);
            this.consultationExtendService.update(consultationExtendEntity);
            if (value != 0) {
                log.info("=========\u66f4\u65b0\u4ef7\u683c\u6210\u529f=======");
            }
        }
        return this.returnSucceed((Object)consultationEntity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    public ResultInfo<Map<String, Object>> queryAllConsultation(String search, Integer type, Integer status, String beginTime, String endTime, Integer pageIndex, Integer pageSize) {
        Page page = PageHelper.startPage((int)pageIndex, (int)pageSize, (boolean)true);
        ArrayList hospitalIds = new ArrayList();
        List consultationEntities = this.consultationService.queryAllConsultationByCondition(search, type, status, beginTime, hospitalIds, endTime);
        Map map = this.getConsultatioinData(page, consultationEntities);
        return this.returnSucceed((Object)map, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    public ResultInfo<Map<String, Object>> queryManageDataConsultation(String userId, String appCode, String search, Integer type, Integer status, String beginTime, String endTime, Integer pageIndex, Integer pageSize) {
        List consultationEntities = null;
        log.info("====\u7ba1\u7406\u5e73\u53f0\u53d6\u5230\u7684userId\u662f:{},\u53d6\u5230\u7684appCode\u662f:{}", (Object)userId, (Object)appCode);
        BaseResponse stringBaseResponse = this.pumpPermission(appCode, userId);
        if (!ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(stringBaseResponse.getCode()) || StringUtil.isBlank((String)((String)stringBaseResponse.getData()))) {
            return this.returnFailure("\u6b64\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u67e5\u770b\u6570\u636e\u7684\u6743\u9650!");
        }
        List nodeOrganInfosList = this.ihosBaseDataRemote.getNodeOrganInfos(appCode);
        List<Long> hospitalIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)nodeOrganInfosList)) {
            for (OrganizationResVO organizationVo : nodeOrganInfosList) {
                hospitalIds.add(Long.parseLong(organizationVo.getOrganId()));
            }
        }
        log.info("\u8be5\u8282\u70b9\u4e0b\u5168\u90e8\u7684\u533b\u9662\u662f:{}", (Object)((Object)hospitalIds).toString());
        Page page = PageHelper.startPage((int)pageIndex, (int)pageSize, (boolean)true);
        String hospitalIdsStr = (String)stringBaseResponse.getData();
        log.info("\u4ece\u6743\u9650\u670d\u52a1\u62ff\u5230\u7684\u533b\u9662\u662f:{}", (Object)hospitalIdsStr);
        if (StringUtil.isEmpty((String)hospitalIdsStr)) {
            consultationEntities = null;
        } else if (StringUtil.isNotEmpty((String)hospitalIdsStr) && !hospitalIdsStr.equals("-1")) {
            hospitalIds = Arrays.asList(hospitalIdsStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            consultationEntities = this.consultationService.queryAllConsultationByCondition(search, type, status, beginTime, hospitalIds, endTime);
        } else {
            consultationEntities = this.consultationService.queryAllConsultationByCondition(search, type, status, beginTime, hospitalIds, endTime);
        }
        Map map = this.getConsultatioinData(page, consultationEntities);
        return this.returnSucceed((Object)map, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    public Map<String, Object> getConsultatioinData(Page page, List<ConsultationEntity> consultationEntities) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<DataManagerVo> dataManagerVos = new ArrayList<DataManagerVo>();
        if (CollectionUtils.isNotEmpty(consultationEntities)) {
            for (ConsultationEntity entity : consultationEntities) {
                DoctorEntityInfoVO expertDetailInfoEntity;
                DoctorEntityInfoVO doctorDetailInfoEntity;
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(entity.getId());
                DataManagerVo dataManagerVo = new DataManagerVo();
                dataManagerVo.setId(entity.getId());
                dataManagerVo.setPatientInformedConsentUrl(entity.getPatientInformedConsentUrl());
                dataManagerVo.setType(entity.getType());
                dataManagerVo.setExpertDepId(entity.getExpertDepId());
                String expertDeptName = StringUtil.isNotEmpty((String)entity.getExpertDeptName()) ? entity.getExpertDeptName() : "";
                dataManagerVo.setExpertDeptName(expertDeptName);
                Long expertId = entity.getExpertId() == null ? 0L : entity.getExpertId();
                dataManagerVo.setExpertId(expertId);
                String expertName = StringUtil.isNotEmpty((String)entity.getExpertName()) ? entity.getExpertName() : "";
                dataManagerVo.setExpertName(expertName);
                Long exertHospitalId = entity.getExpertHospitalId() == null ? 0L : entity.getExpertHospitalId();
                dataManagerVo.setExpertHospitalId(exertHospitalId);
                dataManagerVo.setReceiveTime(entity.getAcceptTime());
                String expertHosName = StringUtil.isNotEmpty((String)entity.getExpertHosName()) ? entity.getExpertHosName() : "";
                dataManagerVo.setExpertHosName(expertHosName);
                BigDecimal amissionFee = consultationExtendEntity.getAmissionFee() == null ? new BigDecimal(0) : consultationExtendEntity.getAmissionFee();
                dataManagerVo.setAmissionFee(amissionFee);
                Long doctorDeptId = entity.getDoctorDepId() == null ? 0L : entity.getDoctorDepId();
                dataManagerVo.setDoctorDepId(doctorDeptId);
                dataManagerVo.setDoctorDetpName(StringUtil.isEmpty((String)entity.getDoctorDepName()) ? "" : entity.getDoctorDepName());
                dataManagerVo.setDoctorHosName(StringUtil.isEmpty((String)entity.getDoctorHosName()) ? "" : entity.getDoctorHosName());
                Long doctorId = entity.getDoctorId() == null ? 0L : entity.getDoctorId();
                dataManagerVo.setDoctorId(doctorId);
                BigDecimal accompanyFee = consultationExtendEntity.getAccompanyFee() == null ? new BigDecimal(0) : consultationExtendEntity.getAccompanyFee();
                dataManagerVo.setAccompanyFee(consultationExtendEntity.getAccompanyFee());
                if (entity.getPatientId() == null) {
                    dataManagerVo.setPatientId(Long.valueOf(0L));
                } else {
                    dataManagerVo.setPatientId(entity.getPatientId());
                }
                dataManagerVo.setOrderViewId(entity.getViewId());
                if (entity.getExpertId() == null) {
                    dataManagerVo.setExpertId(Long.valueOf(0L));
                } else {
                    dataManagerVo.setExpertId(entity.getExpertId());
                }
                if (entity.getExpertName() == null) {
                    dataManagerVo.setExpertName("");
                } else {
                    dataManagerVo.setExpertName(entity.getExpertName());
                }
                if (entity.getExpertHospitalId() == null) {
                    dataManagerVo.setExpertHospitalId(Long.valueOf(0L));
                } else {
                    dataManagerVo.setExpertHospitalId(entity.getExpertHospitalId());
                }
                if (entity.getExpertHosName() == null) {
                    dataManagerVo.setExpertHosName("");
                } else {
                    dataManagerVo.setExpertHosName(entity.getExpertHosName());
                }
                if (consultationExtendEntity.getAmissionFee() == null) {
                    dataManagerVo.setAmissionFee(new BigDecimal(0));
                } else {
                    dataManagerVo.setAmissionFee(consultationExtendEntity.getAmissionFee());
                }
                if (entity.getDoctorDepId() == null) {
                    dataManagerVo.setDoctorDepId(Long.valueOf(0L));
                } else {
                    dataManagerVo.setDoctorDepId(entity.getDoctorDepId());
                }
                dataManagerVo.setDoctorDetpName(StringUtil.isEmpty((String)entity.getDoctorDepName()) ? "" : entity.getDoctorDepName());
                dataManagerVo.setDoctorHosName(StringUtil.isEmpty((String)entity.getDoctorHosName()) ? "" : entity.getDoctorHosName());
                if (entity.getDoctorDepId() == null) {
                    dataManagerVo.setDoctorDepId(Long.valueOf(0L));
                } else {
                    dataManagerVo.setDoctorDepId(entity.getDoctorDepId());
                }
                if (entity.getDoctorId() == null) {
                    dataManagerVo.setDoctorId(Long.valueOf(0L));
                } else {
                    dataManagerVo.setDoctorId(entity.getDoctorId());
                }
                dataManagerVo.setDoctorName(StringUtil.isEmpty((String)entity.getDoctorName()) ? "" : entity.getDoctorName());
                if (consultationExtendEntity.getAccompanyFee() == null) {
                    dataManagerVo.setAccompanyFee(new BigDecimal(0));
                } else {
                    dataManagerVo.setAccompanyFee(consultationExtendEntity.getAccompanyFee());
                }
                if (entity.getPatientId() == null) {
                    dataManagerVo.setPatientId(Long.valueOf(0L));
                } else {
                    dataManagerVo.setPatientId(entity.getPatientId());
                }
                dataManagerVo.setOrderViewId(entity.getViewId());
                try {
                    dataManagerVo.setPatientId(entity.getPatientId());
                    dataManagerVo.setMobileNumber(consultationExtendEntity.getPatientPhone());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    dataManagerVo.setPatientId(Long.valueOf(0L));
                }
                try {
                    dataManagerVo.setPatientSex(consultationExtendEntity.getPatientSex());
                }
                catch (Exception e) {
                    dataManagerVo.setPatientSex(Integer.valueOf(0));
                }
                try {
                    dataManagerVo.setPatientName(entity.getPatientName());
                }
                catch (Exception e) {
                    dataManagerVo.setPatientName("");
                }
                try {
                    dataManagerVo.setPatientAge(consultationExtendEntity.getPatientAge());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dataManagerVo.setPatientAge(Integer.valueOf(0));
                }
                dataManagerVo.setAppWechatPhone(consultationExtendEntity.getPatientPhone());
                if (consultationExtendEntity.getPayType() == null) {
                    dataManagerVo.setPayType(Integer.valueOf(0));
                } else {
                    dataManagerVo.setPayType(consultationExtendEntity.getPayType());
                }
                dataManagerVo.setInitiatorType(consultationExtendEntity.getInitiatorType());
                if (consultationExtendEntity.getPrice() == null) {
                    dataManagerVo.setPrice(new BigDecimal(0));
                } else {
                    dataManagerVo.setPrice(consultationExtendEntity.getPrice());
                }
                if (consultationExtendEntity.getServiceFee() == null) {
                    dataManagerVo.setServiceFee(new BigDecimal(0));
                } else {
                    dataManagerVo.setServiceFee(consultationExtendEntity.getServiceFee());
                }
                if (entity.getStatus() == null) {
                    dataManagerVo.setStatus(Integer.valueOf(0));
                } else {
                    dataManagerVo.setStatus(entity.getStatus());
                }
                if (consultationExtendEntity.getPayState() == null) {
                    dataManagerVo.setPayState(Integer.valueOf(0));
                } else {
                    dataManagerVo.setPayState(consultationExtendEntity.getPayState());
                }
                if (consultationExtendEntity.getVideoTime() == null) {
                    dataManagerVo.setVideoTime("");
                } else {
                    dataManagerVo.setVideoTime(consultationExtendEntity.getVideoTime());
                }
                if (entity.getBeginTime() == null) {
                    dataManagerVo.setBeginTime("");
                } else {
                    dataManagerVo.setBeginTime(entity.getBeginTime());
                }
                if (entity.getFinishTime() == null) {
                    dataManagerVo.setEndTime("");
                } else {
                    dataManagerVo.setEndTime(entity.getFinishTime());
                }
                dataManagerVo.setCreateTime(entity.getCreateTime());
                dataManagerVo.setUpdateTime(entity.getUpdateTime());
                dataManagerVo.setConsultationDate(entity.getConsultationDate());
                dataManagerVo.setConsultationTime(entity.getConsultationTime());
                PatientCaseInfoEntity patientCaseInfoDTO = this.patientCaseInfoService.selectPatientCaseInfoById(entity.getCaseId());
                if (patientCaseInfoDTO == null || StringUtil.isEmpty((String)patientCaseInfoDTO.getMainSuit()) || StringUtil.isEmpty((String)patientCaseInfoDTO.getConsultAim()) || StringUtil.isEmpty((String)patientCaseInfoDTO.getNormalImages()) && StringUtil.isEmpty((String)consultationExtendEntity.getDcmPackUrl()) && StringUtil.isEmpty((String)consultationExtendEntity.getDcmFileUrl())) {
                    dataManagerVo.setIsPatientCase(Integer.valueOf(0));
                } else {
                    dataManagerVo.setIsPatientCase(Integer.valueOf(1));
                }
                ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(entity.getViewId());
                if (consultationReportEntity != null && consultationReportEntity.getStatus() == 1) {
                    dataManagerVo.setIsReport(Integer.valueOf(1));
                } else {
                    dataManagerVo.setIsReport(Integer.valueOf(0));
                }
                if (entity.getDoctorId() != null && entity.getDoctorId().intValue() != 0 && (doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(entity.getDoctorId())) != null) {
                    String docMobileNumber = doctorDetailInfoEntity.getContactMobile();
                    dataManagerVo.setDocMobileNumber(docMobileNumber);
                }
                if (entity.getExpertId() != null && entity.getExpertId().intValue() != 0 && (expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(entity.getExpertId())) != null) {
                    String expertMobileNumber = expertDetailInfoEntity.getContactMobile();
                    dataManagerVo.setExpertMobileNumber(expertMobileNumber);
                }
                List unqualifiedReason = null;
                if (entity.getStatus().intValue() == OrderStatusEnum.FINISH.getValue().intValue()) {
                    unqualifiedReason = this.isOrderQualified(entity);
                }
                if (unqualifiedReason == null || unqualifiedReason.size() < 1) {
                    dataManagerVo.setIsQualifie(Integer.valueOf(1));
                    dataManagerVo.setUnqualifieReason(unqualifiedReason);
                } else {
                    dataManagerVo.setIsQualifie(Integer.valueOf(-1));
                    dataManagerVo.setUnqualifieReason(unqualifiedReason);
                }
                dataManagerVos.add(dataManagerVo);
            }
            map.put("data", dataManagerVos);
            map.put("total", page.getTotal());
        }
        return map;
    }

    public List<ConsultationDataInfoVO> exportConsultationDataInfo(String ids, String appCode, String search, Integer orderType, Integer orderStatus, String beginTime, String endTime, String userId) {
        List<Object> consultationEntityList = new ArrayList<ConsultationEntity>();
        if (StringUtil.isNotEmpty((String)ids)) {
            List<String> idList = Arrays.asList(ids.trim().split(","));
            for (String orderId : idList) {
                ConsultationEntity consultationEntity = this.queryConsultationEntityById(Long.valueOf(Long.parseLong(orderId)));
                ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(Long.valueOf(Long.parseLong(orderId)));
                if (consultationEntity == null || extendEntity == null) continue;
                consultationEntityList.add(consultationEntity);
            }
        } else {
            log.info("====\u7ba1\u7406\u5e73\u53f0\u53d6\u5230\u7684userId\u662f:{},\u53d6\u5230\u7684appCode\u662f:{}", (Object)userId, (Object)appCode);
            List nodeOrganInfosList = this.ihosBaseDataRemote.getNodeOrganInfos(appCode);
            List<Long> hospitalIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)nodeOrganInfosList)) {
                for (OrganizationResVO organizationVo : nodeOrganInfosList) {
                    hospitalIds.add(Long.parseLong(organizationVo.getOrganId()));
                }
            }
            log.info("\u8be5\u8282\u70b9\u4e0b\u5168\u90e8\u7684\u533b\u9662\u662f:{}", (Object)((Object)hospitalIds).toString());
            String hospitalIdsStr = (String)this.pumpPermission(appCode, userId).getData();
            log.info("----\u4ece\u6743\u9650\u670d\u52a1\u4e2d\u53d6\u51fa\u7684\u533b\u9662\u662f:" + hospitalIdsStr);
            if (StringUtil.isEmpty((String)hospitalIdsStr)) {
                consultationEntityList = null;
            } else if (StringUtil.isNotEmpty((String)hospitalIdsStr) && !hospitalIdsStr.equals("-1")) {
                hospitalIds = Arrays.asList(hospitalIdsStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                consultationEntityList = this.consultationService.queryAllConsultationByCondition(search, orderType, orderStatus, beginTime, hospitalIds, endTime);
            } else {
                consultationEntityList = this.consultationService.queryAllConsultationByCondition(search, orderType, orderStatus, beginTime, hospitalIds, endTime);
            }
        }
        return this.capsulateExportData(consultationEntityList);
    }

    public List<ConsultationDataInfoVO> superAdminExportDataInfo(String ids, String search, Integer type, Integer status, String beginTime, String endTime) {
        List<ConsultationEntity> consultationEntityList = new ArrayList();
        if (StringUtil.isNotEmpty((String)ids)) {
            List<String> idList = Arrays.asList(ids.trim().split(","));
            for (String orderId : idList) {
                ConsultationEntity consultationEntity = this.queryConsultationEntityById(Long.valueOf(Long.parseLong(orderId)));
                ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(Long.valueOf(Long.parseLong(orderId)));
                if (consultationEntity == null || extendEntity == null) continue;
                consultationEntityList.add(consultationEntity);
            }
        } else {
            consultationEntityList = this.consultationService.queryAllConsultationByCondition(search, type, status, beginTime, null, endTime);
        }
        return this.capsulateExportData(consultationEntityList);
    }

    private List<ConsultationDataInfoVO> capsulateExportData(List<ConsultationEntity> consultationEntityList) {
        if (CollectionUtils.isNotEmpty(consultationEntityList)) {
            ArrayList<ConsultationDataInfoVO> dataInfoVOS = new ArrayList<ConsultationDataInfoVO>();
            for (ConsultationEntity consultationEntity : consultationEntityList) {
                ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                ConsultationDataInfoVO infoVO = new ConsultationDataInfoVO();
                infoVO.setOrderViewId(consultationEntity.getViewId());
                infoVO.setOrderTypeStr(OrderTypeEnum.TYPE_VEDIO.getValue().equals(consultationEntity.getType()) ? "\u89c6\u9891\u4f1a\u8bca" : "\u56fe\u6587\u4f1a\u8bca");
                infoVO.setInitiateTypeStr(extendEntity.getInitiatorType().equals(ConsultationConstant.TYPE_INITIATOR_PATIENT) ? "\u60a3\u8005\u53d1\u8d77" : "\u533b\u751f\u53d1\u8d77");
                infoVO.setWechatNickName("");
                infoVO.setUserPhone(StringUtil.isNotBlank((String)extendEntity.getUserPhone()) ? extendEntity.getUserPhone() : "");
                infoVO.setPatientName(StringUtil.isNotBlank((String)consultationEntity.getPatientName()) ? consultationEntity.getPatientName() : "");
                infoVO.setPatientPhone(StringUtil.isNotBlank((String)extendEntity.getPatientPhone()) ? extendEntity.getPatientPhone() : "");
                infoVO.setDocHosName(StringUtil.isNotBlank((String)consultationEntity.getDoctorHosName()) ? consultationEntity.getDoctorHosName() : "");
                infoVO.setDocDeptName(StringUtil.isNotBlank((String)consultationEntity.getDoctorDepName()) ? consultationEntity.getDoctorDepName() : "");
                infoVO.setDocName(StringUtil.isNotBlank((String)consultationEntity.getDoctorName()) ? consultationEntity.getDoctorName() : "");
                infoVO.setDocPhone(StringUtil.isNotBlank((String)extendEntity.getDoctorPhone()) ? extendEntity.getDoctorPhone() : "");
                infoVO.setExpertHosName(StringUtil.isNotBlank((String)consultationEntity.getExpertHosName()) ? consultationEntity.getExpertHosName() : "");
                infoVO.setExpertDeptName(StringUtil.isNotBlank((String)consultationEntity.getExpertDeptName()) ? consultationEntity.getExpertDeptName() : "");
                infoVO.setExpertName(StringUtil.isNotBlank((String)consultationEntity.getExpertName()) ? consultationEntity.getExpertName() : "");
                infoVO.setExpertPhone(StringUtil.isNotBlank((String)extendEntity.getExpertPhone()) ? extendEntity.getExpertPhone() : "");
                infoVO.setOrderStatusDesc(OrderStatusEnum.getByValue((Integer)consultationEntity.getStatus()).getDisplay());
                infoVO.setAccompanyFee(extendEntity.getAccompanyFee() == null ? "" : extendEntity.getAccompanyFee().toString());
                infoVO.setAdmissionFee(extendEntity.getAmissionFee() == null ? "" : extendEntity.getAmissionFee().toString());
                infoVO.setOrderPrice(extendEntity.getPrice() == null ? "" : extendEntity.getPrice().toString());
                infoVO.setPayTypeDesc(PayTypeEnum.MONTH_SETTLE.equals((Object)extendEntity.getPayType()) ? "\u6708\u7ed3" : "\u6b63\u5e38");
                infoVO.setSettlementTypeDesc(PayStateEnum.NO_PAY_STATE.equals((Object)extendEntity.getPayState()) ? "\u672a\u7ed3\u7b97" : "\u5df2\u7ed3\u7b97");
                infoVO.setAppointmentTime(StringUtil.isNotEmpty((String)consultationEntity.getConsultationDate()) ? consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime() : "");
                infoVO.setAcceptTime(StringUtil.isNotBlank((String)consultationEntity.getAcceptTime()) ? consultationEntity.getAcceptTime() : "");
                infoVO.setOrderBeginTime(StringUtil.isNotEmpty((String)consultationEntity.getBeginTime()) ? LocalDate.parse(consultationEntity.getBeginTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toString() : "");
                infoVO.setOrderFinishTime(StringUtil.isNotEmpty((String)consultationEntity.getFinishTime()) ? LocalDate.parse(consultationEntity.getFinishTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toString() : "");
                ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId1(consultationEntity.getViewId());
                if (consultationReportEntity != null) {
                    infoVO.setSubmitReportTime(DateTimeUtil.formatTime((Date)consultationReportEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    infoVO.setExistReport("\u6709");
                }
                infoVO.setCaseInfomation("\u6709");
                infoVO.setInformedConsent(StringUtil.isNotEmpty((String)consultationEntity.getPatientInformedConsentUrl()) ? "\u6709" : "\u65e0");
                infoVO.setExistVideo(StringUtil.isNotEmpty((String)extendEntity.getVideoUrl()) ? "\u6709" : "\u65e0");
                infoVO.setVideoDuration(StringUtil.isNotEmpty((String)extendEntity.getVideoUrl()) ? "\u6709" : "\u65e0");
                dataInfoVOS.add(infoVO);
            }
            return dataInfoVOS;
        }
        return null;
    }

    public ResultInfo tuWenExpertAccept(Long orderId, String acceptTime, String consultationDate, String consultationTime) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
        if (consultationEntity.getType().intValue() != OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            log.info("\u8be5\u8ba2\u5355\u4e0d\u662f\u56fe\u6587\u4f1a\u8bca=======");
            return this.returnFailure("\u8be5\u8ba2\u5355\u4e0d\u662f\u56fe\u6587\u4f1a\u8bca");
        }
        int i = this.consultationService.updateAcceptConsultationTuwen(orderId, OrderStatusEnum.RUNNING.getValue(), acceptTime, consultationDate, consultationTime);
        if (i > 0) {
            return this.returnSucceed("\u6210\u529f");
        }
        return this.returnFailure("\u5931\u8d25");
    }

    public ResultInfo uploadPatientInformedConsentUrl(Long orderId, String patientInformedConsentUrl) {
        ConsultationEntity entity = this.queryConsultationEntityById(orderId);
        ResultInfo consultationEntityResultInfo = this.orderStatusAndPayType(entity);
        if (!consultationEntityResultInfo.getCode().equals(ReturnCodeEnum.SUCCEED.getValue())) {
            return consultationEntityResultInfo;
        }
        int i = this.consultationService.uploadPatientInformedConsentUrl(orderId, patientInformedConsentUrl);
        if (i > 0) {
            if (((ConsultationEntity)consultationEntityResultInfo.getData()).getStatus().intValue() == OrderStatusEnum.WAITING.getValue().intValue()) {
                Map map = this.commonService.creatRongCloudGroup(orderId);
                if (((String)map.get("msg")).equals("success")) {
                    log.info("\u521b\u5efa\u7fa4\u7ec4\u6210\u529f======\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66\u4e0a\u4f20\u6210\u529f");
                    return this.returnSucceed("\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66\u4e0a\u4f20\u6210\u529f");
                }
                log.error("\u521b\u5efa\u7fa4\u7ec4\u5931\u8d25======\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66\u4e0a\u4f20\u5931\u8d25" + (String)map.get("msg"));
                throw new RuntimeException("\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66_\u5931\u8d25" + (String)map.get("msg"));
            }
            return this.returnSucceed("\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66\u4e0a\u4f20\u6210\u529f");
        }
        log.error("\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66\u4e0a\u4f20\u5931\u8d25============orderId:" + orderId);
        return this.returnFailure("\u60a3\u8005\u77e5\u60c5\u540c\u610f\u4e66\u4e0a\u4f20\u5931\u8d25");
    }

    public int findAllConsultationByExpIdOrDocId(Long expOrDocId) {
        return this.consultationService.findAllConsultationByExpIdOrDocId(expOrDocId);
    }

    public ConsultationEntity updatePatientCaseInfo(ConsultationPatientCaseInfoVO consultationPatientCaseInfoVO) {
        PatientCaseInfoEntity patientCaseInfoEntity;
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(consultationPatientCaseInfoVO.getOrderId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
        if (consultationEntity != null && (patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId())) != null) {
            patientCaseInfoVO.setDeptDetailId(consultationEntity.getDoctorDepId());
            patientCaseInfoVO.setDeptDetailName(consultationEntity.getDoctorDepName());
            patientCaseInfoVO.setCaseType(PatientCaseInfoDTO.CONSULTATION_TYPE);
            patientCaseInfoVO.setDoctorId(consultationEntity.getDoctorId());
            patientCaseInfoVO.setDoctorName(consultationEntity.getDoctorName());
            patientCaseInfoVO.setHospitalName(consultationEntity.getDoctorHosName());
            patientCaseInfoVO.setHospitalId(consultationEntity.getDoctorHospitalId());
            patientCaseInfoVO.setPatientId(consultationEntity.getPatientId());
            patientCaseInfoVO.setPatientName(consultationEntity.getPatientName());
            if (CollectionUtils.isNotEmpty((Collection)consultationPatientCaseInfoVO.getOssFileIds())) {
                List list = consultationPatientCaseInfoVO.getOssFileIds();
                ArrayList<String> strings = new ArrayList<String>();
                for (Long aLong : list) {
                    strings.add(aLong.toString());
                }
                String normalImages = String.join((CharSequence)",", strings);
                patientCaseInfoVO.setNormalImages(normalImages);
            }
            patientCaseInfoVO.setPresentHistory(consultationPatientCaseInfoVO.getPresentHistory());
            patientCaseInfoVO.setPastHistory(consultationPatientCaseInfoVO.getPastHistory());
            patientCaseInfoVO.setMainSuit(consultationPatientCaseInfoVO.getMainSuit());
            patientCaseInfoVO.setConsultAim(consultationPatientCaseInfoVO.getConsultAim());
            patientCaseInfoVO.setFamilyHistory(consultationPatientCaseInfoVO.getFamilyHistory());
            patientCaseInfoVO.setMedicationHistory(consultationPatientCaseInfoVO.getMedicationHistory());
            patientCaseInfoVO.setPrimaryDiagno(consultationPatientCaseInfoVO.getPrimaryDiagno());
            patientCaseInfoVO.setId(consultationEntity.getCaseId());
            int i = this.patientCaseInfoService.updatePatientCaseInfoByIdSelective(patientCaseInfoVO);
            consultationExtendEntity.setDcmFileUrl(consultationPatientCaseInfoVO.getDcmFileUrl());
            consultationExtendEntity.setDcmPackUrl(consultationPatientCaseInfoVO.getDcmPackUrl());
            this.consultationExtendService.update(consultationExtendEntity);
            if (i == 0) {
                throw new RuntimeException("\u66f4\u65b0\u75c5\u4f8b\u5f02\u5e38");
            }
        }
        return consultationEntity;
    }

    private List<String> isOrderQualified(ConsultationEntity consultationEntity) {
        int days;
        int patientNum;
        PatientCaseInfoEntity patientCaseInfoEntity;
        ConsultationReportEntity consultationReportEntity;
        ArrayList<String> list = new ArrayList<String>();
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (StringUtil.isEmpty((String)consultationEntity.getDoctorName()) || StringUtil.isEmpty((String)consultationEntity.getDoctorDepName()) || StringUtil.isEmpty((String)consultationEntity.getDoctorHosName())) {
            list.add(list.size() + 1 + ".\u966a\u8bca\u533b\u751f\u4fe1\u606f\u7f3a\u5931(\u533b\u9662+\u79d1\u5ba4+\u59d3\u540d)");
        }
        if (StringUtil.isEmpty((String)consultationEntity.getExpertName()) || StringUtil.isEmpty((String)consultationEntity.getExpertDeptName()) || StringUtil.isEmpty((String)consultationEntity.getExpertHosName())) {
            list.add(list.size() + 1 + ".\u4e13\u5bb6\u4fe1\u606f\u7f3a\u5931(\u533b\u9662+\u79d1\u5ba4+\u59d3\u540d)");
        }
        if (StringUtil.isEmpty((String)consultationEntity.getPatientInformedConsentUrl()) && StringUtil.isEmpty((String)consultationEntity.getPatientSignature())) {
            list.add(list.size() + 1 + ".\u77e5\u60c5\u540c\u610f\u4e66\u7f3a\u5931");
        }
        if (consultationEntity.getType() == 4 && StringUtil.isEmpty((String)consultationExtendEntity.getVideoUrl())) {
            list.add(list.size() + 1 + ".\u4f1a\u8bca\u89c6\u9891\u7f3a\u5931");
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) == null || consultationReportEntity.getStatus() != 1) {
            list.add(list.size() + 1 + ".\u4f1a\u8bca\u62a5\u544a\u7f3a\u5931");
        }
        if ((patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId())) == null || StringUtil.isEmpty((String)patientCaseInfoEntity.getMainSuit()) || StringUtil.isEmpty((String)patientCaseInfoEntity.getConsultAim()) || StringUtil.isEmpty((String)patientCaseInfoEntity.getNormalImages()) && StringUtil.isEmpty((String)consultationExtendEntity.getDcmPackUrl()) && StringUtil.isEmpty((String)consultationExtendEntity.getDcmFileUrl())) {
            list.add(list.size() + 1 + ".\u75c5\u4f8b\u4fe1\u606f\u7f3a\u5931(\u75c5\u60c5\u63cf\u8ff0+\u75c5\u4f8b\u9644\u4ef6)");
        }
        if (StringUtil.isEmpty((String)consultationEntity.getPatientName()) || StringUtil.isEmpty((String)consultationExtendEntity.getPatientPhone()) || StringUtil.isEmpty((String)consultationExtendEntity.getPatientIdCard())) {
            list.add(list.size() + 1 + ".\u60a3\u8005\u4fe1\u606f\u7f3a\u5931(\u60a3\u8005\u59d3\u540d+\u7535\u8bdd+\u8eab\u4efd\u8bc1)");
        }
        if ((patientNum = this.consultationService.queryConsultationListWeek(Integer.valueOf(days = 30), consultationEntity.getPatientId()).intValue()) > 3) {
            list.add(list.size() + 1 + ".\u6570\u636e\u91cd\u590d(\u60a3\u8005\u4fe1\u606f\u4e8e\u4e00\u4e2a\u6708\u5185\u91cd\u590d\u51fa\u73b0)");
        }
        return list;
    }

    public void dataDaily(ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity, DoctorEntityInfoVO doctorDetailInfoEntity, DoctorEntityInfoVO expertDoctorDetailInfoEntity) {
        consultationExtendEntity.setExpertFirstDeptid(Long.valueOf(expertDoctorDetailInfoEntity.getStdFirstDeptId() == null ? 0L : expertDoctorDetailInfoEntity.getStdFirstDeptId().longValue()));
        consultationExtendEntity.setExpertFirstDeptname(expertDoctorDetailInfoEntity.getStdFirstDeptName());
        consultationExtendEntity.setExpertDistCode(Long.valueOf(StringUtil.isNotEmpty((String)expertDoctorDetailInfoEntity.getAreaCode()) ? Long.parseLong(expertDoctorDetailInfoEntity.getAreaCode()) : 0L));
        consultationEntity.setExpertSecondDeptId(Long.valueOf(expertDoctorDetailInfoEntity.getStdSecondDeptId().longValue()));
        consultationEntity.setExpertSecondDeptName(expertDoctorDetailInfoEntity.getStdSecondDeptName());
        consultationExtendEntity.setDoctorFirstDeptId(Long.valueOf(doctorDetailInfoEntity.getStdFirstDeptId() == null ? 0L : doctorDetailInfoEntity.getStdFirstDeptId().longValue()));
        consultationExtendEntity.setDoctorFirstDeptName(doctorDetailInfoEntity.getStdFirstDeptName());
        consultationEntity.setDoctorSecondDeptId(Long.valueOf(doctorDetailInfoEntity.getStdSecondDeptId().longValue()));
        consultationEntity.setDoctorSecondDeptName(doctorDetailInfoEntity.getStdSecondDeptName());
        consultationExtendEntity.setDoctorDistCode(Long.valueOf(StringUtil.isNotEmpty((String)doctorDetailInfoEntity.getAreaCode()) ? Long.parseLong(doctorDetailInfoEntity.getAreaCode()) : 0L));
        this.consultationExtendService.update(consultationExtendEntity);
    }

    private BaseResponse<String> pumpPermission(String appCode, String userId) {
        String permissionUrl = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(appCode).append("/").append("permissions/api/v1/dataScope/getPermissionsByKey?key=YCHZ_").append(userId).toString();
        String userPermissions = "";
        try {
            log.info("\u7528\u6237userId:{}====>\u83b7\u53d6\u6743\u9650\u7684\u8bf7\u6c42\u662f:{}", (Object)userId, (Object)permissionUrl);
            userPermissions = HttpUtils.get((String)permissionUrl);
            log.info("\u7528\u6237userId:{}====>\u8fd4\u56de\u6743\u9650\u8bf7\u6c42\u662f:{}", (Object)userId, (Object)userPermissions);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return (BaseResponse)JSONObject.parseObject((String)userPermissions, BaseResponse.class);
    }

    public ResultInfo<List<HosManageOrderDto>> queryHospitalManageOrderByHospitalId(String appCode, String userId, Integer pageIndex, Integer pageSize, String search, String beginTime, String endTime, String depName, Integer status, Integer isSponsor) {
        int total = 0;
        if (StringUtil.isNotEmpty((String)beginTime)) {
            beginTime = beginTime + " 00:00:00";
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            endTime = endTime + " 23:59:59";
        }
        log.info("\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u4ece\u524d\u7aef\u83b7\u53d6\u7684appCode\u662f{}=====userId\u662f:{}", (Object)appCode, (Object)userId);
        List nodeOrganInfosList = this.ihosBaseDataRemote.getNodeOrganInfos(appCode);
        List<Long> hospitalIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)nodeOrganInfosList)) {
            for (OrganizationResVO organizationVo : nodeOrganInfosList) {
                hospitalIds.add(Long.parseLong(organizationVo.getOrganId()));
            }
        }
        log.info("\u8be5\u8282\u70b9\u4e0b\u7684\u6240\u6709\u7684\u533b\u9662\u662f:{}", (Object)((Object)hospitalIds).toString());
        BaseResponse stringBaseResponse = this.pumpPermission(appCode, userId);
        if (!ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(stringBaseResponse.getCode()) || StringUtil.isBlank((String)((String)stringBaseResponse.getData()))) {
            return this.returnFailure("\u6b64\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u67e5\u770b\u8ba2\u5355\u7684\u6743\u9650!");
        }
        List consultationEntityList = null;
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        String hospitalIdsStr = (String)stringBaseResponse.getData();
        if (StringUtil.isEmpty((String)hospitalIdsStr)) {
            consultationEntityList = null;
        } else if (StringUtil.isNotEmpty((String)hospitalIdsStr) && !hospitalIdsStr.equals("-1")) {
            hospitalIds = Arrays.asList(hospitalIdsStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            consultationEntityList = this.consultationService.getConsultationEntityListApplyByHosId(hospitalIds, search, beginTime, endTime, depName, status, isSponsor);
        } else {
            consultationEntityList = this.consultationService.getConsultationEntityListApplyByHosId(hospitalIds, search, beginTime, endTime, depName, status, isSponsor);
        }
        if (CollectionUtils.isEmpty(consultationEntityList)) {
            log.info("======\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u67e5\u8be2\u8282\u70b9\u4e3a:{}\u6ca1\u6709\u8ba2\u5355=======", (Object)appCode);
            return this.returnSucceed("\u6b64\u8282\u70b9\u65e0\u8ba2\u5355");
        }
        PageInfo pageInfo = new PageInfo(consultationEntityList);
        ArrayList<HosManageOrderDto> list = new ArrayList<HosManageOrderDto>();
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            ConsultationReportEntity consultationReport;
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            HosManageOrderDto hosManageOrderDto = new HosManageOrderDto();
            hosManageOrderDto.setOrderId(consultationEntity.getId());
            hosManageOrderDto.setOrderCreateTime(consultationEntity.getCreateTime().toString());
            String format = DateTimeUtil.formatTime((Date)consultationEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            hosManageOrderDto.setOrderCreateTimeStr(format);
            hosManageOrderDto.setOrderViewId(consultationEntity.getViewId());
            hosManageOrderDto.setOrderStatus(consultationEntity.getStatus());
            hosManageOrderDto.setOrderType(consultationEntity.getType());
            hosManageOrderDto.setConsultationDate(consultationEntity.getConsultationDate());
            hosManageOrderDto.setConsultationTime(consultationEntity.getConsultationTime());
            hosManageOrderDto.setBeginTime(consultationEntity.getBeginTime());
            hosManageOrderDto.setFinishTime(consultationEntity.getFinishTime());
            hosManageOrderDto.setAcceptTime(consultationEntity.getAcceptTime());
            hosManageOrderDto.setCloseTime(consultationEntity.getClosedTime());
            hosManageOrderDto.setOrderPrice(consultationExtendEntity.getPrice());
            hosManageOrderDto.setOrderApplicationChannels(consultationEntity.getApplicationChannels());
            hosManageOrderDto.setGroupId(consultationEntity.getGroupId());
            hosManageOrderDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
            if (consultationEntity.getStatus() >= OrderStatusEnum.WAIT_DISTRIBUTION.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue() && consultationEntity.getExpertHospitalId() != 0L) {
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
                if (appCode.equalsIgnoreCase(expertAppCode)) {
                    hosManageOrderDto.setIsApply(Integer.valueOf(2));
                } else {
                    hosManageOrderDto.setIsApply(Integer.valueOf(1));
                }
            }
            hosManageOrderDto.setOrderNum(Integer.valueOf(total));
            hosManageOrderDto.setPatientId(consultationEntity.getPatientId());
            hosManageOrderDto.setPatientName(consultationEntity.getPatientName());
            hosManageOrderDto.setPatientSex(consultationExtendEntity.getPatientSex());
            hosManageOrderDto.setPatientAge(consultationExtendEntity.getPatientAge());
            hosManageOrderDto.setDocId(consultationEntity.getDoctorId());
            hosManageOrderDto.setDocName(consultationEntity.getDoctorName());
            hosManageOrderDto.setDocDepName(consultationEntity.getDoctorDepName());
            hosManageOrderDto.setDoctorHospitalId(consultationEntity.getDoctorHospitalId());
            hosManageOrderDto.setDocHosName(consultationEntity.getDoctorHosName());
            hosManageOrderDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
            hosManageOrderDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
            hosManageOrderDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
            hosManageOrderDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
            hosManageOrderDto.setExpertHospitalId(consultationEntity.getExpertHospitalId());
            hosManageOrderDto.setOrderNum(Integer.valueOf(Integer.parseInt(String.valueOf(pageInfo.getTotal()))));
            if (consultationEntity.getStatus().intValue() == OrderStatusEnum.FINISH.getValue().intValue() && (consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) != null && consultationReport.getStatus() == 1) {
                hosManageOrderDto.setIsReport(Integer.valueOf(1));
            }
            hosManageOrderDto.setPatientTel(consultationExtendEntity.getPatientPhone());
            hosManageOrderDto.setDocTel(consultationExtendEntity.getDoctorPhone());
            hosManageOrderDto.setExpertTel(consultationExtendEntity.getExpertPhone());
            list.add(hosManageOrderDto);
        }
        return this.returnSucceed(list, "\u533b\u9662\u7ba1\u7406\u540e\u53f0\u7ba1\u7406\u8ba2\u5355\u6210\u529f");
    }

    public List<AppOrderListVo> getAppOrderList(Long docorId, List<Integer> produces, List<Integer> orderStatus, List<Integer> orderTypes, String searchParam, Integer pageIndex, Integer pageSize) {
        ArrayList<AppOrderListVo> appOrderListVos = new ArrayList<AppOrderListVo>();
        List list = null;
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        list = produces != null && produces.size() == 1 && produces.get(0).equals(ConsultationConstant.TYPE_APPLY) ? this.consultationService.getAppOrderList(docorId, ConsultationConstant.TYPE_APPLY, orderStatus, orderTypes, searchParam) : (produces != null && produces.size() == 1 && produces.get(0).equals(ConsultationConstant.TYPE_RECEIVE) ? this.consultationService.getAppOrderList(docorId, ConsultationConstant.TYPE_RECEIVE, orderStatus, orderTypes, searchParam) : this.consultationService.getAppOrderList(docorId, ConsultationConstant.TYPE_ALL, orderStatus, orderTypes, searchParam));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ConsultationEntity entity : list) {
                String consultationTime;
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(entity.getId());
                AppOrderListVo appOrderListVo = new AppOrderListVo();
                appOrderListVo.setPatientName(entity.getPatientName());
                appOrderListVo.setPatientAge(consultationExtendEntity.getPatientAge());
                appOrderListVo.setPatientSex(consultationExtendEntity.getPatientSex());
                appOrderListVo.setOrderStatus(entity.getStatus());
                Integer procedure = entity.getDoctorId().equals(docorId) ? ConsultationConstant.TYPE_APPLY : ConsultationConstant.TYPE_RECEIVE;
                appOrderListVo.setProcedure(procedure);
                appOrderListVo.setOrderId(entity.getId());
                appOrderListVo.setOrderViewId(entity.getViewId());
                appOrderListVo.setOrderType(entity.getType());
                String groupId = "";
                if (entity.getStatus() >= OrderStatusEnum.WAITING.getValue() && entity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue() && StringUtil.isEmpty((String)entity.getGroupId())) {
                    log.info("\u8ba2\u5355\u5217\u8868groupId\u8865\u507f\u673a\u5236,\u8ba2\u5355id\u662f:" + entity.getId());
                    try {
                        Map map = this.commonService.creatRongCloudGroup(entity.getId());
                        groupId = (String)map.get("groupId");
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    groupId = entity.getGroupId();
                }
                entity.setGroupId(groupId);
                appOrderListVo.setGroupId(entity.getGroupId());
                appOrderListVo.setApplicationChannal(entity.getApplicationChannels());
                if (StringUtil.isNotEmpty((String)entity.getClosedTime())) {
                    appOrderListVo.setCloseTime(entity.getClosedTime());
                }
                appOrderListVo.setCreateTime(DateTimeUtil.formatTime((Date)entity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                appOrderListVo.setUpdateTime(DateTimeUtil.formatTime((Date)entity.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(entity.getViewId());
                Integer isHaveReport = consultationReportEntity == null ? ConsultationConstant.NO_REPORT : ConsultationConstant.HAVE_REPORT;
                appOrderListVo.setIsHaveReport(isHaveReport);
                if (ConsultationConstant.HAVE_REPORT.equals(isHaveReport)) {
                    appOrderListVo.setReportStatus(consultationReportEntity.getStatus());
                }
                appOrderListVo.setDoctorName(entity.getDoctorName());
                appOrderListVo.setDoctorDeptName(entity.getDoctorDepName());
                appOrderListVo.setDoctorHosName(entity.getDoctorHosName());
                appOrderListVo.setDoctorId(entity.getDoctorId());
                appOrderListVo.setMainSuit(this.patientCaseInfoService.selectPatientCaseInfoById(Long.valueOf(entity.getCaseId())).getMainSuit());
                String expertName = StringUtil.isNotEmpty((String)entity.getExpertName()) ? entity.getExpertName() : "";
                appOrderListVo.setExpertName(expertName);
                String expertDeptName = StringUtil.isNotEmpty((String)entity.getExpertDeptName()) ? entity.getExpertDeptName() : "";
                String expertHosName = StringUtil.isNotEmpty((String)entity.getExpertHosName()) ? entity.getExpertHosName() : "";
                appOrderListVo.setExpertDeptName(expertDeptName);
                appOrderListVo.setExpertHosName(expertHosName);
                String beginTime = StringUtil.isNotEmpty((String)entity.getBeginTime()) ? entity.getBeginTime() : "";
                appOrderListVo.setStartTime(beginTime);
                String endTime = StringUtil.isNotEmpty((String)entity.getFinishTime()) ? entity.getFinishTime() : "";
                appOrderListVo.setEndTime(endTime);
                String consultationDate = StringUtil.isNotEmpty((String)entity.getConsultationDate()) ? entity.getConsultationDate() : "";
                String string = consultationTime = StringUtil.isNotEmpty((String)entity.getConsultationTime()) ? entity.getConsultationTime() : "";
                if (StringUtil.isNotEmpty((String)consultationDate) && StringUtil.isNotEmpty((String)consultationDate)) {
                    appOrderListVo.setConsultationTime(consultationDate + " " + consultationTime);
                }
                appOrderListVos.add(appOrderListVo);
            }
        }
        return appOrderListVos;
    }

    public Map<String, String> patientAddOrder(WechatConsultationVO wechatConsultationVO) {
        HashMap<String, String> map = new HashMap<String, String>();
        Long viewId = 0L;
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(wechatConsultationVO.getDoctorId());
        BaseResponse doctorAuditVOBaseResponse = this.iCloudAccountApiClient.getSecondAudit(wechatConsultationVO.getDoctorId().toString());
        if (doctorAuditVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && doctorAuditVOBaseResponse.getData() != null) {
            map.put("code", ReturnCodeEnum.FAILURE.getValue());
            map.put("msg", "\u6b64\u966a\u8bca\u533b\u751f\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4e0b\u5355!");
            return map;
        }
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(wechatConsultationVO.getPatientId(), Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        QueryOrganDetailVO doctorHospital = this.remoteManage.getHospitalDetailById(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
        patientCaseInfoVO.setCaseName("");
        patientCaseInfoVO.setUserId(wechatConsultationVO.getUserId());
        patientCaseInfoVO.setMainSuit(wechatConsultationVO.getMainSuit() != null ? wechatConsultationVO.getMainSuit() : "");
        patientCaseInfoVO.setFamilyHistory(StringUtil.isEmpty((String)wechatConsultationVO.getFamilyHistory()) ? wechatConsultationVO.getFamilyHistory() : "");
        patientCaseInfoVO.setMedicationHistory(StringUtil.isNotEmpty((String)wechatConsultationVO.getMedicationHistory()) ? wechatConsultationVO.getMedicationHistory() : "");
        patientCaseInfoVO.setPatientName(patientInfoRespVO.getName());
        patientCaseInfoVO.setHospitalName(doctorHospital.getOrganName());
        patientCaseInfoVO.setDoctorName(doctorEntityInfoVO.getName());
        patientCaseInfoVO.setDoctorId(doctorEntityInfoVO.getId());
        patientCaseInfoVO.setDeptDetailId(Long.valueOf(doctorEntityInfoVO.getHospitalDeptId().longValue()));
        patientCaseInfoVO.setDeptDetailName(doctorEntityInfoVO.getHospitalDeptName());
        patientCaseInfoVO.setCaseType(PatientCaseInfoDTO.CONSULTATION_TYPE);
        if (CollectionUtils.isNotEmpty((Collection)wechatConsultationVO.getOssFileIds())) {
            List list = wechatConsultationVO.getOssFileIds();
            ArrayList<String> strings = new ArrayList<String>();
            for (Long aLong : list) {
                strings.add(aLong.toString());
            }
            String normalImages = String.join((CharSequence)",", strings);
            patientCaseInfoVO.setNormalImages(normalImages);
        }
        patientCaseInfoVO.setPastHistory("");
        patientCaseInfoVO.setPresentHistory("");
        patientCaseInfoVO.setHospitalId(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        patientCaseInfoVO.setPrimaryDiagno(wechatConsultationVO.getPrimaryDiagno() != null ? wechatConsultationVO.getPrimaryDiagno() : "");
        patientCaseInfoVO.setConsultAim(wechatConsultationVO.getConsultAim() != null ? wechatConsultationVO.getConsultAim() : "");
        patientCaseInfoVO.setPatientId(Long.valueOf(0L));
        patientCaseInfoVO.setPatientViewId(wechatConsultationVO.getPatientId().toString());
        this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
        ConsultationEntity consultationEntity = new ConsultationEntity();
        ConsultationExtendEntity consultationExtendEntity = new ConsultationExtendEntity();
        LocalDate today = LocalDate.now();
        LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(wechatConsultationVO.getAge()));
        Long age = ChronoUnit.YEARS.between(birthday, today);
        consultationExtendEntity.setPatientAge(Integer.valueOf(age.intValue()));
        consultationExtendEntity.setPatientSex(wechatConsultationVO.getSex());
        consultationExtendEntity.setPatientIdCard(patientInfoRespVO.getCredNo());
        consultationExtendEntity.setPatientPhone(wechatConsultationVO.getMobileNumber());
        BeanUtils.copyProperties((Object)wechatConsultationVO, (Object)consultationEntity);
        consultationEntity.setCaseId(patientCaseInfoVO.getId());
        viewId = UniqueKeyGenerator.generateViewId();
        consultationEntity.setViewId(viewId.toString());
        consultationExtendEntity.setInitiatorType(ConsultationConstant.TYPE_INITIATOR_PATIENT);
        consultationEntity.setDoctorId(doctorEntityInfoVO.getId());
        consultationEntity.setDoctorName(doctorEntityInfoVO.getName());
        consultationExtendEntity.setDoctorPhone(doctorEntityInfoVO.getRegisterMobile());
        consultationEntity.setDoctorDepId(Long.valueOf(doctorEntityInfoVO.getHospitalDeptId().longValue()));
        consultationEntity.setDoctorDepName(doctorEntityInfoVO.getHospitalDeptName());
        consultationEntity.setDoctorHospitalId(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        String accompanyAppCode = this.remoteManage.getAppCodeByHospitalId(doctorEntityInfoVO.getOrganId());
        consultationEntity.setAccompanyAppCode(accompanyAppCode);
        consultationEntity.setDoctorHosName(doctorHospital.getOrganName());
        consultationEntity.setStatus(OrderStatusEnum.NEW_APPLY.getValue());
        consultationEntity.setPatientSignature(wechatConsultationVO.getPatientSignature());
        consultationEntity.setPatientName(patientInfoRespVO.getName());
        consultationExtendEntity.setUserPhone(wechatConsultationVO.getUserPhone());
        ConsultationEntity consultation = this.consultationService.saveConsultation(consultationEntity);
        consultationExtendEntity.setConsultationId(consultation.getId());
        consultationExtendEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
        consultationExtendEntity.setPatientNo(wechatConsultationVO.getPatientNo());
        ConsultationExtendEntity extendEntity = this.consultationExtendService.insert(consultationExtendEntity);
        if (consultation.getId() == null || extendEntity.getId() == null) {
            map.put("code", ReturnCodeEnum.CONSULTATION_SERVER_ERROR.getValue().toString());
            map.put("msg", "\u4e0b\u5355\u51fa\u9519");
            return map;
        }
        map.put("code", ReturnCodeEnum.SUCCEED.getValue().toString());
        map.put("msg", ReturnCodeEnum.SUCCEED.getDisplay());
        map.put("viewId", viewId.toString());
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultInfo<ImproveOrderResVO> improveOrder(WechatConsultationVO wechatConsultationVO) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(wechatConsultationVO.getId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null) {
            return this.returnFailure("\u5b8c\u5584\u7684\u65b0\u7533\u8bf7\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        if (consultationEntity.getStatus() >= OrderStatusEnum.WAIT_DISTRIBUTION.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue()) {
            return this.returnFailure("\u6b64\u8ba2\u5355\u5df2\u7ecf\u5b8c\u5584\u8fc7\u4e00\u6b21\uff0c\u5207\u52ff\u91cd\u590d\u5b8c\u5584!");
        }
        log.info("\u5b8c\u5584\u8ba2\u5355\u4fe1\u606f\u4f20\u7684\u53c2\u6570\u662f:" + wechatConsultationVO.toString());
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        BaseResponse doctorAuditVOBaseResponse = this.iCloudAccountApiClient.getSecondAudit(consultationEntity.getDoctorId().toString());
        if (doctorAuditVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && doctorAuditVOBaseResponse.getData() != null) {
            return new ResultInfo(ReturnCodeEnum.FAILURE.getValue(), "\u6b64\u966a\u8bca\u533b\u751f\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4e0b\u5355!", null);
        }
        consultationEntity.setApplicationChannels(wechatConsultationVO.getApplicationChannels());
        consultationExtendEntity.setDcmPackUrl(wechatConsultationVO.getDcmPackUrl());
        consultationEntity.setDeptType(wechatConsultationVO.getDeptType());
        consultationEntity.setType(wechatConsultationVO.getType());
        consultationExtendEntity.setPrice(new BigDecimal(0));
        consultationEntity.setDeptType(wechatConsultationVO.getDeptType());
        consultationEntity.setExpertDepId(wechatConsultationVO.getDeptId());
        consultationExtendEntity.setDcmFileUrl(wechatConsultationVO.getDcmFileUrl());
        Integer serviceId = 0;
        serviceId = wechatConsultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() ? (wechatConsultationVO.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_HOSPITAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_HOSPITAL.getValue()) : (wechatConsultationVO.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_PERSERNAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_PERSONAL.getValue());
        consultationEntity.setServiceCode(serviceId);
        PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
        PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
        if (patientCaseInfoEntity == null) return this.returnFailure("\u60a3\u8005\u75c5\u5386\u4e0d\u5b58\u5728");
        patientCaseInfoEntity.setFamilyHistory(StringUtil.isNotEmpty((String)wechatConsultationVO.getFamilyHistory()) ? wechatConsultationVO.getFamilyHistory() : patientCaseInfoEntity.getFamilyHistory());
        patientCaseInfoEntity.setMainSuit(StringUtil.isNotEmpty((String)wechatConsultationVO.getMainSuit()) ? wechatConsultationVO.getMainSuit() : patientCaseInfoEntity.getMainSuit());
        patientCaseInfoEntity.setConsultAim(StringUtil.isNotEmpty((String)wechatConsultationVO.getConsultAim()) ? wechatConsultationVO.getConsultAim() : patientCaseInfoEntity.getConsultAim());
        patientCaseInfoEntity.setMedicationHistory(StringUtil.isNotEmpty((String)wechatConsultationVO.getMedicationHistory()) ? wechatConsultationVO.getMedicationHistory() : patientCaseInfoEntity.getMedicationHistory());
        patientCaseInfoEntity.setPastHistory(StringUtil.isNotEmpty((String)wechatConsultationVO.getPastHistory()) ? wechatConsultationVO.getPastHistory() : patientCaseInfoEntity.getPastHistory());
        patientCaseInfoEntity.setPresentHistory(StringUtil.isNotEmpty((String)wechatConsultationVO.getPresentHistory()) ? wechatConsultationVO.getPresentHistory() : patientCaseInfoEntity.getPresentHistory());
        patientCaseInfoEntity.setPrimaryDiagno(StringUtil.isNotEmpty((String)wechatConsultationVO.getPrimaryDiagno()) ? wechatConsultationVO.getPrimaryDiagno() : patientCaseInfoEntity.getPrimaryDiagno());
        patientCaseInfoEntity.setInitalDiagnosis(StringUtil.isNotEmpty((String)wechatConsultationVO.getPrimaryDiagno()) ? wechatConsultationVO.getPrimaryDiagno() : patientCaseInfoEntity.getPrimaryDiagno());
        if (CollectionUtils.isNotEmpty((Collection)wechatConsultationVO.getOssFileIds())) {
            List list = wechatConsultationVO.getOssFileIds();
            ArrayList<String> strings = new ArrayList<String>();
            for (Long aLong : list) {
                strings.add(aLong.toString());
            }
            String normalImages = String.join((CharSequence)",", strings);
            patientCaseInfoEntity.setNormalImages(normalImages);
        }
        BeanUtils.copyProperties((Object)patientCaseInfoEntity, (Object)patientCaseInfoVO);
        int updateValue = this.patientCaseInfoService.updatePatientCaseInfoByIdSelective(patientCaseInfoVO);
        if (updateValue != 1) {
            return this.returnFailure("\u5b8c\u5584\u75c5\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        if (wechatConsultationVO.getApplicationChannels().intValue() != ConsultationConstant.TYPE_APPLICATION_DISTRIBUTION.intValue()) {
            DoctorEntityInfoVO expertEntityInfoVO = this.remoteManage.getDoctorDetailById(wechatConsultationVO.getExpertId());
            if (doctorEntityInfoVO == null || expertEntityInfoVO == null) return this.returnFailure("\u4e13\u5bb6\u4e0d\u5b58\u5728");
            BaseResponse expertAuditVOBaseResponse = this.iCloudAccountApiClient.getSecondAudit(wechatConsultationVO.getExpertId().toString());
            if (expertAuditVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && expertAuditVOBaseResponse.getData() != null) {
                return new ResultInfo(ReturnCodeEnum.FAILURE.getValue(), "\u6b64\u63a5\u8bca\u4e13\u5bb6\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4e0b\u5355!", null);
            }
            consultationEntity.setExpertName(expertEntityInfoVO.getName());
            consultationEntity.setExpertType(expertEntityInfoVO.getDoctorType());
            consultationEntity.setExpertHospitalId(Long.valueOf(expertEntityInfoVO.getOrganId().longValue()));
            String expertHosNmame = this.remoteManage.getHospitalDetailById(Long.valueOf(expertEntityInfoVO.getOrganId().longValue())).getOrganName();
            consultationEntity.setExpertHosName(expertHosNmame);
            consultationEntity.setExpertId(expertEntityInfoVO.getId());
            consultationExtendEntity.setExpertPhone(expertEntityInfoVO.getRegisterMobile());
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(expertEntityInfoVO.getOrganId());
            consultationExtendEntity.setClinicalAppCode(expertAppCode);
            this.dataDaily(consultationEntity, consultationExtendEntity, doctorEntityInfoVO, expertEntityInfoVO);
            if (wechatConsultationVO.getDeptType().intValue() == ConsultationConstant.TYPE_DEPT_STANDARD.intValue()) {
                StandDeptInfoResVO standDeptInfoVO = this.departMentInfoRemote.getStandDeptDetailId(wechatConsultationVO.getDeptId(), Long.valueOf(expertEntityInfoVO.getOrganId().longValue()));
                consultationEntity.setExpertDeptName(standDeptInfoVO.getDisplayName());
            } else {
                consultationEntity.setExpertDeptName(expertEntityInfoVO.getHospitalDeptName());
            }
        } else if (wechatConsultationVO.getDeptType().intValue() == ConsultationConstant.TYPE_DEPT_STANDARD.intValue()) {
            StandDeptInfoResVO standDeptInfoVO = this.departMentInfoRemote.getStandDeptDetailId(wechatConsultationVO.getDeptId(), Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
            consultationEntity.setExpertDeptName(standDeptInfoVO.getDisplayName());
        } else {
            QueryOrganDetailVO queryOrganDetailVO = this.remoteManage.getHospitalDetailById(wechatConsultationVO.getExpertHospitalId());
            consultationEntity.setExpertHospitalId(wechatConsultationVO.getExpertHospitalId());
            consultationEntity.setExpertHosName(queryOrganDetailVO.getOrganName());
            DepartmentResVO hosDeptInfo = this.departMentInfoRemote.getHosDeptDetailId(wechatConsultationVO.getDeptId(), wechatConsultationVO.getExpertHospitalId());
            consultationEntity.setExpertDeptName(hosDeptInfo.getDeptName());
        }
        int value = this.consultationService.updateConsultationEntity(consultationEntity);
        this.consultationExtendService.update(consultationExtendEntity);
        if (value != 1) {
            return this.returnFailure("\u66f4\u65b0\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u7f16\u53f7:" + consultationEntity.getId());
        }
        log.info("-------\u521d\u6b65\u5b8c\u5584\u8ba2\u5355\u8868\u4fe1\u606f\u6210\u529f---------");
        ConsultationEntity dataResult = (ConsultationEntity)this.orderStatusAndPayType(consultationEntity).getData();
        if (OrderStatusEnum.WAITING.getValue().intValue() == dataResult.getStatus().intValue()) {
            try {
                Map map = this.commonService.creatRongCloudGroupTwo(dataResult, patientCaseInfoVO);
                log.info((String)map.get("msg"));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return this.returnFailure("\u878d\u4e91\u670d\u52a1\u9519\u8bef" + e.getCause());
            }
        }
        log.info("======\u5168\u90e8\u5b8c\u5584\u8ba2\u5355\u4fe1\u606f\u6210\u529f=======");
        ImproveOrderResVO improveOrderResVO = new ImproveOrderResVO();
        BeanUtils.copyProperties((Object)dataResult, (Object)improveOrderResVO);
        improveOrderResVO.setInitiatorType(consultationExtendEntity.getInitiatorType());
        improveOrderResVO.setPrice(consultationExtendEntity.getPrice());
        return this.returnSucceed((Object)improveOrderResVO, "\u66f4\u65b0\u6210\u529f!");
    }

    public List<OrderDetailDto> getWeixinOrderListByPatientId(String appCode, Integer pageIndex, Integer pageSize, Long patientId) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        ArrayList<OrderDetailDto> orderDetailDtos = new ArrayList<OrderDetailDto>();
        List list = this.consultationService.getListByPatientId(patientId, appCode);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ConsultationEntity consultationEntity : list) {
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                OrderDetailDto orderDetailDto = new OrderDetailDto();
                orderDetailDto.setOrderId(consultationEntity.getId());
                orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
                orderDetailDto.setOrderViewId(consultationEntity.getViewId());
                orderDetailDto.setOrderStatus(consultationEntity.getStatus());
                orderDetailDto.setOrderType(consultationEntity.getType());
                orderDetailDto.setOrderPrice(consultationExtendEntity.getPrice());
                orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
                orderDetailDto.setWeixinOrderUpdateTime(DateTimeUtil.formatTime((Date)consultationEntity.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
                orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
                orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
                orderDetailDto.setConsultationDate(consultationEntity.getConsultationDate());
                orderDetailDto.setConsultationTime(consultationEntity.getConsultationTime());
                orderDetailDto.setOrderClosedTime(consultationEntity.getClosedTime());
                orderDetailDto.setPatientId(consultationEntity.getPatientId());
                orderDetailDto.setPatientName(consultationEntity.getPatientName());
                orderDetailDto.setPatientSex(consultationExtendEntity.getPatientSex());
                orderDetailDto.setPatientAge(consultationExtendEntity.getPatientAge());
                orderDetailDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
                orderDetailDto.setDocId(consultationEntity.getDoctorId());
                orderDetailDto.setDocName(consultationEntity.getDoctorName());
                orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
                orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
                orderDetailDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
                orderDetailDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
                orderDetailDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
                orderDetailDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
                orderDetailDto.setPatientTel(consultationExtendEntity.getPatientPhone());
                PatientCaseInfoEntity PatientCaseInfoDTO2 = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
                if (PatientCaseInfoDTO2 != null) {
                    orderDetailDto.setPatCaseMainSuit(PatientCaseInfoDTO2.getMainSuit());
                }
                orderDetailDtos.add(orderDetailDto);
            }
        }
        return orderDetailDtos;
    }

    public List<OrderDetailDto> getWeixinOrderListByUserId(String appCode, Integer pageIndex, Integer pageSize, Long userId) {
        ArrayList<OrderDetailDto> orderDetailDtos = new ArrayList<OrderDetailDto>();
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List patientInfoListRespVOList = this.userCenterRemote.getUserBindPatientList(appCode, userId.toString());
        if (CollectionUtils.isNotEmpty((Collection)patientInfoListRespVOList)) {
            List<Object> patientStrList = new ArrayList();
            patientStrList = patientInfoListRespVOList.stream().map(queryPatientInfoListRespVO -> Long.parseLong(queryPatientInfoListRespVO.getPatientId())).collect(Collectors.toList());
            List list = this.consultationService.getListByPatientIds(patientStrList, appCode);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (ConsultationEntity consultationEntity : list) {
                    ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                    OrderDetailDto orderDetailDto = new OrderDetailDto();
                    orderDetailDto.setOrderId(consultationEntity.getId());
                    orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
                    orderDetailDto.setOrderViewId(consultationEntity.getViewId());
                    orderDetailDto.setOrderStatus(consultationEntity.getStatus());
                    orderDetailDto.setOrderType(consultationEntity.getType());
                    orderDetailDto.setOrderPrice(consultationExtendEntity.getPrice());
                    orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
                    orderDetailDto.setWeixinOrderUpdateTime(DateTimeUtil.formatTime((Date)consultationEntity.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
                    orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
                    orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
                    orderDetailDto.setConsultationDate(consultationEntity.getConsultationDate());
                    orderDetailDto.setConsultationTime(consultationEntity.getConsultationTime());
                    orderDetailDto.setOrderClosedTime(consultationEntity.getClosedTime());
                    orderDetailDto.setPatientId(consultationEntity.getPatientId());
                    orderDetailDto.setPatientName(consultationEntity.getPatientName());
                    orderDetailDto.setPatientSex(consultationExtendEntity.getPatientSex());
                    orderDetailDto.setPatientAge(consultationExtendEntity.getPatientAge());
                    orderDetailDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
                    orderDetailDto.setDocId(consultationEntity.getDoctorId());
                    orderDetailDto.setDocName(consultationEntity.getDoctorName());
                    orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
                    orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
                    orderDetailDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
                    orderDetailDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
                    orderDetailDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
                    orderDetailDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
                    orderDetailDto.setPatientTel(consultationExtendEntity.getPatientPhone());
                    PatientCaseInfoEntity PatientCaseInfoDTO2 = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
                    if (PatientCaseInfoDTO2 != null) {
                        orderDetailDto.setPatCaseMainSuit(PatientCaseInfoDTO2.getMainSuit());
                    }
                    orderDetailDtos.add(orderDetailDto);
                }
            }
        }
        return orderDetailDtos;
    }

    public int appWorkbenchCount(Long doctorId) {
        return this.consultationService.appWorkbenchCount(doctorId);
    }

    public int reportHasUploaded(Long doctorId) {
        return this.consultationService.reportHasUploaded(doctorId);
    }

    public int completedAllCount(Long doctorId) {
        return this.consultationService.completedAllCount(doctorId);
    }

    public Map<String, String> addImageOrder(ConsultationVO consultationVO) {
        log.info("\u4e0b\u5355\u65f6\u4f20\u9012\u7684\u53c2\u6570\u662f:" + consultationVO.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationVO.getDoctorId());
        String doctorDeptName = doctorEntityInfoVO.getHospitalDeptName();
        String doctorHosName = this.remoteManage.getHospitalDetailById(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue())).getOrganName();
        PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
        patientCaseInfoVO.setUserId(Long.valueOf(0L));
        patientCaseInfoVO.setMainSuit(consultationVO.getMainSuit() != null ? consultationVO.getMainSuit() : "");
        if (CollectionUtils.isNotEmpty((Collection)consultationVO.getOssFileIds())) {
            List list = consultationVO.getOssFileIds();
            ArrayList<String> strings = new ArrayList<String>();
            for (Long aLong : list) {
                strings.add(aLong.toString());
            }
            String normalImages = String.join((CharSequence)",", strings);
            patientCaseInfoVO.setNormalImages(normalImages);
        }
        patientCaseInfoVO.setPastHistory(consultationVO.getPastHistory());
        patientCaseInfoVO.setPresentHistory(consultationVO.getPresentHistory());
        patientCaseInfoVO.setHospitalId(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        patientCaseInfoVO.setPrimaryDiagno(consultationVO.getPrimaryDiagno() != null ? consultationVO.getPrimaryDiagno() : "");
        patientCaseInfoVO.setConsultAim(consultationVO.getConsultAim() != null ? consultationVO.getConsultAim() : "");
        patientCaseInfoVO.setPatientViewId(consultationVO.getPatientId().toString());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationVO.getPatientId(), consultationVO.getDoctorId());
        patientCaseInfoVO.setPatientName(patientInfoRespVO.getName());
        patientCaseInfoVO.setDoctorId(consultationVO.getDoctorId());
        patientCaseInfoVO.setDoctorName(doctorEntityInfoVO.getName());
        patientCaseInfoVO.setCaseType(PatientCaseInfoDTO.CONSULTATION_TYPE);
        patientCaseInfoVO.setHospitalName(doctorHosName);
        patientCaseInfoVO.setDeptDetailName(doctorDeptName);
        patientCaseInfoVO.setFamilyHistory(StringUtil.isNotEmpty((String)consultationVO.getFamilyHistory()) ? consultationVO.getFamilyHistory() : "");
        patientCaseInfoVO.setMedicationHistory(StringUtil.isNotEmpty((String)consultationVO.getMedicationHistory()) ? consultationVO.getMedicationHistory() : "");
        PatientCaseInfoVO caseInfoVO = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
        ConsultationEntity consultationEntity = new ConsultationEntity();
        ConsultationExtendEntity consultationExtendEntity = new ConsultationExtendEntity();
        BeanUtils.copyProperties((Object)consultationVO, (Object)consultationEntity);
        consultationEntity.setCaseId(caseInfoVO.getId());
        String orderViewId = UniqueKeyGenerator.generateViewId().toString();
        consultationEntity.setViewId(orderViewId);
        consultationEntity.setDoctorId(consultationVO.getDoctorId());
        consultationExtendEntity.setPatientSex(consultationVO.getSex());
        consultationExtendEntity.setPatientIdCard(consultationVO.getIdcard());
        consultationExtendEntity.setPatientPhone(consultationVO.getMobileNumber());
        LocalDate today = LocalDate.now();
        LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(consultationVO.getAge()));
        Long age = ChronoUnit.YEARS.between(birthday, today);
        consultationExtendEntity.setPatientAge(Integer.valueOf(age.intValue()));
        BigDecimal price = null;
        if (consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() || consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_EXPERT.intValue()) {
            Integer serviceId = 0;
            serviceId = consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() ? (consultationVO.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_HOSPITAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_HOSPITAL.getValue()) : (consultationVO.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_PERSERNAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_PERSONAL.getValue());
            DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationVO.getExpertId());
            consultationEntity.setServiceCode(serviceId);
            consultationEntity.setExpertName(expertDetailInfoEntity.getName());
            consultationEntity.setExpertHospitalId(Long.valueOf(expertDetailInfoEntity.getOrganId().longValue()));
            consultationEntity.setExpertId(consultationVO.getExpertId());
            consultationExtendEntity.setExpertPhone(expertDetailInfoEntity.getRegisterMobile());
            consultationEntity.setExpertType(expertDetailInfoEntity.getDoctorType());
            String expertHosName = this.remoteManage.getHospitalDetailById(Long.valueOf(expertDetailInfoEntity.getOrganId().longValue())).getOrganName();
            consultationEntity.setExpertHosName(expertHosName);
            if (consultationVO.getDeptType().intValue() == ConsultationConstant.TYPE_DEPT_STANDARD.intValue()) {
                StandDeptInfoResVO standDeptInfoVO = this.departMentInfoRemote.getStandDeptDetailId(consultationVO.getDeptId(), Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
                consultationEntity.setExpertDeptName(standDeptInfoVO.getDisplayName());
            } else {
                consultationEntity.setExpertDeptName(expertDetailInfoEntity.getHospitalDeptName());
            }
            BigDecimal accompanyFee = new BigDecimal(0);
            BigDecimal amissionFee = new BigDecimal(0);
            BigDecimal baiyihuiFee = new BigDecimal(0);
            if (consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_UNION.intValue() || consultationVO.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_EXPERT.intValue()) {
                ArrayList<QueryPiontServiceDTO> queryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
                QueryPiontServiceDTO expertPiontService = new QueryPiontServiceDTO();
                expertPiontService.setDoctorId(Integer.valueOf(consultationEntity.getExpertId().intValue()));
                expertPiontService.setServiceCode(consultationEntity.getServiceCode().toString());
                queryPiontServiceDTOS.add(expertPiontService);
                List infoVOS = this.remoteManage.queryDoctorServiceInfo(queryPiontServiceDTOS);
                amissionFee = ((PointDoctorServiceInfoVO)infoVOS.get(0)).getPrice();
                log.info("\u63a5\u8bca\u8d39\u8fd4\u56de\u7684\u4ef7\u683c\u662f:" + infoVOS.toString());
                Integer surgeryType = OrderTypeEnum.getByValue((Integer)consultationEntity.getType()).getValue().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) ? DoctorServiceEnum.CONSULTATION_VEDIO_SURGERY.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_SURGERY.getValue();
                ArrayList<QueryPiontServiceDTO> doctorQueryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
                QueryPiontServiceDTO doctorPiontService = new QueryPiontServiceDTO();
                doctorPiontService.setDoctorId(Integer.valueOf(consultationEntity.getDoctorId().intValue()));
                doctorPiontService.setServiceCode(surgeryType.toString());
                doctorQueryPiontServiceDTOS.add(doctorPiontService);
                List doctorInfoVOS = this.remoteManage.queryDoctorServiceInfo(doctorQueryPiontServiceDTOS);
                log.info("\u966a\u8bca\u8d39\u8fd4\u56de\u7684\u4ef7\u683c\u662f:" + doctorInfoVOS.toString());
                accompanyFee = doctorInfoVOS.isEmpty() || doctorInfoVOS.get(0) == null ? new BigDecimal(0) : ((PointDoctorServiceInfoVO)doctorInfoVOS.get(0)).getPrice();
            }
            consultationExtendEntity.setAccompanyFee(accompanyFee);
            consultationExtendEntity.setAmissionFee(amissionFee);
            consultationExtendEntity.setServiceFee(baiyihuiFee);
            price = amissionFee.add(accompanyFee).add(baiyihuiFee);
            log.info("=====\u6b63\u5728\u8fdb\u884cweb\u6216app\u4e0b\u5355====\u966a\u8bca\u8d39:" + accompanyFee + "=====\u63a5\u8bca\u8d39\u662f:" + amissionFee + "=====\u670d\u52a1\u8d39\u662f:" + baiyihuiFee);
            consultationExtendEntity.setPrice(price);
            consultationEntity.setExpertDepId(consultationVO.getDeptId());
            this.dataDaily(consultationEntity, consultationExtendEntity, doctorEntityInfoVO, expertDetailInfoEntity);
        } else {
            if (consultationVO.getDeptType().intValue() == ConsultationConstant.TYPE_DEPT_STANDARD.intValue()) {
                StandDeptInfoResVO standDeptInfoVO = this.departMentInfoRemote.getStandDeptDetailId(consultationVO.getDeptId(), Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
                consultationEntity.setExpertDeptName(standDeptInfoVO.getDisplayName());
            } else {
                QueryOrganDetailVO queryOrganDetailVO = this.remoteManage.getHospitalDetailById(consultationVO.getExpertHospitalId());
                consultationEntity.setExpertHospitalId(consultationVO.getExpertHospitalId());
                consultationEntity.setExpertHosName(queryOrganDetailVO.getOrganName());
                DepartmentResVO hosDeptInfo = this.departMentInfoRemote.getHosDeptDetailId(consultationVO.getDeptId(), consultationVO.getExpertHospitalId());
                log.info("===\u4e0b\u5355\u53d6\u5230\u7684\u533b\u9662\u79d1\u5ba4\u4fe1\u606f\u662f:" + hosDeptInfo.toString() + "==\u79d1\u5ba4\u540d\u79f0\u662f:" + hosDeptInfo.getDeptName());
                consultationEntity.setExpertDeptName(hosDeptInfo.getDeptName());
            }
            price = new BigDecimal(0);
            consultationExtendEntity.setPrice(price);
        }
        if (StringUtil.isNotBlank((String)consultationVO.getDcmFileUrl())) {
            consultationExtendEntity.setDcmFileUrl(consultationExtendEntity.getDcmFileUrl());
        }
        consultationEntity.setExpertDepId(consultationVO.getDeptId());
        consultationEntity.setDeptType(consultationVO.getDeptType());
        consultationEntity.setStatus(OrderStatusEnum.WAIT_PATIENT_SIGN.getValue());
        consultationEntity.setDoctorName(doctorEntityInfoVO.getName());
        consultationExtendEntity.setDoctorPhone(doctorEntityInfoVO.getRegisterMobile());
        consultationEntity.setDoctorDepName(doctorDeptName);
        consultationEntity.setDoctorHosName(doctorHosName);
        consultationEntity.setDoctorDepId(Long.valueOf(doctorEntityInfoVO.getHospitalDeptId().longValue()));
        consultationEntity.setDoctorHospitalId(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
        consultationEntity.setPatientName(patientCaseInfoVO.getPatientName());
        consultationExtendEntity.setInitiatorType(consultationVO.getInitiatorType());
        consultationExtendEntity.setDcmPackUrl(consultationVO.getDcmPackUrl());
        if (consultationVO.getVideoChecked().equals("true")) {
            BigDecimal imagePrice = consultationVO.getImagePrice() == null ? BigDecimal.ZERO : consultationVO.getImagePrice();
            consultationExtendEntity.setPrice(imagePrice.add(price == null ? BigDecimal.ZERO : price));
            consultationExtendEntity.setImagePrice(consultationVO.getImagePrice());
            if (consultationVO.getImagePrice().compareTo(new BigDecimal(300)) == 0) {
                consultationExtendEntity.setImageConsultationTime("10 ~ 30\u5206\u949f");
            } else if (consultationVO.getImagePrice().compareTo(new BigDecimal(500)) == 0) {
                consultationExtendEntity.setImageConsultationTime("30 ~ 60\u5206\u949f");
            } else {
                consultationExtendEntity.setImageConsultationTime("60\u5206\u949f\u4ee5\u4e0a");
            }
            consultationExtendEntity.setIsImageConsultation(Integer.valueOf(1));
        } else {
            consultationExtendEntity.setPrice(price);
        }
        ConsultationEntity consultation = this.consultationService.saveConsultation(consultationEntity);
        consultationExtendEntity.setConsultationId(consultation.getId());
        consultationExtendEntity.setStatus(Integer.valueOf(1));
        ConsultationExtendEntity extendEntity = this.consultationExtendService.insert(consultationExtendEntity);
        if (consultation.getId() != 0L && extendEntity.getId() != null) {
            map.put("code", ReturnCodeEnum.SUCCEED.getValue().toString());
            map.put("msg", ReturnCodeEnum.SUCCEED.getDisplay());
            map.put("viewId", orderViewId);
        }
        return map;
    }

    public BaseResponse<List<TransferResVO>> getConsultationInfoToTransfer(List<TransferReqVO> transferReqVOList) {
        ArrayList<TransferResVO> transferResVOS = new ArrayList<TransferResVO>();
        if (CollectionUtils.isNotEmpty(transferReqVOList)) {
            for (TransferReqVO transferReqVO : transferReqVOList) {
                TransferResVO transferResVO = this.consultationService.getByPatientIdAndAppCode(transferReqVO.getPatientId(), transferReqVO.getAppCode());
                if (transferResVO == null) continue;
                transferResVOS.add(transferResVO);
            }
        }
        return BaseResponse.success(transferResVOS);
    }
}

