/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.byh.common.ResultInfo;
import com.byh.constants.ReportConstant;
import com.byh.controller.BaseController;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.IOssApiClient;
import com.byh.manage.consultation.BusinessManage;
import com.byh.manage.consultation.OrderPayManage;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.TRTCManage;
import com.byh.pojo.bo.consultation.BasePatDocExpertDto;
import com.byh.pojo.bo.consultation.ConsultationReportDto;
import com.byh.pojo.bo.consultation.NormalImagesDto;
import com.byh.pojo.bo.consultation.OrderDetailDto;
import com.byh.pojo.bo.consultation.OrderDetailEditionTwoDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.consultation.ConsultationTranscodeVideoEntity;
import com.byh.pojo.entity.consultation.RtcRoomEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationMerchantConfigService;
import com.byh.service.cosultation.ConsultationPayInfoService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ConsultationTranscodeVideoService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.DateTimeUtil;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.doctoruser.api.pojo.vo.OssFileVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultationReportManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ConsultationReportManager.class);
    private SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private IOssApiClient iOssApiClient;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private ConsultationPayInfoService consultationPayInfoService;
    @Autowired
    private BusinessManage businessManage;
    @Autowired
    private ConsultationMerchantConfigService consultationMerchantConfigService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ConsultationTranscodeVideoService consultationTranscodeVideoService;

    public ResultInfo saveUpdateConsultationReport(String orderViewId, Integer orderType, String treatPlan, String signature, String photoReport) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (consultationEntity == null) {
            log.info("\u8ba2\u5355\u4e0d\u5b58\u5728=======");
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
        ConsultationReportEntity consultationReportEntity = new ConsultationReportEntity();
        if (consultationReport == null) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa=========");
            consultationReportEntity.setViewId(UuidUtils.generateUUID());
            consultationReportEntity.setOrderViewId(orderViewId);
            consultationReportEntity.setOrderType(orderType);
            if (photoReport == null || photoReport.equals("")) {
                consultationReportEntity.setTreatPlan(treatPlan);
                consultationReportEntity.setSignature(signature);
                consultationReportEntity.setAttentions("");
                consultationReportEntity.setDiagnosis("");
                int i = this.consultationReportService.savaConsultationReportEntity1(consultationReportEntity);
                if (i < 0) {
                    log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25=========");
                    return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25");
                }
                log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f=========");
                return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f");
            }
            consultationReportEntity.setPhotoReport(photoReport);
            consultationReportEntity.setAttentions("");
            consultationReportEntity.setDiagnosis("");
            consultationReportEntity.setTreatPlan("");
            int i = this.consultationReportService.savaConsultationReportEntity2(consultationReportEntity);
            if (i < 0) {
                log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25=========");
                return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25");
            }
            log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f=========");
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f");
        }
        log.info("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539=========");
        consultationReportEntity = consultationReport;
        consultationReportEntity.setTreatPlan(treatPlan);
        consultationReportEntity.setSignature(signature);
        consultationReportEntity.setPhotoReport(photoReport);
        int i = this.consultationReportService.updateConsultationReportEntity(consultationReportEntity);
        if (i > 0) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u6210\u529f=========");
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u6210\u529f");
        }
        log.info("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u5931\u8d25========");
        return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u5931\u8d25");
    }

    public ResultInfo<ConsultationReportDto> queryConsultationReportByOrder(String orderViewId) {
        ConsultationReportEntity consultationReportEntity;
        ConsultationReportDto consultationReportDto = new ConsultationReportDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            log.info("\u8ba2\u5355\u4e0d\u5b58\u5728=======");
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        consultationReportDto.setOrderId(consultationEntity.getId());
        consultationReportDto.setOrderViewId(consultationEntity.getViewId());
        consultationReportDto.setOrderBeginTime(consultationEntity.getBeginTime());
        consultationReportDto.setOrderFinishTime(consultationEntity.getFinishTime());
        consultationReportDto.setConsultationDate(consultationEntity.getConsultationDate());
        consultationReportDto.setConsultationTime(consultationEntity.getConsultationTime());
        consultationReportDto.setOrderType(consultationEntity.getType());
        consultationReportDto.setDate(consultationEntity.getBeginTime() + " \u81f3 " + consultationEntity.getFinishTime());
        consultationReportDto.setPatientId(consultationEntity.getPatientId());
        consultationReportDto.setPatientName(consultationEntity.getPatientName());
        consultationReportDto.setPatientSex(consultationExtendEntity.getPatientSex());
        consultationReportDto.setPatientAge(consultationExtendEntity.getPatientAge());
        consultationReportDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
        consultationReportDto.setDocId(consultationEntity.getDoctorId());
        consultationReportDto.setDocName(consultationEntity.getDoctorName());
        consultationReportDto.setDocDepName(consultationEntity.getDoctorDepName());
        consultationReportDto.setDocHosName(consultationEntity.getDoctorHosName());
        consultationReportDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        consultationReportDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        consultationReportDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        consultationReportDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (patientInfoRespVO != null) {
            consultationReportDto.setPatientTel(patientInfoRespVO.getContactMobile());
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId)) != null) {
            consultationReportDto.setIsWrite(Integer.valueOf(1));
            consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
            consultationReportDto.setSignature(consultationReportEntity.getSignature());
            consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
            consultationReportDto.setReportStatus(consultationReportEntity.getStatus());
        }
        return this.returnSucceed((Object)consultationReportDto, "\u6210\u529f");
    }

    public ResultInfo<List<ConsultationReportDto>> queryConsultationReportByPatient(Long patientId, Integer pageIndex, Integer pageSize) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.consultationService.queryConsultationEntityByPatientId(patientId);
        if (consultationEntityList == null || consultationEntityList.size() < 1) {
            log.info("\u8be5\u60a3\u8005\u6ca1\u6709\u4f1a\u8bca\u62a5\u544a===========");
            return this.returnSucceed("\u8be5\u60a3\u8005\u6ca1\u6709\u4f1a\u8bca\u62a5\u544a");
        }
        ArrayList<ConsultationReportDto> list = new ArrayList<ConsultationReportDto>();
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            String orderViewId = consultationEntity.getViewId();
            ConsultationReportDto consultationReportDto = this.getConsultationReportDto(orderViewId);
            if (consultationReportDto == null) {
                log.info("\u8be5\u8ba2\u5355\u65e0\u4f1a\u8bca\u62a5\u544a=====" + orderViewId);
                continue;
            }
            consultationReportDto.setIsWrite(Integer.valueOf(1));
            list.add(consultationReportDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ResultInfo<List<ConsultationReportDto>> queryConsultationReportByDoctorId(Long doctorId, Integer type, Integer pageIndex, Integer pageSize, String search) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.consultationService.queryConsultationListByDocIdAndType(doctorId, type, search);
        if (consultationEntityList == null) {
            return this.returnSucceed("\u7a7a\u7a7a\u5982\u4e5f");
        }
        ArrayList<ConsultationReportDto> list = new ArrayList<ConsultationReportDto>();
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            String orderViewId;
            BasePatDocExpertDto basePatDocExpertDto;
            ConsultationReportDto consultationReportDto = new ConsultationReportDto();
            consultationReportDto.setOrderId(consultationEntity.getId());
            consultationReportDto.setOrderViewId(consultationEntity.getViewId());
            consultationReportDto.setOrderBeginTime(consultationEntity.getBeginTime());
            consultationReportDto.setOrderFinishTime(consultationEntity.getFinishTime());
            consultationReportDto.setConsultationDate(consultationEntity.getConsultationDate());
            consultationReportDto.setConsultationTime(consultationEntity.getConsultationTime());
            consultationReportDto.setOrderType(consultationEntity.getType());
            PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
            if (patientInfoRespVO != null) {
                consultationReportDto.setPatIdCard(patientInfoRespVO.getCredNo());
            }
            if ((basePatDocExpertDto = this.queryPatDocExpertDto(orderViewId = consultationEntity.getViewId())) == null) {
                log.info("\u83b7\u53d6\u57fa\u7840\u4fe1\u606f\u5931\u8d25=======");
            }
            BeanCopier copier = BeanCopier.create(BasePatDocExpertDto.class, ConsultationReportDto.class, (boolean)false);
            try {
                copier.copy((Object)basePatDocExpertDto, (Object)consultationReportDto, null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
            if (consultationReportEntity == null) {
                consultationReportDto.setIsWrite(Integer.valueOf(0));
            } else {
                consultationReportDto.setIsWrite(Integer.valueOf(1));
                consultationReportDto.setDate(consultationEntity.getBeginTime() + " \u81f3 " + consultationEntity.getFinishTime());
                consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
                consultationReportDto.setSignature(consultationReportEntity.getSignature());
                consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
                consultationReportDto.setReportCreateTime(consultationReportEntity.getCreateTime());
                consultationReportDto.setReportUpdateTime(consultationReportEntity.getUpdateTime());
                consultationReportDto.setReportStatus(consultationReportEntity.getStatus());
            }
            list.add(consultationReportDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    private ConsultationReportDto getConsultationReportDto(String orderViewId) {
        ConsultationReportEntity consultationReportEntity;
        ConsultationReportDto consultationReportDto = new ConsultationReportDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            log.info("\u8ba2\u5355\u4e0d\u5b58\u5728=======");
            return null;
        }
        consultationReportDto.setOrderId(consultationEntity.getId());
        consultationReportDto.setOrderViewId(consultationEntity.getViewId());
        consultationReportDto.setOrderBeginTime(consultationEntity.getBeginTime());
        consultationReportDto.setOrderFinishTime(consultationEntity.getFinishTime());
        consultationReportDto.setConsultationDate(consultationEntity.getConsultationDate());
        consultationReportDto.setConsultationTime(consultationEntity.getConsultationTime());
        consultationReportDto.setOrderType(consultationEntity.getType());
        consultationReportDto.setReportCreateTime(consultationEntity.getCreateTime());
        consultationReportDto.setReportUpdateTime(consultationEntity.getUpdateTime());
        consultationReportDto.setPatientId(consultationEntity.getPatientId());
        consultationReportDto.setPatientName(consultationEntity.getPatientName());
        consultationReportDto.setPatientSex(consultationExtendEntity.getPatientSex());
        consultationReportDto.setPatientAge(consultationExtendEntity.getPatientAge());
        consultationReportDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
        consultationReportDto.setDocId(consultationEntity.getDoctorId());
        consultationReportDto.setDocName(consultationEntity.getDoctorName());
        consultationReportDto.setDocDepName(consultationEntity.getDoctorDepName());
        consultationReportDto.setDocHosName(consultationEntity.getDoctorHosName());
        consultationReportDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        consultationReportDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        consultationReportDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        consultationReportDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (patientInfoRespVO != null) {
            consultationReportDto.setPatientTel(patientInfoRespVO.getContactMobile());
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId)) == null) {
            log.info("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u4e0d\u5b58\u5728===\u8ba2\u5355id\u662f:" + consultationEntity.getId());
            return null;
        }
        consultationReportDto.setDate(consultationEntity.getBeginTime() + " \u81f3 " + consultationEntity.getFinishTime());
        consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
        consultationReportDto.setSignature(consultationReportEntity.getSignature());
        consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
        return consultationReportDto;
    }

    private BasePatDocExpertDto queryPatDocExpertDto(String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return null;
        }
        BasePatDocExpertDto basePatDocExpertDto = new BasePatDocExpertDto();
        basePatDocExpertDto.setPatientId(consultationEntity.getPatientId());
        basePatDocExpertDto.setPatientName(consultationEntity.getPatientName());
        basePatDocExpertDto.setPatientSex(consultationExtendEntity.getPatientSex());
        basePatDocExpertDto.setPatientAge(consultationExtendEntity.getPatientAge());
        basePatDocExpertDto.setDocId(consultationEntity.getDoctorId());
        basePatDocExpertDto.setDocName(consultationEntity.getDoctorName());
        basePatDocExpertDto.setDocDepName(consultationEntity.getDoctorDepName());
        basePatDocExpertDto.setDocHosName(consultationEntity.getDoctorHosName());
        basePatDocExpertDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        basePatDocExpertDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        basePatDocExpertDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        basePatDocExpertDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (patientInfoRespVO != null) {
            basePatDocExpertDto.setPatientTel(patientInfoRespVO.getContactMobile());
        }
        return basePatDocExpertDto;
    }

    public ResultInfo<OrderDetailDto> queryOrderDetail(String orderViewId) {
        PatientCaseInfoEntity patientCaseInfoEntity;
        DoctorEntityInfoVO expertEntityInfoVO;
        ConsultationReportEntity consultationReportEntity;
        OrderDetailDto orderDetailDto = new OrderDetailDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        orderDetailDto.setOrderId(consultationEntity.getId());
        orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
        orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
        orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
        orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
        orderDetailDto.setOrderViewId(consultationEntity.getViewId());
        orderDetailDto.setOrderStatus(consultationEntity.getStatus());
        orderDetailDto.setOrderType(consultationEntity.getType());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        orderDetailDto.setVideoUrl(consultationExtendEntity.getVideoUrl());
        ConsultationTranscodeVideoEntity videoEntity = this.consultationTranscodeVideoService.getByOrderViewIdAndOrderType(consultationEntity.getViewId(), consultationEntity.getType());
        if (videoEntity != null && StringUtil.isNotEmpty((String)videoEntity.getVideoUrl())) {
            orderDetailDto.setMp4VideoUrl(videoEntity.getVideoUrl());
        } else {
            orderDetailDto.setMp4VideoUrl(consultationExtendEntity.getVideoUrl());
        }
        orderDetailDto.setPayTime(consultationEntity.getPayTime());
        orderDetailDto.setConsultationDate(consultationEntity.getConsultationDate());
        orderDetailDto.setConsultationTime(consultationEntity.getConsultationTime());
        orderDetailDto.setOrderApplicationChannels(consultationEntity.getApplicationChannels());
        orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
        orderDetailDto.setGroupId(consultationEntity.getGroupId());
        orderDetailDto.setOrderPayType(consultationExtendEntity.getPayType());
        orderDetailDto.setOrderPrice(consultationExtendEntity.getPrice());
        orderDetailDto.setPatientInformedConsentUrl(consultationEntity.getPatientInformedConsentUrl());
        orderDetailDto.setDcmFileUrl(consultationExtendEntity.getDcmFileUrl());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        if (consultationEntity.getType().intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue() && consultationEntity.getStatus() >= OrderStatusEnum.RUNNING.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue()) {
            RtcRoomEntity roomEntity = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
            if (roomEntity == null) {
                this.trtcManage.saveRtcRoomId(consultationEntity.getId());
                RtcRoomEntity roomEntity1 = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
                orderDetailDto.setRoomId(roomEntity1.getId().toString());
            } else {
                orderDetailDto.setRoomId(roomEntity.getId().toString());
            }
        }
        orderDetailDto.setPatientId(consultationEntity.getPatientId());
        orderDetailDto.setPatientName(consultationEntity.getPatientName());
        orderDetailDto.setPatientSex(consultationExtendEntity.getPatientSex());
        orderDetailDto.setPatientAge(consultationExtendEntity.getPatientAge());
        orderDetailDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
        orderDetailDto.setPatientTel(consultationExtendEntity.getPatientPhone());
        orderDetailDto.setDocId(consultationEntity.getDoctorId());
        orderDetailDto.setDocName(consultationEntity.getDoctorName());
        orderDetailDto.setDocDepId(consultationEntity.getDoctorDepId());
        orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
        orderDetailDto.setDocHospId(consultationEntity.getDoctorHospitalId());
        orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
        orderDetailDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        orderDetailDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        orderDetailDto.setExpertDepId(Long.valueOf(consultationEntity.getExpertDepId() == null ? 0L : consultationEntity.getExpertDepId()));
        orderDetailDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        orderDetailDto.setExpertHospId(Long.valueOf(consultationEntity.getExpertHospitalId() == null ? 0L : consultationEntity.getExpertHospitalId()));
        orderDetailDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        String acceptTime = consultationEntity.getAcceptTime();
        if (acceptTime != null && !acceptTime.equals("")) {
            Date acceptDate = DateTimeUtil.addHour((Date)DateTimeUtil.parseTime((String)acceptTime, (String)"yyyy-MM-dd HH:mm:ss"), (int)24);
            orderDetailDto.setOrderAcceptExpireTime(DateTimeUtil.formatTime((Date)acceptDate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) == null) {
            orderDetailDto.setIsReport(Integer.valueOf(0));
        } else {
            orderDetailDto.setIsReport(Integer.valueOf(1));
            orderDetailDto.setReportStatus(consultationReportEntity.getStatus());
            orderDetailDto.setPhotoReportUrl(consultationReportEntity.getPhotoReport());
            orderDetailDto.setDiagnosis(consultationReportEntity.getDiagnosis());
            orderDetailDto.setTreatPlan(consultationReportEntity.getTreatPlan());
            orderDetailDto.setAttentions(consultationReportEntity.getAttentions());
            orderDetailDto.setSignature(consultationReportEntity.getSignature());
        }
        orderDetailDto.setPatientTel(consultationExtendEntity.getPatientPhone());
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        if (doctorEntityInfoVO != null) {
            orderDetailDto.setDocTel(doctorEntityInfoVO.getRegisterMobile());
            orderDetailDto.setDoctorHeadUrl(doctorEntityInfoVO.getHeadPortrait());
            orderDetailDto.setDocProfession(doctorEntityInfoVO.getProfession());
            orderDetailDto.setDocProfessionCode(doctorEntityInfoVO.getProfessionCode());
        }
        if (StringUtil.isNotEmpty((String)consultationEntity.getClosedTime())) {
            orderDetailDto.setOrderClosedTime(consultationEntity.getClosedTime());
        }
        if (consultationEntity.getExpertId() != null && consultationEntity.getExpertId().intValue() != 0 && (expertEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId())) != null) {
            orderDetailDto.setExpertTel(expertEntityInfoVO.getRegisterMobile());
            orderDetailDto.setExpertHeadUrl(expertEntityInfoVO.getHeadPortrait());
            orderDetailDto.setExpertProfession(expertEntityInfoVO.getProfession());
            orderDetailDto.setExpertProfessionCode(expertEntityInfoVO.getProfessionCode());
        }
        if ((patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId())) != null) {
            orderDetailDto.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
            orderDetailDto.setPastHistory(patientCaseInfoEntity.getPastHistory());
            orderDetailDto.setPresentHistory(patientCaseInfoEntity.getPresentHistory());
            orderDetailDto.setPatPrimaryDiagno(patientCaseInfoEntity.getPrimaryDiagno());
            orderDetailDto.setPatCaseFamilyHistory(patientCaseInfoEntity.getFamilyHistory());
            orderDetailDto.setPatCaseMedicationHistory(patientCaseInfoEntity.getMedicationHistory());
            orderDetailDto.setPatCaseConsultAim(patientCaseInfoEntity.getConsultAim());
            String normalImages = patientCaseInfoEntity.getNormalImages();
            ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
            if (StringUtil.isNotEmpty((String)normalImages)) {
                if (normalImages.contains(",")) {
                    List<String> stringList = Arrays.asList(normalImages.split(","));
                    for (String s : stringList) {
                        BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(Long.parseLong(s)));
                        if (!ossFileVOBaseResponse.getCode().equals("1")) {
                            return this.returnFailure("oss\u670d\u52a1\u9519\u8bef:" + ossFileVOBaseResponse.getMsg());
                        }
                        OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                        NormalImagesDto normalImagesDto = new NormalImagesDto();
                        normalImagesDto.setId(ossFileEntity.getId());
                        normalImagesDto.setUrl(ossFileEntity.getUrl());
                        caseAttachmentList.add(normalImagesDto);
                        orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                    }
                } else {
                    OssFileVO ossFileEntity = (OssFileVO)this.iOssApiClient.getById(Long.valueOf(Long.parseLong(normalImages))).getData();
                    NormalImagesDto normalImagesDto = new NormalImagesDto();
                    normalImagesDto.setId(ossFileEntity.getId());
                    normalImagesDto.setUrl(ossFileEntity.getUrl());
                    caseAttachmentList.add(normalImagesDto);
                    orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                }
            } else {
                orderDetailDto.setCaseAttachmentList(caseAttachmentList);
            }
        }
        return this.returnSucceed((Object)orderDetailDto, "\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
    }

    public ResultInfo<OrderDetailEditionTwoDto> queryOrderDetailEditionTwoDto(String orderViewId) {
        DoctorEntityInfoVO doctorEntityInfoVO;
        PatientCaseInfoEntity patientCaseInfoDTO;
        PatientInfoRespVO patientInfoRespVO;
        OrderDetailEditionTwoDto orderDetailEditionTwoDto = new OrderDetailEditionTwoDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (consultationEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        orderDetailEditionTwoDto.setConsultationEntity(consultationEntity);
        ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId());
        if (consultationReportEntity != null) {
            orderDetailEditionTwoDto.setConsultationReportEntity(consultationReportEntity);
        }
        if (consultationEntity.getPatientId() != null && !consultationEntity.getPatientId().equals(0) && (patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId())) != null) {
            orderDetailEditionTwoDto.setPatientInfoDTO(patientInfoRespVO);
        }
        if (consultationEntity.getCaseId() != null && consultationEntity.getCaseId().intValue() != 0 && (patientCaseInfoDTO = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId())) != null) {
            orderDetailEditionTwoDto.setPatientCaseInfoDTO(patientCaseInfoDTO);
            String normalImages = patientCaseInfoDTO.getNormalImages();
            ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
            if (normalImages != null && !normalImages.equals("")) {
                String[] split = normalImages.split(",");
                for (int i = 0; i < split.length; ++i) {
                    BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(split[i]));
                    if (!ossFileVOBaseResponse.getCode().equals("1")) {
                        return this.returnFailure("oss\u670d\u52a1\u9519\u8bef:" + ossFileVOBaseResponse.getMsg());
                    }
                    OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                    if (ossFileEntity == null) continue;
                    NormalImagesDto normalImagesDto = new NormalImagesDto();
                    normalImagesDto.setId(ossFileEntity.getId());
                    normalImagesDto.setUrl(ossFileEntity.getUrl());
                    caseAttachmentList.add(normalImagesDto);
                }
                orderDetailEditionTwoDto.setCaseAttachmentList(caseAttachmentList);
            } else {
                orderDetailEditionTwoDto.setCaseAttachmentList(caseAttachmentList);
            }
        }
        if ((doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId())) != null) {
            orderDetailEditionTwoDto.setDoctorDetailInfoEntity(doctorEntityInfoVO);
        }
        if (consultationEntity.getExpertId() != null && consultationEntity.getExpertId().intValue() != 0) {
            DoctorEntityInfoVO expertEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId());
            orderDetailEditionTwoDto.setExpertHosName(consultationEntity.getExpertHosName());
            orderDetailEditionTwoDto.setExpertRegisterInfoEntity(expertEntityInfoVO);
        }
        return this.returnSucceed((Object)orderDetailEditionTwoDto, "\u6210\u529f");
    }

    public ResultInfo<OrderDetailDto> queryOrderDetailByOrderId(Long orderId) throws ParseException {
        PatientCaseInfoEntity patientCaseInfoEntity;
        DoctorEntityInfoVO expertEntityInfoVO;
        ConsultationReportEntity consultationReportEntity;
        OrderDetailDto orderDetailDto = new OrderDetailDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        orderDetailDto.setOrderId(consultationEntity.getId());
        orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
        orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
        orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
        orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
        orderDetailDto.setOrderViewId(consultationEntity.getViewId());
        orderDetailDto.setOrderStatus(consultationEntity.getStatus());
        orderDetailDto.setOrderType(consultationEntity.getType());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        orderDetailDto.setVideoUrl(consultationExtendEntity.getVideoUrl());
        orderDetailDto.setPayTime(consultationEntity.getPayTime());
        orderDetailDto.setConsultationDate(consultationEntity.getConsultationDate());
        orderDetailDto.setConsultationTime(consultationEntity.getConsultationTime());
        orderDetailDto.setOrderApplicationChannels(consultationEntity.getApplicationChannels());
        orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
        orderDetailDto.setGroupId(consultationEntity.getGroupId());
        orderDetailDto.setOrderPayType(consultationExtendEntity.getPayType());
        orderDetailDto.setOrderPrice(consultationExtendEntity.getPrice());
        orderDetailDto.setPatientInformedConsentUrl(consultationEntity.getPatientInformedConsentUrl());
        orderDetailDto.setDcmFileUrl(consultationExtendEntity.getDcmFileUrl());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        orderDetailDto.setPatientId(consultationEntity.getPatientId());
        orderDetailDto.setPatientName(consultationEntity.getPatientName());
        orderDetailDto.setPatientSex(consultationExtendEntity.getPatientSex());
        orderDetailDto.setPatientAge(consultationExtendEntity.getPatientAge());
        orderDetailDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
        orderDetailDto.setDocId(consultationEntity.getDoctorId());
        orderDetailDto.setDocName(consultationEntity.getDoctorName());
        orderDetailDto.setDocDepId(consultationEntity.getDoctorDepId());
        orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
        orderDetailDto.setDocHospId(consultationEntity.getDoctorHospitalId());
        orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
        orderDetailDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        orderDetailDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        orderDetailDto.setExpertDepId(Long.valueOf(consultationEntity.getExpertDepId() == null ? 0L : consultationEntity.getExpertDepId()));
        orderDetailDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        orderDetailDto.setExpertHospId(Long.valueOf(consultationEntity.getExpertHospitalId() == null ? 0L : consultationEntity.getExpertHospitalId()));
        orderDetailDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        String acceptTime = consultationEntity.getAcceptTime();
        if (StringUtil.isNotBlank((String)acceptTime)) {
            Date parse = this.formatTime.parse(acceptTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.set(11, calendar.get(11) + 24);
            orderDetailDto.setOrderAcceptExpireTime(this.formatTime.format(calendar.getTime()));
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) == null) {
            orderDetailDto.setIsReport(Integer.valueOf(0));
        } else {
            orderDetailDto.setIsReport(Integer.valueOf(1));
            orderDetailDto.setReportStatus(consultationReportEntity.getStatus());
            orderDetailDto.setPhotoReportUrl(consultationReportEntity.getPhotoReport());
            orderDetailDto.setDiagnosis(consultationReportEntity.getDiagnosis());
            orderDetailDto.setTreatPlan(consultationReportEntity.getTreatPlan());
            orderDetailDto.setAttentions(consultationReportEntity.getAttentions());
            orderDetailDto.setSignature(consultationReportEntity.getSignature());
        }
        orderDetailDto.setPatientTel(consultationExtendEntity.getPatientPhone());
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        if (doctorEntityInfoVO != null) {
            orderDetailDto.setDocTel(doctorEntityInfoVO.getRegisterMobile());
            orderDetailDto.setDoctorHeadUrl(doctorEntityInfoVO.getHeadPortrait());
        }
        if (consultationEntity.getExpertId() != null && consultationEntity.getExpertId().intValue() != 0 && (expertEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId())) != null) {
            orderDetailDto.setExpertHeadUrl(expertEntityInfoVO.getHeadPortrait());
        }
        if ((patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId())) != null) {
            orderDetailDto.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
            orderDetailDto.setPastHistory(patientCaseInfoEntity.getPastHistory());
            orderDetailDto.setPresentHistory(patientCaseInfoEntity.getPresentHistory());
            orderDetailDto.setPatPrimaryDiagno(patientCaseInfoEntity.getPrimaryDiagno());
            orderDetailDto.setPatCaseFamilyHistory(patientCaseInfoEntity.getFamilyHistory());
            orderDetailDto.setPatCaseMedicationHistory(patientCaseInfoEntity.getMedicationHistory());
            orderDetailDto.setPatCaseConsultAim(patientCaseInfoEntity.getConsultAim());
            String normalImages = patientCaseInfoEntity.getNormalImages();
            ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
            if (StringUtil.isBlank((String)normalImages)) {
                String[] split = normalImages.split(",");
                for (int i = 0; i < split.length; ++i) {
                    BaseResponse ossFileEntityResultInfoReturn = this.iOssApiClient.getById(Long.valueOf(split[i]));
                    if (!ossFileEntityResultInfoReturn.getCode().equals("1")) {
                        return this.returnFailure("oss\u670d\u52a1\u9519\u8bef:" + ossFileEntityResultInfoReturn.getMsg());
                    }
                    OssFileVO ossFileEntity = (OssFileVO)ossFileEntityResultInfoReturn.getData();
                    if (ossFileEntity == null) continue;
                    NormalImagesDto normalImagesDto = new NormalImagesDto();
                    normalImagesDto.setId(ossFileEntity.getId());
                    normalImagesDto.setUrl(ossFileEntity.getUrl());
                    caseAttachmentList.add(normalImagesDto);
                }
                orderDetailDto.setCaseAttachmentList(caseAttachmentList);
            } else {
                orderDetailDto.setCaseAttachmentList(caseAttachmentList);
            }
        }
        return this.returnSucceed((Object)orderDetailDto, "\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo consultationReportDraft(String orderViewId, Integer orderType, String treatPlan, String signature, String photoReport) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
        if (consultationReport != null && consultationReport.getStatus().intValue() == ReportConstant.STATUS_REPORT_ONLINE.intValue()) {
            log.error("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u5b58\u5728===========");
            return this.returnFailure("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u5b58\u5728");
        }
        if (consultationReport != null && consultationReport.getStatus().intValue() == ReportConstant.STATUS_REPORT_DRAFT.intValue()) {
            consultationReport.setTreatPlan(treatPlan);
            consultationReport.setSignature(signature);
            consultationReport.setPhotoReport(photoReport);
            consultationReport.setStatus(ReportConstant.STATUS_REPORT_DRAFT);
            int i = this.consultationReportService.updateConsultationReportDraft(consultationReport);
            if (i > 0) {
                log.info("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u6210\u529f==============");
                return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u6210\u529f");
            }
            log.error("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u5931\u8d25==============");
            return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u5931\u8d25");
        }
        ConsultationReportEntity consultationReportEntity = new ConsultationReportEntity();
        consultationReportEntity.setViewId(UuidUtils.generateUUID());
        consultationReportEntity.setOrderViewId(orderViewId);
        consultationReportEntity.setOrderType(orderType);
        consultationReportEntity.setTreatPlan(treatPlan);
        consultationReportEntity.setSignature(signature);
        consultationReportEntity.setPhotoReport(photoReport);
        consultationReportEntity.setStatus(ReportConstant.STATUS_REPORT_DRAFT);
        int i = this.consultationReportService.saveConsultationReportDraft(consultationReportEntity);
        if (i > 0) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u6210\u529f==============");
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u6210\u529f");
        }
        log.error("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u5931\u8d25==============");
        return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u5931\u8d25");
    }

    public ResultInfo consultationReportInspect(String orderViewId, Integer status, String reason) {
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
        if (consultationReport == null) {
            return this.returnFailure("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u4e0d\u5b58\u5728");
        }
        int i = this.consultationReportService.updateConsultationReportInspect(orderViewId, status, reason);
        if (i > 0) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u6210\u529f===========");
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u6210\u529f");
        }
        log.error("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u5931\u8d25===========");
        return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u5931\u8d25");
    }

    public boolean checkConsultationQualified(ConsultationEntity consultationEntity, ResultInfo reportResultInfo) {
        boolean checkConsent;
        log.info("===\u5f00\u59cb\u68c0\u67e5\u4f1a\u8bca\u662f\u5426\u5408\u683c===\u8ba2\u5355\u7684id\u662f:" + consultationEntity.getId() + "===\u8ba2\u5355\u7c7b\u578b\u662f:" + consultationEntity.getType());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        boolean checkConsultationValue = false;
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        boolean checkPatienfInfo = StringUtil.isNotEmpty((String)consultationEntity.getPatientName()) && StringUtil.isNotEmpty((String)consultationExtendEntity.getPatientPhone()) && patientInfoRespVO != null && StringUtil.isNotEmpty((String)patientInfoRespVO.getCredNo());
        PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
        boolean checkPatientCaseInfo = StringUtil.isNotEmpty((String)patientCaseInfoEntity.getMainSuit()) && (StringUtil.isNotEmpty((String)patientCaseInfoEntity.getNormalImages()) || StringUtil.isNotEmpty((String)consultationExtendEntity.getDcmFileUrl()) || StringUtil.isNotEmpty((String)consultationExtendEntity.getDcmPackUrl())) && StringUtil.isNotEmpty((String)patientCaseInfoEntity.getConsultAim());
        boolean checkDoctorDetailInfo = StringUtil.isNotEmpty((String)consultationEntity.getDoctorName()) && StringUtil.isNotEmpty((String)consultationEntity.getDoctorHosName()) && StringUtil.isNotEmpty((String)consultationEntity.getDoctorDepName());
        boolean checkExpertDetailInfo = StringUtil.isNotEmpty((String)consultationEntity.getExpertName()) && StringUtil.isNotEmpty((String)consultationEntity.getExpertDeptName()) && StringUtil.isNotEmpty((String)consultationEntity.getExpertHosName());
        boolean checkReport = reportResultInfo.getCode() == ReturnCodeEnum.SUCCEED.getValue();
        boolean checkVedio = true;
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue())) {
            checkVedio = StringUtil.isNotEmpty((String)consultationExtendEntity.getVideoUrl());
        }
        boolean bl = checkConsent = StringUtil.isNotEmpty((String)consultationEntity.getPatientInformedConsentUrl()) || StringUtil.isNotEmpty((String)consultationEntity.getPatientSignature());
        if (checkPatienfInfo && checkPatientCaseInfo && checkDoctorDetailInfo && checkExpertDetailInfo && checkReport && checkVedio && checkConsent) {
            checkConsultationValue = true;
        }
        log.info("===\u68c0\u67e5\u7684\u7ed3\u679c\u662f:===\u60a3\u8005\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkPatienfInfo + "===\u75c5\u4f8b\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkPatientCaseInfo + "===\u966a\u8bca\u533b\u751f\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkDoctorDetailInfo + "===\u63a5\u8bca\u4e13\u5bb6\u662f\u5426\u5408\u683c:" + checkExpertDetailInfo + "====\u4f1a\u8bca\u62a5\u544a\u662f\u5426\u7f3a\u5931:" + checkReport + "===\u4f1a\u8bca\u89c6\u9891\u662f\u5426\u7f3a\u5931:" + checkVedio + "===\u77e5\u60c5\u540c\u610f\u4e66\u662f\u5426\u7f3a\u5931:" + checkConsent + "======\u6700\u7ec8\u7684\u68c0\u67e5\u7ed3\u679c\u662f:" + checkConsultationValue);
        return checkConsultationValue;
    }

    public boolean checkConsultationQualifiedNoPatientInfo(ConsultationEntity consultationEntity, ResultInfo reportResultInfo) {
        boolean checkConsent;
        log.info("===\u5f00\u59cb\u68c0\u67e5\u4f1a\u8bca\u662f\u5426\u5408\u683c===\u8ba2\u5355\u7684id\u662f:" + consultationEntity.getId() + "===\u8ba2\u5355\u7c7b\u578b\u662f:" + consultationEntity.getType());
        boolean checkConsultationValue = false;
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        boolean checkPatienfInfo = StringUtil.isNotEmpty((String)consultationEntity.getPatientName()) && StringUtil.isNotEmpty((String)consultationExtendEntity.getPatientPhone()) && patientInfoRespVO != null && StringUtil.isNotEmpty((String)patientInfoRespVO.getCredNo());
        PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
        boolean checkPatientCaseInfo = StringUtil.isNotEmpty((String)patientCaseInfoEntity.getMainSuit());
        boolean checkDoctorDetailInfo = StringUtil.isNotEmpty((String)consultationEntity.getDoctorName()) && StringUtil.isNotEmpty((String)consultationEntity.getDoctorHosName()) && StringUtil.isNotEmpty((String)consultationEntity.getDoctorDepName());
        boolean checkExpertDetailInfo = StringUtil.isNotEmpty((String)consultationEntity.getExpertName()) && StringUtil.isNotEmpty((String)consultationEntity.getExpertDeptName()) && StringUtil.isNotEmpty((String)consultationEntity.getExpertHosName());
        boolean checkReport = reportResultInfo.getCode() == ReturnCodeEnum.SUCCEED.getValue();
        boolean checkVedio = true;
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue())) {
            checkVedio = StringUtil.isNotEmpty((String)consultationExtendEntity.getVideoUrl());
        }
        boolean bl = checkConsent = StringUtil.isNotEmpty((String)consultationEntity.getPatientInformedConsentUrl()) || StringUtil.isNotEmpty((String)consultationEntity.getPatientSignature());
        if (checkPatienfInfo && checkPatientCaseInfo && checkDoctorDetailInfo && checkExpertDetailInfo && checkReport && checkVedio && checkConsent) {
            checkConsultationValue = true;
        }
        log.info("===\u68c0\u67e5\u7684\u7ed3\u679c\u662f:===\u60a3\u8005\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkPatienfInfo + "===\u75c5\u4f8b\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkPatientCaseInfo + "===\u966a\u8bca\u533b\u751f\u4fe1\u606f\u662f\u5426\u5408\u683c:" + checkDoctorDetailInfo + "===\u63a5\u8bca\u4e13\u5bb6\u662f\u5426\u5408\u683c:" + checkExpertDetailInfo + "====\u4f1a\u8bca\u62a5\u544a\u662f\u5426\u7f3a\u5931:" + checkReport + "===\u4f1a\u8bca\u89c6\u9891\u662f\u5426\u7f3a\u5931:" + checkVedio + "===\u77e5\u60c5\u540c\u610f\u4e66\u662f\u5426\u7f3a\u5931:" + checkConsent + "======\u6700\u7ec8\u7684\u68c0\u67e5\u7ed3\u679c\u662f:" + checkConsultationValue);
        return checkConsultationValue;
    }

    public ResultInfo upLoadReportMore(String orderViewId, String photoReport) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728:" + orderViewId);
        }
        this.compensateVideo(consultationEntity);
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) && StringUtil.isEmpty((String)consultationExtendEntity.getVideoUrl())) {
            log.info("======\u89c6\u9891\u4f1a\u8bca\u8ba2\u5355\u5f55\u5236\u89c6\u9891\u4e3a\u7a7a\u63d0\u4ea4\u4f1a\u8bca\u62a5\u544a\u9519\u8bef=====");
            return this.returnFailure("\u89c6\u9891\u4f1a\u8bca\u8ba2\u5355\u5f55\u5236\u89c6\u9891\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
        ConsultationReportEntity consultationReportEntity = new ConsultationReportEntity();
        Integer i = 0;
        if (consultationReport == null) {
            log.info("============\u65e0\u4f1a\u8bca\u62a5\u544a===========");
            consultationReportEntity.setViewId(UuidUtils.generateUUID());
            consultationReportEntity.setOrderViewId(orderViewId);
            consultationReportEntity.setOrderType(consultationEntity.getType());
            consultationReportEntity.setStatus(ReportConstant.STATUS_REPORT_ONLINE);
            consultationReportEntity.setPhotoReport(photoReport);
            i = this.consultationReportService.savaConsultationReportEntity2(consultationReportEntity);
        } else {
            log.info("============\u6709\u4f1a\u8bca\u62a5\u544a,status:{}", (Object)consultationReport.getStatus());
            consultationReportEntity = consultationReport;
            consultationReportEntity.setDiagnosis("");
            consultationReportEntity.setTreatPlan("");
            consultationReportEntity.setAttentions("");
            consultationReportEntity.setSignature("");
            consultationReportEntity.setReason("");
            consultationReportEntity.setStatus(ReportConstant.STATUS_REPORT_ONLINE);
            consultationReportEntity.setPhotoReport(photoReport);
            i = this.consultationReportService.update(consultationReportEntity);
        }
        if (i == 0) {
            return this.returnFailure("\u4e0a\u4f20\u5931\u8d25");
        }
        return this.returnSucceed("\u4e0a\u4f20\u6210\u529f");
    }

    public void compensateVideo(ConsultationEntity consultationEntity) {
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) && StringUtil.isEmpty((String)consultationExtendEntity.getVideoUrl())) {
            Map videoMap = this.businessManage.getVideoDetailL(consultationEntity);
            log.info("=====\u4ece\u8865\u507f\u89c6\u9891\u673a\u5236\u4e2d\u83b7\u53d6\u5f55\u5236\u89c6\u9891\uff0c\u8ba2\u5355id\u662f:" + consultationEntity.getId() + "====\u83b7\u53d6\u5230\u7684\u89c6\u9891map\u662f:" + videoMap);
            if (!videoMap.isEmpty() && StringUtil.isNotEmpty((String)((String)videoMap.get("expertVideoDetail")))) {
                consultationExtendEntity.setVideoUrl((String)videoMap.get("expertVideoDetail"));
            } else if (!videoMap.isEmpty() && StringUtil.isNotEmpty((String)((String)videoMap.get("doctorVideoDetail")))) {
                consultationExtendEntity.setVideoUrl((String)videoMap.get("doctorVideoDetail"));
            } else {
                consultationExtendEntity.setVideoUrl("");
            }
            this.consultationExtendService.update(consultationExtendEntity);
        }
    }
}

