/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.RelationShipEnum;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.DateTimeUtil;
import com.byh.util.FileUtils;
import com.byh.util.RandomUtil;
import com.byh.util.StringUtil;
import com.byh.util.WordUtils;
import com.byh.util.ZipUtils;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportFileInfoManage {
    private static final Logger log = LoggerFactory.getLogger(ExportFileInfoManage.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private RemoteManage remoteManage;
    public static String FILE_NAME = "FILE_NAME";
    public static String DEFAULT_PICTURE_URL = "https://tupian201805.oss-cn-beijing.aliyuncs.com/2019/zhongweibaiyi_log.png";

    public void exportAgreeWord(Long id, HttpServletResponse response) {
        Map dataMap = this.capsulateAgreeWord(id);
        try {
            WordUtils.exportMillCertificateWord((HttpServletResponse)response, (Map)dataMap, (String)"agreeWord.ftl", (String)((String)dataMap.get(FILE_NAME)));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> capsulateAgreeWord(Long id) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(id);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(id);
        if (consultationEntity != null && consultationExtendEntity != null) {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            dataMap.put("from_hospital", consultationEntity.getDoctorHosName());
            dataMap.put("name", consultationEntity.getPatientName());
            dataMap.put("from_dept", consultationEntity.getDoctorDepName());
            dataMap.put("age", String.valueOf(consultationExtendEntity.getPatientAge()));
            dataMap.put("sex", consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973");
            dataMap.put("mobile_number", consultationExtendEntity.getPatientPhone());
            dataMap.put("primary_diagno", StringUtil.isBlank((String)patientCaseInfoEntity.getPrimaryDiagno()) ? "" : patientCaseInfoEntity.getPrimaryDiagno());
            dataMap.put("from_hosp", consultationEntity.getDoctorHosName());
            dataMap.put("f_hosp", consultationEntity.getExpertHosName());
            dataMap.put("sign", WordUtils.getImgUrlToBase64((String)consultationEntity.getPatientSignature()));
            dataMap.put("relation_ship", RelationShipEnum.getByValue((Integer)consultationEntity.getPatientSignerRelationship()) == null ? "\u5176\u4ed6" : RelationShipEnum.getByValue((Integer)consultationEntity.getPatientSignerRelationship()).getDisplay());
            dataMap.put("date", DateTimeUtil.formatTime((Date)consultationEntity.getCreateTime(), (String)"yyyy-MM-dd"));
            dataMap.put(FILE_NAME, consultationEntity.getViewId() + "_" + consultationEntity.getPatientName());
        }
        return dataMap;
    }

    public void exportApplyWord(Long id, HttpServletResponse response) {
        Map dataMap = this.capsulateApplyWord(id);
        try {
            WordUtils.exportMillCertificateWord((HttpServletResponse)response, (Map)dataMap, (String)"importConsultationApplyWord.ftl", (String)((String)dataMap.get(FILE_NAME)));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> capsulateApplyWord(Long id) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(id);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(id);
        if (consultationEntity != null && consultationExtendEntity != null) {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            dataMap.put("type", OrderTypeEnum.TYPE_VEDIO.getValue().equals(consultationEntity.getType()) ? "\u89c6\u9891\u4f1a\u8bca" : "\u56fe\u6587\u4f1a\u8bca");
            dataMap.put("date", DateTimeUtil.formatTime((Date)consultationEntity.getCreateTime(), (String)"yyyy-MM-dd"));
            dataMap.put("name", consultationEntity.getPatientName());
            dataMap.put("sex", consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973");
            dataMap.put("age", String.valueOf(consultationExtendEntity.getPatientAge()));
            dataMap.put("mobile_number", consultationExtendEntity.getPatientPhone());
            dataMap.put("id_card", consultationExtendEntity.getPatientIdCard());
            dataMap.put("from_hospital", consultationEntity.getDoctorHosName());
            dataMap.put("from_dept", consultationEntity.getDoctorDepName());
            dataMap.put("from_doctor", consultationEntity.getDoctorName());
            dataMap.put("to_hospital", consultationEntity.getExpertHosName());
            dataMap.put("to_dept", consultationEntity.getExpertDeptName());
            dataMap.put("to_doctor", consultationEntity.getExpertName());
            String mainSuit = StringUtil.isBlank((String)patientCaseInfoEntity.getMainSuit()) ? "" : patientCaseInfoEntity.getMainSuit().replace(">", "&gt;").replace("<", "&lt;");
            dataMap.put("mainsuit", mainSuit);
            dataMap.put("past_history", StringUtil.isBlank((String)patientCaseInfoEntity.getPastHistory()) ? "" : patientCaseInfoEntity.getPastHistory());
            dataMap.put("present_history", StringUtil.isBlank((String)patientCaseInfoEntity.getPresentHistory()) ? "" : patientCaseInfoEntity.getPresentHistory());
            dataMap.put("family_history", StringUtil.isNotBlank((String)patientCaseInfoEntity.getFamilyHistory()) ? "" : patientCaseInfoEntity.getFamilyHistory());
            dataMap.put("medication_history", StringUtil.isBlank((String)patientCaseInfoEntity.getMedicationHistory()) ? "" : patientCaseInfoEntity.getMedicationHistory());
            dataMap.put("primary_diagno", StringUtil.isBlank((String)patientCaseInfoEntity.getPrimaryDiagno()) ? "" : patientCaseInfoEntity.getPrimaryDiagno());
            dataMap.put("consult_aim", patientCaseInfoEntity.getConsultAim());
            dataMap.put("advice", StringUtil.isBlank((String)patientCaseInfoEntity.getTreatAdvice()) ? "" : patientCaseInfoEntity.getTreatAdvice());
            dataMap.put("sign", WordUtils.getImgUrlToBase64((String)consultationEntity.getPatientSignature()));
            dataMap.put(FILE_NAME, consultationEntity.getViewId() + "_" + consultationEntity.getPatientName());
        }
        return dataMap;
    }

    public void exportReport(Long id, HttpServletResponse response) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(id);
        ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId1(consultationEntity.getViewId());
        if (consultationReportEntity != null && StringUtil.isNotEmpty((String)consultationReportEntity.getPhotoReport())) {
            String photoReport;
            File zipFile;
            String wordPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u4f1a\u8bca\u62a5\u544a\u6587\u4ef6\u5939\u7684\u540d\u79f0\u662f:{}", (Object)wordPath);
            String zipPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u4f1a\u8bca\u62a5\u544a\u538b\u7f29\u5305\u7684\u540d\u79f0\u662f:{}", (Object)zipPath);
            File file = new File(wordPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(zipFile = new File(zipPath)).exists()) {
                zipFile.mkdir();
            }
            if ((photoReport = consultationReportEntity.getPhotoReport()).contains(",")) {
                List strings = Arrays.asList(consultationReportEntity.getPhotoReport().split(",")).stream().collect(Collectors.toList());
                for (String s : strings) {
                    FileUtils.writeImgeUrlToDir((String)s, (String)(consultationEntity.getViewId() + "_" + RandomUtil.getRandom() + consultationEntity.getPatientName()), (String)consultationReportEntity.getPhotoReport().substring(consultationReportEntity.getPhotoReport().lastIndexOf(".")), (String)wordPath);
                }
            } else {
                FileUtils.writeImgeUrlToDir((String)photoReport, (String)(consultationEntity.getViewId() + "_" + consultationEntity.getPatientName()), (String)consultationReportEntity.getPhotoReport().substring(consultationReportEntity.getPhotoReport().lastIndexOf(".")), (String)wordPath);
            }
            ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateTimeUtil.formatTime((Date)new Date(), (String)"yyyyMMddHHmmss"), (HttpServletResponse)response);
        } else {
            Map dataMap = this.capsulateReport(id);
            try {
                WordUtils.exportMillCertificateWord((HttpServletResponse)response, (Map)dataMap, (String)"report.ftl", (String)((String)dataMap.get(FILE_NAME)));
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Map<String, String> capsulateReport(Long id) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(id);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(id);
        if (consultationEntity != null && consultationExtendEntity != null) {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId1(consultationEntity.getViewId());
            dataMap.put("order_view_id", consultationEntity.getViewId());
            dataMap.put("name", consultationEntity.getPatientName());
            dataMap.put("sex", consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973");
            dataMap.put("age", String.valueOf(consultationExtendEntity.getPatientAge()));
            dataMap.put("mobile_number", StringUtil.isBlank((String)consultationExtendEntity.getPatientPhone()) ? "" : consultationExtendEntity.getPatientPhone());
            dataMap.put("id_card", consultationExtendEntity.getPatientIdCard());
            dataMap.put("from_hospital", consultationEntity.getDoctorHosName());
            dataMap.put("from_dept", consultationEntity.getDoctorDepName());
            dataMap.put("from_doctor", consultationEntity.getDoctorName());
            dataMap.put("to_hospital", consultationEntity.getExpertHosName());
            dataMap.put("to_dept", consultationEntity.getExpertDeptName());
            dataMap.put("to_doctor", consultationEntity.getExpertName());
            dataMap.put("type", OrderTypeEnum.TYPE_VEDIO.getValue().equals(consultationEntity.getType()) ? "\u89c6\u9891\u4f1a\u8bca" : "\u56fe\u6587\u4f1a\u8bca");
            dataMap.put("begin_time", StringUtil.isBlank((String)consultationEntity.getBeginTime()) ? "" : consultationEntity.getBeginTime());
            dataMap.put("finish_time", StringUtil.isBlank((String)consultationEntity.getFinishTime()) ? "" : consultationEntity.getFinishTime());
            String mainSuit = StringUtil.isBlank((String)patientCaseInfoEntity.getMainSuit()) ? "" : patientCaseInfoEntity.getMainSuit().replace(">", "&gt;").replace("<", "&lt;");
            dataMap.put("main_suit", mainSuit);
            if (consultationReportEntity == null) {
                dataMap.put("opinion", "");
                dataMap.put("date", "");
                dataMap.put("sign", "");
            } else {
                dataMap.put("opinion", StringUtil.isBlank((String)consultationReportEntity.getTreatPlan()) ? "" : consultationReportEntity.getTreatPlan());
                dataMap.put("date", DateTimeUtil.formatTime((Date)consultationReportEntity.getCreateTime(), (String)"yyyy-MM-dd"));
                dataMap.put("sign", StringUtil.isBlank((String)consultationReportEntity.getSignature()) ? "" : WordUtils.getImgUrlToBase64((String)consultationReportEntity.getSignature()));
            }
            if (consultationEntity.getExpertHospitalId() != null && consultationEntity.getExpertHospitalId() != 0L) {
                QueryOrganDetailVO queryOrganDetailVO = this.remoteManage.getHospitalDetailById(consultationEntity.getExpertHospitalId());
                dataMap.put("head", StringUtil.isNotEmpty((String)queryOrganDetailVO.getLogo()) ? WordUtils.getImgUrlToBase64((String)queryOrganDetailVO.getLogo()) : "");
                dataMap.put("headHospitalName", queryOrganDetailVO.getOrganName());
            } else {
                dataMap.put("head", WordUtils.getImgUrlToBase64((String)DEFAULT_PICTURE_URL));
                dataMap.put("headHospitalName", "\u5317\u4eac\u4e2d\u536b\u4f70\u533b\u533b\u7597\u4fe1\u606f\u6280\u672f\u6709\u9650\u516c\u53f8");
            }
            dataMap.put(FILE_NAME, consultationEntity.getViewId() + "_" + consultationEntity.getPatientName());
        }
        return dataMap;
    }

    public void batchExportReportWord(String orderIds, HttpServletResponse response) {
        List<Object> ids = new ArrayList<Long>();
        if (orderIds.contains(",")) {
            ids = Arrays.asList(orderIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            ids.add(Long.parseLong(orderIds));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            File zipFile;
            String wordPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u4f1a\u8bca\u62a5\u544a\u6587\u4ef6\u5939\u7684\u540d\u79f0\u662f:{}", (Object)wordPath);
            String zipPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u4f1a\u8bca\u62a5\u544a\u538b\u7f29\u5305\u7684\u540d\u79f0\u662f:{}", (Object)zipPath);
            File file = new File(wordPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(zipFile = new File(zipPath)).exists()) {
                zipFile.mkdir();
            }
            for (Long l : ids) {
                ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(l);
                ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId1(consultationEntity.getViewId());
                if (consultationReportEntity != null && StringUtil.isNotEmpty((String)consultationReportEntity.getPhotoReport())) {
                    if (consultationReportEntity.getPhotoReport().contains(",")) {
                        List strings = Arrays.asList(consultationReportEntity.getPhotoReport().split(",")).stream().collect(Collectors.toList());
                        for (String s2 : strings) {
                            FileUtils.writeImgeUrlToDir((String)s2, (String)(consultationEntity.getViewId() + "_" + RandomUtil.getRandom() + consultationEntity.getPatientName()), (String)consultationReportEntity.getPhotoReport().substring(consultationReportEntity.getPhotoReport().lastIndexOf(".")), (String)wordPath);
                        }
                        continue;
                    }
                    FileUtils.writeImgeUrlToDir((String)consultationReportEntity.getPhotoReport(), (String)(consultationEntity.getViewId() + "_" + consultationEntity.getPatientName()), (String)consultationReportEntity.getPhotoReport().substring(consultationReportEntity.getPhotoReport().lastIndexOf(".")), (String)wordPath);
                    continue;
                }
                Map dataMap = this.capsulateReport(l);
                try {
                    WordUtils.exportWordToPath((Map)dataMap, (String)"report.ftl", (String)wordPath, (String)((String)dataMap.get(FILE_NAME)));
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateTimeUtil.formatTime((Date)new Date(), (String)"yyyyMMddHHmmss"), (HttpServletResponse)response);
        }
    }

    public void batchExportApplyWord(String orderIds, HttpServletResponse response) {
        List<Object> ids = new ArrayList<Long>();
        if (orderIds.contains(",")) {
            ids = Arrays.asList(orderIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            ids.add(Long.parseLong(orderIds));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            File zipFile;
            String wordPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u6587\u4ef6\u5939\u7684\u540d\u79f0\u662f:{}", (Object)wordPath);
            String zipPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u538b\u7f29\u5305\u7684\u540d\u79f0\u662f:{}", (Object)zipPath);
            File file = new File(wordPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(zipFile = new File(zipPath)).exists()) {
                zipFile.mkdir();
            }
            for (Long l : ids) {
                Map dataMap = this.capsulateApplyWord(l);
                try {
                    WordUtils.exportWordToPath((Map)dataMap, (String)"importConsultationApplyWord.ftl", (String)wordPath, (String)((String)dataMap.get(FILE_NAME)));
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateTimeUtil.formatTime((Date)new Date(), (String)"yyyyMMddHHmmss"), (HttpServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchAgreeWord(String orderIds, HttpServletResponse response) {
        List<Object> ids = new ArrayList<Long>();
        if (orderIds.contains(",")) {
            ids = Arrays.asList(orderIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            ids.add(Long.parseLong(orderIds));
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            File zipFile;
            String wordPath = "/tmp/" + System.currentTimeMillis();
            String zipPath = "/tmp/" + System.currentTimeMillis();
            File file = new File(wordPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(zipFile = new File(zipPath)).exists()) {
                zipFile.mkdir();
            }
            for (Long l : ids) {
                Map dataMap = this.capsulateAgreeWord(l);
                try {
                    WordUtils.exportWordToPath((Map)dataMap, (String)"agreeWord.ftl", (String)wordPath, (String)((String)dataMap.get(FILE_NAME)));
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateTimeUtil.formatTime((Date)new Date(), (String)"yyyyMMddHHmmss"), (HttpServletResponse)response);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    org.apache.tomcat.util.http.fileupload.FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    org.apache.tomcat.util.http.fileupload.FileUtils.deleteDirectory((File)zipFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void doctorExportReport(Long docId, String search, Integer type, String beginTime, String endTime, String ids, HttpServletResponse response) {
        if (StringUtil.isNotEmpty((String)ids)) {
            this.batchExportReportWord(ids, response);
        } else {
            beginTime = StringUtil.isNotEmpty((String)beginTime) ? beginTime + " 00:00:00" : beginTime;
            endTime = StringUtil.isNotEmpty((String)endTime) ? endTime + " 23:59:59" : endTime;
            List consultationEntityList = this.consultationService.queryConsultationEntityList(docId, search, type, beginTime, endTime, OrderStatusEnum.WAITING.getValue());
            String orderIds = String.join((CharSequence)",", consultationEntityList.stream().map(c -> c.getId().toString()).collect(Collectors.toList()));
            this.batchExportReportWord(orderIds, response);
        }
    }
}

