/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.OrderStatusEnum;
import com.byh.pojo.bo.consultation.AppointmentTimeConsultationDto;
import com.byh.pojo.bo.consultation.ConsulationEntityDto;
import com.byh.pojo.bo.consultation.OrderDetailDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.StringUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MyClinicManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MyClinicManager.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private ConsultationExtendService consultationExtendService;

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<OrderDetailDto>> queryConsultationListByPatientIdAndHospitalId(Integer pageIndex, Integer pageSize, Long patientId, Long userId, Long hosId, Long doctorId, String search) {
        ArrayList<OrderDetailDto> list = new ArrayList<OrderDetailDto>();
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.consultationService.queryConsultationListByPatientIdAndHospitalId(patientId, userId, hosId, doctorId, search);
        if (consultationEntityList != null) {
            for (ConsultationEntity consultationEntity : consultationEntityList) {
                PatientCaseInfoEntity PatientCaseInfoDTO2;
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                OrderDetailDto orderDetailDto = new OrderDetailDto();
                orderDetailDto.setOrderId(consultationEntity.getId());
                orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
                orderDetailDto.setOrderViewId(consultationEntity.getViewId());
                orderDetailDto.setOrderStatus(consultationEntity.getStatus());
                orderDetailDto.setOrderType(consultationEntity.getType());
                orderDetailDto.setOrderPrice(consultationExtendEntity.getPrice());
                orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
                orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
                orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
                orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
                orderDetailDto.setConsultationDate(consultationEntity.getConsultationDate());
                orderDetailDto.setConsultationTime(consultationEntity.getConsultationTime());
                orderDetailDto.setOrderClosedTime(consultationEntity.getClosedTime());
                orderDetailDto.setPatientId(consultationEntity.getPatientId());
                orderDetailDto.setPatientName(consultationEntity.getPatientName());
                orderDetailDto.setPatientSex(consultationExtendEntity.getPatientSex());
                orderDetailDto.setPatientAge(consultationExtendEntity.getPatientAge());
                orderDetailDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
                orderDetailDto.setDocId(consultationEntity.getDoctorId());
                orderDetailDto.setDocName(consultationEntity.getDoctorName());
                orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
                orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
                orderDetailDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
                orderDetailDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
                orderDetailDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
                orderDetailDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
                PatientInfoRespVO patientInfoDTO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
                if (patientInfoDTO != null) {
                    orderDetailDto.setPatientTel(patientInfoDTO.getContactMobile());
                }
                if ((PatientCaseInfoDTO2 = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId())) != null) {
                    orderDetailDto.setPatCaseMainSuit(PatientCaseInfoDTO2.getMainSuit());
                }
                list.add(orderDetailDto);
            }
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ResultInfo<List<ConsulationEntityDto>> queryConsultationList(Integer pageIndex, Integer pageSize, String beginTime, String endTime, Integer status, String depName, String search) {
        if (StringUtil.isNotEmpty((String)beginTime)) {
            beginTime = beginTime + " 00:00:00";
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            endTime = endTime + " 23:59:59";
        }
        ArrayList hosList = new ArrayList();
        ArrayList<ConsulationEntityDto> list = new ArrayList<ConsulationEntityDto>();
        Page page = PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.consultationService.queryConsultationList(beginTime, endTime, status, depName, search, hosList);
        int count = Integer.valueOf(String.valueOf(page.getTotal()));
        if (CollectionUtils.isNotEmpty((Collection)consultationEntityList)) {
            for (ConsultationEntity consultationEntity : consultationEntityList) {
                ConsultationReportEntity consultationReport;
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                ConsulationEntityDto consulationEntityDto = new ConsulationEntityDto();
                consulationEntityDto.setOrderId(consultationEntity.getId());
                consulationEntityDto.setOrderTime(consultationEntity.getCreateTime().toString());
                consulationEntityDto.setViewId(consultationEntity.getViewId());
                consulationEntityDto.setStatus(consultationEntity.getStatus());
                consulationEntityDto.setType(consultationEntity.getType());
                consulationEntityDto.setPrice(consultationExtendEntity.getPrice());
                consulationEntityDto.setVideoTime(consultationExtendEntity.getVideoTime());
                consulationEntityDto.setFinishTime(consultationEntity.getFinishTime());
                consulationEntityDto.setTotal(Integer.valueOf(count));
                consulationEntityDto.setPatientName(consultationEntity.getPatientName());
                consulationEntityDto.setPatientSex(consultationExtendEntity.getPatientSex());
                consulationEntityDto.setPatientAge(consultationExtendEntity.getPatientAge());
                consulationEntityDto.setDoctorId(consultationEntity.getDoctorId());
                consulationEntityDto.setDoctorName(consultationEntity.getDoctorName());
                consulationEntityDto.setDoctorDepId(consultationEntity.getDoctorDepId());
                consulationEntityDto.setDoctorDetpName(consultationEntity.getDoctorDepName());
                consulationEntityDto.setDoctorHospitalId(consultationEntity.getDoctorHospitalId());
                consulationEntityDto.setDoctorHosName(consultationEntity.getDoctorHosName());
                consulationEntityDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
                consulationEntityDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
                consulationEntityDto.setExpertDepId(Long.valueOf(consultationEntity.getExpertDepId() == null ? 0L : consultationEntity.getExpertDepId()));
                consulationEntityDto.setExpertDeptName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
                consulationEntityDto.setExpertHospitalId(Long.valueOf(consultationEntity.getExpertHospitalId() == null ? 0L : consultationEntity.getExpertHospitalId()));
                consulationEntityDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
                if (consultationEntity.getStatus().intValue() == OrderStatusEnum.FINISH.getValue().intValue() && (consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) != null && consultationReport.getStatus() == 1) {
                    consulationEntityDto.setIsReport(Integer.valueOf(1));
                }
                list.add(consulationEntityDto);
            }
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ConsultationEntity queryConsultationEntityById(Long id) {
        return this.consultationService.queryConsultationEntityById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateConsultationTimeByOrderId(Long id, String consultationTime, String consultationDate) {
        return this.consultationService.updateConsultationTimeByOrderId(id, consultationTime, consultationDate);
    }

    public ConsultationEntity queryConsultationByOrerId(Long orderId) {
        return this.consultationService.queryConsultationEntityById(orderId);
    }

    public int updateOrderStatusByOrderIdAndClose(Long orderId, String closeTime) {
        return this.consultationService.updateOrderStatusByOrderIdAndClose(orderId, closeTime);
    }

    public List<ConsultationEntity> queryConsultationByExpertId(Long expertId) {
        return this.consultationService.queryConsultationByExpertId(expertId);
    }

    public List<AppointmentTimeConsultationDto> queryConsultationDateByExpertId(Long expertId, String consultationDate) {
        return this.consultationService.queryConsultationDateByExpertId(expertId, consultationDate);
    }

    public int queryCountConsultationDateByExpertId(Long expertId, String consultationDate, String consultationTime) {
        return this.consultationService.queryCountConsultationDateByExpertId(expertId, consultationDate, consultationTime);
    }
}

