/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.exception.PushInfoException;
import com.byh.feign.IhospitalApiClient;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.httppojo.PushSubscribeMessageReqVO;
import com.byh.pojo.httppojo.UcWxAuthReqVo;
import com.byh.pojo.vo.consultation.req.UcConfigurationReqVO;
import com.byh.pojo.vo.consultation.res.ClientCodeVO;
import com.byh.pojo.vo.consultation.res.XcxUcConfigurationResVO;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.HttpUtils;
import com.byh.util.ProgramUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProgramMessageManager {
    private static final Logger log = LoggerFactory.getLogger(ProgramMessageManager.class);
    public static final String WX_PROGRAM = "weChatApplets";
    @Autowired
    private ProgramUtils programUtils;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;

    public String getAppCode(Long orderId) {
        ConsultationEntity order = this.consultationService.queryConsultationEntityById(orderId);
        String code = "";
        if (order != null) {
            BaseDTO baseDTO = new BaseDTO();
            baseDTO.setId(Integer.valueOf(order.getDoctorHospitalId().intValue()));
            code = (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
        }
        return code;
    }

    public String getClientCode(String appCode) {
        String clientCode = "";
        StringBuffer url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress());
        XcxUcConfigurationResVO xcxUcConfigurationResVO = new XcxUcConfigurationResVO();
        url = url.append("cloud/doctoruser/configuration/getdetail");
        UcConfigurationReqVO ucConfigurationReqVO = new UcConfigurationReqVO();
        ucConfigurationReqVO.setAppCode(appCode);
        ucConfigurationReqVO.setType(WX_PROGRAM);
        log.info("\u83b7\u53d6clientCode\u7684\u8bf7\u6c42url\u662f:{}====\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)ucConfigurationReqVO));
        String resData = "";
        try {
            resData = HttpUtils.post((String)url.toString(), (String)JSON.toJSONString((Object)ucConfigurationReqVO));
            log.info("\u8c03\u7528\u4e91\u7aef\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u7684clientCode\u662f:{}", (Object)resData);
            if (StringUtil.isNotBlank((String)JSONObject.parseObject((String)resData).getString("data"))) {
                xcxUcConfigurationResVO = (XcxUcConfigurationResVO)JSONObject.parseObject((String)JSONObject.parseObject((String)resData).getString("data"), XcxUcConfigurationResVO.class);
                ClientCodeVO codeVO = (ClientCodeVO)JSONObject.parseObject((String)xcxUcConfigurationResVO.getClientCode(), ClientCodeVO.class);
                clientCode = codeVO.getClientCode();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return clientCode;
    }

    @Async
    public void patientOrderPush(ConsultationEntity consultationEntity) {
        try {
            log.info("============\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u63a8\u9001==============");
            String appCode = this.getAppCode(consultationEntity.getId());
            log.info("============appCode:{}", (Object)appCode);
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
            String clientCode = this.getClientCode(appCode);
            pushSubscribeMessageReqVO.setClientCode(clientCode);
            pushSubscribeMessageReqVO.setTemplateCode("application_success_notify");
            pushSubscribeMessageReqVO.setPage("");
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", "\u8fdc\u7a0b\u4f1a\u8bca");
            data.put("projectName", map);
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", DateTimeUtil.chinaTime((Date)consultationEntity.getCreateTime()));
            data.put("time", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", consultationEntity.getPatientName());
            data.put("patientName", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", consultationEntity.getDoctorName());
            data.put("doctorName", map3);
            HashMap<String, String> map4 = new HashMap<String, String>();
            map4.put("value", "\u60a8\u5df2\u786e\u8ba4\u4f1a\u8bca\u77e5\u60c5\u540c\u610f\u4e66\u5e76\u7533\u8bf7\u6210\u529f");
            data.put("remake", map4);
            List userIdList = this.programUtils.getUserIdList(consultationEntity.getPatientId(), appCode);
            if (!CollectionUtils.isEmpty((Collection)userIdList)) {
                for (String userId : userIdList) {
                    log.info("================userId:{}", (Object)userId);
                    UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
                    ucWxAuthReqVo.setStatus(Integer.valueOf(1));
                    ucWxAuthReqVo.setUserId(userId);
                    ucWxAuthReqVo.setUserType(Integer.valueOf(0));
                    String openId = this.programUtils.getWxOpenId(ucWxAuthReqVo, appCode);
                    log.info("============openId:{}", (Object)openId);
                    pushSubscribeMessageReqVO.setOpenId(openId);
                    pushSubscribeMessageReqVO.setData(data);
                    log.info("============pushSubscribeMessageReqVO:{}", (Object)pushSubscribeMessageReqVO.toString());
                    log.info("============\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u63a8\u9001\u5f00\u59cb==============");
                    this.programUtils.ProgramPush(pushSubscribeMessageReqVO, appCode);
                    log.info("============\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u63a8\u9001\u7ed3\u675f==============");
                }
            }
        }
        catch (Exception e) {
            log.error("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u5f02\u5e38{}", (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertAcceptPush(ConsultationEntity consultationEntity, String acceptTime) throws ParseException {
        try {
            log.info("============\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u63a5\u8bca\u63a8\u9001==============");
            String appCode = this.getAppCode(consultationEntity.getId());
            log.info("============appCode:{}", (Object)appCode);
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
            String clientCode = this.getClientCode(appCode);
            pushSubscribeMessageReqVO.setClientCode(clientCode);
            pushSubscribeMessageReqVO.setTemplateCode("doctor_received_remind");
            pushSubscribeMessageReqVO.setPage("");
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", "\u4e13\u5bb6\u5df2\u63a5\u8bca,\u8bf7\u8010\u5fc3\u7b49\u5f85\u4f1a\u8bca\u5b8c\u6210");
            data.put("remake", map);
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", "\u8fdc\u7a0b\u4f1a\u8bca");
            data.put("projectName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", consultationEntity.getPatientName());
            data.put("patientName", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", consultationEntity.getExpertName());
            data.put("expertName", map3);
            HashMap<String, String> map4 = new HashMap<String, String>();
            map4.put("value", DateTimeUtil.chinaTime((String)acceptTime));
            data.put("time", map4);
            List userIdList = this.programUtils.getUserIdList(consultationEntity.getPatientId(), appCode);
            if (!CollectionUtils.isEmpty((Collection)userIdList)) {
                for (String userId : userIdList) {
                    UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
                    ucWxAuthReqVo.setStatus(Integer.valueOf(1));
                    ucWxAuthReqVo.setUserId(userId);
                    ucWxAuthReqVo.setUserType(Integer.valueOf(0));
                    String openId = this.programUtils.getWxOpenId(ucWxAuthReqVo, appCode);
                    log.info("============openId:{}", (Object)openId);
                    pushSubscribeMessageReqVO.setOpenId(openId);
                    pushSubscribeMessageReqVO.setData(data);
                    log.info("============pushSubscribeMessageReqVO:{}", (Object)pushSubscribeMessageReqVO.toString());
                    log.info("============\u5c0f\u7a0b\u5e8f\u63a5\u8bca\u63a8\u9001\u5f00\u59cb==============");
                    this.programUtils.ProgramPush(pushSubscribeMessageReqVO, appCode);
                    log.info("============\u5c0f\u7a0b\u5e8f\u63a5\u8bca\u63a8\u9001\u7ed3\u675f==============");
                }
            }
        }
        catch (ParseException e) {
            log.error("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u5f02\u5e38{}", (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void cancelOrderPush(ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity, String closeTime) throws ParseException {
        try {
            log.info("============\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u53d6\u6d88\u8ba2\u5355\u63a8\u9001==============");
            String appCode = this.getAppCode(consultationEntity.getId());
            log.info("============appCode:{}", (Object)appCode);
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
            String clientCode = this.getClientCode(appCode);
            pushSubscribeMessageReqVO.setClientCode(clientCode);
            pushSubscribeMessageReqVO.setTemplateCode("order_cancel_notify");
            pushSubscribeMessageReqVO.setPage("");
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", "\u8fdc\u7a0b\u4f1a\u8bca");
            data.put("projectName", map);
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", "\uffe5" + consultationExtendEntity.getPrice() + "\u5143");
            data.put("price", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", DateTimeUtil.chinaTime((String)closeTime));
            data.put("closeTime", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", consultationEntity.getViewId());
            data.put("orderViewId", map3);
            HashMap<String, String> map4 = new HashMap<String, String>();
            map4.put("value", "\u5df2\u9000\u6b3e,\u9000\u6b3e\u5c06\u57282\u5929\u5185\u5165\u8d26\u81f3\u60a8\u7684\u652f\u4ed8\u8d26\u53f7");
            data.put("remake", map4);
            List userIdList = this.programUtils.getUserIdList(consultationEntity.getPatientId(), appCode);
            if (!CollectionUtils.isEmpty((Collection)userIdList)) {
                for (String userId : userIdList) {
                    UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
                    ucWxAuthReqVo.setStatus(Integer.valueOf(1));
                    ucWxAuthReqVo.setUserId(userId);
                    ucWxAuthReqVo.setUserType(Integer.valueOf(0));
                    String openId = this.programUtils.getWxOpenId(ucWxAuthReqVo, appCode);
                    log.info("============openId:{}", (Object)openId);
                    pushSubscribeMessageReqVO.setOpenId(openId);
                    pushSubscribeMessageReqVO.setData(data);
                    log.info("============pushSubscribeMessageReqVO:{}", (Object)pushSubscribeMessageReqVO.toString());
                    log.info("============\u5c0f\u7a0b\u5e8f\u53d6\u6d88\u8ba2\u5355\u63a8\u9001\u5f00\u59cb==============");
                    this.programUtils.ProgramPush(pushSubscribeMessageReqVO, appCode);
                    log.info("============\u5c0f\u7a0b\u5e8f\u53d6\u6d88\u8ba2\u5355\u63a8\u9001\u7ed3\u675f==============");
                }
            }
        }
        catch (ParseException e) {
            log.error("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u5f02\u5e38{}", (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void finishOrderPush(ConsultationEntity consultationEntity) throws ParseException {
        try {
            log.info("============\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u5b8c\u6210\u4f1a\u8bca\u63a8\u9001==============");
            String appCode = this.getAppCode(consultationEntity.getId());
            log.info("============appCode:{}", (Object)appCode);
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
            String clientCode = this.getClientCode(appCode);
            pushSubscribeMessageReqVO.setClientCode(clientCode);
            pushSubscribeMessageReqVO.setTemplateCode("server_finished_notify");
            pushSubscribeMessageReqVO.setPage("");
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", "\u8fdc\u7a0b\u4f1a\u8bca");
            data.put("projectName", map);
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", DateTimeUtil.chinaTime((String)consultationEntity.getFinishTime()));
            data.put("time", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", "\uffe5" + consultationExtendEntity.getPrice() + "\u5143");
            data.put("price", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u672c\u6b21\u8fdc\u7a0b\u4f1a\u8bca\u670d\u52a1\u5df2\u5b8c\u6210");
            data.put("remake", map3);
            List userIdList = this.programUtils.getUserIdList(consultationEntity.getPatientId(), appCode);
            if (!CollectionUtils.isEmpty((Collection)userIdList)) {
                for (String userId : userIdList) {
                    UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
                    ucWxAuthReqVo.setStatus(Integer.valueOf(1));
                    ucWxAuthReqVo.setUserId(userId);
                    ucWxAuthReqVo.setUserType(Integer.valueOf(0));
                    String openId = this.programUtils.getWxOpenId(ucWxAuthReqVo, appCode);
                    log.info("============openId:{}", (Object)openId);
                    pushSubscribeMessageReqVO.setOpenId(openId);
                    pushSubscribeMessageReqVO.setData(data);
                    log.info("============pushSubscribeMessageReqVO:{}", (Object)pushSubscribeMessageReqVO.toString());
                    log.info("============\u5c0f\u7a0b\u5e8f\u5b8c\u6210\u4f1a\u8bca\u63a8\u9001\u5f00\u59cb==============");
                    this.programUtils.ProgramPush(pushSubscribeMessageReqVO, appCode);
                    log.info("============\u5c0f\u7a0b\u5e8f\u5b8c\u6210\u4f1a\u8bca\u63a8\u9001\u7ed3\u675f==============");
                }
            }
        }
        catch (ParseException e) {
            log.error("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u5f02\u5e38{}", (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }
}

