/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.byh.feign.IDoctorApiClient;
import com.byh.feign.IhospitalApiClient;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.doctor.QueryPiontServiceDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.PointDoctorServiceInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteManage {
    private static final Logger log = LoggerFactory.getLogger(RemoteManage.class);
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;

    public DoctorEntityInfoVO getDoctorDetailById(Long id) {
        log.info("\u8c03\u7528\u65f6\u533b\u751f\u8be6\u60c5\u7684id\u662f:" + id);
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(id.intValue()));
        BaseResponse doctorDetailsInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
        return (DoctorEntityInfoVO)doctorDetailsInfoVOBaseResponse.getData();
    }

    public QueryOrganDetailVO getHospitalDetailById(Long id) {
        log.info("==\u8c03\u7528\u53d6\u533b\u9662\u8be6\u60c5\u7684id\u662f:" + id);
        QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
        queryOrganDetailDTO.setOrganId(Integer.valueOf(id.intValue()));
        BaseResponse organDetailVOBaseResponse = this.ihospitalApiClient.queryOrganDetail(queryOrganDetailDTO);
        return (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
    }

    public List<PointDoctorServiceInfoVO> queryDoctorServiceInfo(List<QueryPiontServiceDTO> serviceDTOS) {
        BaseResponse listBaseResponse = this.iDoctorApiClient.queryDoctorPointServiceInfo(serviceDTOS);
        return (List)listBaseResponse.getData();
    }

    public String getAppCodeByHospitalId(Integer hospitalId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(hospitalId);
        return (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
    }
}

