/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.byh.controller.BaseController;
import com.byh.exception.PushInfoException;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.vo.consultation.req.BaseAliSmsReqVO;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.util.AliSmsTemplate;
import com.byh.util.DateTimeUtil;
import com.byh.util.PushInfoManagerUtils;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ShortMessageManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ShortMessageManager.class);
    public static final String SMSAPPCODE = "";
    public static final Integer USER = 0;
    public static final Integer DOCTOR = 1;
    @Autowired
    private PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private RemoteManage remoteManage;

    @Async
    public void newConsultationToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.newConsultationToDoctorMsg);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String sex = consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("sex", sex);
            map.put("age", consultationExtendEntity.getPatientAge().toString());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void videoConsultationAccept(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.videoConsultationAcceptMsg);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String time = consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            map.put("time", time);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationAccept(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.photoConsultationAcceptMsg);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String time = consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime();
            Date date = DateTimeUtil.parseTime((String)time, (String)"yyyy-MM-dd HH:mm:ss");
            String dateTimeStr = DateTimeUtil.formatTime((Date)DateTimeUtil.addDay((Date)date, (int)1), (String)"yyyy-MM-dd HH:mm:ss");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            map.put("time", dateTimeStr);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationExpertChanged(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.consultationExpertChangedMsg);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("doctorname", consultationEntity.getDoctorName());
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationStartToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.consultationStartMsgToDoctor);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationStartedToDoctor(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.consultationStartedMsgToDoctor);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void videoConsultationFromAdminToDoctor(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.videoConsultationFromAdminMsgToDoctor);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationFromAdminToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.photoConsultationFromAdminMsgToDoctor);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void reportHaveSubmitToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.reportHaveSubmitMsgToDoctor);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void videoConsultationApplyToExpert(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.videoConsultationApplyToExpert);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationApplyToExpert(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.photoConsultationApplyToExpert);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationStartToExpert(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.consultationStartMsgToExpert);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("doctorname", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationStartedToExpert(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.consultationStartedMsgToExpert);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("doctorname", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void videoConsultationFromAdminToReport(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.videoConsultationFromAdminMsgToReport);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationFromAdminToReport(ConsultationEntity consultationEntity) {
        try {
            String userId = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId()).getUserId();
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.photoConsultationFromAdminMsgToReport);
            baseAliSmsReqVO.setUserType(DOCTOR);
            baseAliSmsReqVO.setAppSdkType("ali");
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertConsultationReportRefused(String orderViewId, String reason) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.expertConsultationReportRefused);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("reason", reason);
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertConsultationReportNews(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.getExpertConsultationReportNews);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientName", consultationEntity.getPatientName());
            map.put("doctorName", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void applySubmittedToUser(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.applySubmittedMsgToUser);
            baseAliSmsReqVO.setUserType(USER);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            baseAliSmsReqVO.setAppSdkType("ali");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("doctorName", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void doctorHaveSubmitApply(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.doctorHaveSubmitApply);
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("doctorName", consultationEntity.getDoctorName());
            map.put("expertName", consultationEntity.getExpertName());
            map.put("hospitalName", consultationEntity.getDoctorHosName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertHaveAcceptApply(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.expertHaveAcceptApply);
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String time = consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertName", consultationEntity.getExpertName());
            map.put("date", time);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void remindUserWatchReport(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.remindUserWatchReport);
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void remindUserSignName(ConsultationEntity consultationEntity, String patientPhone) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.remindUserSignName);
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            baseAliSmsReqVO.setPhone(patientPhone);
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void cancelConsultationApply(String orderViewId, String reason) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.cancelConsultationApply);
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            baseAliSmsReqVO.setPhone(extendEntity.getPatientPhone());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("reason", reason);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void cancelConsultationToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode(AliSmsTemplate.cancelOrderToDoctor);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void verifyDoctorBillInfo(DoctorBillInfoEntity billInfoEntity, String phone, Integer doctorHospitalId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("money", billInfoEntity.getActualMoney().toString());
            BaseAliSmsReqVO aliSmsSendPatientInfoReqVO = new BaseAliSmsReqVO();
            aliSmsSendPatientInfoReqVO.setAppSdkType("ali");
            aliSmsSendPatientInfoReqVO.setSmsAppCode("EHOS_BYH");
            aliSmsSendPatientInfoReqVO.setTemplateCode("SMS_152208307");
            aliSmsSendPatientInfoReqVO.setUserType(DOCTOR);
            aliSmsSendPatientInfoReqVO.setPhone(phone);
            if (params != null) {
                aliSmsSendPatientInfoReqVO.setParams(params);
            }
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(doctorHospitalId);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, aliSmsSendPatientInfoReqVO);
            log.info("================\u5165\u8d26\u77ed\u4fe1\u63a8\u9001\u5b8c\u6210=============");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    private void improveBaseAliSmsReqVO(BaseAliSmsReqVO baseAliSmsReqVO, Long doctorId) {
        String phone = this.remoteManage.getDoctorDetailById(doctorId).getRegisterMobile();
        baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
        baseAliSmsReqVO.setPhone(phone);
        baseAliSmsReqVO.setUserType(DOCTOR);
        baseAliSmsReqVO.setAppSdkType("ali");
    }
}

