/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.healthallian;

import com.byh.common.ResultInfo;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.controller.BaseController;
import com.byh.enums.HealthAllianceEnum;
import com.byh.enums.HealthAllianceTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.IOrganizationApiClient;
import com.byh.pojo.bo.healthallian.HospitalHealthAllianceDto;
import com.byh.pojo.bo.healthallian.SuperHospitaMemberlDto;
import com.byh.pojo.bo.healthallian.SuperHospitalHealthAllianceDto;
import com.byh.pojo.bo.healthallian.SuperHospitalHealthAllianceUpdateDto;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceEntity;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceMemberEntity;
import com.byh.pojo.vo.healthalliance.HospitalHealthAllianceVo;
import com.byh.pojo.vo.healthalliance.SuperHospitalHealthAllianceVo;
import com.byh.service.healthalliace.HealthAllianceMemberService;
import com.byh.service.healthalliace.HealthAllianceService;
import com.byh.service.healthalliace.HealthAllianceServiceService;
import com.byh.util.HttpClientUtils;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.doctoruser.api.pojo.dto.organization.ListOrganDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.organization.DoctorNumberVO;
import com.doctoruser.api.pojo.vo.basedata.organization.ListOrganVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.JedisCluster;

@Service
public class HealthAllianceManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(HealthAllianceManager.class);
    @Autowired
    private HealthAllianceService healthAllianceService;
    @Autowired
    private HealthAllianceMemberService healthAllianceMemberService;
    @Autowired
    private HealthAllianceServiceService healthAllianceServiceService;
    @Autowired
    private IOrganizationApiClient iOrganizationApiClient;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo insertHospitalHealthAlliance(HospitalHealthAllianceDto hospitalHealthAllianceDto) {
        if (hospitalHealthAllianceDto.getApplicantId() == null || hospitalHealthAllianceDto.getApplicantId().intValue() == 0) {
            log.info("\u8bf7\u8f93\u5165\u7533\u8bf7\u8005id=========");
            return this.returnFailure("\u8bf7\u8f93\u5165\u7533\u8bf7\u8005id");
        }
        if (hospitalHealthAllianceDto.getApplicantType() == null || hospitalHealthAllianceDto.getApplicantType() == 0) {
            return this.returnFailure("\u8bf7\u8f93\u5165\u7533\u8bf7\u8005type");
        }
        if (hospitalHealthAllianceDto.getHospitalId() == null || hospitalHealthAllianceDto.getHospitalId().intValue() == 0) {
            return this.returnFailure("\u8bf7\u8f93\u5165\u533b\u9662id");
        }
        if (hospitalHealthAllianceDto.getHospitalLevel() == null || hospitalHealthAllianceDto.getHospitalLevel() == 0) {
            return this.returnFailure("\u8bf7\u8f93\u5165\u533b\u9662\u7b49\u7ea7");
        }
        if (hospitalHealthAllianceDto.getYltName() == null || hospitalHealthAllianceDto.getYltName().equals("")) {
            return this.returnFailure("\u8bf7\u8f93\u5165\u533b\u8054\u4f53\u540d\u79f0");
        }
        int i = this.healthAllianceService.insertHospitalHealthAlliance(hospitalHealthAllianceDto);
        if (i < 0) {
            return this.returnFailure("\u7533\u8bf7\u533b\u8054\u4f53\u5931\u8d25");
        }
        return this.returnSucceed("\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo updateHospitalHealthAlliance(Long auditorId, Integer auditorType, Integer status, Long hospitalId) {
        if (auditorId == null || auditorId.intValue() == 0) {
            log.info("\u5ba1\u6838\u4ebaid\u4e3a\u7a7a=======");
            return this.returnFailure("\u5ba1\u6838\u4ebaid\u4e3a\u7a7a=======");
        }
        if (auditorType == null || auditorType == 0) {
            log.info("\u5ba1\u6838\u4eba\u7c7b\u578b\u4e3a\u7a7a=======");
            return this.returnFailure("\u5ba1\u6838\u4eba\u7c7b\u578b\u4e3a\u7a7a=======");
        }
        if (status == null || status == 0) {
            log.info("\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a=======");
            return this.returnFailure("\u5ba1\u6838\u4eba\u72b6\u6001\u4e3a\u7a7a=======");
        }
        if (hospitalId == null && hospitalId.intValue() == 0) {
            log.info("\u533b\u9662id\u4e3a\u7a7a=======");
            return this.returnFailure("\u533b\u9662id\u4e3a\u7a7a=======");
        }
        int flag = this.healthAllianceService.updateHospitalHealthAlliance(auditorId, auditorType, status, hospitalId);
        if (flag == 0) {
            log.info("\u72b6\u6001\u4fee\u6539\u8be5\u5931\u8d25======" + flag);
            return this.returnFailure("\u72b6\u6001\u4fee\u6539\u8be5\u5931\u8d25");
        }
        return this.returnSucceed("\u72b6\u6001\u4fee\u6539\u8be5\u6210\u529f");
    }

    public ResultInfo<List<HospitalHealthAllianceVo>> getListHealthAllianceByHospitalId(Long hospitalId, Integer pageIndex, Integer pageSize, String searchParam) {
        if (hospitalId == null || hospitalId.intValue() == 0) {
            log.info("\u8bf7\u4f20\u5165\u533b\u9662id========");
            return this.returnFailure("\u8bf7\u4f20\u5165\u533b\u9662id");
        }
        String flag = this.healthAllianceMemberService.getHealthAllianceByHospitalId(hospitalId);
        if (flag == null) {
            return this.returnSucceed("\u6700\u540e\u4e00\u9875");
        }
        if (flag.equals("0")) {
            return this.returnFailure("\u8be5\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53\u5185");
        }
        String ids = flag;
        ArrayList integers = new ArrayList();
        if (StringUtil.isNotEmpty((String)ids)) {
            List<String> strings = new ArrayList<String>();
            if (ids.contains(",")) {
                strings = Arrays.asList(ids.split(","));
            } else {
                strings.add(ids);
            }
            CollectionUtils.collect(strings, (Transformer)new /* Unavailable Anonymous Inner Class!! */, integers);
        }
        log.info("=====\u53d6\u5230\u533b\u9662\u7684id\u662f:" + ((Object)integers).toString());
        ListOrganDTO listOrganDTO = new ListOrganDTO();
        listOrganDTO.setHospitalId(integers);
        listOrganDTO.setSearchParam(searchParam);
        listOrganDTO.setPageNum(pageIndex);
        listOrganDTO.setPageSize(pageSize);
        BaseResponse hxPageBaseResponse = this.iOrganizationApiClient.queryOrganList(listOrganDTO);
        if (hxPageBaseResponse.getCode().equals("1") && hxPageBaseResponse.getData() != null) {
            ArrayList<HospitalHealthAllianceVo> healthAllianceList = new ArrayList<HospitalHealthAllianceVo>();
            List hospitalInfoEntityList = ((PageResult)hxPageBaseResponse.getData()).getContent();
            if (CollectionUtils.isNotEmpty((Collection)hospitalInfoEntityList)) {
                for (ListOrganVO hospitalInfo : hospitalInfoEntityList) {
                    HospitalHealthAllianceVo hospitalHealthAllianceVo = new HospitalHealthAllianceVo();
                    HospitalHealthAllianceMemberEntity memberEntity = this.healthAllianceMemberService.getByHospitalIdAndRole(hospitalInfo.getHospitalId().toString(), HospitalHealthAllianceMemberEntity.TYPE_ISCENTER_HOSPITAL);
                    if (memberEntity == null) {
                        hospitalHealthAllianceVo.setIsCenterHospital(HospitalHealthAllianceMemberEntity.NOT_CENTER_HOSPITAL);
                    } else {
                        hospitalHealthAllianceVo.setIsCenterHospital(HospitalHealthAllianceMemberEntity.IS_CENTER_HOSPITAL);
                    }
                    hospitalHealthAllianceVo.setHospitalId(Long.valueOf(Long.parseLong(hospitalInfo.getHospitalId().toString())));
                    hospitalHealthAllianceVo.setHospitalName(hospitalInfo.getHospitalName());
                    hospitalHealthAllianceVo.setHospitalLogo(hospitalInfo.getLogo());
                    hospitalHealthAllianceVo.setHosType(hospitalInfo.getCategoryName());
                    hospitalHealthAllianceVo.setCategoryName(hospitalInfo.getCategoryName());
                    hospitalHealthAllianceVo.setDepartmentNum(hospitalInfo.getDeptNum());
                    hospitalHealthAllianceVo.setDoctorNum(hospitalInfo.getExpertNum());
                    hospitalHealthAllianceVo.setAppCode(hospitalInfo.getAppCode());
                    hospitalHealthAllianceVo.setHotDepartmentName(hospitalInfo.getHotDepartmentName());
                    healthAllianceList.add(hospitalHealthAllianceVo);
                }
                Collections.sort(healthAllianceList, new /* Unavailable Anonymous Inner Class!! */);
                log.info("\u6392\u597d\u5e8f\u540e\u533b\u9662id\u663e\u793a\u662f:{}", (Object)healthAllianceList.stream().map(HospitalHealthAllianceVo::getHospitalId).collect(Collectors.toList()).toString());
            }
            return this.returnSucceed(healthAllianceList, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnSucceed(new ArrayList(), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<HospitalHealthAllianceVo>> getListHospitalHealthAlliance(Integer pageIndex, Integer pageSize, String searchParam) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List list = this.healthAllianceService.getListHospitalHealthAlliance();
        if (list == null || list.size() < 1) {
            return this.returnSucceed("\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u9875\u4e86....");
        }
        String ids = "";
        for (HospitalHealthAllianceEntity hospitalHealthAllianceEntity : list) {
            ids = ids + hospitalHealthAllianceEntity.getHospitalId() + ",";
        }
        if (!ids.equals("")) {
            ids = ids.substring(0, ids.length() - 1);
        }
        ArrayList integers = new ArrayList();
        if (StringUtil.isNotEmpty((String)ids)) {
            List<String> strings = Arrays.asList(ids.split(","));
            CollectionUtils.collect(strings, (Transformer)new /* Unavailable Anonymous Inner Class!! */, integers);
        }
        ListOrganDTO listOrganDTO = new ListOrganDTO();
        listOrganDTO.setHospitalId(integers);
        listOrganDTO.setSearchParam(searchParam);
        BaseResponse hxPageBaseResponse = this.iOrganizationApiClient.queryOrganList(listOrganDTO);
        if (hxPageBaseResponse.getCode() == "1") {
            ArrayList<HospitalHealthAllianceVo> healthAllianceList = new ArrayList<HospitalHealthAllianceVo>();
            List hospitalInfoEntityList = ((PageResult)hxPageBaseResponse.getData()).getContent();
            if (CollectionUtils.isNotEmpty((Collection)hospitalInfoEntityList)) {
                for (ListOrganVO hospitalInfo : hospitalInfoEntityList) {
                    HospitalHealthAllianceVo hospitalHealthAllianceVo = new HospitalHealthAllianceVo();
                    hospitalHealthAllianceVo.setOrganCategory(hospitalInfo.getOrganCategory());
                    hospitalHealthAllianceVo.setCategoryName(hospitalInfo.getCategoryName());
                    hospitalHealthAllianceVo.setDepartmentNum(hospitalInfo.getDeptNum());
                    hospitalHealthAllianceVo.setDoctorNum(hospitalInfo.getExpertNum());
                    hospitalHealthAllianceVo.setHotDepartmentName("");
                    healthAllianceList.add(hospitalHealthAllianceVo);
                }
                return this.returnSucceed(healthAllianceList, "\u6210\u529f");
            }
            log.info("\u83b7\u53d6\u533b\u8054\u4f53\u5931\u8d25=========");
            return this.returnSucceed("\u7a7a");
        }
        return this.returnFailure("\u5931\u8d25");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo insertSuperHospitalHealthAlliance(SuperHospitalHealthAllianceDto superHospitalHealthAllianceDto) {
        String appCode = superHospitalHealthAllianceDto.getAppCode();
        HospitalHealthAllianceEntity hospitalHealthAlliance = new HospitalHealthAllianceEntity();
        hospitalHealthAlliance.setViewId(UuidUtils.generateUUID());
        hospitalHealthAlliance.setType(superHospitalHealthAllianceDto.getType());
        hospitalHealthAlliance.setAllianceType(superHospitalHealthAllianceDto.getAllianceType());
        hospitalHealthAlliance.setHospitalId(superHospitalHealthAllianceDto.getHospitalId());
        hospitalHealthAlliance.setHospitalLevel(superHospitalHealthAllianceDto.getHospitalLevel());
        hospitalHealthAlliance.setYltName(superHospitalHealthAllianceDto.getHospitalName());
        hospitalHealthAlliance.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
        hospitalHealthAlliance.setAppCode(appCode);
        int i = this.healthAllianceService.insertHospitalHealthAllianceEntity(hospitalHealthAlliance);
        if (i > 0) {
            log.info("\u65b0\u5efa\u6210\u529f======");
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = new HospitalHealthAllianceMemberEntity();
            hospitalHealthAllianceMemberEntity.setViewId(hospitalHealthAlliance.getViewId());
            hospitalHealthAllianceMemberEntity.setAllianceUuid(hospitalHealthAlliance.getViewId());
            hospitalHealthAllianceMemberEntity.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            hospitalHealthAllianceMemberEntity.setHospitalId(superHospitalHealthAllianceDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setHospitalLevel(superHospitalHealthAllianceDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setRole(Integer.valueOf(1));
            hospitalHealthAllianceMemberEntity.setAppCode(appCode);
            int j = this.healthAllianceMemberService.insertHealthAllianceMember(hospitalHealthAllianceMemberEntity);
            if (j <= 0) {
                return this.returnFailure("\u6210\u5458\u8868\u6dfb\u52a0\u5931\u8d25");
            }
        } else {
            return this.returnFailure("\u65b0\u5efa\u5931\u8d25");
        }
        log.info("\u6210\u5458\u8868\u6dfb\u52a0\u6210\u529f======");
        List memberList = superHospitalHealthAllianceDto.getMemberList();
        for (SuperHospitaMemberlDto superHospitaMemberlDto : memberList) {
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMember = this.healthAllianceMemberService.queryHospitalHealthAllianceMember(hospitalHealthAlliance.getViewId(), superHospitaMemberlDto.getHospitalId(), HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            if (hospitalHealthAllianceMember != null) continue;
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = new HospitalHealthAllianceMemberEntity();
            hospitalHealthAllianceMemberEntity.setViewId(UuidUtils.generateUUID());
            hospitalHealthAllianceMemberEntity.setAllianceUuid(hospitalHealthAlliance.getViewId());
            hospitalHealthAllianceMemberEntity.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            hospitalHealthAllianceMemberEntity.setHospitalId(superHospitaMemberlDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setHospitalLevel(superHospitaMemberlDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setParentHosId(superHospitalHealthAllianceDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setParentHosLevel(superHospitalHealthAllianceDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setRole(Integer.valueOf(2));
            hospitalHealthAllianceMemberEntity.setAppCode(appCode);
            int j = this.healthAllianceMemberService.insertHealthAllianceMember(hospitalHealthAllianceMemberEntity);
            if (j > 0) {
                log.info("\u6210\u5458\u8868\u6dfb\u52a0\u6210\u529f======");
                continue;
            }
            return this.returnFailure("\u6210\u5458\u8868\u6dfb\u52a0\u5931\u8d25");
        }
        List healthHosId = superHospitalHealthAllianceDto.getMemberList().stream().map(e -> e.getHospitalId().toString()).collect(Collectors.toList());
        healthHosId.add(superHospitalHealthAllianceDto.getHospitalId().toString());
        HashMap<String, String> map = new HashMap<String, String>();
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + appCode + "/permissions/api/v1/dataScope/updateUserScopeOrgan";
        JSONArray jsonArray = new JSONArray(healthHosId);
        map.put("organIdList", jsonArray.toString());
        try {
            HttpClientUtils.simplePostInvoke((String)url, map);
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return this.returnSucceed((Object)hospitalHealthAlliance.getViewId(), "\u6210\u529f");
    }

    public ResultInfo deleteSuperHospitalHealthAllianceMember(String allianceUuid, Long hospitalId, Integer isLast) {
        int i;
        if (isLast == 1) {
            i = this.healthAllianceService.deleteHealthAlliance(allianceUuid, HealthAllianceEnum.DETELE.getValue());
            if (i > 0) {
                log.info("\u4e2d\u5fc3\u533b\u9662\u5220\u9664\u6210\u529f=============");
            } else {
                log.info("\u4e2d\u5fc3\u533b\u9662\u5220\u9664\u5931\u8d25=============");
            }
        }
        i = this.healthAllianceMemberService.updateHospitalHealthAllianceMemberByAllianceUuidAndHosId(allianceUuid, hospitalId, HealthAllianceEnum.DETELE.getValue(), isLast);
        Object entities = null;
        if (isLast == 1) {
            List list = this.healthAllianceMemberService.getByAllianceUuId(allianceUuid);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (HospitalHealthAllianceMemberEntity memberEntity : list) {
                    List healthAllianceMemberEntities = this.healthAllianceMemberService.getListHealthAllianceMemberByHospitalId(memberEntity.getHospitalId());
                    if (!CollectionUtils.isEmpty((Collection)healthAllianceMemberEntities)) continue;
                    int j = this.healthAllianceServiceService.updateStatusByHospitalId(Integer.valueOf(-1), memberEntity.getHospitalId());
                    log.info("=====\u5220\u9664\u533b\u9662id\u4e3a:" + memberEntity.getHospitalId() + "\u7684\u6708\u7ed3\u670d\u52a1\u6210\u529f====");
                }
            }
        } else {
            List healthAllianceMemberEntities = this.healthAllianceMemberService.getListHealthAllianceMemberByHospitalId(hospitalId);
            if (CollectionUtils.isEmpty((Collection)healthAllianceMemberEntities)) {
                int j = this.healthAllianceServiceService.updateStatusByHospitalId(Integer.valueOf(-1), hospitalId);
                log.info("=====\u5220\u9664\u533b\u9662id\u4e3a:" + hospitalId + "\u7684\u6708\u7ed3\u670d\u52a1\u6210\u529f====");
            }
        }
        HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.getHospitalHealthAllianceByViewId1(allianceUuid);
        String appCode = hospitalHealthAllianceEntity.getAppCode();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(-1);
        statusList.add(-2);
        List healthHosId = this.healthAllianceMemberService.getHosIdListByAllianceAndStatus(allianceUuid, statusList);
        HashMap<String, String> map = new HashMap<String, String>();
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + appCode + "/permissions/api/v1/dataScope/updateUserScopeOrganDel";
        JSONArray jsonArray = new JSONArray((Collection)healthHosId);
        map.put("healthIdList", jsonArray.toString());
        try {
            HttpClientUtils.simplePostInvoke((String)url, map);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.returnSucceed("\u6210\u5458\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> querySuperHospitalHealthAlliance(String search, Integer type, Integer status, Integer pageIndex, Integer pageSize) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List hospitalHealthAllianceEntityList = this.healthAllianceService.queryHospitalHealthAlliance(search, type, status);
        if (hospitalHealthAllianceEntityList == null) {
            return this.returnFailure("\u7a7a\u7a7a\u5982\u4e5f");
        }
        int total = this.healthAllianceService.queryHospitalHealthAlliance(search, type, status).size();
        ArrayList<SuperHospitalHealthAllianceVo> list = new ArrayList<SuperHospitalHealthAllianceVo>();
        for (HospitalHealthAllianceEntity hospitalHealthAllianceEntity : hospitalHealthAllianceEntityList) {
            BaseResponse doctorNumberVOBaseResponse;
            SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
            superHospitalHealthAllianceVo.setId(hospitalHealthAllianceEntity.getId());
            superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceEntity.getHospitalId());
            superHospitalHealthAllianceVo.setYltName(hospitalHealthAllianceEntity.getYltName());
            superHospitalHealthAllianceVo.setAllianceType(hospitalHealthAllianceEntity.getAllianceType());
            superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceEntity.getStatus());
            superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceEntity.getViewId());
            superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceEntity.getHospitalLevel());
            QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
            queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalHealthAllianceEntity.getHospitalId().intValue()));
            BaseResponse queryOrganDetailVOBaseResponse = this.iOrganizationApiClient.queryOrganDetail(queryOrganDetailDTO);
            if (!queryOrganDetailVOBaseResponse.getCode().equals("1")) {
                return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef:" + queryOrganDetailVOBaseResponse.getMsg());
            }
            QueryOrganDetailVO hospitalInfoEntity = (QueryOrganDetailVO)queryOrganDetailVOBaseResponse.getData();
            if (hospitalInfoEntity != null) {
                superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getOrganName());
                superHospitalHealthAllianceVo.setOrganCategory(hospitalInfoEntity.getOrganCategory());
                superHospitalHealthAllianceVo.setCategoryName(hospitalInfoEntity.getCategoryName());
            }
            if (!(doctorNumberVOBaseResponse = this.iOrganizationApiClient.queryDoctorNum(queryOrganDetailDTO)).getCode().equals("1")) {
                return this.returnFailure("\u533b\u751f\u670d\u52a1\u51fa\u9519:" + doctorNumberVOBaseResponse.getMsg());
            }
            Integer doctorNumber = ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getDoctorNum() + ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getFamousDoctorNum();
            superHospitalHealthAllianceVo.setDoctorNum(doctorNumber);
            List hospitalHealthAllianceMemberEntityList = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(hospitalHealthAllianceEntity.getViewId(), hospitalHealthAllianceEntity.getHospitalId());
            if (hospitalHealthAllianceMemberEntityList == null) {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(0));
            } else {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(hospitalHealthAllianceMemberEntityList.size()));
            }
            superHospitalHealthAllianceVo.setTotal(Integer.valueOf(total));
            list.add(superHospitalHealthAllianceVo);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> querySuperHospitalHealthAllianceDetail(String allianceUuid, Integer pageIndex, Integer pageSize) {
        HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.getHospitalHealthAllianceByViewId1(allianceUuid);
        if (hospitalHealthAllianceEntity == null) {
            return this.returnFailure("\u8be5\u533b\u8054\u4f53\u672a\u7533\u8bf7\u533b\u8054\u4f53");
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List hospitalHealthAllianceMemberEntityList = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(allianceUuid, hospitalHealthAllianceEntity.getHospitalId());
        ArrayList<SuperHospitalHealthAllianceVo> list = new ArrayList<SuperHospitalHealthAllianceVo>();
        for (HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity : hospitalHealthAllianceMemberEntityList) {
            BaseResponse doctorNumberVOBaseResponse;
            if (hospitalHealthAllianceEntity.getHospitalId().intValue() == hospitalHealthAllianceMemberEntity.getHospitalId().intValue()) {
                log.info("\u4e2d\u5fc3\u533b\u9662");
                continue;
            }
            SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
            superHospitalHealthAllianceVo.setId(hospitalHealthAllianceMemberEntity.getId());
            superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceMemberEntity.getHospitalId());
            superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceMemberEntity.getStatus());
            superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceMemberEntity.getHospitalLevel());
            superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceMemberEntity.getViewId());
            if (hospitalHealthAllianceEntity.getStatus() == 1) {
                superHospitalHealthAllianceVo.setTotal(Integer.valueOf(this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(allianceUuid, hospitalHealthAllianceEntity.getHospitalId()).size()));
            } else {
                superHospitalHealthAllianceVo.setTotal(Integer.valueOf(this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid1(allianceUuid, hospitalHealthAllianceEntity.getHospitalId()).size()));
            }
            QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
            queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalHealthAllianceMemberEntity.getHospitalId().intValue()));
            BaseResponse queryOrganDetailVOBaseResponse = this.iOrganizationApiClient.queryOrganDetail(queryOrganDetailDTO);
            if (!queryOrganDetailVOBaseResponse.getCode().equals("1")) {
                return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef:" + queryOrganDetailVOBaseResponse.getMsg());
            }
            QueryOrganDetailVO hospitalInfoEntity = (QueryOrganDetailVO)queryOrganDetailVOBaseResponse.getData();
            if (hospitalInfoEntity != null) {
                superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getOrganName());
                superHospitalHealthAllianceVo.setOrganCategory(hospitalInfoEntity.getOrganCategory());
                superHospitalHealthAllianceVo.setCategoryName(hospitalInfoEntity.getCategoryName());
            }
            if (!(doctorNumberVOBaseResponse = this.iOrganizationApiClient.queryDoctorNum(queryOrganDetailDTO)).getCode().equals("1")) {
                return this.returnFailure("\u533b\u751f\u670d\u52a1\u51fa\u9519:" + doctorNumberVOBaseResponse.getMsg());
            }
            Integer doctorNumber = ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getDoctorNum() + ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getFamousDoctorNum();
            superHospitalHealthAllianceVo.setDoctorNum(doctorNumber);
            list.add(superHospitalHealthAllianceVo);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<SuperHospitalHealthAllianceVo> querySuperHospitalDetail(Long hospitalId, String allianceUuid) {
        HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.queryHospitalHealthAllianceByHosIdAndAllianceUuid(hospitalId, allianceUuid);
        if (hospitalHealthAllianceEntity == null) {
            log.info("\u8be5\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53\u5185===========" + hospitalId);
            return this.returnFailure("\u8be5\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53\u5185" + hospitalId);
        }
        SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
        superHospitalHealthAllianceVo.setId(hospitalHealthAllianceEntity.getId());
        superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceEntity.getHospitalId());
        superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceEntity.getStatus());
        superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceEntity.getHospitalLevel());
        superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceEntity.getViewId());
        superHospitalHealthAllianceVo.setAllianceType(hospitalHealthAllianceEntity.getAllianceType());
        int size = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(hospitalHealthAllianceEntity.getViewId(), hospitalId).size();
        superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(size));
        QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
        queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalHealthAllianceEntity.getHospitalId().intValue()));
        BaseResponse queryOrganDetailVOBaseResponse = this.iOrganizationApiClient.queryOrganDetail(queryOrganDetailDTO);
        if (!queryOrganDetailVOBaseResponse.getCode().equals("1")) {
            return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef:" + queryOrganDetailVOBaseResponse.getMsg());
        }
        QueryOrganDetailVO hospitalInfoEntity = (QueryOrganDetailVO)queryOrganDetailVOBaseResponse.getData();
        superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getOrganName());
        superHospitalHealthAllianceVo.setOrganCategory(hospitalInfoEntity.getOrganCategory());
        superHospitalHealthAllianceVo.setCategoryName(hospitalInfoEntity.getCategoryName());
        BaseResponse doctorNumberVOBaseResponse = this.iOrganizationApiClient.queryDoctorNum(queryOrganDetailDTO);
        if (!doctorNumberVOBaseResponse.getCode().equals("1")) {
            return this.returnFailure("\u533b\u751f\u670d\u52a1\u51fa\u9519:" + doctorNumberVOBaseResponse.getMsg());
        }
        Integer doctorNumber = ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getDoctorNum() + ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getFamousDoctorNum();
        superHospitalHealthAllianceVo.setDoctorNum(doctorNumber);
        return this.returnSucceed((Object)superHospitalHealthAllianceVo, "\u6210\u529f");
    }

    public ResultInfo getHealthAllianceType() {
        ArrayList list = new ArrayList();
        for (HealthAllianceTypeEnum e : HealthAllianceTypeEnum.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", e.getValue());
            map.put("typeName", e.getDisplay());
            if (e.getValue() == 0) continue;
            list.add(map);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<HospitalHealthAllianceMemberEntity>> getIsHealthalliance(Long hospitalId) {
        List healthAllianceMemberEntityList = this.healthAllianceMemberService.getListHealthAllianceMemberByHospitalId(hospitalId);
        if (healthAllianceMemberEntityList == null || healthAllianceMemberEntityList.size() < 1) {
            return this.returnSucceed((Object)healthAllianceMemberEntityList, "\u4e0d\u5728\u533b\u8054\u4f53\u5185");
        }
        return this.returnSucceed((Object)healthAllianceMemberEntityList, "\u5728\u533b\u8054\u4f53\u5185");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<List<SuperHospitalHealthAllianceVo>> getHealthAllianceByHosId(Long hospitalId, Integer pageIndex, Integer pageSize, String search, Integer type, Integer status, String appCode, String userId) {
        List healthAllianceMemberEntityList = this.healthAllianceMemberService.getListHealthAllianceMemberByHospitalIdAndAppCode(hospitalId, appCode);
        if (healthAllianceMemberEntityList == null || healthAllianceMemberEntityList.size() == 0) {
            return this.returnFailure("\u6682\u65e0\u533b\u8054\u4f53");
        }
        healthAllianceMemberEntityList = healthAllianceMemberEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HospitalHealthAllianceMemberEntity>(Comparator.comparing(HospitalHealthAllianceMemberEntity::getAllianceUuid))), ArrayList::new));
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List hospitalHealthAllianceEntityList = this.healthAllianceService.queryHospitalHealthAllianceByAlliance(healthAllianceMemberEntityList, search, type, status);
        if (hospitalHealthAllianceEntityList == null || hospitalHealthAllianceEntityList.size() == 0) {
            return this.returnSucceed("\u7a7a\u7a7a\u5982\u4e5f");
        }
        int total = this.healthAllianceService.getCountHospitalHealthAlliance1(healthAllianceMemberEntityList, search, type, status);
        ArrayList<SuperHospitalHealthAllianceVo> list = new ArrayList<SuperHospitalHealthAllianceVo>();
        for (HospitalHealthAllianceEntity hospitalHealthAllianceEntity : hospitalHealthAllianceEntityList) {
            BaseResponse doctorNumberVOBaseResponse;
            SuperHospitalHealthAllianceVo superHospitalHealthAllianceVo = new SuperHospitalHealthAllianceVo();
            superHospitalHealthAllianceVo.setId(hospitalHealthAllianceEntity.getId());
            superHospitalHealthAllianceVo.setHospitalId(hospitalHealthAllianceEntity.getHospitalId());
            superHospitalHealthAllianceVo.setYltName(hospitalHealthAllianceEntity.getYltName());
            superHospitalHealthAllianceVo.setAllianceType(hospitalHealthAllianceEntity.getAllianceType());
            superHospitalHealthAllianceVo.setStatus(hospitalHealthAllianceEntity.getStatus());
            superHospitalHealthAllianceVo.setViewId(hospitalHealthAllianceEntity.getViewId());
            superHospitalHealthAllianceVo.setHospitalLevel(hospitalHealthAllianceEntity.getHospitalLevel());
            QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
            queryOrganDetailDTO.setOrganId(Integer.valueOf(hospitalHealthAllianceEntity.getHospitalId().intValue()));
            BaseResponse queryOrganDetailVOBaseResponse = this.iOrganizationApiClient.queryOrganDetail(queryOrganDetailDTO);
            if (!queryOrganDetailVOBaseResponse.getCode().equals("1")) {
                return this.returnFailure("\u533b\u9662\u670d\u52a1\u9519\u8bef:" + queryOrganDetailVOBaseResponse.getMsg());
            }
            QueryOrganDetailVO hospitalInfoEntity = (QueryOrganDetailVO)queryOrganDetailVOBaseResponse.getData();
            if (hospitalInfoEntity != null) {
                superHospitalHealthAllianceVo.setHospitalName(hospitalInfoEntity.getOrganName());
                superHospitalHealthAllianceVo.setOrganCategory(hospitalInfoEntity.getOrganCategory());
                superHospitalHealthAllianceVo.setCategoryName(hospitalInfoEntity.getCategoryName());
            }
            if (!(doctorNumberVOBaseResponse = this.iOrganizationApiClient.queryDoctorNum(queryOrganDetailDTO)).getCode().equals("1")) {
                return this.returnFailure("\u533b\u751f\u670d\u52a1\u51fa\u9519:" + doctorNumberVOBaseResponse.getMsg());
            }
            Integer doctorNumber = ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getDoctorNum() + ((DoctorNumberVO)doctorNumberVOBaseResponse.getData()).getFamousDoctorNum();
            superHospitalHealthAllianceVo.setDoctorNum(doctorNumber);
            List hospitalHealthAllianceMemberEntityList = this.healthAllianceMemberService.getHealthAllianceMemberByAllianceUuid(hospitalHealthAllianceEntity.getViewId(), hospitalHealthAllianceEntity.getHospitalId());
            if (hospitalHealthAllianceMemberEntityList == null) {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(0));
            } else {
                superHospitalHealthAllianceVo.setHosNum(Integer.valueOf(hospitalHealthAllianceMemberEntityList.size()));
            }
            superHospitalHealthAllianceVo.setTotal(Integer.valueOf(total));
            list.add(superHospitalHealthAllianceVo);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo insertSuperHospitalHealthAllianceMember(SuperHospitalHealthAllianceUpdateDto superHospitalHealthAllianceUpdateDto) {
        String allianceUuid;
        Long hospitalId = superHospitalHealthAllianceUpdateDto.getHospitalId();
        HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.queryHospitalHealthAllianceByHosIdAndAllianceUuid(hospitalId, allianceUuid = superHospitalHealthAllianceUpdateDto.getAllianceUuid());
        if (hospitalHealthAllianceEntity == null) {
            log.info("\u8be5\u4e2d\u5fc3\u533b\u9662\u5df2\u7ecf\u4e0b\u7ebf\u6216\u8005\u88ab\u5220\u9664====================");
            return this.returnFailure("\u8be5\u4e2d\u5fc3\u533b\u9662\u5df2\u7ecf\u4e0b\u7ebf\u6216\u8005\u88ab\u5220\u9664");
        }
        List memberList = superHospitalHealthAllianceUpdateDto.getMemberList();
        for (SuperHospitaMemberlDto superHospitaMemberlDto : memberList) {
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMember = this.healthAllianceMemberService.queryHospitalHealthAllianceMember(allianceUuid, superHospitaMemberlDto.getHospitalId(), HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            if (hospitalHealthAllianceMember != null) continue;
            HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = new HospitalHealthAllianceMemberEntity();
            hospitalHealthAllianceMemberEntity.setViewId(UuidUtils.generateUUID());
            hospitalHealthAllianceMemberEntity.setAllianceUuid(allianceUuid);
            hospitalHealthAllianceMemberEntity.setStatus(HealthAllianceEnum.EXAMINATION_PASSED.getValue());
            hospitalHealthAllianceMemberEntity.setHospitalId(superHospitaMemberlDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setHospitalLevel(superHospitaMemberlDto.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setParentHosId(superHospitalHealthAllianceUpdateDto.getHospitalId());
            hospitalHealthAllianceMemberEntity.setParentHosLevel(hospitalHealthAllianceEntity.getHospitalLevel());
            hospitalHealthAllianceMemberEntity.setRole(Integer.valueOf(2));
            hospitalHealthAllianceMemberEntity.setAppCode(hospitalHealthAllianceEntity.getAppCode());
            int j = this.healthAllianceMemberService.insertHealthAllianceMember(hospitalHealthAllianceMemberEntity);
            if (j > 0) {
                log.info("\u6210\u5458\u8868\u6dfb\u52a0\u6210\u529f======");
                continue;
            }
            return this.returnFailure("\u6210\u5458\u8868\u6dfb\u52a0\u5931\u8d25");
        }
        ArrayList<String> allianceList = new ArrayList<String>();
        allianceList.add(superHospitalHealthAllianceUpdateDto.getAllianceUuid());
        String healthHosIds = this.healthAllianceMemberService.getHosIdByAllianceList(allianceList);
        List healthHosIdList = superHospitalHealthAllianceUpdateDto.getMemberList().stream().map(e -> e.getHospitalId().toString()).collect(Collectors.toList());
        healthHosIdList.addAll(Arrays.asList(healthHosIds.split(",")));
        HashMap<String, String> map = new HashMap<String, String>();
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + hospitalHealthAllianceEntity.getAppCode() + "/permissions/api/v1/dataScope/updateUserScopeOrgan";
        JSONArray jsonArray = new JSONArray(healthHosIdList);
        map.put("organIdList", jsonArray.toString());
        try {
            HttpClientUtils.simplePostInvoke((String)url, map);
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return this.returnSucceed("\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo isOnlineHealthAlliance(String allianceUuid, Integer status) {
        int i = this.healthAllianceService.updateHospitalHealthAllianceIsOnline(allianceUuid, status);
        if (i > 0) {
            int j = this.healthAllianceMemberService.updateHospitalHealthAllianceMemberIsOnline(allianceUuid, status);
            if (j > 0) {
                HospitalHealthAllianceEntity hospitalHealthAllianceEntity = this.healthAllianceService.getHospitalHealthAllianceByViewId1(allianceUuid);
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(-1);
                statusList.add(-2);
                List healthHosIds = this.healthAllianceMemberService.getHosIdListByAllianceAndStatus(allianceUuid, statusList);
                HashMap<String, String> map = new HashMap<String, String>();
                String url = this.remoteCallAddressConfig.getRemoteCallAddress() + hospitalHealthAllianceEntity.getAppCode() + "/permissions/api/v1/dataScope/updateUserScopeOrganDel";
                JSONArray jsonArray = new JSONArray((Collection)healthHosIds);
                map.put("healthIdList", jsonArray.toString());
                try {
                    HttpClientUtils.simplePostInvoke((String)url, map);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return this.returnSucceed("\u6210\u529f");
            }
            return this.returnFailure("\u5931\u8d25");
        }
        log.info("\u5931\u8d25:\u4e2d\u5fc3\u533b\u9662========");
        return this.returnFailure("\u5931\u8d25:\u4e2d\u5fc3\u533b\u9662");
    }

    public ResultInfo<Integer> queryHealthAllianceCount() {
        int count = this.healthAllianceService.queryHealthAllianceCount();
        return this.returnSucceed((Object)count, "\u83b7\u53d6\u533b\u8054\u4f53\u6570\u91cf\u6210\u529f");
    }

    public Boolean isExistYiChun(Long hosId) {
        String search = "\u5b9c\u6625\u5e02\u4eba\u6c11\u533b\u9662";
        String viewIdStr = this.healthAllianceService.getHosHealthAllianceByName(search);
        if (StringUtil.isEmpty((String)viewIdStr)) {
            return false;
        }
        String[] viewIdSplit = viewIdStr.split(",");
        List<String> viewIdList = Arrays.asList(viewIdSplit);
        List list = this.healthAllianceMemberService.isExistYiChun(hosId, viewIdList);
        if (list == null || list.size() == 0) {
            return false;
        }
        return true;
    }

    public String getAllianceUuidByHosIdList(List<String> hosIdList) {
        return this.healthAllianceMemberService.getAllianceUuidByHosIdList(hosIdList);
    }

    public String getHosIdByAllianceList(List<String> allianceList) {
        return this.healthAllianceMemberService.getHosIdByAllianceList(allianceList);
    }
}

