/*
 * Decompiled with CFR 0.152.
 */
package com.byh.remotecall.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.constants.URLConstant;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.IhospitalApiClient;
import com.byh.pojo.vo.consultation.req.PatientInfoReqVO;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.util.HttpUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PatientInfoRemoteImpl
implements PatientInfoRemote {
    private static final Logger log = LoggerFactory.getLogger(PatientInfoRemoteImpl.class);
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;

    public PatientInfoRespVO getPatientInfoById(Long id, Long hopitalId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(hopitalId.intValue()));
        String appCode = (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(appCode).append("/").append(URLConstant.PATIENT_INFO_URL).toString();
        PatientInfoReqVO patientInfoReqVO = new PatientInfoReqVO();
        patientInfoReqVO.setPatientId(id.toString());
        patientInfoReqVO.setAppCode(appCode);
        patientInfoReqVO.setHospitalId(hopitalId.toString());
        patientInfoReqVO.setChannelCode("PATIENT_IOS");
        PatientInfoRespVO patientInfoRespVO = new PatientInfoRespVO();
        try {
            String respData = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)patientInfoReqVO));
            log.info("\u4f7f\u7528HttpPost\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)respData);
            if (StringUtil.isNotEmpty((String)respData) && ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSONObject.parseObject((String)respData).getString("code")) && JSONObject.parseObject((String)respData).get((Object)"data") != null) {
                patientInfoRespVO = (PatientInfoRespVO)JSONObject.parseObject((String)JSONObject.parseObject((String)respData).getString("data"), PatientInfoRespVO.class);
                log.info("\u60a3\u8005\u4fe1\u606f\u662f:{},=======\u60a3\u8005\u59d3\u540d\u662f:{}", (Object)patientInfoRespVO.toString(), (Object)patientInfoRespVO.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("\u6839\u636e\u533b\u9662id:{},\u67e5\u5230\u7684\u60a3\u8005\u4fe1\u606f\u662f:{}", (Object)hopitalId, (Object)patientInfoRespVO.toString());
        return patientInfoRespVO;
    }
}

