/*
 * Decompiled with CFR 0.152.
 */
package com.byh.remotecall.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.constants.URLConstant;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.IhospitalApiClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.vo.consultation.req.DoctorIdReqVO;
import com.byh.pojo.vo.consultation.req.PatientIdReqVO;
import com.byh.pojo.vo.consultation.req.QueryPatientInfoListReqVO;
import com.byh.pojo.vo.consultation.req.UserCardReqVO;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.pojo.vo.consultation.res.QueryPatientInfoListRespVO;
import com.byh.pojo.vo.consultation.res.UserCardResVO;
import com.byh.pojo.vo.consultation.res.UserInfoRespVO;
import com.byh.remotecall.UserCenterRemote;
import com.byh.util.HttpUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class UserCenterRemoteImpl
implements UserCenterRemote {
    private static final Logger log = LoggerFactory.getLogger(UserCenterRemoteImpl.class);
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;

    public DoctorInfoRespVO getUserIdByDoctorId(Long doctorId) {
        Integer hospitalId = this.remoteManage.getDoctorDetailById(doctorId).getOrganId();
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(hospitalId);
        String code = (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(URLConstant.GET_DOCTOR_USERID_URL).toString();
        DoctorIdReqVO doctorIdReqVO = new DoctorIdReqVO();
        doctorIdReqVO.setDoctorId(doctorId.toString());
        doctorIdReqVO.setAppCode(code);
        doctorIdReqVO.setHospitalId(hospitalId.toString());
        doctorIdReqVO.setChannelCode("PATIENT_IOS");
        DoctorInfoRespVO doctorInfoRespVO = new DoctorInfoRespVO();
        String userDataRes = "";
        try {
            userDataRes = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)doctorIdReqVO));
            log.info("\u6839\u636edoctorId:{}\u4ece\u7528\u6237\u4e2d\u5fc3\u53d6\u5230\u7684\u4fe1\u606f\u662f:{}", (Object)doctorId, (Object)userDataRes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (StringUtil.isNotEmpty((String)userDataRes) && ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSONObject.parseObject((String)userDataRes).getString("code")) && JSONObject.parseObject((String)userDataRes).get((Object)"data") != null) {
            doctorInfoRespVO = (DoctorInfoRespVO)JSONObject.parseObject((String)JSONObject.parseObject((String)userDataRes).getString("data"), DoctorInfoRespVO.class);
            log.info("\u62ff\u5230\u7684\u7528\u6237userId\u662f:{}", (Object)doctorInfoRespVO.getUserId());
        }
        return doctorInfoRespVO;
    }

    public UserInfoRespVO getUserIdByPatientId(Long patientId, Long hospitalId) {
        UserInfoRespVO userInfoRespVO = null;
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(hospitalId.intValue()));
        String code = (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(code).append("/").append(URLConstant.GET_PATIENT_USERID_URL).toString();
        PatientIdReqVO patientIdReqVO = new PatientIdReqVO();
        patientIdReqVO.setPatientId(patientId.toString());
        patientIdReqVO.setAppCode(code);
        patientIdReqVO.setChannelCode("PATIENT_IOS");
        BaseResponse respVOBaseResponse = (BaseResponse)this.restTemplate.postForObject(url, (Object)patientIdReqVO, BaseResponse.class, new Object[0]);
        log.info("=====\u6839\u636e\u60a3\u8005id:{}=====\u966a\u8bca\u533b\u751fid:{}=====\u8c03\u53d6\u5230\u7684\u7528\u6237\u4fe1\u606fjson\u683c\u5f0f\u662f:{}", new Object[]{patientId, hospitalId, respVOBaseResponse.toString()});
        if (respVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && respVOBaseResponse.getData() != null) {
            String dataStr = JSON.toJSONString((Object)respVOBaseResponse.getData());
            userInfoRespVO = (UserInfoRespVO)JSON.parseObject((String)dataStr, UserInfoRespVO.class);
        }
        return userInfoRespVO;
    }

    public List<QueryPatientInfoListRespVO> getUserPatientInfoList(String appCode, Long userId) {
        QueryPatientInfoListReqVO queryPatientInfoListReqVO = new QueryPatientInfoListReqVO();
        queryPatientInfoListReqVO.setUserId(userId.toString());
        queryPatientInfoListReqVO.setAppCode(appCode);
        queryPatientInfoListReqVO.setChannelCode("PATIENT_IOS");
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + appCode + "/usercenter/user/patientinfolist";
        String dataStr = "";
        try {
            dataStr = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)queryPatientInfoListReqVO));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("====data:{}", (Object)dataStr);
        JSONObject jsonObject = JSONObject.parseObject((String)dataStr);
        List listRespVOS = JSONArray.parseArray((String)jsonObject.getString("data"), QueryPatientInfoListRespVO.class);
        return listRespVOS;
    }

    public List<UserCardResVO> getUserBindPatientList(String appCode, String userId) {
        UserCardReqVO userCardReqVO = new UserCardReqVO();
        userCardReqVO.setUserId(userId);
        userCardReqVO.setAppCode(appCode);
        userCardReqVO.setChannelCode("PATIENT_IOS");
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(appCode).append("/").append("usercenter/card/cardlist").toString();
        List userCardResVOS = null;
        try {
            log.info("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u5c31\u8bca\u5361\u7684url\u662f:{}=====\u5165\u53c2\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)userCardReqVO));
            String dataStr = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)userCardReqVO));
            log.info("\u5c31\u8bca\u5361\u670d\u52a1\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)dataStr);
            JSONObject jsonObject = JSONObject.parseObject((String)dataStr);
            if (StringUtil.isNotBlank((String)jsonObject.getString("data"))) {
                userCardResVOS = JSONArray.parseArray((String)jsonObject.getString("data"), UserCardResVO.class);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return userCardResVOS;
    }
}

