/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.chat.api.pojo.UserRongCloudAssociationEntity;
import com.byh.chat.api.vo.RongCloudOrderGroupVo;
import com.byh.chat.api.vo.RongCloudUserIdVo;
import com.byh.enums.OrderTypeEnum;
import com.byh.feign.IRongCloudGroupInfoClient;
import com.byh.feign.IRongUserClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements CommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private IRongUserClient iRongUserClient;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private IRongCloudGroupInfoClient iRongCloudGroupInfoClient;

    public Map<String, String> creatRongCloudGroup(Long orderId) {
        log.info("=================\u521b\u5efa\u7fa4\u7ec4=================");
        HashMap<String, String> map = new HashMap<String, String>();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
        if (consultationEntity == null) {
            log.error("\u8ba2\u5355\u4e0d\u5b58\u5728==========");
            map.put("msg", "\u8ba2\u5355\u4e0d\u5b58\u5728");
            return map;
        }
        RongCloudOrderGroupVo rongCloudOrderGroupVo = new RongCloudOrderGroupVo();
        rongCloudOrderGroupVo.setOrderUuid(consultationEntity.getViewId());
        Integer orderType = consultationEntity.getType();
        String orderTypeName = "";
        if (orderType.intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_VEDIO.getDisplay();
        } else if (orderType.intValue() == OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_TUWEN.getDisplay();
        }
        ArrayList<RongCloudUserIdVo> list = new ArrayList<RongCloudUserIdVo>();
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
        if (patientInfoRespVO != null || patientCaseInfoEntity != null) {
            JSONObject jsonObject = new JSONObject();
            String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
            jsonObject.put("pDiaName", (Object)pDiaName);
            Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
            jsonObject.put("pDiaSex", (Object)pDiaSex);
            String patientBir = patientInfoRespVO.getBirthdate();
            Long age = 0L;
            log.info("\u53d6\u5230\u7684\u60a3\u8005\u51fa\u751f\u5e74\u6708\u65e5\u662f:" + patientBir);
            if (StringUtil.isNotEmpty((String)patientBir)) {
                LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(patientInfoRespVO.getBirthdate()));
                LocalDate today = LocalDate.now();
                age = ChronoUnit.YEARS.between(birthday, today);
            }
            jsonObject.put("pDiaAge", (Object)age);
            jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
            String pDiaTimeChieCom = patientCaseInfoEntity.getMainSuit() == null ? "" : patientCaseInfoEntity.getMainSuit();
            jsonObject.put("pDiaTimeChieCom", (Object)pDiaTimeChieCom);
            String primaryDiagno = patientCaseInfoEntity.getPrimaryDiagno() == null ? "" : patientCaseInfoEntity.getPrimaryDiagno();
            jsonObject.put("pDiaDesc", (Object)primaryDiagno);
            log.info("\u7fa4\u7ec4\u60a3\u8005JSON======================" + jsonObject.toJSONString());
            rongCloudOrderGroupVo.setDiagMessage(jsonObject.toJSONString());
        }
        RongCloudUserIdVo expertRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId());
        UserRongCloudAssociationEntity expertRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getExpertId()).getData();
        if (expertRongCloudAssociationEntity != null) {
            expertRongCloudUserIdVo.setUserType(expertDetailInfoEntity.getDoctorType());
            expertRongCloudUserIdVo.setRongCloudId(expertRongCloudAssociationEntity.getRongCloudId());
            expertRongCloudUserIdVo.setUserId(expertDetailInfoEntity.getId().toString());
            expertRongCloudUserIdVo.setHeadImageUrl(expertDetailInfoEntity.getHeadPortrait());
            expertRongCloudUserIdVo.setUserName(expertDetailInfoEntity.getName());
        }
        list.add(expertRongCloudUserIdVo);
        RongCloudUserIdVo doctorRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        if (doctorDetailInfoEntity != null) {
            rongCloudOrderGroupVo.setLoginUserId(doctorDetailInfoEntity.getId().toString());
            rongCloudOrderGroupVo.setLoginUserType(doctorDetailInfoEntity.getDoctorType());
            UserRongCloudAssociationEntity doctorRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getDoctorId()).getData();
            log.info("=====\u53d6\u5230\u5ba1\u6838\u7684\u878d\u4e91id====doctorRongCloudId\uff1a" + doctorRongCloudAssociationEntity.getRongCloudId());
            rongCloudOrderGroupVo.setRongLoginUserId(doctorRongCloudAssociationEntity.getRongCloudId());
            String name = doctorDetailInfoEntity.getName() + "\u548c" + expertDetailInfoEntity.getName() + "\u7684" + orderTypeName + "\u4f1a\u8bca\u5ba4";
            if (name.length() > 15) {
                name = name.substring(0, 15);
            }
            rongCloudOrderGroupVo.setName(name);
            rongCloudOrderGroupVo.setInviteMessage(doctorDetailInfoEntity.getName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
            doctorRongCloudUserIdVo.setUserId(doctorDetailInfoEntity.getId().toString());
            doctorRongCloudUserIdVo.setHeadImageUrl(doctorDetailInfoEntity.getHeadPortrait());
            doctorRongCloudUserIdVo.setUserType(doctorDetailInfoEntity.getDoctorType());
            doctorRongCloudUserIdVo.setRongCloudId(doctorRongCloudAssociationEntity.getRongCloudId());
            doctorRongCloudUserIdVo.setUserName(doctorDetailInfoEntity.getName());
        }
        list.add(doctorRongCloudUserIdVo);
        rongCloudOrderGroupVo.setRongCloudUserIdVoList(list);
        log.info("\u521b\u5efa\u65f6\u4f20\u5165\u7684\u503c\u662f:" + rongCloudOrderGroupVo.toString());
        BaseResponse baseResponse = this.iRongCloudGroupInfoClient.createOrderGroup(rongCloudOrderGroupVo);
        if (baseResponse == null || !baseResponse.getCode().equals("1")) {
            log.error("\u878d\u4e91\u670d\u52a1\u9519\u8bef,\u8ba2\u5355id:" + orderId + "\u9519\u8bef\u4fe1\u606f:" + baseResponse.getMsg());
            return map;
        }
        String groupId = (String)baseResponse.getData();
        int i = this.consultationService.saveConsultationGroupIdByOrderId(orderId, groupId);
        if (i > 0) {
            log.info("\u4fdd\u5b58groupId\u6210\u529f=========");
            map.put("groupId", groupId);
            map.put("msg", "success");
            return map;
        }
        log.error("\u4fdd\u5b58groupId\u5931\u8d25=========\u8ba2\u5355id:" + orderId);
        map.put("msg", "\u8ba2\u5355\u670d\u52a1\u9519\u8bef:\u4fdd\u5b58groupId\u5931\u8d25,\u8ba2\u5355id" + orderId);
        return map;
    }

    public Map<String, String> creatRongCloudGroupTwo(ConsultationEntity consultationEntity, PatientCaseInfoVO patientCaseInfoVO) {
        log.info("=================\u521b\u5efa\u7fa4\u7ec4=================");
        HashMap<String, String> map = new HashMap<String, String>();
        if (consultationEntity == null) {
            log.error("\u8ba2\u5355\u4e0d\u5b58\u5728==========");
            map.put("msg", "\u8ba2\u5355\u4e0d\u5b58\u5728");
            return map;
        }
        RongCloudOrderGroupVo rongCloudOrderGroupVo = new RongCloudOrderGroupVo();
        rongCloudOrderGroupVo.setOrderUuid(consultationEntity.getViewId());
        Integer orderType = consultationEntity.getType();
        String orderTypeName = "";
        if (orderType.intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_VEDIO.getDisplay();
        } else if (orderType.intValue() == OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_TUWEN.getDisplay();
        }
        ArrayList<RongCloudUserIdVo> list = new ArrayList<RongCloudUserIdVo>();
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
        if (patientInfoRespVO != null || patientCaseInfoEntity != null) {
            JSONObject jsonObject = new JSONObject();
            String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
            jsonObject.put("pDiaName", (Object)pDiaName);
            Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
            jsonObject.put("pDiaSex", (Object)pDiaSex);
            String patientBir = patientInfoRespVO.getBirthdate();
            Long age = 0L;
            log.info("\u53d6\u5230\u7684\u60a3\u8005\u51fa\u751f\u5e74\u6708\u65e5\u662f:" + patientBir);
            if (StringUtil.isNotEmpty((String)patientBir)) {
                LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(patientInfoRespVO.getBirthdate()));
                LocalDate today = LocalDate.now();
                age = ChronoUnit.YEARS.between(birthday, today);
            }
            jsonObject.put("pDiaAge", (Object)age);
            jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
            String pDiaTimeChieCom = patientCaseInfoEntity.getMainSuit() == null ? "" : patientCaseInfoEntity.getMainSuit();
            jsonObject.put("pDiaTimeChieCom", (Object)pDiaTimeChieCom);
            String primaryDiagno = patientCaseInfoEntity.getPrimaryDiagno() == null ? "" : patientCaseInfoEntity.getPrimaryDiagno();
            jsonObject.put("pDiaDesc", (Object)primaryDiagno);
            log.info("\u7fa4\u7ec4\u60a3\u8005JSON======================" + jsonObject.toJSONString());
            rongCloudOrderGroupVo.setDiagMessage(jsonObject.toJSONString());
        }
        RongCloudUserIdVo expertRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId());
        UserRongCloudAssociationEntity expertRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getExpertId()).getData();
        if (expertRongCloudAssociationEntity != null) {
            expertRongCloudUserIdVo.setUserType(expertDetailInfoEntity.getDoctorType());
            expertRongCloudUserIdVo.setRongCloudId(expertRongCloudAssociationEntity.getRongCloudId());
            expertRongCloudUserIdVo.setUserId(expertDetailInfoEntity.getId().toString());
            expertRongCloudUserIdVo.setHeadImageUrl(expertDetailInfoEntity.getHeadPortrait());
            expertRongCloudUserIdVo.setUserName(expertDetailInfoEntity.getName());
        }
        list.add(expertRongCloudUserIdVo);
        RongCloudUserIdVo doctorRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        if (doctorDetailInfoEntity != null) {
            rongCloudOrderGroupVo.setLoginUserId(doctorDetailInfoEntity.getId().toString());
            rongCloudOrderGroupVo.setLoginUserType(doctorDetailInfoEntity.getDoctorType());
            UserRongCloudAssociationEntity doctorRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getDoctorId()).getData();
            rongCloudOrderGroupVo.setRongLoginUserId(doctorRongCloudAssociationEntity.getRongCloudId());
            String name = doctorDetailInfoEntity.getName() + "\u548c" + expertDetailInfoEntity.getName() + "\u7684" + orderTypeName + "\u4f1a\u8bca\u5ba4";
            if (name.length() > 15) {
                name = name.substring(0, 15);
            }
            rongCloudOrderGroupVo.setName(name);
            rongCloudOrderGroupVo.setInviteMessage(doctorDetailInfoEntity.getName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
            doctorRongCloudUserIdVo.setUserId(doctorDetailInfoEntity.getId().toString());
            doctorRongCloudUserIdVo.setHeadImageUrl(doctorDetailInfoEntity.getHeadPortrait());
            doctorRongCloudUserIdVo.setUserType(doctorDetailInfoEntity.getDoctorType());
            doctorRongCloudUserIdVo.setRongCloudId(doctorRongCloudAssociationEntity.getRongCloudId());
            doctorRongCloudUserIdVo.setUserName(doctorDetailInfoEntity.getName());
        }
        list.add(doctorRongCloudUserIdVo);
        rongCloudOrderGroupVo.setRongCloudUserIdVoList(list);
        BaseResponse baseResponse = this.iRongCloudGroupInfoClient.createOrderGroup(rongCloudOrderGroupVo);
        if (baseResponse == null || !baseResponse.getCode().equals("1")) {
            log.error("\u878d\u4e91\u670d\u52a1\u9519\u8bef,\u8ba2\u5355id:" + consultationEntity.getId() + "\u9519\u8bef\u4fe1\u606f:" + baseResponse.getMsg());
            return map;
        }
        String groupId = (String)baseResponse.getData();
        int i = this.consultationService.saveConsultationGroupIdByOrderId(consultationEntity.getId(), groupId);
        if (i > 0) {
            log.info("\u4fdd\u5b58groupId\u6210\u529f=========");
            map.put("msg", "success");
            return map;
        }
        log.error("\u4fdd\u5b58groupId\u5931\u8d25=========\u8ba2\u5355id:" + consultationEntity.getId());
        map.put("msg", "\u8ba2\u5355\u670d\u52a1\u9519\u8bef:\u4fdd\u5b58groupId\u5931\u8d25,\u8ba2\u5355id" + consultationEntity.getId());
        return map;
    }
}

