/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.consultation;

import com.byh.common.PageResult;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.dao.consultation.DoctorBillInfoEntityMapper;
import com.byh.enums.BillBusinessTypeEnum;
import com.byh.enums.BillTypeEnum;
import com.byh.enums.UserTypeEnum;
import com.byh.exception.PushInfoException;
import com.byh.feign.IDoctorApiClient;
import com.byh.feign.IOrganizationApiClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.vo.consultation.BillListQuery;
import com.byh.pojo.vo.consultation.BillListVo;
import com.byh.pojo.vo.consultation.DoctorBillHxgyVo;
import com.byh.pojo.vo.consultation.DoctorBillVo;
import com.byh.pojo.vo.consultation.ExcelData;
import com.byh.pojo.vo.consultation.NewTransferVo;
import com.byh.pojo.vo.consultation.excel.BillDataInfoVO;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.ConsultationMerchantConfigService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.DoctorBillInfoService;
import com.byh.util.PushInfoManagerUtils;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.dto.doctor.DoctorSearchDTO;
import com.doctoruser.api.pojo.dto.doctor.FuzzyQueryDoctorDTO;
import com.doctoruser.api.pojo.dto.doctor.UpdateBalanceDTO;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class DoctorBillInfoServiceImpl
implements DoctorBillInfoService {
    private static final Logger log = LoggerFactory.getLogger(DoctorBillInfoServiceImpl.class);
    private static final Integer bill_invalid = -99;
    private static final int STATUS_INVALID = -1;
    private static final int STATUS_VALID = 1;
    @Autowired
    private DoctorBillInfoEntityMapper doctorBillInfoEntityMapper;
    @Autowired
    private IDoctorApiClient doctorApiClient;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private IOrganizationApiClient organizationApiClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private ConsultationMerchantConfigService consultationMerchantConfigService;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private RemoteManage remoteManage;

    public int saveDoctorBillInfo(DoctorBillInfoEntity doctorBillInfo) {
        int i = this.doctorBillInfoEntityMapper.insertSelective(doctorBillInfo);
        return i;
    }

    public DoctorBillInfoEntity getDoctorBillInfo(Long id) {
        DoctorBillInfoEntity doctorBillInfo = this.doctorBillInfoEntityMapper.selectByPrimaryKey(id);
        return doctorBillInfo;
    }

    public int updateDoctorBillInfo(DoctorBillInfoEntity doctorBillInfo) {
        int i = this.doctorBillInfoEntityMapper.updateByPrimaryKeySelective(doctorBillInfo);
        return i;
    }

    public int deleteDoctorBillInfo(Long id) {
        DoctorBillInfoEntity doctorBillInfo = new DoctorBillInfoEntity();
        doctorBillInfo.setId(id);
        doctorBillInfo.setStatus(-1);
        int i = this.doctorBillInfoEntityMapper.updateByPrimaryKeySelective(doctorBillInfo);
        return i;
    }

    @Transactional
    public DoctorBillInfoEntity addOne(DoctorBillVo doctorBillVo) {
        int addFlag;
        int billCount = this.doctorBillInfoEntityMapper.countByDoctorIdAndBusinessId(doctorBillVo.getBusinessId(), doctorBillVo.getDoctorId());
        if (billCount > 0) {
            log.error("=====\u7531\u4e8e\u591a\u6b21\u4fee\u6539\u4fdd\u5b58\u4f1a\u8bca\u62a5\u544a,\u8d26\u5355\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u6dfb\u52a0\uff01=====");
            return new DoctorBillInfoEntity();
        }
        DoctorEntityInfoVO doctorEntityInfoVO = this.getDoctorInfo(doctorBillVo.getDoctorId());
        if (doctorEntityInfoVO.getBalance() == null) {
            doctorEntityInfoVO.setBalance(BigDecimal.ZERO);
        }
        DoctorBillInfoEntity result = new DoctorBillInfoEntity();
        result.setUuid(UuidUtils.generateUUID());
        result.setDoctorId(doctorBillVo.getDoctorId());
        result.setSource(doctorBillVo.getSource());
        result.setType(doctorBillVo.getType().intValue());
        result.setSponsor(doctorBillVo.getSponsor());
        result.setOriginalMoney(doctorBillVo.getOriginalMoney());
        BigDecimal subsidyMoney = doctorBillVo.getSubsidyMoney() == null ? BigDecimal.ZERO : doctorBillVo.getSubsidyMoney();
        result.setSubsidyMoney(subsidyMoney);
        result.setTaxationMoney(BigDecimal.ZERO);
        if (doctorBillVo.getBusinessType() == BillBusinessTypeEnum.WITHDRAW.getValue().intValue()) {
            result.setPreAccount(doctorEntityInfoVO.getBalance().add(doctorBillVo.getOriginalMoney()));
        } else {
            result.setPreAccount(doctorEntityInfoVO.getBalance());
        }
        if (result.getType() == BillTypeEnum.INCOME.getValue().intValue() || result.getType() == BillTypeEnum.COMMISSION.getValue().intValue()) {
            result.setAuditMoney(result.getOriginalMoney().add(result.getSubsidyMoney()).subtract(result.getTaxationMoney()));
        } else if (result.getType() == BillTypeEnum.EXPEND.getValue().intValue()) {
            result.setAuditMoney(result.getOriginalMoney().add(result.getTaxationMoney()));
            result.setCurAccount(result.getPreAccount().subtract(result.getAuditMoney()));
        }
        result.setRemark(doctorBillVo.getRemark());
        result.setBusinessId(doctorBillVo.getBusinessId());
        result.setBusinessType(doctorBillVo.getBusinessType());
        if (doctorBillVo.getBillStatus() == 1) {
            result.setStatus(1);
        } else if (doctorBillVo.getBillStatus() == -1) {
            result.setStatus(-1);
        }
        if (doctorBillVo.getBusinessType() == BillBusinessTypeEnum.WITHDRAW.getValue().intValue()) {
            result.setActualMoney(result.getAuditMoney());
        }
        if ((addFlag = this.doctorBillInfoEntityMapper.insertSelective(result)) > 0) {
            return result;
        }
        return null;
    }

    private DoctorEntityInfoVO getDoctorInfo(Long doctorId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(doctorId.intValue()));
        BaseResponse doctorEntityInfoVOBaseResponse = this.doctorApiClient.endQueryDoctorDetailInfo(baseDTO);
        DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
        return doctorEntityInfoVO;
    }

    public PageResult<List<BillListVo>> getListByCondition(BillListQuery billListQuery) {
        String searchText;
        if (billListQuery.getPageNum() == null || billListQuery.getPageSize() == null) {
            billListQuery.setPageNum(Integer.valueOf(1));
            billListQuery.setPageSize(Integer.valueOf(10));
        }
        PageHelper.startPage((int)billListQuery.getPageNum(), (int)billListQuery.getPageSize());
        PageResult result = new PageResult();
        Page voList = new Page();
        String doctorIds = "";
        if (StringUtils.isNotBlank((CharSequence)billListQuery.getDoctorName())) {
            FuzzyQueryDoctorDTO fuzzyQueryDoctorDTO = new FuzzyQueryDoctorDTO();
            fuzzyQueryDoctorDTO.setDoctorId(Integer.valueOf(0));
            fuzzyQueryDoctorDTO.setSearchParam(billListQuery.getDoctorName());
            BaseResponse baseResponse = this.doctorApiClient.queryDoctorListByNameOrTelphone(fuzzyQueryDoctorDTO);
            List listDoctorVOS = (List)baseResponse.getData();
            if (listDoctorVOS == null || listDoctorVOS.isEmpty()) {
                return result;
            }
            List doctorIdList = listDoctorVOS.stream().map(listDoctorVo -> listDoctorVo.getDoctorId().toString()).collect(Collectors.toList());
            doctorIds = String.join((CharSequence)",", doctorIdList);
            billListQuery.setDoctorIds(doctorIds);
        }
        if (StringUtils.isNotBlank((CharSequence)(searchText = billListQuery.getSearchText()))) {
            if (searchText.length() >= 16) {
                log.info("=====================\u8ba2\u5355viewId\u641c\u7d22========================");
                billListQuery.setSearchText("");
                billListQuery.setBusinessId(searchText);
            }
            if (searchText.length() < 16) {
                log.info("=====================\u641c\u7d22========================");
                billListQuery.setBusinessId(searchText);
                DoctorSearchDTO doctorSearchDTO = new DoctorSearchDTO();
                doctorSearchDTO.setSearchParam(searchText);
                doctorSearchDTO.setType(Integer.valueOf(2));
                BaseResponse doctorIdListResponse = this.doctorApiClient.endQueryDoctorInfo(doctorSearchDTO);
                List doctorIdListFromSearchText = (List)doctorIdListResponse.getData();
                String doctorIdsFromSearchText = "";
                if (doctorIdListFromSearchText != null && !doctorIdListFromSearchText.isEmpty()) {
                    List doctorIdStrListFromSearchText = doctorIdListFromSearchText.stream().map(id -> id.toString()).collect(Collectors.toList());
                    doctorIdsFromSearchText = String.join((CharSequence)",", doctorIdStrListFromSearchText);
                    log.info("=====================doctorIdsFromSearchText{}", (Object)doctorIdsFromSearchText);
                    billListQuery.setSearchText(doctorIdsFromSearchText);
                } else {
                    billListQuery.setSearchText("0");
                }
            }
        }
        log.info("billListQuery: [{}]", (Object)billListQuery.toString());
        Page entityPage = this.doctorBillInfoEntityMapper.selectByCondition(billListQuery);
        for (DoctorBillInfoEntity entity : entityPage) {
            BillListVo vo = new BillListVo();
            vo.setDoctorBillInfoEntity(entity);
            DoctorEntityInfoVO doctorEntityInfoVO = this.getDoctorInfo(entity.getDoctorId());
            vo.setBalance(doctorEntityInfoVO.getBalance());
            vo.setDoctorName(doctorEntityInfoVO.getName());
            QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
            queryOrganDetailDTO.setOrganId(doctorEntityInfoVO.getOrganId());
            BaseResponse organDetailVOBaseResponse = this.organizationApiClient.queryOrganDetail(queryOrganDetailDTO);
            QueryOrganDetailVO organDetailVO = (QueryOrganDetailVO)organDetailVOBaseResponse.getData();
            vo.setHospitalName(organDetailVO.getOrganName());
            vo.setStandardDept(doctorEntityInfoVO.getStdFirstDeptName());
            vo.setTelephone(doctorEntityInfoVO.getContactMobile());
            vo.setUserType(doctorEntityInfoVO.getDoctorType());
            String orderViewId = entity.getBusinessId();
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            if (consultationEntity != null) {
                vo.setPatientName(consultationEntity.getPatientName());
            }
            voList.add((Object)vo);
        }
        if (entityPage != null && entityPage.size() == 2 && ((BillListVo)voList.get(1)).getDoctorBillInfoEntity().getBusinessType() > ((BillListVo)voList.get(0)).getDoctorBillInfoEntity().getBusinessType()) {
            Collections.reverse(voList);
        }
        result.setTotal(entityPage.getTotal());
        result.setPages(entityPage.getPages());
        result.setPageNum(billListQuery.getPageNum().intValue());
        result.setPageSize(billListQuery.getPageSize().intValue());
        result.setPageData((Object)voList);
        return result;
    }

    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public int updateStatus(Long billId, BigDecimal actualMoney, String auditor) {
        DoctorBillInfoEntity billInfoEntity = this.doctorBillInfoEntityMapper.selectByPrimaryKey(billId);
        DoctorEntityInfoVO doctorEntityInfoVO = this.getDoctorInfo(billInfoEntity.getDoctorId());
        if (billInfoEntity == null || doctorEntityInfoVO == null) {
            return 0;
        }
        billInfoEntity.setStatus(1);
        billInfoEntity.setRemark(auditor);
        billInfoEntity.setActualMoney(actualMoney);
        billInfoEntity.setPreAccount(doctorEntityInfoVO.getBalance());
        if (billInfoEntity.getPreAccount() == null) {
            billInfoEntity.setCurAccount(actualMoney);
        } else {
            billInfoEntity.setCurAccount(billInfoEntity.getPreAccount().add(actualMoney));
        }
        int updateFlag = this.doctorBillInfoEntityMapper.updateByPrimaryKeySelective(billInfoEntity);
        if (updateFlag <= 0) {
            return 0;
        }
        DoctorBillHxgyVo doctorBillHxgyVo = new DoctorBillHxgyVo();
        doctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
        doctorBillHxgyVo.setBillMoney(actualMoney);
        doctorBillHxgyVo.setBillType(Integer.valueOf(1));
        doctorBillHxgyVo.setOrderId(billInfoEntity.getBusinessId());
        doctorBillHxgyVo.setObjectId(billInfoEntity.getDoctorId().toString());
        doctorBillHxgyVo.setCreator(auditor);
        String businessType = this.getBusinessTypeName(Integer.valueOf(billInfoEntity.getBusinessType()));
        doctorBillHxgyVo.setServCode(businessType);
        doctorBillHxgyVo.setDeptName(doctorEntityInfoVO.getStdFirstDeptName());
        doctorBillHxgyVo.setDoctorName(doctorEntityInfoVO.getName());
        doctorBillHxgyVo.setOrderMoney(billInfoEntity.getActualMoney());
        doctorBillHxgyVo.setTransactionId(UuidUtils.generateUUID());
        String appCode = this.remoteManage.getAppCodeByHospitalId(doctorEntityInfoVO.getOrganId());
        doctorBillHxgyVo.setOrganCode(doctorEntityInfoVO.getOrganId().toString());
        doctorBillHxgyVo.setAppCode(appCode);
        QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
        queryOrganDetailDTO.setOrganId(doctorEntityInfoVO.getOrganId());
        BaseResponse queryOrganDetailVOBaseResponse = this.organizationApiClient.queryOrganDetail(queryOrganDetailDTO);
        QueryOrganDetailVO queryOrganDetailVO = (QueryOrganDetailVO)queryOrganDetailVOBaseResponse.getData();
        doctorBillHxgyVo.setHospitalName(queryOrganDetailVO.getOrganName());
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("cloud/bill/addBillDetail").toString();
        log.info("======addBillDetail\u8c03\u7528\u65f6\u7684url\u662f:" + url + "====\u4f20\u5165\u7684\u53c2\u6570\u662f:" + doctorBillHxgyVo.toString());
        BaseResponse baseResponse = (BaseResponse)this.restTemplate.postForObject(url, (Object)doctorBillHxgyVo, BaseResponse.class, new Object[0]);
        log.info("====addBillDetail\u8fd4\u56de\u7684baseResponse:" + baseResponse);
        BigDecimal bigDecimal = doctorEntityInfoVO.getBalance() == null ? BigDecimal.ZERO : doctorEntityInfoVO.getBalance();
        doctorEntityInfoVO.setBalance(bigDecimal.add(billInfoEntity.getActualMoney()));
        UpdateBalanceDTO updateBalanceDTO = new UpdateBalanceDTO();
        updateBalanceDTO.setBalance(bigDecimal.add(billInfoEntity.getActualMoney()));
        updateBalanceDTO.setDoctorId(Integer.valueOf(billInfoEntity.getDoctorId().intValue()));
        BaseResponse updateDoctorBalanceResponse = this.doctorApiClient.updateDoctorBalance(updateBalanceDTO);
        if (billInfoEntity.getActualMoney().compareTo(BigDecimal.ZERO) == 0) {
            return Integer.valueOf(updateDoctorBalanceResponse.getCode());
        }
        DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(doctorEntityInfoVO.getId());
        try {
            this.shortMessageManager.verifyDoctorBillInfo(billInfoEntity, doctorEntityInfoVO.getRegisterMobile(), doctorEntityInfoVO.getOrganId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.webAndAppMessageManager.verifyYoumengDoctorBillInfo(doctorInfoRespVO, billInfoEntity, Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
            log.info("================\u5165\u8d26app\u63a8\u9001\u5b8c\u6210=============");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.webAndAppMessageManager.verifyGoeasyDoctorBillInfo(doctorInfoRespVO, billInfoEntity, Long.valueOf(doctorEntityInfoVO.getOrganId().longValue()));
            log.info("================\u5165\u8d26web\u63a8\u9001\u5b8c\u6210=============");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Integer.valueOf(updateDoctorBalanceResponse.getCode());
    }

    private String getBusinessTypeName(Integer businessType) {
        String businessTypeStr = "";
        String businessTypeName = BillBusinessTypeEnum.getByValue((Integer)businessType).getDisplay();
        if ("\u533b\u9662\u56fe\u6587\u4f1a\u8bca\u63a5\u8bca".equals(businessTypeName) || "\u533b\u9662\u56fe\u6587\u4f1a\u8bca\u966a\u8bca".equals(businessTypeName)) {
            businessTypeStr = "ylttw";
        }
        if ("\u533b\u9662\u89c6\u9891\u4f1a\u8bca\u63a5\u8bca".equals(businessTypeName) || "\u533b\u9662\u89c6\u9891\u4f1a\u8bca\u966a\u8bca".equals(businessTypeName)) {
            businessTypeStr = "yltsp";
        }
        if ("\u4e2a\u4eba\u56fe\u6587\u4f1a\u8bca\u63a5\u8bca".equals(businessTypeName) || "\u4e2a\u4eba\u56fe\u6587\u4f1a\u8bca\u966a\u8bca".equals(businessTypeName)) {
            businessTypeStr = "zjtw";
        }
        if ("\u4e2a\u4eba\u89c6\u9891\u4f1a\u8bca\u63a5\u8bca".equals(businessTypeName) || "\u4e2a\u4eba\u89c6\u9891\u4f1a\u8bca\u966a\u8bca".equals(businessTypeName)) {
            businessTypeStr = "zjsp";
        }
        return businessTypeStr;
    }

    public BigDecimal getMoneySum(String viewId) {
        String hospitalIds = "";
        return this.doctorBillInfoEntityMapper.selectMoneySum(hospitalIds);
    }

    @Transactional
    public DoctorBillInfoEntity addTransfer(NewTransferVo newTransferVo) {
        String businessId = newTransferVo.getBusinessId().trim();
        DoctorBillInfoEntity billInfoEntity = this.doctorBillInfoEntityMapper.selectByBusinessId(businessId);
        if (billInfoEntity == null) {
            log.info("========\u5f85\u5212\u62e8\u7684\u4e1a\u52a1\u8ba2\u5355\u4e0d\u5b58\u5728============");
            return null;
        }
        this.doctorBillInfoEntityMapper.invalidBill(businessId, Integer.valueOf(-1), bill_invalid);
        DoctorBillVo doctorBillVo = new DoctorBillVo();
        doctorBillVo.setBillStatus(Integer.valueOf(1));
        doctorBillVo.setSubsidyMoney(BigDecimal.ZERO);
        doctorBillVo.setSource(billInfoEntity.getSource());
        doctorBillVo.setOriginalMoney(newTransferVo.getMoney());
        doctorBillVo.setDoctorId(newTransferVo.getDoctorId());
        doctorBillVo.setBusinessId(billInfoEntity.getBusinessId());
        doctorBillVo.setBusinessType(billInfoEntity.getBusinessType());
        doctorBillVo.setType(Integer.valueOf(billInfoEntity.getType()));
        doctorBillVo.setRemark(newTransferVo.getRemark());
        DoctorBillInfoEntity entity = this.addOne(doctorBillVo);
        DoctorEntityInfoVO doctorEntityInfoVO = this.getDoctorInfo(billInfoEntity.getDoctorId());
        BigDecimal balance = doctorEntityInfoVO.getBalance() == null ? BigDecimal.ZERO : doctorEntityInfoVO.getBalance();
        balance = newTransferVo.getMoney().add(balance);
        doctorEntityInfoVO.setBalance(balance);
        UpdateBalanceDTO updateBalanceDTO = new UpdateBalanceDTO();
        updateBalanceDTO.setBalance(balance);
        updateBalanceDTO.setDoctorId(Integer.valueOf(billInfoEntity.getDoctorId().intValue()));
        this.doctorApiClient.updateDoctorBalance(updateBalanceDTO);
        return entity;
    }

    public ExcelData BillExcel(String ids) {
        BillListQuery query = new BillListQuery();
        query.setPageNum(Integer.valueOf(1));
        query.setPageSize(Integer.valueOf(10));
        query.setSqlExtend(ids);
        List pageData = (List)this.getListByCondition(query).getPageData();
        ExcelData excelData = new ExcelData();
        excelData.setName("\u533b\u751f\u8d26\u5355\u8868");
        excelData.setRows(this.billToExcel(pageData));
        excelData.setTitles(this.billTitle());
        return excelData;
    }

    private List<String> billTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u7f16\u53f7");
        result.add("\u533b\u751f\u59d3\u540d");
        result.add("\u8bca\u7597\u8ba2\u5355\u7f16\u53f7");
        result.add("\u533b\u9662\u540d\u79f0");
        result.add("\u79d1\u5ba4");
        result.add("\u670d\u52a1\u7c7b\u578b");
        result.add("\u8054\u7cfb\u65b9\u5f0f");
        result.add("\u7c7b\u578b");
        result.add("\u64cd\u4f5c\u91d1\u989d");
        result.add("\u8ba2\u5355\u72b6\u6001");
        return result;
    }

    private List<List<Object>> billToExcel(List<BillListVo> listVos) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        for (BillListVo vo : listVos) {
            result.add(this.billRow(vo));
        }
        return result;
    }

    private List<Object> billRow(BillListVo vo) {
        ArrayList<Object> result = new ArrayList<Object>();
        DoctorBillInfoEntity entity = vo.getDoctorBillInfoEntity();
        result.add(entity.getId());
        result.add(vo.getDoctorName());
        result.add(entity.getBusinessId());
        result.add(vo.getHospitalName());
        result.add(vo.getStandardDept());
        try {
            result.add(BillBusinessTypeEnum.getByValue((Integer)entity.getBusinessType()).getDisplay());
        }
        catch (RuntimeException e) {
            result.add("");
        }
        result.add(vo.getTelephone());
        try {
            result.add(UserTypeEnum.getByValue((Integer)vo.getUserType()).getDisplay());
        }
        catch (RuntimeException e) {
            result.add("");
        }
        result.add(entity.getActualMoney());
        if (entity.getStatus() == 1) {
            result.add("\u5df2\u5212\u62e8");
        } else if (entity.getStatus() == -1) {
            result.add("\u5f85\u5904\u7406");
        }
        return result;
    }

    public List<BillDataInfoVO> billDataInfoVOS(String ids) {
        ArrayList<BillDataInfoVO> billDataInfoVOS = new ArrayList<BillDataInfoVO>();
        List<String> idList = new ArrayList<String>();
        if (ids.contains(",")) {
            idList = Arrays.asList(ids.trim().split(","));
        } else {
            idList.add(ids);
        }
        for (String s : idList) {
            DoctorBillInfoEntity doctorBillInfoEntity = this.getDoctorBillInfo(Long.valueOf(Long.parseLong(s)));
            BillDataInfoVO billDataInfoVO = new BillDataInfoVO();
            billDataInfoVO.setId(doctorBillInfoEntity.getId().toString());
            DoctorEntityInfoVO doctorEntityInfoVO = this.getDoctorInfo(doctorBillInfoEntity.getDoctorId());
            billDataInfoVO.setDocName(doctorEntityInfoVO.getName());
            billDataInfoVO.setBusinessId(doctorBillInfoEntity.getBusinessId());
            billDataInfoVO.setDocHosName(this.remoteManage.getHospitalDetailById(Long.valueOf(doctorEntityInfoVO.getOrganId().longValue())).getOrganName());
            billDataInfoVO.setDocDeptName(doctorEntityInfoVO.getHospitalDeptName());
            billDataInfoVO.setServerTypeDesc(StringUtil.isNotBlank((String)doctorBillInfoEntity.getSource()) ? doctorBillInfoEntity.getSource() : "");
            billDataInfoVO.setPatientPhone(doctorEntityInfoVO.getRegisterMobile());
            billDataInfoVO.setMoney(doctorBillInfoEntity.getActualMoney() != null ? doctorBillInfoEntity.getActualMoney().toString() : "");
            billDataInfoVO.setOrderStatusDesc(doctorBillInfoEntity.getStatus() == 1 ? "\u5df2\u5212\u62e8" : "\u5f85\u5904\u7406");
            String userTypeDesc = "";
            userTypeDesc = UserTypeEnum.PATIENT.getValue().equals(doctorBillInfoEntity.getSponsor()) ? "\u60a3\u8005" : (UserTypeEnum.SPECIALIST.getValue().equals(doctorBillInfoEntity.getSponsor()) ? "\u533b\u751f" : "\u5176\u4ed6");
            billDataInfoVO.setUserType(userTypeDesc);
            billDataInfoVOS.add(billDataInfoVO);
        }
        return billDataInfoVOS;
    }
}

