/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.healthalliace;

import com.byh.dao.healthalliance.HospitalHealthAllianceMemberMapper;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceMemberEntity;
import com.byh.service.healthalliace.HealthAllianceMemberService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HealthAllianceMemberServiceImpl
implements HealthAllianceMemberService {
    @Autowired
    private HospitalHealthAllianceMemberMapper hospitalHealthAllianceMemberMapper;

    public String getHealthAllianceByHospitalId(Long hospitalId) {
        String ids = "";
        List allianceUuidList = this.hospitalHealthAllianceMemberMapper.getMemberAllianceUuidByHosId(hospitalId);
        if (allianceUuidList == null || allianceUuidList.size() < 1) {
            return "0";
        }
        List hosIdList = this.hospitalHealthAllianceMemberMapper.getMemberHosIdByAllianceUuid(allianceUuidList);
        for (Integer hosId : hosIdList) {
            ids = ids + hosId.toString() + ",";
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
        }
        return ids;
    }

    public HospitalHealthAllianceMemberEntity getHealthAllianceMemberByHospitalId(Long hospitalId) {
        return this.hospitalHealthAllianceMemberMapper.getHealthAllianceMemberByHospitalId(hospitalId);
    }

    public int insertHealthAllianceMember(HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity) {
        return this.hospitalHealthAllianceMemberMapper.insert(hospitalHealthAllianceMemberEntity);
    }

    public HospitalHealthAllianceMemberEntity queryHospitalHealthAllianceMember(String allianceUuid, Long hospitalId, Integer status) {
        return this.hospitalHealthAllianceMemberMapper.queryHospitalHealthAllianceMember(allianceUuid, hospitalId, status);
    }

    public int updateHospitalHealthAllianceMemberByAllianceUuidAndHosId(String allianceUuid, Long hospitalId, Integer status, Integer isLast) {
        return this.hospitalHealthAllianceMemberMapper.updateHospitalHealthAllianceMemberByAllianceUuidAndHosId(allianceUuid, hospitalId, status, isLast);
    }

    public List<HospitalHealthAllianceMemberEntity> getHealthAllianceMemberByAllianceUuid(String viewId, Long hosId) {
        return this.hospitalHealthAllianceMemberMapper.getHealthAllianceMemberByAllianceUuid(viewId, hosId);
    }

    public List<HospitalHealthAllianceMemberEntity> getHealthAllianceMemberByAllianceUuid1(String viewId, Long hosId) {
        return this.hospitalHealthAllianceMemberMapper.getHealthAllianceMemberByAllianceUuid1(viewId, hosId);
    }

    public List<HospitalHealthAllianceMemberEntity> getListHealthAllianceMemberByHospitalId(Long hospitalId) {
        return this.hospitalHealthAllianceMemberMapper.getListHealthAllianceMemberByHospitalId(hospitalId);
    }

    public List<HospitalHealthAllianceMemberEntity> getListHealthAllianceMemberByHospitalIdAndAppCode(Long hospitalId, String appCode) {
        return this.hospitalHealthAllianceMemberMapper.getListHealthAllianceMemberByHospitalIdAndAppCode(hospitalId, appCode);
    }

    public int updateHospitalHealthAllianceMemberIsOnline(String allianceUuid, Integer status) {
        return this.hospitalHealthAllianceMemberMapper.updateHospitalHealthAllianceMemberIsOnline(allianceUuid, status);
    }

    public List<HospitalHealthAllianceMemberEntity> getByAllianceUuId(String uuid) {
        return this.hospitalHealthAllianceMemberMapper.getByAllianceUuId(uuid);
    }

    public HospitalHealthAllianceMemberEntity getByHospitalIdAndRole(String hospitalId, Integer role) {
        return this.hospitalHealthAllianceMemberMapper.getByHospitalIdAndRole(hospitalId, role);
    }

    public List<HospitalHealthAllianceMemberEntity> isExistYiChun(Long hosId, List<String> viewIdList) {
        return this.hospitalHealthAllianceMemberMapper.isExistYiChun(hosId, viewIdList);
    }

    public String getAllianceUuidByHosIdList(List<String> hosIdList) {
        return this.hospitalHealthAllianceMemberMapper.getAllianceUuidByHosIdList(hosIdList);
    }

    public String getHosIdByAllianceList(List<String> allianceList) {
        return this.hospitalHealthAllianceMemberMapper.getHosIdByAllianceList(allianceList);
    }

    public List<String> getHosIdListByAllianceAndStatus(String allianceUuid, List<Integer> statusList) {
        return this.hospitalHealthAllianceMemberMapper.getHosIdListByAllianceAndStatus(allianceUuid, statusList);
    }
}

