/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.superadmin;

import com.byh.dao.superadmin.SuperAdminMapper;
import com.byh.exception.LoginException;
import com.byh.pojo.entity.superadmin.SuperAdminUserEntity;
import com.byh.service.superadmin.SuperAdminService;
import com.byh.util.TokenUtils;
import com.byh.util.UuidUtils;
import io.jsonwebtoken.Claims;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class SuperAdminServiceImpl
implements SuperAdminService {
    private static final Logger log = LoggerFactory.getLogger(SuperAdminServiceImpl.class);
    public static final String LOGIN_TOKEN_SECRET = "super_admin";
    public static final String SUPER_ADMIN_LOGIN_TIME = "super_admin_login_time";
    public static final String SUPER_ADMIN_LOGIN = "super_admin_login";
    public static final int WEB_LOGIN_EXPIRED_TIME = 14400;
    @Autowired
    private SuperAdminMapper adminUserMapper;
    @Autowired
    private JedisCluster jedisCluster;

    public SuperAdminUserEntity login(String userName, String password) throws LoginException {
        this.validationLoginParam(userName, password);
        String md5Password = DigestUtils.md5Hex((String)password);
        SuperAdminUserEntity superAdminUserEntity = this.adminUserMapper.selectByLoginName(userName);
        if (superAdminUserEntity == null || !superAdminUserEntity.getPassword().equalsIgnoreCase(md5Password)) {
            throw new LoginException("\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (-1 == superAdminUserEntity.getStatus()) {
            throw new LoginException("\u60a8\u7684\u8d26\u6237\u5df2\u88ab\u7981\u7528");
        }
        String viewId = superAdminUserEntity.getViewId();
        String token = TokenUtils.createJWT((String)viewId, null, (String)"web_super_manager", (String)UuidUtils.generateUUID(), (String)LOGIN_TOKEN_SECRET, (long)-1L);
        this.jedisCluster.set(SUPER_ADMIN_LOGIN + viewId, token);
        this.jedisCluster.set(SUPER_ADMIN_LOGIN_TIME + viewId, String.valueOf(System.currentTimeMillis()));
        this.adminUserMapper.updateToken(superAdminUserEntity.getLoginName(), token);
        superAdminUserEntity.setToken(token);
        superAdminUserEntity.setPassword("");
        return superAdminUserEntity;
    }

    public SuperAdminUserEntity validateToken(String token) throws LoginException {
        if (token.indexOf("Bearer ") == -1) {
            throw new LoginException("\u8bf7\u6c42\u7684\u7b7e\u540d\u65e0\u6548");
        }
        Claims clientClaims = TokenUtils.parseJWT((String)token, (String)LOGIN_TOKEN_SECRET);
        String viewId = clientClaims.get((Object)"unique_name").toString();
        String clientUuid = clientClaims.get((Object)"uuid").toString();
        this.validateWebSuperManagerLoginExpiredTime(viewId);
        String serverToken = this.jedisCluster.get(SUPER_ADMIN_LOGIN + viewId);
        Claims serverClaims = TokenUtils.parseJWT((String)serverToken, (String)LOGIN_TOKEN_SECRET);
        String serverUuid = serverClaims.get((Object)"uuid").toString();
        if (!clientUuid.equalsIgnoreCase(serverUuid)) {
            throw new LoginException("\u8d26\u53f7\u5df2\u88ab\u4ed6\u4eba\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return null;
    }

    public void logout(String viewId) {
        this.jedisCluster.del(SUPER_ADMIN_LOGIN_TIME + viewId);
        this.jedisCluster.del(LOGIN_TOKEN_SECRET + viewId);
    }

    private void validateWebSuperManagerLoginExpiredTime(String viewId) throws LoginException {
        String lastOperateTime = this.jedisCluster.get(SUPER_ADMIN_LOGIN_TIME + viewId);
        if (lastOperateTime == null) {
            throw new LoginException("\u8d26\u53f7\u88ab\u4ed6\u4eba\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        Long requestTime = (System.currentTimeMillis() - Long.valueOf(lastOperateTime)) / 1000L;
        if (requestTime > 14400L) {
            this.logout(viewId);
            throw new LoginException("\u767b\u5f55\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        this.jedisCluster.set(SUPER_ADMIN_LOGIN_TIME + viewId, String.valueOf(System.currentTimeMillis()));
    }

    private void validationLoginParam(String userName, String password) throws LoginException {
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new LoginException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new LoginException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

