/*
 * Decompiled with CFR 0.152.
 */
package com.byh.task.consultation;

import com.byh.enums.OrderStatusEnum;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.service.cosultation.ConsultationService;
import com.byh.util.DateTimeUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@JobHandler(value="pushInfoBeforeAcceptOrder")
@Component
public class PushTask
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(PushTask.class);
    @Autowired
    private WebAndAppMessageManager pushInfoManager;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ShortMessageManager shortMessageManager;

    @Transactional(rollbackFor={Exception.class})
    public void pushInfoBeforeAcceptOrder() {
    }

    public ReturnT<String> execute(String s) throws Exception {
        String thisTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        log.info("=======\u63a5\u8bca\u524d\u4e00\u5c0f\u65f6\u63d0\u9192\u533b\u751f\u5f00\u59cb=====\u5f53\u524d\u65f6\u95f4\u662f:" + thisTime);
        String thisDate = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd");
        Date preDate = DateTimeUtil.addHour((Date)new Date(), (int)1);
        String startTime = DateTimeUtil.formatTime((Date)preDate, (String)"HH:mm:ss");
        String endTime = DateTimeUtil.formatTime((Date)DateTimeUtil.addMinute((Date)preDate, (int)5), (String)"HH:mm:ss");
        List list = this.consultationService.seletConsultationByDateAndTimeAndStatus(OrderStatusEnum.WAITING.getValue(), thisDate, startTime, endTime);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ConsultationEntity consultationEntity : list) {
                this.shortMessageManager.consultationStartToDoctor(consultationEntity.getViewId());
                this.shortMessageManager.consultationStartToExpert(consultationEntity.getViewId());
                this.pushInfoManager.pushAheadMessage(consultationEntity);
            }
        }
        log.info("======\u63a5\u8bca\u524d\u4e00\u5c0f\u65f6\u63d0\u9192\u533b\u751f\u5f00\u59cb\u7ed3\u675f=====");
        return ReturnT.SUCCESS;
    }
}

