/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.pojo.httppojo.PushSubscribeMessageReqVO;
import com.byh.pojo.httppojo.UcWxAuthReqVo;
import com.byh.pojo.httppojo.WxOpenIdResponse;
import com.byh.pojo.httppojo.WxUserResponse;
import com.byh.util.HttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProgramUtils {
    private static final Logger log = LoggerFactory.getLogger(ProgramUtils.class);
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;

    public String getWxOpenId(UcWxAuthReqVo ucWxAuthReqVo, String appCode) {
        String JsonString = JSONObject.toJSONString((Object)ucWxAuthReqVo);
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + appCode + "/usercenter/node/account/getWxAuth";
        try {
            String responseStr = HttpUtils.post((String)url, (String)JsonString);
            log.info("====\u8c03\u7528\u83b7\u53d6openId\u8fd4\u56de{}", (Object)responseStr);
            WxOpenIdResponse wxOpenIdResponse = (WxOpenIdResponse)JSON.parseObject((String)responseStr, WxOpenIdResponse.class);
            if (wxOpenIdResponse != null) {
                String openId = wxOpenIdResponse.getData().getWxOpenid();
                return openId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public void ProgramPush(PushSubscribeMessageReqVO pushSubscribeMessageReqVO, String appCode) {
        String JsonString = JSONObject.toJSONString((Object)pushSubscribeMessageReqVO);
        log.info("====\u8c03\u7528\u63a8\u9001\u53c2\u6570{}", (Object)JsonString);
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + "cloud/push/wechat_message//subscribe_push";
        try {
            String pushReturn = HttpUtils.post((String)url, (String)JsonString);
            log.info("====\u8c03\u7528\u63a8\u9001\u8fd4\u56de{}", (Object)pushReturn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getUserIdList(Long patientId, String appCode) {
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + appCode + "/usercenter/card/getuserlist";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientId", patientId.toString());
            String responseStr = HttpUtils.get((String)url, map);
            log.info("====\u8c03\u7528\u83b7\u53d6userId\u8fd4\u56de{}", (Object)responseStr);
            WxUserResponse wxUserResponse = (WxUserResponse)JSON.parseObject((String)responseStr, WxUserResponse.class);
            if (wxUserResponse != null) {
                return wxUserResponse.getData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }
}

